/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.data;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import jp.riken.brain.ni.samuraigraph.base.SGButton;
import jp.riken.brain.ni.samuraigraph.base.SGDataColumnInfo;
import jp.riken.brain.ni.samuraigraph.data.SGAttributeDialog;
import jp.riken.brain.ni.samuraigraph.data.SGDataColumnSelectionPanel;
import jp.riken.brain.ni.samuraigraph.data.SGDataUtility;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFDataColumnInfo;
import jp.riken.brain.ni.samuraigraph.data.SGVariable;
import ucar.nc2.Dimension;

public class SGNetCDFDataColumnSelectionPanel
extends SGDataColumnSelectionPanel
implements MouseListener {
    private static final long serialVersionUID = -8916914942493060714L;
    public static final String COLUMN_NAME_NAME = "Name";
    public static final String COLUMN_NAME_DIMENSION = "Dimension";
    public static final String COLUMN_NAME_BUTTON = "";
    public static final String[] COLUMN_NAME_ARRAY = new String[]{"No.", "Name", "Dimension", "Column Type", ""};
    private static final int[] PREFERRED_COLUMN_WIDTH_ARRAY = new int[]{10, 80, 80, 140, 20};
    private static final String[] DATA_TYPE_ARRAY = new String[]{"SXY_NETCDF", "SXYZ_NETCDF", "SXY_MULTIPLE_NETCDF", "SXY_MULTIPLE_NETCDF_PICKUP", "VXY_NETCDF"};
    private Window mDialogOwner = null;
    private Map<String, SGAttributeDialog> mAttributeDialogMap = new HashMap<String, SGAttributeDialog>();

    public SGNetCDFDataColumnSelectionPanel() {
        this.mTable.addMouseListener(this);
    }

    protected String[] getColumnNameArray() {
        return COLUMN_NAME_ARRAY;
    }

    protected int[] getPreferredColumnWidthArray() {
        return PREFERRED_COLUMN_WIDTH_ARRAY;
    }

    protected String[] getDataTypeArray() {
        return DATA_TYPE_ARRAY;
    }

    protected SGDataColumnSelectionPanel.DataColumnTableModel createTableModel() {
        return new NetCDFDataColumnTableModel();
    }

    protected void initTableModel() {
        super.initTableModel();
        int n = this.getColumnIndex(COLUMN_NAME_BUTTON);
        TableColumn tableColumn = this.mTable.getColumnModel().getColumn(n);
        ButtonColumn buttonColumn = new ButtonColumn();
        tableColumn.setMinWidth(20);
        tableColumn.setMaxWidth(20);
        tableColumn.setResizable(false);
        tableColumn.setCellEditor(buttonColumn);
        tableColumn.setCellRenderer(buttonColumn);
    }

    public void setPopupDialogOwner(Window window) {
        this.mDialogOwner = window;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object.equals(this.mTable)) {
            Point point = mouseEvent.getPoint();
            int n = this.mTable.columnAtPoint(point);
            int n2 = this.mTable.rowAtPoint(point);
            if (n2 >= 0 && n == this.getColumnIndex(COLUMN_NAME_BUTTON)) {
                Object object2 = this.mTable.getValueAt(n2, n);
                SGVariable sGVariable = (SGVariable)object2;
                String string = sGVariable.getName();
                SGAttributeDialog sGAttributeDialog = this.mAttributeDialogMap.get(string);
                if (sGAttributeDialog != null && sGAttributeDialog.isVisible()) {
                    return;
                }
                SGAttributeDialog sGAttributeDialog2 = null;
                if (this.mDialogOwner instanceof Dialog) {
                    sGAttributeDialog2 = new SGAttributeDialog((Dialog)this.mDialogOwner, false);
                } else if (this.mDialogOwner instanceof Frame) {
                    sGAttributeDialog2 = new SGAttributeDialog((Frame)this.mDialogOwner, false);
                } else {
                    throw new Error("Not supported dialog owner.");
                }
                this.mAttributeDialogMap.put(string, sGAttributeDialog2);
                sGAttributeDialog2.setVariable(sGVariable);
                sGAttributeDialog2.setLocation(mouseEvent.getXOnScreen() + 20, mouseEvent.getYOnScreen() + 20);
                sGAttributeDialog2.setVisible(true);
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public boolean checkSelectedItems() {
        List<SGDataColumnInfo> list = this.getColumnInfoList();
        int n = this.getColumnInfoList().size();
        int n2 = this.getColumnIndex(COLUMN_NAME_NAME);
        int n3 = this.getColumnIndex("Column Type");
        SGDataColumnInfo[] sGDataColumnInfoArray = new SGNetCDFDataColumnInfo[n];
        for (int i = 0; i < n; ++i) {
            String string = (String)this.mTable.getValueAt(i, n2);
            if (string == null) {
                string = COLUMN_NAME_BUTTON;
            }
            SGVariable sGVariable = ((SGNetCDFDataColumnInfo)list.get(i)).getVariable();
            sGDataColumnInfoArray[i] = new SGNetCDFDataColumnInfo(sGVariable, string, sGVariable.getValueType());
            String string2 = (String)this.mTable.getValueAt(i, n3);
            if (string2 == null) {
                string2 = COLUMN_NAME_BUTTON;
            }
            sGDataColumnInfoArray[i].setColumnType(string2);
        }
        return SGDataUtility.checkDataColumns(this.mDataType, sGDataColumnInfoArray, this.mDataInfoMap);
    }

    protected JTable createTableInstance() {
        return new JTable(){
            private static final long serialVersionUID = -7054748048254127674L;

            public String getToolTipText(MouseEvent mouseEvent) {
                int n = this.rowAtPoint(mouseEvent.getPoint());
                int n2 = this.columnAtPoint(mouseEvent.getPoint());
                if (n2 == 4) {
                    return null;
                }
                Object object = this.getModel().getValueAt(n, n2);
                if (object != null && !SGNetCDFDataColumnSelectionPanel.COLUMN_NAME_BUTTON.equals(object.toString())) {
                    return object.toString();
                }
                return null;
            }
        };
    }

    private static class ButtonColumn
    extends AbstractCellEditor
    implements TableCellRenderer,
    TableCellEditor {
        private static final long serialVersionUID = 1089174278086303154L;
        private static final String BUTTON_TEXT = " ";
        private final JButton renderButton = new SGButton(" ");
        private final JButton editorButton = new SGButton(" ");

        public ButtonColumn() {
            this.editorButton.setFocusPainted(false);
            this.editorButton.setRolloverEnabled(false);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return this.renderButton;
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            return this.editorButton;
        }

        public Object getCellEditorValue() {
            return BUTTON_TEXT;
        }
    }

    protected class NetCDFDataColumnTableModel
    extends SGDataColumnSelectionPanel.DataColumnTableModel {
        private static final long serialVersionUID = 5724156778412127794L;

        protected void addData(int n, SGDataColumnInfo sGDataColumnInfo) {
            SGNetCDFDataColumnInfo sGNetCDFDataColumnInfo = (SGNetCDFDataColumnInfo)sGDataColumnInfo;
            String string = sGNetCDFDataColumnInfo.getColumnType();
            if (string == null) {
                string = SGNetCDFDataColumnSelectionPanel.COLUMN_NAME_BUTTON;
            }
            SGVariable sGVariable = sGNetCDFDataColumnInfo.getVariable();
            List<Dimension> list = sGVariable.getDimensions();
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = list.size();
            for (int i = 0; i < n2; ++i) {
                Dimension dimension = list.get(i);
                stringBuffer.append(dimension.getName());
                if (i == n2 - 1) continue;
                stringBuffer.append(", ");
            }
            Object[] objectArray = new Object[]{Integer.toString(n + 1), sGDataColumnInfo.getTitle(), stringBuffer.toString(), string, sGVariable};
            super.addRow(objectArray);
        }
    }
}

