/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.data;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.riken.brain.ni.samuraigraph.base.SGButton;
import jp.riken.brain.ni.samuraigraph.base.SGDataColumnInfo;
import jp.riken.brain.ni.samuraigraph.base.SGDataColumnInfoSet;
import jp.riken.brain.ni.samuraigraph.base.SGTextField;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.data.SGDataDuplicationDialog;
import jp.riken.brain.ni.samuraigraph.data.SGIDataSetupTableHolder;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFData;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFDataSetupPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGNetCDFDataDuplicationDialog
extends SGDataDuplicationDialog {
    private static final long serialVersionUID = -7649280544732580706L;
    public static final String TITLE = "Setup for Duplication";
    private JPanel mButtonPanel;
    private SGButton mCancelButton;
    private JLabel mDataNameLabel;
    private JPanel mDataNamePanel;
    private SGTextField mDataNameTextField;
    private SGNetCDFDataSetupPanel mNetCDFDataSetupPanel;
    private SGButton mOKButton;

    public SGNetCDFDataDuplicationDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
    }

    private void initComponents() {
        this.mDataNamePanel = new JPanel();
        this.mDataNameLabel = new JLabel();
        this.mDataNameTextField = new SGTextField();
        this.mNetCDFDataSetupPanel = new SGNetCDFDataSetupPanel();
        this.mButtonPanel = new JPanel();
        this.mOKButton = new SGButton();
        this.mCancelButton = new SGButton();
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.mDataNamePanel.setLayout(new GridBagLayout());
        this.mDataNameLabel.setFont(new Font("Dialog", 1, 12));
        this.mDataNameLabel.setText("Data Name");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.mDataNamePanel.add((Component)this.mDataNameLabel, gridBagConstraints);
        this.mDataNameTextField.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.mDataNamePanel.add((Component)this.mDataNameTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.mDataNamePanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.getContentPane().add((Component)this.mNetCDFDataSetupPanel, gridBagConstraints);
        this.mOKButton.setText("OK");
        this.mOKButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setText("Cancel");
        this.mCancelButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mCancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        this.pack();
    }

    private void initProperty() {
        this.setTitle(TITLE);
        this.getOKButton().addActionListener(this);
        this.getCancelButton().addActionListener(this);
        this.mNetCDFDataSetupPanel.getClearButton().addActionListener(this);
        this.mNetCDFDataSetupPanel.getRestoreButton().addActionListener(this);
        this.mNetCDFDataSetupPanel.getComplementButton().addActionListener(this);
        this.mNetCDFDataSetupPanel.getTable().addPropertyChangeListener(this);
        this.mNetCDFDataSetupPanel.setPopupDialogOwner(this);
    }

    @Override
    protected JButton getOKButton() {
        return this.mOKButton;
    }

    @Override
    protected JButton getCancelButton() {
        return this.mCancelButton;
    }

    @Override
    protected SGIDataSetupTableHolder getTableHolder() {
        return this.mNetCDFDataSetupPanel;
    }

    @Override
    public JTextField getDataNameTextField() {
        return this.mDataNameTextField;
    }

    public boolean setData(String string, SGNetCDFData sGNetCDFData, SGDataColumnInfoSet sGDataColumnInfoSet, Map<String, Object> map) {
        this.mDataNameTextField.setText(string);
        return this.mNetCDFDataSetupPanel.setData(sGNetCDFData, sGDataColumnInfoSet, map, false);
    }

    @Override
    public SGDataColumnInfo[] getDataColumnTypes() {
        return this.mNetCDFDataSetupPanel.getDataColumnTypes();
    }

    @Override
    protected boolean onOK() {
        boolean bl = true;
        String string = this.getDataName();
        if (!SGUtilityText.isValidString(string)) {
            bl = false;
        }
        if (!bl) {
            SGUtility.showMessageDialog(this, "Input value is invalid.", "Error", 0);
            return false;
        }
        return super.onOK();
    }
}

