/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.data;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import jp.riken.brain.ni.samuraigraph.base.SGButton;
import jp.riken.brain.ni.samuraigraph.base.SGDataColumnInfo;
import jp.riken.brain.ni.samuraigraph.base.SGDataColumnInfoSet;
import jp.riken.brain.ni.samuraigraph.base.SGTextField;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.data.SGCoordinateVariable;
import jp.riken.brain.ni.samuraigraph.data.SGCoordinateVariablePanel;
import jp.riken.brain.ni.samuraigraph.data.SGDataUtility;
import jp.riken.brain.ni.samuraigraph.data.SGGlobalAttributeDialog;
import jp.riken.brain.ni.samuraigraph.data.SGIDataColumnTypeConstants;
import jp.riken.brain.ni.samuraigraph.data.SGIDataSetupTableHolder;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFData;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFDataColumnInfo;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFDataColumnSelectionPanel;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFFile;
import jp.riken.brain.ni.samuraigraph.data.SGVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGNetCDFDataSetupPanel
extends JPanel
implements SGIDataColumnTypeConstants,
PropertyChangeListener,
ActionListener,
SGIDataSetupTableHolder {
    private static final long serialVersionUID = -7931773969660601629L;
    private JPanel mCoordinateVariablePanel;
    private JScrollPane mCoordinateVariableScrollPane;
    private SGNetCDFDataColumnSelectionPanel mDataColumnSelectionPanel;
    private SGCoordinateVariablePanel mDummyPanel;
    private SGButton mGlobalAttributeButton;
    private JPanel mMultiDimensionSubPanel;
    private SGTextField mMultipleDimensionEndField;
    private JLabel mMultipleDimensionEndLabel;
    private JPanel mMultipleDimensionPanel;
    private SGTextField mMultipleDimensionStartField;
    private JLabel mMultipleDimensionStartLabel;
    private SGTextField mMultipleDimensionStepField;
    private JLabel mMultipleDimensionStepLabel;
    private static final int SCROLL_BAR_UNIT_INCREMENT = 20;
    private static final int SCROLL_BAR_BLOCK_INCREMENT = 80;
    private SGNetCDFFile mNetCDFFile = null;
    private String mDataType = null;
    private Map<String, Object> mInfoMap = null;
    private SGNetCDFDataColumnInfo[] mNetCDFColumns;
    private final TemporaryColumnInfo mTemporaryColumnInfo = new TemporaryColumnInfo();
    private SGGlobalAttributeDialog mGlobalAttributeDialog = null;
    private Window mDialogOwner = null;

    public SGNetCDFDataSetupPanel() {
        this.initComponents();
        this.initProperty();
    }

    private void initComponents() {
        this.mCoordinateVariableScrollPane = new JScrollPane();
        this.mCoordinateVariablePanel = new JPanel();
        this.mDummyPanel = new SGCoordinateVariablePanel();
        this.mDataColumnSelectionPanel = new SGNetCDFDataColumnSelectionPanel();
        this.mGlobalAttributeButton = new SGButton();
        this.mMultipleDimensionPanel = new JPanel();
        this.mMultiDimensionSubPanel = new JPanel();
        this.mMultipleDimensionStartLabel = new JLabel();
        this.mMultipleDimensionEndLabel = new JLabel();
        this.mMultipleDimensionStepLabel = new JLabel();
        this.mMultipleDimensionStartField = new SGTextField();
        this.mMultipleDimensionEndField = new SGTextField();
        this.mMultipleDimensionStepField = new SGTextField();
        this.setLayout(new GridBagLayout());
        this.mCoordinateVariableScrollPane.setBorder(BorderFactory.createTitledBorder(null, "Coordinate Variables", 0, 0, new Font("Dialog", 1, 12)));
        this.mCoordinateVariableScrollPane.setHorizontalScrollBarPolicy(31);
        this.mCoordinateVariableScrollPane.setHorizontalScrollBar(null);
        this.mCoordinateVariableScrollPane.setPreferredSize(new Dimension(434, 128));
        this.mCoordinateVariablePanel.setLayout(new BoxLayout(this.mCoordinateVariablePanel, 1));
        this.mCoordinateVariablePanel.add(this.mDummyPanel);
        this.mCoordinateVariableScrollPane.setViewportView(this.mCoordinateVariablePanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.mCoordinateVariableScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.mDataColumnSelectionPanel, gridBagConstraints);
        this.mGlobalAttributeButton.setText("Show Global Attributes");
        this.mGlobalAttributeButton.setFont(new Font("Dialog", 1, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 8, 4, 4);
        this.add((Component)this.mGlobalAttributeButton, gridBagConstraints);
        this.mMultipleDimensionPanel.setBorder(BorderFactory.createTitledBorder(null, "Index Selection for Pickup Data", 0, 0, new Font("Dialog", 1, 12)));
        this.mMultipleDimensionPanel.setLayout(new GridBagLayout());
        this.mMultiDimensionSubPanel.setLayout(new GridBagLayout());
        this.mMultipleDimensionStartLabel.setFont(new Font("Dialog", 0, 12));
        this.mMultipleDimensionStartLabel.setText("Start");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 10, 4, 4);
        this.mMultiDimensionSubPanel.add((Component)this.mMultipleDimensionStartLabel, gridBagConstraints);
        this.mMultipleDimensionEndLabel.setFont(new Font("Dialog", 0, 12));
        this.mMultipleDimensionEndLabel.setText("End");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.mMultiDimensionSubPanel.add((Component)this.mMultipleDimensionEndLabel, gridBagConstraints);
        this.mMultipleDimensionStepLabel.setFont(new Font("Dialog", 0, 12));
        this.mMultipleDimensionStepLabel.setText("Step");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.mMultiDimensionSubPanel.add((Component)this.mMultipleDimensionStepLabel, gridBagConstraints);
        this.mMultipleDimensionStartField.setColumns(3);
        this.mMultipleDimensionStartField.setFont(new Font("Dialog", 0, 12));
        this.mMultipleDimensionStartField.setMinimumSize(new Dimension(39, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.mMultiDimensionSubPanel.add((Component)this.mMultipleDimensionStartField, gridBagConstraints);
        this.mMultipleDimensionEndField.setFont(new Font("Dialog", 0, 12));
        this.mMultipleDimensionEndField.setMinimumSize(new Dimension(39, 22));
        this.mMultipleDimensionEndField.setPreferredSize(new Dimension(39, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.mMultiDimensionSubPanel.add((Component)this.mMultipleDimensionEndField, gridBagConstraints);
        this.mMultipleDimensionStepField.setColumns(3);
        this.mMultipleDimensionStepField.setFont(new Font("Dialog", 0, 12));
        this.mMultipleDimensionStepField.setMinimumSize(new Dimension(39, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.mMultiDimensionSubPanel.add((Component)this.mMultipleDimensionStepField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.mMultipleDimensionPanel.add((Component)this.mMultiDimensionSubPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.mMultipleDimensionPanel, gridBagConstraints);
    }

    private void initProperty() {
        JScrollBar jScrollBar = this.mCoordinateVariableScrollPane.getVerticalScrollBar();
        jScrollBar.setUnitIncrement(20);
        jScrollBar.setBlockIncrement(80);
        this.getClearButton().addActionListener(this);
        this.getRestoreButton().addActionListener(this);
        this.getComplementButton().addActionListener(this);
        this.mGlobalAttributeButton.addActionListener(this);
        this.getTable().addPropertyChangeListener(this);
        this.setMultipleDimensionPanelEnabled(false);
    }

    public boolean setData(SGNetCDFFile sGNetCDFFile, String string, SGDataColumnInfoSet sGDataColumnInfoSet, Map<String, Object> map, boolean bl) {
        if (sGNetCDFFile == null || string == null || sGDataColumnInfoSet == null || map == null) {
            throw new IllegalArgumentException("ncFile == null || dataType == null || colInfoSet == null || infoMap == null");
        }
        this.mTemporaryColumnInfo.clearColumnInfo();
        SGDataColumnInfo[] sGDataColumnInfoArray = sGDataColumnInfoSet.getDataColumnInfoArray();
        this.mNetCDFColumns = new SGNetCDFDataColumnInfo[sGDataColumnInfoArray.length];
        for (int i = 0; i < sGDataColumnInfoArray.length; ++i) {
            this.mNetCDFColumns[i] = (SGNetCDFDataColumnInfo)sGDataColumnInfoArray[i];
        }
        map.put("Data Source", sGNetCDFFile);
        this.clear();
        this.mNetCDFFile = sGNetCDFFile;
        this.mDataType = string;
        this.mInfoMap = map;
        this.mInfoMap.put("DataType", string);
        List<SGVariable> list = sGNetCDFFile.getVariables();
        if (!this.mDataColumnSelectionPanel.setData(string, sGDataColumnInfoSet, map, bl)) {
            return false;
        }
        if (SGDataUtility.isSXYTypeData(string)) {
            this.setMultipleDimensionPanelEnabled(false);
            this.mMultipleDimensionPanel.setVisible(true);
        } else {
            this.mMultipleDimensionPanel.setVisible(false);
        }
        for (SGVariable sGVariable : list) {
            int n;
            int n2;
            SGCoordinateVariable sGCoordinateVariable;
            if (!sGVariable.isCoordinateVariable()) continue;
            String string2 = sGVariable.getName();
            double[] dArray = null;
            if (sGVariable instanceof SGCoordinateVariable) {
                sGCoordinateVariable = (SGCoordinateVariable)sGVariable;
                n2 = sGCoordinateVariable.getLength();
                if (n2 == 0) {
                    return false;
                }
                dArray = new double[n2];
                for (n = 0; n < n2; ++n) {
                    dArray[n] = n;
                }
            } else {
                try {
                    sGCoordinateVariable = sGVariable.getVariable().read();
                }
                catch (IOException iOException) {
                    return false;
                }
                n2 = (int)sGCoordinateVariable.getSize();
                if (n2 == 0) {
                    return false;
                }
                dArray = new double[n2];
                for (n = 0; n < n2; ++n) {
                    dArray[n] = sGCoordinateVariable.getDouble(n);
                }
            }
            int n3 = 0;
            for (n2 = 0; n2 < this.mNetCDFColumns.length; ++n2) {
                if (!string2.equals(this.mNetCDFColumns[n2].getVariable().getName())) continue;
                n3 = this.mNetCDFColumns[n2].getOrigin();
            }
            String string3 = sGVariable.getUnitsString();
            SGCoordinateVariablePanel sGCoordinateVariablePanel = new SGCoordinateVariablePanel(sGVariable, dArray, n3, string3);
            this.mCoordinateVariablePanel.add(sGCoordinateVariablePanel);
        }
        this.updateComponentsEnabled();
        return true;
    }

    private void setMultipleDimensionPanelEnabled(boolean bl) {
        this.mMultipleDimensionPanel.setEnabled(bl);
        this.mMultipleDimensionStartLabel.setEnabled(bl);
        this.mMultipleDimensionStartField.setEnabled(bl);
        this.mMultipleDimensionEndLabel.setEnabled(bl);
        this.mMultipleDimensionEndField.setEnabled(bl);
        this.mMultipleDimensionStepLabel.setEnabled(bl);
        this.mMultipleDimensionStepField.setEnabled(bl);
    }

    public boolean setDataToMultipleDimensionPanel(Map<String, Object> map, SGNetCDFDataColumnInfo[] sGNetCDFDataColumnInfoArray, boolean bl) {
        if (bl) {
            return SGDataUtility.updatePickupParameters(map, sGNetCDFDataColumnInfoArray);
        }
        return true;
    }

    public boolean setData(SGNetCDFData sGNetCDFData, SGDataColumnInfoSet sGDataColumnInfoSet, Map<String, Object> map, boolean bl) {
        return this.setData(sGNetCDFData.getNetcdfFile(), sGNetCDFData.getDataType(), sGDataColumnInfoSet, map, bl);
    }

    public SGDataColumnInfo[] getDataColumnTypes() {
        SGDataColumnInfo[] sGDataColumnInfoArray = this.mDataColumnSelectionPanel.getDataColumnTypes();
        SGDataColumnInfo[] sGDataColumnInfoArray2 = new SGNetCDFDataColumnInfo[sGDataColumnInfoArray.length];
        for (int i = 0; i < sGDataColumnInfoArray.length; ++i) {
            SGNetCDFDataColumnInfo sGNetCDFDataColumnInfo = (SGNetCDFDataColumnInfo)sGDataColumnInfoArray[i];
            String string = sGNetCDFDataColumnInfo.getVariable().getName();
            SGVariable sGVariable = this.mNetCDFFile.findVariable(string);
            int n = this.getCoordinateVariableIndex(string);
            String string2 = sGDataColumnInfoArray[i].getColumnType();
            String string3 = sGNetCDFDataColumnInfo.getValueType();
            sGDataColumnInfoArray2[i] = new SGNetCDFDataColumnInfo(sGVariable, sGVariable.getNameInPriorityOrder(), string3, n);
            sGDataColumnInfoArray2[i].setColumnType(string2);
        }
        return sGDataColumnInfoArray2;
    }

    @Override
    public SGDataColumnInfoSet getDataColumnInfoSet() {
        SGDataColumnInfoSet sGDataColumnInfoSet = new SGDataColumnInfoSet(this.getDataColumnTypes());
        return sGDataColumnInfoSet;
    }

    public double getCoordinateVariableValue(String string) {
        SGVariable sGVariable = this.mNetCDFFile.findVariable(string);
        if (sGVariable == null) {
            return -1.0;
        }
        if (!sGVariable.isCoordinateVariable()) {
            return -1.0;
        }
        SGCoordinateVariablePanel sGCoordinateVariablePanel = this.getCoordinateVariablePanel(string);
        return sGCoordinateVariablePanel.getCurrentValue();
    }

    public int getCoordinateVariableIndex(String string) {
        SGVariable sGVariable = this.mNetCDFFile.findVariable(string);
        if (sGVariable == null) {
            return -1;
        }
        if (!sGVariable.isCoordinateVariable()) {
            return -1;
        }
        SGCoordinateVariablePanel sGCoordinateVariablePanel = this.getCoordinateVariablePanel(string);
        return sGCoordinateVariablePanel.getCurrentIndex();
    }

    private void updateComponentsEnabled() {
        boolean bl;
        String[] stringArray;
        Object object;
        Object object2;
        SGDataColumnInfo[] sGDataColumnInfoArray = this.mDataColumnSelectionPanel.getDataColumnTypes();
        boolean bl2 = true;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < sGDataColumnInfoArray.length; ++i) {
            object2 = (SGNetCDFDataColumnInfo)sGDataColumnInfoArray[i];
            object = ((SGDataColumnInfo)object2).getColumnType();
            this.mNetCDFColumns[i].setColumnType((String)object);
            if (!"".equals(object) && !"Time".equals(object)) {
                arrayList.add(((SGNetCDFDataColumnInfo)object2).getVariableName());
            }
            if (!"Pickup".equals(object)) continue;
            bl2 = false;
        }
        this.updateColumnTypeForPickup(bl2, sGDataColumnInfoArray);
        if (bl2) {
            this.setMultipleDimensionPanelEnabled(false);
            this.mInfoMap.put("Graphs for multiple variables", Boolean.TRUE);
        } else {
            this.setMultipleDimensionPanelEnabled(true);
            this.mInfoMap.put("Graphs for multiple variables", Boolean.FALSE);
            this.setDataToMultipleDimensionPanel(this.mInfoMap, this.mNetCDFColumns, true);
            Object object3 = this.mInfoMap.get("Multiple dimension start");
            this.mMultipleDimensionStartField.setText(object3.toString());
            object2 = this.mInfoMap.get("Multiple dimension end");
            this.mMultipleDimensionEndField.setText(object2.toString());
            object = this.mInfoMap.get("Multiple dimension step");
            this.mMultipleDimensionStepField.setText(object.toString());
        }
        Component[] componentArray = this.mCoordinateVariablePanel.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            object = (SGCoordinateVariablePanel)componentArray[i];
            stringArray = ((SGCoordinateVariablePanel)object).getVariableName();
            bl = !arrayList.contains(stringArray);
            ((SGCoordinateVariablePanel)object).setComponentsEnabled(bl);
        }
        this.mGlobalAttributeButton.setEnabled(true);
        SGDataColumnInfoSet sGDataColumnInfoSet = this.getDataColumnInfoSet();
        object = sGDataColumnInfoSet.getDataColumnInfoArray();
        stringArray = new String[((SGDataColumnInfo[])object).length];
        for (bl = false; bl < stringArray.length; bl += 1) {
            stringArray[bl] = object[bl].getColumnType();
        }
        bl = SGDataUtility.isComplementedButtonEnabled(this.mInfoMap, stringArray, this.mDataColumnSelectionPanel.getColumnInfoList());
        this.getComplementButton().setEnabled(bl);
    }

    private void updateColumnTypeForPickup(boolean bl, SGDataColumnInfo[] sGDataColumnInfoArray) {
        if (this.mTemporaryColumnInfo.multipleVariable != bl) {
            int n = this.mDataColumnSelectionPanel.getColumnIndex("Column Type");
            if (bl) {
                for (int i = 0; i < sGDataColumnInfoArray.length; ++i) {
                    String string;
                    String string2 = sGDataColumnInfoArray[i].getColumnType();
                    String string3 = "";
                    if (string2.equals("Lower Error")) {
                        string3 = "Lower Error";
                    } else if (string2.equals("Upper Error")) {
                        string3 = "Upper Error";
                    } else if (string2.equals("Lower / Upper Error")) {
                        string3 = "Lower / Upper Error";
                    } else if (string2.equals("Tick Label")) {
                        string3 = "Tick Label";
                    }
                    if (string3.equals("")) continue;
                    if (this.mTemporaryColumnInfo.colInfoVariable.length > i && (string = this.mTemporaryColumnInfo.colInfoVariable[i].getColumnType()).startsWith(string3)) {
                        this.mDataColumnSelectionPanel.mTable.setValueAt(string, i, n);
                        continue;
                    }
                    this.mDataColumnSelectionPanel.mTable.setValueAt("", i, n);
                }
            } else {
                for (int i = 0; i < sGDataColumnInfoArray.length; ++i) {
                    String string = sGDataColumnInfoArray[i].getColumnType();
                    if (string.startsWith("Lower Error")) {
                        this.mDataColumnSelectionPanel.mTable.setValueAt("Lower Error", i, n);
                        continue;
                    }
                    if (string.startsWith("Upper Error")) {
                        this.mDataColumnSelectionPanel.mTable.setValueAt("Upper Error", i, n);
                        continue;
                    }
                    if (string.startsWith("Lower / Upper Error")) {
                        this.mDataColumnSelectionPanel.mTable.setValueAt("Lower / Upper Error", i, n);
                        continue;
                    }
                    if (!string.startsWith("Tick Label")) continue;
                    this.mDataColumnSelectionPanel.mTable.setValueAt("Tick Label", i, n);
                }
            }
        }
        this.mTemporaryColumnInfo.setColumnInfo(bl, sGDataColumnInfoArray);
    }

    private SGCoordinateVariablePanel getCoordinateVariablePanel(String string) {
        Component[] componentArray = this.mCoordinateVariablePanel.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            SGCoordinateVariablePanel sGCoordinateVariablePanel = (SGCoordinateVariablePanel)componentArray[i];
            String string2 = sGCoordinateVariablePanel.getVariableName();
            if (!string.equals(string2)) continue;
            return sGCoordinateVariablePanel;
        }
        return null;
    }

    @Override
    public SGButton getRestoreButton() {
        return this.mDataColumnSelectionPanel.getRestoreButton();
    }

    @Override
    public SGButton getClearButton() {
        return this.mDataColumnSelectionPanel.getClearButton();
    }

    @Override
    public SGButton getComplementButton() {
        return this.mDataColumnSelectionPanel.getComplementButton();
    }

    @Override
    public JTable getTable() {
        return this.mDataColumnSelectionPanel.getTable();
    }

    @Override
    public boolean checkSelectedItems() {
        if (!this.mDataColumnSelectionPanel.checkSelectedItems()) {
            return false;
        }
        SGDataColumnInfo[] sGDataColumnInfoArray = this.mDataColumnSelectionPanel.getDataColumnTypes();
        SGNetCDFDataColumnInfo[] sGNetCDFDataColumnInfoArray = new SGNetCDFDataColumnInfo[sGDataColumnInfoArray.length];
        for (int i = 0; i < sGDataColumnInfoArray.length; ++i) {
            sGNetCDFDataColumnInfoArray[i] = (SGNetCDFDataColumnInfo)sGDataColumnInfoArray[i];
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(this.mInfoMap);
        hashMap.put("Multiple dimension start", this.getMultipleDimensionStart());
        hashMap.put("Multiple dimension end", this.getMultipleDimensionEnd());
        hashMap.put("Multiple dimension step", this.getMultipleDimensionStep());
        return SGDataUtility.checkNetCDFDataColumns(sGNetCDFDataColumnInfoArray, this.mDataType, this.mNetCDFFile, hashMap);
    }

    @Override
    public void updateTable() {
        this.mDataColumnSelectionPanel.updateTable();
    }

    @Override
    public void clear() {
        this.mCoordinateVariablePanel.removeAll();
        this.mDataColumnSelectionPanel.clear();
        this.mGlobalAttributeButton.setEnabled(false);
        if (this.mGlobalAttributeDialog != null) {
            this.mGlobalAttributeDialog.setVisible(false);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        Object object = propertyChangeEvent.getSource();
        if (object.equals(this.getTable()) && "tableCellEditor".equals(string = propertyChangeEvent.getPropertyName())) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SGNetCDFDataSetupPanel.this.updateComponentsEnabled();
                }
            });
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.getClearButton()) || object.equals(this.getRestoreButton()) || object.equals(this.getComplementButton())) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SGNetCDFDataSetupPanel.this.updateComponentsEnabled();
                }
            });
        } else if (object.equals(this.mGlobalAttributeButton)) {
            if (this.mGlobalAttributeDialog != null && this.mGlobalAttributeDialog.isVisible()) {
                return;
            }
            SGGlobalAttributeDialog sGGlobalAttributeDialog = null;
            if (this.mDialogOwner instanceof Dialog) {
                sGGlobalAttributeDialog = new SGGlobalAttributeDialog((Dialog)this.mDialogOwner, false);
            } else if (this.mDialogOwner instanceof Frame) {
                sGGlobalAttributeDialog = new SGGlobalAttributeDialog((Frame)this.mDialogOwner, false);
            } else {
                throw new Error("Not supported dialog owner.");
            }
            this.mGlobalAttributeDialog = sGGlobalAttributeDialog;
            sGGlobalAttributeDialog.setNetcdfFile(this.mNetCDFFile);
            Point point = this.mDialogOwner.getLocation();
            sGGlobalAttributeDialog.setLocation(point.x + 20, point.y + 20);
            sGGlobalAttributeDialog.setVisible(true);
        }
    }

    @Override
    public void setDataType(String string) {
        this.mDataType = string;
        this.mDataColumnSelectionPanel.setDataType(string);
    }

    public void setPopupDialogOwner(Window window) {
        this.mDialogOwner = window;
        this.mDataColumnSelectionPanel.setPopupDialogOwner(window);
    }

    public JTextField getMultipleDimensionStartField() {
        return this.mMultipleDimensionStartField;
    }

    public Integer getMultipleDimensionStart() {
        String string = this.mMultipleDimensionStartField.getText();
        if (string == null) {
            return null;
        }
        Integer n = SGUtilityText.getInteger(string);
        return n;
    }

    public JTextField getMultipleDimensionEndField() {
        return this.mMultipleDimensionEndField;
    }

    public Integer getMultipleDimensionEnd() {
        String string = this.mMultipleDimensionEndField.getText();
        if (string == null) {
            return null;
        }
        Integer n = SGUtilityText.getInteger(string);
        return n;
    }

    public JTextField getMultipleDimensionStepField() {
        return this.mMultipleDimensionStepField;
    }

    public Integer getMultipleDimensionStep() {
        String string = this.mMultipleDimensionStepField.getText();
        if (string == null) {
            return null;
        }
        Integer n = SGUtilityText.getInteger(string);
        return n;
    }

    public Boolean isVariableDataType() {
        for (int i = 0; i < this.mNetCDFColumns.length; ++i) {
            if (!"Pickup".equals(this.mNetCDFColumns[i].getColumnType())) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private static class TemporaryColumnInfo {
        boolean multipleVariable;
        SGDataColumnInfo[] colInfoVariable;
        SGDataColumnInfo[] colInfoPickup;

        private TemporaryColumnInfo() {
        }

        void setColumnInfo(boolean bl, SGDataColumnInfo[] sGDataColumnInfoArray) {
            this.multipleVariable = bl;
            if (bl) {
                this.colInfoVariable = new SGDataColumnInfo[sGDataColumnInfoArray.length];
                for (int i = 0; i < sGDataColumnInfoArray.length; ++i) {
                    this.colInfoVariable[i] = (SGDataColumnInfo)sGDataColumnInfoArray[i].clone();
                }
            } else {
                this.colInfoPickup = new SGDataColumnInfo[sGDataColumnInfoArray.length];
                for (int i = 0; i < sGDataColumnInfoArray.length; ++i) {
                    this.colInfoPickup[i] = (SGDataColumnInfo)sGDataColumnInfoArray[i].clone();
                }
            }
        }

        void clearColumnInfo() {
            this.colInfoVariable = new SGDataColumnInfo[0];
            this.colInfoPickup = new SGDataColumnInfo[0];
        }
    }
}

