/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.data;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.riken.brain.ni.samuraigraph.base.SGIDataSource;
import jp.riken.brain.ni.samuraigraph.data.SGByteDataVariable;
import jp.riken.brain.ni.samuraigraph.data.SGCoordinateVariable;
import jp.riken.brain.ni.samuraigraph.data.SGDataUtility;
import jp.riken.brain.ni.samuraigraph.data.SGDateVariable;
import jp.riken.brain.ni.samuraigraph.data.SGINetCDFConstants;
import jp.riken.brain.ni.samuraigraph.data.SGTextVariable;
import jp.riken.brain.ni.samuraigraph.data.SGVariable;
import ucar.ma2.ArrayChar;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGNetCDFFile
implements SGIDataSource,
SGINetCDFConstants {
    private NetcdfFile mNetcdfFile = null;
    private List<SGVariable> mVariableList = new ArrayList<SGVariable>();
    private boolean mDisposed = false;
    protected Map<String, Object> mVariableCache = new HashMap<String, Object>();

    public SGNetCDFFile(NetcdfFile netcdfFile) {
        Object object;
        Object object22;
        Object object32;
        if (netcdfFile == null) {
            throw new IllegalArgumentException("ncfile == null");
        }
        this.mNetcdfFile = netcdfFile;
        List list = netcdfFile.getVariables();
        ArrayList<Dimension> arrayList = new ArrayList<Dimension>();
        for (Object object32 : list) {
            if (!SGDataUtility.isSGTextVariable((Variable)object32) && !SGDataUtility.isSGDateVariable((Variable)object32)) continue;
            arrayList.add(object32.getDimension(1));
        }
        ArrayList arrayList2 = new ArrayList();
        for (Object object22 : list) {
            if (!DataType.BYTE.equals((Object)object22.getDataType())) continue;
            arrayList2.add(object22.getDimension(0));
        }
        for (Object object22 : list) {
            if (!object22.isCoordinateVariable()) continue;
            this.mVariableList.add(new SGVariable((Variable)object22));
        }
        object32 = netcdfFile.getDimensions();
        object22 = object32.iterator();
        while (object22.hasNext()) {
            Dimension dimension = (Dimension)object22.next();
            boolean bl = false;
            for (String[] stringArray : list) {
                if (!stringArray.isCoordinateVariable() || !(object = stringArray.getDimension(0)).equals((Object)dimension)) continue;
                bl = true;
                break;
            }
            if (!bl && arrayList.contains(dimension)) {
                bl = true;
            }
            if (!bl && arrayList2.contains(dimension)) {
                bl = true;
            }
            if (bl) continue;
            this.mVariableList.add(new SGCoordinateVariable(dimension));
        }
        for (Dimension dimension : list) {
            if (dimension.isCoordinateVariable()) continue;
            if (DataType.CHAR.equals((Object)dimension.getDataType())) {
                String[] stringArray;
                block15: {
                    List list2 = dimension.getDimensions();
                    if (null == list2 || list2.size() != 2) continue;
                    Object object4 = dimension.getShape();
                    stringArray = new String[object4[0]];
                    try {
                        object = dimension.read();
                        if (!(object instanceof ArrayChar)) break block15;
                        ArrayChar arrayChar = (ArrayChar)object;
                        Index index = arrayChar.getIndex();
                        for (int i = 0; i < object4[0]; ++i) {
                            byte[] byArray = new byte[object4[1]];
                            for (int j = 0; j < object4[1]; ++j) {
                                byArray[j] = arrayChar.getByte(index.set(i, j));
                            }
                            stringArray[i] = new String(byArray, "UTF-8").trim();
                        }
                    }
                    catch (IOException iOException) {
                        continue;
                    }
                }
                object = null;
                object = SGDataUtility.isSGDateVariable((Variable)dimension) ? new SGDateVariable((Variable)dimension, stringArray) : new SGTextVariable((Variable)dimension, stringArray);
                this.mVariableList.add((SGVariable)object);
                continue;
            }
            if (DataType.BYTE.equals((Object)dimension.getDataType())) {
                this.mVariableList.add(new SGByteDataVariable((Variable)dimension));
                continue;
            }
            this.mVariableList.add(new SGVariable((Variable)dimension));
        }
    }

    public NetcdfFile getNetcdfFile() {
        return this.mNetcdfFile;
    }

    public List<SGVariable> getVariables() {
        return new ArrayList<SGVariable>(this.mVariableList);
    }

    public SGVariable findVariable(String string) {
        for (SGVariable sGVariable : this.mVariableList) {
            if (!sGVariable.getName().equals(string)) continue;
            return sGVariable;
        }
        return null;
    }

    public SGVariable findVariableEx(String string) {
        for (int i = 0; i < this.mVariableList.size(); ++i) {
            SGVariable sGVariable = this.mVariableList.get(i);
            String string2 = sGVariable.getLongName();
            if (string2 != null && string.equals(string2)) {
                return sGVariable;
            }
            string2 = sGVariable.getStandardName();
            if (string2 != null && string.equals(string2)) {
                return sGVariable;
            }
            if (!string.equals(sGVariable.getName())) continue;
            return sGVariable;
        }
        return null;
    }

    public int getVariableIndex(String string) {
        for (int i = 0; i < this.mVariableList.size(); ++i) {
            SGVariable sGVariable = this.mVariableList.get(i);
            if (string.equals(sGVariable.getName())) {
                return i;
            }
            if (!(sGVariable instanceof SGTextVariable) || !string.equals(sGVariable.getOriginalName())) continue;
            return i;
        }
        return -1;
    }

    public SGVariable findTopVariable(String string) {
        Variable variable = this.mNetcdfFile.findTopVariable(string);
        if (variable != null) {
            return new SGVariable(variable);
        }
        return null;
    }

    public List<Dimension> getDimensions() {
        return this.mNetcdfFile.getDimensions();
    }

    public Dimension findDimension(String string) {
        return this.mNetcdfFile.findDimension(string);
    }

    public String toString() {
        if (this.mNetcdfFile == null) {
            return "null";
        }
        return this.mNetcdfFile.toString();
    }

    public SGTextVariable findTextVariable(String string) {
        SGTextVariable sGTextVariable = null;
        for (int i = 0; i < this.mVariableList.size(); ++i) {
            SGTextVariable sGTextVariable2;
            SGVariable sGVariable = this.mVariableList.get(i);
            if (!(sGVariable instanceof SGTextVariable) || !(sGTextVariable2 = (SGTextVariable)sGVariable).getName().endsWith(string)) continue;
            sGTextVariable = sGTextVariable2;
            break;
        }
        return sGTextVariable;
    }

    public Object clone() {
        SGNetCDFFile sGNetCDFFile = null;
        try {
            sGNetCDFFile = (SGNetCDFFile)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        sGNetCDFFile.mVariableList = new ArrayList<SGVariable>();
        sGNetCDFFile.mVariableList.addAll(this.mVariableList);
        return sGNetCDFFile;
    }

    @Override
    public void dispose() {
        this.mDisposed = true;
        this.mVariableList.clear();
        this.mVariableCache.clear();
        try {
            this.mNetcdfFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.mNetcdfFile = null;
        this.mVariableList = null;
        this.mVariableCache = null;
    }

    @Override
    public boolean isDisposed() {
        return this.mDisposed;
    }

    public Object getVariableCache(String string) {
        return this.mVariableCache.get(string);
    }

    public void setVariableCache(String string, Object object) {
        this.mVariableCache.put(string, object);
    }
}

