/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.data;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.data.SGDataSourceObserver;
import jp.riken.brain.ni.samuraigraph.data.SGDataUtility;
import jp.riken.brain.ni.samuraigraph.data.SGDateVariable;
import jp.riken.brain.ni.samuraigraph.data.SGISXYTypeData;
import jp.riken.brain.ni.samuraigraph.data.SGISXYTypeMultipleData;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFData;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFFile;
import jp.riken.brain.ni.samuraigraph.data.SGSXYMultipleNetCDFData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYNetCDFData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYNetCDFDateData;
import jp.riken.brain.ni.samuraigraph.data.SGVariable;
import org.w3c.dom.Element;
import ucar.nc2.Dimension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGSXYMultipleDimensionNetCDFData
extends SGSXYMultipleNetCDFData {
    protected SGVariable mXVariable = null;
    protected SGVariable mYVariable = null;
    protected SGVariable mLowerErrorVariable = null;
    protected SGVariable mUpperErrorVariable = null;
    protected SGVariable mTickLabelVariable = null;
    protected Dimension mDimension = null;
    protected Integer[] mDimensionIndices = null;

    public SGSXYMultipleDimensionNetCDFData() {
    }

    public SGSXYMultipleDimensionNetCDFData(SGNetCDFFile sGNetCDFFile, SGDataSourceObserver sGDataSourceObserver, String string, String string2, String string3, String string4, String string5, String string6, int n, int n2, int n3, String string7, String string8) {
        super(sGNetCDFFile, sGDataSourceObserver, string7, string8);
        Object object;
        if (string == null || string2 == null || string6 == null) {
            throw new IllegalArgumentException("xName == null || yName == null || dimName == null");
        }
        if (!(string3 == null && string4 == null || string3 != null && string4 != null)) {
            throw new IllegalArgumentException("lName = " + string3 + ", uName = " + string4);
        }
        Dimension dimension = sGNetCDFFile.findDimension(string6);
        if (dimension == null) {
            throw new IllegalArgumentException("Dimension is not found: " + string6);
        }
        int n4 = dimension.getLength();
        if (n < 0 || n >= n4) {
            throw new IllegalArgumentException("Dimension start is out of bounds: " + n);
        }
        if (n2 < 0 || n2 >= n4) {
            throw new IllegalArgumentException("Dimension end is out of bounds: " + n2);
        }
        SGVariable sGVariable = this.getVariable(sGNetCDFFile, string);
        SGVariable sGVariable2 = this.getVariable(sGNetCDFFile, string2);
        SGVariable sGVariable3 = this.getVariable(sGNetCDFFile, string3);
        SGVariable sGVariable4 = this.getVariable(sGNetCDFFile, string4);
        SGVariable sGVariable5 = this.getVariable(sGNetCDFFile, string5);
        ArrayList<Dimension> arrayList = new ArrayList<Dimension>();
        arrayList.add(dimension);
        if (this.mTimeVariable != null) {
            object = this.mTimeVariable.getDimension(0);
            if (object.equals((Object)dimension)) {
                throw new IllegalArgumentException("The dimension of a coordinate variable is equal to the given dimension.");
            }
            arrayList.add((Dimension)object);
        }
        if (this.mSerialNumberVariable != null) {
            if (!sGVariable.isCoordinateVariable() || !sGVariable2.isCoordinateVariable()) {
                throw new IllegalArgumentException("Both of x and y variables must not be coordinate variables.");
            }
            object = this.mSerialNumberVariable.getDimension(0);
            arrayList.add((Dimension)object);
            this.checkNotCoordinateVariable(sGVariable, arrayList);
            this.checkNotCoordinateVariable(sGVariable2, arrayList);
        } else {
            Dimension dimension2;
            if (sGVariable.isCoordinateVariable() && sGVariable2.isCoordinateVariable() || !sGVariable.isCoordinateVariable() && !sGVariable2.isCoordinateVariable()) {
                throw new IllegalArgumentException("Either of x and y variables must be a coordinate variable.");
            }
            object = null;
            SGVariable sGVariable6 = null;
            if (sGVariable.isCoordinateVariable()) {
                object = sGVariable;
                sGVariable6 = sGVariable2;
            } else {
                object = sGVariable2;
                sGVariable6 = sGVariable;
            }
            Dimension dimension3 = ((SGVariable)object).getDimension(0);
            if (dimension3.equals((Object)dimension)) {
                throw new IllegalArgumentException("The dimension of a coordinate variable is equal to the given dimension.");
            }
            arrayList.add(dimension3);
            if (this.mTimeVariable != null && (dimension2 = this.mTimeVariable.getDimension(0)).equals((Object)dimension3)) {
                throw new IllegalArgumentException("The dimension of a coordinate variable is equal to the dimension for time.");
            }
            this.checkNotCoordinateVariable(sGVariable6, arrayList);
        }
        this.checkNotCoordinateVariable(sGVariable3, arrayList);
        this.checkNotCoordinateVariable(sGVariable4, arrayList);
        this.checkNotCoordinateVariable(sGVariable5, arrayList);
        this.mXVariable = sGVariable;
        this.mYVariable = sGVariable2;
        this.mLowerErrorVariable = sGVariable3;
        this.mUpperErrorVariable = sGVariable4;
        this.mTickLabelVariable = sGVariable5;
        this.mDimension = dimension;
        this.mDimensionStart = n;
        this.mDimensionEnd = n2;
        this.mDimensionStep = n3;
        this.updateDimensionIndices();
    }

    @Override
    public boolean setDimensionStart(int n) {
        int n2 = this.mDimension.getLength();
        if (n < 0 || n >= n2) {
            throw new IllegalArgumentException("Dimension start is out of bounds: " + n);
        }
        if (!super.setDimensionStart(n)) {
            return false;
        }
        this.updateDimensionIndices();
        return true;
    }

    @Override
    public boolean setDimensionEnd(int n) {
        int n2 = this.mDimension.getLength();
        if (n < 0 || n >= n2) {
            throw new IllegalArgumentException("Dimension end is out of bounds: " + n);
        }
        if (!super.setDimensionEnd(n)) {
            return false;
        }
        this.updateDimensionIndices();
        return true;
    }

    @Override
    public boolean setDimensionStep(int n) {
        if (!super.setDimensionStep(n)) {
            return false;
        }
        this.updateDimensionIndices();
        return true;
    }

    public String getDimensionName() {
        if (null == this.mDimension) {
            return "";
        }
        return this.mDimension.getName();
    }

    public Integer[] getDimensionIndices() {
        return (Integer[])this.mDimensionIndices.clone();
    }

    private void updateDimensionIndices() {
        this.mDimensionIndices = SGDataUtility.calcDimIndices(this.mDimension, this.mDimensionStart, this.mDimensionEnd, this.mDimensionStep);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.mXVariable = null;
        this.mYVariable = null;
        this.mLowerErrorVariable = null;
        this.mUpperErrorVariable = null;
        this.mTickLabelVariable = null;
        this.mDimension = null;
        this.mDimensionStart = null;
        this.mDimensionEnd = null;
        this.mDimensionStep = null;
        this.mDimensionIndices = null;
        this.mVariableCache.clear();
    }

    @Override
    protected boolean hasMultipleYValues() {
        return this.mXVariable.isCoordinateVariable();
    }

    public SGVariable getMultipleVariable() {
        if (this.hasMultipleYValues()) {
            return this.mYVariable;
        }
        return this.mXVariable;
    }

    @Override
    public SGVariable getSingleVariable() {
        if (this.hasMultipleYValues()) {
            return this.mXVariable;
        }
        return this.mYVariable;
    }

    public SGVariable getXVariable() {
        return this.mXVariable;
    }

    public SGVariable getYVariable() {
        return this.mYVariable;
    }

    public SGVariable getLowerErrorVariable() {
        return this.mLowerErrorVariable;
    }

    public SGVariable getUpperErrorVariable() {
        return this.mUpperErrorVariable;
    }

    public SGVariable getTickLabelVariable() {
        return this.mTickLabelVariable;
    }

    @Override
    public String getDataType() {
        return "SXY_MULTIPLE_NETCDF_PICKUP";
    }

    @Override
    protected String getDataTypeForDataSet() {
        return "SXY_MULTIPLE";
    }

    @Override
    public SGVariable[] getVariables() {
        ArrayList<SGVariable> arrayList = new ArrayList<SGVariable>();
        arrayList.add(this.mXVariable);
        arrayList.add(this.mYVariable);
        if (this.mLowerErrorVariable != null) {
            arrayList.add(this.mLowerErrorVariable);
        }
        if (this.mUpperErrorVariable != null) {
            arrayList.add(this.mUpperErrorVariable);
        }
        if (this.mTickLabelVariable != null) {
            arrayList.add(this.mTickLabelVariable);
        }
        if (this.mTimeVariable != null) {
            arrayList.add(this.mTimeVariable);
        }
        if (this.mSerialNumberVariable != null) {
            arrayList.add(this.mSerialNumberVariable);
        }
        SGVariable[] sGVariableArray = new SGVariable[arrayList.size()];
        return arrayList.toArray(sGVariableArray);
    }

    @Override
    protected double[][] getDataSetValues() {
        return null;
    }

    @Override
    public Double getXValue(int n, int n2) {
        int n3 = this.getPointsNumber();
        if (n2 < 0 || n2 >= n3) {
            throw new IllegalArgumentException("given index is out of bounds: " + n2);
        }
        if (n < 0 || n >= this.mDimension.getLength()) {
            throw new IllegalArgumentException("given index is out of bounds: " + n);
        }
        return super.getXValue(n, n2);
    }

    @Override
    public Double getYValue(int n, int n2) {
        int n3 = this.getPointsNumber();
        if (n2 < 0 || n2 >= n3) {
            throw new IllegalArgumentException("given index is out of bounds: " + n2);
        }
        if (n < 0 || n >= this.mDimension.getLength()) {
            throw new IllegalArgumentException("given index is out of bounds: " + n);
        }
        return super.getYValue(n, n2);
    }

    @Override
    public int getSXYDataNumMax() {
        return this.mDimension.getLength();
    }

    public Double getDimensionValue(int n) {
        try {
            double d = this.getCoordinateValue(this.mDimension.getName(), n);
            return d;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public boolean isErrorBarAvailable() {
        return this.mLowerErrorVariable != null && this.mUpperErrorVariable != null;
    }

    @Override
    public boolean isTickLabelAvailable() {
        return this.mTickLabelVariable != null;
    }

    @Override
    public Boolean isErrorBarVertical() {
        if (this.isErrorBarAvailable()) {
            return this.hasMultipleYValues();
        }
        return null;
    }

    @Override
    public Boolean isTickLabelHorizontal() {
        if (this.isTickLabelAvailable()) {
            return this.hasMultipleYValues();
        }
        return null;
    }

    @Override
    public String getTitleX() {
        if (this.hasMultipleYValues()) {
            return this.getNameWithUnit(this.mXVariable);
        }
        return "";
    }

    @Override
    public String getTitleY() {
        if (this.hasMultipleYValues()) {
            return "";
        }
        return this.getNameWithUnit(this.mYVariable);
    }

    @Override
    public String[] getCurrentColumnType() {
        List<SGVariable> list = this.mNCFile.getVariables();
        int n = list.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            String string;
            SGVariable sGVariable = list.get(i);
            if (sGVariable.equals(this.mXVariable)) {
                stringArray[i] = "X";
                continue;
            }
            if (sGVariable.equals(this.mYVariable)) {
                stringArray[i] = "Y";
                continue;
            }
            if (sGVariable.equals(this.mLowerErrorVariable) || sGVariable.equals(this.mUpperErrorVariable)) {
                string = null;
                if (this.mLowerErrorVariable.equals(this.mUpperErrorVariable)) {
                    string = "Lower / Upper Error";
                } else if (sGVariable.equals(this.mLowerErrorVariable)) {
                    string = "Lower Error";
                } else if (sGVariable.equals(this.mUpperErrorVariable)) {
                    string = "Upper Error";
                }
                stringArray[i] = string;
                continue;
            }
            if (sGVariable.equals(this.mTickLabelVariable)) {
                stringArray[i] = "Tick Label";
                continue;
            }
            if (sGVariable.equals(this.mTimeVariable)) {
                stringArray[i] = "Time";
                continue;
            }
            if (sGVariable.equals(this.mSerialNumberVariable)) {
                stringArray[i] = "SerialNumbers";
                continue;
            }
            if (sGVariable.isCoordinateVariable()) {
                string = sGVariable.getDimension(0);
                if (this.mDimension.equals((Object)string)) {
                    stringArray[i] = "Pickup";
                    continue;
                }
                stringArray[i] = "";
                continue;
            }
            stringArray[i] = "";
        }
        return stringArray;
    }

    @Override
    public boolean setColumnType(String[] stringArray) {
        SGVariable sGVariable = null;
        SGVariable sGVariable2 = null;
        SGVariable sGVariable3 = null;
        SGVariable sGVariable4 = null;
        SGVariable sGVariable5 = null;
        SGVariable sGVariable6 = null;
        SGVariable sGVariable7 = null;
        SGVariable sGVariable8 = null;
        List<SGVariable> list = this.mNCFile.getVariables();
        for (int i = 0; i < stringArray.length; ++i) {
            SGVariable sGVariable9 = list.get(i);
            if (SGUtilityText.isEqualString("X", stringArray[i])) {
                sGVariable = sGVariable9;
                continue;
            }
            if (SGUtilityText.isEqualString("Y", stringArray[i])) {
                sGVariable2 = sGVariable9;
                continue;
            }
            if (SGUtilityText.isEqualString(stringArray[i], "Lower Error")) {
                sGVariable3 = sGVariable9;
                continue;
            }
            if (SGUtilityText.isEqualString(stringArray[i], "Upper Error")) {
                sGVariable4 = sGVariable9;
                continue;
            }
            if (SGUtilityText.isEqualString(stringArray[i], "Lower / Upper Error")) {
                sGVariable3 = sGVariable9;
                sGVariable4 = sGVariable9;
                continue;
            }
            if (SGUtilityText.isEqualString(stringArray[i], "Tick Label")) {
                sGVariable5 = sGVariable9;
                continue;
            }
            if (SGUtilityText.isEqualString(stringArray[i], "Pickup")) {
                sGVariable7 = sGVariable9;
                continue;
            }
            if (SGUtilityText.isEqualString(stringArray[i], "Time")) {
                sGVariable6 = sGVariable9;
                continue;
            }
            if (SGUtilityText.isEqualString(stringArray[i], "SerialNumbers")) {
                sGVariable8 = sGVariable9;
                continue;
            }
            if ("".equals(stringArray[i])) continue;
            return false;
        }
        if (sGVariable == null || sGVariable2 == null || sGVariable7 == null) {
            return false;
        }
        if (!(sGVariable3 != null && sGVariable4 != null || sGVariable3 == null && sGVariable4 == null)) {
            return false;
        }
        this.mXVariable = sGVariable;
        this.mYVariable = sGVariable2;
        this.mLowerErrorVariable = sGVariable3;
        this.mUpperErrorVariable = sGVariable4;
        this.mTickLabelVariable = sGVariable5;
        this.mTimeVariable = sGVariable6;
        this.mSerialNumberVariable = sGVariable8;
        this.mDimension = sGVariable7.getDimension(0);
        return true;
    }

    @Override
    public SGProperties getProperties() {
        SXYMultipleDimensionNetCDFDataProperties sXYMultipleDimensionNetCDFDataProperties = new SXYMultipleDimensionNetCDFDataProperties();
        if (!this.getProperties(sXYMultipleDimensionNetCDFDataProperties)) {
            return null;
        }
        return sXYMultipleDimensionNetCDFDataProperties;
    }

    @Override
    public boolean getProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof SXYMultipleDimensionNetCDFDataProperties)) {
            return false;
        }
        if (!super.getProperties(sGProperties)) {
            return false;
        }
        SXYMultipleDimensionNetCDFDataProperties sXYMultipleDimensionNetCDFDataProperties = (SXYMultipleDimensionNetCDFDataProperties)sGProperties;
        sXYMultipleDimensionNetCDFDataProperties.xName = this.getName(this.mXVariable);
        sXYMultipleDimensionNetCDFDataProperties.yName = this.getName(this.mYVariable);
        sXYMultipleDimensionNetCDFDataProperties.lName = this.getName(this.mLowerErrorVariable);
        sXYMultipleDimensionNetCDFDataProperties.uName = this.getName(this.mUpperErrorVariable);
        sXYMultipleDimensionNetCDFDataProperties.tName = this.getName(this.mTickLabelVariable);
        sXYMultipleDimensionNetCDFDataProperties.dimName = this.getName(this.mDimension);
        sXYMultipleDimensionNetCDFDataProperties.dimStart = this.mDimensionStart;
        sXYMultipleDimensionNetCDFDataProperties.dimEnd = this.mDimensionEnd;
        sXYMultipleDimensionNetCDFDataProperties.dimStep = this.mDimensionStep;
        return true;
    }

    @Override
    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof SXYMultipleDimensionNetCDFDataProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        SXYMultipleDimensionNetCDFDataProperties sXYMultipleDimensionNetCDFDataProperties = (SXYMultipleDimensionNetCDFDataProperties)sGProperties;
        this.mXVariable = this.findVariable(sXYMultipleDimensionNetCDFDataProperties.xName);
        this.mYVariable = this.findVariable(sXYMultipleDimensionNetCDFDataProperties.yName);
        this.mLowerErrorVariable = this.findVariable(sXYMultipleDimensionNetCDFDataProperties.lName);
        this.mUpperErrorVariable = this.findVariable(sXYMultipleDimensionNetCDFDataProperties.uName);
        this.mTickLabelVariable = this.findVariable(sXYMultipleDimensionNetCDFDataProperties.tName);
        this.mDimension = this.findDimension(sXYMultipleDimensionNetCDFDataProperties.dimName);
        this.mDimensionStart = sXYMultipleDimensionNetCDFDataProperties.dimStart;
        this.mDimensionEnd = sXYMultipleDimensionNetCDFDataProperties.dimEnd;
        this.mDimensionStep = sXYMultipleDimensionNetCDFDataProperties.dimStep;
        this.updateDimensionIndices();
        return true;
    }

    @Override
    public boolean readProperty(Element element) {
        if (!super.readProperty(element)) {
            return false;
        }
        String string = null;
        SGVariable sGVariable = null;
        SGVariable sGVariable2 = null;
        SGVariable sGVariable3 = null;
        SGVariable sGVariable4 = null;
        SGVariable sGVariable5 = null;
        Dimension dimension = null;
        Integer n = null;
        Integer n2 = null;
        Integer n3 = null;
        string = element.getAttribute("XValueName");
        if (string.length() != 0) {
            sGVariable = this.mNCFile.findVariable(string);
            if (sGVariable == null) {
                return false;
            }
        } else {
            return false;
        }
        string = element.getAttribute("YValueName");
        if (string.length() != 0) {
            sGVariable2 = this.mNCFile.findVariable(string);
            if (sGVariable2 == null) {
                return false;
            }
        } else {
            return false;
        }
        string = element.getAttribute("LowerErrorValueName");
        if (string.length() != 0 && (sGVariable3 = this.mNCFile.findVariable(string)) == null) {
            return false;
        }
        string = element.getAttribute("UpperErrorValueName");
        if (string.length() != 0 && (sGVariable4 = this.mNCFile.findVariable(string)) == null) {
            return false;
        }
        if (!(sGVariable3 == null && sGVariable4 == null || sGVariable3 != null && sGVariable4 != null)) {
            return false;
        }
        string = element.getAttribute("TickLabelName");
        if (string.length() != 0 && (sGVariable5 = this.mNCFile.findVariable(string)) == null) {
            return false;
        }
        string = element.getAttribute("PickupDimensionName");
        if (string.length() != 0 && (dimension = this.mNCFile.findDimension(string)) == null) {
            return false;
        }
        string = element.getAttribute("PickupStart");
        if (string.length() != 0 && (n = SGUtilityText.getInteger(string)) == null) {
            return false;
        }
        string = element.getAttribute("PickupEnd");
        if (string.length() != 0 && (n2 = SGUtilityText.getInteger(string)) == null) {
            return false;
        }
        string = element.getAttribute("PickupStep");
        if (string.length() != 0 && (n3 = SGUtilityText.getInteger(string)) == null) {
            return false;
        }
        this.mXVariable = sGVariable;
        this.mYVariable = sGVariable2;
        this.mLowerErrorVariable = sGVariable3;
        this.mUpperErrorVariable = sGVariable4;
        this.mTickLabelVariable = sGVariable5;
        this.mDimension = dimension;
        this.mDimensionStart = n;
        this.mDimensionEnd = n2;
        this.mDimensionStep = n3;
        this.updateDimensionIndices();
        return true;
    }

    @Override
    public boolean writeProperty(Element element, int n) {
        if (!super.writeProperty(element, n)) {
            return false;
        }
        element.setAttribute("XValueName", this.mXVariable.getName());
        element.setAttribute("YValueName", this.mYVariable.getName());
        if (this.isErrorBarAvailable()) {
            element.setAttribute("LowerErrorValueName", this.mLowerErrorVariable.getName());
            element.setAttribute("UpperErrorValueName", this.mUpperErrorVariable.getName());
        }
        if (this.isTickLabelAvailable()) {
            element.setAttribute("TickLabelName", this.mTickLabelVariable.getOriginalName());
        }
        if (this.mDimension != null) {
            element.setAttribute("PickupDimensionName", this.mDimension.getName());
        }
        if (this.mDimensionStart != null) {
            element.setAttribute("PickupStart", String.valueOf(this.mDimensionStart));
        }
        if (this.mDimensionEnd != null) {
            element.setAttribute("PickupEnd", String.valueOf(this.mDimensionEnd));
        }
        if (this.mDimensionStep != null) {
            element.setAttribute("PickupStep", String.valueOf(this.mDimensionStep));
        }
        return true;
    }

    @Override
    public boolean setData(SGData sGData) {
        if (!(sGData instanceof SGSXYMultipleDimensionNetCDFData)) {
            throw new IllegalArgumentException("Given data is not the instance of SGSXYMultipleDimensionNetCDFData class.");
        }
        if (!super.setData(sGData)) {
            return false;
        }
        SGSXYMultipleDimensionNetCDFData sGSXYMultipleDimensionNetCDFData = (SGSXYMultipleDimensionNetCDFData)sGData;
        this.mXVariable = sGSXYMultipleDimensionNetCDFData.mXVariable;
        this.mYVariable = sGSXYMultipleDimensionNetCDFData.mYVariable;
        if (sGSXYMultipleDimensionNetCDFData.isErrorBarAvailable()) {
            this.mLowerErrorVariable = sGSXYMultipleDimensionNetCDFData.mLowerErrorVariable;
            this.mUpperErrorVariable = sGSXYMultipleDimensionNetCDFData.mUpperErrorVariable;
        }
        if (sGSXYMultipleDimensionNetCDFData.isTickLabelAvailable()) {
            this.mTickLabelVariable = sGSXYMultipleDimensionNetCDFData.mTickLabelVariable;
        }
        this.mDimension = sGSXYMultipleDimensionNetCDFData.mDimension;
        this.updateDimensionIndices();
        return true;
    }

    @Override
    protected double[][] getMultipleVariableValueArray() {
        SGVariable[] sGVariableArray = new SGVariable[]{this.getSingleVariable()};
        SGVariable sGVariable = this.getMultipleVariable();
        String string = this.mDimension.getName();
        double[][] dArrayArray = new double[this.mDimensionIndices.length][];
        for (int i = 0; i < dArrayArray.length; ++i) {
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>(this.mOriginMap);
            hashMap.put(string, this.mDimensionIndices[i]);
            dArrayArray[i] = this.getValueArray(sGVariable, sGVariableArray, hashMap);
        }
        return dArrayArray;
    }

    @Override
    public SGISXYTypeData[] getSXYDataArray() {
        int n = this.mDimensionIndices.length;
        List<Dimension> list = this.mNCFile.getDimensions();
        String string = this.mDimension.getName();
        String string2 = this.hasMultipleYValues() ? this.mYVariable.getName() : this.mXVariable.getName();
        String string3 = this.mLowerErrorVariable != null ? this.mLowerErrorVariable.getName() : null;
        String string4 = this.mUpperErrorVariable != null ? this.mUpperErrorVariable.getName() : null;
        String string5 = this.mTickLabelVariable != null ? this.mTickLabelVariable.getName() : null;
        String string6 = this.mTimeVariable != null ? this.mTimeVariable.getName() : null;
        String string7 = this.mSerialNumberVariable != null ? this.mSerialNumberVariable.getName() : null;
        SGISXYTypeData[] sGISXYTypeDataArray = new SGISXYTypeData[n];
        for (int i = 0; i < sGISXYTypeDataArray.length; ++i) {
            SGSXYNetCDFData sGSXYNetCDFData = this.mXVariable instanceof SGDateVariable || this.mYVariable instanceof SGDateVariable ? new SGSXYNetCDFDateData(this.mNCFile, this.mObserver, this.mXVariable.getName(), this.mYVariable.getName(), string3, string4, string2, string5, string2, string6, string7) : new SGSXYNetCDFData(this.mNCFile, this.mObserver, this.mXVariable.getName(), this.mYVariable.getName(), string3, string4, string2, string5, string2, string6, string7);
            for (Dimension dimension : list) {
                Integer n2;
                String string8 = dimension.getName();
                if (string8.equals(string)) {
                    n2 = this.mDimensionIndices[i];
                } else {
                    n2 = (Integer)this.mOriginMap.get(string8);
                    if (n2 == null) {
                        n2 = 0;
                    }
                }
                sGSXYNetCDFData.setOrigin(string8, n2);
            }
            SGSXYNetCDFData sGSXYNetCDFData2 = sGSXYNetCDFData;
            sGSXYNetCDFData2.setCacheMap(this.mVariableCache);
            sGISXYTypeDataArray[i] = sGSXYNetCDFData;
        }
        return sGISXYTypeDataArray;
    }

    @Override
    public int getOrigin(String string) {
        if (SGDataUtility.isSameNetCDFGroup(string, this.getDimensionName())) {
            return super.getOrigin(string);
        }
        return 0;
    }

    @Override
    public Map<String, Object> getInfoMap() {
        Map<String, Object> map = super.getInfoMap();
        map.put("Multiple", Boolean.TRUE);
        map.put("Graphs for multiple variables", Boolean.FALSE);
        map.put("Multiple dimension start", this.mDimensionStart);
        map.put("Multiple dimension end", this.mDimensionEnd);
        map.put("Multiple dimension step", this.mDimensionStep);
        return map;
    }

    @Override
    public SGISXYTypeMultipleData[] getSXYTypeMultipleDataArray() {
        SGISXYTypeData[] sGISXYTypeDataArray = this.getSXYDataArray();
        SGISXYTypeMultipleData[] sGISXYTypeMultipleDataArray = new SGISXYTypeMultipleData[sGISXYTypeDataArray.length];
        for (int i = 0; i < sGISXYTypeDataArray.length; ++i) {
            SGSXYNetCDFData sGSXYNetCDFData = (SGSXYNetCDFData)sGISXYTypeDataArray[i];
            sGISXYTypeMultipleDataArray[i] = sGSXYNetCDFData.toMultiple(this.mDimension, this.mDimensionIndices[i]);
            sGSXYNetCDFData.dispose();
        }
        return sGISXYTypeMultipleDataArray;
    }

    @Override
    public boolean isSplitEnabled() {
        int n = this.mDimensionIndices.length;
        return n > 1;
    }

    public static SGISXYTypeMultipleData merge(List<SGData> list) {
        Cloneable cloneable2;
        if (list.size() == 0) {
            return null;
        }
        for (Cloneable cloneable2 : list) {
            if (cloneable2 instanceof SGSXYMultipleDimensionNetCDFData) continue;
            return null;
        }
        SGSXYMultipleDimensionNetCDFData sGSXYMultipleDimensionNetCDFData = (SGSXYMultipleDimensionNetCDFData)list.get(list.size() - 1);
        cloneable2 = sGSXYMultipleDimensionNetCDFData.getNetcdfFile();
        SGDataSourceObserver sGDataSourceObserver = sGSXYMultipleDimensionNetCDFData.mObserver;
        String string = sGSXYMultipleDimensionNetCDFData.mXVariable.getName();
        String string2 = sGSXYMultipleDimensionNetCDFData.mYVariable.getName();
        String string3 = null != sGSXYMultipleDimensionNetCDFData.mLowerErrorVariable ? sGSXYMultipleDimensionNetCDFData.mLowerErrorVariable.getName() : null;
        String string4 = null != sGSXYMultipleDimensionNetCDFData.mUpperErrorVariable ? sGSXYMultipleDimensionNetCDFData.mUpperErrorVariable.getName() : null;
        String string5 = null != sGSXYMultipleDimensionNetCDFData.mTickLabelVariable ? sGSXYMultipleDimensionNetCDFData.mTickLabelVariable.getName() : null;
        String string6 = null != sGSXYMultipleDimensionNetCDFData.mDimension ? sGSXYMultipleDimensionNetCDFData.mDimension.getName() : null;
        String string7 = sGSXYMultipleDimensionNetCDFData.isTimeVariableAvailable() ? sGSXYMultipleDimensionNetCDFData.getTimeVariable().getName() : null;
        String string8 = sGSXYMultipleDimensionNetCDFData.isSerialNumberAvailable() ? sGSXYMultipleDimensionNetCDFData.getSerialNumberVariable().getName() : null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < list.size(); ++i) {
            SGSXYMultipleDimensionNetCDFData sGSXYMultipleDimensionNetCDFData2 = (SGSXYMultipleDimensionNetCDFData)list.get(i);
            int n4 = sGSXYMultipleDimensionNetCDFData2.getDimensionStart();
            int n5 = sGSXYMultipleDimensionNetCDFData2.getDimensionEnd();
            int n6 = sGSXYMultipleDimensionNetCDFData2.getDimensionStep();
            if (i == 0) {
                n = n4;
                n2 = n5;
                n3 = n6;
            }
            if (n5 < n4) {
                int n7 = n4;
                n4 = n5;
                n5 = n7;
            }
            if (n4 < n) {
                n = n4;
            }
            if (n5 > n2) {
                n2 = n5;
            }
            if (n3 >= n6) continue;
            n3 = n6;
        }
        SGSXYMultipleDimensionNetCDFData sGSXYMultipleDimensionNetCDFData3 = new SGSXYMultipleDimensionNetCDFData((SGNetCDFFile)cloneable2, sGDataSourceObserver, string, string2, string3, string4, string5, string6, n, n2, n3, string7, string8);
        sGSXYMultipleDimensionNetCDFData3.mOriginMap = new HashMap(sGSXYMultipleDimensionNetCDFData.mOriginMap);
        sGSXYMultipleDimensionNetCDFData3.setDecimalPlaces(sGSXYMultipleDimensionNetCDFData.getDecimalPlaces());
        sGSXYMultipleDimensionNetCDFData3.setExponent(sGSXYMultipleDimensionNetCDFData.getExponent());
        return sGSXYMultipleDimensionNetCDFData3;
    }

    @Override
    public boolean isXVariableCoordinate() {
        return this.getXVariable().isCoordinateVariable();
    }

    public static class SXYMultipleDimensionNetCDFDataProperties
    extends SGNetCDFData.NetCDFDataProperties {
        protected String xName = null;
        protected String yName = null;
        protected String lName = null;
        protected String uName = null;
        protected String tName = null;
        protected String dimName = null;
        protected Integer dimStart = null;
        protected Integer dimEnd = null;
        protected Integer dimStep = null;

        public void dispose() {
            super.dispose();
            this.xName = null;
            this.yName = null;
            this.lName = null;
            this.uName = null;
            this.tName = null;
            this.dimName = null;
            this.dimStart = null;
            this.dimEnd = null;
            this.dimStep = null;
        }

        public boolean equals(Object object) {
            if (!(object instanceof SXYMultipleDimensionNetCDFDataProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            SXYMultipleDimensionNetCDFDataProperties sXYMultipleDimensionNetCDFDataProperties = (SXYMultipleDimensionNetCDFDataProperties)object;
            if (!SGUtility.equals(this.xName, sXYMultipleDimensionNetCDFDataProperties.xName)) {
                return false;
            }
            if (!SGUtility.equals(this.yName, sXYMultipleDimensionNetCDFDataProperties.yName)) {
                return false;
            }
            if (!SGUtility.equals(this.lName, sXYMultipleDimensionNetCDFDataProperties.lName)) {
                return false;
            }
            if (!SGUtility.equals(this.uName, sXYMultipleDimensionNetCDFDataProperties.uName)) {
                return false;
            }
            if (!SGUtility.equals(this.tName, sXYMultipleDimensionNetCDFDataProperties.tName)) {
                return false;
            }
            if (!SGUtility.equals(this.dimName, sXYMultipleDimensionNetCDFDataProperties.dimName)) {
                return false;
            }
            if (!SGUtility.equals(this.dimStart, sXYMultipleDimensionNetCDFDataProperties.dimStart)) {
                return false;
            }
            if (!SGUtility.equals(this.dimEnd, sXYMultipleDimensionNetCDFDataProperties.dimEnd)) {
                return false;
            }
            return SGUtility.equals(this.dimStep, sXYMultipleDimensionNetCDFDataProperties.dimStep);
        }
    }
}

