/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.data.SGDataSourceObserver;
import jp.riken.brain.ni.samuraigraph.data.SGDataUtility;
import jp.riken.brain.ni.samuraigraph.data.SGDateVariable;
import jp.riken.brain.ni.samuraigraph.data.SGISXYTypeData;
import jp.riken.brain.ni.samuraigraph.data.SGISXYTypeMultipleData;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFData;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFFile;
import jp.riken.brain.ni.samuraigraph.data.SGSXYMultipleNetCDFData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYNetCDFData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYNetCDFDateData;
import jp.riken.brain.ni.samuraigraph.data.SGVariable;
import org.w3c.dom.Element;
import ucar.nc2.Dimension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGSXYMultipleVariableNetCDFData
extends SGSXYMultipleNetCDFData {
    protected SGVariable[] mXVariables = null;
    protected SGVariable[] mYVariables = null;
    protected SGVariable[] mLowerErrorVariables = null;
    protected SGVariable[] mUpperErrorVariables = null;
    protected SGVariable[] mErrorBarHolderVariables = null;
    protected SGVariable[] mTickLabelVariables = null;
    protected SGVariable[] mTickLabelHolderVariables = null;
    private boolean mIsSingleVariableDateFlag = false;

    public SGSXYMultipleVariableNetCDFData() {
    }

    public SGSXYMultipleVariableNetCDFData(SGNetCDFFile sGNetCDFFile, SGDataSourceObserver sGDataSourceObserver, String[] stringArray, String[] stringArray2, String string, String string2) {
        super(sGNetCDFFile, sGDataSourceObserver, string, string2);
        SGVariable sGVariable;
        Object object;
        if (stringArray == null || stringArray2 == null) {
            throw new IllegalArgumentException("xNames == null || yNames == null");
        }
        int n = stringArray.length;
        if (n == 0) {
            throw new IllegalArgumentException("The number of variables for x-values is equal to zero.");
        }
        int n2 = stringArray2.length;
        if (n2 == 0) {
            throw new IllegalArgumentException("The number of variables for y-values is equal to zero.");
        }
        if (!this.isValidXYNames(sGNetCDFFile, stringArray, stringArray2)) {
            throw new IllegalArgumentException("Either one of the two arrays must have only one element.");
        }
        SGVariable[] sGVariableArray = new SGVariable[n];
        for (int i = 0; i < n; ++i) {
            sGVariableArray[i] = sGNetCDFFile.findVariable(stringArray[i]);
            if (sGVariableArray[i] != null) continue;
            throw new IllegalArgumentException("Illegal variable name: " + stringArray[i]);
        }
        SGVariable[] sGVariableArray2 = new SGVariable[n2];
        for (int i = 0; i < n2; ++i) {
            sGVariableArray2[i] = sGNetCDFFile.findVariable(stringArray2[i]);
            if (sGVariableArray2[i] != null) continue;
            throw new IllegalArgumentException("Illegal variable name: " + stringArray2[i]);
        }
        Object object2 = null;
        SGVariable[] sGVariableArray3 = null;
        if (sGVariableArray.length == 1 && sGVariableArray2.length == 1) {
            object = sGVariableArray[0];
            sGVariable = sGVariableArray2[0];
            if (((SGVariable)object).isCoordinateVariable()) {
                object2 = object;
                sGVariableArray3 = sGVariableArray2;
            } else {
                object2 = sGVariable;
                sGVariableArray3 = sGVariableArray;
            }
        } else if (sGVariableArray.length == 1) {
            object2 = sGVariableArray[0];
            sGVariableArray3 = sGVariableArray2;
        } else if (sGVariableArray2.length == 1) {
            object2 = sGVariableArray2[0];
            sGVariableArray3 = sGVariableArray;
        } else {
            throw new IllegalArgumentException("Either of x and y variables must be size one array.");
        }
        object = new ArrayList();
        if (this.mTimeVariable != null) {
            sGVariable = this.mTimeVariable.getDimension(0);
            object.add(sGVariable);
        }
        if (this.mSerialNumberVariable != null) {
            if (((SGVariable)object2).isCoordinateVariable()) {
                throw new IllegalArgumentException("The single variable must not be a coordinate variable.");
            }
            for (int i = 0; i < sGVariableArray3.length; ++i) {
                if (!sGVariableArray3[i].isCoordinateVariable()) continue;
                throw new IllegalArgumentException("The multiple variables must not be coordinate variables.");
            }
            sGVariable = this.mSerialNumberVariable.getDimension(0);
            object.add(sGVariable);
            this.checkNotCoordinateVariable((SGVariable)object2, (List<Dimension>)object);
        } else {
            if (!((SGVariable)object2).isCoordinateVariable()) {
                throw new IllegalArgumentException("The single variable must be a coordinate variable.");
            }
            object.add(((SGVariable)object2).getDimension(0));
        }
        for (int i = 0; i < sGVariableArray3.length; ++i) {
            this.checkNotCoordinateVariable(sGVariableArray3[i], (List<Dimension>)object);
        }
        this.mXVariables = sGVariableArray;
        this.mYVariables = sGVariableArray2;
        this.updateIsSingleVariableDateFlag();
    }

    public SGSXYMultipleVariableNetCDFData(SGNetCDFFile sGNetCDFFile, SGDataSourceObserver sGDataSourceObserver, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5, String[] stringArray6, String[] stringArray7, String string, String string2) {
        this(sGNetCDFFile, sGDataSourceObserver, stringArray, stringArray2, string, string2);
        String[] stringArray8;
        String[] stringArray9 = stringArray8 = stringArray.length == 1 ? stringArray2 : stringArray;
        if (!this.isValidErrorBarNames(sGNetCDFFile, stringArray8, stringArray3, stringArray4, stringArray5)) {
            throw new IllegalArgumentException("Column indices for the error bars are invalid.");
        }
        if (!this.isValidTickLabelNames(sGNetCDFFile, stringArray8, stringArray6, stringArray7)) {
            throw new IllegalArgumentException("Column indices for the tick labels are invalid.");
        }
        SGVariable sGVariable = this.mXVariables.length == 1 ? this.mXVariables[0] : this.mYVariables[0];
        ArrayList<Dimension> arrayList = new ArrayList<Dimension>();
        arrayList.add(sGVariable.getDimension(0));
        if (this.mTimeVariable != null) {
            arrayList.add(this.mTimeVariable.getDimension(0));
        }
        if (this.mSerialNumberVariable != null) {
            arrayList.add(this.mSerialNumberVariable.getDimension(0));
        }
        boolean bl = stringArray3 != null && stringArray3.length != 0;
        boolean bl2 = stringArray6 != null && stringArray6.length != 0;
        SGVariable[] sGVariableArray = bl ? this.getVariables(stringArray3, sGNetCDFFile, arrayList) : null;
        SGVariable[] sGVariableArray2 = bl ? this.getVariables(stringArray4, sGNetCDFFile, arrayList) : null;
        SGVariable[] sGVariableArray3 = bl ? this.getVariables(stringArray5, sGNetCDFFile, arrayList) : null;
        SGVariable[] sGVariableArray4 = bl2 ? this.getVariables(stringArray6, sGNetCDFFile, arrayList) : null;
        SGVariable[] sGVariableArray5 = bl2 ? this.getVariables(stringArray7, sGNetCDFFile, arrayList) : null;
        this.mLowerErrorVariables = sGVariableArray;
        this.mUpperErrorVariables = sGVariableArray2;
        this.mErrorBarHolderVariables = sGVariableArray3;
        this.mTickLabelVariables = sGVariableArray4;
        this.mTickLabelHolderVariables = sGVariableArray5;
    }

    private boolean isValidXYNames(SGNetCDFFile sGNetCDFFile, String[] stringArray, String[] stringArray2) {
        if (stringArray.length == 0 || stringArray2.length == 0) {
            return false;
        }
        if (stringArray.length != 1 && stringArray2.length != 1) {
            return false;
        }
        if (!this.isValidNames(sGNetCDFFile, stringArray)) {
            return false;
        }
        return this.isValidNames(sGNetCDFFile, stringArray2);
    }

    private boolean isValidErrorBarNames(SGNetCDFFile sGNetCDFFile, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4) {
        if (stringArray2 != null && stringArray3 != null) {
            if (!this.isValidNames(sGNetCDFFile, stringArray2)) {
                return false;
            }
            if (!this.isValidNames(sGNetCDFFile, stringArray3)) {
                return false;
            }
            if (stringArray2.length != stringArray3.length) {
                return false;
            }
            if (stringArray4 != null) {
                if (!this.isValidNames(sGNetCDFFile, stringArray4)) {
                    return false;
                }
                if (stringArray4.length != stringArray2.length) {
                    return false;
                }
            }
        }
        return true;
    }

    private boolean isValidTickLabelNames(SGNetCDFFile sGNetCDFFile, String[] stringArray, String[] stringArray2, String[] stringArray3) {
        if (stringArray2 != null) {
            if (!this.isValidNames(sGNetCDFFile, stringArray2)) {
                return false;
            }
            if (stringArray3 != null) {
                if (!this.isValidNames(sGNetCDFFile, stringArray3)) {
                    return false;
                }
                if (stringArray3.length != stringArray2.length) {
                    return false;
                }
            }
        }
        return true;
    }

    private boolean isValidNames(SGNetCDFFile sGNetCDFFile, String[] stringArray) {
        if (stringArray == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) {
                return false;
            }
            if (sGNetCDFFile.findVariable(stringArray[i]) != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.mXVariables = null;
        this.mYVariables = null;
        this.mLowerErrorVariables = null;
        this.mUpperErrorVariables = null;
        this.mTickLabelVariables = null;
        this.mTickLabelHolderVariables = null;
    }

    @Override
    protected boolean hasMultipleYValues() {
        return this.mXVariables.length == 1;
    }

    public SGVariable[] getMultipleVariables() {
        if (this.hasMultipleYValues()) {
            return this.mYVariables;
        }
        return this.mXVariables;
    }

    @Override
    public SGVariable getSingleVariable() {
        if (this.hasMultipleYValues()) {
            return this.mXVariables[0];
        }
        return this.mYVariables[0];
    }

    @Override
    protected String getDataTypeForDataSet() {
        return "SXY_MULTIPLE";
    }

    @Override
    public String[] getCurrentColumnType() {
        List<SGVariable> list = this.mNCFile.getVariables();
        int n = list.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            SGVariable sGVariable = list.get(i);
            int n2 = this.find(sGVariable, this.mLowerErrorVariables);
            int n3 = this.find(sGVariable, this.mUpperErrorVariables);
            int n4 = this.find(sGVariable, this.mTickLabelVariables);
            if (this.find(sGVariable, this.mXVariables) != -1) {
                stringArray[i] = "X";
                continue;
            }
            if (this.find(sGVariable, this.mYVariables) != -1) {
                stringArray[i] = "Y";
                continue;
            }
            if (n2 != -1 || n3 != -1) {
                String string = null;
                int n5 = -1;
                if (n2 == n3) {
                    string = "Lower / Upper Error";
                    n5 = n2;
                } else if (n2 != -1) {
                    string = "Lower Error";
                    n5 = n2;
                } else if (n3 != -1) {
                    string = "Upper Error";
                    n5 = n3;
                }
                if (string == null) {
                    return null;
                }
                int n6 = this.mNCFile.getVariableIndex(this.mErrorBarHolderVariables[n5].getName());
                if (n6 == -1) {
                    return null;
                }
                stringArray[i] = SGDataUtility.appendColumnTitle(string, this.mErrorBarHolderVariables[n5].getName());
                continue;
            }
            if (n4 != -1) {
                int n7 = this.mNCFile.getVariableIndex(this.mTickLabelHolderVariables[n4].getName());
                if (n7 == -1) {
                    return null;
                }
                stringArray[i] = SGDataUtility.appendColumnTitle("Tick Label", this.mTickLabelHolderVariables[n4].getName());
                continue;
            }
            stringArray[i] = sGVariable.equals(this.mTimeVariable) ? "Time" : (sGVariable.equals(this.mSerialNumberVariable) ? "SerialNumbers" : "");
        }
        return stringArray;
    }

    @Override
    public SGVariable[] getVariables() {
        int n;
        ArrayList<SGVariable> arrayList = new ArrayList<SGVariable>();
        for (n = 0; n < this.mXVariables.length; ++n) {
            arrayList.add(this.mXVariables[n]);
        }
        for (n = 0; n < this.mYVariables.length; ++n) {
            arrayList.add(this.mYVariables[n]);
        }
        if (this.mLowerErrorVariables != null) {
            for (n = 0; n < this.mLowerErrorVariables.length; ++n) {
                arrayList.add(this.mLowerErrorVariables[n]);
            }
        }
        if (this.mUpperErrorVariables != null) {
            for (n = 0; n < this.mUpperErrorVariables.length; ++n) {
                arrayList.add(this.mUpperErrorVariables[n]);
            }
        }
        if (this.mTickLabelVariables != null) {
            for (n = 0; n < this.mTickLabelVariables.length; ++n) {
                arrayList.add(this.mTickLabelVariables[n]);
            }
        }
        if (this.mTimeVariable != null) {
            arrayList.add(this.mTimeVariable);
        }
        if (this.mSerialNumberVariable != null) {
            arrayList.add(this.mSerialNumberVariable);
        }
        SGVariable[] sGVariableArray = new SGVariable[arrayList.size()];
        return arrayList.toArray(sGVariableArray);
    }

    public SGVariable[] getXVariables() {
        return this.getVariables(this.mXVariables);
    }

    public SGVariable[] getYVariables() {
        return this.getVariables(this.mYVariables);
    }

    public SGVariable[] getLowerErrorVariables() {
        return this.getVariables(this.mLowerErrorVariables);
    }

    public SGVariable[] getUpperErrorVariables() {
        return this.getVariables(this.mUpperErrorVariables);
    }

    public SGVariable[] getErrorHolderVariables() {
        return this.getVariables(this.mErrorBarHolderVariables);
    }

    public SGVariable[] getTickLabelVariables() {
        return this.getVariables(this.mTickLabelVariables);
    }

    public SGVariable[] getTickLabelHolderVariables() {
        return this.getVariables(this.mTickLabelHolderVariables);
    }

    private SGVariable[] getVariables(SGVariable[] sGVariableArray) {
        if (sGVariableArray != null) {
            return (SGVariable[])sGVariableArray.clone();
        }
        return null;
    }

    @Override
    public boolean setColumnType(String[] stringArray) {
        SGVariable[] sGVariableArray;
        Object object;
        Object object2;
        String string;
        int n;
        Object object3;
        ArrayList<SGVariable> arrayList = new ArrayList<SGVariable>();
        ArrayList<SGVariable> arrayList2 = new ArrayList<SGVariable>();
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        ArrayList<Object> arrayList4 = new ArrayList<Object>();
        ArrayList<Object> arrayList5 = new ArrayList<Object>();
        Object object4 = null;
        Object object5 = null;
        ArrayList<String> arrayList6 = new ArrayList<String>();
        ArrayList<String> arrayList7 = new ArrayList<String>();
        ArrayList<String> arrayList8 = new ArrayList<String>();
        List<SGVariable> list = this.mNCFile.getVariables();
        for (int i = 0; i < stringArray.length; ++i) {
            object3 = list.get(i);
            if (SGUtilityText.isEqualString("X", stringArray[i])) {
                arrayList.add((SGVariable)object3);
                continue;
            }
            if (SGUtilityText.isEqualString("Y", stringArray[i])) {
                arrayList2.add((SGVariable)object3);
                continue;
            }
            if (SGUtilityText.startsWith(stringArray[i], "Lower Error")) {
                arrayList3.add(object3);
                arrayList6.add(stringArray[i]);
                continue;
            }
            if (SGUtilityText.startsWith(stringArray[i], "Upper Error")) {
                arrayList4.add(object3);
                arrayList7.add(stringArray[i]);
                continue;
            }
            if (SGUtilityText.startsWith(stringArray[i], "Lower / Upper Error")) {
                arrayList3.add(object3);
                arrayList4.add(object3);
                arrayList6.add(stringArray[i]);
                arrayList7.add(stringArray[i]);
                continue;
            }
            if (SGUtilityText.startsWith(stringArray[i], "Tick Label")) {
                arrayList5.add(object3);
                arrayList8.add(stringArray[i]);
                continue;
            }
            if (SGUtilityText.isEqualString("Time", stringArray[i])) {
                object4 = object3;
                continue;
            }
            if (SGUtilityText.isEqualString("SerialNumbers", stringArray[i])) {
                object5 = object3;
                continue;
            }
            if ("".equals(stringArray[i])) continue;
            return false;
        }
        if (arrayList.size() == 0 || arrayList2.size() == 0) {
            return false;
        }
        if (arrayList.size() != 1 && arrayList2.size() != 1) {
            return false;
        }
        if (arrayList3.size() != arrayList4.size()) {
            return false;
        }
        ArrayList<SGVariable[]> arrayList9 = new ArrayList<SGVariable[]>();
        object3 = new ArrayList();
        for (n = 0; n < arrayList4.size(); ++n) {
            string = (String)arrayList7.get(n);
            object2 = SGDataUtility.getColumnIndexOfNetCDFAppendedColumnTitle(string, this.mNCFile);
            if (object2 == null) {
                return false;
            }
            object3.add(object2);
        }
        for (n = 0; n < arrayList3.size(); ++n) {
            string = (String)arrayList6.get(n);
            object2 = SGDataUtility.getColumnIndexOfNetCDFAppendedColumnTitle(string, this.mNCFile);
            if (object2 == null) {
                return false;
            }
            if (!object3.contains(object2)) {
                return false;
            }
            object = list.get(object2.intValue());
            arrayList9.add((SGVariable[])object);
        }
        ArrayList<SGVariable[]> arrayList10 = new ArrayList<SGVariable[]>();
        for (int i = 0; i < arrayList5.size(); ++i) {
            object2 = (String)arrayList8.get(i);
            object = SGDataUtility.getColumnIndexOfNetCDFAppendedColumnTitle((String)object2, this.mNCFile);
            if (object == null) {
                return false;
            }
            sGVariableArray = list.get(object.intValue());
            arrayList10.add(sGVariableArray);
        }
        SGVariable[] sGVariableArray2 = arrayList.toArray(new SGVariable[arrayList.size()]);
        object2 = arrayList2.toArray(new SGVariable[arrayList2.size()]);
        object = null;
        sGVariableArray = null;
        SGVariable[] sGVariableArray3 = null;
        if (arrayList3.size() != 0) {
            object = arrayList3.toArray(new SGVariable[arrayList3.size()]);
            sGVariableArray = arrayList4.toArray(new SGVariable[arrayList4.size()]);
            sGVariableArray3 = arrayList9.toArray(new SGVariable[arrayList9.size()]);
        }
        SGVariable[] sGVariableArray4 = null;
        SGVariable[] sGVariableArray5 = null;
        if (arrayList5.size() != 0) {
            sGVariableArray4 = arrayList5.toArray(new SGVariable[arrayList5.size()]);
            sGVariableArray5 = arrayList10.toArray(new SGVariable[arrayList10.size()]);
        }
        this.mXVariables = sGVariableArray2;
        this.mYVariables = object2;
        this.mLowerErrorVariables = object;
        this.mUpperErrorVariables = sGVariableArray;
        this.mErrorBarHolderVariables = sGVariableArray3;
        this.mTickLabelVariables = sGVariableArray4;
        this.mTickLabelHolderVariables = sGVariableArray5;
        this.mTimeVariable = object4;
        this.mSerialNumberVariable = object5;
        this.updateIsSingleVariableDateFlag();
        return true;
    }

    @Override
    public boolean setData(SGData sGData) {
        if (!(sGData instanceof SGSXYMultipleVariableNetCDFData)) {
            throw new IllegalArgumentException("Given data is not the instance of SGSXYMultipleNetCDFData class.");
        }
        if (!super.setData(sGData)) {
            return false;
        }
        SGSXYMultipleVariableNetCDFData sGSXYMultipleVariableNetCDFData = (SGSXYMultipleVariableNetCDFData)sGData;
        this.mXVariables = (SGVariable[])sGSXYMultipleVariableNetCDFData.mXVariables.clone();
        this.mYVariables = (SGVariable[])sGSXYMultipleVariableNetCDFData.mYVariables.clone();
        this.updateIsSingleVariableDateFlag();
        if (sGSXYMultipleVariableNetCDFData.isErrorBarAvailable()) {
            this.mLowerErrorVariables = (SGVariable[])sGSXYMultipleVariableNetCDFData.mLowerErrorVariables.clone();
            this.mUpperErrorVariables = (SGVariable[])sGSXYMultipleVariableNetCDFData.mUpperErrorVariables.clone();
            this.mErrorBarHolderVariables = (SGVariable[])sGSXYMultipleVariableNetCDFData.mErrorBarHolderVariables.clone();
        }
        if (sGSXYMultipleVariableNetCDFData.mTickLabelVariables != null) {
            this.mTickLabelVariables = (SGVariable[])sGSXYMultipleVariableNetCDFData.mTickLabelVariables.clone();
            this.mTickLabelHolderVariables = (SGVariable[])sGSXYMultipleVariableNetCDFData.mTickLabelHolderVariables.clone();
        }
        return true;
    }

    @Override
    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof SXYMultipleVariableNetCDFDataProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        SXYMultipleVariableNetCDFDataProperties sXYMultipleVariableNetCDFDataProperties = (SXYMultipleVariableNetCDFDataProperties)sGProperties;
        SGVariable[] sGVariableArray = new SGVariable[sXYMultipleVariableNetCDFDataProperties.xNames.length];
        for (int i = 0; i < sGVariableArray.length; ++i) {
            sGVariableArray[i] = this.mNCFile.findVariable(sXYMultipleVariableNetCDFDataProperties.xNames[i]);
        }
        SGVariable[] sGVariableArray2 = new SGVariable[sXYMultipleVariableNetCDFDataProperties.yNames.length];
        for (int i = 0; i < sGVariableArray2.length; ++i) {
            sGVariableArray2[i] = this.mNCFile.findVariable(sXYMultipleVariableNetCDFDataProperties.yNames[i]);
        }
        SGVariable[] sGVariableArray3 = null;
        if (sXYMultipleVariableNetCDFDataProperties.lNames != null) {
            sGVariableArray3 = new SGVariable[sXYMultipleVariableNetCDFDataProperties.lNames.length];
            for (int i = 0; i < sGVariableArray3.length; ++i) {
                sGVariableArray3[i] = this.mNCFile.findVariable(sXYMultipleVariableNetCDFDataProperties.lNames[i]);
            }
        }
        SGVariable[] sGVariableArray4 = null;
        if (sXYMultipleVariableNetCDFDataProperties.uNames != null) {
            sGVariableArray4 = new SGVariable[sXYMultipleVariableNetCDFDataProperties.uNames.length];
            for (int i = 0; i < sGVariableArray4.length; ++i) {
                sGVariableArray4[i] = this.mNCFile.findVariable(sXYMultipleVariableNetCDFDataProperties.uNames[i]);
            }
        }
        SGVariable[] sGVariableArray5 = null;
        if (sXYMultipleVariableNetCDFDataProperties.ehNames != null) {
            sGVariableArray5 = new SGVariable[sXYMultipleVariableNetCDFDataProperties.ehNames.length];
            for (int i = 0; i < sGVariableArray5.length; ++i) {
                sGVariableArray5[i] = this.mNCFile.findVariable(sXYMultipleVariableNetCDFDataProperties.ehNames[i]);
            }
        }
        SGVariable[] sGVariableArray6 = null;
        if (sXYMultipleVariableNetCDFDataProperties.tNames != null) {
            sGVariableArray6 = new SGVariable[sXYMultipleVariableNetCDFDataProperties.tNames.length];
            for (int i = 0; i < sGVariableArray6.length; ++i) {
                sGVariableArray6[i] = this.mNCFile.findVariable(sXYMultipleVariableNetCDFDataProperties.tNames[i]);
            }
        }
        SGVariable[] sGVariableArray7 = null;
        if (sXYMultipleVariableNetCDFDataProperties.thNames != null) {
            sGVariableArray7 = new SGVariable[sXYMultipleVariableNetCDFDataProperties.thNames.length];
            for (int i = 0; i < sGVariableArray7.length; ++i) {
                sGVariableArray7[i] = this.mNCFile.findVariable(sXYMultipleVariableNetCDFDataProperties.thNames[i]);
            }
        }
        this.mXVariables = sGVariableArray;
        this.mYVariables = sGVariableArray2;
        this.mLowerErrorVariables = sGVariableArray3;
        this.mUpperErrorVariables = sGVariableArray4;
        this.mErrorBarHolderVariables = sGVariableArray5;
        this.mTickLabelVariables = sGVariableArray6;
        this.mTickLabelHolderVariables = sGVariableArray7;
        this.updateIsSingleVariableDateFlag();
        return true;
    }

    @Override
    public SGProperties getProperties() {
        SXYMultipleVariableNetCDFDataProperties sXYMultipleVariableNetCDFDataProperties = new SXYMultipleVariableNetCDFDataProperties();
        if (!this.getProperties(sXYMultipleVariableNetCDFDataProperties)) {
            return null;
        }
        return sXYMultipleVariableNetCDFDataProperties;
    }

    @Override
    public boolean getProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof SXYMultipleVariableNetCDFDataProperties)) {
            return false;
        }
        if (!super.getProperties(sGProperties)) {
            return false;
        }
        SXYMultipleVariableNetCDFDataProperties sXYMultipleVariableNetCDFDataProperties = (SXYMultipleVariableNetCDFDataProperties)sGProperties;
        String[] stringArray = new String[this.mXVariables.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.mXVariables[i].getName();
        }
        String[] stringArray2 = new String[this.mYVariables.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = this.mYVariables[i].getName();
        }
        String[] stringArray3 = null;
        String[] stringArray4 = null;
        String[] stringArray5 = null;
        if (this.isErrorBarAvailable()) {
            int n;
            stringArray3 = new String[this.mLowerErrorVariables.length];
            for (n = 0; n < stringArray3.length; ++n) {
                stringArray3[n] = this.mLowerErrorVariables[n].getName();
            }
            stringArray4 = new String[this.mUpperErrorVariables.length];
            for (n = 0; n < stringArray4.length; ++n) {
                stringArray4[n] = this.mUpperErrorVariables[n].getName();
            }
            stringArray5 = new String[this.mErrorBarHolderVariables.length];
            for (n = 0; n < stringArray5.length; ++n) {
                stringArray5[n] = this.mErrorBarHolderVariables[n].getName();
            }
        }
        String[] stringArray6 = null;
        String[] stringArray7 = null;
        if (this.mTickLabelVariables != null) {
            int n;
            stringArray6 = new String[this.mTickLabelVariables.length];
            for (n = 0; n < stringArray6.length; ++n) {
                stringArray6[n] = this.mTickLabelVariables[n].getName();
            }
            stringArray7 = new String[this.mTickLabelHolderVariables.length];
            for (n = 0; n < stringArray7.length; ++n) {
                stringArray7[n] = this.mTickLabelHolderVariables[n].getName();
            }
        }
        sXYMultipleVariableNetCDFDataProperties.xNames = stringArray;
        sXYMultipleVariableNetCDFDataProperties.yNames = stringArray2;
        sXYMultipleVariableNetCDFDataProperties.lNames = stringArray3;
        sXYMultipleVariableNetCDFDataProperties.uNames = stringArray4;
        sXYMultipleVariableNetCDFDataProperties.ehNames = stringArray5;
        sXYMultipleVariableNetCDFDataProperties.tNames = stringArray6;
        sXYMultipleVariableNetCDFDataProperties.thNames = stringArray7;
        return true;
    }

    @Override
    public boolean readProperty(Element element) {
        SGVariable sGVariable;
        if (!super.readProperty(element)) {
            return false;
        }
        String string = null;
        String[] stringArray = null;
        SGVariable[] sGVariableArray = null;
        SGVariable[] sGVariableArray2 = null;
        SGVariable[] sGVariableArray3 = null;
        SGVariable[] sGVariableArray4 = null;
        SGVariable[] sGVariableArray5 = null;
        SGVariable[] sGVariableArray6 = null;
        SGVariable[] sGVariableArray7 = null;
        string = element.getAttribute("XValueNames");
        if (string.length() != 0) {
            sGVariable = this.mNCFile.findVariable(string);
            if (sGVariable == null) {
                return false;
            }
        } else {
            return false;
        }
        sGVariableArray = this.readVariables(stringArray);
        string = element.getAttribute("YValueNames");
        if (string.length() != 0) {
            sGVariable = this.mNCFile.findVariable(string);
            if (sGVariable == null) {
                return false;
            }
        } else {
            return false;
        }
        sGVariableArray2 = this.readVariables(stringArray);
        stringArray = this.readNames(element, "LowerErrorValueNames");
        if (stringArray != null && (sGVariableArray3 = this.readVariables(stringArray)) == null) {
            return false;
        }
        stringArray = this.readNames(element, "UpperErrorValueNames");
        if (stringArray != null && (sGVariableArray4 = this.readVariables(stringArray)) == null) {
            return false;
        }
        stringArray = this.readNames(element, "ErrorBarHolderNames");
        if (stringArray != null && (sGVariableArray5 = this.readVariables(stringArray)) == null) {
            return false;
        }
        if (!(sGVariableArray3 == null && sGVariableArray4 == null && sGVariableArray5 == null || sGVariableArray3 != null && sGVariableArray4 != null && sGVariableArray5 != null)) {
            return false;
        }
        stringArray = this.readNames(element, "TickLabelNames");
        if (stringArray != null && (sGVariableArray6 = this.readVariables(stringArray)) == null) {
            return false;
        }
        stringArray = this.readNames(element, "TickLabelHolderNames");
        if (stringArray != null && (sGVariableArray7 = this.readVariables(stringArray)) == null) {
            return false;
        }
        if (!(sGVariableArray6 == null && sGVariableArray7 == null || sGVariableArray6 != null && sGVariableArray7 != null)) {
            return false;
        }
        this.mXVariables = sGVariableArray;
        this.mYVariables = sGVariableArray2;
        this.mLowerErrorVariables = sGVariableArray3;
        this.mUpperErrorVariables = sGVariableArray4;
        this.mErrorBarHolderVariables = sGVariableArray5;
        this.mTickLabelVariables = sGVariableArray6;
        this.mTickLabelHolderVariables = sGVariableArray7;
        this.updateIsSingleVariableDateFlag();
        return true;
    }

    protected SGVariable[] readVariables(String[] stringArray) {
        SGVariable[] sGVariableArray = new SGVariable[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            SGVariable sGVariable = this.mNCFile.findVariable(stringArray[i]);
            if (sGVariable == null) {
                return null;
            }
            sGVariableArray[i] = sGVariable;
        }
        return sGVariableArray;
    }

    @Override
    protected double[][] getDataSetValues() {
        double[][] dArray = this.getXValueArray();
        double[][] dArray2 = this.getYValueArray();
        int n = dArray.length;
        double[][] dArrayArray = new double[n][];
        for (int i = 0; i < n; ++i) {
            int n2;
            dArrayArray[i] = new double[dArray.length + dArray2.length];
            for (n2 = 0; n2 < dArray.length; ++n2) {
                dArrayArray[i][n2] = dArray[n2][i];
            }
            for (n2 = 0; n2 < dArray2.length; ++n2) {
                dArrayArray[i][n2 + dArray.length] = dArray2[n2][i];
            }
        }
        return dArrayArray;
    }

    protected String bindVariableNamesInBracket(SGVariable[] sGVariableArray) {
        StringBuffer stringBuffer = new StringBuffer("{");
        for (int i = 0; i < sGVariableArray.length; ++i) {
            stringBuffer.append(sGVariableArray[i].getOriginalName());
            if (i == sGVariableArray.length - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    @Override
    public boolean writeProperty(Element element, int n) {
        if (!super.writeProperty(element, n)) {
            return false;
        }
        String string = null;
        string = this.bindVariableNamesInBracket(this.mXVariables);
        element.setAttribute("XValueNames", string);
        string = this.bindVariableNamesInBracket(this.mYVariables);
        element.setAttribute("YValueNames", string);
        if (this.isErrorBarAvailable()) {
            string = this.bindVariableNamesInBracket(this.mLowerErrorVariables);
            element.setAttribute("LowerErrorValueNames", string);
            string = this.bindVariableNamesInBracket(this.mUpperErrorVariables);
            element.setAttribute("UpperErrorValueNames", string);
            string = this.bindVariableNamesInBracket(this.mErrorBarHolderVariables);
            element.setAttribute("ErrorBarHolderNames", string);
        }
        if (this.mTickLabelVariables != null) {
            string = this.bindVariableNamesInBracket(this.mTickLabelVariables);
            element.setAttribute("TickLabelNames", string);
            string = this.bindVariableNamesInBracket(this.mTickLabelHolderVariables);
            element.setAttribute("TickLabelHolderNames", string);
        }
        return true;
    }

    @Override
    public String getDataType() {
        return "SXY_MULTIPLE_NETCDF";
    }

    @Override
    public SGISXYTypeData[] getSXYDataArray() {
        SGVariable sGVariable = this.getSingleVariable();
        SGVariable[] sGVariableArray = this.getMultipleVariables();
        int n = sGVariableArray.length;
        String string = sGVariable.getName();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = sGVariableArray[i].getName();
        }
        String string2 = this.mTimeVariable != null ? this.mTimeVariable.getName() : null;
        String string3 = this.mSerialNumberVariable != null ? this.mSerialNumberVariable.getName() : null;
        List<SGVariable> list = this.mNCFile.getVariables();
        boolean bl = this.hasMultipleYValues();
        boolean bl2 = this.isErrorBarAvailable();
        boolean bl3 = this.mTickLabelVariables != null;
        SGISXYTypeData[] sGISXYTypeDataArray = new SGISXYTypeData[n];
        for (int i = 0; i < sGISXYTypeDataArray.length; ++i) {
            Object object;
            String string4;
            String string5 = bl ? string : stringArray[i];
            String string6 = bl ? stringArray[i] : string;
            String string7 = null;
            String string8 = null;
            String string9 = null;
            if (bl2) {
                for (int j = 0; j < this.mErrorBarHolderVariables.length; ++j) {
                    string4 = this.mErrorBarHolderVariables[j].getName();
                    if (!string5.equals(string4) && !string6.equals(string4)) continue;
                    string9 = string4;
                    string7 = this.mLowerErrorVariables[j].getName();
                    string8 = this.mUpperErrorVariables[j].getName();
                    break;
                }
            }
            String string10 = null;
            string4 = null;
            if (bl3) {
                for (int j = 0; j < this.mTickLabelHolderVariables.length; ++j) {
                    object = this.mTickLabelHolderVariables[j].getName();
                    if (!string5.equals(object) && !string6.equals(object)) continue;
                    string4 = object;
                    string10 = this.mTickLabelVariables[j].getName();
                    break;
                }
            }
            SGSXYNetCDFData sGSXYNetCDFData = this.mNCFile.findVariable(string5) instanceof SGDateVariable || this.mNCFile.findVariable(string6) instanceof SGDateVariable ? new SGSXYNetCDFDateData(this.mNCFile, this.mObserver, string5, string6, string7, string8, string9, string10, string4, string2, string3) : new SGSXYNetCDFData(this.mNCFile, this.mObserver, string5, string6, string7, string8, string9, string10, string4, string2, string3);
            for (SGVariable sGVariable2 : list) {
                String string11;
                if (!sGVariable2.isCoordinateVariable() || !this.mOriginMap.containsKey(string11 = sGVariable2.getName())) continue;
                int n2 = (Integer)this.mOriginMap.get(string11);
                sGSXYNetCDFData.setOrigin(string11, n2);
            }
            object = sGSXYNetCDFData;
            ((SGNetCDFData)object).setCacheMap(this.mVariableCache);
            sGISXYTypeDataArray[i] = sGSXYNetCDFData;
        }
        return sGISXYTypeDataArray;
    }

    @Override
    public int getSXYDataNumMax() {
        int n = 0;
        List<SGVariable> list = this.mNCFile.getVariables();
        for (SGVariable sGVariable : list) {
            if (!sGVariable.isCoordinateVariable()) continue;
            Dimension dimension = sGVariable.getDimension(0);
            int n2 = 0;
            for (SGVariable sGVariable2 : list) {
                List<Dimension> list2 = sGVariable2.getDimensions();
                if (!list2.contains(dimension)) continue;
                ++n2;
            }
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    @Override
    public Double getXValue(int n, int n2) {
        int n3 = this.getPointsNumber();
        if (n2 < 0 || n2 >= n3) {
            throw new IllegalArgumentException("given index is out of bounds: " + n2);
        }
        if (n < 0 || n >= this.mXVariables.length) {
            throw new IllegalArgumentException("given index is out of bounds: " + n);
        }
        return super.getXValue(n, n2);
    }

    @Override
    public Double getYValue(int n, int n2) {
        int n3 = this.getPointsNumber();
        if (n2 < 0 || n2 >= n3) {
            throw new IllegalArgumentException("given index is out of bounds: " + n2);
        }
        if (n < 0 || n >= this.mYVariables.length) {
            throw new IllegalArgumentException("given index is out of bounds: " + n);
        }
        return super.getYValue(n, n2);
    }

    @Override
    protected double[][] getMultipleVariableValueArray() {
        SGVariable[] sGVariableArray = new SGVariable[]{this.getCoordinateVariable()};
        SGVariable[] sGVariableArray2 = this.getMultipleVariables();
        double[][] dArrayArray = new double[sGVariableArray2.length][];
        for (int i = 0; i < dArrayArray.length; ++i) {
            dArrayArray[i] = !sGVariableArray2[i].isCoordinateVariable() ? this.getValueArray(sGVariableArray2[i], sGVariableArray) : this.getCoordinateValueArray(sGVariableArray2[i]);
        }
        return dArrayArray;
    }

    @Override
    public String getTitleX() {
        if (this.mXVariables.length == 1 && this.mYVariables.length == 1) {
            return this.getNameWithUnit(this.mXVariables[0]);
        }
        if (this.hasMultipleYValues()) {
            return this.getNameWithUnit(this.mXVariables[0]);
        }
        return "";
    }

    @Override
    public String getTitleY() {
        if (this.mXVariables.length == 1 && this.mYVariables.length == 1) {
            return this.getNameWithUnit(this.mYVariables[0]);
        }
        if (this.hasMultipleYValues()) {
            return "";
        }
        return this.getNameWithUnit(this.mYVariables[0]);
    }

    @Override
    public boolean isErrorBarAvailable() {
        return this.mLowerErrorVariables != null && this.mUpperErrorVariables != null;
    }

    @Override
    public boolean isTickLabelAvailable() {
        if (this.mIsSingleVariableDateFlag) {
            return true;
        }
        return this.mTickLabelVariables != null;
    }

    @Override
    public Boolean isErrorBarVertical() {
        if (this.isErrorBarAvailable()) {
            return SGUtility.contains((Object[])this.mErrorBarHolderVariables, this.mYVariables);
        }
        return null;
    }

    @Override
    public Boolean isTickLabelHorizontal() {
        if (this.mIsSingleVariableDateFlag) {
            if (this.hasMultipleYValues() && this.mXVariables[0] instanceof SGDateVariable) {
                return true;
            }
            return false;
        }
        if (this.isTickLabelAvailable()) {
            return SGUtility.contains((Object[])this.mTickLabelHolderVariables, this.mYVariables);
        }
        return null;
    }

    @Override
    public Map<String, Object> getInfoMap() {
        Map<String, Object> map = super.getInfoMap();
        map.put("Multiple", Boolean.TRUE);
        map.put("Graphs for multiple variables", Boolean.TRUE);
        if (null != this.mDimensionStart) {
            map.put("Multiple dimension start", this.mDimensionStart);
        }
        if (null != this.mDimensionEnd) {
            map.put("Multiple dimension end", this.mDimensionEnd);
        }
        if (null != this.mDimensionStep) {
            map.put("Multiple dimension step", this.mDimensionStep);
        }
        return map;
    }

    @Override
    public SGISXYTypeMultipleData[] getSXYTypeMultipleDataArray() {
        SGISXYTypeData[] sGISXYTypeDataArray = this.getSXYDataArray();
        SGISXYTypeMultipleData[] sGISXYTypeMultipleDataArray = new SGISXYTypeMultipleData[sGISXYTypeDataArray.length];
        for (int i = 0; i < sGISXYTypeDataArray.length; ++i) {
            SGSXYNetCDFData sGSXYNetCDFData = (SGSXYNetCDFData)sGISXYTypeDataArray[i];
            sGISXYTypeMultipleDataArray[i] = sGSXYNetCDFData.toMultiple();
            sGSXYNetCDFData.dispose();
        }
        return sGISXYTypeMultipleDataArray;
    }

    @Override
    public boolean isSplitEnabled() {
        SGVariable[] sGVariableArray = this.getMultipleVariables();
        int n = sGVariableArray.length;
        return n > 1;
    }

    public static SGISXYTypeMultipleData merge(List<SGData> list) {
        Object object;
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3;
        Object[] objectArray4;
        String[] stringArray;
        Cloneable cloneable22;
        if (list.size() == 0) {
            return null;
        }
        for (Cloneable cloneable22 : list) {
            if (cloneable22 instanceof SGSXYMultipleVariableNetCDFData) continue;
            return null;
        }
        SGSXYMultipleVariableNetCDFData sGSXYMultipleVariableNetCDFData = (SGSXYMultipleVariableNetCDFData)list.get(list.size() - 1);
        cloneable22 = sGSXYMultipleVariableNetCDFData.getNetcdfFile();
        SGDataSourceObserver sGDataSourceObserver = sGSXYMultipleVariableNetCDFData.mObserver;
        String string = sGSXYMultipleVariableNetCDFData.isTimeVariableAvailable() ? sGSXYMultipleVariableNetCDFData.getTimeVariable().getName() : null;
        String string2 = sGSXYMultipleVariableNetCDFData.isSerialNumberAvailable() ? sGSXYMultipleVariableNetCDFData.getSerialNumberVariable().getName() : null;
        TreeSet<String> treeSet = new TreeSet<String>();
        TreeSet<String> treeSet2 = new TreeSet<String>();
        TreeSet<String> treeSet3 = new TreeSet<String>();
        TreeSet<String> treeSet4 = new TreeSet<String>();
        TreeSet<String> treeSet5 = new TreeSet<String>();
        TreeSet<String> treeSet6 = new TreeSet<String>();
        TreeSet<String> treeSet7 = new TreeSet<String>();
        for (SGData stringArray22 : list) {
            int n;
            stringArray = (String[])stringArray22;
            objectArray4 = stringArray.getXVariables();
            objectArray3 = stringArray.getYVariables();
            objectArray2 = stringArray.getLowerErrorVariables();
            objectArray = stringArray.getUpperErrorVariables();
            object = stringArray.getErrorHolderVariables();
            SGVariable[] sGVariableArray = stringArray.getTickLabelVariables();
            SGVariable[] sGVariableArray2 = stringArray.getTickLabelHolderVariables();
            if (null != objectArray4) {
                for (n = 0; n < objectArray4.length; ++n) {
                    treeSet.add(((SGVariable)objectArray4[n]).getName());
                }
            }
            if (null != objectArray3) {
                for (n = 0; n < objectArray3.length; ++n) {
                    treeSet2.add(((SGVariable)objectArray3[n]).getName());
                }
            }
            if (null != objectArray2) {
                for (n = 0; n < objectArray2.length; ++n) {
                    treeSet3.add(((SGVariable)objectArray2[n]).getName());
                }
            }
            if (null != objectArray) {
                for (n = 0; n < objectArray.length; ++n) {
                    treeSet4.add(((SGVariable)objectArray[n]).getName());
                }
            }
            if (null != object) {
                for (n = 0; n < ((SGVariable[])object).length; ++n) {
                    treeSet5.add(object[n].getName());
                }
            }
            if (null != sGVariableArray) {
                for (n = 0; n < sGVariableArray.length; ++n) {
                    treeSet6.add(sGVariableArray[n].getName());
                }
            }
            if (null == sGVariableArray2) continue;
            for (n = 0; n < sGVariableArray2.length; ++n) {
                treeSet7.add(sGVariableArray2[n].getName());
            }
        }
        String[] stringArray3 = new String[treeSet.size()];
        String[] stringArray2 = new String[treeSet2.size()];
        stringArray = new String[treeSet3.size()];
        objectArray4 = new String[treeSet4.size()];
        objectArray3 = new String[treeSet5.size()];
        objectArray2 = new String[treeSet6.size()];
        objectArray = new String[treeSet7.size()];
        treeSet.toArray(stringArray3);
        treeSet2.toArray(stringArray2);
        treeSet3.toArray(stringArray);
        treeSet4.toArray(objectArray4);
        treeSet5.toArray(objectArray3);
        treeSet6.toArray(objectArray2);
        treeSet7.toArray(objectArray);
        object = new SGSXYMultipleVariableNetCDFData((SGNetCDFFile)cloneable22, sGDataSourceObserver, stringArray3, stringArray2, stringArray, (String[])objectArray4, (String[])objectArray3, (String[])objectArray2, (String[])objectArray, string, string2);
        ((SGSXYMultipleVariableNetCDFData)object).mOriginMap = new HashMap(sGSXYMultipleVariableNetCDFData.mOriginMap);
        ((SGSXYMultipleNetCDFData)object).setDecimalPlaces(sGSXYMultipleVariableNetCDFData.getDecimalPlaces());
        ((SGSXYMultipleNetCDFData)object).setExponent(sGSXYMultipleVariableNetCDFData.getExponent());
        return object;
    }

    private void updateIsSingleVariableDateFlag() {
        this.mIsSingleVariableDateFlag = this.mXVariables.length == 1 && this.mXVariables[0] instanceof SGDateVariable ? true : this.mYVariables.length == 1 && this.mYVariables[0] instanceof SGDateVariable;
    }

    @Override
    public boolean isXVariableCoordinate() {
        if (this.getXVariables().length == 1) {
            return this.getXVariables()[0].isCoordinateVariable();
        }
        return false;
    }

    public static class SXYMultipleVariableNetCDFDataProperties
    extends SGNetCDFData.NetCDFDataProperties {
        protected String[] xNames = null;
        protected String[] yNames = null;
        protected String[] lNames = null;
        protected String[] uNames = null;
        protected String[] ehNames = null;
        protected String[] tNames = null;
        protected String[] thNames = null;

        public void dispose() {
            super.dispose();
            this.xNames = null;
            this.yNames = null;
            this.lNames = null;
            this.uNames = null;
            this.ehNames = null;
            this.tNames = null;
            this.thNames = null;
        }

        public boolean equals(Object object) {
            if (!(object instanceof SXYMultipleVariableNetCDFDataProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            SXYMultipleVariableNetCDFDataProperties sXYMultipleVariableNetCDFDataProperties = (SXYMultipleVariableNetCDFDataProperties)object;
            if (!SGUtility.equals(this.xNames, sXYMultipleVariableNetCDFDataProperties.xNames)) {
                return false;
            }
            if (!SGUtility.equals(this.yNames, sXYMultipleVariableNetCDFDataProperties.yNames)) {
                return false;
            }
            if (!SGUtility.equals(this.lNames, sXYMultipleVariableNetCDFDataProperties.lNames)) {
                return false;
            }
            if (!SGUtility.equals(this.uNames, sXYMultipleVariableNetCDFDataProperties.uNames)) {
                return false;
            }
            if (!SGUtility.equals(this.ehNames, sXYMultipleVariableNetCDFDataProperties.ehNames)) {
                return false;
            }
            if (!SGUtility.equals(this.tNames, sXYMultipleVariableNetCDFDataProperties.tNames)) {
                return false;
            }
            return SGUtility.equals(this.thNames, sXYMultipleVariableNetCDFDataProperties.thNames);
        }
    }
}

