/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.data;

import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2d;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.base.SGValueRange;
import jp.riken.brain.ni.samuraigraph.data.SGArrayData;
import jp.riken.brain.ni.samuraigraph.data.SGDataColumn;
import jp.riken.brain.ni.samuraigraph.data.SGDataSourceObserver;
import jp.riken.brain.ni.samuraigraph.data.SGDataUtility;
import jp.riken.brain.ni.samuraigraph.data.SGIDataColumnNameConstants;
import jp.riken.brain.ni.samuraigraph.data.SGIDataColumnTypeConstants;
import jp.riken.brain.ni.samuraigraph.data.SGISXYZTypeData;
import jp.riken.brain.ni.samuraigraph.data.SGNumberDataColumn;
import jp.riken.brain.ni.samuraigraph.data.SGTextDataFile;
import org.w3c.dom.Element;

public class SGSXYZData
extends SGArrayData
implements SGISXYZTypeData,
SGIDataColumnTypeConstants,
SGIDataColumnNameConstants {
    protected Integer mXIndex = null;
    protected Integer mYIndex = null;
    protected Integer mZIndex = null;

    public SGSXYZData() {
    }

    public SGSXYZData(SGTextDataFile sGTextDataFile, SGDataSourceObserver sGDataSourceObserver, Integer n, Integer n2, Integer n3) {
        super(sGTextDataFile, sGDataSourceObserver);
        if (n == null || n2 == null || n3 == null) {
            throw new IllegalArgumentException("Indices for values must not be null.");
        }
        if (!this.checkColumnIndexRange(n)) {
            throw new IllegalArgumentException("Index out of bounds: " + n);
        }
        if (!this.checkColumnIndexRange(n2)) {
            throw new IllegalArgumentException("Index out of bounds: " + n2);
        }
        if (!this.checkColumnIndexRange(n3)) {
            throw new IllegalArgumentException("Index out of bounds: " + n3);
        }
        this.mXIndex = n;
        this.mYIndex = n2;
        this.mZIndex = n3;
    }

    public SGSXYZData(SGData sGData) {
        this.setData(sGData);
    }

    public void dispose() {
        super.dispose();
        this.mXIndex = null;
        this.mYIndex = null;
        this.mZIndex = null;
    }

    public boolean setData(SGData sGData) {
        if (!(sGData instanceof SGSXYZData)) {
            throw new IllegalArgumentException("!(data instanceof SGSXYZData)");
        }
        if (!super.setData(sGData)) {
            return false;
        }
        SGSXYZData sGSXYZData = (SGSXYZData)sGData;
        this.mXIndex = sGSXYZData.mXIndex;
        this.mYIndex = sGSXYZData.mYIndex;
        this.mZIndex = sGSXYZData.mZIndex;
        return true;
    }

    public double[] getXValueArray() {
        return this.getXArray();
    }

    public double[] getYValueArray() {
        return this.getYArray();
    }

    public double[] getZValueArray() {
        return this.getZArray();
    }

    public SGTuple2d[] getXYValueArray() {
        double[] dArray = this.getXArray();
        double[] dArray2 = this.getYArray();
        SGTuple2d[] sGTuple2dArray = new SGTuple2d[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            sGTuple2dArray[i] = new SGTuple2d(dArray[i], dArray2[i]);
        }
        return sGTuple2dArray;
    }

    protected double[] getXArray() {
        SGDataColumn[] sGDataColumnArray = this.mDataFile.mDataColumns;
        SGNumberDataColumn sGNumberDataColumn = (SGNumberDataColumn)sGDataColumnArray[this.mXIndex];
        return sGNumberDataColumn.getNumberArray();
    }

    protected double[] getYArray() {
        SGDataColumn[] sGDataColumnArray = this.mDataFile.mDataColumns;
        SGNumberDataColumn sGNumberDataColumn = (SGNumberDataColumn)sGDataColumnArray[this.mYIndex];
        return sGNumberDataColumn.getNumberArray();
    }

    protected double[] getZArray() {
        SGDataColumn[] sGDataColumnArray = this.mDataFile.mDataColumns;
        SGNumberDataColumn sGNumberDataColumn = (SGNumberDataColumn)sGDataColumnArray[this.mZIndex];
        return sGNumberDataColumn.getNumberArray();
    }

    public int getPointsNumber() {
        return this.getXYValueArray().length;
    }

    public String getDataType() {
        return "SXYZ";
    }

    public String[] getCurrentColumnType() {
        int n = this.getColNum();
        String[] stringArray = new String[n];
        if (this.mXIndex != null) {
            stringArray[this.mXIndex.intValue()] = "X";
        }
        if (this.mYIndex != null) {
            stringArray[this.mYIndex.intValue()] = "Y";
        }
        if (this.mZIndex != null) {
            stringArray[this.mZIndex.intValue()] = "Z";
        }
        return stringArray;
    }

    protected SGDataColumn[] getDataSetColumns() {
        SGDataColumn[] sGDataColumnArray = this.mDataFile.mDataColumns;
        SGDataColumn[] sGDataColumnArray2 = new SGDataColumn[]{sGDataColumnArray[this.mXIndex], sGDataColumnArray[this.mYIndex], sGDataColumnArray[this.mZIndex]};
        sGDataColumnArray2[0].setColumnType("X");
        sGDataColumnArray2[1].setColumnType("Y");
        sGDataColumnArray2[2].setColumnType("Z");
        return sGDataColumnArray2;
    }

    public SGDataColumn[] getUsedDataColumnsClone() {
        return this.getDataSetColumnsClone();
    }

    public boolean setColumnType(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("columns == null");
        }
        Integer n = null;
        Integer n2 = null;
        Integer n3 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (SGUtilityText.isEqualString("X", stringArray[i])) {
                n = i;
                continue;
            }
            if (SGUtilityText.isEqualString("Y", stringArray[i])) {
                n2 = i;
                continue;
            }
            if (SGUtilityText.isEqualString("Z", stringArray[i])) {
                n3 = i;
                continue;
            }
            if ("".equals(stringArray[i])) continue;
            return false;
        }
        if (n == null || n2 == null || n3 == null) {
            return false;
        }
        this.mXIndex = n;
        this.mYIndex = n2;
        this.mZIndex = n3;
        return true;
    }

    public SGProperties getProperties() {
        SXYZDataProperties sXYZDataProperties = new SXYZDataProperties();
        if (!this.getProperties(sXYZDataProperties)) {
            return null;
        }
        return sXYZDataProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof SXYZDataProperties)) {
            return false;
        }
        if (!super.getProperties(sGProperties)) {
            return false;
        }
        SXYZDataProperties sXYZDataProperties = (SXYZDataProperties)sGProperties;
        sXYZDataProperties.mXIndex = this.mXIndex;
        sXYZDataProperties.mYIndex = this.mYIndex;
        sXYZDataProperties.mZIndex = this.mZIndex;
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof SXYZDataProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        SXYZDataProperties sXYZDataProperties = (SXYZDataProperties)sGProperties;
        this.mXIndex = sXYZDataProperties.mXIndex;
        this.mYIndex = sXYZDataProperties.mYIndex;
        this.mZIndex = sXYZDataProperties.mZIndex;
        return true;
    }

    protected boolean writeAttributeColumnIndices(Element element) {
        element.setAttribute("XValueIndex", this.mXIndex.toString());
        element.setAttribute("YValueIndex", this.mYIndex.toString());
        element.setAttribute("ZValueIndex", this.mZIndex.toString());
        return true;
    }

    protected boolean writeSequentialColumnIndices(Element element) {
        element.setAttribute("XValueIndex", Integer.toString(0));
        element.setAttribute("YValueIndex", Integer.toString(1));
        element.setAttribute("ZValueIndex", Integer.toString(2));
        return true;
    }

    protected boolean writeSequentialColumnName(Element element) {
        element.setAttribute("XValueIndex", this.getSequentialColumnName(0));
        element.setAttribute("YValueIndex", this.getSequentialColumnName(1));
        element.setAttribute("ZValueIndex", this.getSequentialColumnName(2));
        element.setAttribute("SerialNumberVariableName", "SerialNumbers");
        return true;
    }

    public boolean readProperty(Element element) {
        Integer n = null;
        Integer n2 = null;
        Integer n3 = null;
        Integer n4 = null;
        n = this.readIndex(element, "XValueIndex");
        if (n != null) {
            if (!this.checkColumnIndexRange(n)) {
                return false;
            }
        } else {
            return false;
        }
        n2 = n;
        n = this.readIndex(element, "YValueIndex");
        if (n != null) {
            if (!this.checkColumnIndexRange(n)) {
                return false;
            }
        } else {
            return false;
        }
        n3 = n;
        n = this.readIndex(element, "ZValueIndex");
        if (n != null) {
            if (!this.checkColumnIndexRange(n)) {
                return false;
            }
        } else {
            return false;
        }
        n4 = n;
        this.mXIndex = n2;
        this.mYIndex = n3;
        this.mZIndex = n4;
        return true;
    }

    public SGValueRange getBoundsX() {
        return SGDataUtility.getBoundsX(this);
    }

    public SGValueRange getBoundsY() {
        return SGDataUtility.getBoundsY(this);
    }

    public SGValueRange getBoundsZ() {
        return SGDataUtility.getBoundsZ(this);
    }

    public String getTitleX() {
        if (this.mXIndex == null) {
            return "";
        }
        SGDataColumn[] sGDataColumnArray = this.mDataFile.mDataColumns;
        return sGDataColumnArray[this.mXIndex].getTitle();
    }

    public String getTitleY() {
        if (this.mYIndex == null) {
            return "";
        }
        SGDataColumn[] sGDataColumnArray = this.mDataFile.mDataColumns;
        return sGDataColumnArray[this.mYIndex].getTitle();
    }

    public String getTitleZ() {
        if (this.mZIndex == null) {
            return "";
        }
        SGDataColumn[] sGDataColumnArray = this.mDataFile.mDataColumns;
        return sGDataColumnArray[this.mZIndex].getTitle();
    }

    public SGDataColumn getXColumn() {
        return this.getColumn(this.mXIndex);
    }

    public SGDataColumn getYColumn() {
        return this.getColumn(this.mYIndex);
    }

    public SGDataColumn getZColumn() {
        return this.getColumn(this.mZIndex);
    }

    public static class SXYZDataProperties
    extends SGArrayData.ArrayDataProperties {
        Integer mXIndex = null;
        Integer mYIndex = null;
        Integer mZIndex = null;

        public boolean equals(Object object) {
            if (!(object instanceof SXYZDataProperties)) {
                return false;
            }
            SXYZDataProperties sXYZDataProperties = (SXYZDataProperties)object;
            if (this.mXIndex != null ? !this.mXIndex.equals(sXYZDataProperties.mXIndex) : sXYZDataProperties.mXIndex != null) {
                return false;
            }
            if (this.mYIndex != null ? !this.mYIndex.equals(sXYZDataProperties.mYIndex) : sXYZDataProperties.mYIndex != null) {
                return false;
            }
            return !(this.mZIndex != null ? !this.mZIndex.equals(sXYZDataProperties.mZIndex) : sXYZDataProperties.mZIndex != null);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[");
            stringBuffer.append("XIndex=");
            stringBuffer.append(this.mXIndex);
            stringBuffer.append(", YIndex=");
            stringBuffer.append(this.mYIndex);
            stringBuffer.append(", ZIndex=");
            stringBuffer.append(this.mZIndex);
            stringBuffer.append("]");
            return stringBuffer.toString();
        }

        public void dispose() {
            super.dispose();
            this.mXIndex = null;
            this.mYIndex = null;
            this.mZIndex = null;
        }
    }
}

