/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.data;

import java.util.ArrayList;
import java.util.List;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2d;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.base.SGValueRange;
import jp.riken.brain.ni.samuraigraph.data.SGDataSourceObserver;
import jp.riken.brain.ni.samuraigraph.data.SGDataUtility;
import jp.riken.brain.ni.samuraigraph.data.SGIDataColumnNameConstants;
import jp.riken.brain.ni.samuraigraph.data.SGIDataColumnTypeConstants;
import jp.riken.brain.ni.samuraigraph.data.SGISXYZTypeData;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFData;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFFile;
import jp.riken.brain.ni.samuraigraph.data.SGVariable;
import org.w3c.dom.Element;
import ucar.ma2.Array;
import ucar.nc2.Dimension;

public class SGSXYZNetCDFData
extends SGNetCDFData
implements SGISXYZTypeData,
SGIDataColumnTypeConstants,
SGIDataColumnNameConstants {
    protected SGVariable mXVariable = null;
    protected SGVariable mYVariable = null;
    protected SGVariable mZVariable = null;

    public SGSXYZNetCDFData() {
    }

    public SGSXYZNetCDFData(SGNetCDFFile sGNetCDFFile, SGDataSourceObserver sGDataSourceObserver, String string, String string2, String string3, String string4, String string5) {
        super(sGNetCDFFile, sGDataSourceObserver, string4, string5);
        if (string == null || string2 == null || string3 == null) {
            throw new IllegalArgumentException("xName == null || yName == null || zName == null");
        }
        SGVariable sGVariable = sGNetCDFFile.findVariable(string);
        if (sGVariable == null) {
            throw new IllegalArgumentException("Illegal variable name: " + string);
        }
        SGVariable sGVariable2 = sGNetCDFFile.findVariable(string2);
        if (sGVariable2 == null) {
            throw new IllegalArgumentException("Illegal variable name: " + string2);
        }
        SGVariable sGVariable3 = sGNetCDFFile.findVariable(string3);
        if (sGVariable3 == null) {
            throw new IllegalArgumentException("Illegal variable name: " + string3);
        }
        ArrayList<Dimension> arrayList = new ArrayList<Dimension>();
        if (this.mTimeVariable != null) {
            arrayList.add(this.mTimeVariable.getDimension(0));
        }
        if (this.isSerialNumberAvailable()) {
            if (sGVariable.isCoordinateVariable() || sGVariable2.isCoordinateVariable() || sGVariable3.isCoordinateVariable()) {
                throw new IllegalArgumentException("x, y and z variables must not be coordinate variables.");
            }
            Dimension dimension = this.mSerialNumberVariable.getDimension(0);
            arrayList.add(dimension);
            this.checkNotCoordinateVariable(sGVariable, arrayList);
            this.checkNotCoordinateVariable(sGVariable2, arrayList);
        } else {
            if (!sGVariable.isCoordinateVariable() || !sGVariable2.isCoordinateVariable()) {
                throw new IllegalArgumentException("x and y variables must be coordinate variable.");
            }
            if (sGVariable3.isCoordinateVariable()) {
                throw new IllegalArgumentException("z variable must not be a coordinate variable.");
            }
            arrayList.add(sGVariable.getDimension(0));
            arrayList.add(sGVariable2.getDimension(0));
        }
        this.checkNotCoordinateVariable(sGVariable3, arrayList);
        this.mXVariable = sGVariable;
        this.mYVariable = sGVariable2;
        this.mZVariable = sGVariable3;
    }

    public void dispose() {
        super.dispose();
        this.mXVariable = null;
        this.mYVariable = null;
        this.mZVariable = null;
        this.mVariableCache.clear();
    }

    public String[] getCurrentColumnType() {
        List<SGVariable> list = this.mNCFile.getVariables();
        int n = list.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            SGVariable sGVariable = list.get(i);
            stringArray[i] = sGVariable.equals(this.mXVariable) ? "X" : (sGVariable.equals(this.mYVariable) ? "Y" : (sGVariable.equals(this.mZVariable) ? "Z" : (sGVariable.equals(this.mTimeVariable) ? "Time" : (sGVariable.equals(this.mSerialNumberVariable) ? "SerialNumbers" : ""))));
        }
        return stringArray;
    }

    protected String getDataTypeForDataSet() {
        return "SXYZ";
    }

    public SGVariable[] getVariables() {
        ArrayList<SGVariable> arrayList = new ArrayList<SGVariable>();
        arrayList.add(this.mXVariable);
        arrayList.add(this.mYVariable);
        arrayList.add(this.mZVariable);
        if (this.mTimeVariable != null) {
            arrayList.add(this.mTimeVariable);
        }
        if (this.mSerialNumberVariable != null) {
            arrayList.add(this.mSerialNumberVariable);
        }
        SGVariable[] sGVariableArray = new SGVariable[arrayList.size()];
        return arrayList.toArray(sGVariableArray);
    }

    public SGVariable getXVariable() {
        return this.mXVariable;
    }

    public SGVariable getYVariable() {
        return this.mYVariable;
    }

    public SGVariable getZVariable() {
        return this.mZVariable;
    }

    public boolean setColumnType(String[] stringArray) {
        SGVariable sGVariable = null;
        SGVariable sGVariable2 = null;
        SGVariable sGVariable3 = null;
        SGVariable sGVariable4 = null;
        SGVariable sGVariable5 = null;
        List<SGVariable> list = this.mNCFile.getVariables();
        for (int i = 0; i < stringArray.length; ++i) {
            SGVariable sGVariable6 = list.get(i);
            if (SGUtilityText.isEqualString("X", stringArray[i])) {
                sGVariable = sGVariable6;
                continue;
            }
            if (SGUtilityText.isEqualString("Y", stringArray[i])) {
                sGVariable2 = sGVariable6;
                continue;
            }
            if (SGUtilityText.isEqualString("Z", stringArray[i])) {
                sGVariable3 = sGVariable6;
                continue;
            }
            if (SGUtilityText.isEqualString("Time", stringArray[i])) {
                sGVariable4 = sGVariable6;
                continue;
            }
            if (SGUtilityText.isEqualString("SerialNumbers", stringArray[i])) {
                sGVariable5 = sGVariable6;
                continue;
            }
            if ("".equals(stringArray[i])) continue;
            return false;
        }
        if (sGVariable == null || sGVariable2 == null || sGVariable3 == null) {
            return false;
        }
        this.mXVariable = sGVariable;
        this.mYVariable = sGVariable2;
        this.mZVariable = sGVariable3;
        this.mTimeVariable = sGVariable4;
        this.mSerialNumberVariable = sGVariable5;
        return true;
    }

    public boolean setData(SGData sGData) {
        if (!(sGData instanceof SGSXYZNetCDFData)) {
            throw new IllegalArgumentException("Given data is not the instance of SGSXYZNetCDFData class.");
        }
        if (!super.setData(sGData)) {
            return false;
        }
        SGSXYZNetCDFData sGSXYZNetCDFData = (SGSXYZNetCDFData)sGData;
        this.mXVariable = sGSXYZNetCDFData.mXVariable;
        this.mYVariable = sGSXYZNetCDFData.mYVariable;
        this.mZVariable = sGSXYZNetCDFData.mZVariable;
        return true;
    }

    public SGProperties getProperties() {
        SXYZNetCDFDataProperties sXYZNetCDFDataProperties = new SXYZNetCDFDataProperties();
        if (!this.getProperties(sXYZNetCDFDataProperties)) {
            return null;
        }
        return sXYZNetCDFDataProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof SXYZNetCDFDataProperties)) {
            return false;
        }
        if (!super.getProperties(sGProperties)) {
            return false;
        }
        SXYZNetCDFDataProperties sXYZNetCDFDataProperties = (SXYZNetCDFDataProperties)sGProperties;
        sXYZNetCDFDataProperties.xName = this.mXVariable.getName();
        sXYZNetCDFDataProperties.yName = this.mYVariable.getName();
        sXYZNetCDFDataProperties.zName = this.mZVariable.getName();
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof SXYZNetCDFDataProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        SXYZNetCDFDataProperties sXYZNetCDFDataProperties = (SXYZNetCDFDataProperties)sGProperties;
        this.mXVariable = this.mNCFile.findVariable(sXYZNetCDFDataProperties.xName);
        this.mYVariable = this.mNCFile.findVariable(sXYZNetCDFDataProperties.yName);
        this.mZVariable = this.mNCFile.findVariable(sXYZNetCDFDataProperties.zName);
        return true;
    }

    public boolean writeProperty(Element element, int n) {
        if (!super.writeProperty(element, n)) {
            return false;
        }
        element.setAttribute("XValueName", this.mXVariable.getName());
        element.setAttribute("YValueName", this.mYVariable.getName());
        element.setAttribute("ZValueName", this.mZVariable.getName());
        return true;
    }

    public boolean readProperty(Element element) {
        if (!super.readProperty(element)) {
            return false;
        }
        String string = null;
        SGVariable sGVariable = null;
        SGVariable sGVariable2 = null;
        SGVariable sGVariable3 = null;
        string = element.getAttribute("XValueName");
        if (string.length() != 0) {
            sGVariable = this.mNCFile.findVariable(string);
            if (sGVariable == null) {
                return false;
            }
        } else {
            return false;
        }
        string = element.getAttribute("YValueName");
        if (string.length() != 0) {
            sGVariable2 = this.mNCFile.findVariable(string);
            if (sGVariable2 == null) {
                return false;
            }
        } else {
            return false;
        }
        string = element.getAttribute("ZValueName");
        if (string.length() != 0) {
            sGVariable3 = this.mNCFile.findVariable(string);
            if (sGVariable3 == null) {
                return false;
            }
        } else {
            return false;
        }
        this.mXVariable = sGVariable;
        this.mYVariable = sGVariable2;
        this.mZVariable = sGVariable3;
        return true;
    }

    public String getDataType() {
        return "SXYZ_NETCDF";
    }

    public double[][] getDataSetValues() {
        SGTuple2d[] sGTuple2dArray = this.getXYValueArray();
        double[] dArray = this.getZValueArray();
        int n = sGTuple2dArray.length;
        double[][] dArrayArray = new double[n][];
        for (int i = 0; i < n; ++i) {
            dArrayArray[i] = new double[3];
            dArrayArray[i][0] = sGTuple2dArray[i].x;
            dArrayArray[i][1] = sGTuple2dArray[i].y;
            dArrayArray[i][2] = dArray[i];
        }
        return dArrayArray;
    }

    public int getPointsNumber() {
        int n;
        if (this.isSerialNumberAvailable()) {
            Dimension dimension = this.mSerialNumberVariable.getDimension(0);
            n = dimension.getLength();
        } else {
            Dimension dimension = this.mXVariable.getDimension(0);
            Dimension dimension2 = this.mYVariable.getDimension(0);
            n = dimension.getLength() * dimension2.getLength();
        }
        return n;
    }

    public double[] getXValueArray() {
        if (this.isSerialNumberAvailable()) {
            return this.getValueArray(this.mXVariable, new SGVariable[]{this.mSerialNumberVariable});
        }
        return this.getCoordinateValueArray(this.mXVariable);
    }

    public double[] getYValueArray() {
        if (this.isSerialNumberAvailable()) {
            return this.getValueArray(this.mYVariable, new SGVariable[]{this.mSerialNumberVariable});
        }
        return this.getCoordinateValueArray(this.mYVariable);
    }

    public double[] getZValueArray() {
        if (this.isSerialNumberAvailable()) {
            return this.getValueArray(this.mZVariable, new SGVariable[]{this.mSerialNumberVariable});
        }
        return this.getValueArray(this.mZVariable, new SGVariable[]{this.mXVariable, this.mYVariable});
    }

    public SGTuple2d[] getXYValueArray() {
        double[] dArray = this.getXValueArray();
        double[] dArray2 = this.getYValueArray();
        if (this.isSerialNumberAvailable()) {
            int n = dArray.length;
            SGTuple2d[] sGTuple2dArray = new SGTuple2d[n];
            for (int i = 0; i < n; ++i) {
                sGTuple2dArray[i] = new SGTuple2d(dArray[i], dArray2[i]);
            }
            return sGTuple2dArray;
        }
        SGTuple2d[] sGTuple2dArray = new SGTuple2d[dArray.length * dArray2.length];
        for (int i = 0; i < dArray2.length; ++i) {
            for (int j = 0; j < dArray.length; ++j) {
                int n = i * dArray.length + j;
                sGTuple2dArray[n] = new SGTuple2d(dArray[j], dArray2[i]);
            }
        }
        return sGTuple2dArray;
    }

    public SGValueRange getBoundsX() {
        return SGDataUtility.getBoundsX(this);
    }

    public SGValueRange getBoundsY() {
        return SGDataUtility.getBoundsY(this);
    }

    public SGValueRange getBoundsZ() {
        return SGDataUtility.getBoundsZ(this);
    }

    public String getTitleX() {
        return this.getNameWithUnit(this.mXVariable);
    }

    public String getTitleY() {
        return this.getNameWithUnit(this.mYVariable);
    }

    public String getTitleZ() {
        return this.getNameWithUnit(this.mZVariable);
    }

    protected Double[] arrangeValueArray(Array array, SGVariable sGVariable, SGVariable[] sGVariableArray) {
        if (this.isSerialNumberAvailable()) {
            return this.arrange1Dim(array);
        }
        return this.arrange2Dim(array, sGVariable, sGVariableArray);
    }

    public static class SXYZNetCDFDataProperties
    extends SGNetCDFData.NetCDFDataProperties {
        protected String xName = null;
        protected String yName = null;
        protected String zName = null;

        public void dispose() {
            super.dispose();
            this.xName = null;
            this.yName = null;
            this.zName = null;
        }

        public boolean equals(Object object) {
            if (!(object instanceof SXYZNetCDFDataProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            SXYZNetCDFDataProperties sXYZNetCDFDataProperties = (SXYZNetCDFDataProperties)object;
            if (!SGUtility.equals(this.xName, sXYZNetCDFDataProperties.xName)) {
                return false;
            }
            if (!SGUtility.equals(this.yName, sXYZNetCDFDataProperties.yName)) {
                return false;
            }
            return SGUtility.equals(this.zName, sXYZNetCDFDataProperties.zName);
        }
    }
}

