/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.data;

import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.data.SGDataColumn;

public class SGTextDataColumn
extends SGDataColumn {
    protected String[] mArray = null;

    public SGTextDataColumn(String string, String[] stringArray) {
        super(string);
        if (stringArray == null) {
            throw new IllegalArgumentException("array == null");
        }
        this.mArray = SGUtility.copyStringArray(stringArray);
    }

    public int getLength() {
        return this.mArray.length;
    }

    public String getValueType() {
        return "Text";
    }

    public void dispose() {
        super.dispose();
        this.mArray = null;
    }

    String[] getTextArray() {
        return this.mArray;
    }

    public Object getValue(int n) {
        if (n > this.mArray.length) {
            throw new IllegalArgumentException("Index out of bounds: " + n + " > " + this.mArray.length);
        }
        return this.mArray[n];
    }

    public String[] getStringArray() {
        return (String[])this.mArray.clone();
    }

    protected Object getExportedValue(int n) {
        Object object = this.getValue(n);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\"');
        stringBuffer.append(object.toString());
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }
}

