/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.data;

import java.util.ArrayList;
import jp.riken.brain.ni.samuraigraph.base.SGIDataSource;
import jp.riken.brain.ni.samuraigraph.data.SGDataColumn;

public class SGTextDataFile
implements SGIDataSource {
    protected SGDataColumn[] mDataColumns = null;
    protected final String filePath;
    private boolean mDisposed = false;

    public SGTextDataFile(String string, SGDataColumn[] sGDataColumnArray) {
        int n;
        this.filePath = string;
        if (sGDataColumnArray == null) {
            throw new IllegalArgumentException("columns == null");
        }
        for (n = 0; n < sGDataColumnArray.length; ++n) {
            if (sGDataColumnArray[n] != null) continue;
            throw new IllegalArgumentException("columnsArray[" + n + "] == null");
        }
        if (sGDataColumnArray.length == 0) {
            throw new IllegalArgumentException("columnsArray.length == 0");
        }
        if (sGDataColumnArray.length > 1) {
            n = sGDataColumnArray[0].getLength();
            for (int i = 1; i < sGDataColumnArray.length; ++i) {
                int n2 = sGDataColumnArray[i].getLength();
                if (n2 == n) continue;
                throw new IllegalArgumentException("Data length is illegal.");
            }
        }
        this.mDataColumns = (SGDataColumn[])sGDataColumnArray.clone();
    }

    public String getPath() {
        return this.filePath;
    }

    public SGDataColumn[] getDataColumns() {
        return (SGDataColumn[])this.mDataColumns.clone();
    }

    public void setDataColumns(SGDataColumn[] sGDataColumnArray) {
        if (sGDataColumnArray == null) {
            throw new IllegalArgumentException("columns == null");
        }
        this.mDataColumns = new SGDataColumn[sGDataColumnArray.length];
        for (int i = 0; i < sGDataColumnArray.length; ++i) {
            this.mDataColumns[i] = (SGDataColumn)sGDataColumnArray[i].clone();
        }
    }

    public Object clone() {
        SGTextDataFile sGTextDataFile = null;
        try {
            sGTextDataFile = (SGTextDataFile)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        if (this.mDataColumns != null) {
            SGDataColumn[] sGDataColumnArray = new SGDataColumn[this.mDataColumns.length];
            for (int i = 0; i < sGDataColumnArray.length; ++i) {
                sGDataColumnArray[i] = (SGDataColumn)this.mDataColumns[i].clone();
            }
            sGTextDataFile.mDataColumns = sGDataColumnArray;
        }
        return sGTextDataFile;
    }

    public void dispose() {
        this.mDisposed = true;
        if (this.mDataColumns != null) {
            for (int i = 0; i < this.mDataColumns.length; ++i) {
                this.mDataColumns[i].dispose();
            }
        }
        this.mDataColumns = null;
    }

    public boolean isDisposed() {
        return this.mDisposed;
    }

    public int getColNum() {
        if (this.mDataColumns == null) {
            return -1;
        }
        return this.mDataColumns.length;
    }

    public int getLength() {
        return this.mDataColumns[0].getLength();
    }

    public int getColNum(Class clazz) {
        SGDataColumn[] sGDataColumnArray = this.mDataColumns;
        int n = 0;
        for (int i = 0; i < sGDataColumnArray.length; ++i) {
            if (!sGDataColumnArray[i].getClass().isAssignableFrom(clazz)) continue;
            ++n;
        }
        return n;
    }

    public int getRowNum() {
        if (this.mDataColumns == null || this.mDataColumns.length == 0) {
            return -1;
        }
        return this.mDataColumns[0].getLength();
    }

    public int[] getIndexArray(Class clazz) {
        SGDataColumn[] sGDataColumnArray = this.mDataColumns;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < sGDataColumnArray.length; ++i) {
            if (!sGDataColumnArray[i].getClass().isAssignableFrom(clazz)) continue;
            arrayList.add(i);
        }
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            Integer n = (Integer)arrayList.get(i);
            nArray[i] = n;
        }
        return nArray;
    }

    public String[] getTitles() {
        SGDataColumn[] sGDataColumnArray = this.mDataColumns;
        String[] stringArray = new String[sGDataColumnArray.length];
        for (int i = 0; i < sGDataColumnArray.length; ++i) {
            stringArray[i] = sGDataColumnArray[i].getTitle();
        }
        return stringArray;
    }

    public String getTitle(int n) {
        SGDataColumn[] sGDataColumnArray = this.mDataColumns;
        if (n < 0 || n >= this.getColNum()) {
            throw new IllegalArgumentException("Index out of bounds: " + n);
        }
        return sGDataColumnArray[n].getTitle();
    }

    public boolean isEmptyTitle(int n) {
        return null == this.getTitle(n) || this.getTitle(n).trim().equals("");
    }

    public boolean isRepeatedTitle(int n) {
        String[] stringArray = this.getTitles();
        if (null == stringArray[n]) {
            return true;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (n == i || !stringArray[n].equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public String[] getValueTypes() {
        SGDataColumn[] sGDataColumnArray = this.mDataColumns;
        String[] stringArray = new String[sGDataColumnArray.length];
        for (int i = 0; i < sGDataColumnArray.length; ++i) {
            stringArray[i] = sGDataColumnArray[i].getValueType();
        }
        return stringArray;
    }

    protected boolean checkColumnIndexRange(Integer n) {
        SGDataColumn[] sGDataColumnArray = this.mDataColumns;
        int n2 = n;
        return 0 <= n2 && n2 < sGDataColumnArray.length;
    }

    protected void setDataColumn(SGDataColumn sGDataColumn, int n) {
        SGDataColumn[] sGDataColumnArray = this.mDataColumns;
        if (n < 0 || n >= sGDataColumnArray.length) {
            throw new IllegalArgumentException("Index out of bounds: " + n);
        }
        sGDataColumnArray[n] = sGDataColumn;
    }
}

