/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.data;

import java.util.HashMap;
import java.util.Map;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2d;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.base.SGValueRange;
import jp.riken.brain.ni.samuraigraph.data.SGArrayData;
import jp.riken.brain.ni.samuraigraph.data.SGDataColumn;
import jp.riken.brain.ni.samuraigraph.data.SGDataSourceObserver;
import jp.riken.brain.ni.samuraigraph.data.SGDataUtility;
import jp.riken.brain.ni.samuraigraph.data.SGIDataColumnNameConstants;
import jp.riken.brain.ni.samuraigraph.data.SGIDataColumnTypeConstants;
import jp.riken.brain.ni.samuraigraph.data.SGIVXYTypeData;
import jp.riken.brain.ni.samuraigraph.data.SGNumberDataColumn;
import jp.riken.brain.ni.samuraigraph.data.SGTextDataFile;
import jp.riken.brain.ni.samuraigraph.data.SGVXYDataUtility;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGVXYData
extends SGArrayData
implements SGIVXYTypeData,
SGIDataColumnTypeConstants,
SGIDataColumnNameConstants {
    protected Integer mXCoordinateIndex = null;
    protected Integer mYCoordinateIndex = null;
    protected Integer mComponentIndex1 = null;
    protected Integer mComponentIndex2 = null;
    private boolean mPolarFlag = false;

    public SGVXYData() {
    }

    public SGVXYData(SGTextDataFile sGTextDataFile, SGDataSourceObserver sGDataSourceObserver, Integer n, Integer n2, Integer n3, Integer n4, boolean bl) {
        super(sGTextDataFile, sGDataSourceObserver);
        if (n == null || n2 == null || n3 == null || n4 == null) {
            throw new IllegalArgumentException("Indices must not be null.");
        }
        if (!this.checkColumnIndexRange(n)) {
            throw new IllegalArgumentException("Index out of bounds: " + n);
        }
        if (!this.checkColumnIndexRange(n2)) {
            throw new IllegalArgumentException("Index out of bounds: " + n2);
        }
        if (!this.checkColumnIndexRange(n3)) {
            throw new IllegalArgumentException("Index out of bounds: " + n3);
        }
        if (!this.checkColumnIndexRange(n4)) {
            throw new IllegalArgumentException("Index out of bounds: " + n4);
        }
        this.mXCoordinateIndex = n;
        this.mYCoordinateIndex = n2;
        this.mComponentIndex1 = n3;
        this.mComponentIndex2 = n4;
        this.mPolarFlag = bl;
    }

    public SGVXYData(SGData sGData) {
        this.setData(sGData);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.mXCoordinateIndex = null;
        this.mYCoordinateIndex = null;
        this.mComponentIndex1 = null;
        this.mComponentIndex2 = null;
    }

    @Override
    public boolean setData(SGData sGData) {
        if (!(sGData instanceof SGVXYData)) {
            return false;
        }
        if (!super.setData(sGData)) {
            return false;
        }
        SGVXYData sGVXYData = (SGVXYData)sGData;
        this.mXCoordinateIndex = sGVXYData.mXCoordinateIndex;
        this.mYCoordinateIndex = sGVXYData.mYCoordinateIndex;
        this.mComponentIndex1 = sGVXYData.mComponentIndex1;
        this.mComponentIndex2 = sGVXYData.mComponentIndex2;
        this.mPolarFlag = sGVXYData.isPolar();
        return true;
    }

    @Override
    public int getPointsNumber() {
        return this.getXArray().length;
    }

    @Override
    public String getDataType() {
        return "VXY";
    }

    @Override
    public SGValueRange getBoundsX() {
        return SGDataUtility.getBoundsX(this);
    }

    @Override
    public SGValueRange getBoundsY() {
        return SGDataUtility.getBoundsY(this);
    }

    @Override
    public double[] getXCoordinateArray() {
        return this.getXArray();
    }

    @Override
    public double[] getYCoordinateArray() {
        return this.getYArray();
    }

    @Override
    public SGTuple2d[] getCoordinateArray() {
        double[] dArray = this.getXArray();
        double[] dArray2 = this.getYArray();
        SGTuple2d[] sGTuple2dArray = new SGTuple2d[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            sGTuple2dArray[i] = new SGTuple2d(dArray[i], dArray2[i]);
        }
        return sGTuple2dArray;
    }

    @Override
    public double[] getXComponentArray() {
        if (this.isPolar()) {
            double[] dArray = this.getComponentArray1();
            double[] dArray2 = this.getComponentArray2();
            return SGVXYDataUtility.getXComponentArray(dArray, dArray2);
        }
        return this.getComponentArray1();
    }

    @Override
    public double[] getYComponentArray() {
        if (this.isPolar()) {
            double[] dArray = this.getComponentArray1();
            double[] dArray2 = this.getComponentArray2();
            return SGVXYDataUtility.getYComponentArray(dArray, dArray2);
        }
        return this.getComponentArray2();
    }

    @Override
    public double[] getMagnitudeArray() {
        if (this.isPolar()) {
            return this.getComponentArray1();
        }
        double[] dArray = this.getComponentArray1();
        double[] dArray2 = this.getComponentArray2();
        return SGVXYDataUtility.getMagnitudeArray(dArray, dArray2);
    }

    @Override
    public double[] getAngleArray() {
        if (this.isPolar()) {
            return this.getComponentArray2();
        }
        double[] dArray = this.getComponentArray1();
        double[] dArray2 = this.getComponentArray2();
        return SGVXYDataUtility.getAngleArray(dArray, dArray2);
    }

    protected double[] getXArray() {
        SGDataColumn[] sGDataColumnArray = this.mDataFile.mDataColumns;
        SGNumberDataColumn sGNumberDataColumn = (SGNumberDataColumn)sGDataColumnArray[this.mXCoordinateIndex];
        return sGNumberDataColumn.getNumberArray();
    }

    protected double[] getYArray() {
        SGDataColumn[] sGDataColumnArray = this.mDataFile.mDataColumns;
        SGNumberDataColumn sGNumberDataColumn = (SGNumberDataColumn)sGDataColumnArray[this.mYCoordinateIndex];
        return sGNumberDataColumn.getNumberArray();
    }

    protected double[] getComponentArray1() {
        SGDataColumn[] sGDataColumnArray = this.mDataFile.mDataColumns;
        SGNumberDataColumn sGNumberDataColumn = (SGNumberDataColumn)sGDataColumnArray[this.mComponentIndex1];
        return sGNumberDataColumn.getNumberArray();
    }

    protected double[] getComponentArray2() {
        SGDataColumn[] sGDataColumnArray = this.mDataFile.mDataColumns;
        SGNumberDataColumn sGNumberDataColumn = (SGNumberDataColumn)sGDataColumnArray[this.mComponentIndex2];
        return sGNumberDataColumn.getNumberArray();
    }

    @Override
    public boolean isPolar() {
        return this.mPolarFlag;
    }

    @Override
    protected boolean writeAttributeColumnIndices(Element element) {
        element.setAttribute("XCoordinateIndex", this.mXCoordinateIndex.toString());
        element.setAttribute("YCoordinateIndex", this.mYCoordinateIndex.toString());
        element.setAttribute("ComponentIndex1", this.mComponentIndex1.toString());
        element.setAttribute("ComponentIndex2", this.mComponentIndex2.toString());
        return true;
    }

    @Override
    protected boolean writeSequentialColumnIndices(Element element) {
        element.setAttribute("XCoordinateIndex", Integer.toString(0));
        element.setAttribute("YCoordinateIndex", Integer.toString(1));
        element.setAttribute("ComponentIndex1", Integer.toString(2));
        element.setAttribute("ComponentIndex2", Integer.toString(3));
        return true;
    }

    @Override
    protected boolean writeSequentialColumnName(Element element) {
        element.setAttribute("XCoordinateIndex", this.getSequentialColumnName(0));
        element.setAttribute("YCoordinateIndex", this.getSequentialColumnName(1));
        element.setAttribute("ComponentIndex1", this.getSequentialColumnName(2));
        element.setAttribute("ComponentIndex2", this.getSequentialColumnName(3));
        element.setAttribute("SerialNumberVariableName", "SerialNumbers");
        return true;
    }

    @Override
    public boolean readProperty(Element element) {
        Integer n = null;
        n = this.readIndex(element, "XCoordinateIndex");
        if (n != null) {
            if (!this.checkColumnIndexRange(n)) {
                return false;
            }
        } else {
            return false;
        }
        this.mXCoordinateIndex = n;
        n = this.readIndex(element, "YCoordinateIndex");
        if (n != null) {
            if (!this.checkColumnIndexRange(n)) {
                return false;
            }
        } else {
            return false;
        }
        this.mYCoordinateIndex = n;
        n = this.readIndex(element, "ComponentIndex1");
        if (n != null) {
            if (!this.checkColumnIndexRange(n)) {
                return false;
            }
        } else {
            return false;
        }
        this.mComponentIndex1 = n;
        n = this.readIndex(element, "ComponentIndex2");
        if (n != null) {
            if (!this.checkColumnIndexRange(n)) {
                return false;
            }
        } else {
            return false;
        }
        this.mComponentIndex2 = n;
        return true;
    }

    @Override
    public Map<String, Object> getInfoMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("Polar selected", this.isPolar());
        return hashMap;
    }

    @Override
    public String getTitleX() {
        if (this.mXCoordinateIndex == null) {
            return "";
        }
        SGDataColumn[] sGDataColumnArray = this.mDataFile.mDataColumns;
        return sGDataColumnArray[this.mXCoordinateIndex].getTitle();
    }

    @Override
    public String getTitleY() {
        if (this.mYCoordinateIndex == null) {
            return "";
        }
        SGDataColumn[] sGDataColumnArray = this.mDataFile.mDataColumns;
        return sGDataColumnArray[this.mYCoordinateIndex].getTitle();
    }

    public Integer getXCoordinateIndex() {
        return this.mXCoordinateIndex;
    }

    public Integer getYCoordinateIndex() {
        return this.mYCoordinateIndex;
    }

    public Integer getComponentIndex1() {
        return this.mComponentIndex1;
    }

    public Integer getComponentIndex2() {
        return this.mComponentIndex2;
    }

    public void setXCoordinateIndex(Integer n) {
        if (!this.checkColumnIndexRange(n)) {
            throw new IllegalArgumentException("Index out of bounds: " + n);
        }
        this.mXCoordinateIndex = n;
    }

    public void setYCoordinateIndex(Integer n) {
        if (!this.checkColumnIndexRange(n)) {
            throw new IllegalArgumentException("Index out of bounds: " + n);
        }
        this.mYCoordinateIndex = n;
    }

    public void setComponentIndex1(Integer n) {
        if (!this.checkColumnIndexRange(n)) {
            throw new IllegalArgumentException("Index out of bounds: " + n);
        }
        this.mComponentIndex1 = n;
    }

    public void setComponentIndex2(Integer n) {
        if (!this.checkColumnIndexRange(n)) {
            throw new IllegalArgumentException("Index out of bounds: " + n);
        }
        this.mComponentIndex2 = n;
    }

    @Override
    public SGProperties getProperties() {
        VXYDataProperties vXYDataProperties = new VXYDataProperties();
        if (!this.getProperties(vXYDataProperties)) {
            return null;
        }
        return vXYDataProperties;
    }

    @Override
    public boolean getProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof VXYDataProperties)) {
            return false;
        }
        if (!super.getProperties(sGProperties)) {
            return false;
        }
        VXYDataProperties vXYDataProperties = (VXYDataProperties)sGProperties;
        vXYDataProperties.mXCoordinateIndex = this.getXCoordinateIndex();
        vXYDataProperties.mYCoordinateIndex = this.getYCoordinateIndex();
        vXYDataProperties.mComponentIndex1 = this.getComponentIndex1();
        vXYDataProperties.mComponentIndex2 = this.getComponentIndex2();
        return true;
    }

    @Override
    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof VXYDataProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        VXYDataProperties vXYDataProperties = (VXYDataProperties)sGProperties;
        this.mXCoordinateIndex = vXYDataProperties.mXCoordinateIndex;
        this.mYCoordinateIndex = vXYDataProperties.mYCoordinateIndex;
        this.mComponentIndex1 = vXYDataProperties.mComponentIndex1;
        this.mComponentIndex2 = vXYDataProperties.mComponentIndex2;
        return true;
    }

    @Override
    public boolean setColumnType(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("columns == null");
        }
        Integer n = null;
        Integer n2 = null;
        Integer n3 = null;
        Integer n4 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (SGUtilityText.isEqualString("X-Coordinate", stringArray[i])) {
                n = i;
                continue;
            }
            if (SGUtilityText.isEqualString("Y-Coordinate", stringArray[i])) {
                n2 = i;
                continue;
            }
            if (SGUtilityText.isEqualString("Magnitude", stringArray[i]) || SGUtilityText.isEqualString("X-Component", stringArray[i])) {
                n3 = i;
                continue;
            }
            if (SGUtilityText.isEqualString("Angle", stringArray[i]) || SGUtilityText.isEqualString("Y-Component", stringArray[i])) {
                n4 = i;
                continue;
            }
            if ("".equals(stringArray[i])) continue;
            return false;
        }
        this.mXCoordinateIndex = n;
        this.mYCoordinateIndex = n2;
        this.mComponentIndex1 = n3;
        this.mComponentIndex2 = n4;
        return true;
    }

    @Override
    public String[] getCurrentColumnType() {
        String string;
        String string2;
        if (this.isPolar()) {
            string2 = "Magnitude";
            string = "Angle";
        } else {
            string2 = "X-Component";
            string = "Y-Component";
        }
        int n = this.getColNum();
        String[] stringArray = new String[n];
        if (this.mXCoordinateIndex != null) {
            stringArray[this.mXCoordinateIndex.intValue()] = "X-Coordinate";
        }
        if (this.mYCoordinateIndex != null) {
            stringArray[this.mYCoordinateIndex.intValue()] = "Y-Coordinate";
        }
        if (this.mComponentIndex1 != null) {
            stringArray[this.mComponentIndex1.intValue()] = string2;
        }
        if (this.mComponentIndex2 != null) {
            stringArray[this.mComponentIndex2.intValue()] = string;
        }
        return stringArray;
    }

    @Override
    protected SGDataColumn[] getDataSetColumns() {
        SGDataColumn[] sGDataColumnArray = this.mDataFile.mDataColumns;
        SGDataColumn[] sGDataColumnArray2 = new SGDataColumn[]{sGDataColumnArray[this.mXCoordinateIndex], sGDataColumnArray[this.mYCoordinateIndex], sGDataColumnArray[this.mComponentIndex1], sGDataColumnArray[this.mComponentIndex2]};
        sGDataColumnArray2[0].setColumnType("X-Coordinate");
        sGDataColumnArray2[1].setColumnType("Y-Coordinate");
        if (this.isPolar()) {
            sGDataColumnArray2[2].setColumnType("Magnitude");
            sGDataColumnArray2[3].setColumnType("Angle");
        } else {
            sGDataColumnArray2[2].setColumnType("X-Component");
            sGDataColumnArray2[3].setColumnType("Y-Component");
        }
        return sGDataColumnArray2;
    }

    @Override
    public SGDataColumn[] getUsedDataColumnsClone() {
        return this.getDataSetColumnsClone();
    }

    public static class VXYDataProperties
    extends SGArrayData.ArrayDataProperties {
        Integer mXCoordinateIndex = null;
        Integer mYCoordinateIndex = null;
        Integer mComponentIndex1 = null;
        Integer mComponentIndex2 = null;

        public boolean equals(Object object) {
            if (!(object instanceof VXYDataProperties)) {
                return false;
            }
            VXYDataProperties vXYDataProperties = (VXYDataProperties)object;
            if (this.mXCoordinateIndex != null ? !this.mXCoordinateIndex.equals(vXYDataProperties.mXCoordinateIndex) : vXYDataProperties.mXCoordinateIndex != null) {
                return false;
            }
            if (this.mYCoordinateIndex != null ? !this.mYCoordinateIndex.equals(vXYDataProperties.mYCoordinateIndex) : vXYDataProperties.mYCoordinateIndex != null) {
                return false;
            }
            if (this.mComponentIndex1 != null ? !this.mComponentIndex1.equals(vXYDataProperties.mComponentIndex1) : vXYDataProperties.mComponentIndex1 != null) {
                return false;
            }
            return !(this.mComponentIndex2 != null ? !this.mComponentIndex2.equals(vXYDataProperties.mComponentIndex2) : vXYDataProperties.mComponentIndex2 != null);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[");
            stringBuffer.append("XIndex=");
            stringBuffer.append(this.mXCoordinateIndex);
            stringBuffer.append(", YIndex=");
            stringBuffer.append(this.mYCoordinateIndex);
            stringBuffer.append(", ComponentIndex1=");
            stringBuffer.append(this.mComponentIndex1);
            stringBuffer.append(", ComponentIndex2=");
            stringBuffer.append(this.mComponentIndex2);
            stringBuffer.append("]");
            return stringBuffer.toString();
        }

        public void dispose() {
            super.dispose();
            this.mXCoordinateIndex = null;
            this.mYCoordinateIndex = null;
            this.mComponentIndex1 = null;
            this.mComponentIndex2 = null;
        }
    }
}

