/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2d;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.base.SGValueRange;
import jp.riken.brain.ni.samuraigraph.data.SGDataSourceObserver;
import jp.riken.brain.ni.samuraigraph.data.SGDataUtility;
import jp.riken.brain.ni.samuraigraph.data.SGIDataColumnNameConstants;
import jp.riken.brain.ni.samuraigraph.data.SGIDataColumnTypeConstants;
import jp.riken.brain.ni.samuraigraph.data.SGIVXYTypeData;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFData;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFFile;
import jp.riken.brain.ni.samuraigraph.data.SGVXYDataUtility;
import jp.riken.brain.ni.samuraigraph.data.SGVariable;
import org.w3c.dom.Element;
import ucar.ma2.Array;
import ucar.nc2.Dimension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGVXYNetCDFData
extends SGNetCDFData
implements SGIVXYTypeData,
SGIDataColumnTypeConstants,
SGIDataColumnNameConstants {
    protected SGVariable mXLocationVariable = null;
    protected SGVariable mYLocationVariable = null;
    protected SGVariable mFirstComponentVariable = null;
    protected SGVariable mSecondComponentVariable = null;
    private boolean mPolarFlag = false;

    public SGVXYNetCDFData() {
    }

    public SGVXYNetCDFData(SGNetCDFFile sGNetCDFFile, SGDataSourceObserver sGDataSourceObserver, String string, String string2, String string3, String string4, boolean bl, String string5, String string6) {
        super(sGNetCDFFile, sGDataSourceObserver, string5, string6);
        if (string == null || string2 == null || string3 == null || string4 == null) {
            throw new IllegalArgumentException("xName == null || yName == null || fName == null || sName == null");
        }
        SGVariable sGVariable = sGNetCDFFile.findVariable(string);
        if (sGVariable == null) {
            throw new IllegalArgumentException("Illegal variable name: " + string);
        }
        SGVariable sGVariable2 = sGNetCDFFile.findVariable(string2);
        if (sGVariable2 == null) {
            throw new IllegalArgumentException("Illegal variable name: " + string2);
        }
        SGVariable sGVariable3 = sGNetCDFFile.findVariable(string3);
        if (sGVariable3 == null) {
            throw new IllegalArgumentException("Illegal variable name: " + string3);
        }
        SGVariable sGVariable4 = sGNetCDFFile.findVariable(string4);
        if (sGVariable4 == null) {
            throw new IllegalArgumentException("Illegal variable name: " + string4);
        }
        ArrayList<Dimension> arrayList = new ArrayList<Dimension>();
        if (this.mTimeVariable != null) {
            arrayList.add(this.mTimeVariable.getDimension(0));
        }
        if (sGVariable3.isCoordinateVariable() || sGVariable4.isCoordinateVariable()) {
            throw new IllegalArgumentException("Both of two components must not be coordinate variables.");
        }
        if (this.isSerialNumberAvailable()) {
            if (sGVariable.isCoordinateVariable() || sGVariable2.isCoordinateVariable()) {
                throw new IllegalArgumentException("Both of x and y must not be coordinate variables.");
            }
            Dimension dimension = this.mSerialNumberVariable.getDimension(0);
            arrayList.add(dimension);
            this.checkNotCoordinateVariable(sGVariable, arrayList);
            this.checkNotCoordinateVariable(sGVariable2, arrayList);
        } else {
            if (!sGVariable.isCoordinateVariable() || !sGVariable2.isCoordinateVariable()) {
                throw new IllegalArgumentException("Both of x and y must be coordinate variables.");
            }
            arrayList.add(sGVariable.getDimension(0));
            arrayList.add(sGVariable2.getDimension(0));
        }
        this.checkNotCoordinateVariable(sGVariable3, arrayList);
        this.checkNotCoordinateVariable(sGVariable4, arrayList);
        this.mXLocationVariable = sGVariable;
        this.mYLocationVariable = sGVariable2;
        this.mFirstComponentVariable = sGVariable3;
        this.mSecondComponentVariable = sGVariable4;
        this.mPolarFlag = bl;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.mXLocationVariable = null;
        this.mYLocationVariable = null;
        this.mFirstComponentVariable = null;
        this.mSecondComponentVariable = null;
        this.mVariableCache.clear();
    }

    @Override
    public boolean isPolar() {
        return this.mPolarFlag;
    }

    @Override
    public Map<String, Object> getInfoMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("Polar selected", this.isPolar());
        return hashMap;
    }

    private String getFirstComponentName() {
        if (this.isPolar()) {
            return "Magnitude";
        }
        return "X-Component";
    }

    private String getSecondComponentName() {
        if (this.isPolar()) {
            return "Angle";
        }
        return "Y-Component";
    }

    @Override
    public String getDataType() {
        return "VXY_NETCDF";
    }

    @Override
    protected String getDataTypeForDataSet() {
        return "VXY";
    }

    @Override
    public int getPointsNumber() {
        int n;
        if (this.isSerialNumberAvailable()) {
            Dimension dimension = this.mSerialNumberVariable.getDimension(0);
            n = dimension.getLength();
        } else {
            Dimension dimension = this.mXLocationVariable.getDimension(0);
            Dimension dimension2 = this.mYLocationVariable.getDimension(0);
            n = dimension.getLength() * dimension2.getLength();
        }
        return n;
    }

    @Override
    public SGVariable[] getVariables() {
        ArrayList<SGVariable> arrayList = new ArrayList<SGVariable>();
        arrayList.add(this.mXLocationVariable);
        arrayList.add(this.mYLocationVariable);
        arrayList.add(this.mFirstComponentVariable);
        arrayList.add(this.mSecondComponentVariable);
        if (this.mTimeVariable != null) {
            arrayList.add(this.mTimeVariable);
        }
        if (this.mSerialNumberVariable != null) {
            arrayList.add(this.mSerialNumberVariable);
        }
        SGVariable[] sGVariableArray = new SGVariable[arrayList.size()];
        return arrayList.toArray(sGVariableArray);
    }

    @Override
    public String[] getCurrentColumnType() {
        String string = this.getFirstComponentName();
        String string2 = this.getSecondComponentName();
        List<SGVariable> list = this.mNCFile.getVariables();
        int n = list.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            SGVariable sGVariable = list.get(i);
            stringArray[i] = sGVariable.equals(this.mXLocationVariable) ? "X-Coordinate" : (sGVariable.equals(this.mYLocationVariable) ? "Y-Coordinate" : (sGVariable.equals(this.mFirstComponentVariable) ? string : (sGVariable.equals(this.mSecondComponentVariable) ? string2 : (sGVariable.equals(this.mTimeVariable) ? "Time" : (sGVariable.equals(this.mSerialNumberVariable) ? "SerialNumbers" : "")))));
        }
        return stringArray;
    }

    @Override
    public boolean setColumnType(String[] stringArray) {
        SGVariable sGVariable = null;
        SGVariable sGVariable2 = null;
        SGVariable sGVariable3 = null;
        SGVariable sGVariable4 = null;
        SGVariable sGVariable5 = null;
        SGVariable sGVariable6 = null;
        String string = this.getFirstComponentName();
        String string2 = this.getSecondComponentName();
        List<SGVariable> list = this.mNCFile.getVariables();
        for (int i = 0; i < stringArray.length; ++i) {
            SGVariable sGVariable7 = list.get(i);
            if (SGUtilityText.isEqualString("X-Coordinate", stringArray[i])) {
                sGVariable = sGVariable7;
                continue;
            }
            if (SGUtilityText.isEqualString("Y-Coordinate", stringArray[i])) {
                sGVariable2 = sGVariable7;
                continue;
            }
            if (SGUtilityText.isEqualString(string, stringArray[i])) {
                sGVariable3 = sGVariable7;
                continue;
            }
            if (SGUtilityText.isEqualString(string2, stringArray[i])) {
                sGVariable4 = sGVariable7;
                continue;
            }
            if (SGUtilityText.isEqualString("Time", stringArray[i])) {
                sGVariable5 = sGVariable7;
                continue;
            }
            if (SGUtilityText.isEqualString("SerialNumbers", stringArray[i])) {
                sGVariable6 = sGVariable7;
                continue;
            }
            if ("".equals(stringArray[i])) continue;
            return false;
        }
        if (sGVariable == null || sGVariable2 == null || sGVariable3 == null || sGVariable4 == null) {
            return false;
        }
        this.mXLocationVariable = sGVariable;
        this.mYLocationVariable = sGVariable2;
        this.mFirstComponentVariable = sGVariable3;
        this.mSecondComponentVariable = sGVariable4;
        this.mTimeVariable = sGVariable5;
        this.mSerialNumberVariable = sGVariable6;
        return true;
    }

    public boolean isValidColumn(String[] stringArray) {
        SGVariable sGVariable = null;
        SGVariable sGVariable2 = null;
        SGVariable sGVariable3 = null;
        SGVariable sGVariable4 = null;
        SGVariable sGVariable5 = null;
        Object var7_7 = null;
        String string = this.getFirstComponentName();
        String string2 = this.getSecondComponentName();
        List<SGVariable> list = this.mNCFile.getVariables();
        for (int i = 0; i < stringArray.length; ++i) {
            SGVariable sGVariable6 = list.get(i);
            if (SGUtilityText.isEqualString("X-Coordinate", stringArray[i])) {
                sGVariable = sGVariable6;
                continue;
            }
            if (SGUtilityText.isEqualString("Y-Coordinate", stringArray[i])) {
                sGVariable2 = sGVariable6;
                continue;
            }
            if (SGUtilityText.isEqualString(string, stringArray[i])) {
                sGVariable3 = sGVariable6;
                continue;
            }
            if (SGUtilityText.isEqualString(string2, stringArray[i])) {
                sGVariable4 = sGVariable6;
                continue;
            }
            if (SGUtilityText.isEqualString("Time", stringArray[i])) {
                sGVariable5 = sGVariable6;
                continue;
            }
            if ("".equals(stringArray[i])) continue;
            return false;
        }
        if (sGVariable == null || sGVariable2 == null || sGVariable3 == null || sGVariable4 == null) {
            return false;
        }
        this.mXLocationVariable = sGVariable;
        this.mYLocationVariable = sGVariable2;
        this.mFirstComponentVariable = sGVariable3;
        this.mSecondComponentVariable = sGVariable4;
        this.mTimeVariable = sGVariable5;
        this.mSerialNumberVariable = var7_7;
        return true;
    }

    @Override
    public boolean setData(SGData sGData) {
        if (!(sGData instanceof SGVXYNetCDFData)) {
            throw new IllegalArgumentException("Given data is not the instance of SGVXYNetCDFData class.");
        }
        if (!super.setData(sGData)) {
            return false;
        }
        SGVXYNetCDFData sGVXYNetCDFData = (SGVXYNetCDFData)sGData;
        this.mXLocationVariable = sGVXYNetCDFData.mXLocationVariable;
        this.mYLocationVariable = sGVXYNetCDFData.mYLocationVariable;
        this.mFirstComponentVariable = sGVXYNetCDFData.mFirstComponentVariable;
        this.mSecondComponentVariable = sGVXYNetCDFData.mSecondComponentVariable;
        this.mPolarFlag = sGVXYNetCDFData.mPolarFlag;
        return true;
    }

    @Override
    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof VXYNetCDFDataProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        VXYNetCDFDataProperties vXYNetCDFDataProperties = (VXYNetCDFDataProperties)sGProperties;
        this.mXLocationVariable = this.mNCFile.findVariable(vXYNetCDFDataProperties.xName);
        this.mYLocationVariable = this.mNCFile.findVariable(vXYNetCDFDataProperties.yName);
        this.mFirstComponentVariable = this.mNCFile.findTopVariable(vXYNetCDFDataProperties.fName);
        this.mSecondComponentVariable = this.mNCFile.findTopVariable(vXYNetCDFDataProperties.sName);
        return true;
    }

    @Override
    public SGProperties getProperties() {
        VXYNetCDFDataProperties vXYNetCDFDataProperties = new VXYNetCDFDataProperties();
        if (!this.getProperties(vXYNetCDFDataProperties)) {
            return null;
        }
        return vXYNetCDFDataProperties;
    }

    @Override
    public boolean getProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof VXYNetCDFDataProperties)) {
            return false;
        }
        if (!super.getProperties(sGProperties)) {
            return false;
        }
        VXYNetCDFDataProperties vXYNetCDFDataProperties = (VXYNetCDFDataProperties)sGProperties;
        vXYNetCDFDataProperties.xName = this.mXLocationVariable.getName();
        vXYNetCDFDataProperties.yName = this.mYLocationVariable.getName();
        vXYNetCDFDataProperties.fName = this.mFirstComponentVariable.getName();
        vXYNetCDFDataProperties.sName = this.mSecondComponentVariable.getName();
        return true;
    }

    @Override
    public double[][] getDataSetValues() {
        SGTuple2d[] sGTuple2dArray = this.getCoordinateArray();
        double[] dArray = this.getFirstComponentValueArray();
        double[] dArray2 = this.getSecondComponentValueArray();
        int n = sGTuple2dArray.length;
        double[][] dArrayArray = new double[n][];
        for (int i = 0; i < n; ++i) {
            dArrayArray[i] = new double[4];
            dArrayArray[i][0] = sGTuple2dArray[i].x;
            dArrayArray[i][1] = sGTuple2dArray[i].y;
            dArrayArray[i][2] = dArray[i];
            dArrayArray[i][3] = dArray2[i];
        }
        return dArrayArray;
    }

    @Override
    public boolean writeProperty(Element element, int n) {
        if (!super.writeProperty(element, n)) {
            return false;
        }
        element.setAttribute("XCoordinateVariableName", this.mXLocationVariable.getName());
        element.setAttribute("YCoordinateVariableName", this.mYLocationVariable.getName());
        element.setAttribute("FirstComponentVariableName", this.mFirstComponentVariable.getName());
        element.setAttribute("SecondComponentVariableName", this.mSecondComponentVariable.getName());
        return true;
    }

    private SGVariable[] getCoordinateVariables() {
        if (this.isSerialNumberAvailable()) {
            return new SGVariable[]{this.mSerialNumberVariable};
        }
        return new SGVariable[]{this.mXLocationVariable, this.mYLocationVariable};
    }

    private double[] getFirstComponentValueArray() {
        if (this.isSerialNumberAvailable()) {
            return this.getValueArray(this.mFirstComponentVariable, new SGVariable[]{this.mSerialNumberVariable});
        }
        return this.getValueArray(this.mFirstComponentVariable, this.getCoordinateVariables());
    }

    private double[] getSecondComponentValueArray() {
        if (this.isSerialNumberAvailable()) {
            return this.getValueArray(this.mSecondComponentVariable, new SGVariable[]{this.mSerialNumberVariable});
        }
        return this.getValueArray(this.mSecondComponentVariable, this.getCoordinateVariables());
    }

    @Override
    public double[] getXCoordinateArray() {
        if (this.isSerialNumberAvailable()) {
            return this.getValueArray(this.mXLocationVariable, new SGVariable[]{this.mSerialNumberVariable});
        }
        return this.getCoordinateValueArray(this.mXLocationVariable);
    }

    @Override
    public double[] getYCoordinateArray() {
        if (this.isSerialNumberAvailable()) {
            return this.getValueArray(this.mYLocationVariable, new SGVariable[]{this.mSerialNumberVariable});
        }
        return this.getCoordinateValueArray(this.mYLocationVariable);
    }

    @Override
    public SGTuple2d[] getCoordinateArray() {
        double[] dArray = this.getXCoordinateArray();
        double[] dArray2 = this.getYCoordinateArray();
        if (this.isSerialNumberAvailable()) {
            int n = dArray.length;
            SGTuple2d[] sGTuple2dArray = new SGTuple2d[n];
            for (int i = 0; i < n; ++i) {
                sGTuple2dArray[i] = new SGTuple2d(dArray[i], dArray2[i]);
            }
            return sGTuple2dArray;
        }
        SGTuple2d[] sGTuple2dArray = new SGTuple2d[dArray.length * dArray2.length];
        for (int i = 0; i < dArray2.length; ++i) {
            for (int j = 0; j < dArray.length; ++j) {
                int n = i * dArray.length + j;
                sGTuple2dArray[n] = new SGTuple2d(dArray[j], dArray2[i]);
            }
        }
        return sGTuple2dArray;
    }

    @Override
    public double[] getXComponentArray() {
        if (this.isPolar()) {
            double[] dArray = this.getFirstComponentValueArray();
            double[] dArray2 = this.getSecondComponentValueArray();
            return SGVXYDataUtility.getXComponentArray(dArray, dArray2);
        }
        return this.getFirstComponentValueArray();
    }

    @Override
    public double[] getYComponentArray() {
        if (this.isPolar()) {
            double[] dArray = this.getFirstComponentValueArray();
            double[] dArray2 = this.getSecondComponentValueArray();
            return SGVXYDataUtility.getYComponentArray(dArray, dArray2);
        }
        return this.getSecondComponentValueArray();
    }

    @Override
    public double[] getMagnitudeArray() {
        if (this.isPolar()) {
            return this.getFirstComponentValueArray();
        }
        double[] dArray = this.getFirstComponentValueArray();
        double[] dArray2 = this.getSecondComponentValueArray();
        return SGVXYDataUtility.getMagnitudeArray(dArray, dArray2);
    }

    @Override
    public double[] getAngleArray() {
        if (this.isPolar()) {
            return this.getSecondComponentValueArray();
        }
        double[] dArray = this.getFirstComponentValueArray();
        double[] dArray2 = this.getSecondComponentValueArray();
        return SGVXYDataUtility.getAngleArray(dArray, dArray2);
    }

    @Override
    public SGValueRange getBoundsX() {
        return SGDataUtility.getBoundsX(this);
    }

    @Override
    public SGValueRange getBoundsY() {
        return SGDataUtility.getBoundsY(this);
    }

    @Override
    public String getTitleX() {
        return this.getNameWithUnit(this.mXLocationVariable);
    }

    @Override
    public String getTitleY() {
        return this.getNameWithUnit(this.mYLocationVariable);
    }

    @Override
    protected Double[] arrangeValueArray(Array array, SGVariable sGVariable, SGVariable[] sGVariableArray) {
        if (this.isSerialNumberAvailable()) {
            return this.arrange1Dim(array);
        }
        return this.arrange2Dim(array, sGVariable, sGVariableArray);
    }

    public static class VXYNetCDFDataProperties
    extends SGNetCDFData.NetCDFDataProperties {
        protected String xName = null;
        protected String yName = null;
        protected String fName = null;
        protected String sName = null;

        public void dispose() {
            super.dispose();
            this.xName = null;
            this.yName = null;
            this.fName = null;
            this.sName = null;
        }

        public boolean equals(Object object) {
            if (!(object instanceof VXYNetCDFDataProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            VXYNetCDFDataProperties vXYNetCDFDataProperties = (VXYNetCDFDataProperties)object;
            if (!SGUtility.equals(this.xName, vXYNetCDFDataProperties.xName)) {
                return false;
            }
            if (!SGUtility.equals(this.yName, vXYNetCDFDataProperties.yName)) {
                return false;
            }
            if (!SGUtility.equals(this.fName, vXYNetCDFDataProperties.fName)) {
                return false;
            }
            return SGUtility.equals(this.sName, vXYNetCDFDataProperties.sName);
        }
    }
}

