/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import jp.riken.brain.ni.samuraigraph.base.SGButton;
import jp.riken.brain.ni.samuraigraph.base.SGCheckBox;
import jp.riken.brain.ni.samuraigraph.base.SGColorBarModel;
import jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton;
import jp.riken.brain.ni.samuraigraph.base.SGComboBox;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGRadioButton;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGTextField;
import jp.riken.brain.ni.samuraigraph.base.SGTwoAxesSelectionPanel;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGAxisPanel;
import jp.riken.brain.ni.samuraigraph.figure.SGColorBarStyleManager;
import jp.riken.brain.ni.samuraigraph.figure.SGIAxisConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGIColorBarConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGIColorBarDialogObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGColorBarDialog
extends SGPropertyDialog
implements SGIColorBarConstants,
SGIFigureConstants,
SGIAxisConstants,
ItemListener {
    private static final long serialVersionUID = -5966935892328455296L;
    public static final String TITLE = "Color Bar Properties";
    private JPanel mAxisParentPanel;
    private SGTwoAxesSelectionPanel mAxisSelectionPanel;
    private JLabel mBarLengthLabel;
    private SGSpinner mBarLengthSpinner;
    private JLabel mBarWidthLabel;
    private SGSpinner mBarWidthSpinner;
    private JPanel mButtonPanel;
    private SGButton mCancelButton;
    private JPanel mColorBarPanel;
    private JPanel mColorBarRenderPanel;
    private SGComboBox mColorBarStyleComboBox;
    private JLabel mColorBarStyleLabel;
    private JLabel mDirectionLabel;
    private JPanel mDirectionPanel;
    private SGColorSelectionButton mFontColorButton;
    private JLabel mFontColorLabel;
    private SGComboBox mFontNameComboBox;
    private JLabel mFontNameLabel;
    private JPanel mFontPanel;
    private JLabel mFontSizeLabel;
    private SGSpinner mFontSizeSpinner;
    private SGComboBox mFontStyleComboBox;
    private JLabel mFontStyleLabel;
    private JLabel mFrameLineWidthLabel1;
    private JLabel mFrameLineWidthLabel2;
    private SGSpinner mFrameLineWidthSpinner;
    private SGRadioButton mHorizontalLowerRadioButton;
    private SGRadioButton mHorizontalUpperRadioButton;
    private JPanel mLayoutPanel;
    private SGColorSelectionButton mLineColorButton;
    private JLabel mLineColorLabel;
    private JPanel mLinePanel;
    private SGButton mOKButton;
    private SGRadioButton mPerpendicularLeftRadioButton;
    private SGRadioButton mPerpendicularRightRadioButton;
    private SGButton mPreviewButton;
    private SGCheckBox mReversedOrderCheckBox;
    private JLabel mSpaceLineAndScaleLabel;
    private SGSpinner mSpaceLineAndScaleSpinner;
    private JLabel mSpaceScaleAndTitleLabel;
    private SGSpinner mSpaceScaleAndTitleSpinner;
    private JPanel mStylePanel;
    private JTabbedPane mTabbedPane;
    private JLabel mTickMarkLabel1;
    private JLabel mTickMarkLabel2;
    private JLabel mTickMarkLengthLabel1;
    private JLabel mTickMarkLengthLabel2;
    private SGSpinner mTickMarkLengthSpinner;
    private SGSpinner mTickMarkWidthSpinner;
    private JLabel mXLabel;
    private SGTextField mXValueTextField;
    private JLabel mYLabel;
    private SGTextField mYValueTextField;
    private SGAxisPanel mAxisPanel = null;
    private JRadioButton mColorBarDirectionNoSelectedRadioButton = new JRadioButton();

    public SGColorBarDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
        this.initialize();
    }

    private void initComponents() {
        this.mButtonPanel = new JPanel();
        this.mOKButton = new SGButton();
        this.mCancelButton = new SGButton();
        this.mPreviewButton = new SGButton();
        this.mAxisSelectionPanel = new SGTwoAxesSelectionPanel();
        this.mTabbedPane = new JTabbedPane();
        this.mStylePanel = new JPanel();
        this.mLinePanel = new JPanel();
        this.mFrameLineWidthLabel2 = new JLabel();
        this.mLineColorLabel = new JLabel();
        this.mTickMarkLabel1 = new JLabel();
        this.mFrameLineWidthSpinner = new SGSpinner();
        this.mTickMarkLabel2 = new JLabel();
        this.mTickMarkLengthLabel1 = new JLabel();
        this.mTickMarkLengthLabel2 = new JLabel();
        this.mTickMarkWidthSpinner = new SGSpinner();
        this.mTickMarkLengthSpinner = new SGSpinner();
        this.mLineColorButton = new SGColorSelectionButton();
        this.mFrameLineWidthLabel1 = new JLabel();
        this.mFontPanel = new JPanel();
        this.mFontNameLabel = new JLabel();
        this.mFontSizeLabel = new JLabel();
        this.mFontColorLabel = new JLabel();
        this.mFontStyleComboBox = new SGComboBox();
        this.mFontSizeSpinner = new SGSpinner();
        this.mFontNameComboBox = new SGComboBox();
        this.mFontColorButton = new SGColorSelectionButton();
        this.mFontStyleLabel = new JLabel();
        this.mColorBarPanel = new JPanel();
        this.mColorBarStyleLabel = new JLabel();
        this.mColorBarStyleComboBox = new SGComboBox();
        this.mColorBarRenderPanel = new JPanel();
        this.mReversedOrderCheckBox = new SGCheckBox();
        this.mLayoutPanel = new JPanel();
        this.mXLabel = new JLabel();
        this.mYLabel = new JLabel();
        this.mBarWidthLabel = new JLabel();
        this.mBarWidthSpinner = new SGSpinner();
        this.mBarLengthLabel = new JLabel();
        this.mBarLengthSpinner = new SGSpinner();
        this.mSpaceLineAndScaleLabel = new JLabel();
        this.mSpaceLineAndScaleSpinner = new SGSpinner();
        this.mSpaceScaleAndTitleLabel = new JLabel();
        this.mSpaceScaleAndTitleSpinner = new SGSpinner();
        this.mDirectionLabel = new JLabel();
        this.mDirectionPanel = new JPanel();
        this.mHorizontalUpperRadioButton = new SGRadioButton();
        this.mPerpendicularLeftRadioButton = new SGRadioButton();
        this.mHorizontalLowerRadioButton = new SGRadioButton();
        this.mPerpendicularRightRadioButton = new SGRadioButton();
        this.mXValueTextField = new SGTextField();
        this.mYValueTextField = new SGTextField();
        this.mAxisParentPanel = new JPanel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.mOKButton.setText("OK");
        this.mOKButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setText("Cancel");
        this.mCancelButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mCancelButton);
        this.mPreviewButton.setText("Preview");
        this.mPreviewButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mPreviewButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.getContentPane().add((Component)this.mAxisSelectionPanel, gridBagConstraints);
        this.mTabbedPane.setFont(new Font("Dialog", 1, 12));
        this.mStylePanel.setLayout(new GridBagLayout());
        this.mLinePanel.setBorder(BorderFactory.createTitledBorder(null, "Line", 0, 0, new Font("Dialog", 3, 12)));
        this.mLinePanel.setLayout(new GridBagLayout());
        this.mFrameLineWidthLabel2.setFont(new Font("Dialog", 0, 12));
        this.mFrameLineWidthLabel2.setText("Width");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 15, 5, 5);
        this.mLinePanel.add((Component)this.mFrameLineWidthLabel2, gridBagConstraints);
        this.mLineColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mLineColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 10, 10, 5);
        this.mLinePanel.add((Component)this.mLineColorLabel, gridBagConstraints);
        this.mTickMarkLabel1.setFont(new Font("Dialog", 0, 12));
        this.mTickMarkLabel1.setText("Tick Mark");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 20, 0, 5);
        this.mLinePanel.add((Component)this.mTickMarkLabel1, gridBagConstraints);
        this.mFrameLineWidthSpinner.setFont(new Font("Dialog", 0, 12));
        this.mFrameLineWidthSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.mLinePanel.add((Component)this.mFrameLineWidthSpinner, gridBagConstraints);
        this.mTickMarkLabel2.setFont(new Font("Dialog", 0, 12));
        this.mTickMarkLabel2.setText("Width");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 20, 10, 5);
        this.mLinePanel.add((Component)this.mTickMarkLabel2, gridBagConstraints);
        this.mTickMarkLengthLabel1.setFont(new Font("Dialog", 0, 12));
        this.mTickMarkLengthLabel1.setText("Tick Mark");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 10, 0, 5);
        this.mLinePanel.add((Component)this.mTickMarkLengthLabel1, gridBagConstraints);
        this.mTickMarkLengthLabel2.setFont(new Font("Dialog", 0, 12));
        this.mTickMarkLengthLabel2.setText("Length");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 10, 10, 5);
        this.mLinePanel.add((Component)this.mTickMarkLengthLabel2, gridBagConstraints);
        this.mTickMarkWidthSpinner.setFont(new Font("Dialog", 0, 12));
        this.mTickMarkWidthSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.mLinePanel.add((Component)this.mTickMarkWidthSpinner, gridBagConstraints);
        this.mTickMarkLengthSpinner.setFont(new Font("Dialog", 0, 12));
        this.mTickMarkLengthSpinner.setPreferredSize(new Dimension(75, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.mLinePanel.add((Component)this.mTickMarkLengthSpinner, gridBagConstraints);
        this.mLineColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLinePanel.add((Component)this.mLineColorButton, gridBagConstraints);
        this.mFrameLineWidthLabel1.setFont(new Font("Dialog", 0, 12));
        this.mFrameLineWidthLabel1.setText("Frame Line");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 15, 0, 5);
        this.mLinePanel.add((Component)this.mFrameLineWidthLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.mStylePanel.add((Component)this.mLinePanel, gridBagConstraints);
        this.mFontPanel.setBorder(BorderFactory.createTitledBorder(null, "Font", 0, 0, new Font("Dialog", 3, 12)));
        this.mFontPanel.setLayout(new GridBagLayout());
        this.mFontNameLabel.setFont(new Font("Dialog", 0, 12));
        this.mFontNameLabel.setText("Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.mFontPanel.add((Component)this.mFontNameLabel, gridBagConstraints);
        this.mFontSizeLabel.setFont(new Font("Dialog", 0, 12));
        this.mFontSizeLabel.setText("Size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.mFontPanel.add((Component)this.mFontSizeLabel, gridBagConstraints);
        this.mFontColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mFontColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.mFontPanel.add((Component)this.mFontColorLabel, gridBagConstraints);
        this.mFontStyleComboBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mFontPanel.add((Component)this.mFontStyleComboBox, gridBagConstraints);
        this.mFontSizeSpinner.setFont(new Font("Dialog", 0, 12));
        this.mFontSizeSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.mFontPanel.add((Component)this.mFontSizeSpinner, gridBagConstraints);
        this.mFontNameComboBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mFontPanel.add((Component)this.mFontNameComboBox, gridBagConstraints);
        this.mFontColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.mFontPanel.add((Component)this.mFontColorButton, gridBagConstraints);
        this.mFontStyleLabel.setFont(new Font("Dialog", 0, 12));
        this.mFontStyleLabel.setText("Style");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.mFontPanel.add((Component)this.mFontStyleLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.mStylePanel.add((Component)this.mFontPanel, gridBagConstraints);
        this.mColorBarPanel.setLayout(new GridBagLayout());
        this.mColorBarStyleLabel.setFont(new Font("Dialog", 0, 12));
        this.mColorBarStyleLabel.setText("Style");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mColorBarPanel.add((Component)this.mColorBarStyleLabel, gridBagConstraints);
        this.mColorBarStyleComboBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mColorBarPanel.add((Component)this.mColorBarStyleComboBox, gridBagConstraints);
        this.mColorBarRenderPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.mColorBarRenderPanel.setPreferredSize(new Dimension(200, 20));
        this.mColorBarRenderPanel.setLayout(new BoxLayout(this.mColorBarRenderPanel, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.mColorBarPanel.add((Component)this.mColorBarRenderPanel, gridBagConstraints);
        this.mReversedOrderCheckBox.setText("Reversed Order");
        this.mReversedOrderCheckBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.mColorBarPanel.add((Component)this.mReversedOrderCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.mStylePanel.add((Component)this.mColorBarPanel, gridBagConstraints);
        this.mTabbedPane.addTab("Style", this.mStylePanel);
        this.mLayoutPanel.setLayout(new GridBagLayout());
        this.mXLabel.setFont(new Font("Dialog", 0, 12));
        this.mXLabel.setText("X");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mLayoutPanel.add((Component)this.mXLabel, gridBagConstraints);
        this.mYLabel.setFont(new Font("Dialog", 0, 12));
        this.mYLabel.setText("Y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.mLayoutPanel.add((Component)this.mYLabel, gridBagConstraints);
        this.mBarWidthLabel.setFont(new Font("Dialog", 0, 12));
        this.mBarWidthLabel.setText("Width");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mLayoutPanel.add((Component)this.mBarWidthLabel, gridBagConstraints);
        this.mBarWidthSpinner.setFont(new Font("Dialog", 0, 12));
        this.mBarWidthSpinner.setPreferredSize(new Dimension(75, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLayoutPanel.add((Component)this.mBarWidthSpinner, gridBagConstraints);
        this.mBarLengthLabel.setFont(new Font("Dialog", 0, 12));
        this.mBarLengthLabel.setText("Length");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.mLayoutPanel.add((Component)this.mBarLengthLabel, gridBagConstraints);
        this.mBarLengthSpinner.setFont(new Font("Dialog", 0, 12));
        this.mBarLengthSpinner.setPreferredSize(new Dimension(75, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.mLayoutPanel.add((Component)this.mBarLengthSpinner, gridBagConstraints);
        this.mSpaceLineAndScaleLabel.setFont(new Font("Dialog", 0, 12));
        this.mSpaceLineAndScaleLabel.setText("to Scale");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mLayoutPanel.add((Component)this.mSpaceLineAndScaleLabel, gridBagConstraints);
        this.mSpaceLineAndScaleSpinner.setFont(new Font("Dialog", 0, 12));
        this.mSpaceLineAndScaleSpinner.setPreferredSize(new Dimension(75, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLayoutPanel.add((Component)this.mSpaceLineAndScaleSpinner, gridBagConstraints);
        this.mSpaceScaleAndTitleLabel.setFont(new Font("Dialog", 0, 12));
        this.mSpaceScaleAndTitleLabel.setText("to Title");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.mLayoutPanel.add((Component)this.mSpaceScaleAndTitleLabel, gridBagConstraints);
        this.mSpaceScaleAndTitleSpinner.setFont(new Font("Dialog", 0, 12));
        this.mSpaceScaleAndTitleSpinner.setPreferredSize(new Dimension(75, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.mLayoutPanel.add((Component)this.mSpaceScaleAndTitleSpinner, gridBagConstraints);
        this.mDirectionLabel.setFont(new Font("Dialog", 0, 12));
        this.mDirectionLabel.setText("Direction");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLayoutPanel.add((Component)this.mDirectionLabel, gridBagConstraints);
        this.mDirectionPanel.setLayout(new GridBagLayout());
        this.mHorizontalUpperRadioButton.setText("Horizontal Upper");
        this.mHorizontalUpperRadioButton.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.mDirectionPanel.add((Component)this.mHorizontalUpperRadioButton, gridBagConstraints);
        this.mPerpendicularLeftRadioButton.setText("Perpendicular Left");
        this.mPerpendicularLeftRadioButton.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.mDirectionPanel.add((Component)this.mPerpendicularLeftRadioButton, gridBagConstraints);
        this.mHorizontalLowerRadioButton.setText("Horizontal Lower");
        this.mHorizontalLowerRadioButton.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.mDirectionPanel.add((Component)this.mHorizontalLowerRadioButton, gridBagConstraints);
        this.mPerpendicularRightRadioButton.setText("Perpendicular Right");
        this.mPerpendicularRightRadioButton.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.mDirectionPanel.add((Component)this.mPerpendicularRightRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLayoutPanel.add((Component)this.mDirectionPanel, gridBagConstraints);
        this.mXValueTextField.setColumns(6);
        this.mXValueTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLayoutPanel.add((Component)this.mXValueTextField, gridBagConstraints);
        this.mYValueTextField.setColumns(6);
        this.mYValueTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.mLayoutPanel.add((Component)this.mYValueTextField, gridBagConstraints);
        this.mTabbedPane.addTab("Layout", this.mLayoutPanel);
        this.mAxisParentPanel.setLayout(new GridBagLayout());
        this.mTabbedPane.addTab("Scale", this.mAxisParentPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.getContentPane().add((Component)this.mTabbedPane, gridBagConstraints);
        this.pack();
    }

    private void initProperty() {
        this.setTitle(TITLE);
        String[] stringArray = SGUtility.getAvailableFontFamilyNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.mFontNameComboBox.addItem(stringArray[i]);
        }
        String[] stringArray2 = new String[]{"Plain", "Italic", "Bold", "Bold Italic"};
        for (int i = 0; i < stringArray2.length; ++i) {
            this.mFontStyleComboBox.addItem(stringArray2[i]);
        }
        String[] stringArray3 = SGColorBarStyleManager.DEFAULT_COLOR_BAR_NAMES;
        for (int i = 0; i < stringArray3.length; ++i) {
            this.mColorBarStyleComboBox.addItem(stringArray3[i]);
        }
        this.mAxisPanel = new SGAxisPanel(4);
        this.mAxisParentPanel.add(this.mAxisPanel);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.mHorizontalLowerRadioButton);
        buttonGroup.add(this.mHorizontalUpperRadioButton);
        buttonGroup.add(this.mPerpendicularLeftRadioButton);
        buttonGroup.add(this.mPerpendicularRightRadioButton);
        buttonGroup.add(this.mColorBarDirectionNoSelectedRadioButton);
        this.mBarWidthSpinner.initProperties(new SpinnerNumberModel(10.0, 0.5, 10.0, 0.1), "cm", 1, 2);
        this.mBarLengthSpinner.initProperties(new SpinnerNumberModel(10.0, 1.0, 50.0, 1.0), "cm", 1, 2);
        this.mSpaceLineAndScaleSpinner.initProperties(new SpinnerNumberModel(0.0, 0.0, 5.0, 0.1), "cm", 1, 2);
        this.mSpaceScaleAndTitleSpinner.initProperties(new SpinnerNumberModel(0.0, 0.0, 5.0, 0.1), "cm", 1, 2);
        this.mFrameLineWidthSpinner.initProperties(SGColorBarDialog.getLineWidthSpinnerNumberModel(), "pt", 1, 2);
        this.mTickMarkWidthSpinner.initProperties(SGColorBarDialog.getLineWidthSpinnerNumberModel(), "pt", 1, 2);
        this.mTickMarkLengthSpinner.initProperties(new SpinnerNumberModel(0.1, 0.0, 0.5, 0.05), "cm", 1, 2);
        this.mFontSizeSpinner.initProperties(SGColorBarDialog.getFontSizeSpinnerNumberModel(), "pt", 1, 2);
        this.mHorizontalUpperRadioButton.addActionListener(this);
        this.mHorizontalLowerRadioButton.addActionListener(this);
        this.mPerpendicularLeftRadioButton.addActionListener(this);
        this.mPerpendicularRightRadioButton.addActionListener(this);
        this.mReversedOrderCheckBox.addActionListener(this);
        this.mXValueTextField.setDescription("Layout-> X");
        this.mYValueTextField.setDescription("Layout-> Y");
        this.mBarWidthSpinner.setDescription("Layout-> Width");
        this.mBarLengthSpinner.setDescription("Layout-> Length");
        this.mSpaceLineAndScaleSpinner.setDescription("Layout-> to Scale");
        this.mSpaceScaleAndTitleSpinner.setDescription("Layout-> to Title");
        this.mFrameLineWidthSpinner.setDescription("Line-> Frame Line Width");
        this.mTickMarkWidthSpinner.setDescription("Line-> Tick Mark Width");
        this.mTickMarkLengthSpinner.setDescription("Line-> Tick Mark Length");
        this.mFontSizeSpinner.setDescription("Font-> Size");
        this.mAxisPanel.mTitleTextField.setDescription("Title-> Label");
        this.mAxisPanel.mMinValueTextField.setDescription("Scale-> Min");
        this.mAxisPanel.mMaxValueTextField.setDescription("Scale-> Max");
        this.mAxisPanel.mStepTextField.setDescription("Scale-> Tick Mark-> Step");
        this.mAxisPanel.mBaseTextField.setDescription("Scale-> Tick Mark-> Base");
        this.mAxisPanel.mExponentSpinner.setDescription("Scale-> Number-> Format-> Exp Part");
        this.mAxisPanel.mNumberAngleSpinner.setDescription("Scale-> Number-> Angle");
        this.mColorBarStyleComboBox.addItemListener(this);
        this.mAxisPanel.setVisibleName("Color Bar Visible");
        this.mColorBarRenderPanel.add(new ColorBarPanel());
        this.pack();
    }

    @Override
    protected JButton getOKButton() {
        return this.mOKButton;
    }

    @Override
    protected JButton getCancelButton() {
        return this.mCancelButton;
    }

    @Override
    protected JButton getPreviewButton() {
        return this.mPreviewButton;
    }

    @Override
    public List getColorSelectionButtonsList() {
        ArrayList<SGColorSelectionButton> arrayList = new ArrayList<SGColorSelectionButton>();
        arrayList.add(this.mLineColorButton);
        arrayList.add(this.mFontColorButton);
        return arrayList;
    }

    @Override
    public List getNumberTextFieldList() {
        ArrayList<SGTextField> arrayList = new ArrayList<SGTextField>();
        arrayList.add(this.mXValueTextField);
        arrayList.add(this.mYValueTextField);
        return arrayList;
    }

    @Override
    public List<SGSpinner> getSpinnerList() {
        ArrayList<SGSpinner> arrayList = new ArrayList<SGSpinner>();
        arrayList.add(this.mBarWidthSpinner);
        arrayList.add(this.mBarLengthSpinner);
        arrayList.add(this.mSpaceScaleAndTitleSpinner);
        arrayList.add(this.mSpaceLineAndScaleSpinner);
        arrayList.add(this.mFrameLineWidthSpinner);
        arrayList.add(this.mTickMarkWidthSpinner);
        arrayList.add(this.mTickMarkLengthSpinner);
        arrayList.add(this.mFontSizeSpinner);
        return arrayList;
    }

    @Override
    public List getTextFieldComponentsList() {
        List list = this.getFormattedTextFieldsListFromSpinners();
        list.addAll(this.getNumberTextFieldList());
        list.addAll(this.mAxisPanel.getTextFieldComponentsList());
        ArrayList<SGSpinner> arrayList = this.mAxisPanel.getSpinnerList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGSpinner sGSpinner = (SGSpinner)arrayList.get(i);
            list.add(sGSpinner.getFormattedTextField());
        }
        return list;
    }

    public Number getXValue() {
        return this.getNumber(this.mXValueTextField);
    }

    public Number getYValue() {
        return this.getNumber(this.mYValueTextField);
    }

    public Number getBarWidth() {
        return this.mBarWidthSpinner.getNumber();
    }

    public Number getBarLength() {
        return this.mBarLengthSpinner.getNumber();
    }

    public Number getSpaceLineAndScale() {
        return this.mSpaceLineAndScaleSpinner.getNumber();
    }

    public Number getSpaceScaleAndTitle() {
        return this.mSpaceScaleAndTitleSpinner.getNumber();
    }

    public String getColorBarDirection() {
        String string = null;
        if (this.mHorizontalLowerRadioButton.isSelected()) {
            string = "Horizontal Lower";
        } else if (this.mHorizontalUpperRadioButton.isSelected()) {
            string = "Horizontal Upper";
        } else if (this.mPerpendicularLeftRadioButton.isSelected()) {
            string = "Perpendicular Left";
        } else if (this.mPerpendicularRightRadioButton.isSelected()) {
            string = "Perpendicular Right";
        }
        return string;
    }

    public Boolean isReversedOrder() {
        return this.mReversedOrderCheckBox.getSelected();
    }

    public Number getFrameLineWidth() {
        return this.mFrameLineWidthSpinner.getNumber();
    }

    public Color getLineColor() {
        return this.mLineColorButton.getColor();
    }

    public Number getTickMarkWidth() {
        return this.mTickMarkWidthSpinner.getNumber();
    }

    public Number getTickMarkLength() {
        return this.mTickMarkLengthSpinner.getNumber();
    }

    public Boolean isTitleVisible() {
        return this.mAxisPanel.isTitleVisible();
    }

    public String getTitleString() {
        return this.mAxisPanel.getTitleString();
    }

    public String getColorBarStyle() {
        return (String)this.mColorBarStyleComboBox.getSelectedItem();
    }

    public String getFontName() {
        return (String)this.mFontNameComboBox.getSelectedItem();
    }

    public Number getFontSize() {
        return this.mFontSizeSpinner.getNumber();
    }

    public Integer getFontStyle() {
        String string = (String)this.mFontStyleComboBox.getSelectedItem();
        return SGUtilityText.getFontStyle(string);
    }

    public Color getFontColor() {
        return this.mFontColorButton.getColor();
    }

    public Number getMinValue() {
        return this.mAxisPanel.getMinValue();
    }

    public Number getMaxValue() {
        return this.mAxisPanel.getMaxValue();
    }

    public Integer getScaleType() {
        return this.mAxisPanel.getScaleType();
    }

    public Boolean isScaleInvert() {
        return this.mAxisPanel.getInvCoordFlag();
    }

    public Boolean isTickMarkAuto() {
        return this.mAxisPanel.getAutoCalcFlag();
    }

    public Boolean isTickMarkVisible() {
        return this.mAxisPanel.isTickMarkVisible();
    }

    public Boolean isScaleLineInner() {
        return this.mAxisPanel.getScaleLineDirection();
    }

    public Boolean isFormatVisible() {
        return this.mAxisPanel.isFormatVisible();
    }

    public Boolean isFormatInteger() {
        return this.mAxisPanel.isFormatInteger();
    }

    public Boolean isExponentVisible() {
        return this.mAxisPanel.isExponentVisible();
    }

    public Number getExponentValue() {
        return this.mAxisPanel.getExponentValue();
    }

    public boolean setXValue(Object object) {
        return this.setValue(this.mXValueTextField, object);
    }

    public boolean setYValue(Object object) {
        return this.setValue(this.mYValueTextField, object);
    }

    public boolean setBarWidth(Object object) {
        return this.setValue(this.mBarWidthSpinner, object);
    }

    public boolean setBarLength(Object object) {
        return this.setValue(this.mBarLengthSpinner, object);
    }

    public boolean setSpaceLineAndScale(Object object) {
        return this.setValue(this.mSpaceLineAndScaleSpinner, object);
    }

    public boolean setSpaceScaleAndTitle(Object object) {
        return this.setValue(this.mSpaceScaleAndTitleSpinner, object);
    }

    public boolean setColorBarDirection(String string) {
        if (string == null) {
            this.mColorBarDirectionNoSelectedRadioButton.setSelected(true);
        } else if (string.equals("Horizontal Lower")) {
            this.mHorizontalLowerRadioButton.setSelected(true);
        } else if (string.equals("Horizontal Upper")) {
            this.mHorizontalUpperRadioButton.setSelected(true);
        } else if (string.equals("Perpendicular Left")) {
            this.mPerpendicularLeftRadioButton.setSelected(true);
        } else if (string.equals("Perpendicular Right")) {
            this.mPerpendicularRightRadioButton.setSelected(true);
        }
        return true;
    }

    public boolean setReversedOrder(Boolean bl) {
        this.mReversedOrderCheckBox.setSelected(bl);
        return true;
    }

    public boolean setColorBarStyle(String string) {
        this.mColorBarStyleComboBox.setSelectedItem(string);
        return true;
    }

    public boolean setFrameLineWidth(Object object) {
        return this.setValue(this.mFrameLineWidthSpinner, object);
    }

    public boolean setTickMarkWidth(Object object) {
        return this.setValue(this.mTickMarkWidthSpinner, object);
    }

    public boolean setTickMarkLength(Object object) {
        return this.setValue(this.mTickMarkLengthSpinner, object);
    }

    public boolean setLineColor(Color color) {
        this.mLineColorButton.setColor(color);
        return true;
    }

    public boolean setFontName(String string) {
        String string2 = SGUtility.findFontFamilyName(string);
        this.mFontNameComboBox.setSelectedItem(string2);
        return true;
    }

    public boolean setFontSize(Object object) {
        return this.setValue(this.mFontSizeSpinner, object);
    }

    public boolean setFontStyle(Integer n) {
        String string = null;
        if (n != null) {
            string = SGUtilityText.getFontStyleName(n);
        }
        this.mFontStyleComboBox.setSelectedItem(string);
        return true;
    }

    public boolean setFontColor(Color color) {
        this.mFontColorButton.setColor(color);
        return true;
    }

    public boolean setTitleVisible(Boolean bl) {
        return this.mAxisPanel.setTitleVisible(bl);
    }

    public boolean setTitleString(String string) {
        return this.mAxisPanel.setTitle(string);
    }

    public boolean setMinValue(Object object) {
        return this.mAxisPanel.setMinValue(object);
    }

    public boolean setMaxValue(Object object) {
        return this.mAxisPanel.setMaxValue(object);
    }

    public boolean setScaleType(Integer n) {
        return this.mAxisPanel.setScaleType(n);
    }

    public boolean setScaleInvert(Boolean bl) {
        return this.mAxisPanel.setInvertCoordinates(bl);
    }

    public boolean setTickMarkAuto(Boolean bl) {
        return this.mAxisPanel.setAutoCalcFlag(bl);
    }

    public boolean setStepValue(Object object) {
        return this.mAxisPanel.setStepValue(object);
    }

    public boolean setBaseValue(Object object) {
        return this.mAxisPanel.setBaseValue(object);
    }

    public boolean setTickMarkVisible(Boolean bl) {
        return this.mAxisPanel.setTickMarkVisible(bl);
    }

    public boolean setTickMarkInside(Boolean bl) {
        return this.mAxisPanel.setTickMarkInside(bl);
    }

    public boolean setFormatVisible(Boolean bl) {
        return this.mAxisPanel.setFormatVisible(bl);
    }

    public boolean setFormatInteger(Boolean bl) {
        return this.mAxisPanel.setFormatInteger(bl);
    }

    public boolean setExponentVisible(Boolean bl) {
        return this.mAxisPanel.setExponentVisible(bl);
    }

    public boolean setExponentValue(Object object) {
        return this.mAxisPanel.setExponentValue(object);
    }

    @Override
    public boolean setDialogProperty() {
        if (this.mPropertyDialogObserverList.size() == 0) {
            return false;
        }
        List list = this.mPropertyDialogObserverList;
        if (!this.mAxisSelectionPanel.setSelected(list)) {
            return false;
        }
        SGIColorBarDialogObserver sGIColorBarDialogObserver = (SGIColorBarDialogObserver)list.get(0);
        double d = sGIColorBarDialogObserver.getXValue();
        double d2 = sGIColorBarDialogObserver.getYValue();
        float f = sGIColorBarDialogObserver.getBarWidth("cm");
        float f2 = sGIColorBarDialogObserver.getBarLength("cm");
        float f3 = sGIColorBarDialogObserver.getSpaceToScale("cm");
        float f4 = sGIColorBarDialogObserver.getSpaceToTitle("cm");
        String string = sGIColorBarDialogObserver.getDirection();
        String string2 = sGIColorBarDialogObserver.getColorBarStyle();
        boolean bl = sGIColorBarDialogObserver.isReversedOrder();
        float f5 = sGIColorBarDialogObserver.getFrameLineWidth("pt");
        Color color = sGIColorBarDialogObserver.getLineColor();
        float f6 = sGIColorBarDialogObserver.getTickMarkWidth("pt");
        float f7 = sGIColorBarDialogObserver.getTickMarkLength("cm");
        String string3 = sGIColorBarDialogObserver.getFontName();
        float f8 = sGIColorBarDialogObserver.getFontSize("pt");
        int n = sGIColorBarDialogObserver.getFontStyle();
        Color color2 = sGIColorBarDialogObserver.getFontColor();
        Double d3 = d;
        Double d4 = d2;
        Float f9 = Float.valueOf(f);
        Float f10 = Float.valueOf(f2);
        Float f11 = Float.valueOf(f3);
        Float f12 = Float.valueOf(f4);
        String string4 = string;
        Boolean bl2 = bl;
        String string5 = string2;
        Float f13 = Float.valueOf(f5);
        Color color3 = color;
        Float f14 = Float.valueOf(f6);
        Float f15 = Float.valueOf(f7);
        String string6 = string3;
        Float f16 = Float.valueOf(f8);
        Integer n2 = n;
        Color color4 = color2;
        if (list.size() > 1) {
            double d5;
            SGIColorBarDialogObserver sGIColorBarDialogObserver2;
            int n3;
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGIColorBarDialogObserver2 = (SGIColorBarDialogObserver)list.get(n3);
                d5 = sGIColorBarDialogObserver2.getXValue();
                if (d == d5) continue;
                d3 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGIColorBarDialogObserver2 = (SGIColorBarDialogObserver)list.get(n3);
                d5 = sGIColorBarDialogObserver2.getYValue();
                if (d2 == d5) continue;
                d4 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGIColorBarDialogObserver2 = (SGIColorBarDialogObserver)list.get(n3);
                float f17 = sGIColorBarDialogObserver2.getBarWidth("cm");
                if (f == f17) continue;
                f9 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGIColorBarDialogObserver2 = (SGIColorBarDialogObserver)list.get(n3);
                float f18 = sGIColorBarDialogObserver2.getBarLength("cm");
                if (f2 == f18) continue;
                f10 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGIColorBarDialogObserver2 = (SGIColorBarDialogObserver)list.get(n3);
                float f19 = sGIColorBarDialogObserver2.getSpaceToScale("cm");
                if (f3 == f19) continue;
                f11 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGIColorBarDialogObserver2 = (SGIColorBarDialogObserver)list.get(n3);
                float f20 = sGIColorBarDialogObserver2.getSpaceToTitle("cm");
                if (f4 == f20) continue;
                f12 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGIColorBarDialogObserver2 = (SGIColorBarDialogObserver)list.get(n3);
                String string7 = sGIColorBarDialogObserver2.getDirection();
                if (string.equals(string7)) continue;
                string4 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGIColorBarDialogObserver2 = (SGIColorBarDialogObserver)list.get(n3);
                boolean bl3 = sGIColorBarDialogObserver2.isReversedOrder();
                if (bl == bl3) continue;
                bl2 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGIColorBarDialogObserver2 = (SGIColorBarDialogObserver)list.get(n3);
                String string8 = sGIColorBarDialogObserver2.getColorBarStyle();
                if (string2.equals(string8)) continue;
                string5 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGIColorBarDialogObserver2 = (SGIColorBarDialogObserver)list.get(n3);
                float f21 = sGIColorBarDialogObserver2.getFrameLineWidth("pt");
                if (f5 == f21) continue;
                f13 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGIColorBarDialogObserver2 = (SGIColorBarDialogObserver)list.get(n3);
                float f22 = sGIColorBarDialogObserver2.getTickMarkWidth("pt");
                if (f6 == f22) continue;
                f14 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGIColorBarDialogObserver2 = (SGIColorBarDialogObserver)list.get(n3);
                float f23 = sGIColorBarDialogObserver2.getTickMarkWidth("cm");
                if (f7 == f23) continue;
                f15 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGIColorBarDialogObserver2 = (SGIColorBarDialogObserver)list.get(n3);
                String string9 = sGIColorBarDialogObserver2.getFontName();
                if (string3.equals(string9)) continue;
                string6 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGIColorBarDialogObserver2 = (SGIColorBarDialogObserver)list.get(n3);
                float f24 = sGIColorBarDialogObserver2.getFontSize("pt");
                if (f8 == f24) continue;
                f16 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGIColorBarDialogObserver2 = (SGIColorBarDialogObserver)list.get(n3);
                int n4 = sGIColorBarDialogObserver2.getFontStyle();
                if (n == n4) continue;
                n2 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGIColorBarDialogObserver2 = (SGIColorBarDialogObserver)list.get(n3);
                Color color5 = sGIColorBarDialogObserver2.getFontColor();
                if (color2.equals(color5)) continue;
                color4 = null;
                break;
            }
        }
        this.setXValue(d3);
        this.setYValue(d4);
        this.setBarWidth(f9);
        this.setBarLength(f10);
        this.setSpaceLineAndScale(f11);
        this.setSpaceScaleAndTitle(f12);
        this.setColorBarDirection(string4);
        this.setReversedOrder(bl2);
        this.setColorBarStyle(string5);
        this.setFrameLineWidth(f13);
        this.setTickMarkWidth(f14);
        this.setTickMarkLength(f15);
        this.setLineColor(color3);
        this.setFontName(string6);
        this.setFontStyle(n2);
        this.setFontSize(f16);
        this.setFontColor(color4);
        return this.mAxisPanel.setComponentsProperty(new ArrayList(this.mPropertyDialogObserverList));
    }

    @Override
    public boolean setPropertiesToListeners(SGIPropertyDialogObserver sGIPropertyDialogObserver) {
        SGIColorBarDialogObserver sGIColorBarDialogObserver = (SGIColorBarDialogObserver)sGIPropertyDialogObserver;
        int n = this.mAxisSelectionPanel.getXAxisLocation();
        int n2 = this.mAxisSelectionPanel.getYAxisLocation();
        Number number = this.getXValue();
        Number number2 = this.getYValue();
        Number number3 = this.getBarWidth();
        Number number4 = this.getBarLength();
        Number number5 = this.getSpaceLineAndScale();
        Number number6 = this.getSpaceScaleAndTitle();
        String string = this.getColorBarDirection();
        Boolean bl = this.isReversedOrder();
        String string2 = this.getColorBarStyle();
        Number number7 = this.getFrameLineWidth();
        Color color = this.getLineColor();
        Number number8 = this.getTickMarkWidth();
        Number number9 = this.getTickMarkLength();
        String string3 = this.getFontName();
        Number number10 = this.getFontSize();
        Integer n3 = this.getFontStyle();
        Color color2 = this.getFontColor();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!sGIColorBarDialogObserver.hasValidXAxisValue(n, number)) {
            arrayList.add("X");
        }
        if (!sGIColorBarDialogObserver.hasValidYAxisValue(n2, number2)) {
            arrayList.add("Y");
        }
        if (arrayList.size() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Axis value is invalid");
            stringBuffer.append(":\n");
            for (int i = 0; i < arrayList.size(); ++i) {
                String string4 = (String)arrayList.get(i);
                stringBuffer.append('-');
                stringBuffer.append(string4);
                stringBuffer.append('\n');
            }
            this.setInputErrorMessage(stringBuffer.toString());
            return false;
        }
        if (n != -1) {
            sGIColorBarDialogObserver.setXAxisLocation(n);
        }
        if (n2 != -1) {
            sGIColorBarDialogObserver.setYAxisLocation(n2);
        }
        if (number != null) {
            sGIColorBarDialogObserver.setXValue(number.doubleValue());
        }
        if (number2 != null) {
            sGIColorBarDialogObserver.setYValue(number2.doubleValue());
        }
        if (number3 != null) {
            sGIColorBarDialogObserver.setBarWidth(number3.floatValue(), "cm");
        }
        if (number4 != null) {
            sGIColorBarDialogObserver.setBarLength(number4.floatValue(), "cm");
        }
        if (number5 != null) {
            sGIColorBarDialogObserver.setSpaceToScale(number5.floatValue(), "cm");
        }
        if (number6 != null) {
            sGIColorBarDialogObserver.setSpaceToTitle(number6.floatValue(), "cm");
        }
        if (string != null) {
            sGIColorBarDialogObserver.setDirection(string);
        }
        if (bl != null) {
            sGIColorBarDialogObserver.setReversedOrder(bl);
        }
        if (string2 != null) {
            sGIColorBarDialogObserver.setColorBarStyle(string2);
        }
        if (number7 != null) {
            sGIColorBarDialogObserver.setFrameLineWidth(number7.floatValue(), "pt");
        }
        if (color != null) {
            sGIColorBarDialogObserver.setLineColor(color);
        }
        if (number8 != null) {
            sGIColorBarDialogObserver.setTickMarkWidth(number8.floatValue(), "pt");
        }
        if (number9 != null) {
            sGIColorBarDialogObserver.setTickMarkLength(number9.floatValue(), "cm");
        }
        if (string3 != null) {
            sGIColorBarDialogObserver.setFontName(string3);
        }
        if (number10 != null) {
            sGIColorBarDialogObserver.setFontSize(number10.floatValue(), "pt");
        }
        if (n3 != null) {
            sGIColorBarDialogObserver.setFontStyle(n3);
        }
        if (color2 != null) {
            sGIColorBarDialogObserver.setFontColor(color2);
        }
        return this.mAxisPanel.setPropertiesToListeners(sGIColorBarDialogObserver);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object.equals(this.mColorBarStyleComboBox)) {
            this.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (object.equals(this.mReversedOrderCheckBox)) {
            this.repaint();
        }
    }

    @Override
    protected boolean hasValidInputValues() {
        boolean bl = true;
        if (!super.hasValidInputValues()) {
            bl = false;
        }
        if (!this.hasValidNumber(this.mXValueTextField, null, null)) {
            bl = false;
        }
        if (!this.hasValidNumber(this.mYValueTextField, null, null)) {
            bl = false;
        }
        ArrayList arrayList = this.mAxisPanel.getNumberTextFieldList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGTextField sGTextField = (SGTextField)arrayList.get(i);
            if (this.hasValidNumber(sGTextField, null, null)) continue;
            bl = false;
        }
        ArrayList<SGSpinner> arrayList2 = this.mAxisPanel.getSpinnerList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGSpinner sGSpinner = (SGSpinner)arrayList2.get(i);
            if (sGSpinner.hasValidValue()) continue;
            this.addInputErrorDescription(sGSpinner.getDescription());
            bl = false;
        }
        ArrayList arrayList3 = this.mAxisPanel.getTextFieldComponentsList();
        for (int i = 0; i < arrayList3.size(); ++i) {
            SGTextField sGTextField = (SGTextField)arrayList3.get(i);
            if (sGTextField.hasValidText()) continue;
            this.addInputErrorDescription(sGTextField.getDescription());
            bl = false;
        }
        return bl;
    }

    class ColorBarPanel
    extends JPanel {
        private static final long serialVersionUID = 1829361019103918985L;
        private SGColorBarStyleManager mColorBarStyleManager = new SGColorBarStyleManager();

        public ColorBarPanel() {
            this.setOpaque(false);
        }

        public void paintComponent(Graphics graphics) {
            String string = (String)SGColorBarDialog.this.mColorBarStyleComboBox.getSelectedItem();
            if (string != null) {
                SGColorBarModel sGColorBarModel = this.mColorBarStyleManager.getColorBarModel(string);
                Boolean bl = SGColorBarDialog.this.mReversedOrderCheckBox.getSelected();
                if (sGColorBarModel != null && bl != null) {
                    sGColorBarModel.setValueRange(0.0, 1.0);
                    sGColorBarModel.setReversedOrder(bl);
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    Rectangle rectangle = this.getBounds();
                    double d = ((RectangularShape)rectangle).getWidth();
                    int n = (int)d;
                    int n2 = (int)((RectangularShape)rectangle).getHeight();
                    for (int i = 0; i < n; ++i) {
                        double d2 = (double)i / (double)n;
                        Rectangle rectangle2 = new Rectangle(i, 0, 1, n2);
                        Color color = sGColorBarModel.evaluate(d2);
                        graphics2D.setPaint(color);
                        graphics2D.fill(rectangle2);
                    }
                }
            }
        }
    }
}

