/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementSymbol;
import jp.riken.brain.ni.samuraigraph.figure.SGIArrowConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGStroke;
import org.w3c.dom.Element;

public abstract class SGDrawingElementArrow
extends SGDrawingElement
implements SGIArrowConstants,
SGIDrawingElementConstants {
    protected SGDrawingElementLine mLine;
    protected SGDrawingElementSymbol mStartHead;
    protected SGDrawingElementSymbol mEndHead;

    protected abstract SGDrawingElementLine createBodyInstance();

    protected abstract SGDrawingElementSymbol createHeadInstance(SGDrawingElementArrow var1, boolean var2);

    protected SGDrawingElementLine getLine() {
        return this.mLine;
    }

    protected SGDrawingElementSymbol getStartHead() {
        return this.mStartHead;
    }

    protected SGDrawingElementSymbol getEndHead() {
        return this.mEndHead;
    }

    public void dispose() {
        super.dispose();
        this.mLine.dispose();
        this.mStartHead.dispose();
        this.mEndHead.dispose();
        this.mLine = null;
        this.mStartHead = null;
        this.mEndHead = null;
    }

    public boolean contains(int n, int n2) {
        boolean bl = this.getLine().contains(n, n2);
        if (bl) {
            return true;
        }
        boolean bl2 = this.getStartHead().contains(n, n2);
        if (bl2) {
            return true;
        }
        boolean bl3 = this.getEndHead().contains(n, n2);
        return bl3;
    }

    public abstract Color getColor();

    public abstract SGStroke getStroke();

    public abstract float getGradient();

    public abstract boolean setColor(Color var1);

    public boolean setStart(SGTuple2f sGTuple2f) {
        return this.setLocation(sGTuple2f, this.getEnd());
    }

    public abstract boolean setStartX(float var1);

    public abstract boolean setStartY(float var1);

    public boolean setEnd(SGTuple2f sGTuple2f) {
        return this.setLocation(this.getStart(), sGTuple2f);
    }

    public abstract boolean setEndX(float var1);

    public abstract boolean setEndY(float var1);

    public abstract boolean setLocation(SGTuple2f var1, SGTuple2f var2);

    public boolean setTermPoints(float f, float f2, float f3, float f4) {
        return this.setLocation(new SGTuple2f(f, f2), new SGTuple2f(f3, f4));
    }

    public float getStartX() {
        return this.getStart().x;
    }

    public float getStartY() {
        return this.getStart().y;
    }

    public float getEndX() {
        return this.getEnd().x;
    }

    public float getEndY() {
        return this.getEnd().y;
    }

    public abstract SGTuple2f getStart();

    public abstract SGTuple2f getEnd();

    public abstract boolean setLineWidth(float var1);

    public boolean setLineWidth(float f, String string) {
        Float f2 = SGUtility.getLineWidth(f, string);
        if (f2 == null) {
            return false;
        }
        return this.setLineWidth(f2.floatValue());
    }

    public abstract boolean setLineType(int var1);

    public abstract boolean setHeadSize(float var1);

    public boolean setHeadSize(float f, String string) {
        Float f2 = SGUtility.calcPropertyValue(f, string, "cm", 0.05, 2.0, -2);
        if (f2 == null) {
            return false;
        }
        return this.setHeadSize(f2.floatValue());
    }

    public abstract boolean setStartHeadType(int var1);

    public abstract boolean setEndHeadType(int var1);

    public abstract float getLineWidth();

    public abstract int getLineType();

    public abstract float getHeadSize();

    public abstract boolean setHeadAngle(Float var1, Float var2);

    public abstract float getHeadOpenAngle();

    public abstract float getHeadCloseAngle();

    public abstract int getStartHeadType();

    public abstract int getEndHeadType();

    public SGProperties getProperties() {
        ArrowProperties arrowProperties = new ArrowProperties();
        if (!this.getProperties(arrowProperties)) {
            return null;
        }
        return arrowProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof ArrowProperties)) {
            return false;
        }
        if (!super.getProperties(sGProperties)) {
            return false;
        }
        ArrowProperties arrowProperties = (ArrowProperties)sGProperties;
        arrowProperties.setLineWidth(this.getLineWidth());
        arrowProperties.setLineType(this.getLineType());
        arrowProperties.setHeadSize(this.getHeadSize());
        arrowProperties.setHeadOpenAngle(this.getHeadOpenAngle());
        arrowProperties.setHeadCloseAngle(this.getHeadCloseAngle());
        arrowProperties.setStartHeadType(this.getStartHeadType());
        arrowProperties.setEndHeadType(this.getEndHeadType());
        arrowProperties.setColor(this.getColor());
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof ArrowProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        ArrowProperties arrowProperties = (ArrowProperties)sGProperties;
        Float f = arrowProperties.getLineWidth();
        if (f == null) {
            return false;
        }
        this.setLineWidth(f.floatValue());
        Integer n = arrowProperties.getLineType();
        if (n == null) {
            return false;
        }
        this.setLineType(n);
        Float f2 = arrowProperties.getHeadSize();
        if (f2 == null) {
            return false;
        }
        this.setHeadSize(f2.floatValue());
        Float f3 = arrowProperties.getHeadOpenAngle();
        if (f3 == null) {
            return false;
        }
        Float f4 = arrowProperties.getHeadCloseAngle();
        if (f4 == null) {
            return false;
        }
        this.setHeadAngle(Float.valueOf(f3.floatValue()), Float.valueOf(f4.floatValue()));
        Integer n2 = arrowProperties.getStartHeadType();
        if (n2 == null) {
            return false;
        }
        this.setStartHeadType(n2);
        Integer n3 = arrowProperties.getEndHeadType();
        if (n3 == null) {
            return false;
        }
        this.setEndHeadType(n3);
        Color color = arrowProperties.getColor();
        if (color == null) {
            return false;
        }
        this.setColor(color);
        return true;
    }

    public static boolean isValidArrowHeadType(int n) {
        if (SGDrawingElementSymbol.isValidSymbolType(n)) {
            return true;
        }
        int[] nArray = new int[]{-1, 8, 10};
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean isLineTypeSymbol(int n) {
        if (SGDrawingElementSymbol.isLineTypeSymbol(n)) {
            return true;
        }
        return n == 8;
    }

    public static Integer getArrowHeadTypeFromName(String string) {
        Integer n = SGDrawingElementSymbol.getSymbolTypeFromName(string);
        if (n != null) {
            return n;
        }
        if (SGUtilityText.isEqualString("No Symbol", string)) {
            n = -1;
        } else if (SGUtilityText.isEqualString("Transverse Line", string)) {
            n = 8;
        } else if (SGUtilityText.isEqualString("Arrow Head", string)) {
            n = 10;
        }
        return n;
    }

    public static String getArrowHeadTypeName(int n) {
        String string = SGDrawingElementSymbol.getSymbolTypeName(n);
        if (string == null) {
            switch (n) {
                case -1: {
                    string = "No Symbol";
                    break;
                }
                case 8: {
                    string = "Transverse Line";
                    break;
                }
                case 10: {
                    string = "Arrow Head";
                    break;
                }
            }
        }
        return string;
    }

    public boolean writeProperty(Element element) {
        float f = (float)SGUtilityNumber.roundOffNumber(this.getLineWidth(), -3);
        float f2 = (float)SGUtilityNumber.roundOffNumber(this.getHeadSize() * 0.035277776f, -3);
        float f3 = (float)SGUtilityNumber.roundOffNumber(this.getHeadOpenAngle(), -3);
        float f4 = (float)SGUtilityNumber.roundOffNumber(this.getHeadCloseAngle(), -3);
        element.setAttribute("Width", Float.toString(f) + "pt");
        element.setAttribute("Type", SGDrawingElementLine.getLineTypeName(this.getLineType()));
        element.setAttribute("HeadSize", Float.toString(f2) + "cm");
        element.setAttribute("StartHeadType", SGDrawingElementArrow.getArrowHeadTypeName(this.getStartHeadType()));
        element.setAttribute("EndHeadType", SGDrawingElementArrow.getArrowHeadTypeName(this.getEndHeadType()));
        element.setAttribute("HeadOpenAngle", Float.toString(f3));
        element.setAttribute("HeadCloseAngle", Float.toString(f4));
        ArrayList<Color> arrayList = new ArrayList<Color>();
        arrayList.add(this.getColor());
        element.setAttribute("Color", SGUtilityText.getColorListString(arrayList));
        return true;
    }

    public boolean readProperty(Element element) {
        float f;
        StringBuffer stringBuffer;
        String string = null;
        Number number = null;
        List<Color> list = null;
        string = element.getAttribute("Width");
        if (string.length() != 0) {
            stringBuffer = new StringBuffer();
            number = SGUtilityText.getNumber(string, stringBuffer);
            if (number == null) {
                return false;
            }
            f = number.floatValue();
            if (!this.setLineWidth(f, stringBuffer.toString())) {
                return false;
            }
        }
        if ((string = element.getAttribute("Type")).length() != 0) {
            number = SGDrawingElementLine.getLineTypeFromName(string);
            if (number == null) {
                return false;
            }
            int n = number.intValue();
            if (!this.setLineType(n)) {
                return false;
            }
        }
        if ((string = element.getAttribute("HeadSize")).length() != 0) {
            stringBuffer = new StringBuffer();
            number = SGUtilityText.getNumber(string, stringBuffer);
            if (number == null) {
                return false;
            }
            f = number.floatValue();
            if (!this.setHeadSize(f, stringBuffer.toString())) {
                return false;
            }
        }
        if ((string = element.getAttribute("StartHeadType")).length() != 0) {
            number = SGDrawingElementArrow.getArrowHeadTypeFromName(string);
            if (number == null) {
                return false;
            }
            int n = number.intValue();
            if (!this.setStartHeadType(n)) {
                return false;
            }
        }
        if ((string = element.getAttribute("EndHeadType")).length() != 0) {
            number = SGDrawingElementArrow.getArrowHeadTypeFromName(string);
            if (number == null) {
                return false;
            }
            int n = number.intValue();
            if (!this.setEndHeadType(n)) {
                return false;
            }
        }
        if ((string = element.getAttribute("Color")).length() != 0) {
            list = SGUtilityText.getColorList(string);
            if (list == null) {
                return false;
            }
            if (list.size() == 0) {
                return false;
            }
            Color color = list.get(0);
            if (!this.setColor(color)) {
                return false;
            }
        }
        if ((string = element.getAttribute("HeadOpenAngle")).length() != 0) {
            number = SGUtilityText.getFloat(string, SGIConstants.degree);
            if (number == null) {
                return false;
            }
            float f2 = number.floatValue();
            string = element.getAttribute("HeadCloseAngle");
            if (string.length() != 0) {
                number = SGUtilityText.getFloat(string, SGIConstants.degree);
                if (number == null) {
                    return false;
                }
                f = number.floatValue();
                if (!this.setHeadAngle(Float.valueOf(f2), Float.valueOf(f))) {
                    return false;
                }
            }
        }
        return true;
    }

    public static class ArrowProperties
    extends SGDrawingElement.DrawingElementProperties {
        private SGDrawingElementLine.LineProperties mLineProperties = new SGDrawingElementLine.LineProperties();
        private SGDrawingElementSymbol.SymbolProperties mSymbolProperties = new SGDrawingElementSymbol.SymbolProperties();
        private int mEndHeadType;
        private double mHeadOpenAngle;
        private double mHeadCloseAngle;
        private Color mColor = null;

        public boolean equals(Object object) {
            if (!(object instanceof ArrowProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            ArrowProperties arrowProperties = (ArrowProperties)object;
            if (!this.mLineProperties.equals(arrowProperties.mLineProperties)) {
                return false;
            }
            if (!this.mSymbolProperties.equals(arrowProperties.mSymbolProperties)) {
                return false;
            }
            if (this.mEndHeadType != arrowProperties.mEndHeadType) {
                return false;
            }
            if (this.mHeadOpenAngle != arrowProperties.mHeadOpenAngle) {
                return false;
            }
            if (this.mHeadCloseAngle != arrowProperties.mHeadCloseAngle) {
                return false;
            }
            return SGUtility.equals(this.mColor, arrowProperties.mColor);
        }

        public Float getLineWidth() {
            return this.mLineProperties.getLineWidth();
        }

        public Integer getLineType() {
            return this.mLineProperties.getLineType();
        }

        public Float getHeadSize() {
            return this.mSymbolProperties.getSize();
        }

        public Integer getStartHeadType() {
            return this.mSymbolProperties.getSymbolType();
        }

        public Integer getEndHeadType() {
            return this.mEndHeadType;
        }

        public Float getHeadOpenAngle() {
            return Float.valueOf((float)this.mHeadOpenAngle);
        }

        public Float getHeadCloseAngle() {
            return Float.valueOf((float)this.mHeadCloseAngle);
        }

        public Color getColor() {
            return this.mColor;
        }

        public boolean setLineWidth(float f) {
            if (!this.mLineProperties.setLineWidth(f)) {
                return false;
            }
            return this.mSymbolProperties.setLineWidth(f);
        }

        public boolean setLineType(int n) {
            return this.mLineProperties.setLineType(n);
        }

        public boolean setStartHeadType(int n) {
            return this.mSymbolProperties.setSymbolType(n);
        }

        public boolean setEndHeadType(int n) {
            this.mEndHeadType = n;
            return true;
        }

        public boolean setHeadSize(float f) {
            return this.mSymbolProperties.setSize(f);
        }

        public boolean setColor(Color color) {
            this.mColor = color;
            return true;
        }

        public boolean setHeadOpenAngle(float f) {
            this.mHeadOpenAngle = f;
            return true;
        }

        public boolean setHeadCloseAngle(float f) {
            this.mHeadCloseAngle = f;
            return true;
        }
    }
}

