/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGILineConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGStroke;

public abstract class SGDrawingElementLine
extends SGDrawingElement
implements SGILineConstants,
SGIDrawingElementConstants {
    protected abstract SGStroke getStroke();

    public SGDrawingElementLine() {
    }

    public SGDrawingElementLine(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        this.setTermPoints(sGTuple2f, sGTuple2f2);
    }

    public SGDrawingElementLine(float f, float f2, float f3, float f4) {
        this.setTermPoints(f, f2, f3, f4);
    }

    public boolean setTermPoints(float f, float f2, float f3, float f4) {
        return this.setTermPoints(new SGTuple2f(f, f2), new SGTuple2f(f3, f4));
    }

    public abstract boolean setTermPoints(SGTuple2f var1, SGTuple2f var2);

    public abstract boolean setLineWidth(float var1);

    public abstract boolean setLineType(int var1);

    public boolean setCap(int n) {
        this.getStroke().setEndCap(n);
        return true;
    }

    public abstract SGTuple2f getStart();

    public abstract SGTuple2f getEnd();

    public int getLineType() {
        return this.getStroke().getLineType();
    }

    public float getLineWidth() {
        return this.getStroke().getLineWidth();
    }

    public abstract Color getColor();

    public abstract boolean setColor(Color var1);

    public int getCap() {
        return this.getStroke().getEndCap();
    }

    public float getMagnitude() {
        SGTuple2f sGTuple2f = this.getStart();
        SGTuple2f sGTuple2f2 = this.getEnd();
        float f = sGTuple2f2.x - sGTuple2f.x;
        float f2 = sGTuple2f2.y - sGTuple2f.y;
        float f3 = (float)Math.sqrt(f * f + f2 * f2);
        return f3;
    }

    public static boolean isValidLineType(int n) {
        int[] nArray = new int[]{1, 2, 3, 4, 5};
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            return true;
        }
        return false;
    }

    public static Integer getLineTypeFromName(String string) {
        int n;
        if (string == null) {
            return null;
        }
        if (SGUtilityText.isEqualString("Solid", string)) {
            n = 1;
        } else if (SGUtilityText.isEqualString("Broken", string)) {
            n = 2;
        } else if (SGUtilityText.isEqualString("Dotted", string)) {
            n = 3;
        } else if (SGUtilityText.isEqualString("Dashed", string)) {
            n = 4;
        } else if (SGUtilityText.isEqualString("Double Dashed", string)) {
            n = 5;
        } else {
            return null;
        }
        return n;
    }

    public static String getLineTypeName(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = "Solid";
                break;
            }
            case 2: {
                string = "Broken";
                break;
            }
            case 3: {
                string = "Dotted";
                break;
            }
            case 4: {
                string = "Dashed";
                break;
            }
            case 5: {
                string = "Double Dashed";
                break;
            }
        }
        return string;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof LineProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        LineProperties lineProperties = (LineProperties)sGProperties;
        Float f = lineProperties.getLineWidth();
        if (f == null) {
            return false;
        }
        Integer n = lineProperties.getLineType();
        if (n == null) {
            return false;
        }
        Color color = lineProperties.getColor();
        if (color == null) {
            return false;
        }
        this.setLineWidth(f.floatValue());
        this.setLineType(n);
        this.setColor(color);
        return true;
    }

    public SGProperties getProperties() {
        LineProperties lineProperties = new LineProperties();
        if (!this.getProperties(lineProperties)) {
            return null;
        }
        return lineProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof LineProperties)) {
            return false;
        }
        if (!super.getProperties(sGProperties)) {
            return false;
        }
        LineProperties lineProperties = (LineProperties)sGProperties;
        lineProperties.setLineWidth(this.getLineWidth());
        lineProperties.setLineType(this.getLineType());
        lineProperties.setColor(this.getColor());
        return true;
    }

    public static class LineProperties
    extends SGDrawingElement.DrawingElementProperties {
        private float mLineWidth = 0.0f;
        private int mLineType = -1;
        private Color mColor = null;

        public boolean equals(Object object) {
            if (!(object instanceof LineProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            LineProperties lineProperties = (LineProperties)object;
            if (lineProperties.mLineWidth != this.mLineWidth) {
                return false;
            }
            if (lineProperties.mLineType != this.mLineType) {
                return false;
            }
            return SGUtility.equals(lineProperties.mColor, this.mColor);
        }

        public Float getLineWidth() {
            return Float.valueOf(this.mLineWidth);
        }

        public Integer getLineType() {
            return this.mLineType;
        }

        public Color getColor() {
            return this.mColor;
        }

        public boolean setLineWidth(float f) {
            this.mLineWidth = f;
            return true;
        }

        public boolean setLineType(int n) {
            this.mLineType = n;
            return true;
        }

        public boolean setColor(Color color) {
            this.mColor = color;
            return true;
        }
    }
}

