/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGFillPaint;
import jp.riken.brain.ni.samuraigraph.base.SGIPaint;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGSelectablePaint;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.SGIRectangleConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGPaintUtility;
import jp.riken.brain.ni.samuraigraph.figure.SGStroke;
import org.w3c.dom.Element;

public abstract class SGDrawingElementRectangle
extends SGDrawingElement
implements SGIRectangleConstants {
    protected abstract SGStroke getStroke();

    public abstract float getX();

    public abstract float getY();

    public SGTuple2f getLocation() {
        return new SGTuple2f(this.getX(), this.getY());
    }

    public abstract float getWidth();

    public abstract float getHeight();

    public abstract float getEdgeLineWidth();

    public abstract Color getEdgeLineColor();

    public abstract boolean isEdgeLineVisible();

    public abstract SGIPaint getInnerPaint();

    public abstract int getEdgeLineType();

    public abstract float getTransparency();

    public abstract boolean setEdgeLineWidth(float var1);

    public boolean setEdgeLineWidth(float f, String string) {
        Float f2 = SGUtility.getLineWidth(f, string);
        if (f2 == null) {
            return false;
        }
        return this.setEdgeLineWidth(f2.floatValue());
    }

    public abstract boolean setEdgeLineType(int var1);

    public abstract boolean setEdgeLineColor(Color var1);

    public abstract boolean setEdgeLineVisible(boolean var1);

    public abstract boolean setInnerPaint(SGIPaint var1);

    public abstract boolean setTransparent(float var1);

    public abstract boolean setX(float var1);

    public abstract boolean setY(float var1);

    public boolean setLocation(float f, float f2) {
        this.setX(f);
        this.setY(f2);
        return true;
    }

    public boolean setLocation(SGTuple2f sGTuple2f) {
        this.setLocation(sGTuple2f.x, sGTuple2f.y);
        return true;
    }

    public abstract boolean setWidth(float var1);

    public boolean setWidth(float f, String string) {
        return this.setWidth((float)SGUtilityText.convertToPoint(f, string));
    }

    public abstract boolean setHeight(float var1);

    public boolean setHeight(float f, String string) {
        return this.setHeight((float)SGUtilityText.convertToPoint(f, string));
    }

    public boolean setSize(float f, float f2) {
        this.setWidth(f);
        this.setHeight(f2);
        return true;
    }

    public boolean setBounds(float f, float f2, float f3, float f4) {
        this.setLocation(f, f2);
        this.setSize(f3, f4);
        return true;
    }

    public SGProperties getProperties() {
        RectangleProperties rectangleProperties = new RectangleProperties();
        if (!this.getProperties(rectangleProperties)) {
            return null;
        }
        return rectangleProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof RectangleProperties)) {
            return false;
        }
        if (!super.getProperties(sGProperties)) {
            return false;
        }
        RectangleProperties rectangleProperties = (RectangleProperties)sGProperties;
        rectangleProperties.setHeight(this.getHeight());
        rectangleProperties.setWidth(this.getWidth());
        rectangleProperties.setEdgeLineWidth(this.getEdgeLineWidth());
        rectangleProperties.setEdgeLineType(this.getEdgeLineType());
        rectangleProperties.setEdgeLineColor(this.getEdgeLineColor());
        rectangleProperties.setEdgeLineVisible(this.isEdgeLineVisible());
        rectangleProperties.setInnerPaint(this.getInnerPaint());
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof RectangleProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        RectangleProperties rectangleProperties = (RectangleProperties)sGProperties;
        Float f = rectangleProperties.getWidth();
        if (f == null) {
            return false;
        }
        this.setWidth(f.floatValue());
        Float f2 = rectangleProperties.getHeight();
        if (f2 == null) {
            return false;
        }
        this.setHeight(f2.floatValue());
        Float f3 = rectangleProperties.getEdgeLineWidth();
        if (f3 == null) {
            return false;
        }
        this.setEdgeLineWidth(f3.floatValue());
        int n = rectangleProperties.getEdgeLineType();
        if (n == -1) {
            return false;
        }
        this.setEdgeLineType(n);
        Color color = rectangleProperties.getEdgeLineColor();
        if (color == null) {
            return false;
        }
        this.setEdgeLineColor(color);
        Boolean bl = rectangleProperties.isEdgeLineVisible();
        if (bl == null) {
            return false;
        }
        this.setEdgeLineVisible(bl);
        this.setTransparent(rectangleProperties.getTransparency());
        SGIPaint sGIPaint = rectangleProperties.getInnerPaint();
        if (sGIPaint == null) {
            return false;
        }
        this.setInnerPaint(sGIPaint);
        return true;
    }

    public boolean writeProperty(Element element) {
        float f = (float)SGUtilityNumber.roundOffNumber(this.getEdgeLineWidth(), -3);
        element.setAttribute("EdgeLineWidth", Float.toString(f) + "pt");
        element.setAttribute("EdgeLineType", SGDrawingElementLine.getLineTypeName(this.getEdgeLineType()));
        element.setAttribute("EdgeLineColor", SGUtilityText.getColorString(this.getEdgeLineColor()));
        element.setAttribute("EdgeLineVisible", Boolean.toString(this.isEdgeLineVisible()));
        return SGPaintUtility.writeProperty(element, this.getInnerPaint());
    }

    public boolean readProperty(Element element) {
        Object object;
        String string = null;
        Number number = null;
        Color color = null;
        Boolean bl = null;
        string = element.getAttribute("EdgeLineWidth");
        if (string.length() != 0) {
            object = new StringBuffer();
            number = SGUtilityText.getNumber(string, (StringBuffer)object);
            if (number == null) {
                return false;
            }
            float f = number.floatValue();
            if (!this.setEdgeLineWidth(f, ((StringBuffer)object).toString())) {
                return false;
            }
        }
        if ((string = element.getAttribute("EdgeLineType")).length() != 0) {
            number = SGDrawingElementLine.getLineTypeFromName(string);
            if (number == null) {
                return false;
            }
            int n = number.intValue();
            if (!this.setEdgeLineType(n)) {
                return false;
            }
        }
        if ((string = element.getAttribute("InnerColor")).length() != 0) {
            object = SGUtilityText.getColorList(string);
            if (object == null) {
                return false;
            }
            if (object.size() < 1) {
                return false;
            }
            color = (Color)object.get(0);
            SGSelectablePaint sGSelectablePaint = new SGSelectablePaint();
            sGSelectablePaint.setSelectedPaintStyle(0);
            sGSelectablePaint.setFillColor(color);
            if (!this.setInnerPaint(sGSelectablePaint)) {
                return false;
            }
            string = element.getAttribute("Transparent");
            if (string.length() != 0 && (bl = SGUtilityText.getBoolean(string)) != null && (bl == false ? !this.setTransparent(1.0f) : !this.setTransparent(0.0f))) {
                return false;
            }
        } else {
            object = SGPaintUtility.readProperty(element);
            if (null != object) {
                this.setInnerPaint((SGIPaint)object);
            } else {
                return false;
            }
        }
        string = element.getAttribute("EdgeLineColor");
        if (string.length() != 0) {
            color = SGUtilityText.parseColor(string);
            if (color == null) {
                return false;
            }
            object = color;
            if (!this.setEdgeLineColor((Color)object)) {
                return false;
            }
        }
        if ((string = element.getAttribute("EdgeLineVisible")).length() != 0) {
            bl = SGUtilityText.getBoolean(string);
            if (bl == null) {
                return false;
            }
            if (!this.setEdgeLineVisible(bl)) {
                return false;
            }
        }
        return true;
    }

    public static class RectangleProperties
    extends SGDrawingElement.DrawingElementProperties {
        private float mWidth = 0.0f;
        private float mHeight = 0.0f;
        private float mEdgeLineWidth = 0.0f;
        private int mEdgeLineType = -1;
        private Color mEdgeLineColor = null;
        private boolean mEdgeLineVisible = true;
        private SGIPaint mInnerPaint = new SGFillPaint();

        public boolean equals(Object object) {
            if (!(object instanceof RectangleProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            RectangleProperties rectangleProperties = (RectangleProperties)object;
            if (this.mWidth != rectangleProperties.mWidth) {
                return false;
            }
            if (this.mHeight != rectangleProperties.mHeight) {
                return false;
            }
            if (this.mEdgeLineWidth != rectangleProperties.mEdgeLineWidth) {
                return false;
            }
            if (this.mEdgeLineType != rectangleProperties.mEdgeLineType) {
                return false;
            }
            if (this.mEdgeLineVisible != rectangleProperties.mEdgeLineVisible) {
                return false;
            }
            if (!SGUtility.equals(this.mEdgeLineColor, rectangleProperties.mEdgeLineColor)) {
                return false;
            }
            return this.mInnerPaint.equals(rectangleProperties.mInnerPaint);
        }

        public Float getWidth() {
            return Float.valueOf(this.mWidth);
        }

        public Float getHeight() {
            return Float.valueOf(this.mHeight);
        }

        public Float getEdgeLineWidth() {
            return Float.valueOf(this.mEdgeLineWidth);
        }

        public int getEdgeLineType() {
            return this.mEdgeLineType;
        }

        public Color getEdgeLineColor() {
            return this.mEdgeLineColor;
        }

        public Boolean isEdgeLineVisible() {
            return this.mEdgeLineVisible;
        }

        public SGIPaint getInnerPaint() {
            try {
                return (SGIPaint)this.mInnerPaint.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError(cloneNotSupportedException.getMessage());
            }
        }

        public float getTransparency() {
            return this.mInnerPaint.getAlpha();
        }

        public boolean setWidth(float f) {
            this.mWidth = f;
            return true;
        }

        public boolean setHeight(float f) {
            this.mHeight = f;
            return true;
        }

        public boolean setEdgeLineWidth(float f) {
            this.mEdgeLineWidth = f;
            return true;
        }

        public boolean setEdgeLineType(int n) {
            this.mEdgeLineType = n;
            return true;
        }

        public boolean setEdgeLineColor(Color color) {
            this.mEdgeLineColor = color;
            return true;
        }

        public boolean setEdgeLineVisible(boolean bl) {
            this.mEdgeLineVisible = bl;
            return true;
        }

        public boolean setInnerPaint(SGIPaint sGIPaint) {
            this.mInnerPaint = sGIPaint;
            return true;
        }

        public boolean setTransparent(float f) {
            return this.mInnerPaint.setAlpha(f);
        }
    }
}

