/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementString;
import jp.riken.brain.ni.samuraigraph.figure.SGISignificantDifferenceConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGIStringConstants;
import org.w3c.dom.Element;

public abstract class SGDrawingElementSignificantDifference
extends SGDrawingElement
implements SGISignificantDifferenceConstants,
SGIStringConstants {
    private float mX;
    private float mY;
    private float mWidth;
    private float mPerpendicularHeight1;
    private float mPerpendicularHeight2;
    private float mSpace;
    private float mLineWidth;
    private boolean mLineVisibleFlag = true;
    private SGDrawingElementString mStringElement;
    private SGDrawingElementLine mHorizontalLine;
    private SGDrawingElementLine mPerpendicularLine1;
    private SGDrawingElementLine mPerpendicularLine2;
    private Color mColor = null;

    public boolean isLineVisible() {
        return this.mLineVisibleFlag;
    }

    public boolean setLineVisible(boolean bl) {
        this.mLineVisibleFlag = bl;
        return true;
    }

    public SGDrawingElementSignificantDifference() {
        this.mStringElement = this.createString();
        this.mHorizontalLine = this.createLine();
        this.mPerpendicularLine1 = this.createLine();
        this.mPerpendicularLine2 = this.createLine();
    }

    public SGDrawingElementSignificantDifference(float f, float f2, float f3, float f4, float f5) {
        this.setLocation(f, f2);
        this.setSize(f3, f4, f5);
    }

    protected abstract SGDrawingElementString createString();

    protected abstract SGDrawingElementLine createLine();

    public void dispose() {
        super.dispose();
        this.mHorizontalLine.dispose();
        this.mPerpendicularLine1.dispose();
        this.mPerpendicularLine2.dispose();
        this.mStringElement.dispose();
        this.mHorizontalLine = null;
        this.mPerpendicularLine1 = null;
        this.mPerpendicularLine2 = null;
        this.mStringElement = null;
    }

    public boolean contains(int n, int n2) {
        if (this.isLineVisible()) {
            if (this.mHorizontalLine.contains(n, n2)) {
                return true;
            }
            if (this.mPerpendicularLine1.contains(n, n2)) {
                return true;
            }
            if (this.mPerpendicularLine2.contains(n, n2)) {
                return true;
            }
        }
        return this.mStringElement.contains(n, n2);
    }

    public float getX() {
        return this.mX;
    }

    public float getY() {
        return this.mY;
    }

    public float getX1() {
        return this.getX();
    }

    public float getX2() {
        return this.getX1() + this.getMagnification() * this.getWidth();
    }

    public float getY1() {
        return this.getY() + this.getMagnification() * this.getPerpendicularHeight1();
    }

    public float getY2() {
        return this.getY() + this.getMagnification() * this.getPerpendicularHeight2();
    }

    public float getWidth() {
        return this.mWidth;
    }

    public float getPerpendicularHeight1() {
        return this.mPerpendicularHeight1;
    }

    public float getPerpendicularHeight2() {
        return this.mPerpendicularHeight2;
    }

    public float getSpace() {
        return this.mSpace;
    }

    public final SGDrawingElementString getStringElement() {
        return this.mStringElement;
    }

    protected final SGDrawingElementLine getHorizontalLine() {
        return this.mHorizontalLine;
    }

    protected final SGDrawingElementLine getPerpendicularLine1() {
        return this.mPerpendicularLine1;
    }

    protected final SGDrawingElementLine getPerpendicularLine2() {
        return this.mPerpendicularLine2;
    }

    public String getText() {
        return this.mStringElement.getString();
    }

    public float getFontSize() {
        return this.mStringElement.getFontSize();
    }

    public int getFontStyle() {
        return this.mStringElement.getFontStyle();
    }

    public String getFontName() {
        return this.mStringElement.getFontName();
    }

    public float getLineWidth() {
        return this.mLineWidth;
    }

    public Color getColor() {
        return this.mColor;
    }

    public boolean setColor(Color color) {
        this.mColor = color;
        this.mStringElement.setColor(color);
        return true;
    }

    public boolean setLocation(float f, float f2) {
        this.setX(f);
        this.setY(f2);
        return true;
    }

    public boolean setX(float f) {
        this.mX = f;
        return true;
    }

    public boolean setY(float f) {
        this.mY = f;
        return true;
    }

    public boolean setSize(float f, float f2, float f3) {
        this.setWidth(f);
        this.setPerpendicularHeight1(f2);
        this.setPerpendicularHeight2(f3);
        return true;
    }

    public boolean setWidth(float f) {
        this.mWidth = f;
        return true;
    }

    public boolean setWidth(float f, String string) {
        return this.setWidth((float)SGUtilityText.convertToPoint(f, string));
    }

    public boolean setPerpendicularHeight1(float f) {
        this.mPerpendicularHeight1 = f;
        return true;
    }

    public boolean setPerpendicularHeight1(float f, String string) {
        return this.setPerpendicularHeight1((float)SGUtilityText.convertToPoint(f, string));
    }

    public boolean setPerpendicularHeight2(float f) {
        this.mPerpendicularHeight2 = f;
        return true;
    }

    public boolean setPerpendicularHeight2(float f, String string) {
        return this.setPerpendicularHeight2((float)SGUtilityText.convertToPoint(f, string));
    }

    public boolean setSpace(float f) {
        this.mSpace = f;
        return true;
    }

    public boolean setSpace(float f, String string) {
        Float f2 = SGUtility.calcPropertyValue(f, string, "cm", -1.0, 1.0, -2);
        if (f2 == null) {
            return false;
        }
        return this.setSpace(f2.floatValue());
    }

    public boolean setText(String string) {
        if (string == null) {
            throw new IllegalArgumentException("text==null");
        }
        this.mStringElement.setString(string);
        return true;
    }

    public boolean setLineWidth(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("lw < 0.0f");
        }
        this.mLineWidth = f;
        this.mHorizontalLine.setLineWidth(f);
        this.mPerpendicularLine1.setLineWidth(f);
        this.mPerpendicularLine2.setLineWidth(f);
        return true;
    }

    public boolean setLineWidth(float f, String string) {
        Float f2 = SGUtility.getLineWidth(f, string);
        if (f2 == null) {
            return false;
        }
        return this.setLineWidth(f2.floatValue());
    }

    public boolean setFont(String string, int n, float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("size < 0.0f");
        }
        this.mStringElement.setFont(string, n, f);
        return true;
    }

    public boolean setFontName(String string) {
        int n = this.mStringElement.getFontStyle();
        float f = this.mStringElement.getFontSize();
        return this.setFont(string, n, f);
    }

    public boolean setFontSize(float f) {
        String string = this.mStringElement.getFontName();
        int n = this.mStringElement.getFontStyle();
        return this.setFont(string, n, f);
    }

    public boolean setFontSize(float f, String string) {
        Float f2 = SGUtility.getFontSize(f, string);
        if (f2 == null) {
            return false;
        }
        return this.setFontSize(f2.floatValue());
    }

    public boolean setFontStyle(int n) {
        if (!SGUtilityText.isValidFontStyle(n)) {
            return false;
        }
        String string = this.getFontName();
        float f = this.getFontSize();
        return this.setFont(string, n, f);
    }

    public boolean isFlippingHorizontal() {
        return this.mWidth < 0.0f;
    }

    public boolean isFlippingVertical() {
        return this.isFlippingVertical1() && this.isFlippingVertical2();
    }

    public boolean isFlippingVertical1() {
        return this.mPerpendicularHeight1 < 0.0f;
    }

    public boolean isFlippingVertical2() {
        return this.mPerpendicularHeight2 < 0.0f;
    }

    public boolean isFlippingVerticalLeft() {
        return !this.isFlippingHorizontal() ? this.isFlippingVertical1() : this.isFlippingVertical2();
    }

    public boolean isFlippingVerticalRight() {
        return !this.isFlippingHorizontal() ? this.isFlippingVertical2() : this.isFlippingVertical1();
    }

    public float getLeftHeight() {
        if (!this.isFlippingHorizontal()) {
            return this.getPerpendicularHeight1();
        }
        return this.getPerpendicularHeight2();
    }

    public float getRightHeight() {
        if (!this.isFlippingHorizontal()) {
            return this.getPerpendicularHeight2();
        }
        return this.getPerpendicularHeight1();
    }

    public boolean setLeftHeight(float f) {
        if (!this.isFlippingHorizontal()) {
            this.setPerpendicularHeight1(f);
        } else {
            this.setPerpendicularHeight2(f);
        }
        return true;
    }

    public boolean setRightHeight(float f) {
        if (!this.isFlippingHorizontal()) {
            this.setPerpendicularHeight2(f);
        } else {
            this.setPerpendicularHeight1(f);
        }
        return true;
    }

    public boolean setNodePointLocation(float f, float f2, float f3, float f4, float f5) {
        float f6 = this.getMagnification();
        float f7 = (f3 - f) / f6;
        this.setX(f);
        this.setWidth(f7);
        this.setY(f5);
        float f8 = (f2 - f5) / f6;
        float f9 = (f4 - f5) / f6;
        this.setPerpendicularHeight1(f8);
        this.setPerpendicularHeight2(f9);
        return true;
    }

    public SGProperties getProperties() {
        SigDiffProperties sigDiffProperties = new SigDiffProperties();
        if (!this.getProperties(sigDiffProperties)) {
            return null;
        }
        return sigDiffProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof SigDiffProperties)) {
            return false;
        }
        if (!super.getProperties(sGProperties)) {
            return false;
        }
        SigDiffProperties sigDiffProperties = (SigDiffProperties)sGProperties;
        sigDiffProperties.mSpace = this.mSpace;
        sigDiffProperties.mLineVisible = this.mLineVisibleFlag;
        sigDiffProperties.mLineWidth = this.mLineWidth;
        sigDiffProperties.mText = this.getText();
        sigDiffProperties.mFontName = this.getFontName();
        sigDiffProperties.mFontSize = this.getFontSize();
        sigDiffProperties.mFontStyle = this.getFontStyle();
        sigDiffProperties.mColor = this.getColor();
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof SigDiffProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        SigDiffProperties sigDiffProperties = (SigDiffProperties)sGProperties;
        this.mSpace = sigDiffProperties.mSpace;
        this.setText(sigDiffProperties.mText);
        this.setFont(sigDiffProperties.mFontName, sigDiffProperties.mFontStyle, sigDiffProperties.mFontSize);
        this.setLineVisible(sigDiffProperties.mLineVisible);
        this.setLineWidth(sigDiffProperties.mLineWidth);
        this.setColor(sigDiffProperties.getColor());
        return true;
    }

    public boolean writeProperty(Element element) {
        float f = (float)SGUtilityNumber.roundOffNumber(this.getFontSize(), -3);
        float f2 = (float)SGUtilityNumber.roundOffNumber(this.getLineWidth(), -3);
        float f3 = (float)SGUtilityNumber.roundOffNumber(this.getSpace() * 0.035277776f, -3);
        ArrayList<Color> arrayList = new ArrayList<Color>();
        arrayList.add(this.mColor);
        element.setAttribute("Text", this.getText());
        element.setAttribute("FontName", this.getFontName());
        element.setAttribute("FontSize", Float.toString(f) + "pt");
        element.setAttribute("FontStyle", SGUtilityText.getFontStyleName(this.getFontStyle()));
        element.setAttribute("Color", SGUtilityText.getColorListString(arrayList));
        element.setAttribute("LineVisible", Boolean.toString(this.isLineVisible()));
        element.setAttribute("LineWidth", Float.toString(f2) + "pt");
        element.setAttribute("Space", Float.toString(f3) + "cm");
        return true;
    }

    public boolean readProperty(Element element) {
        float f;
        Object object;
        String string = null;
        Number number = null;
        Boolean bl = null;
        List<Color> list = null;
        string = element.getAttribute("Text");
        if (string.length() != 0 && !this.setText((String)(object = string))) {
            return false;
        }
        string = element.getAttribute("FontName");
        if (string.length() != 0 && !this.setFontName((String)(object = string))) {
            return false;
        }
        string = element.getAttribute("FontSize");
        if (string.length() != 0) {
            object = new StringBuffer();
            number = SGUtilityText.getNumber(string, (StringBuffer)object);
            if (number == null) {
                return false;
            }
            f = number.floatValue();
            if (!this.setFontSize(f, ((StringBuffer)object).toString())) {
                return false;
            }
        }
        if ((string = element.getAttribute("FontStyle")).length() != 0) {
            object = SGUtilityText.getFontStyle(string);
            if (object == null) {
                return false;
            }
            if (!this.setFontStyle((Integer)object)) {
                return false;
            }
        }
        if ((string = element.getAttribute("Color")).length() != 0) {
            list = SGUtilityText.getColorList(string);
            if (list == null) {
                return false;
            }
            if (list.size() < 1) {
                return false;
            }
            object = list.get(0);
            if (!this.setColor((Color)object)) {
                return false;
            }
        }
        if ((string = element.getAttribute("LineVisible")).length() != 0) {
            bl = SGUtilityText.getBoolean(string);
            if (bl == null) {
                return false;
            }
            boolean bl2 = bl;
            if (!this.setLineVisible(bl2)) {
                return false;
            }
        }
        if ((string = element.getAttribute("LineWidth")).length() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            number = SGUtilityText.getNumber(string, stringBuffer);
            if (number == null) {
                return false;
            }
            f = number.floatValue();
            if (!this.setLineWidth(f, stringBuffer.toString())) {
                return false;
            }
        }
        if ((string = element.getAttribute("Space")).length() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            number = SGUtilityText.getNumber(string, stringBuffer);
            if (number == null) {
                return false;
            }
            f = number.floatValue();
            if (!this.setSpace(f, stringBuffer.toString())) {
                return false;
            }
        }
        return true;
    }

    public static class SigDiffProperties
    extends SGDrawingElement.DrawingElementProperties {
        private float mSpace;
        private float mLineWidth;
        private String mText;
        private String mFontName;
        private float mFontSize;
        private int mFontStyle;
        private boolean mLineVisible;
        private Color mColor;

        public boolean equals(Object object) {
            if (!(object instanceof SigDiffProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            SigDiffProperties sigDiffProperties = (SigDiffProperties)object;
            if (sigDiffProperties.mSpace != this.mSpace) {
                return false;
            }
            if (sigDiffProperties.mLineWidth != this.mLineWidth) {
                return false;
            }
            if (!SGUtility.equals(sigDiffProperties.mText, this.mText)) {
                return false;
            }
            if (!SGUtility.equals(sigDiffProperties.mFontName, this.mFontName)) {
                return false;
            }
            if (sigDiffProperties.mFontSize != this.mFontSize) {
                return false;
            }
            if (sigDiffProperties.mFontStyle != this.mFontStyle) {
                return false;
            }
            if (sigDiffProperties.mLineVisible != this.mLineVisible) {
                return false;
            }
            return SGUtility.equals(sigDiffProperties.mColor, this.mColor);
        }

        public Float getSpace() {
            return Float.valueOf(this.mSpace);
        }

        public Float getLineWidth() {
            return Float.valueOf(this.mLineWidth);
        }

        public String getText() {
            return this.mText;
        }

        public String getFontName() {
            return this.mFontName;
        }

        public Float getFontSize() {
            return Float.valueOf(this.mFontSize);
        }

        public Integer getFontStyle() {
            return this.mFontStyle;
        }

        public Boolean getLineVisible() {
            return this.mLineVisible;
        }

        public Color getColor() {
            return this.mColor;
        }

        public void setSpace(float f) {
            this.mSpace = f;
        }

        public void setLineWidth(float f) {
            this.mLineWidth = f;
        }

        public void setText(String string) {
            this.mText = string;
        }

        public void setFontName(String string) {
            this.mFontName = string;
        }

        public void setFontSize(float f) {
            this.mFontSize = f;
        }

        public void setFontStyle(int n) {
            this.mFontStyle = n;
        }

        public void setLineVisible(boolean bl) {
            this.mLineVisible = bl;
        }

        public void setColor(Color color) {
            this.mColor = color;
        }
    }
}

