/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGFillPaint;
import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIPaint;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGISymbolConstants;

public abstract class SGDrawingElementSymbol
extends SGDrawingElement
implements SGISymbolConstants,
SGIDrawingElementConstants {
    public abstract boolean setX(float var1);

    public abstract boolean setY(float var1);

    public abstract boolean setLocation(float var1, float var2);

    public abstract boolean setLocation(SGTuple2f var1);

    public abstract boolean setSize(float var1);

    public abstract boolean setType(int var1);

    public abstract boolean setAngle(float var1);

    public abstract boolean setLineColor(Color var1);

    public abstract boolean setInnerColor(Color var1);

    public abstract boolean setLineWidth(float var1);

    public abstract boolean setLineVisible(boolean var1);

    public abstract SGTuple2f getLocation();

    public float getX() {
        return this.getLocation().x;
    }

    public float getY() {
        return this.getLocation().y;
    }

    public abstract float getAngle();

    public abstract float getSize();

    public abstract int getType();

    public abstract SGIPaint getInnerPaint();

    public abstract Color getLineColor();

    public abstract float getLineWidth();

    public abstract boolean isLineVisible();

    public static boolean isValidSymbolType(int n) {
        int[] nArray = new int[]{1, 2, 3, 4, 5, 6, 7};
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            return true;
        }
        return false;
    }

    public static Integer getSymbolTypeFromName(String string) {
        int n;
        if (string == null) {
            return null;
        }
        if (SGUtilityText.isEqualString("Circle", string)) {
            n = 1;
        } else if (SGUtilityText.isEqualString("Square", string)) {
            n = 2;
        } else if (SGUtilityText.isEqualString("Diamond", string)) {
            n = 3;
        } else if (SGUtilityText.isEqualString("Triangle", string)) {
            n = 4;
        } else if (SGUtilityText.isEqualString("Inverted Triangle", string) || SGUtilityText.isEqualString("I-Triangle", string)) {
            n = 5;
        } else if (SGUtilityText.isEqualString("Cross", string)) {
            n = 6;
        } else if (SGUtilityText.isEqualString("Plus", string)) {
            n = 7;
        } else {
            return null;
        }
        return n;
    }

    public static String getSymbolTypeName(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = "Circle";
                break;
            }
            case 2: {
                string = "Square";
                break;
            }
            case 3: {
                string = "Diamond";
                break;
            }
            case 4: {
                string = "Triangle";
                break;
            }
            case 5: {
                string = "Inverted Triangle";
                break;
            }
            case 6: {
                string = "Cross";
                break;
            }
            case 7: {
                string = "Plus";
                break;
            }
        }
        return string;
    }

    public static boolean isLineTypeSymbol(int n) {
        return n == 6 || n == 7;
    }

    public SGProperties getProperties() {
        SymbolProperties symbolProperties = new SymbolProperties();
        this.getProperties(symbolProperties);
        return symbolProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof SymbolProperties)) {
            return false;
        }
        super.getProperties(sGProperties);
        SymbolProperties symbolProperties = (SymbolProperties)sGProperties;
        symbolProperties.setSize(this.getSize());
        symbolProperties.setSymbolType(this.getType());
        symbolProperties.setLineWidth(this.getLineWidth());
        symbolProperties.setLineColor(this.getLineColor());
        return true;
    }

    public static class SymbolProperties
    extends SGDrawingElement.DrawingElementProperties {
        private int mType = -1;
        private float mSize = 0.0f;
        private float mLineWidth = 0.0f;
        private Color mLineColor = null;
        private boolean mLineVisible = true;
        private SGFillPaint mInnerPaint = null;

        public boolean equals(Object object) {
            if (!(object instanceof SymbolProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            SymbolProperties symbolProperties = (SymbolProperties)object;
            if (symbolProperties.mType != this.mType) {
                return false;
            }
            if (symbolProperties.mSize != this.mSize) {
                return false;
            }
            if (symbolProperties.mLineWidth != this.mLineWidth) {
                return false;
            }
            if (!SGUtility.equals(symbolProperties.mLineColor, this.mLineColor)) {
                return false;
            }
            if (symbolProperties.mLineVisible != this.mLineVisible) {
                return false;
            }
            return SGUtility.equals(symbolProperties.mInnerPaint, this.mInnerPaint);
        }

        public Float getSize() {
            return Float.valueOf(this.mSize);
        }

        public Integer getSymbolType() {
            return this.mType;
        }

        public Float getLineWidth() {
            return Float.valueOf(this.mLineWidth);
        }

        public Color getLineColor() {
            return this.mLineColor;
        }

        public Boolean isLineVisible() {
            return this.mLineVisible;
        }

        public SGIPaint getInnerPaint() {
            return this.mInnerPaint;
        }

        public boolean setSize(float f) {
            this.mSize = f;
            return true;
        }

        public boolean setSymbolType(int n) {
            this.mType = n;
            return true;
        }

        public boolean setLineWidth(float f) {
            this.mLineWidth = f;
            return true;
        }

        public boolean setLineColor(Color color) {
            this.mLineColor = color;
            return true;
        }

        public boolean setLineVisible(boolean bl) {
            this.mLineVisible = bl;
            return true;
        }

        public boolean setInnerPaint(SGIPaint sGIPaint) {
            try {
                this.mInnerPaint = (SGFillPaint)sGIPaint.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError(cloneNotSupportedException.getMessage());
            }
            return true;
        }
    }
}

