/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.BasicStroke;
import java.util.HashMap;
import jp.riken.brain.ni.samuraigraph.figure.SGILineConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGStrokeDash;

public class SGStroke
implements SGILineConstants {
    private float mMagnification = 1.0f;
    private float mLineWidth = 1.0f;
    private int mLineType = 1;
    private int mCap = 0;
    private int mJoin = 2;
    private float mMiterLimit = 1.0f;
    private float mDashPhase = 0.0f;
    private HashMap mStrokeDashMap = new HashMap();
    private BasicStroke mBasicStroke = null;

    public SGStroke() {
        this.init();
    }

    private void init() {
        SGStrokeDash sGStrokeDash = new SGStrokeDash(1, 0, 2.0f, 0.0f, 1.0f);
        SGStrokeDash sGStrokeDash2 = new SGStrokeDash(1, 0, 1.0f, 0.0f, 1.0f);
        SGStrokeDash sGStrokeDash3 = new SGStrokeDash(1, 1, 4.0f, 1.0f, 1.0f);
        SGStrokeDash sGStrokeDash4 = new SGStrokeDash(1, 2, 4.0f, 1.0f, 1.0f);
        this.mStrokeDashMap.put(2, sGStrokeDash);
        this.mStrokeDashMap.put(3, sGStrokeDash2);
        this.mStrokeDashMap.put(4, sGStrokeDash3);
        this.mStrokeDashMap.put(5, sGStrokeDash4);
    }

    private boolean isValidLineType(int n) {
        if (n == 1) {
            return true;
        }
        SGStrokeDash sGStrokeDash = (SGStrokeDash)this.mStrokeDashMap.get(n);
        return sGStrokeDash != null;
    }

    public float getMagnification() {
        return this.mMagnification;
    }

    public float getLineWidth() {
        return this.mLineWidth;
    }

    public int getLineType() {
        return this.mLineType;
    }

    public float getDashPhase() {
        return this.mDashPhase;
    }

    public int getEndCap() {
        return this.mCap;
    }

    public int getLineJoin() {
        return this.mJoin;
    }

    public float getMiterLimit() {
        return this.mMiterLimit;
    }

    private SGStrokeDash getCurrentStrokeDash() {
        return this.getStrokeDash(this.mLineType);
    }

    public SGStrokeDash getStrokeDash(int n) {
        SGStrokeDash sGStrokeDash = (SGStrokeDash)this.mStrokeDashMap.get(n);
        if (sGStrokeDash == null) {
            return null;
        }
        return (SGStrokeDash)sGStrokeDash.clone();
    }

    public void setMagnification(float f) {
        if (f <= 0.0f) {
            throw new IllegalArgumentException("Magnification is not positive: " + f);
        }
        this.mMagnification = f;
        this.updateBasicStroke();
    }

    public void setLineType(int n) {
        if (!this.isValidLineType(n)) {
            throw new IllegalArgumentException("Illegal line type: " + n);
        }
        this.mLineType = n;
        this.updateBasicStroke();
    }

    public void setLineWidth(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("lineWidth < 0.0f :" + f);
        }
        this.mLineWidth = f;
        this.updateBasicStroke();
    }

    public void setDashPhase(float f) {
        this.mDashPhase = f;
    }

    public void setEndCap(int n) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("The end cap style is illegal:" + n);
        }
        this.mCap = n;
    }

    public void setJoin(int n) {
        if (n != 2 && n != 0 && n != 1) {
            throw new IllegalArgumentException("The line join style is illegal:" + n);
        }
        this.mJoin = n;
    }

    public void setMiterLimit(float f) {
        this.mMiterLimit = f;
    }

    public BasicStroke getBasicStroke() {
        return this.mBasicStroke;
    }

    private void updateBasicStroke() {
        int n;
        float f = this.mLineWidth * this.mMagnification;
        if (this.mLineType == 1) {
            this.mBasicStroke = new BasicStroke(f, this.mCap, this.mJoin);
            return;
        }
        SGStrokeDash sGStrokeDash = this.getCurrentStrokeDash();
        int n2 = sGStrokeDash.getLineNum1();
        int n3 = sGStrokeDash.getLineNum2();
        float f2 = sGStrokeDash.getLineLen1();
        float f3 = sGStrokeDash.getLineLen2();
        float f4 = sGStrokeDash.getSpace();
        int n4 = n2 + n3;
        float[] fArray = new float[2 * n4];
        for (n = 0; n < n2; ++n) {
            fArray[2 * n] = f2 * f;
            fArray[2 * n + 1] = f4 * f;
        }
        for (n = n2; n < n4; ++n) {
            fArray[2 * n] = f3 * f;
            fArray[2 * n + 1] = f4 * f;
        }
        this.mBasicStroke = new BasicStroke(f, this.mCap, this.mJoin, this.mMiterLimit, fArray, this.mDashPhase);
    }

    public void setLineNumber1(int n, int n2) {
        SGStrokeDash sGStrokeDash = this.getStrokeDash(n);
        if (sGStrokeDash == null) {
            throw new IllegalArgumentException("Illegal line type: " + n);
        }
        sGStrokeDash.setLineNum1(n2);
        this.updateBasicStroke();
    }

    public void setLineNumber2(int n, int n2) {
        SGStrokeDash sGStrokeDash = this.getStrokeDash(n);
        if (sGStrokeDash == null) {
            throw new IllegalArgumentException("Illegal line type: " + n);
        }
        sGStrokeDash.setLineNum2(n2);
        this.updateBasicStroke();
    }

    public void setLineLength1(int n, float f) {
        SGStrokeDash sGStrokeDash = this.getStrokeDash(n);
        if (sGStrokeDash == null) {
            throw new IllegalArgumentException("Illegal line type: " + n);
        }
        sGStrokeDash.setLineLen1(f);
        this.updateBasicStroke();
    }

    public void setLineLength2(int n, float f) {
        SGStrokeDash sGStrokeDash = this.getStrokeDash(n);
        if (sGStrokeDash == null) {
            throw new IllegalArgumentException("Illegal line type: " + n);
        }
        sGStrokeDash.setLineLen2(f);
        this.updateBasicStroke();
    }

    public void setSpace(int n, float f) {
        SGStrokeDash sGStrokeDash = this.getStrokeDash(n);
        if (sGStrokeDash == null) {
            throw new IllegalArgumentException("Illegal line type: " + n);
        }
        sGStrokeDash.setSpace(f);
        this.updateBasicStroke();
    }

    public int getLineNum1(int n) {
        SGStrokeDash sGStrokeDash = this.getStrokeDash(n);
        if (sGStrokeDash == null) {
            throw new IllegalArgumentException("Illegal line type: " + n);
        }
        return sGStrokeDash.getLineNum1();
    }

    public int getLineNum2(int n) {
        SGStrokeDash sGStrokeDash = this.getStrokeDash(n);
        if (sGStrokeDash == null) {
            throw new IllegalArgumentException("Illegal line type: " + n);
        }
        return sGStrokeDash.getLineNum2();
    }

    public float getLineLength1(int n) {
        SGStrokeDash sGStrokeDash = this.getStrokeDash(n);
        if (sGStrokeDash == null) {
            throw new IllegalArgumentException("Illegal line type: " + n);
        }
        return sGStrokeDash.getLineLen1();
    }

    public float getLineLength2(int n) {
        SGStrokeDash sGStrokeDash = this.getStrokeDash(n);
        if (sGStrokeDash == null) {
            throw new IllegalArgumentException("Illegal line type: " + n);
        }
        return sGStrokeDash.getLineLen2();
    }

    public float getSpace(int n) {
        SGStrokeDash sGStrokeDash = this.getStrokeDash(n);
        if (sGStrokeDash == null) {
            throw new IllegalArgumentException("Illegal line type: " + n);
        }
        return sGStrokeDash.getSpace();
    }
}

