/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.util.ArrayList;
import java.util.List;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.data.SGIVXYTypeData;
import jp.riken.brain.ni.samuraigraph.figure.SGElementGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGUtilityForFigureElement {
    public static final int MAGNITUDE_PER_CM_MINIMAL_ORDER = 3;

    public static float roundMagnitudePerCM(float f, SGIVXYTypeData sGIVXYTypeData) {
        if (Float.isNaN(f)) {
            return Float.NaN;
        }
        double[] dArray = sGIVXYTypeData.getMagnitudeArray();
        float f2 = (float)SGUtilityNumber.max(dArray);
        if (Float.isNaN(f2) || f2 <= 0.0f) {
            return f;
        }
        float f3 = (float)SGUtilityNumber.getNumberInNumberOrder(f, f2, 3, 4);
        return f3;
    }

    public static List<SGElementGroup> getGroups(Class clazz, List<SGElementGroup> list) {
        ArrayList<SGElementGroup> arrayList = new ArrayList<SGElementGroup>();
        for (int i = 0; i < list.size(); ++i) {
            SGElementGroup sGElementGroup = list.get(i);
            if (!clazz.isAssignableFrom(sGElementGroup.getClass())) continue;
            arrayList.add(sGElementGroup);
        }
        return arrayList;
    }

    public static SGElementGroup getGroup(Class clazz, List<SGElementGroup> list) {
        if (null == list) {
            return null;
        }
        for (int i = 0; i < list.size(); ++i) {
            SGElementGroup sGElementGroup = list.get(i);
            if (!clazz.isAssignableFrom(sGElementGroup.getClass())) continue;
            return sGElementGroup;
        }
        return null;
    }
}

