/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import java.awt.Frame;
import java.io.Serializable;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingWindow;
import jp.riken.brain.ni.samuraigraph.base.SGFigure;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementAxisBreak;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementGrid;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementShape;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementSignificantDifference;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementString;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementTimingLine;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyMap;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyResults;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.SGIFigureTypeConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGIXYFigureDialogObserver;
import jp.riken.brain.ni.samuraigraph.figure.SGXYFigureDialog;

public class SGXYFigure
extends SGFigure
implements SGIXYFigureDialogObserver,
SGIFigureTypeConstants {
    public SGXYFigure(SGDrawingWindow sGDrawingWindow) {
        super(sGDrawingWindow);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SGXYFigure.this.mPropertyDialog = new SGXYFigureDialog((Frame)SGXYFigure.this.mWnd, true);
            }
        });
    }

    public String getType() {
        return "XY";
    }

    public SGPropertyDialog getPropertyDialog() {
        SGPropertyDialog sGPropertyDialog = null;
        if (this.mPropertyDialog != null) {
            sGPropertyDialog = this.mPropertyDialog;
        } else {
            this.mPropertyDialog = sGPropertyDialog = new SGXYFigureDialog((Frame)this.mWnd, true);
        }
        return sGPropertyDialog;
    }

    public SGIFigureElementGrid getGridElement() {
        return (SGIFigureElementGrid)this.getIFigureElement(SGIFigureElementGrid.class);
    }

    public SGIFigureElement getSymbolElement(int n) {
        Class clazz = null;
        switch (n) {
            case 0: {
                clazz = SGIFigureElementString.class;
                break;
            }
            case 1: {
                clazz = SGIFigureElementAxisBreak.class;
                break;
            }
            case 2: {
                clazz = SGIFigureElementSignificantDifference.class;
                break;
            }
            case 3: {
                clazz = SGIFigureElementTimingLine.class;
                break;
            }
            case 4: {
                clazz = SGIFigureElementShape.class;
            }
        }
        if (clazz == null) {
            return null;
        }
        return this.getIFigureElement(clazz);
    }

    public int getXAxisLocation() {
        return this.getGridElement().getXAxisLocation();
    }

    public int getYAxisLocation() {
        return this.getGridElement().getYAxisLocation();
    }

    public boolean setXAxisLocation(int n) {
        return this.getGridElement().setXAxisLocation(n);
    }

    public boolean setYAxisLocation(int n) {
        return this.getGridElement().setYAxisLocation(n);
    }

    public boolean setGridVisible(boolean bl) {
        return this.getGridElement().setGridVisible(bl);
    }

    public boolean setAutoCalculateRange(boolean bl) {
        return this.getGridElement().setAutoRangeFlag(bl);
    }

    public boolean setGridStepValueX(double d) {
        return this.getGridElement().setStepValueX(d);
    }

    public boolean setGridStepValueY(double d) {
        return this.getGridElement().setStepValueY(d);
    }

    public boolean setGridBaselineValueX(double d) {
        return this.getGridElement().setBaselineValueX(d);
    }

    public boolean setGridBaselineValueY(double d) {
        return this.getGridElement().setBaselineValueY(d);
    }

    public boolean setGridLineWidth(float f, String string) {
        return this.getGridElement().setLineWidth(f, string);
    }

    public boolean setGridLineType(int n) {
        return this.getGridElement().setLineType(n);
    }

    public boolean setGridLineColor(Color color) {
        return this.getGridElement().setColor(color);
    }

    public boolean isGridVisible() {
        return this.getGridElement().isGridVisible();
    }

    public boolean isAutoCalculateRange() {
        return this.getGridElement().isAutoRange();
    }

    public double getGridStepValueX() {
        return this.getGridElement().getStepValueX();
    }

    public double getGridStepValueY() {
        return this.getGridElement().getStepValueY();
    }

    public double getGridBaselineValueX() {
        return this.getGridElement().getBaselineValueX();
    }

    public double getGridBaselineValueY() {
        return this.getGridElement().getBaselineValueY();
    }

    public float getGridLineWidth(String string) {
        return this.getGridElement().getLineWidth(string);
    }

    public int getGridLineType() {
        return this.getGridElement().getLineType();
    }

    public Color getGridLineColor() {
        return this.getGridElement().getColor();
    }

    public boolean hasValidStepXValue(Number number) {
        return this.getGridElement().hasValidStepXValue(number);
    }

    public boolean hasValidStepYValue(Number number) {
        return this.getGridElement().hasValidStepYValue(number);
    }

    public SGProperties getProperties() {
        XYFigureProperties xYFigureProperties = new XYFigureProperties();
        if (!this.getProperties(xYFigureProperties)) {
            return null;
        }
        return xYFigureProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof XYFigureProperties)) {
            return false;
        }
        if (!super.getProperties(sGProperties)) {
            return false;
        }
        XYFigureProperties xYFigureProperties = (XYFigureProperties)sGProperties;
        SGIFigureElementGrid sGIFigureElementGrid = this.getGridElement();
        xYFigureProperties.mXAxisConfiguration = sGIFigureElementGrid.getXAxisLocation();
        xYFigureProperties.mYAxisConfiguration = sGIFigureElementGrid.getYAxisLocation();
        xYFigureProperties.mBaselineValueX = sGIFigureElementGrid.getBaselineValueX();
        xYFigureProperties.mBaselineValueY = sGIFigureElementGrid.getBaselineValueY();
        xYFigureProperties.mStepValueX = sGIFigureElementGrid.getStepValueX();
        xYFigureProperties.mStepValueY = sGIFigureElementGrid.getStepValueY();
        xYFigureProperties.mVisibleFlag = sGIFigureElementGrid.isGridVisible();
        xYFigureProperties.mAutoRangeFlag = sGIFigureElementGrid.isAutoRange();
        xYFigureProperties.mLineWidth = sGIFigureElementGrid.getLineWidth();
        xYFigureProperties.mLineType = sGIFigureElementGrid.getLineType();
        xYFigureProperties.mColor = sGIFigureElementGrid.getColor();
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof XYFigureProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        XYFigureProperties xYFigureProperties = (XYFigureProperties)sGProperties;
        SGIFigureElementGrid sGIFigureElementGrid = this.getGridElement();
        sGIFigureElementGrid.setXAxisLocation(xYFigureProperties.mXAxisConfiguration);
        sGIFigureElementGrid.setYAxisLocation(xYFigureProperties.mYAxisConfiguration);
        sGIFigureElementGrid.setBaselineValueX(xYFigureProperties.mBaselineValueX);
        sGIFigureElementGrid.setBaselineValueY(xYFigureProperties.mBaselineValueY);
        sGIFigureElementGrid.setStepValueX(xYFigureProperties.mStepValueX);
        sGIFigureElementGrid.setStepValueY(xYFigureProperties.mStepValueY);
        sGIFigureElementGrid.setGridVisible(xYFigureProperties.mVisibleFlag);
        sGIFigureElementGrid.setAutoRangeFlag(xYFigureProperties.mAutoRangeFlag);
        sGIFigureElementGrid.setLineWidth(xYFigureProperties.mLineWidth);
        sGIFigureElementGrid.setLineType(xYFigureProperties.mLineType);
        sGIFigureElementGrid.setColor(xYFigureProperties.mColor);
        return true;
    }

    protected SGPropertyResults setProperties(SGPropertyMap sGPropertyMap, SGPropertyResults sGPropertyResults) {
        SGPropertyResults sGPropertyResults2 = (SGPropertyResults)sGPropertyResults.clone();
        if ((sGPropertyResults2 = super.setProperties(sGPropertyMap, sGPropertyResults2)) == null) {
            return null;
        }
        Iterator<String> iterator = sGPropertyMap.getKeyIterator();
        while (iterator.hasNext()) {
            Serializable serializable;
            String string = iterator.next();
            String string2 = sGPropertyMap.getValueString(string);
            if ("GridVisible".equalsIgnoreCase(string)) {
                serializable = SGUtilityText.getBoolean(string2);
                if (serializable == null) {
                    sGPropertyResults2.putResult("GridVisible", 1);
                    continue;
                }
                if (!this.setGridVisible((Boolean)serializable)) {
                    sGPropertyResults2.putResult("GridVisible", 1);
                    continue;
                }
                sGPropertyResults2.putResult("GridVisible", 0);
                continue;
            }
            if ("GridAxisX".equalsIgnoreCase(string)) {
                int n = SGUtility.getAxisLocation(string2);
                if (n == -1) {
                    sGPropertyResults2.putResult("GridAxisX", 1);
                    continue;
                }
                if (!this.setXAxisLocation(n)) {
                    sGPropertyResults2.putResult("GridAxisX", 1);
                    continue;
                }
                sGPropertyResults2.putResult("GridAxisX", 0);
                continue;
            }
            if ("GridAxisY".equalsIgnoreCase(string)) {
                int n = SGUtility.getAxisLocation(string2);
                if (n == -1) {
                    sGPropertyResults2.putResult("GridAxisY", 1);
                    continue;
                }
                if (!this.setYAxisLocation(n)) {
                    sGPropertyResults2.putResult("GridAxisY", 1);
                    continue;
                }
                sGPropertyResults2.putResult("GridAxisY", 0);
                continue;
            }
            if ("GridAuto".equalsIgnoreCase(string)) {
                serializable = SGUtilityText.getBoolean(string2);
                if (serializable == null) {
                    sGPropertyResults2.putResult("GridAuto", 1);
                    continue;
                }
                if (!this.setAutoCalculateRange((Boolean)serializable)) {
                    sGPropertyResults2.putResult("GridAuto", 1);
                    continue;
                }
                sGPropertyResults2.putResult("GridAuto", 0);
                continue;
            }
            if ("GridStepX".equalsIgnoreCase(string)) {
                serializable = SGUtilityText.getDouble(string2);
                if (serializable == null) {
                    sGPropertyResults2.putResult("GridStepX", 1);
                    continue;
                }
                if (!SGUtility.isValidPropertyValue(((Number)serializable).doubleValue())) {
                    sGPropertyResults2.putResult("GridStepX", 1);
                    continue;
                }
                if (!this.setGridStepValueX(((Number)serializable).doubleValue())) {
                    sGPropertyResults2.putResult("GridStepX", 1);
                    continue;
                }
                sGPropertyResults2.putResult("GridStepX", 0);
                continue;
            }
            if ("GridStepY".equalsIgnoreCase(string)) {
                serializable = SGUtilityText.getDouble(string2);
                if (serializable == null) {
                    sGPropertyResults2.putResult("GridStepY", 1);
                    continue;
                }
                if (!SGUtility.isValidPropertyValue(((Number)serializable).doubleValue())) {
                    sGPropertyResults2.putResult("GridStepY", 1);
                    continue;
                }
                if (!this.setGridStepValueY(((Number)serializable).doubleValue())) {
                    sGPropertyResults2.putResult("GridStepY", 1);
                    continue;
                }
                sGPropertyResults2.putResult("GridStepY", 0);
                continue;
            }
            if ("GridBaseX".equalsIgnoreCase(string)) {
                serializable = SGUtilityText.getDouble(string2);
                if (serializable == null) {
                    sGPropertyResults2.putResult("GridBaseX", 1);
                    continue;
                }
                if (!SGUtility.isValidPropertyValue(((Number)serializable).doubleValue())) {
                    sGPropertyResults2.putResult("GridBaseX", 1);
                    continue;
                }
                if (!this.setGridBaselineValueX(((Number)serializable).doubleValue())) {
                    sGPropertyResults2.putResult("GridBaseX", 1);
                    continue;
                }
                sGPropertyResults2.putResult("GridBaseX", 0);
                continue;
            }
            if ("GridBaseY".equalsIgnoreCase(string)) {
                serializable = SGUtilityText.getDouble(string2);
                if (serializable == null) {
                    sGPropertyResults2.putResult("GridBaseY", 1);
                    continue;
                }
                if (!SGUtility.isValidPropertyValue(((Number)serializable).doubleValue())) {
                    sGPropertyResults2.putResult("GridBaseY", 1);
                    continue;
                }
                if (!this.setGridBaselineValueY(((Number)serializable).doubleValue())) {
                    sGPropertyResults2.putResult("GridBaseY", 1);
                    continue;
                }
                sGPropertyResults2.putResult("GridBaseY", 0);
                continue;
            }
            if ("GridLineWidth".equalsIgnoreCase(string)) {
                serializable = new StringBuffer();
                Number number = SGUtilityText.getNumber(string2, serializable);
                if (number == null) {
                    sGPropertyResults2.putResult("GridLineWidth", 1);
                    continue;
                }
                if (!this.setGridLineWidth(number.floatValue(), ((StringBuffer)serializable).toString())) {
                    sGPropertyResults2.putResult("GridLineWidth", 1);
                    continue;
                }
                sGPropertyResults2.putResult("GridLineWidth", 0);
                continue;
            }
            if ("GridLineType".equalsIgnoreCase(string)) {
                serializable = SGDrawingElementLine.getLineTypeFromName(string2);
                if (serializable == null) {
                    sGPropertyResults2.putResult("GridLineType", 1);
                    continue;
                }
                if (!this.setGridLineType((Integer)serializable)) {
                    sGPropertyResults2.putResult("GridLineType", 1);
                    continue;
                }
                sGPropertyResults2.putResult("GridLineType", 0);
                continue;
            }
            if (!"GridColor".equalsIgnoreCase(string)) continue;
            serializable = SGUtilityText.getColor(string2);
            if (serializable != null) {
                if (!this.setGridLineColor((Color)serializable)) {
                    sGPropertyResults2.putResult("GridColor", 1);
                    continue;
                }
            } else {
                serializable = SGUtilityText.parseColor(string2);
                if (serializable == null) {
                    sGPropertyResults2.putResult("GridColor", 1);
                    continue;
                }
                if (!this.setGridLineColor((Color)serializable)) {
                    sGPropertyResults2.putResult("GridColor", 1);
                    continue;
                }
            }
            sGPropertyResults2.putResult("GridColor", 0);
        }
        return sGPropertyResults2;
    }

    public static class XYFigureProperties
    extends SGFigure.FigureProperties {
        private int mXAxisConfiguration;
        private int mYAxisConfiguration;
        private double mStepValueX;
        private double mBaselineValueX;
        private double mStepValueY;
        private double mBaselineValueY;
        private boolean mVisibleFlag;
        private boolean mAutoRangeFlag;
        private float mLineWidth;
        private int mLineType;
        private Color mColor;

        public boolean equals(Object object) {
            if (!(object instanceof XYFigureProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            XYFigureProperties xYFigureProperties = (XYFigureProperties)object;
            if (this.mXAxisConfiguration != xYFigureProperties.mXAxisConfiguration) {
                return false;
            }
            if (this.mYAxisConfiguration != xYFigureProperties.mYAxisConfiguration) {
                return false;
            }
            if (this.mBaselineValueX != xYFigureProperties.mBaselineValueX) {
                return false;
            }
            if (this.mStepValueX != xYFigureProperties.mStepValueX) {
                return false;
            }
            if (this.mBaselineValueY != xYFigureProperties.mBaselineValueY) {
                return false;
            }
            if (this.mStepValueY != xYFigureProperties.mStepValueY) {
                return false;
            }
            if (this.mVisibleFlag != xYFigureProperties.mVisibleFlag) {
                return false;
            }
            if (this.mAutoRangeFlag != xYFigureProperties.mAutoRangeFlag) {
                return false;
            }
            if (this.mLineWidth != xYFigureProperties.mLineWidth) {
                return false;
            }
            if (this.mLineType != xYFigureProperties.mLineType) {
                return false;
            }
            return this.mColor.equals(xYFigureProperties.mColor);
        }
    }
}

