/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.text.JTextComponent;
import jp.riken.brain.ni.samuraigraph.base.SGButton;
import jp.riken.brain.ni.samuraigraph.base.SGCheckBox;
import jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton;
import jp.riken.brain.ni.samuraigraph.base.SGComboBox;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGTextField;
import jp.riken.brain.ni.samuraigraph.base.SGTwoAxesSelectionPanel;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.SGIFigureTypeConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGILineConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGIXYFigureDialogObserver;

public class SGXYFigureDialog
extends SGPropertyDialog
implements SGIFigureConstants,
SGIFigureTypeConstants,
SGILineConstants {
    private static final long serialVersionUID = -5394120960119844819L;
    public static final String TITLE = "Figure Properties";
    private SGCheckBox mAutoCheckBox;
    private SGTwoAxesSelectionPanel mAxisPanel;
    private SGColorSelectionButton mBackgroundColorButton;
    private JLabel mBackgroundColorLabel;
    private JLabel mBaseXValueLabel;
    private SGTextField mBaseXValueTextField;
    private JLabel mBaseYValueLabel;
    private SGTextField mBaseYValueTextField;
    private JPanel mButtonPanel;
    private SGButton mCancelButton;
    private SGCheckBox mColorBarVisibleCheckBox;
    private JSeparator mColorSeparator;
    private JPanel mFigurePanel;
    private SGButton mGridDialogButton;
    private JLabel mGridLabel;
    private JPanel mGridPanel;
    private SGCheckBox mGridVisibleCheckBox;
    private JLabel mHeightLabel;
    private SGSpinner mHeightSpinner;
    private JPanel mInnerGridPanel;
    private JLabel mLeftSpaceLabel;
    private SGCheckBox mLegendVisibleCheckBox;
    private SGColorSelectionButton mLineColorButton;
    private JLabel mLineColorLabel;
    private JLabel mLineLabel;
    private JSeparator mLineSeparator;
    private SGComboBox mLineTypeComboBox;
    private JLabel mLineTypeLabel;
    private JLabel mLineWidthLabel;
    private SGSpinner mLineWidthSpinner;
    private JLabel mLocationLabel;
    private JLabel mLocationLabel1;
    private JSeparator mLocationSeparator;
    private JSeparator mLocationSeparator1;
    private SGButton mOKButton;
    private SGButton mPreviewButton;
    private JLabel mRightSpaceLabel;
    private JLabel mSizeLabel;
    private JSeparator mSizeSeparator;
    private JLabel mSpaceLabel;
    private JLabel mSpaceLineAndScaleLabel;
    private SGSpinner mSpaceLineAndScaleSpinner;
    private JLabel mSpaceScaleAndTitleLabel;
    private SGSpinner mSpaceScaleAndTitleSpinner;
    private JSeparator mSpaceSeparator;
    private JLabel mStepXValueLabel;
    private SGTextField mStepXValueTextField;
    private JLabel mStepYValueLabel;
    private SGTextField mStepYValueTextField;
    private JTabbedPane mTabbedPane;
    private SGCheckBox mTransparentCheckBox;
    private JLabel mWidthLabel;
    private SGSpinner mWidthSpinner;
    private JLabel mXLabel;
    private SGSpinner mXSpinner;
    private JLabel mYLabel;
    private SGSpinner mYSpinner;
    private static final String MSG_STEP_ERROR = "Zero value is set to the step value";

    public SGXYFigureDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
        this.initialize();
    }

    private void initComponents() {
        this.mGridLabel = new JLabel();
        this.mGridDialogButton = new SGButton();
        this.mButtonPanel = new JPanel();
        this.mOKButton = new SGButton();
        this.mCancelButton = new SGButton();
        this.mPreviewButton = new SGButton();
        this.mTabbedPane = new JTabbedPane();
        this.mFigurePanel = new JPanel();
        this.mWidthLabel = new JLabel();
        this.mHeightLabel = new JLabel();
        this.mWidthSpinner = new SGSpinner();
        this.mHeightSpinner = new SGSpinner();
        this.mLocationLabel = new JLabel();
        this.mSizeLabel = new JLabel();
        this.mXLabel = new JLabel();
        this.mXSpinner = new SGSpinner();
        this.mYLabel = new JLabel();
        this.mYSpinner = new SGSpinner();
        this.mSpaceLabel = new JLabel();
        this.mSpaceLineAndScaleLabel = new JLabel();
        this.mSpaceScaleAndTitleLabel = new JLabel();
        this.mSpaceLineAndScaleSpinner = new SGSpinner();
        this.mSpaceScaleAndTitleSpinner = new SGSpinner();
        this.mBackgroundColorLabel = new JLabel();
        this.mBackgroundColorButton = new SGColorSelectionButton();
        this.mLegendVisibleCheckBox = new SGCheckBox();
        this.mLocationSeparator = new JSeparator();
        this.mSizeSeparator = new JSeparator();
        this.mSpaceSeparator = new JSeparator();
        this.mColorSeparator = new JSeparator();
        this.mLeftSpaceLabel = new JLabel();
        this.mRightSpaceLabel = new JLabel();
        this.mTransparentCheckBox = new SGCheckBox();
        this.mColorBarVisibleCheckBox = new SGCheckBox();
        this.mGridPanel = new JPanel();
        this.mInnerGridPanel = new JPanel();
        this.mLineLabel = new JLabel();
        this.mLineSeparator = new JSeparator();
        this.mGridVisibleCheckBox = new SGCheckBox();
        this.mLocationLabel1 = new JLabel();
        this.mLocationSeparator1 = new JSeparator();
        this.mStepXValueLabel = new JLabel();
        this.mStepXValueTextField = new SGTextField();
        this.mBaseXValueLabel = new JLabel();
        this.mBaseXValueTextField = new SGTextField();
        this.mStepYValueLabel = new JLabel();
        this.mStepYValueTextField = new SGTextField();
        this.mBaseYValueLabel = new JLabel();
        this.mBaseYValueTextField = new SGTextField();
        this.mLineTypeLabel = new JLabel();
        this.mLineTypeComboBox = new SGComboBox();
        this.mLineWidthLabel = new JLabel();
        this.mLineWidthSpinner = new SGSpinner();
        this.mLineColorLabel = new JLabel();
        this.mLineColorButton = new SGColorSelectionButton();
        this.mAutoCheckBox = new SGCheckBox();
        this.mAxisPanel = new SGTwoAxesSelectionPanel();
        this.mGridLabel.setFont(new Font("Dialog", 3, 12));
        this.mGridLabel.setText("Grid ");
        this.mGridDialogButton.setText("Show Dialog");
        this.mGridDialogButton.setFont(new Font("Dialog", 0, 12));
        this.getContentPane().setLayout(new GridBagLayout());
        this.mOKButton.setText("OK");
        this.mOKButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setText("Cancel");
        this.mCancelButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mCancelButton);
        this.mPreviewButton.setText("Preview");
        this.mPreviewButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mPreviewButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        this.mTabbedPane.setFont(new Font("Dialog", 1, 12));
        this.mFigurePanel.setFont(new Font("Dialog", 0, 12));
        this.mFigurePanel.setLayout(new GridBagLayout());
        this.mWidthLabel.setFont(new Font("Dialog", 0, 12));
        this.mWidthLabel.setText("Width");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mFigurePanel.add((Component)this.mWidthLabel, gridBagConstraints);
        this.mHeightLabel.setFont(new Font("Dialog", 0, 12));
        this.mHeightLabel.setText("Height");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.mFigurePanel.add((Component)this.mHeightLabel, gridBagConstraints);
        this.mWidthSpinner.setFont(new Font("Dialog", 0, 12));
        this.mWidthSpinner.setPreferredSize(new Dimension(75, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mFigurePanel.add((Component)this.mWidthSpinner, gridBagConstraints);
        this.mHeightSpinner.setFont(new Font("Dialog", 0, 12));
        this.mHeightSpinner.setPreferredSize(new Dimension(75, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mFigurePanel.add((Component)this.mHeightSpinner, gridBagConstraints);
        this.mLocationLabel.setFont(new Font("Dialog", 3, 12));
        this.mLocationLabel.setText("Location");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.mFigurePanel.add((Component)this.mLocationLabel, gridBagConstraints);
        this.mSizeLabel.setFont(new Font("Dialog", 3, 12));
        this.mSizeLabel.setText("Size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mFigurePanel.add((Component)this.mSizeLabel, gridBagConstraints);
        this.mXLabel.setFont(new Font("Dialog", 0, 12));
        this.mXLabel.setText("X");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mFigurePanel.add((Component)this.mXLabel, gridBagConstraints);
        this.mXSpinner.setFont(new Font("Dialog", 0, 12));
        this.mXSpinner.setPreferredSize(new Dimension(75, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mFigurePanel.add((Component)this.mXSpinner, gridBagConstraints);
        this.mYLabel.setFont(new Font("Dialog", 0, 12));
        this.mYLabel.setText("Y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.mFigurePanel.add((Component)this.mYLabel, gridBagConstraints);
        this.mYSpinner.setFont(new Font("Dialog", 0, 12));
        this.mYSpinner.setPreferredSize(new Dimension(75, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mFigurePanel.add((Component)this.mYSpinner, gridBagConstraints);
        this.mSpaceLabel.setFont(new Font("Dialog", 3, 12));
        this.mSpaceLabel.setText("Space");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mFigurePanel.add((Component)this.mSpaceLabel, gridBagConstraints);
        this.mSpaceLineAndScaleLabel.setFont(new Font("Dialog", 0, 12));
        this.mSpaceLineAndScaleLabel.setText("to Scale");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mFigurePanel.add((Component)this.mSpaceLineAndScaleLabel, gridBagConstraints);
        this.mSpaceScaleAndTitleLabel.setFont(new Font("Dialog", 0, 12));
        this.mSpaceScaleAndTitleLabel.setText("to Title");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.mFigurePanel.add((Component)this.mSpaceScaleAndTitleLabel, gridBagConstraints);
        this.mSpaceLineAndScaleSpinner.setFont(new Font("Dialog", 0, 12));
        this.mSpaceLineAndScaleSpinner.setPreferredSize(new Dimension(75, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mFigurePanel.add((Component)this.mSpaceLineAndScaleSpinner, gridBagConstraints);
        this.mSpaceScaleAndTitleSpinner.setFont(new Font("Dialog", 0, 12));
        this.mSpaceScaleAndTitleSpinner.setPreferredSize(new Dimension(75, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mFigurePanel.add((Component)this.mSpaceScaleAndTitleSpinner, gridBagConstraints);
        this.mBackgroundColorLabel.setFont(new Font("Dialog", 3, 12));
        this.mBackgroundColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mFigurePanel.add((Component)this.mBackgroundColorLabel, gridBagConstraints);
        this.mBackgroundColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.mFigurePanel.add((Component)this.mBackgroundColorButton, gridBagConstraints);
        this.mLegendVisibleCheckBox.setText("Legend");
        this.mLegendVisibleCheckBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mFigurePanel.add((Component)this.mLegendVisibleCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 60, 0, 0);
        this.mFigurePanel.add((Component)this.mLocationSeparator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 35, 0, 0);
        this.mFigurePanel.add((Component)this.mSizeSeparator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 48, 0, 0);
        this.mFigurePanel.add((Component)this.mSpaceSeparator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 45, 0, 0);
        this.mFigurePanel.add((Component)this.mColorSeparator, gridBagConstraints);
        this.mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.mFigurePanel.add((Component)this.mLeftSpaceLabel, gridBagConstraints);
        this.mRightSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.mFigurePanel.add((Component)this.mRightSpaceLabel, gridBagConstraints);
        this.mTransparentCheckBox.setText("Transparency");
        this.mTransparentCheckBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.mFigurePanel.add((Component)this.mTransparentCheckBox, gridBagConstraints);
        this.mColorBarVisibleCheckBox.setText("Color Bar");
        this.mColorBarVisibleCheckBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mFigurePanel.add((Component)this.mColorBarVisibleCheckBox, gridBagConstraints);
        this.mTabbedPane.addTab("Figure", this.mFigurePanel);
        this.mGridPanel.setFont(new Font("Dialog", 0, 12));
        this.mGridPanel.setLayout(new GridBagLayout());
        this.mInnerGridPanel.setBorder(BorderFactory.createBevelBorder(0));
        this.mInnerGridPanel.setLayout(new GridBagLayout());
        this.mLineLabel.setFont(new Font("Dialog", 3, 12));
        this.mLineLabel.setText("Line");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 10, 0, 5);
        this.mInnerGridPanel.add((Component)this.mLineLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 40, 0, 10);
        this.mInnerGridPanel.add((Component)this.mLineSeparator, gridBagConstraints);
        this.mGridVisibleCheckBox.setText("Visible");
        this.mGridVisibleCheckBox.setFont(new Font("Dialog", 0, 12));
        this.mGridVisibleCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SGXYFigureDialog.this.mGridVisibleCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.mInnerGridPanel.add((Component)this.mGridVisibleCheckBox, gridBagConstraints);
        this.mLocationLabel1.setFont(new Font("Dialog", 3, 12));
        this.mLocationLabel1.setText("Location");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 5, 5);
        this.mInnerGridPanel.add((Component)this.mLocationLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 65, 5, 10);
        this.mInnerGridPanel.add((Component)this.mLocationSeparator1, gridBagConstraints);
        this.mStepXValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mStepXValueLabel.setText("Step X");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mInnerGridPanel.add((Component)this.mStepXValueLabel, gridBagConstraints);
        this.mStepXValueTextField.setColumns(6);
        this.mStepXValueTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mInnerGridPanel.add((Component)this.mStepXValueTextField, gridBagConstraints);
        this.mBaseXValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mBaseXValueLabel.setText("Base X");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mInnerGridPanel.add((Component)this.mBaseXValueLabel, gridBagConstraints);
        this.mBaseXValueTextField.setColumns(6);
        this.mBaseXValueTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.mInnerGridPanel.add((Component)this.mBaseXValueTextField, gridBagConstraints);
        this.mStepYValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mStepYValueLabel.setText("Step Y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mInnerGridPanel.add((Component)this.mStepYValueLabel, gridBagConstraints);
        this.mStepYValueTextField.setColumns(6);
        this.mStepYValueTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mInnerGridPanel.add((Component)this.mStepYValueTextField, gridBagConstraints);
        this.mBaseYValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mBaseYValueLabel.setText("Base Y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mInnerGridPanel.add((Component)this.mBaseYValueLabel, gridBagConstraints);
        this.mBaseYValueTextField.setColumns(6);
        this.mBaseYValueTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.mInnerGridPanel.add((Component)this.mBaseYValueTextField, gridBagConstraints);
        this.mLineTypeLabel.setFont(new Font("Dialog", 0, 12));
        this.mLineTypeLabel.setText("Type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mInnerGridPanel.add((Component)this.mLineTypeLabel, gridBagConstraints);
        this.mLineTypeComboBox.setFont(new Font("Dialog", 0, 12));
        this.mLineTypeComboBox.setPreferredSize(new Dimension(140, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mInnerGridPanel.add((Component)this.mLineTypeComboBox, gridBagConstraints);
        this.mLineWidthLabel.setFont(new Font("Dialog", 0, 12));
        this.mLineWidthLabel.setText("Width");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mInnerGridPanel.add((Component)this.mLineWidthLabel, gridBagConstraints);
        this.mLineWidthSpinner.setFont(new Font("Dialog", 0, 12));
        this.mLineWidthSpinner.setMinimumSize(new Dimension(65, 20));
        this.mLineWidthSpinner.setPreferredSize(new Dimension(75, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mInnerGridPanel.add((Component)this.mLineWidthSpinner, gridBagConstraints);
        this.mLineColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mLineColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 10, 5);
        this.mInnerGridPanel.add((Component)this.mLineColorLabel, gridBagConstraints);
        this.mLineColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mInnerGridPanel.add((Component)this.mLineColorButton, gridBagConstraints);
        this.mAutoCheckBox.setText("Auto");
        this.mAutoCheckBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.mInnerGridPanel.add((Component)this.mAutoCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mGridPanel.add((Component)this.mInnerGridPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.mGridPanel.add((Component)this.mAxisPanel, gridBagConstraints);
        this.mTabbedPane.addTab("Grid", this.mGridPanel);
        this.getContentPane().add((Component)this.mTabbedPane, new GridBagConstraints());
        this.pack();
    }

    private void mGridVisibleCheckBoxActionPerformed(ActionEvent actionEvent) {
    }

    private boolean initProperty() {
        this.setTitle(TITLE);
        this.mXSpinner.initProperties(new SpinnerNumberModel(0.0, -50.0, 150.0, 1.0), "cm", 1, 1);
        this.mYSpinner.initProperties(new SpinnerNumberModel(0.0, -50.0, 150.0, 1.0), "cm", 1, 1);
        this.mWidthSpinner.initProperties(new SpinnerNumberModel(10.0, 0.1, 50.0, 1.0), "cm", 1, 1);
        this.mHeightSpinner.initProperties(new SpinnerNumberModel(10.0, 0.1, 50.0, 1.0), "cm", 1, 1);
        this.mSpaceLineAndScaleSpinner.initProperties(new SpinnerNumberModel(0.0, 0.0, 5.0, 0.1), "cm", 1, 2);
        this.mSpaceScaleAndTitleSpinner.initProperties(new SpinnerNumberModel(0.0, 0.0, 5.0, 0.1), "cm", 1, 2);
        SGComboBox sGComboBox = this.mLineTypeComboBox;
        String[] stringArray = new String[]{"Solid", "Broken", "Dotted", "Dashed", "Double Dashed"};
        for (int i = 0; i < stringArray.length; ++i) {
            sGComboBox.addItem(stringArray[i]);
        }
        this.pack();
        this.mLineWidthSpinner.initProperties(SGXYFigureDialog.getLineWidthSpinnerNumberModel(), "pt", 1, 2);
        this.mXSpinner.setDescription("Figure-> Location-> X");
        this.mYSpinner.setDescription("Figure-> Location-> Y");
        this.mWidthSpinner.setDescription("Figure-> Size-> Width");
        this.mHeightSpinner.setDescription("Figure-> Size-> Height");
        this.mSpaceLineAndScaleSpinner.setDescription("Figure-> Space-> to Scale");
        this.mSpaceScaleAndTitleSpinner.setDescription("Figure-> Space-> to Title");
        this.mStepXValueTextField.setDescription("Grid-> Location-> StepX");
        this.mStepYValueTextField.setDescription("Grid-> Location-> StepY");
        this.mBaseXValueTextField.setDescription("Grid-> Location-> BaseX");
        this.mBaseYValueTextField.setDescription("Grid-> Location-> BaseY");
        this.mLineWidthSpinner.setDescription("Grid-> Line-> Width");
        this.mTransparentCheckBox.addActionListener(this);
        this.mLegendVisibleCheckBox.addActionListener(this);
        this.mGridVisibleCheckBox.addActionListener(this);
        this.mAutoCheckBox.addActionListener(this);
        this.mLineTypeComboBox.addActionListener(this);
        this.mAxisPanel.addActionListener(this);
        this.mColorBarVisibleCheckBox.addActionListener(this);
        this.mTabbedPane.addChangeListener(this);
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (object.equals(this.mTransparentCheckBox)) {
            this.setFigureTransparent(this.isFigureTransparent());
        } else if (object.equals(this.mGridVisibleCheckBox)) {
            this.setGridVisible(this.mGridVisibleCheckBox.getSelected());
        } else if (object.equals(this.mAutoCheckBox)) {
            this.setAutoFlag(this.mAutoCheckBox.getSelected());
        }
    }

    public Number getFigureX() {
        return this.mXSpinner.getNumber();
    }

    public Number getFigureY() {
        return this.mYSpinner.getNumber();
    }

    public Number getFigureWidth() {
        return this.mWidthSpinner.getNumber();
    }

    public Number getFigureHeight() {
        return this.mHeightSpinner.getNumber();
    }

    public Number getSpaceLineAndNumber() {
        return this.mSpaceLineAndScaleSpinner.getNumber();
    }

    public Number getSpaceNumberAndTitle() {
        return this.mSpaceScaleAndTitleSpinner.getNumber();
    }

    public Color getFigureBackgroundColor() {
        return this.mBackgroundColorButton.getColor();
    }

    public Boolean isFigureTransparent() {
        return this.mTransparentCheckBox.getSelected();
    }

    public Boolean getFigureLegendVisible() {
        return this.mLegendVisibleCheckBox.getSelected();
    }

    public boolean setFigureX(Object object) {
        return this.setValue(this.mXSpinner, object);
    }

    public boolean setFigureY(Object object) {
        return this.setValue(this.mYSpinner, object);
    }

    public boolean setFigureWidth(Object object) {
        return this.setValue(this.mWidthSpinner, object);
    }

    public boolean setFigureHeight(Object object) {
        return this.setValue(this.mHeightSpinner, object);
    }

    public boolean setFigureSpaceLineAndNumber(Object object) {
        return this.setValue(this.mSpaceLineAndScaleSpinner, object);
    }

    public boolean setFigureSpaceNumberAndTitle(Object object) {
        return this.setValue(this.mSpaceScaleAndTitleSpinner, object);
    }

    public boolean setFigureBackgroundColor(Color color) {
        this.mBackgroundColorButton.setColor(color);
        return true;
    }

    public boolean setFigureTransparent(Boolean bl) {
        this.mTransparentCheckBox.setSelected(bl);
        this.setBackgroundComponentsEnabled(bl);
        return true;
    }

    private boolean setBackgroundComponentsEnabled(Boolean bl) {
        boolean bl2 = true;
        if (bl != null) {
            bl2 = bl == false;
        }
        this.mBackgroundColorButton.setEnabled(bl2);
        return true;
    }

    public boolean setFigureLegendVisible(Boolean bl) {
        this.mLegendVisibleCheckBox.setSelected(bl);
        return true;
    }

    public void setGridVisible(Boolean bl) {
        this.mGridVisibleCheckBox.setSelected(bl);
        this.setGridComponentsEnabled(bl);
    }

    private void setGridComponentsEnabled(Boolean bl) {
        boolean bl2 = false;
        if (bl != null) {
            bl2 = bl;
        }
        this.setGridComponentsEnabled(bl2);
    }

    private void setGridComponentsEnabled(boolean bl) {
        Component[] componentArray = new Component[]{this.mLocationLabel1, this.mLineLabel, this.mAutoCheckBox, this.mLineWidthLabel, this.mLineWidthSpinner, this.mLineTypeLabel, this.mLineTypeComboBox, this.mLineColorLabel, this.mLineColorButton};
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i].setEnabled(bl);
        }
        this.setScaleComponentsEnabled(bl);
    }

    public void setAutoFlag(Boolean bl) {
        this.mAutoCheckBox.setSelected(bl);
        this.setScaleComponentsEditable(bl);
        this.setScaleComponentsEnabled(bl);
    }

    private void setScaleComponentsEnabled(Boolean bl) {
        boolean bl2;
        if (bl == null) {
            bl2 = true;
        } else {
            boolean bl3 = bl;
            Boolean bl4 = this.getGridVisible();
            boolean bl5 = bl4 == null ? false : bl4;
            bl2 = !bl3 && bl5;
        }
        this.setScaleComponentsEnabled(bl2);
    }

    private void setScaleComponentsEnabled(boolean bl) {
        Component[] componentArray = new Component[]{this.mBaseXValueLabel, this.mBaseXValueTextField, this.mBaseYValueLabel, this.mBaseYValueTextField, this.mStepXValueLabel, this.mStepXValueTextField, this.mStepYValueLabel, this.mStepYValueTextField};
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i].setEnabled(bl);
        }
    }

    private void setScaleComponentsEditable(Boolean bl) {
        boolean bl2 = true;
        if (bl != null) {
            bl2 = bl == false;
        }
        this.setScaleComponentsEditable(bl2);
    }

    private void setScaleComponentsEditable(boolean bl) {
        JTextComponent[] jTextComponentArray = new JTextComponent[]{this.mBaseXValueTextField, this.mBaseYValueTextField, this.mStepXValueTextField, this.mStepYValueTextField};
        for (int i = 0; i < jTextComponentArray.length; ++i) {
            jTextComponentArray[i].setEditable(bl);
        }
    }

    public boolean setLineType(Integer n) {
        if (n != null) {
            String string = SGDrawingElementLine.getLineTypeName(n);
            this.mLineTypeComboBox.setSelectedItem(string);
        } else {
            this.mLineTypeComboBox.setSelectedItem(null);
        }
        return true;
    }

    public Boolean getGridVisible() {
        return this.mGridVisibleCheckBox.getSelected();
    }

    public int getLineType() {
        String string = (String)this.mLineTypeComboBox.getSelectedItem();
        Integer n = SGDrawingElementLine.getLineTypeFromName(string);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public boolean setLineWidth(Object object) {
        return this.setValue(this.mLineWidthSpinner, object);
    }

    public Number getLineWidth() {
        return this.mLineWidthSpinner.getNumber();
    }

    public boolean setLineColor(Color color) {
        this.mLineColorButton.setColor(color);
        return true;
    }

    public Color getLineColor() {
        return this.mLineColorButton.getColor();
    }

    public Boolean getAutoFlag() {
        return this.mAutoCheckBox.getSelected();
    }

    public Number getBaseXValue() {
        String string = this.mBaseXValueTextField.getText();
        Double d = SGUtilityText.getDouble(string);
        return d;
    }

    public Number getBaseYValue() {
        String string = this.mBaseYValueTextField.getText();
        Double d = SGUtilityText.getDouble(string);
        return d;
    }

    public Number getStepXValue() {
        String string = this.mStepXValueTextField.getText();
        Double d = SGUtilityText.getDouble(string);
        return d;
    }

    public Number getStepYValue() {
        String string = this.mStepYValueTextField.getText();
        Double d = SGUtilityText.getDouble(string);
        return d;
    }

    public void setBaseXValue(Object object) {
        this.setValue(this.mBaseXValueTextField, object);
    }

    public void setStepXValue(Object object) {
        this.setValue(this.mStepXValueTextField, object);
    }

    public void setBaseYValue(Object object) {
        this.setValue(this.mBaseYValueTextField, object);
    }

    public void setStepYValue(Object object) {
        this.setValue(this.mStepYValueTextField, object);
    }

    public List getTextFieldComponentsList() {
        List list = this.getFormattedTextFieldsListFromSpinners();
        list.addAll(this.getNumberTextFieldList());
        return list;
    }

    public List getNumberTextFieldList() {
        ArrayList<SGTextField> arrayList = new ArrayList<SGTextField>();
        arrayList.add(this.mStepXValueTextField);
        arrayList.add(this.mStepYValueTextField);
        arrayList.add(this.mBaseXValueTextField);
        arrayList.add(this.mBaseYValueTextField);
        return arrayList;
    }

    public List getColorSelectionButtonsList() {
        ArrayList<SGColorSelectionButton> arrayList = new ArrayList<SGColorSelectionButton>();
        arrayList.add(this.mBackgroundColorButton);
        arrayList.add(this.mLineColorButton);
        return arrayList;
    }

    public List getSpinnerList() {
        ArrayList<SGSpinner> arrayList = new ArrayList<SGSpinner>();
        arrayList.add(this.mXSpinner);
        arrayList.add(this.mYSpinner);
        arrayList.add(this.mWidthSpinner);
        arrayList.add(this.mHeightSpinner);
        arrayList.add(this.mSpaceLineAndScaleSpinner);
        arrayList.add(this.mSpaceScaleAndTitleSpinner);
        arrayList.add(this.mLineWidthSpinner);
        return arrayList;
    }

    public boolean setDialogProperty() {
        List list = this.mPropertyDialogObserverList;
        SGIFigureDialogObserver sGIFigureDialogObserver = (SGIFigureDialogObserver)list.get(0);
        float f = sGIFigureDialogObserver.getFigureX("cm");
        float f2 = sGIFigureDialogObserver.getFigureY("cm");
        float f3 = sGIFigureDialogObserver.getFigureWidth("cm");
        float f4 = sGIFigureDialogObserver.getFigureHeight("cm");
        float f5 = sGIFigureDialogObserver.getSpaceAxisLineAndNumber("cm");
        float f6 = sGIFigureDialogObserver.getSpaceNumberAndTitle("cm");
        Color color = sGIFigureDialogObserver.getBackgroundColor();
        boolean bl = sGIFigureDialogObserver.isTransparent();
        boolean bl2 = sGIFigureDialogObserver.isLegendVisible();
        boolean bl3 = sGIFigureDialogObserver.isColorBarVisible();
        Float f7 = Float.valueOf(f);
        Float f8 = Float.valueOf(f2);
        Float f9 = Float.valueOf(f3);
        Float f10 = Float.valueOf(f4);
        Float f11 = Float.valueOf(f5);
        Float f12 = Float.valueOf(f6);
        Color color2 = color;
        Boolean bl4 = bl;
        Boolean bl5 = bl2;
        Boolean bl6 = bl3;
        if (list.size() > 1) {
            float f13;
            SGIFigureDialogObserver sGIFigureDialogObserver2;
            int n;
            for (n = 1; n < list.size(); ++n) {
                sGIFigureDialogObserver2 = (SGIFigureDialogObserver)list.get(n);
                f13 = sGIFigureDialogObserver2.getFigureX("cm");
                if (f == f13) continue;
                f7 = null;
                break;
            }
            for (n = 1; n < list.size(); ++n) {
                sGIFigureDialogObserver2 = (SGIFigureDialogObserver)list.get(n);
                f13 = sGIFigureDialogObserver2.getFigureY("cm");
                if (f2 == f13) continue;
                f8 = null;
                break;
            }
            for (n = 1; n < list.size(); ++n) {
                sGIFigureDialogObserver2 = (SGIFigureDialogObserver)list.get(n);
                f13 = sGIFigureDialogObserver2.getFigureWidth("cm");
                if (f3 == f13) continue;
                f9 = null;
                break;
            }
            for (n = 1; n < list.size(); ++n) {
                sGIFigureDialogObserver2 = (SGIFigureDialogObserver)list.get(n);
                f13 = sGIFigureDialogObserver2.getFigureHeight("cm");
                if (f4 == f13) continue;
                f10 = null;
                break;
            }
            for (n = 1; n < list.size(); ++n) {
                sGIFigureDialogObserver2 = (SGIFigureDialogObserver)list.get(n);
                f13 = sGIFigureDialogObserver2.getSpaceAxisLineAndNumber("cm");
                if (f5 == f13) continue;
                f11 = null;
                break;
            }
            for (n = 1; n < list.size(); ++n) {
                sGIFigureDialogObserver2 = (SGIFigureDialogObserver)list.get(n);
                f13 = sGIFigureDialogObserver2.getSpaceNumberAndTitle("cm");
                if (f6 == f13) continue;
                f12 = null;
                break;
            }
            for (n = 1; n < list.size(); ++n) {
                sGIFigureDialogObserver2 = (SGIFigureDialogObserver)list.get(n);
                Color color3 = sGIFigureDialogObserver2.getBackgroundColor();
                if (color.equals(color3)) continue;
                color2 = null;
                break;
            }
            for (n = 1; n < list.size(); ++n) {
                sGIFigureDialogObserver2 = (SGIFigureDialogObserver)list.get(n);
                boolean bl7 = sGIFigureDialogObserver2.isTransparent();
                if (bl == bl7) continue;
                bl4 = null;
                break;
            }
            for (n = 1; n < list.size(); ++n) {
                sGIFigureDialogObserver2 = (SGIFigureDialogObserver)list.get(n);
                boolean bl8 = sGIFigureDialogObserver2.isLegendVisible();
                if (bl2 == bl8) continue;
                bl5 = null;
                break;
            }
            for (n = 1; n < list.size(); ++n) {
                sGIFigureDialogObserver2 = (SGIFigureDialogObserver)list.get(n);
                boolean bl9 = sGIFigureDialogObserver2.isColorBarVisible();
                if (bl3 == bl9) continue;
                bl6 = null;
                break;
            }
        }
        this.setFigureX(f7);
        this.setFigureY(f8);
        this.setFigureWidth(f9);
        this.setFigureHeight(f10);
        this.setFigureSpaceLineAndNumber(f11);
        this.setFigureSpaceNumberAndTitle(f12);
        this.setFigureBackgroundColor(color2);
        this.setFigureTransparent(bl4);
        this.setFigureLegendVisible(bl5);
        Boolean bl10 = true;
        for (int i = 0; i < list.size(); ++i) {
            SGIFigureDialogObserver sGIFigureDialogObserver3 = (SGIFigureDialogObserver)list.get(i);
            if (sGIFigureDialogObserver3.isLegendAvailable()) continue;
            bl10 = false;
            break;
        }
        this.mLegendVisibleCheckBox.setEnabled(bl10);
        this.mColorBarVisibleCheckBox.setSelected(bl6);
        Boolean bl11 = true;
        for (int i = 0; i < list.size(); ++i) {
            SGIFigureDialogObserver sGIFigureDialogObserver4 = (SGIFigureDialogObserver)list.get(i);
            if (sGIFigureDialogObserver4.isColorBarAvailable()) continue;
            bl11 = false;
            break;
        }
        this.mColorBarVisibleCheckBox.setEnabled(bl11);
        return this.setGridProperty();
    }

    private boolean isGridTabEnable() {
        return this.mTabbedPane.isEnabledAt(1);
    }

    private boolean setGridProperty() {
        boolean bl;
        SGIXYFigureDialogObserver sGIXYFigureDialogObserver;
        int n;
        List list = this.mPropertyDialogObserverList;
        if (!this.mAxisPanel.setSelected(list)) {
            return false;
        }
        SGIXYFigureDialogObserver sGIXYFigureDialogObserver2 = (SGIXYFigureDialogObserver)list.get(0);
        boolean bl2 = sGIXYFigureDialogObserver2.isGridVisible();
        boolean bl3 = sGIXYFigureDialogObserver2.isAutoCalculateRange();
        double d = sGIXYFigureDialogObserver2.getGridStepValueX();
        double d2 = sGIXYFigureDialogObserver2.getGridStepValueY();
        double d3 = sGIXYFigureDialogObserver2.getGridBaselineValueX();
        double d4 = sGIXYFigureDialogObserver2.getGridBaselineValueY();
        float f = sGIXYFigureDialogObserver2.getGridLineWidth("pt");
        int n2 = sGIXYFigureDialogObserver2.getGridLineType();
        Color color = sGIXYFigureDialogObserver2.getGridLineColor();
        Boolean bl4 = bl2;
        Boolean bl5 = bl3;
        Double d5 = d;
        Double d6 = d2;
        Double d7 = d3;
        Double d8 = d4;
        Float f2 = Float.valueOf(f);
        Integer n3 = n2;
        Color color2 = color;
        if (list.size() > 1) {
            for (n = 1; n < list.size(); ++n) {
                sGIXYFigureDialogObserver = (SGIXYFigureDialogObserver)list.get(n);
                bl = sGIXYFigureDialogObserver.isGridVisible();
                if (bl2 == bl) continue;
                bl4 = null;
                break;
            }
        }
        if (list.size() > 1) {
            for (n = 1; n < list.size(); ++n) {
                sGIXYFigureDialogObserver = (SGIXYFigureDialogObserver)list.get(n);
                bl = sGIXYFigureDialogObserver.isAutoCalculateRange();
                if (bl3 == bl) continue;
                bl5 = null;
                break;
            }
        }
        if (list.size() > 1) {
            for (n = 1; n < list.size(); ++n) {
                sGIXYFigureDialogObserver = (SGIXYFigureDialogObserver)list.get(n);
                double d9 = sGIXYFigureDialogObserver.getGridStepValueX();
                if (d == d9) continue;
                d5 = null;
                break;
            }
        }
        if (list.size() > 1) {
            for (n = 1; n < list.size(); ++n) {
                sGIXYFigureDialogObserver = (SGIXYFigureDialogObserver)list.get(n);
                double d10 = sGIXYFigureDialogObserver.getGridStepValueY();
                if (d2 == d10) continue;
                d6 = null;
                break;
            }
        }
        if (list.size() > 1) {
            for (n = 1; n < list.size(); ++n) {
                sGIXYFigureDialogObserver = (SGIXYFigureDialogObserver)list.get(n);
                double d11 = sGIXYFigureDialogObserver.getGridBaselineValueX();
                if (d3 == d11) continue;
                d7 = null;
                break;
            }
        }
        if (list.size() > 1) {
            for (n = 1; n < list.size(); ++n) {
                sGIXYFigureDialogObserver = (SGIXYFigureDialogObserver)list.get(n);
                double d12 = sGIXYFigureDialogObserver.getGridBaselineValueY();
                if (d4 == d12) continue;
                d8 = null;
                break;
            }
        }
        if (list.size() > 1) {
            for (n = 1; n < list.size(); ++n) {
                sGIXYFigureDialogObserver = (SGIXYFigureDialogObserver)list.get(n);
                float f3 = sGIXYFigureDialogObserver.getGridLineWidth("pt");
                if (f == f3) continue;
                f2 = null;
                break;
            }
        }
        if (list.size() > 1) {
            for (n = 1; n < list.size(); ++n) {
                sGIXYFigureDialogObserver = (SGIXYFigureDialogObserver)list.get(n);
                int n4 = sGIXYFigureDialogObserver.getGridLineType();
                if (n2 == n4) continue;
                n3 = null;
                break;
            }
        }
        if (list.size() > 1) {
            for (n = 1; n < list.size(); ++n) {
                sGIXYFigureDialogObserver = (SGIXYFigureDialogObserver)list.get(n);
                Color color3 = sGIXYFigureDialogObserver.getGridLineColor();
                if (color.equals(color3)) continue;
                color2 = null;
                break;
            }
        }
        this.setAutoFlag(bl5);
        this.setStepXValue(d5);
        this.setStepYValue(d6);
        this.setBaseXValue(d7);
        this.setBaseYValue(d8);
        this.setLineWidth(f2);
        this.setLineType(n3);
        this.setLineColor(color2);
        this.setGridVisible(bl4);
        return true;
    }

    public boolean setPropertiesToListeners(SGIPropertyDialogObserver sGIPropertyDialogObserver) {
        Boolean bl;
        Boolean bl2;
        Color color;
        Boolean bl3;
        Number number;
        Number number2;
        Number number3;
        Number number4;
        Number number5;
        SGIXYFigureDialogObserver sGIXYFigureDialogObserver = (SGIXYFigureDialogObserver)sGIPropertyDialogObserver;
        Number number6 = this.getFigureX();
        if (number6 != null) {
            sGIXYFigureDialogObserver.setFigureX(number6.floatValue(), "cm");
        }
        if ((number5 = this.getFigureY()) != null) {
            sGIXYFigureDialogObserver.setFigureY(number5.floatValue(), "cm");
        }
        if ((number4 = this.getFigureWidth()) != null) {
            sGIXYFigureDialogObserver.setFigureWidth(number4.floatValue(), "cm");
        }
        if ((number3 = this.getFigureHeight()) != null) {
            sGIXYFigureDialogObserver.setFigureHeight(number3.floatValue(), "cm");
        }
        if ((number2 = this.getSpaceLineAndNumber()) != null) {
            sGIXYFigureDialogObserver.setSpaceAxisLineAndNumber(number2.floatValue(), "cm");
        }
        if ((number = this.getSpaceNumberAndTitle()) != null) {
            sGIXYFigureDialogObserver.setSpaceNumberAndTitle(number.floatValue(), "cm");
        }
        if ((bl3 = this.isFigureTransparent()) != null) {
            sGIXYFigureDialogObserver.setTransparent(bl3);
        }
        if ((color = this.getFigureBackgroundColor()) != null) {
            sGIXYFigureDialogObserver.setBackgroundColor(color);
        }
        if ((bl2 = this.getFigureLegendVisible()) != null) {
            sGIXYFigureDialogObserver.setLegendVisible(bl2);
        }
        if (this.mColorBarVisibleCheckBox.isEnabled() && (bl = this.mColorBarVisibleCheckBox.getSelected()) != null) {
            sGIXYFigureDialogObserver.setColorBarVisible(bl);
        }
        return !this.isGridTabEnable() || this.setPropertiesToGridListeners(sGIXYFigureDialogObserver);
    }

    private boolean setPropertiesToGridListeners(SGIXYFigureDialogObserver sGIXYFigureDialogObserver) {
        Boolean bl;
        SGIXYFigureDialogObserver sGIXYFigureDialogObserver2 = sGIXYFigureDialogObserver;
        Number number = this.getStepXValue();
        Number number2 = this.getStepYValue();
        boolean bl2 = true;
        String string = "Zero value is set to the step value: ";
        if (!sGIXYFigureDialogObserver.hasValidStepXValue(number)) {
            bl2 = false;
            string = string + "X";
        }
        if (!sGIXYFigureDialogObserver.hasValidStepYValue(number2)) {
            if (!bl2) {
                string = string + "and ";
            }
            bl2 = false;
            string = string + "Y";
        }
        if (!bl2) {
            this.setInputErrorMessage(string);
            return false;
        }
        int n = this.mAxisPanel.getXAxisLocation();
        int n2 = this.mAxisPanel.getYAxisLocation();
        if (n != -1) {
            sGIXYFigureDialogObserver2.setXAxisLocation(n);
        }
        if (n2 != -1) {
            sGIXYFigureDialogObserver2.setYAxisLocation(n2);
        }
        if ((bl = this.getAutoFlag()) != null && !sGIXYFigureDialogObserver2.setAutoCalculateRange(bl)) {
            return false;
        }
        Boolean bl3 = this.getGridVisible();
        if (bl3 != null && !sGIXYFigureDialogObserver2.setGridVisible(bl3)) {
            return false;
        }
        Number number3 = this.getBaseXValue();
        if (number3 != null && !sGIXYFigureDialogObserver2.setGridBaselineValueX(number3.doubleValue())) {
            return false;
        }
        Number number4 = this.getBaseYValue();
        if (number4 != null && !sGIXYFigureDialogObserver2.setGridBaselineValueY(number4.doubleValue())) {
            return false;
        }
        if (number != null && !sGIXYFigureDialogObserver2.setGridStepValueX(number.doubleValue())) {
            return false;
        }
        if (number2 != null && !sGIXYFigureDialogObserver2.setGridStepValueY(number2.doubleValue())) {
            return false;
        }
        Number number5 = this.getLineWidth();
        if (number5 != null && !sGIXYFigureDialogObserver2.setGridLineWidth(number5.floatValue(), "pt")) {
            return false;
        }
        int n3 = this.getLineType();
        if (n3 != -1 && !sGIXYFigureDialogObserver2.setGridLineType(n3)) {
            return false;
        }
        Color color = this.getLineColor();
        return color == null || sGIXYFigureDialogObserver2.setGridLineColor(color);
    }

    protected boolean hasValidInputValues() {
        boolean bl = true;
        if (!super.hasValidInputValues()) {
            bl = false;
        }
        if (!this.hasValidNumber(this.mBaseXValueTextField, null, null)) {
            bl = false;
        }
        if (!this.hasValidNumber(this.mBaseYValueTextField, null, null)) {
            bl = false;
        }
        if (!this.hasValidNumber(this.mStepXValueTextField, null, null)) {
            bl = false;
        }
        if (!this.hasValidNumber(this.mStepYValueTextField, null, null)) {
            bl = false;
        }
        return bl;
    }

    protected JButton getOKButton() {
        return this.mOKButton;
    }

    protected JButton getCancelButton() {
        return this.mCancelButton;
    }

    protected JButton getPreviewButton() {
        return this.mPreviewButton;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        super.stateChanged(changeEvent);
        Object object = changeEvent.getSource();
        if (object.equals(this.mTabbedPane)) {
            int n = this.mTabbedPane.getSelectedIndex();
            this.setColorButtonProperty(n);
        }
    }

    protected boolean setColorButtonProperty(int n) {
        int n2 = this.mTabbedPane.indexOfComponent(this.mFigurePanel);
        int n3 = this.mTabbedPane.indexOfComponent(this.mGridPanel);
        SGColorSelectionButton sGColorSelectionButton = null;
        if (n == n2) {
            if (!this.mTransparentCheckBox.isSelected()) {
                sGColorSelectionButton = this.mBackgroundColorButton;
            }
        } else if (n == n3 && this.mGridVisibleCheckBox.isSelected()) {
            sGColorSelectionButton = this.mLineColorButton;
        }
        return sGColorSelectionButton != null;
    }
}

