/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import jp.riken.brain.ni.samuraigraph.base.SGIPaint;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementArrow;
import jp.riken.brain.ni.samuraigraph.figure.SGStroke;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementLine2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementSymbol2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIDrawingElementJava2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityJava2D;

public abstract class SGDrawingElementArrow2D
extends SGDrawingElementArrow
implements SGIDrawingElementJava2D {
    public Rectangle2D getElementBounds() {
        SGDrawingElementLine2D sGDrawingElementLine2D = (SGDrawingElementLine2D)this.getLine();
        SGDrawingElementSymbol2D sGDrawingElementSymbol2D = (SGDrawingElementSymbol2D)this.getStartHead();
        SGDrawingElementSymbol2D sGDrawingElementSymbol2D2 = (SGDrawingElementSymbol2D)this.getEndHead();
        ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
        arrayList.add(sGDrawingElementLine2D.getElementBounds());
        arrayList.add(sGDrawingElementSymbol2D.getElementBounds());
        arrayList.add(sGDrawingElementSymbol2D2.getElementBounds());
        Rectangle2D rectangle2D = SGUtility.createUnion(arrayList);
        return rectangle2D;
    }

    public void paint(Graphics2D graphics2D) {
        if (!this.isVisible()) {
            return;
        }
        SGDrawingElementLine2D sGDrawingElementLine2D = (SGDrawingElementLine2D)this.getLine();
        SGDrawingElementSymbol2D sGDrawingElementSymbol2D = (SGDrawingElementSymbol2D)this.getStartHead();
        SGDrawingElementSymbol2D sGDrawingElementSymbol2D2 = (SGDrawingElementSymbol2D)this.getEndHead();
        sGDrawingElementLine2D.paint(graphics2D);
        sGDrawingElementSymbol2D.paint(graphics2D);
        sGDrawingElementSymbol2D2.paint(graphics2D);
    }

    public void paint(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (!this.isVisible()) {
            return;
        }
        SGDrawingElementLine2D sGDrawingElementLine2D = (SGDrawingElementLine2D)this.getLine();
        SGDrawingElementSymbol2D sGDrawingElementSymbol2D = (SGDrawingElementSymbol2D)this.getStartHead();
        SGDrawingElementSymbol2D sGDrawingElementSymbol2D2 = (SGDrawingElementSymbol2D)this.getEndHead();
        sGDrawingElementLine2D.paint(graphics2D, rectangle2D);
        sGDrawingElementSymbol2D.paint(graphics2D, rectangle2D);
        sGDrawingElementSymbol2D2.paint(graphics2D, rectangle2D);
    }

    public float getMagnitude() {
        SGTuple2f sGTuple2f = this.getStart();
        SGTuple2f sGTuple2f2 = this.getEnd();
        float f = sGTuple2f.x - sGTuple2f2.x;
        float f2 = sGTuple2f.y - sGTuple2f2.y;
        return (float)Math.sqrt(f * f + f2 * f2);
    }

    public float getGradient() {
        SGTuple2f sGTuple2f = this.getStart();
        SGTuple2f sGTuple2f2 = this.getEnd();
        return SGUtilityJava2D.getGradient(sGTuple2f.x, sGTuple2f.y, sGTuple2f2.x, sGTuple2f2.y);
    }

    protected void updateHeadAngle() {
        SGDrawingElementLine2D sGDrawingElementLine2D = (SGDrawingElementLine2D)this.getLine();
        SGDrawingElementSymbol2D sGDrawingElementSymbol2D = (SGDrawingElementSymbol2D)this.getStartHead();
        SGDrawingElementSymbol2D sGDrawingElementSymbol2D2 = (SGDrawingElementSymbol2D)this.getEndHead();
        float f = sGDrawingElementLine2D.getGradient();
        sGDrawingElementSymbol2D.setAngle(f - 1.5707964f);
        sGDrawingElementSymbol2D2.setAngle(f + 1.5707964f);
    }

    protected abstract Shape getStartHeadShape();

    protected abstract Shape getEndHeadShape();

    protected abstract void updateHeadShape();

    protected static Shape createHeadShape(int n, float f, float f2, float f3) {
        Shape shape = null;
        if (n == 10) {
            if (f3 <= f2) {
                return null;
            }
            float f4 = (float)Math.tan(f2 * ((float)Math.PI / 180));
            float f5 = (float)Math.tan(f3 * ((float)Math.PI / 180));
            float f6 = f * f4;
            Point2D[] point2DArray = new Point2D[]{new Point2D.Float(0.0f, 0.0f), new Point2D.Float(f6, f), new Point2D.Float(0.0f, f - f6 / f5), new Point2D.Float(-f6, f)};
            Line2D[] line2DArray = new Line2D[point2DArray.length];
            for (int i = 0; i < line2DArray.length; ++i) {
                line2DArray[i] = new Line2D.Float(point2DArray[i], point2DArray[(i + 1) % point2DArray.length]);
            }
            GeneralPath generalPath = new GeneralPath();
            for (int i = 0; i < line2DArray.length; ++i) {
                generalPath.append(line2DArray[i], true);
            }
            shape = generalPath;
        } else if (n == 8) {
            float f7 = 0.5f * f;
            Line2D.Float float_ = new Line2D.Float(-f7, 0.0f, 0.0f, 0.0f);
            Line2D.Float float_2 = new Line2D.Float(0.0f, 0.0f, f7, 0.0f);
            GeneralPath generalPath = new GeneralPath();
            generalPath.append(float_, false);
            generalPath.append(float_2, false);
            shape = generalPath;
        } else if (n != -1) {
            shape = SGDrawingElementSymbol2D.createShape(n, f);
        }
        return shape;
    }

    protected static class ArrowHead
    extends SGDrawingElementSymbol2D {
        protected SGDrawingElementArrow mArrow = null;
        protected boolean mStartFlag = true;

        public ArrowHead(SGDrawingElementArrow sGDrawingElementArrow, boolean bl) {
            this.mArrow = sGDrawingElementArrow;
            this.mStartFlag = bl;
        }

        public void dispose() {
            super.dispose();
            this.mArrow = null;
        }

        protected void paintLine(Graphics2D graphics2D, Shape shape) {
            if (SGDrawingElementArrow.isLineTypeSymbol(this.getType())) {
                super.paintLine(graphics2D, shape);
            }
        }

        protected void paintLine(Graphics2D graphics2D, Area area, Shape shape) {
            if (SGDrawingElementArrow.isLineTypeSymbol(this.getType())) {
                super.paintLine(graphics2D, area, shape);
            }
        }

        protected float getHeadOpenAngle() {
            return this.mArrow.getHeadOpenAngle();
        }

        protected float getHeadCloseAngle() {
            return this.mArrow.getHeadCloseAngle();
        }

        protected Shape createShape() {
            int n = this.getType();
            float f = this.getMagnification() * this.getSize();
            float f2 = this.getHeadOpenAngle();
            float f3 = this.getHeadCloseAngle();
            return SGDrawingElementArrow2D.createHeadShape(n, f, f2, f3);
        }

        protected void paintInner(Graphics2D graphics2D, Shape shape) {
            graphics2D.setPaint(this.getInnerColor());
            graphics2D.fill(shape);
        }

        public float getAngle() {
            float f = this.mArrow.getGradient();
            if (this.mStartFlag) {
                return f - 1.5707964f;
            }
            return f + 1.5707964f;
        }

        public Color getInnerColor() {
            return this.mArrow.getColor();
        }

        public SGIPaint getInnerPaint() {
            return null;
        }

        public Color getLineColor() {
            return this.mArrow.getColor();
        }

        public float getLineWidth() {
            return this.mArrow.getLineWidth();
        }

        public boolean isLineVisible() {
            return true;
        }

        public float getSize() {
            return this.mArrow.getHeadSize();
        }

        public int getType() {
            if (this.mStartFlag) {
                return this.mArrow.getStartHeadType();
            }
            return this.mArrow.getEndHeadType();
        }

        public boolean setAngle(float f) {
            return true;
        }

        public boolean setInnerColor(Color color) {
            return true;
        }

        public boolean setLineColor(Color color) {
            return true;
        }

        public boolean setLineWidth(float f) {
            return true;
        }

        public boolean setLineVisible(boolean bl) {
            return true;
        }

        public boolean setSize(float f) {
            return true;
        }

        public boolean setType(int n) {
            return true;
        }

        public float getMagnification() {
            return this.mArrow.getMagnification();
        }

        public boolean setMagnification(float f) {
            return true;
        }

        public SGTuple2f getLocation() {
            if (this.mStartFlag) {
                return this.mArrow.getStart();
            }
            return this.mArrow.getEnd();
        }

        public float getX() {
            return this.getLocation().x;
        }

        public float getY() {
            return this.getLocation().y;
        }

        public boolean setLocation(float f, float f2) {
            return true;
        }

        public boolean setLocation(SGTuple2f sGTuple2f) {
            return true;
        }

        public boolean setX(float f) {
            return true;
        }

        public boolean setY(float f) {
            return true;
        }

        protected Shape getShape() {
            if (this.mStartFlag) {
                return ((SGDrawingElementArrow2D)this.mArrow).getStartHeadShape();
            }
            return ((SGDrawingElementArrow2D)this.mArrow).getEndHeadShape();
        }

        protected void updateShape() {
        }
    }

    protected static class ArrowBody
    extends SGDrawingElementLine2D {
        protected SGDrawingElementArrow mArrow = null;

        public ArrowBody(SGDrawingElementArrow sGDrawingElementArrow) {
            this.mArrow = sGDrawingElementArrow;
        }

        public Shape getLineShape() {
            float f = this.mArrow.getHeadOpenAngle() * ((float)Math.PI / 180);
            float f2 = this.mArrow.getHeadCloseAngle() * ((float)Math.PI / 180);
            float f3 = (float)Math.tan(f);
            float f4 = (float)Math.tan(f2);
            float f5 = f <= f2 ? this.getMagnification() * this.mArrow.getHeadSize() * (1.0f - f3 / f4) : 0.0f;
            float f6 = this.getMagnitude();
            float f7 = this.mArrow.getStartHeadType() != 10 ? 0.0f : 0.5f * f5;
            float f8 = this.mArrow.getEndHeadType() != 10 ? f6 : f6 - 0.5f * f5;
            Line2D.Float float_ = new Line2D.Float(0.0f, f7, 0.0f, f8);
            Shape shape = this.getAffineTransform().createTransformedShape(float_);
            return shape;
        }

        private AffineTransform getAffineTransform() {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(this.getStart().x, this.getStart().y);
            double d = (double)this.getGradient() - 1.5707963267948966;
            affineTransform.rotate(d);
            return affineTransform;
        }

        public Color getColor() {
            return this.mArrow.getColor();
        }

        protected SGStroke getStroke() {
            return this.mArrow.getStroke();
        }

        public boolean setColor(Color color) {
            return true;
        }

        public boolean setLineType(int n) {
            return true;
        }

        public boolean setLineWidth(float f) {
            return true;
        }

        public float getMagnification() {
            return this.mArrow.getMagnification();
        }

        public boolean setMagnification(float f) {
            return true;
        }

        public SGTuple2f getEnd() {
            return this.mArrow.getEnd();
        }

        public SGTuple2f getStart() {
            return this.mArrow.getStart();
        }

        public boolean setTermPoints(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
            return true;
        }
    }
}

