/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementSymbol;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIDrawingElementJava2D;

public abstract class SGDrawingElementSymbol2D
extends SGDrawingElementSymbol
implements SGIDrawingElementJava2D {
    public static final float MIN_SIZE = 6.0f;
    private static final float SQRT_2 = (float)Math.sqrt(2.0);
    private static final float SQRT_3 = (float)Math.sqrt(3.0);

    public boolean contains(int n, int n2) {
        Shape shape = this.getSymbolShape();
        if (shape == null) {
            return false;
        }
        Rectangle2D rectangle2D = shape.getBounds2D();
        if (rectangle2D.getWidth() < 6.0 || rectangle2D.getHeight() < 6.0) {
            float f = (float)rectangle2D.getCenterX();
            float f2 = (float)rectangle2D.getCenterY();
            rectangle2D = new Rectangle2D.Float(f - 3.0f, f2 - 3.0f, 6.0f, 6.0f);
        }
        return rectangle2D.contains(n, n2);
    }

    public Rectangle2D getElementBounds() {
        Shape shape = this.getSymbolShape();
        if (shape == null) {
            return new Rectangle2D.Float(this.getX(), this.getY(), 0.0f, 0.0f);
        }
        return shape.getBounds2D();
    }

    public Shape getSymbolShape() {
        Shape shape = this.getShape();
        if (shape != null) {
            AffineTransform affineTransform = this.getAffineTransform();
            shape = affineTransform.createTransformedShape(shape);
        }
        return shape;
    }

    protected static Shape createShape(int n, float f) {
        float f2 = 0.5f * f;
        float f3 = -f2;
        Shape shape = null;
        switch (n) {
            case 1: {
                shape = new Ellipse2D.Float(f3, f3, f, f);
                break;
            }
            case 2: {
                shape = new Rectangle2D.Float(f3, f3, f, f);
                break;
            }
            case 3: {
                float f4;
                float f5 = f / SQRT_2;
                float f6 = f4 = -f5;
                float f7 = f5;
                Line2D.Float float_ = new Line2D.Float(0.0f, f7, f7, 0.0f);
                Line2D.Float float_2 = new Line2D.Float(f7, 0.0f, 0.0f, f6);
                Line2D.Float float_3 = new Line2D.Float(0.0f, f6, f6, 0.0f);
                Line2D.Float float_4 = new Line2D.Float(f6, 0.0f, 0.0f, f7);
                GeneralPath generalPath = new GeneralPath();
                generalPath.append(float_, true);
                generalPath.append(float_2, true);
                generalPath.append(float_3, true);
                generalPath.append(float_4, true);
                generalPath.append(float_, true);
                shape = generalPath;
                break;
            }
            case 4: {
                float f8 = f / SQRT_3;
                float f9 = -f8;
                float f10 = f2;
                float f11 = 0.5f * f8;
                float f12 = -f2;
                float f13 = f11;
                Line2D.Float float_ = new Line2D.Float(0.0f, f9, f10, f11);
                Line2D.Float float_5 = new Line2D.Float(f10, f11, f12, f13);
                Line2D.Float float_6 = new Line2D.Float(f12, f13, 0.0f, f9);
                GeneralPath generalPath = new GeneralPath();
                generalPath.append(float_, true);
                generalPath.append(float_5, true);
                generalPath.append(float_6, true);
                generalPath.append(float_, true);
                shape = generalPath;
                break;
            }
            case 5: {
                float f14 = -f / SQRT_3;
                float f15 = -f14;
                float f16 = f2;
                float f17 = 0.5f * f14;
                float f18 = -f2;
                float f19 = f17;
                Line2D.Float float_ = new Line2D.Float(0.0f, f15, f16, f17);
                Line2D.Float float_7 = new Line2D.Float(f16, f17, f18, f19);
                Line2D.Float float_8 = new Line2D.Float(f18, f19, 0.0f, f15);
                GeneralPath generalPath = new GeneralPath();
                generalPath.append(float_, true);
                generalPath.append(float_7, true);
                generalPath.append(float_8, true);
                generalPath.append(float_, true);
                shape = generalPath;
                break;
            }
            case 6: {
                float f20 = f3;
                float f21 = f2;
                float f22 = f3;
                float f23 = f2;
                Line2D.Float float_ = new Line2D.Float(f20, f22, f21, f23);
                Line2D.Float float_9 = new Line2D.Float(f21, f22, f20, f23);
                GeneralPath generalPath = new GeneralPath();
                generalPath.append(float_, false);
                generalPath.append(float_9, false);
                shape = generalPath;
                break;
            }
            case 7: {
                Line2D.Float float_ = new Line2D.Float(f3, 0.0f, f2, 0.0f);
                Line2D.Float float_10 = new Line2D.Float(0.0f, f3, 0.0f, f2);
                GeneralPath generalPath = new GeneralPath();
                generalPath.append(float_, false);
                generalPath.append(float_10, false);
                shape = generalPath;
                break;
            }
        }
        return shape;
    }

    protected Shape createShape() {
        int n = this.getType();
        float f = this.getMagnification() * this.getSize();
        return SGDrawingElementSymbol2D.createShape(n, f);
    }

    protected AffineTransform getAffineTransform() {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(this.getX(), this.getY());
        affineTransform.rotate(this.getAngle());
        return affineTransform;
    }

    public void paint(Graphics2D graphics2D) {
        if (!this.isVisible()) {
            return;
        }
        Shape shape = this.getShape();
        if (shape == null) {
            return;
        }
        AffineTransform affineTransform = graphics2D.getTransform();
        AffineTransform affineTransform2 = new AffineTransform(affineTransform);
        affineTransform2.concatenate(this.getAffineTransform());
        graphics2D.setTransform(affineTransform2);
        this.paintInner(graphics2D, shape);
        if (this.isLineVisible()) {
            this.paintLine(graphics2D, shape);
        }
        graphics2D.setTransform(affineTransform);
    }

    protected void paintInner(Graphics2D graphics2D, Shape shape) {
        int n = this.getType();
        if (n == 1 || n == 2 || n == 3 || n == 4 || n == 5) {
            if (this.getInnerPaint() != null) {
                graphics2D.setPaint(this.getInnerPaint().getPaint(null));
            }
            graphics2D.fill(shape);
        }
    }

    protected void paintLine(Graphics2D graphics2D, Shape shape) {
        BasicStroke basicStroke = new BasicStroke(this.getMagnification() * this.getLineWidth(), 0, 0);
        graphics2D.setStroke(basicStroke);
        graphics2D.setPaint(this.getLineColor());
        graphics2D.draw(shape);
    }

    public void paint(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            this.paint(graphics2D);
        } else {
            if (!this.isVisible()) {
                return;
            }
            Shape shape = this.getSymbolShape();
            if (shape == null) {
                return;
            }
            Area area = new Area(rectangle2D);
            this.paintInner(graphics2D, area, shape);
            if (this.isLineVisible()) {
                this.paintLine(graphics2D, area, shape);
            }
        }
    }

    protected void paintInner(Graphics2D graphics2D, Area area, Shape shape) {
        Area area2 = new Area(shape);
        area2.intersect(area);
        if (this.getInnerPaint() != null) {
            graphics2D.setPaint(this.getInnerPaint().getPaint(null));
        }
        graphics2D.fill(area2);
    }

    protected void paintLine(Graphics2D graphics2D, Area area, Shape shape) {
        BasicStroke basicStroke = new BasicStroke(this.getMagnification() * this.getLineWidth(), 0, 0);
        Shape shape2 = basicStroke.createStrokedShape(shape);
        Area area2 = new Area(shape2);
        area2.intersect(area);
        graphics2D.setPaint(this.getLineColor());
        graphics2D.fill(area2);
    }

    protected abstract Shape getShape();

    protected abstract void updateShape();
}

