/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementArrow;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementSymbol;
import jp.riken.brain.ni.samuraigraph.figure.SGElementGroup;
import jp.riken.brain.ni.samuraigraph.figure.SGIArrowConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGStroke;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementArrow2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupVXY;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIElementGroupConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIElementGroupGridSXY;
import org.w3c.dom.Element;

public abstract class SGElementGroupArrow
extends SGElementGroupVXY
implements SGIElementGroupGridSXY,
SGIArrowConstants,
SGIElementGroupConstants {
    protected SGStroke mStroke = new SGStroke();
    protected int mLineType;
    protected float mHeadSize;
    protected float mHeadOpenAngle;
    protected float mHeadCloseAngle;
    protected int mStartHeadType;
    protected int mEndHeadType;
    protected Color mColor;
    protected Shape mStartHeadShape = null;
    protected Shape mEndHeadShape = null;
    protected boolean mGridMode = false;
    protected Rectangle2D mBounds = new Rectangle2D.Float();
    protected static final float SINGLE_VALUE_MARGIN = 10.0f;

    public void dispose() {
        super.dispose();
        this.mBounds = null;
    }

    protected SGStroke getStroke() {
        return this.mStroke;
    }

    public boolean setMagnification(float f) {
        if (!super.setMagnification(f)) {
            return false;
        }
        this.mStroke.setMagnification(f);
        this.updateHeadShape();
        return true;
    }

    public int getLineType() {
        return this.mLineType;
    }

    public float getLineWidth() {
        return this.mStroke.getLineWidth();
    }

    public float getLineWidth(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getLineWidth(), string);
    }

    public float getHeadSize() {
        return this.mHeadSize;
    }

    public float getHeadSize(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getHeadSize(), string);
    }

    public float getHeadOpenAngle() {
        return this.mHeadOpenAngle;
    }

    public float getHeadCloseAngle() {
        return this.mHeadCloseAngle;
    }

    public int getStartHeadType() {
        return this.mStartHeadType;
    }

    public int getEndHeadType() {
        return this.mEndHeadType;
    }

    public Color getColor() {
        return this.mColor;
    }

    public Shape getStartHeadShape() {
        return this.mStartHeadShape;
    }

    public Shape getEndHeadShape() {
        return this.mEndHeadShape;
    }

    protected void updateHeadShape() {
        float f = this.getMagnification() * this.getHeadSize();
        float f2 = this.getHeadOpenAngle();
        float f3 = this.getHeadCloseAngle();
        this.mStartHeadShape = SGDrawingElementArrow2D.createHeadShape(this.getStartHeadType(), f, f2, f3);
        this.mEndHeadShape = SGDrawingElementArrow2D.createHeadShape(this.getEndHeadType(), f, f2, f3);
    }

    public boolean setLineType(int n) {
        if (!SGDrawingElementLine.isValidLineType(n)) {
            return false;
        }
        this.mLineType = n;
        this.mStroke.setLineType(n);
        return true;
    }

    public boolean setLineWidth(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("lw < 0.0f");
        }
        this.mStroke.setLineWidth(f);
        return true;
    }

    public abstract boolean setLineWidth(float var1, String var2);

    public boolean setHeadSize(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("size < 0.0f");
        }
        this.mHeadSize = f;
        this.updateHeadShape();
        return true;
    }

    public abstract boolean setHeadSize(float var1, String var2);

    public abstract boolean setHeadAngle(float var1, float var2);

    public boolean setStartHeadType(int n) {
        if (!SGDrawingElementArrow.isValidArrowHeadType(n)) {
            return false;
        }
        this.mStartHeadType = n;
        this.updateHeadShape();
        return true;
    }

    public boolean setEndHeadType(int n) {
        if (!SGDrawingElementArrow.isValidArrowHeadType(n)) {
            return false;
        }
        this.mEndHeadType = n;
        this.updateHeadShape();
        return true;
    }

    public boolean setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color == null");
        }
        this.mColor = color;
        return true;
    }

    public abstract SGTuple2f getStartLocation(int var1);

    public abstract SGTuple2f getEndLocation(int var1);

    public boolean paintElement(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        if (sGDrawingElementArray == null) {
            return true;
        }
        for (int i = 0; i < sGDrawingElementArray.length; ++i) {
            SGDrawingElementArrow2D sGDrawingElementArrow2D = (SGDrawingElementArrow2D)sGDrawingElementArray[i];
            if (!sGDrawingElementArrow2D.isVisible()) continue;
            sGDrawingElementArrow2D.paint(graphics2D, rectangle2D);
        }
        return true;
    }

    public static String getSymbolTypeName(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = "Circle";
                break;
            }
            case 2: {
                string = "Square";
                break;
            }
            case 4: {
                string = "Triangle";
                break;
            }
            case 6: {
                string = "Cross";
                break;
            }
            case 8: {
                string = "Transverse Line";
                break;
            }
            case 10: {
                string = "Arrow Head";
                break;
            }
            case -1: {
                string = "No Symbol";
                break;
            }
        }
        return string;
    }

    public String getTagName() {
        return "Arrow";
    }

    public boolean writeProperty(Element element) {
        float f = (float)SGUtilityNumber.roundOffNumber(this.getLineWidth(), -3);
        float f2 = (float)SGUtilityNumber.roundOffNumber(this.getHeadSize() * 0.035277776f, -3);
        float f3 = (float)SGUtilityNumber.roundOffNumber(this.getHeadOpenAngle(), -3);
        float f4 = (float)SGUtilityNumber.roundOffNumber(this.getHeadCloseAngle(), -3);
        ArrayList<Color> arrayList = new ArrayList<Color>();
        arrayList.add(this.getColor());
        element.setAttribute("Width", Float.toString(f) + "pt");
        element.setAttribute("Type", SGDrawingElementLine.getLineTypeName(this.getLineType()));
        element.setAttribute("HeadSize", Float.toString(f2) + "cm");
        element.setAttribute("StartHeadType", SGDrawingElementArrow.getArrowHeadTypeName(this.getStartHeadType()));
        element.setAttribute("EndHeadType", SGDrawingElementArrow.getArrowHeadTypeName(this.getEndHeadType()));
        element.setAttribute("HeadOpenAngle", Float.toString(f3));
        element.setAttribute("HeadCloseAngle", Float.toString(f4));
        element.setAttribute("Color", SGUtilityText.getColorListString(arrayList));
        return true;
    }

    public boolean readProperty(Element element) {
        float f;
        StringBuffer stringBuffer;
        String string = null;
        Number number = null;
        Color color = null;
        List<Color> list = null;
        string = element.getAttribute("Width");
        if (string.length() != 0) {
            stringBuffer = new StringBuffer();
            number = SGUtilityText.getNumber(string, stringBuffer);
            if (number == null) {
                return false;
            }
            f = number.floatValue();
            if (!this.setLineWidth(f, stringBuffer.toString())) {
                return false;
            }
        }
        if ((string = element.getAttribute("Type")).length() != 0) {
            number = SGDrawingElementLine.getLineTypeFromName(string);
            if (number == null) {
                return false;
            }
            int n = number.intValue();
            if (!this.setLineType(n)) {
                return false;
            }
        }
        if ((string = element.getAttribute("HeadSize")).length() != 0) {
            stringBuffer = new StringBuffer();
            number = SGUtilityText.getNumber(string, stringBuffer);
            if (number == null) {
                return false;
            }
            f = number.floatValue();
            if (!this.setHeadSize(f, stringBuffer.toString())) {
                return false;
            }
        }
        if ((string = element.getAttribute("StartHeadType")).length() != 0) {
            number = SGDrawingElementArrow.getArrowHeadTypeFromName(string);
            if (number == null) {
                return false;
            }
            int n = number.intValue();
            if (!this.setStartHeadType(n)) {
                return false;
            }
        }
        if ((string = element.getAttribute("EndHeadType")).length() != 0) {
            number = SGDrawingElementArrow.getArrowHeadTypeFromName(string);
            if (number == null) {
                return false;
            }
            int n = number.intValue();
            if (!this.setEndHeadType(n)) {
                return false;
            }
        }
        if ((string = element.getAttribute("HeadOpenAngle")).length() != 0) {
            number = SGUtilityText.getFloat(string, SGIConstants.degree);
            if (number == null) {
                return false;
            }
            float f2 = number.floatValue();
            string = element.getAttribute("HeadCloseAngle");
            if (string.length() != 0) {
                number = SGUtilityText.getFloat(string, SGIConstants.degree);
                if (number == null) {
                    return false;
                }
                f = number.floatValue();
                if (!this.setHeadAngle(f2, f)) {
                    return false;
                }
            }
        }
        if ((string = element.getAttribute("Color")).length() != 0) {
            list = SGUtilityText.getColorList(string);
            if (list == null) {
                return false;
            }
            if (list.size() < 1) {
                return false;
            }
            color = list.get(0);
            if (!this.setColor(color)) {
                return false;
            }
        }
        return true;
    }

    protected boolean initDrawingElement(SGTuple2f[] sGTuple2fArray, SGTuple2f[] sGTuple2fArray2) {
        int n = sGTuple2fArray.length;
        if (!this.initDrawingElement(n)) {
            return false;
        }
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        for (int i = 0; i < sGDrawingElementArray.length; ++i) {
            ((SGDrawingElementArrow)sGDrawingElementArray[i]).setLocation(sGTuple2fArray[i], sGTuple2fArray2[i]);
        }
        return true;
    }

    public boolean setLocation(SGTuple2f[] sGTuple2fArray, SGTuple2f[] sGTuple2fArray2) {
        if (sGTuple2fArray == null || sGTuple2fArray2 == null) {
            throw new IllegalArgumentException("startArray==null || endArray==null");
        }
        if (sGTuple2fArray.length != sGTuple2fArray2.length) {
            throw new IllegalArgumentException("startArray.length != endArray.length");
        }
        if (sGTuple2fArray.length != this.mDrawingElementArray.length) {
            this.initDrawingElement(sGTuple2fArray.length);
        }
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        for (int i = 0; i < sGDrawingElementArray.length; ++i) {
            boolean bl = !sGTuple2fArray[i].isInfinite() && !sGTuple2fArray[i].isNaN() && !sGTuple2fArray2[i].isInfinite() && !sGTuple2fArray2[i].isNaN();
            SGDrawingElementArrow sGDrawingElementArrow = (SGDrawingElementArrow)sGDrawingElementArray[i];
            sGDrawingElementArrow.setVisible(bl);
            if (!bl) continue;
            sGDrawingElementArrow.setLocation(sGTuple2fArray[i], sGTuple2fArray2[i]);
        }
        return true;
    }

    public SGProperties getProperties() {
        ArrowProperties arrowProperties = new ArrowProperties();
        if (!this.getProperties(arrowProperties)) {
            return null;
        }
        return arrowProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof ArrowProperties)) {
            return false;
        }
        if (!super.getProperties(sGProperties)) {
            return false;
        }
        ArrowProperties arrowProperties = (ArrowProperties)sGProperties;
        arrowProperties.setLineWidth(this.getLineWidth());
        arrowProperties.setLineType(this.getLineType());
        arrowProperties.setHeadSize(this.getHeadSize());
        arrowProperties.setStartHeadType(this.getStartHeadType());
        arrowProperties.setEndHeadType(this.getEndHeadType());
        arrowProperties.setHeadOpenAngle(this.getHeadOpenAngle());
        arrowProperties.setHeadCloseAngle(this.getHeadCloseAngle());
        arrowProperties.setColor(this.getColor());
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof ArrowProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        ArrowProperties arrowProperties = (ArrowProperties)sGProperties;
        Float f = arrowProperties.getLineWidth();
        if (f == null) {
            return false;
        }
        this.setLineWidth(f.floatValue());
        Integer n = arrowProperties.getLineType();
        if (n == null) {
            return false;
        }
        this.setLineType(n);
        Float f2 = arrowProperties.getHeadSize();
        if (f2 == null) {
            return false;
        }
        this.setHeadSize(f2.floatValue());
        Integer n2 = arrowProperties.getStartHeadType();
        if (n2 == null) {
            return false;
        }
        this.setStartHeadType(n2);
        Integer n3 = arrowProperties.getEndHeadType();
        if (n3 == null) {
            return false;
        }
        this.setEndHeadType(n3);
        Float f3 = arrowProperties.getHeadOpenAngle();
        if (f3 == null) {
            return false;
        }
        Float f4 = arrowProperties.getHeadCloseAngle();
        if (f4 == null) {
            return false;
        }
        this.setHeadAngle(f3.floatValue(), f4.floatValue());
        Color color = arrowProperties.getColor();
        if (color == null) {
            return false;
        }
        this.setColor(color);
        return true;
    }

    public boolean isGridMode() {
        return this.mGridMode;
    }

    public boolean setGridMode(boolean bl) {
        this.mGridMode = bl;
        return true;
    }

    protected static class ArrowInGroup
    extends SGDrawingElementArrow2D {
        protected SGElementGroup mGroup = null;
        protected int mIndex = -1;

        private SGElementGroupArrow getArrowGroup() {
            return (SGElementGroupArrow)this.mGroup;
        }

        protected ArrowInGroup() {
        }

        public ArrowInGroup(SGElementGroupArrow sGElementGroupArrow, int n) {
            this.mGroup = sGElementGroupArrow;
            this.mIndex = n;
            this.mLine = this.createBodyInstance();
            this.mStartHead = this.createHeadInstance(this, true);
            this.mEndHead = this.createHeadInstance(this, false);
        }

        public float getLineWidth() {
            return this.getArrowGroup().getLineWidth();
        }

        public int getLineType() {
            return this.getArrowGroup().getLineType();
        }

        public float getHeadSize() {
            return this.getArrowGroup().getHeadSize();
        }

        public int getStartHeadType() {
            return this.getArrowGroup().getStartHeadType();
        }

        public int getEndHeadType() {
            return this.getArrowGroup().getEndHeadType();
        }

        public float getHeadCloseAngle() {
            return this.getArrowGroup().getHeadCloseAngle();
        }

        public float getHeadOpenAngle() {
            return this.getArrowGroup().getHeadOpenAngle();
        }

        public boolean setHeadAngle(Float f, Float f2) {
            return true;
        }

        public void dispose() {
            super.dispose();
            this.mGroup = null;
        }

        protected SGDrawingElementLine createBodyInstance() {
            return new SGDrawingElementArrow2D.ArrowBody(this);
        }

        protected SGDrawingElementSymbol createHeadInstance(SGDrawingElementArrow sGDrawingElementArrow, boolean bl) {
            return new SGDrawingElementArrow2D.ArrowHead(sGDrawingElementArrow, bl);
        }

        public SGStroke getStroke() {
            return this.getArrowGroup().getStroke();
        }

        public boolean setLineType(int n) {
            return true;
        }

        public boolean setLineWidth(float f) {
            return true;
        }

        public boolean setStartHeadType(int n) {
            return true;
        }

        public boolean setEndHeadType(int n) {
            return true;
        }

        public boolean setHeadSize(float f) {
            return true;
        }

        public float getMagnification() {
            return this.mGroup.getMagnification();
        }

        public boolean setMagnification(float f) {
            return true;
        }

        public Color getColor() {
            return this.getArrowGroup().getColor();
        }

        public boolean setColor(Color color) {
            return true;
        }

        public SGTuple2f getEnd() {
            return this.getArrowGroup().getEndLocation(this.mIndex);
        }

        public SGTuple2f getStart() {
            return this.getArrowGroup().getStartLocation(this.mIndex);
        }

        public boolean setLocation(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
            return true;
        }

        public boolean setEndX(float f) {
            return true;
        }

        public boolean setEndY(float f) {
            return true;
        }

        public boolean setStartX(float f) {
            return true;
        }

        public boolean setStartY(float f) {
            return true;
        }

        protected Shape getStartHeadShape() {
            return this.getArrowGroup().getStartHeadShape();
        }

        protected Shape getEndHeadShape() {
            return this.getArrowGroup().getEndHeadShape();
        }

        protected void updateHeadShape() {
        }
    }

    public static class ArrowProperties
    extends SGElementGroup.ElementGroupProperties {
        private SGDrawingElementArrow.ArrowProperties mArrowProperties = new SGDrawingElementArrow.ArrowProperties();

        public Object copy() {
            Object object = super.copy();
            ArrowProperties arrowProperties = (ArrowProperties)object;
            arrowProperties.mArrowProperties = (SGDrawingElementArrow.ArrowProperties)this.mArrowProperties.copy();
            return arrowProperties;
        }

        public void dispose() {
            super.dispose();
            this.mArrowProperties.dispose();
        }

        public boolean equals(Object object) {
            if (!(object instanceof ArrowProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            ArrowProperties arrowProperties = (ArrowProperties)object;
            return this.mArrowProperties.equals(arrowProperties.mArrowProperties);
        }

        public Float getLineWidth() {
            return this.mArrowProperties.getLineWidth();
        }

        public Integer getLineType() {
            return this.mArrowProperties.getLineType();
        }

        public Float getHeadLineWidth() {
            return this.mArrowProperties.getLineWidth();
        }

        public Float getHeadSize() {
            return this.mArrowProperties.getHeadSize();
        }

        public Integer getStartHeadType() {
            return this.mArrowProperties.getStartHeadType();
        }

        public Integer getEndHeadType() {
            return this.mArrowProperties.getEndHeadType();
        }

        public Float getHeadOpenAngle() {
            return this.mArrowProperties.getHeadOpenAngle();
        }

        public Float getHeadCloseAngle() {
            return this.mArrowProperties.getHeadCloseAngle();
        }

        public Color getColor() {
            return this.mArrowProperties.getColor();
        }

        public boolean setLineWidth(float f) {
            return this.mArrowProperties.setLineWidth(f);
        }

        public boolean setLineType(int n) {
            return this.mArrowProperties.setLineType(n);
        }

        public boolean setStartHeadType(int n) {
            return this.mArrowProperties.setStartHeadType(n);
        }

        public boolean setEndHeadType(int n) {
            return this.mArrowProperties.setEndHeadType(n);
        }

        public boolean setHeadSize(float f) {
            return this.mArrowProperties.setHeadSize(f);
        }

        public boolean setHeadOpenAngle(float f) {
            return this.mArrowProperties.setHeadOpenAngle(f);
        }

        public boolean setHeadCloseAngle(float f) {
            return this.mArrowProperties.setHeadCloseAngle(f);
        }

        public boolean setColor(Color color) {
            return this.mArrowProperties.setColor(color);
        }
    }
}

