/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.data.SGIVXYTypeData;
import jp.riken.brain.ni.samuraigraph.figure.SGIVXYDataConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGArrowUtility;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementArrow2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupArrow;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupArrowForData;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSetInGraph;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSetInGraphVXY;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGFigureElementGraph;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIElementGroupInGraph;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityForFigureElementJava2D;

public class SGElementGroupArrowInGraph
extends SGElementGroupArrowForData
implements SGIElementGroupInGraph,
SGIVXYDataConstants {
    protected SGFigureElementGraph mGraph = null;
    protected SGElementGroupSetInGraph mGroupSet = null;
    private boolean mFocusedFlag = false;
    public static final int NUMBER_OF_ANCHORS = 8;
    public static final Color FOCUS_COLOR = new Color(63, 63, 63, 63);

    public boolean setElementGroupSet(SGElementGroupSetInGraph sGElementGroupSetInGraph) {
        this.mGroupSet = sGElementGroupSetInGraph;
        return true;
    }

    public void setFocused(boolean bl) {
        this.mFocusedFlag = bl;
    }

    public boolean isFocused() {
        return this.mFocusedFlag;
    }

    protected SGElementGroupArrowInGraph(SGFigureElementGraph sGFigureElementGraph) {
        this.mGraph = sGFigureElementGraph;
        this.setVisible(true);
    }

    public boolean paintElement(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        block6: {
            block5: {
                if (!super.paintElement(graphics2D, rectangle2D)) {
                    return false;
                }
                if (!this.mGridMode) break block5;
                if (!this.isFocused()) break block6;
                float f = (float)this.mBounds.getMinX();
                float f2 = (float)this.mBounds.getMaxX();
                float f3 = (float)this.mBounds.getMinY();
                float f4 = (float)this.mBounds.getMaxY();
                float f5 = f2 - f;
                float f6 = f4 - f3;
                graphics2D.setPaint(FOCUS_COLOR);
                Rectangle2D.Double double_ = new Rectangle2D.Double(f, f3, f5, f6);
                graphics2D.fill(double_);
                float f7 = (f2 - f) / 7.0f;
                float f8 = (f4 - f3) / 7.0f;
                for (int i = 0; i <= 7; ++i) {
                    float f9 = f3 + (float)i * f8;
                    for (int j = 0; j <= 7; ++j) {
                        float f10 = f + (float)j * f7;
                        SGUtilityForFigureElementJava2D.drawAnchorAsFocusedObject(f10, f9, graphics2D);
                    }
                }
                break block6;
            }
            if (this.isFocused() && this.mGraph.isSymbolsVisibleAroundFocusedObjects()) {
                SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
                for (int i = 0; i < sGDrawingElementArray.length; ++i) {
                    SGDrawingElementArrow2D sGDrawingElementArrow2D = (SGDrawingElementArrow2D)sGDrawingElementArray[i];
                    this.emphasisArrow(sGDrawingElementArrow2D, graphics2D);
                }
            }
        }
        return true;
    }

    private boolean emphasisArrow(SGDrawingElementArrow2D sGDrawingElementArrow2D, Graphics2D graphics2D) {
        SGTuple2f sGTuple2f = sGDrawingElementArrow2D.getStart();
        SGTuple2f sGTuple2f2 = sGDrawingElementArrow2D.getEnd();
        SGUtilityForFigureElementJava2D.drawAnchorAsFocusedObject(new Point2D.Float(sGTuple2f.x, sGTuple2f.y), graphics2D);
        SGUtilityForFigureElementJava2D.drawAnchorAsFocusedObject(new Point2D.Float(sGTuple2f2.x, sGTuple2f2.y), graphics2D);
        return true;
    }

    public boolean contains(int n, int n2) {
        Rectangle2D rectangle2D = this.mGraph.getGraphRect();
        if (!rectangle2D.contains(n, n2)) {
            return false;
        }
        if (this.mGridMode) {
            return this.mBounds.contains(n, n2);
        }
        return super.contains(n, n2);
    }

    protected SGDrawingElement createDrawingElementInstance(int n) {
        return new SGElementGroupArrow.ArrowInGroup(this, n);
    }

    public SGTuple2f getEndLocation(int n) {
        if (this.mGroupSet instanceof SGElementGroupSetInGraphVXY) {
            SGElementGroupSetInGraphVXY sGElementGroupSetInGraphVXY = (SGElementGroupSetInGraphVXY)this.mGroupSet;
            return sGElementGroupSetInGraphVXY.getEndLocation(n);
        }
        throw new Error("Not supported");
    }

    public SGTuple2f getStartLocation(int n) {
        if (this.mGroupSet instanceof SGElementGroupSetInGraphVXY) {
            SGElementGroupSetInGraphVXY sGElementGroupSetInGraphVXY = (SGElementGroupSetInGraphVXY)this.mGroupSet;
            return sGElementGroupSetInGraphVXY.getStartLocation(n);
        }
        throw new Error("Not supported");
    }

    public boolean initDrawingElement(float[] fArray, float[] fArray2) {
        int n = fArray.length * fArray2.length;
        return this.initDrawingElement(n);
    }

    public boolean setLocation(float[] fArray, float[] fArray2) {
        if (fArray == null || fArray2 == null) {
            throw new IllegalArgumentException("xCoordinateArray == null || yCoordinateArray == null");
        }
        int n = fArray.length;
        int n2 = fArray2.length;
        int n3 = n * n2;
        if (this.mDrawingElementArray.length != n3) {
            this.initDrawingElement(n3);
        }
        SGIVXYTypeData sGIVXYTypeData = (SGIVXYTypeData)((Object)this.mGroupSet.getData());
        SGElementGroupSetInGraphVXY sGElementGroupSetInGraphVXY = (SGElementGroupSetInGraphVXY)this.mGroupSet;
        SGTuple2f[] sGTuple2fArray = sGElementGroupSetInGraphVXY.mEndPointsArray;
        if (!SGArrowUtility.calcEndLocation(sGIVXYTypeData, this.mGraph, this.mGroupSet, sGElementGroupSetInGraphVXY.getMagnitudePerCM(), sGElementGroupSetInGraphVXY.isDirectionInvariant(), fArray, fArray2, null, sGTuple2fArray)) {
            return false;
        }
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (n == 1) {
            f = fArray[0];
            f2 = fArray[0];
        } else {
            f = SGUtilityNumber.min(fArray);
            f2 = SGUtilityNumber.max(fArray);
        }
        if (n2 == 1) {
            f3 = fArray2[0];
            f4 = fArray2[0];
        } else {
            f3 = SGUtilityNumber.min(fArray2);
            f4 = SGUtilityNumber.max(fArray2);
        }
        SGTuple2f sGTuple2f = SGUtilityNumber.min(sGTuple2fArray);
        if (sGTuple2f.x < f) {
            f = sGTuple2f.x;
        }
        if (sGTuple2f.y < f3) {
            f3 = sGTuple2f.y;
        }
        SGTuple2f sGTuple2f2 = SGUtilityNumber.max(sGTuple2fArray);
        if (sGTuple2f2.x > f2) {
            f2 = sGTuple2f2.x;
        }
        if (sGTuple2f2.y > f4) {
            f4 = sGTuple2f2.y;
        }
        this.mBounds.setRect(f -= 10.0f, f3 -= 10.0f, (f2 += 10.0f) - f, (f4 += 10.0f) - f3);
        return true;
    }
}

