/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.data.SGISXYData;
import jp.riken.brain.ni.samuraigraph.figure.SGISXYDataConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementBar2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupBar;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupBarForData;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSetInGraph;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSetInGraphSXY;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGFigureElementGraph;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIElementGroupInGraph;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityForFigureElementJava2D;
import org.w3c.dom.Element;

public class SGElementGroupBarInGraph
extends SGElementGroupBarForData
implements SGIElementGroupInGraph,
SGISXYDataConstants {
    public static final int MAX_NUMBER_OF_ANCHORS = 8;
    private SGFigureElementGraph mGraph = null;
    protected SGElementGroupSetInGraph mGroupSet = null;
    private boolean mFocusedFlag = false;

    public boolean setElementGroupSet(SGElementGroupSetInGraph sGElementGroupSetInGraph) {
        this.mGroupSet = sGElementGroupSetInGraph;
        return true;
    }

    public void setFocused(boolean bl) {
        this.mFocusedFlag = bl;
    }

    public boolean isFocused() {
        return this.mFocusedFlag;
    }

    public SGElementGroupBarInGraph(SGISXYData sGISXYData, SGFigureElementGraph sGFigureElementGraph) {
        super(sGISXYData);
        this.mGraph = sGFigureElementGraph;
    }

    public boolean initDrawingElement(int n) {
        super.initDrawingElement(n);
        return true;
    }

    protected boolean initDrawingElement(SGTuple2f[] sGTuple2fArray) {
        super.initDrawingElement(sGTuple2fArray);
        return true;
    }

    public boolean writeProperty(Element element) {
        if (!super.writeProperty(element)) {
            return false;
        }
        element.setAttribute("Visible", Boolean.toString(this.mVisibleFlag));
        return true;
    }

    public boolean readProperty(Element element) {
        if (!super.readProperty(element)) {
            return false;
        }
        return this.mGraph.readProperty(this, element);
    }

    private float getBaselineLocation(double d) {
        SGElementGroupSetInGraphSXY sGElementGroupSetInGraphSXY = (SGElementGroupSetInGraphSXY)this.mGroupSet;
        boolean bl = this.isVertical();
        SGAxis sGAxis = bl ? sGElementGroupSetInGraphSXY.getYAxis() : sGElementGroupSetInGraphSXY.getXAxis();
        return this.mGraph.calcLocation(d, sGAxis, !bl);
    }

    public boolean setLocation(SGTuple2f[] sGTuple2fArray) {
        if (this.mDrawingElementArray == null) {
            return true;
        }
        SGTuple2f[] sGTuple2fArray2 = sGTuple2fArray;
        if (sGTuple2fArray.length != this.mDrawingElementArray.length) {
            this.initDrawingElement(sGTuple2fArray2);
        }
        float f = this.getBaselineLocation(this.getBaselineValue());
        boolean bl = true;
        if (Float.isInfinite(f) || Float.isNaN(f)) {
            bl = false;
        }
        SGElementGroupSetInGraphSXY sGElementGroupSetInGraphSXY = (SGElementGroupSetInGraphSXY)this.mGroupSet;
        SGAxis sGAxis = this.mVerticalFlag ? sGElementGroupSetInGraphSXY.getXAxis() : sGElementGroupSetInGraphSXY.getYAxis();
        double d = sGAxis.getMinValue();
        double d2 = sGAxis.getMaxValue();
        float f2 = (float)(Math.abs(this.getWidthValueInGraph()) / (d2 - d));
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (this.mVerticalFlag) {
            f3 = this.mGraph.getGraphRectWidth() * f2;
            this.setRectangleWidth(f3);
        } else {
            f4 = this.mGraph.getGraphRectHeight() * f2;
            this.setRectangleHeight(f4);
        }
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        for (int i = 0; i < sGDrawingElementArray.length; ++i) {
            SGDrawingElementBar2D sGDrawingElementBar2D = (SGDrawingElementBar2D)sGDrawingElementArray[i];
            float f5 = sGTuple2fArray2[i].x;
            float f6 = sGTuple2fArray2[i].y;
            if (!bl || Float.isInfinite(f5) || Float.isNaN(f5) || Float.isInfinite(f6) || Float.isNaN(f6)) {
                sGDrawingElementBar2D.setVisible(false);
                continue;
            }
            sGDrawingElementBar2D.setVisible(true);
            if (this.mVerticalFlag) {
                f4 = f - f6;
            } else {
                f3 = f - f5;
            }
            sGDrawingElementBar2D.setBounds(f5, f6, f3, f4);
        }
        return true;
    }

    public boolean paintElement(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        block4: {
            super.paintElement(graphics2D, rectangle2D);
            SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
            if (!this.isFocused() || !this.mGraph.isSymbolsVisibleAroundFocusedObjects()) break block4;
            int n = sGDrawingElementArray.length;
            if (n <= 8) {
                for (int i = 0; i < n; ++i) {
                    SGDrawingElementBar2D sGDrawingElementBar2D = (SGDrawingElementBar2D)sGDrawingElementArray[i];
                    this.emphasisBar(sGDrawingElementBar2D, graphics2D);
                }
            } else {
                int n2 = n / 8;
                int n3 = 0;
                do {
                    SGDrawingElementBar2D sGDrawingElementBar2D = (SGDrawingElementBar2D)sGDrawingElementArray[n3];
                    this.emphasisBar(sGDrawingElementBar2D, graphics2D);
                } while ((n3 += n2) < n);
            }
        }
        return true;
    }

    private boolean emphasisBar(SGDrawingElementBar2D sGDrawingElementBar2D, Graphics2D graphics2D) {
        SGUtilityForFigureElementJava2D.drawAnchorsOnRectangle(sGDrawingElementBar2D.getElementBounds(), graphics2D);
        return true;
    }

    public boolean contains(int n, int n2) {
        Rectangle2D rectangle2D = this.mGraph.getGraphRect();
        if (!rectangle2D.contains(n, n2)) {
            return false;
        }
        return super.contains(n, n2);
    }

    public float getX(int n) {
        return this.getLocation((int)n).x;
    }

    public float getY(int n) {
        return this.getLocation((int)n).y;
    }

    public SGTuple2f getLocation(int n) {
        if (this.mGroupSet instanceof SGElementGroupSetInGraphSXY) {
            SGElementGroupSetInGraphSXY sGElementGroupSetInGraphSXY = (SGElementGroupSetInGraphSXY)this.mGroupSet;
            return sGElementGroupSetInGraphSXY.getBarLocation(n);
        }
        throw new Error("Not supported.");
    }

    public boolean setBaselineValue(double d) {
        if (this.isVisible()) {
            SGAxis sGAxis;
            SGAxis sGAxis2 = sGAxis = this.isVertical() ? this.mGroupSet.getYAxis() : this.mGroupSet.getXAxis();
            if (!sGAxis.isValidValue(d)) {
                return false;
            }
        }
        return super.setBaselineValue(d);
    }

    public boolean setWidthValue(double d) {
        SGAxis sGAxis;
        SGAxis sGAxis2 = sGAxis = this.isVertical() ? this.mGroupSet.getXAxis() : this.mGroupSet.getYAxis();
        if (!sGAxis.isValidValue(d)) {
            return false;
        }
        return super.setWidthValue(d);
    }

    protected double getIntervalInGraph() {
        return this.mInterval;
    }

    protected double getWidthValueInGraph() {
        return super.getWidthValue();
    }

    protected SGDrawingElement createDrawingElementInstance(int n) {
        return new BarInGraph(this, n);
    }

    protected static class BarInGraph
    extends SGElementGroupBar.BarInGroup {
        public BarInGraph(SGElementGroupBarInGraph sGElementGroupBarInGraph, int n) {
            super(sGElementGroupBarInGraph, n);
        }

        public Rectangle2D getElementBounds() {
            float f;
            float f2;
            float f3 = this.getX();
            float f4 = this.getY();
            float f5 = this.getWidth();
            float f6 = this.getHeight();
            float f7 = Math.abs(f5);
            float f8 = Math.abs(f6);
            if (this.isVertical()) {
                f2 = f3 - 0.5f * f7;
                f = f6 > 0.0f ? f4 : f4 - f8;
            } else {
                f2 = f5 > 0.0f ? f3 : f3 - f7;
                f = f4 - 0.5f * f8;
            }
            Rectangle2D.Float float_ = new Rectangle2D.Float(f2, f, f7, f8);
            return float_;
        }

        public float getWidth() {
            return this.isVertical() ? this.mGroup.getRectangleWidth() : this.mWidth;
        }

        public float getHeight() {
            return this.isVertical() ? this.mHeight : this.mGroup.getRectangleHeight();
        }

        public boolean setWidth(float f) {
            this.mWidth = f;
            return true;
        }

        public boolean setHeight(float f) {
            this.mHeight = f;
            return true;
        }
    }
}

