/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGFillPaint;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.figure.SGISXYZDataConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupColorMap;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupColorMapForData;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSetInGraph;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSetInGraphSXYZ;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGFigureElementGraph;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIElementGroupInGraph;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityForFigureElementJava2D;
import org.w3c.dom.Element;

public class SGElementGroupColorMapInGraph
extends SGElementGroupColorMapForData
implements SGIElementGroupInGraph,
SGISXYZDataConstants {
    public static final int MAX_NUMBER_OF_ANCHORS = 20;
    private SGFigureElementGraph mGraph = null;
    protected SGElementGroupSetInGraph mGroupSet = null;
    private boolean mFocusedFlag = false;
    public static final int NUMBER_OF_ANCHORS = 8;
    public static final Color FOCUS_COLOR = new Color(63, 63, 63, 63);

    public boolean setElementGroupSet(SGElementGroupSetInGraph sGElementGroupSetInGraph) {
        this.mGroupSet = sGElementGroupSetInGraph;
        return true;
    }

    public void setFocused(boolean bl) {
        this.mFocusedFlag = bl;
    }

    public boolean isFocused() {
        return this.mFocusedFlag;
    }

    public SGElementGroupColorMapInGraph(SGFigureElementGraph sGFigureElementGraph) {
        this.mGraph = sGFigureElementGraph;
        this.setVisible(true);
    }

    public boolean setLocation(SGTuple2f[] sGTuple2fArray) {
        if (this.mDrawingElementArray == null) {
            return true;
        }
        if (sGTuple2fArray.length != this.mDrawingElementArray.length) {
            this.initDrawingElement(sGTuple2fArray);
        }
        SGElementGroupSetInGraphSXYZ sGElementGroupSetInGraphSXYZ = (SGElementGroupSetInGraphSXYZ)this.mGroupSet;
        SGAxis sGAxis = sGElementGroupSetInGraphSXYZ.getXAxis();
        SGAxis sGAxis2 = sGElementGroupSetInGraphSXYZ.getYAxis();
        double d = sGAxis.getMinValue();
        double d2 = sGAxis.getMaxValue();
        double d3 = sGAxis2.getMinValue();
        double d4 = sGAxis2.getMaxValue();
        float f = this.mGraph.getGraphRectWidth() * (float)(this.mWidthValue / (d2 - d));
        float f2 = this.mGraph.getGraphRectHeight() * (float)(this.mHeightValue / (d4 - d3));
        this.setRectangleWidth(f);
        this.setRectangleHeight(f2);
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        for (int i = 0; i < sGDrawingElementArray.length; ++i) {
            SGElementGroupColorMap.ColorMapRectangle colorMapRectangle = (SGElementGroupColorMap.ColorMapRectangle)sGDrawingElementArray[i];
            float f3 = sGTuple2fArray[i].x;
            float f4 = sGTuple2fArray[i].y;
            if (Float.isInfinite(f3) || Float.isNaN(f3) || Float.isInfinite(f4) || Float.isNaN(f4)) {
                colorMapRectangle.setVisible(false);
                continue;
            }
            colorMapRectangle.setBounds(f3, f4, f, f2);
            double d5 = colorMapRectangle.getZValue();
            if (Double.isNaN(d5) || Double.isInfinite(d5)) {
                colorMapRectangle.setVisible(false);
                continue;
            }
            if (this.mColorBarModel.getScaleType() == 1 && d5 <= 0.0) {
                colorMapRectangle.setVisible(false);
                continue;
            }
            colorMapRectangle.setVisible(true);
            Color color = this.mColorBarModel.evaluate(d5);
            colorMapRectangle.setInnerPaint(new SGFillPaint(color));
        }
        return true;
    }

    public boolean paintElement(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        block7: {
            block6: {
                super.paintElement(graphics2D, rectangle2D);
                if (!this.mGridMode) break block6;
                if (!this.isFocused()) break block7;
                float f = (float)this.mBounds.getMinX();
                float f2 = (float)this.mBounds.getMaxX();
                float f3 = (float)this.mBounds.getMinY();
                float f4 = (float)this.mBounds.getMaxY();
                float f5 = f2 - f;
                float f6 = f4 - f3;
                graphics2D.setPaint(FOCUS_COLOR);
                Rectangle2D.Double double_ = new Rectangle2D.Double(f, f3, f5, f6);
                graphics2D.fill(double_);
                float f7 = (f2 - f) / 7.0f;
                float f8 = (f4 - f3) / 7.0f;
                for (int i = 0; i <= 7; ++i) {
                    float f9 = f3 + (float)i * f8;
                    for (int j = 0; j <= 7; ++j) {
                        float f10 = f + (float)j * f7;
                        SGUtilityForFigureElementJava2D.drawAnchorAsFocusedObject(f10, f9, graphics2D);
                    }
                }
                break block7;
            }
            SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
            if (!this.isFocused() || !this.mGraph.isSymbolsVisibleAroundFocusedObjects()) break block7;
            int n = sGDrawingElementArray.length;
            if (n <= 20) {
                for (int i = 0; i < n; ++i) {
                    SGElementGroupColorMap.ColorMapRectangle colorMapRectangle = (SGElementGroupColorMap.ColorMapRectangle)sGDrawingElementArray[i];
                    Point2D.Float float_ = new Point2D.Float();
                    ((Point2D)float_).setLocation((double)colorMapRectangle.getX() + (double)colorMapRectangle.getWidth() / 2.0, (double)colorMapRectangle.getY() + (double)colorMapRectangle.getHeight() / 2.0);
                    SGUtilityForFigureElementJava2D.drawAnchorAsFocusedObject(float_, graphics2D);
                }
            } else {
                int n2 = n / 20;
                int n3 = 0;
                do {
                    SGElementGroupColorMap.ColorMapRectangle colorMapRectangle = (SGElementGroupColorMap.ColorMapRectangle)sGDrawingElementArray[n3];
                    Point2D.Float float_ = new Point2D.Float();
                    ((Point2D)float_).setLocation((double)colorMapRectangle.getX() + (double)colorMapRectangle.getWidth() / 2.0, (double)colorMapRectangle.getY() + (double)colorMapRectangle.getHeight() / 2.0);
                    SGUtilityForFigureElementJava2D.drawAnchorAsFocusedObject(float_, graphics2D);
                } while ((n3 += n2) < n);
            }
        }
        return true;
    }

    public boolean contains(int n, int n2) {
        if (this.mGridMode) {
            Rectangle2D rectangle2D = this.mGraph.getGraphRect();
            Rectangle2D rectangle2D2 = rectangle2D.createIntersection(this.mBounds);
            return rectangle2D2.contains(n, n2);
        }
        Rectangle2D rectangle2D = this.mGraph.getGraphRect();
        if (!rectangle2D.contains(n, n2)) {
            return false;
        }
        return super.contains(n, n2);
    }

    public boolean writeProperty(Element element) {
        if (!super.writeProperty(element)) {
            return false;
        }
        element.setAttribute("Visible", Boolean.toString(this.mVisibleFlag));
        return true;
    }

    public boolean readProperty(Element element) {
        if (!super.readProperty(element)) {
            return false;
        }
        return this.mGraph.readProperty(this, element);
    }

    public float getX(int n) {
        return this.getLocation((int)n).x;
    }

    public float getY(int n) {
        return this.getLocation((int)n).y;
    }

    public SGTuple2f getLocation(int n) {
        if (this.mGroupSet instanceof SGElementGroupSetInGraphSXYZ) {
            SGElementGroupSetInGraphSXYZ sGElementGroupSetInGraphSXYZ = (SGElementGroupSetInGraphSXYZ)this.mGroupSet;
            return sGElementGroupSetInGraphSXYZ.getLocation(n);
        }
        throw new Error("Not supported.");
    }
}

