/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.geom.Rectangle2D;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2d;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.data.SGISXYTypeData;
import jp.riken.brain.ni.samuraigraph.data.SGISXYTypeMultipleData;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementErrorBar;
import jp.riken.brain.ni.samuraigraph.figure.SGISXYDataConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupErrorBarForData;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSetInGraph;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGFigureElementGraph;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIElementGroupInGraph;
import org.w3c.dom.Element;

public class SGElementGroupErrorBarInGraph
extends SGElementGroupErrorBarForData
implements SGIElementGroupInGraph,
SGISXYDataConstants {
    public static final int MAX_NUMBER_OF_ANCHORS = 8;
    private SGFigureElementGraph mGraph = null;
    protected SGElementGroupSetInGraph mGroupSet = null;
    private SGTuple2f[] mLowerArray = null;
    private SGTuple2f[] mUpperArray = null;
    private SGTuple2f[] mCenterArray = null;
    private boolean mFocusedFlag = false;

    public boolean setElementGroupSet(SGElementGroupSetInGraph sGElementGroupSetInGraph) {
        this.mGroupSet = sGElementGroupSetInGraph;
        return true;
    }

    public void setFocused(boolean bl) {
        this.mFocusedFlag = bl;
    }

    public boolean isFocused() {
        return this.mFocusedFlag;
    }

    public SGElementGroupErrorBarInGraph(SGISXYTypeData sGISXYTypeData, SGFigureElementGraph sGFigureElementGraph) {
        super(sGISXYTypeData);
        this.mGraph = sGFigureElementGraph;
        int n = sGISXYTypeData != null ? sGISXYTypeData.getPointsNumber() : 0;
        this.initDrawingElement(n);
    }

    public SGElementGroupErrorBarInGraph(SGISXYTypeMultipleData sGISXYTypeMultipleData, SGFigureElementGraph sGFigureElementGraph) {
        super(sGISXYTypeMultipleData);
        this.mGraph = sGFigureElementGraph;
        int n = sGISXYTypeMultipleData != null ? sGISXYTypeMultipleData.getPointsNumber() : 0;
        this.initDrawingElement(n);
    }

    public void dispose() {
        super.dispose();
        this.mCenterArray = null;
        this.mLowerArray = null;
        this.mUpperArray = null;
    }

    public boolean writeProperty(Element element) {
        if (!super.writeProperty(element)) {
            return false;
        }
        element.setAttribute("Visible", Boolean.toString(this.mVisibleFlag));
        return true;
    }

    public boolean readProperty(Element element) {
        if (!super.readProperty(element)) {
            return false;
        }
        return this.mGraph.readProperty(this, element);
    }

    boolean calcErrorBarLocation(SGISXYTypeData sGISXYTypeData, SGAxis sGAxis, SGAxis sGAxis2, SGTuple2d[] sGTuple2dArray, double d, SGTuple2f[] sGTuple2fArray) {
        boolean bl;
        SGDrawingElementErrorBar sGDrawingElementErrorBar;
        int n;
        int n2 = sGISXYTypeData.getPointsNumber();
        SGTuple2d[] sGTuple2dArray2 = new SGTuple2d[n2];
        SGTuple2d[] sGTuple2dArray3 = new SGTuple2d[n2];
        for (int i = 0; i < n2; ++i) {
            sGTuple2dArray2[i] = new SGTuple2d(sGTuple2dArray[i]);
            sGTuple2dArray3[i] = new SGTuple2d(sGTuple2dArray[i]);
        }
        double[] dArray = sGISXYTypeData.getLowerErrorValueArray();
        double[] dArray2 = sGISXYTypeData.getUpperErrorValueArray();
        Boolean bl2 = this.isVertical();
        if (bl2 == null) {
            return false;
        }
        if (this.mDrawingElementArray.length != n2) {
            this.initDrawingElement(n2);
        }
        if (this.mErrorBarStyle == 1) {
            for (n = 0; n < n2; ++n) {
                double d2;
                sGDrawingElementErrorBar = (SGDrawingElementErrorBar)this.mDrawingElementArray[n];
                bl = !Double.isNaN(dArray[n]);
                boolean bl3 = !Double.isNaN(dArray2[n]);
                sGDrawingElementErrorBar.setLowerVisible(bl);
                sGDrawingElementErrorBar.setUpperVisible(bl3);
                double d3 = bl ? dArray[n] : 0.0;
                double d4 = d2 = bl3 ? dArray2[n] : 0.0;
                if (Boolean.TRUE.equals(bl2)) {
                    sGTuple2dArray2[n].y += d3;
                    sGTuple2dArray3[n].y += d2;
                    continue;
                }
                sGTuple2dArray2[n].x += d3;
                sGTuple2dArray3[n].x += d2;
            }
        } else if (this.mErrorBarStyle == 2) {
            for (n = 0; n < n2; ++n) {
                double d5;
                sGDrawingElementErrorBar = (SGDrawingElementErrorBar)this.mDrawingElementArray[n];
                bl = !Double.isNaN(dArray2[n]);
                sGDrawingElementErrorBar.setLowerVisible(false);
                sGDrawingElementErrorBar.setUpperVisible(bl);
                double d6 = d5 = bl ? dArray2[n] : 0.0;
                if (Boolean.TRUE.equals(bl2)) {
                    sGTuple2dArray3[n].y += d5;
                    continue;
                }
                sGTuple2dArray3[n].x += d5;
            }
        } else if (this.mErrorBarStyle == 3) {
            for (n = 0; n < n2; ++n) {
                double d7;
                sGDrawingElementErrorBar = (SGDrawingElementErrorBar)this.mDrawingElementArray[n];
                bl = !Double.isNaN(dArray[n]);
                sGDrawingElementErrorBar.setLowerVisible(bl);
                sGDrawingElementErrorBar.setUpperVisible(false);
                double d8 = d7 = bl ? dArray[n] : 0.0;
                if (Boolean.TRUE.equals(bl2)) {
                    sGTuple2dArray2[n].y += d7;
                    continue;
                }
                sGTuple2dArray2[n].x += d7;
            }
        } else {
            throw new Error();
        }
        if (sGAxis2.getScaleType() == 1) {
            for (n = 0; n < n2; ++n) {
                sGDrawingElementErrorBar = (SGDrawingElementErrorBar)this.mDrawingElementArray[n];
                if (sGTuple2dArray[n].y <= 0.0) {
                    sGDrawingElementErrorBar.setLowerVisible(false);
                    sGDrawingElementErrorBar.setUpperVisible(false);
                    continue;
                }
                if (!(sGTuple2dArray2[n].y <= 0.0)) continue;
                sGDrawingElementErrorBar.setLowerVisible(false);
            }
        }
        this.mCenterArray = sGTuple2fArray;
        this.mGraph.calcLocationOfPoints(sGTuple2dArray2, sGAxis, sGAxis2, this.mLowerArray);
        this.mGraph.calcLocationOfPoints(sGTuple2dArray3, sGAxis, sGAxis2, this.mUpperArray);
        return true;
    }

    public boolean initDrawingElement(int n) {
        if (!super.initDrawingElement(n)) {
            return false;
        }
        SGTuple2f[] sGTuple2fArray = new SGTuple2f[n];
        SGTuple2f[] sGTuple2fArray2 = new SGTuple2f[n];
        SGTuple2f[] sGTuple2fArray3 = new SGTuple2f[n];
        for (int i = 0; i < n; ++i) {
            sGTuple2fArray[i] = new SGTuple2f();
            sGTuple2fArray2[i] = new SGTuple2f();
            sGTuple2fArray3[i] = new SGTuple2f();
        }
        this.mCenterArray = sGTuple2fArray;
        this.mLowerArray = sGTuple2fArray2;
        this.mUpperArray = sGTuple2fArray3;
        return true;
    }

    public boolean updateLocation() {
        return this.setLocation(this.mCenterArray, this.mLowerArray, this.mUpperArray);
    }

    public boolean contains(int n, int n2) {
        Rectangle2D rectangle2D = this.mGraph.getGraphRect();
        if (!rectangle2D.contains(n, n2)) {
            return false;
        }
        SGISXYTypeData sGISXYTypeData = (SGISXYTypeData)((Object)this.mGraph.getData(this.mGroupSet));
        if (sGISXYTypeData == null) {
            return false;
        }
        if (!sGISXYTypeData.isErrorBarAvailable()) {
            return false;
        }
        return super.contains(n, n2);
    }

    public SGTuple2f getStartLocation(int n) {
        return this.mCenterArray[n];
    }

    public SGTuple2f getLowerEndLocation(int n) {
        return this.mLowerArray[n];
    }

    public SGTuple2f getUpperEndLocation(int n) {
        return this.mUpperArray[n];
    }
}

