/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDataColumnInfo;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementForData;
import jp.riken.brain.ni.samuraigraph.base.SGIUndoable;
import jp.riken.brain.ni.samuraigraph.base.SGPluginsQueryMessage;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyMap;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyResults;
import jp.riken.brain.ni.samuraigraph.base.SGUndoManager;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.data.SGArrayData;
import jp.riken.brain.ni.samuraigraph.data.SGDataUtility;
import jp.riken.brain.ni.samuraigraph.data.SGIDataAnimation;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFData;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFDataColumnInfo;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFFile;
import jp.riken.brain.ni.samuraigraph.data.SGSXYMultipleData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYMultipleDimensionNetCDFData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYMultipleNetCDFData;
import jp.riken.brain.ni.samuraigraph.data.SGVariable;
import jp.riken.brain.ni.samuraigraph.figure.SGElementGroup;
import jp.riken.brain.ni.samuraigraph.figure.SGElementGroupSet;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIDataPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIElementGroupSetInFigureElement;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SGElementGroupSetInFigureElement
extends SGElementGroupSet
implements SGIElementGroupSetInFigureElement,
SGIUndoable,
SGIDataPropertyDialogObserver,
SGIConstants,
SGIDataAnimation,
ActionListener {
    protected SGData mData = null;
    protected String mName = null;
    protected boolean mVisibleInLegendFlag = true;
    protected boolean mSelectedFlag = false;
    protected SGAxis mXAxis = null;
    protected SGAxis mYAxis = null;
    protected SGAxis mZAxis = null;
    protected Map<Integer, String> mLabelStringList = new HashMap<Integer, String>();
    private int mID;
    protected JPopupMenu mPopupMenu = null;
    private SGUndoManager mUndoManager = new SGUndoManager(this);
    protected SGProperties mTempDataProperties = null;

    public SGElementGroupSetInFigureElement(SGData sGData) {
        this.mData = sGData;
    }

    @Override
    public SGData getData() {
        return this.mData;
    }

    @Override
    public int getID() {
        return this.mID;
    }

    @Override
    public boolean setID(int n) {
        this.mID = n;
        return true;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.mPopupMenu = null;
        this.mName = null;
        this.mUndoManager.dispose();
        this.mUndoManager = null;
        this.mXAxis = null;
        this.mYAxis = null;
        this.mZAxis = null;
    }

    @Override
    public boolean setName(String string) {
        this.mName = string;
        return true;
    }

    @Override
    public boolean setVisibleInLegend(boolean bl) {
        this.mVisibleInLegendFlag = bl;
        return true;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    public boolean isVisibleInLegend() {
        return this.mVisibleInLegendFlag;
    }

    public boolean isSelected() {
        return this.mSelectedFlag;
    }

    public void setSelected(boolean bl) {
        this.mSelectedFlag = bl;
    }

    @Override
    public boolean setXAxis(SGAxis sGAxis) {
        this.mXAxis = sGAxis;
        return true;
    }

    @Override
    public boolean setYAxis(SGAxis sGAxis) {
        this.mYAxis = sGAxis;
        return true;
    }

    public boolean setZAxis(SGAxis sGAxis) {
        this.mZAxis = sGAxis;
        return true;
    }

    @Override
    public SGAxis getXAxis() {
        return this.mXAxis;
    }

    @Override
    public SGAxis getYAxis() {
        return this.mYAxis;
    }

    public SGAxis getZAxis() {
        return this.mZAxis;
    }

    @Override
    public abstract boolean setXAxisLocation(int var1);

    @Override
    public abstract boolean setYAxisLocation(int var1);

    public JPopupMenu getPopupMenu() {
        JPopupMenu jPopupMenu = null;
        if (this.mPopupMenu != null) {
            jPopupMenu = this.mPopupMenu;
        } else {
            this.mPopupMenu = jPopupMenu = this.createGroupSetPopupMenu();
        }
        return jPopupMenu;
    }

    protected JPopupMenu createGroupSetPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.setBounds(0, 0, 100, 100);
        jPopupMenu.add(new JLabel(this.getPopupMenuTitle()));
        jPopupMenu.addSeparator();
        List<List<PopupMenuItem>> list = this.getCommands();
        for (int i = 0; i < list.size(); ++i) {
            List<PopupMenuItem> list2 = list.get(i);
            this.addCommands(jPopupMenu, list2);
            if (list2.size() == 0 || i == list.size() - 1) continue;
            jPopupMenu.addSeparator();
        }
        return jPopupMenu;
    }

    protected List<List<PopupMenuItem>> getCommands() {
        ArrayList<List<PopupMenuItem>> arrayList = new ArrayList<List<PopupMenuItem>>();
        arrayList.add(this.convertCommandToPopupMenuItem(this.getMoveCommandList()));
        arrayList.add(this.convertCommandToPopupMenuItem(this.getEditCommandList()));
        if (SGDataUtility.isNetCDFData(this.getData())) {
            arrayList.add(this.convertCommandToPopupMenuItem(this.getNetCDFCommandList()));
        }
        arrayList.add(this.getOptionalCommandList());
        arrayList.add(this.convertCommandToPopupMenuItem(this.getPropertyCommandList()));
        return arrayList;
    }

    private List<PopupMenuItem> convertCommandToPopupMenuItem(List<String> list) {
        ArrayList<PopupMenuItem> arrayList = new ArrayList<PopupMenuItem>();
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(new PopupMenuItem(list.get(i), true));
        }
        return arrayList;
    }

    private void addCommands(JPopupMenu jPopupMenu, List<PopupMenuItem> list) {
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get((int)i).mItemString;
            boolean bl = list.get((int)i).mItemEnabled;
            SGUtility.addItem(jPopupMenu, this, string, bl);
        }
    }

    protected abstract List<String> getMoveCommandList();

    protected List<String> getEditCommandList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Cut");
        arrayList.add("Copy");
        arrayList.add("Duplicate");
        arrayList.add("Delete");
        return arrayList;
    }

    protected List<String> getNetCDFCommandList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Insert Label of Fixed Values");
        arrayList.add("Play Animation");
        return arrayList;
    }

    protected List<PopupMenuItem> getOptionalCommandList() {
        ArrayList<PopupMenuItem> arrayList = new ArrayList<PopupMenuItem>();
        arrayList.add(new PopupMenuItem("Fit axes", true));
        arrayList.add(new PopupMenuItem("Transform", true));
        return arrayList;
    }

    protected List<PopupMenuItem> getPluginsCommandList() {
        ArrayList<PopupMenuItem> arrayList = new ArrayList<PopupMenuItem>();
        SGPluginsQueryMessage sGPluginsQueryMessage = new SGPluginsQueryMessage("OutputToFileIsEnabled");
        this.notifyToListener("OutputToFileIsEnabled", sGPluginsQueryMessage);
        boolean bl = false;
        Object object = sGPluginsQueryMessage.get();
        if (object instanceof Boolean) {
            bl = (Boolean)object;
        }
        arrayList.add(new PopupMenuItem("Output to File", bl));
        return arrayList;
    }

    protected List<String> getPropertyCommandList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Property");
        return arrayList;
    }

    protected String getPopupMenuTitle() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  -- Data: ");
        stringBuffer.append(this.getID());
        stringBuffer.append(" ");
        stringBuffer.append(SGUtility.removeEscapeChar(this.mName));
        stringBuffer.append(" --");
        return stringBuffer.toString();
    }

    public List<Boolean> getVisibleFlagList() {
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
        for (int i = 0; i < this.mDrawingElementGroupList.size(); ++i) {
            SGElementGroup sGElementGroup = (SGElementGroup)this.mDrawingElementGroupList.get(i);
            boolean bl = sGElementGroup.isVisible();
            arrayList.add(bl);
        }
        return arrayList;
    }

    @Override
    public boolean onDrawingElement(int n, int n2) {
        for (int i = 0; i < this.mDrawingElementGroupList.size(); ++i) {
            SGElementGroup sGElementGroup = (SGElementGroup)this.mDrawingElementGroupList.get(i);
            SGDrawingElement[] sGDrawingElementArray = sGElementGroup.getDrawingElementArray();
            for (int j = 0; j < sGDrawingElementArray.length; ++j) {
                if (!sGDrawingElementArray[j].contains(n, n2)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean writeProperty(Element element, int n) {
        element.setAttribute("Name", this.mName);
        element.setAttribute("VisibleInLegend", Boolean.toString(this.mVisibleInLegendFlag));
        switch (n) {
            case 1: {
                SGData sGData = this.getData();
                if (sGData instanceof SGSXYMultipleData) {
                    ((SGSXYMultipleData)sGData).writeSamplingRateToProperty(element);
                }
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                SGData sGData = this.getData();
                if (sGData.writeProperty(element, n)) break;
                return false;
            }
        }
        return true;
    }

    @Override
    public SGProperties getProperties() {
        ElementGroupSetPropertiesInFigureElement elementGroupSetPropertiesInFigureElement = new ElementGroupSetPropertiesInFigureElement();
        if (!this.getProperties(elementGroupSetPropertiesInFigureElement)) {
            return null;
        }
        return elementGroupSetPropertiesInFigureElement;
    }

    @Override
    public boolean getProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof ElementGroupSetPropertiesInFigureElement)) {
            return false;
        }
        if (!super.getProperties(sGProperties)) {
            return false;
        }
        ElementGroupSetPropertiesInFigureElement elementGroupSetPropertiesInFigureElement = (ElementGroupSetPropertiesInFigureElement)sGProperties;
        elementGroupSetPropertiesInFigureElement.name = this.mName;
        elementGroupSetPropertiesInFigureElement.visibleInLegend = this.mVisibleInLegendFlag;
        elementGroupSetPropertiesInFigureElement.dataProperties = (SGData.DataProperties)this.getDataProperties();
        elementGroupSetPropertiesInFigureElement.labelStringList.clear();
        elementGroupSetPropertiesInFigureElement.labelStringList.putAll(this.mLabelStringList);
        return true;
    }

    @Override
    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof ElementGroupSetPropertiesInFigureElement)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        ElementGroupSetPropertiesInFigureElement elementGroupSetPropertiesInFigureElement = (ElementGroupSetPropertiesInFigureElement)sGProperties;
        this.setName(elementGroupSetPropertiesInFigureElement.name);
        this.setVisibleInLegend(elementGroupSetPropertiesInFigureElement.visibleInLegend);
        this.setDataProperties(elementGroupSetPropertiesInFigureElement.dataProperties);
        this.mLabelStringList.clear();
        this.mLabelStringList.putAll(elementGroupSetPropertiesInFigureElement.labelStringList);
        return true;
    }

    public boolean setDataProperties(SGProperties sGProperties) {
        SGData sGData = this.getData();
        if (sGData != null) {
            return sGData.setProperties(sGProperties);
        }
        return false;
    }

    @Override
    public SGProperties getDataProperties() {
        SGData sGData = this.getData();
        if (sGData != null) {
            return sGData.getProperties();
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[name=");
        stringBuffer.append(this.mName);
        stringBuffer.append(", ");
        stringBuffer.append(super.toString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    @Override
    public boolean isChanged() {
        return this.mUndoManager.isChanged();
    }

    @Override
    public void setChanged(boolean bl) {
        this.mUndoManager.setChanged(bl);
    }

    @Override
    public boolean isChangedRoot() {
        return this.isChanged();
    }

    @Override
    public SGProperties getMemento() {
        return this.getProperties();
    }

    @Override
    public boolean setMemento(SGProperties sGProperties) {
        return this.setProperties(sGProperties);
    }

    @Override
    public boolean isUndoable() {
        return this.mUndoManager.isUndoable();
    }

    @Override
    public boolean isRedoable() {
        return this.mUndoManager.isRedoable();
    }

    @Override
    public boolean setMementoBackward() {
        if (!this.mUndoManager.setMementoBackward()) {
            return false;
        }
        return this.synchronizeDataOnUndo();
    }

    @Override
    public boolean setMementoForward() {
        if (!this.mUndoManager.setMementoForward()) {
            return false;
        }
        return this.synchronizeDataOnUndo();
    }

    private boolean synchronizeDataOnUndo() {
        SGData sGData = this.getData();
        ElementGroupSetPropertiesInFigureElement elementGroupSetPropertiesInFigureElement = (ElementGroupSetPropertiesInFigureElement)this.getProperties();
        return sGData.setProperties(elementGroupSetPropertiesInFigureElement.dataProperties);
    }

    @Override
    public boolean undo() {
        return this.setMementoBackward();
    }

    @Override
    public boolean redo() {
        return this.setMementoForward();
    }

    @Override
    public boolean updateHistory() {
        return this.mUndoManager.updateHistory();
    }

    @Override
    public void initUndoBuffer() {
        this.mUndoManager.initUndoBuffer();
    }

    @Override
    public boolean initPropertiesHistory() {
        return this.mUndoManager.initPropertiesHistory();
    }

    @Override
    public boolean deleteForwardHistory() {
        return this.mUndoManager.deleteForwardHistory();
    }

    @Override
    public void clearChanged() {
        this.setChanged(false);
    }

    public String[] getTitleArray() {
        SGData sGData = this.getData();
        if (!(sGData instanceof SGArrayData)) {
            throw new Error("Data is not of array type.");
        }
        SGArrayData sGArrayData = (SGArrayData)sGData;
        return sGArrayData.getTitles();
    }

    @Override
    public Map<String, Object> getInfoMap() {
        return this.getData().getInfoMap();
    }

    public String[] getValueTypeArray() {
        SGData sGData = this.getData();
        if (!(sGData instanceof SGArrayData)) {
            throw new Error("Data is not of array type.");
        }
        SGArrayData sGArrayData = (SGArrayData)sGData;
        String[] stringArray = sGArrayData.getValueTypes();
        return stringArray;
    }

    @Override
    public boolean setColumnInfo(SGDataColumnInfo[] sGDataColumnInfoArray, String string) {
        SGData sGData = this.getData();
        return sGData.setColumnInfo(sGDataColumnInfoArray);
    }

    @Override
    public String getDataType() {
        return this.getData().getDataType();
    }

    @Override
    public SGDataColumnInfo[] getDataColumnInfoArray() {
        SGData sGData = this.getData();
        SGDataColumnInfo[] sGDataColumnInfoArray = null;
        if (sGData instanceof SGArrayData) {
            SGArrayData sGArrayData = (SGArrayData)sGData;
            int n = sGArrayData.getColNum();
            String[] stringArray = sGArrayData.getTitles();
            String[] stringArray2 = this.getValueTypeArray();
            String[] stringArray3 = sGArrayData.getCurrentColumnType();
            sGDataColumnInfoArray = new SGDataColumnInfo[n];
            for (int i = 0; i < n; ++i) {
                sGDataColumnInfoArray[i] = new SGDataColumnInfo(stringArray[i], stringArray2[i]);
                sGDataColumnInfoArray[i].setColumnType(stringArray3[i]);
            }
        } else if (sGData instanceof SGNetCDFData) {
            SGNetCDFData sGNetCDFData = (SGNetCDFData)sGData;
            SGNetCDFFile sGNetCDFFile = sGNetCDFData.getNetcdfFile();
            List<SGVariable> list = sGNetCDFFile.getVariables();
            int n = list.size();
            sGDataColumnInfoArray = new SGNetCDFDataColumnInfo[n];
            String[] stringArray = sGNetCDFData.getCurrentColumnType();
            for (int i = 0; i < n; ++i) {
                SGVariable sGVariable = list.get(i);
                String string = sGVariable.getName();
                int n2 = sGVariable.isCoordinateVariable() ? sGNetCDFData.getOrigin(string) : 0;
                sGDataColumnInfoArray[i] = new SGNetCDFDataColumnInfo(sGVariable, sGVariable.getNameInPriorityOrder(), sGVariable.getValueType(), n2);
                sGDataColumnInfoArray[i].setColumnType(stringArray[i]);
            }
        } else {
            throw new Error("Data type is not supported: " + sGData.getDataType());
        }
        return sGDataColumnInfoArray;
    }

    @Override
    public SGIFigureElementForData.DataLabel getDataLabel() {
        Object object;
        SGData sGData = this.getData();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        if (sGData instanceof SGNetCDFData) {
            object = (SGNetCDFData)sGData;
            SGNetCDFFile sGNetCDFFile = ((SGNetCDFData)object).getNetcdfFile();
            List<SGVariable> list = sGNetCDFFile.getVariables();
            int n3 = list.size();
            boolean bl2 = true;
            for (int i = 0; i < n3; ++i) {
                double d;
                String string;
                SGVariable sGVariable = list.get(i);
                if (!sGVariable.isCoordinateVariable() || !((SGNetCDFData)object).isFixedCoordinateVariable(string = sGVariable.getName())) continue;
                int n4 = -1;
                if (!(sGData instanceof SGSXYMultipleDimensionNetCDFData)) {
                    n4 = ((SGNetCDFData)object).getOrigin(string);
                } else {
                    SGSXYMultipleDimensionNetCDFData sGSXYMultipleDimensionNetCDFData = (SGSXYMultipleDimensionNetCDFData)object;
                    if (!SGDataUtility.isSameNetCDFGroup(string, sGSXYMultipleDimensionNetCDFData.getDimensionName())) continue;
                    n4 = string.equals(sGSXYMultipleDimensionNetCDFData.getDimensionName()) ? sGSXYMultipleDimensionNetCDFData.getDimensionStart() : ((SGNetCDFData)object).getOrigin(string);
                }
                if (n4 == -1) continue;
                try {
                    d = ((SGNetCDFData)object).getCoordinateValue(string, n4);
                }
                catch (IOException iOException) {
                    return null;
                }
                bl = true;
                String string2 = sGVariable.getUnitsString();
                String string3 = SGUtility.addEscapeChar(sGVariable.getIdentifiableNameInPriorityOrder());
                String string4 = null;
                if (string2 != null) {
                    string4 = SGUtility.addEscapeChar(string2);
                }
                if (!bl2) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(string3);
                stringBuffer.append('=');
                stringBuffer.append(d);
                if (string4 != null) {
                    stringBuffer.append('[');
                    stringBuffer.append(string4);
                    stringBuffer.append(']');
                }
                bl2 = false;
            }
        } else {
            return null;
        }
        if (!bl) {
            return null;
        }
        object = new SGIFigureElementForData.DataLabel(stringBuffer.toString(), n, n2);
        return object;
    }

    public boolean addLabelStringId(int n, String string) {
        Integer n2 = n;
        String string2 = this.mLabelStringList.get(n2);
        if (string2 == null || !string2.equals(string)) {
            this.mLabelStringList.put(n, string);
            return true;
        }
        return false;
    }

    @Override
    public int getFrameNumber() {
        if (this.mData instanceof SGNetCDFData) {
            SGNetCDFData sGNetCDFData = (SGNetCDFData)this.mData;
            double[] dArray = sGNetCDFData.getTimeValueArray();
            if (dArray == null) {
                return -1;
            }
            return dArray.length;
        }
        throw new Error("Animation is not supported.");
    }

    @Override
    public int getCurrentFrameIndex() {
        if (this.mData instanceof SGNetCDFData) {
            SGNetCDFData sGNetCDFData = (SGNetCDFData)this.mData;
            return sGNetCDFData.getCurrentTimeValueIndex();
        }
        throw new Error("Animation is not supported.");
    }

    @Override
    public void setCurrentFrameIndex(int n) {
        if (!(this.mData instanceof SGNetCDFData)) {
            throw new Error("Animation is not supported.");
        }
        SGNetCDFData sGNetCDFData = (SGNetCDFData)this.mData;
        sGNetCDFData.setCurrentTimeValueIndex(n);
    }

    @Override
    public void saveChanges() {
        if (this.mData instanceof SGNetCDFData) {
            SGNetCDFData sGNetCDFData = (SGNetCDFData)this.mData;
            SGProperties sGProperties = sGNetCDFData.getProperties();
            if (!sGProperties.equals(this.mTempDataProperties)) {
                this.onSaveChanges();
            }
        } else {
            throw new Error("Animation is not supported.");
        }
        this.mTempDataProperties = null;
    }

    protected abstract void onSaveChanges();

    @Override
    public void cancelChanges() {
        if (!(this.mData instanceof SGNetCDFData)) {
            throw new Error("Animation is not supported.");
        }
        SGNetCDFData sGNetCDFData = (SGNetCDFData)this.mData;
        sGNetCDFData.setProperties(this.mTempDataProperties);
        this.updateWithData();
        this.mTempDataProperties = null;
    }

    @Override
    public String getDataSourceName() {
        SGNetCDFData sGNetCDFData = (SGNetCDFData)this.mData;
        SGVariable sGVariable = sGNetCDFData.getTimeVariable();
        if (sGVariable != null) {
            return sGVariable.getIdentifiableNameInPriorityOrder();
        }
        return null;
    }

    @Override
    public String getDataSourceUnitString() {
        SGNetCDFData sGNetCDFData = (SGNetCDFData)this.mData;
        SGVariable sGVariable = sGNetCDFData.getTimeVariable();
        if (sGVariable != null) {
            return sGVariable.getUnitsString();
        }
        return null;
    }

    @Override
    public Number getCurrentValue() {
        SGNetCDFData sGNetCDFData = (SGNetCDFData)this.mData;
        return sGNetCDFData.getCurrentTimeValue();
    }

    @Override
    public SGPropertyResults setProperties(SGPropertyMap sGPropertyMap) {
        SGPropertyResults sGPropertyResults = new SGPropertyResults();
        if (!this.prepare()) {
            return null;
        }
        if ((sGPropertyResults = this.setProperties(sGPropertyMap, sGPropertyResults)) == null) {
            return null;
        }
        if (!this.commit()) {
            return null;
        }
        this.notifyToRoot();
        return sGPropertyResults;
    }

    protected SGPropertyResults setProperties(SGPropertyMap sGPropertyMap, SGPropertyResults sGPropertyResults) {
        SGPropertyResults sGPropertyResults2 = (SGPropertyResults)sGPropertyResults.clone();
        Iterator<String> iterator = sGPropertyMap.getKeyIterator();
        while (iterator.hasNext()) {
            String[] stringArray;
            String[] stringArray2;
            String string = iterator.next();
            String string2 = sGPropertyMap.getValueString(string);
            if ("AxisX".equalsIgnoreCase(string)) {
                int n = SGUtility.getAxisLocation(string2);
                if (n == -1) {
                    sGPropertyResults2.putResult("AxisX", 1);
                    continue;
                }
                if (!this.setXAxisLocation(n)) {
                    sGPropertyResults2.putResult("AxisX", 1);
                    continue;
                }
                sGPropertyResults2.putResult("AxisX", 0);
                continue;
            }
            if ("AxisY".equalsIgnoreCase(string)) {
                int n = SGUtility.getAxisLocation(string2);
                if (n == -1) {
                    sGPropertyResults2.putResult("AxisY", 1);
                    continue;
                }
                if (!this.setYAxisLocation(n)) {
                    sGPropertyResults2.putResult("AxisY", 1);
                    continue;
                }
                sGPropertyResults2.putResult("AxisY", 0);
                continue;
            }
            if ("VisibleInLegend".equalsIgnoreCase(string)) {
                Boolean bl = SGUtilityText.getBoolean(string2);
                if (bl == null) {
                    sGPropertyResults2.putResult("VisibleInLegend", 1);
                    continue;
                }
                if (!this.setVisibleInLegend(bl)) {
                    sGPropertyResults2.putResult("VisibleInLegend", 1);
                    continue;
                }
                sGPropertyResults2.putResult("VisibleInLegend", 0);
                continue;
            }
            if ("Name".equalsIgnoreCase(string)) {
                if (!sGPropertyMap.isDoubleQuoted(string)) {
                    sGPropertyResults2.putResult("Name", 1);
                    continue;
                }
                String string3 = SGUtility.createDataNameBase(string2);
                if (string3 == null) {
                    sGPropertyResults2.putResult("Name", 1);
                    continue;
                }
                if (!this.setName(string3)) {
                    sGPropertyResults2.putResult("Name", 1);
                    continue;
                }
                sGPropertyResults2.putResult("Name", 0);
                continue;
            }
            if ("ColumnType".equalsIgnoreCase(string)) {
                Object object;
                Object object2;
                int n;
                int n2;
                String[] stringArray3 = SGUtilityText.getStringsInBracket(string2);
                if (stringArray3 == null) {
                    sGPropertyResults2.putResult("ColumnType", 1);
                    continue;
                }
                if (stringArray3.length == 0) {
                    sGPropertyResults2.putResult("ColumnType", 1);
                    continue;
                }
                boolean bl = true;
                stringArray2 = new String[stringArray3.length];
                stringArray = new String[stringArray3.length];
                for (n2 = 0; n2 < stringArray3.length; ++n2) {
                    n = stringArray3[n2].indexOf(58);
                    if (n == -1) {
                        bl = false;
                        break;
                    }
                    object2 = stringArray3[n2].substring(0, n);
                    object = stringArray3[n2].substring(n + 1);
                    stringArray2[n2] = ((String)object2).trim();
                    stringArray[n2] = ((String)object).trim();
                }
                if (!bl) {
                    sGPropertyResults2.putResult("ColumnType", 1);
                    continue;
                }
                block2: for (n2 = 0; n2 < stringArray2.length - 1; ++n2) {
                    for (n = n2 + 1; n < stringArray2.length; ++n) {
                        if (!stringArray2[n2].equals(stringArray2[n])) continue;
                        bl = false;
                        continue block2;
                    }
                }
                if (!bl) {
                    sGPropertyResults2.putResult("ColumnType", 1);
                    continue;
                }
                if (this.mData instanceof SGArrayData) {
                    int n3;
                    int n4;
                    SGArrayData sGArrayData = (SGArrayData)this.mData;
                    int[] nArray = new int[stringArray2.length];
                    for (n4 = 0; n4 < stringArray2.length; ++n4) {
                        object = SGUtilityText.getInteger(stringArray2[n4]);
                        if (object == null) {
                            bl = false;
                            break;
                        }
                        nArray[n4] = (Integer)object;
                    }
                    if (!bl) {
                        sGPropertyResults2.putResult("ColumnType", 1);
                        continue;
                    }
                    n4 = sGArrayData.getColNum();
                    object = new String[n4];
                    for (n3 = 0; n3 < ((Object)object).length; ++n3) {
                        object[n3] = "";
                    }
                    for (n3 = 0; n3 < nArray.length; ++n3) {
                        int n5 = nArray[n3] - 1;
                        if (n5 < 0 || n5 >= ((Object)object).length) {
                            bl = false;
                            break;
                        }
                        object[n5] = stringArray[n3];
                    }
                    if (!bl) {
                        sGPropertyResults2.putResult("ColumnType", 1);
                        continue;
                    }
                    if (!sGArrayData.setColumnType((String[])object)) {
                        sGPropertyResults2.putResult("ColumnType", 1);
                        continue;
                    }
                    if (!this.columnTypeChanged(sGArrayData)) {
                        sGPropertyResults2.putResult("ColumnType", 1);
                        continue;
                    }
                } else if (this.mData instanceof SGNetCDFData) {
                    int n6;
                    SGNetCDFData sGNetCDFData = (SGNetCDFData)this.mData;
                    SGNetCDFFile sGNetCDFFile = sGNetCDFData.getNetcdfFile();
                    object2 = sGNetCDFFile.getVariables();
                    object = new String[object2.size()];
                    for (n6 = 0; n6 < ((String[])object).length; ++n6) {
                        object[n6] = "";
                    }
                    for (n6 = 0; n6 < stringArray2.length; ++n6) {
                        int n7 = sGNetCDFFile.getVariableIndex(stringArray2[n6]);
                        if (n7 == -1) {
                            bl = false;
                            break;
                        }
                        object[n7] = stringArray[n6];
                    }
                    if (!bl) {
                        sGPropertyResults2.putResult("ColumnType", 1);
                        continue;
                    }
                    if (!sGNetCDFData.setColumnType((String[])object)) {
                        sGPropertyResults2.putResult("ColumnType", 1);
                        continue;
                    }
                    if (!this.columnTypeChanged(sGNetCDFData)) {
                        sGPropertyResults2.putResult("ColumnType", 1);
                        continue;
                    }
                }
                sGPropertyResults2.putResult("ColumnType", 0);
                continue;
            }
            if ("CoordinateVariablesIndex".equalsIgnoreCase(string)) {
                int n;
                if (!(this.mData instanceof SGNetCDFData)) {
                    sGPropertyResults2.putResult("CoordinateVariablesIndex", 1);
                    continue;
                }
                SGNetCDFData sGNetCDFData = (SGNetCDFData)this.mData;
                boolean bl = true;
                stringArray2 = SGUtilityText.getStringsInBracket(string2);
                if (stringArray2 == null) {
                    sGPropertyResults2.putResult("CoordinateVariablesIndex", 1);
                    continue;
                }
                if (stringArray2.length == 0) {
                    sGPropertyResults2.putResult("CoordinateVariablesIndex", 1);
                    continue;
                }
                stringArray = new String[stringArray2.length];
                int[] nArray = new int[stringArray2.length];
                for (n = 0; n < stringArray2.length; ++n) {
                    int n8 = stringArray2[n].indexOf(40);
                    if (n8 == -1) {
                        bl = false;
                        break;
                    }
                    int n9 = stringArray2[n].lastIndexOf(41);
                    if (n9 == -1) {
                        bl = false;
                        break;
                    }
                    String string4 = stringArray2[n].substring(0, n8);
                    String string5 = stringArray2[n].substring(n8 + 1, n9);
                    Integer n10 = SGUtilityText.getInteger(string5.trim());
                    if (n10 == null) {
                        bl = false;
                        break;
                    }
                    stringArray[n] = string4.trim();
                    nArray[n] = n10;
                }
                if (!bl) {
                    sGPropertyResults2.putResult("CoordinateVariablesIndex", 1);
                    continue;
                }
                for (n = 0; n < stringArray2.length; ++n) {
                    if (sGNetCDFData.setOrigin(stringArray[n], nArray[n])) continue;
                    bl = false;
                    break;
                }
                if (!bl) {
                    sGPropertyResults2.putResult("CoordinateVariablesIndex", 1);
                    continue;
                }
                sGPropertyResults2.putResult("CoordinateVariablesIndex", 0);
                continue;
            }
            if ("PickupStart".equalsIgnoreCase(string)) {
                if (!(this.mData instanceof SGSXYMultipleNetCDFData)) {
                    sGPropertyResults2.putResult("PickupStart", 1);
                    continue;
                }
                SGSXYMultipleNetCDFData sGSXYMultipleNetCDFData = (SGSXYMultipleNetCDFData)this.mData;
                Integer n = SGUtilityText.getInteger(string2);
                if (n == null) {
                    sGPropertyResults2.putResult("PickupStart", 1);
                    continue;
                }
                if (!sGSXYMultipleNetCDFData.setDimensionStart(n)) {
                    sGPropertyResults2.putResult("PickupStart", 1);
                    continue;
                }
                if (!this.columnTypeChanged(sGSXYMultipleNetCDFData)) {
                    sGPropertyResults2.putResult("PickupStart", 1);
                    continue;
                }
                sGPropertyResults2.putResult("PickupStart", 0);
                continue;
            }
            if ("PickupEnd".equalsIgnoreCase(string)) {
                if (!(this.mData instanceof SGSXYMultipleNetCDFData)) {
                    sGPropertyResults2.putResult("PickupEnd", 1);
                    continue;
                }
                SGSXYMultipleNetCDFData sGSXYMultipleNetCDFData = (SGSXYMultipleNetCDFData)this.mData;
                Integer n = SGUtilityText.getInteger(string2);
                if (n == null) {
                    sGPropertyResults2.putResult("PickupEnd", 1);
                    continue;
                }
                if (!sGSXYMultipleNetCDFData.setDimensionEnd(n)) {
                    sGPropertyResults2.putResult("PickupEnd", 1);
                    continue;
                }
                if (!this.columnTypeChanged(sGSXYMultipleNetCDFData)) {
                    sGPropertyResults2.putResult("PickupEnd", 1);
                    continue;
                }
                sGPropertyResults2.putResult("PickupEnd", 0);
                continue;
            }
            if (!"PickupStep".equalsIgnoreCase(string)) continue;
            if (!(this.mData instanceof SGSXYMultipleNetCDFData)) {
                sGPropertyResults2.putResult("PickupStep", 1);
                continue;
            }
            SGSXYMultipleNetCDFData sGSXYMultipleNetCDFData = (SGSXYMultipleNetCDFData)this.mData;
            Integer n = SGUtilityText.getInteger(string2);
            if (n == null) {
                sGPropertyResults2.putResult("PickupStep", 1);
                continue;
            }
            if (!sGSXYMultipleNetCDFData.setDimensionStep(n)) {
                sGPropertyResults2.putResult("PickupStep", 1);
                continue;
            }
            if (!this.columnTypeChanged(sGSXYMultipleNetCDFData)) {
                sGPropertyResults2.putResult("PickupStep", 1);
                continue;
            }
            sGPropertyResults2.putResult("PickupStep", 0);
        }
        return sGPropertyResults2;
    }

    protected void compareDataColumns(String string, SGProperties sGProperties) {
        SGProperties sGProperties2 = this.getProperties();
        ElementGroupSetPropertiesInFigureElement elementGroupSetPropertiesInFigureElement = (ElementGroupSetPropertiesInFigureElement)sGProperties;
        ElementGroupSetPropertiesInFigureElement elementGroupSetPropertiesInFigureElement2 = (ElementGroupSetPropertiesInFigureElement)sGProperties2;
        if (!elementGroupSetPropertiesInFigureElement.dataProperties.equals(elementGroupSetPropertiesInFigureElement2.dataProperties)) {
            boolean bl = this.isSelected();
            this.setSelected(true);
            this.notifyToListener(string);
            this.setSelected(bl);
        }
    }

    protected abstract void notifyToListener(String var1);

    protected abstract void notifyToListener(String var1, Object var2);

    @Override
    public boolean setData(SGData sGData) {
        this.mData = sGData;
        return true;
    }

    @Override
    public boolean contains(SGElementGroupSetInFigureElement sGElementGroupSetInFigureElement) {
        return this.equals(sGElementGroupSetInFigureElement);
    }

    protected abstract boolean columnTypeChanged(SGData var1);

    public static class MultipleElementGroupSetProperties
    extends ElementGroupSetPropertiesInFigureElement {
        protected List<SGProperties> mChildPropertyList = new ArrayList<SGProperties>();

        public Object copy() {
            Object object = super.copy();
            MultipleElementGroupSetProperties multipleElementGroupSetProperties = (MultipleElementGroupSetProperties)object;
            ArrayList<SGProperties> arrayList = new ArrayList<SGProperties>();
            for (int i = 0; i < this.mChildPropertyList.size(); ++i) {
                arrayList.add(this.mChildPropertyList.get(i));
            }
            multipleElementGroupSetProperties.mChildPropertyList = arrayList;
            return multipleElementGroupSetProperties;
        }

        public void dispose() {
            super.dispose();
            this.mChildPropertyList.clear();
        }

        public boolean equals(Object object) {
            if (!(object instanceof MultipleElementGroupSetProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            MultipleElementGroupSetProperties multipleElementGroupSetProperties = (MultipleElementGroupSetProperties)object;
            return ((Object)multipleElementGroupSetProperties.mChildPropertyList).equals(this.mChildPropertyList);
        }

        public String toString() {
            String string = super.toString();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[");
            stringBuffer.append(string);
            stringBuffer.append(", Child=");
            stringBuffer.append(this.mChildPropertyList);
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }

    public static class ElementGroupSetPropertiesInFigureElement
    extends SGElementGroupSet.ElementGroupSetProperties {
        String name;
        boolean visibleInLegend;
        int xAxis;
        int yAxis;
        SGData.DataProperties dataProperties;
        Map<Integer, String> labelStringList = new HashMap<Integer, String>();

        public boolean equals(Object object) {
            if (!(object instanceof ElementGroupSetPropertiesInFigureElement)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            ElementGroupSetPropertiesInFigureElement elementGroupSetPropertiesInFigureElement = (ElementGroupSetPropertiesInFigureElement)object;
            if (!elementGroupSetPropertiesInFigureElement.name.equals(this.name)) {
                return false;
            }
            if (elementGroupSetPropertiesInFigureElement.visibleInLegend != this.visibleInLegend) {
                return false;
            }
            if (elementGroupSetPropertiesInFigureElement.xAxis != this.xAxis) {
                return false;
            }
            if (elementGroupSetPropertiesInFigureElement.yAxis != this.yAxis) {
                return false;
            }
            if (!SGUtility.equals(elementGroupSetPropertiesInFigureElement.dataProperties, this.dataProperties)) {
                return false;
            }
            return ((Object)elementGroupSetPropertiesInFigureElement.labelStringList).equals(this.labelStringList);
        }

        public String toString() {
            String string = super.toString();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[");
            stringBuffer.append(string);
            stringBuffer.append(", name=");
            stringBuffer.append(this.name);
            stringBuffer.append(", visibleInLegend=");
            stringBuffer.append(this.visibleInLegend);
            stringBuffer.append(", data=");
            stringBuffer.append(this.dataProperties);
            stringBuffer.append(this.toStringLabelList());
            stringBuffer.append("]");
            return stringBuffer.toString();
        }

        public String toStringLabelList() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.labelStringList.size() > 0) {
                stringBuffer.append(", labelList=");
                for (Integer n : this.labelStringList.keySet()) {
                    stringBuffer.append("(" + n + "," + this.labelStringList.get(n) + ")");
                }
            }
            return stringBuffer.toString();
        }

        public Object copy() {
            Object object = super.copy();
            ElementGroupSetPropertiesInFigureElement elementGroupSetPropertiesInFigureElement = (ElementGroupSetPropertiesInFigureElement)object;
            if (this.dataProperties != null) {
                elementGroupSetPropertiesInFigureElement.dataProperties = (SGData.DataProperties)this.dataProperties.copy();
            }
            elementGroupSetPropertiesInFigureElement.labelStringList.clear();
            elementGroupSetPropertiesInFigureElement.labelStringList.putAll(this.labelStringList);
            return elementGroupSetPropertiesInFigureElement;
        }

        public void dispose() {
            super.dispose();
            if (this.dataProperties != null) {
                this.dataProperties.dispose();
                this.dataProperties = null;
            }
            this.labelStringList.clear();
            this.labelStringList = null;
            this.name = null;
        }
    }

    static class PopupMenuItem {
        final String mItemString;
        boolean mItemEnabled;

        PopupMenuItem(String string, boolean bl) {
            this.mItemString = string;
            this.mItemEnabled = bl;
        }

        public void setEnabled(boolean bl) {
            this.mItemEnabled = bl;
        }
    }
}

