/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGIChildObject;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIData;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementAxis;
import jp.riken.brain.ni.samuraigraph.base.SGINode;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGISelectable;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.data.SGDataTypeConstants;
import jp.riken.brain.ni.samuraigraph.data.SGISXYData;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSetInFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGFigureElementGraph;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIElementGroupInGraph;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIElementGroupSetMultipleSXY;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGISXYDataDialogObserver;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGMultipleSXYUtility;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SGElementGroupSetInGraph
extends SGElementGroupSetInFigureElement
implements SGIPropertyDialogObserver,
SGISelectable,
SGINode,
SGIChildObject,
SGIConstants {
    protected SGFigureElementGraph mGraph = null;
    private boolean mClipFlag = true;
    protected SGProperties mTemporaryProperties = null;

    @Override
    public boolean setXAxisLocation(int n) {
        if (n != 0 && n != 1) {
            return false;
        }
        this.mXAxis = this.mGraph.getAxisElement().getAxisInPlane(n);
        return true;
    }

    @Override
    public boolean setYAxisLocation(int n) {
        if (n != 2 && n != 3) {
            return false;
        }
        this.mYAxis = this.mGraph.getAxisElement().getAxisInPlane(n);
        return true;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.mPopupMenu = null;
        this.mTemporaryProperties = null;
        this.mGraph = null;
    }

    protected void setClipFlag(boolean bl) {
        this.mClipFlag = bl;
    }

    protected boolean getClipFlag() {
        return this.mClipFlag;
    }

    @Override
    public void setSelected(boolean bl) {
        super.setSelected(bl);
        ArrayList arrayList = new ArrayList(this.mDrawingElementGroupList);
        for (int i = 0; i < arrayList.size(); ++i) {
            SGIElementGroupInGraph sGIElementGroupInGraph = (SGIElementGroupInGraph)arrayList.get(i);
            sGIElementGroupInGraph.setFocused(bl);
        }
    }

    public SGElementGroupSetInGraph(SGData sGData, SGFigureElementGraph sGFigureElementGraph) {
        super(sGData);
        this.mGraph = sGFigureElementGraph;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Property")) {
            this.mGraph.setPropertiesOfSelectedObjects();
        } else if (string.equals("Play Animation")) {
            this.mTempDataProperties = this.mData.getProperties();
            this.mGraph.notifyToListener(string);
            this.mGraph.doAnimation(this);
        } else {
            this.mGraph.notifyToListener(string);
        }
    }

    protected boolean onMouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = mouseEvent.getClickCount();
        if (this.contains(n, n2)) {
            this.mGraph.updateFocusedObjectsList((SGISelectable)this, mouseEvent);
            this.mGraph.notifyDataSelection();
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && n3 == 2) {
                this.mGraph.setPropertiesOfSelectedObjects();
            } else if (SwingUtilities.isRightMouseButton(mouseEvent) && n3 == 1) {
                this.mGraph.showDataPopupMenu(this, n, n2);
            }
            return true;
        }
        return false;
    }

    protected boolean onMousePressed(MouseEvent mouseEvent) {
        return this.contains(mouseEvent.getX(), mouseEvent.getY());
    }

    @Override
    public boolean updateWithData() {
        return this.mGraph.updateAllDrawingElementsLocation();
    }

    @Override
    public boolean commit() {
        this.compareDataColumns("Data columns are changed on commit", this.mTemporaryProperties);
        SGProperties sGProperties = this.mTemporaryProperties;
        SGProperties sGProperties2 = this.getProperties();
        if (!sGProperties.equals(sGProperties2)) {
            this.setChanged(true);
        }
        this.mTemporaryProperties = null;
        if (!this.updateWithData()) {
            return false;
        }
        this.mGraph.repaint();
        this.mGraph.notifyChangeOnCommit();
        return true;
    }

    @Override
    public boolean cancel() {
        this.compareDataColumns("Data columns are changed on cancel", this.mTemporaryProperties);
        if (!this.setProperties(this.mTemporaryProperties)) {
            return false;
        }
        this.mTemporaryProperties = null;
        SGData sGData = this.getData();
        SGElementGroupSetInFigureElement.ElementGroupSetPropertiesInFigureElement elementGroupSetPropertiesInFigureElement = (SGElementGroupSetInFigureElement.ElementGroupSetPropertiesInFigureElement)this.getProperties();
        sGData.setProperties(elementGroupSetPropertiesInFigureElement.dataProperties);
        if (!this.updateWithData()) {
            return false;
        }
        this.mGraph.repaint();
        this.mGraph.notifyChange();
        return true;
    }

    @Override
    public boolean preview() {
        this.compareDataColumns("Data columns are changed on preview", this.mTemporaryProperties);
        if (!this.updateWithData()) {
            return false;
        }
        this.mGraph.repaint();
        this.mGraph.notifyChange();
        return true;
    }

    @Override
    protected void notifyToListener(String string) {
        this.mGraph.notifyToListener(string);
    }

    @Override
    protected void notifyToListener(String string, Object object) {
        this.mGraph.notifyToListener(string, object);
    }

    @Override
    public ArrayList getChildNodes() {
        return new ArrayList();
    }

    @Override
    public boolean getProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof SGElementGroupSetInFigureElement.ElementGroupSetPropertiesInFigureElement)) {
            return false;
        }
        if (!super.getProperties(sGProperties)) {
            return false;
        }
        SGElementGroupSetInFigureElement.ElementGroupSetPropertiesInFigureElement elementGroupSetPropertiesInFigureElement = (SGElementGroupSetInFigureElement.ElementGroupSetPropertiesInFigureElement)sGProperties;
        SGIFigureElementAxis sGIFigureElementAxis = this.mGraph.getAxisElement();
        elementGroupSetPropertiesInFigureElement.xAxis = sGIFigureElementAxis.getLocationInPlane(this.getXAxis());
        elementGroupSetPropertiesInFigureElement.yAxis = sGIFigureElementAxis.getLocationInPlane(this.getYAxis());
        return true;
    }

    @Override
    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof SGElementGroupSetInFigureElement.ElementGroupSetPropertiesInFigureElement)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        SGElementGroupSetInFigureElement.ElementGroupSetPropertiesInFigureElement elementGroupSetPropertiesInFigureElement = (SGElementGroupSetInFigureElement.ElementGroupSetPropertiesInFigureElement)sGProperties;
        SGIFigureElementAxis sGIFigureElementAxis = this.mGraph.getAxisElement();
        this.setXAxis(sGIFigureElementAxis.getAxisInPlane(elementGroupSetPropertiesInFigureElement.xAxis));
        this.setYAxis(sGIFigureElementAxis.getAxisInPlane(elementGroupSetPropertiesInFigureElement.yAxis));
        return true;
    }

    @Override
    public String getInstanceDescription() {
        String string = this.getDataType();
        String string2 = SGDataTypeConstants.getLongDataTypeConstant(string);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getID());
        stringBuffer.append(": ");
        stringBuffer.append(string2);
        stringBuffer.append(": ");
        stringBuffer.append(SGUtility.removeEscapeChar(this.mName));
        return stringBuffer.toString();
    }

    @Override
    public boolean writeProperty(Element element, int n) {
        if (!super.writeProperty(element, n)) {
            return false;
        }
        SGData sGData = this.getData();
        element.setAttribute("Type", sGData.getDataType(n));
        return true;
    }

    @Override
    public String getTagName() {
        return "Data";
    }

    protected abstract boolean updateDrawingElementsLocation(SGIData var1);

    @Override
    public boolean setMementoBackward() {
        if (!super.setMementoBackward()) {
            return false;
        }
        this.mGraph.updateAllDrawingElementsLocation();
        this.mGraph.notifyChangeOnUndo();
        return true;
    }

    @Override
    public boolean setMementoForward() {
        if (!super.setMementoForward()) {
            return false;
        }
        this.mGraph.updateAllDrawingElementsLocation();
        this.mGraph.notifyChangeOnUndo();
        return true;
    }

    @Override
    public void notifyToRoot() {
        this.mGraph.notifyToRoot();
    }

    @Override
    public SGPropertyDialog getPropertyDialog() {
        SGData sGData = this.mGraph.getData(this);
        SGPropertyDialog sGPropertyDialog = this.mGraph.getDataDialog(sGData);
        return sGPropertyDialog;
    }

    @Override
    public boolean setName(String string) {
        if (!super.setName(string)) {
            return false;
        }
        JPopupMenu jPopupMenu = this.getPopupMenu();
        if (jPopupMenu != null) {
            Component[] componentArray = jPopupMenu.getComponents();
            JLabel jLabel = (JLabel)componentArray[0];
            jLabel.setText(this.getPopupMenuTitle());
        }
        return true;
    }

    @Override
    public void setCurrentFrameIndex(int n) {
        super.setCurrentFrameIndex(n);
        this.updateDrawingElementsLocation(this.mData);
        this.mGraph.repaint();
    }

    @Override
    protected void onSaveChanges() {
        this.setChanged(true);
        this.mGraph.notifyChangeOnCommit();
        this.notifyToRoot();
        this.updateWithData();
        this.mGraph.repaint();
    }

    @Override
    public void cancelChanges() {
        super.cancelChanges();
        this.mGraph.repaint();
    }

    @Override
    protected List<String> getMoveCommandList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Bring to Front");
        arrayList.add("Bring Forward");
        arrayList.add("Send Backward");
        arrayList.add("Send to Back");
        return arrayList;
    }

    @Override
    protected boolean columnTypeChanged(SGData sGData) {
        SGElementGroupSetInFigureElement sGElementGroupSetInFigureElement;
        Boolean bl;
        if (sGData instanceof SGISXYData && (bl = ((SGISXYData)((Object)sGData)).isErrorBarVertical()) != null && (sGElementGroupSetInFigureElement = this.mGraph.getElementGroupSet(sGData)) instanceof SGISXYDataDialogObserver) {
            ((SGISXYDataDialogObserver)((Object)sGElementGroupSetInFigureElement)).setErrorBarVertical(bl);
        }
        return !(this instanceof SGIElementGroupSetMultipleSXY) || SGMultipleSXYUtility.setColumnInfo((SGIElementGroupSetMultipleSXY)((Object)this), this.mGraph);
    }
}

