/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDataColumnInfo;
import jp.riken.brain.ni.samuraigraph.base.SGIData;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyMap;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyResults;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.data.SGDataUtility;
import jp.riken.brain.ni.samuraigraph.data.SGIVXYTypeData;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFData;
import jp.riken.brain.ni.samuraigraph.figure.SGElementGroup;
import jp.riken.brain.ni.samuraigraph.figure.SGIArrowConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGUtilityForFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGArrowUtility;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupArrow;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupArrowForData;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupArrowInGraph;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSetInFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSetInGraph;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGFigureElementGraph;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIElementGroupInGraph;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIElementGroupSetVXY;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIVXYDataDialogObserver;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGElementGroupSetInGraphVXY
extends SGElementGroupSetInGraph
implements SGIElementGroupSetVXY,
SGIVXYDataDialogObserver,
SGIArrowConstants {
    protected SGTuple2f[] mStartPointsArray = null;
    protected float[] mXArray = null;
    protected float[] mYArray = null;
    protected SGTuple2f[] mEndPointsArray = null;
    private float mMagnitudePerCM = 1.0f;
    private boolean mDirectionFixedFlag;

    protected SGElementGroupSetInGraphVXY(SGData sGData, SGFigureElementGraph sGFigureElementGraph) {
        super(sGData, sGFigureElementGraph);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.mStartPointsArray = null;
        this.mEndPointsArray = null;
        this.mXArray = null;
        this.mYArray = null;
    }

    protected void initPointsArray(int n) {
        SGTuple2f[] sGTuple2fArray = new SGTuple2f[n];
        SGTuple2f[] sGTuple2fArray2 = new SGTuple2f[n];
        for (int i = 0; i < n; ++i) {
            sGTuple2fArray[i] = new SGTuple2f();
            sGTuple2fArray2[i] = new SGTuple2f();
        }
        this.mStartPointsArray = sGTuple2fArray;
        this.mEndPointsArray = sGTuple2fArray2;
    }

    protected void initPointsArray(int n, int n2) {
        this.mXArray = new float[n];
        this.mYArray = new float[n2];
        int n3 = n * n2;
        this.mEndPointsArray = new SGTuple2f[n3];
        for (int i = 0; i < n3; ++i) {
            this.mEndPointsArray[i] = new SGTuple2f();
        }
    }

    @Override
    public float getMagnitudePerCM() {
        return this.mMagnitudePerCM;
    }

    @Override
    public boolean setMagnitudePerCM(float f) {
        if ((double)f <= 0.0) {
            return false;
        }
        SGIVXYTypeData sGIVXYTypeData = (SGIVXYTypeData)((Object)this.mData);
        this.mMagnitudePerCM = SGUtilityForFigureElement.roundMagnitudePerCM(f, sGIVXYTypeData);
        this.updateDrawingElementsLocation(this.mGraph.getData(this));
        return true;
    }

    @Override
    public String getClassDescription() {
        return "";
    }

    protected boolean createDrawingElements() {
        return true;
    }

    @Override
    public boolean addDrawingElementGroup(int n) {
        SGElementGroupArrowInGraph sGElementGroupArrowInGraph = null;
        if (n != 3) {
            return false;
        }
        sGElementGroupArrowInGraph = new SGElementGroupArrowInGraph(this.mGraph);
        sGElementGroupArrowInGraph.setGridMode(this.isGridMode());
        this.addElementGroup(sGElementGroupArrowInGraph);
        return true;
    }

    private boolean addElementGroup(SGElementGroupArrow sGElementGroupArrow) {
        SGIElementGroupInGraph sGIElementGroupInGraph = (SGIElementGroupInGraph)((Object)sGElementGroupArrow);
        sGIElementGroupInGraph.setElementGroupSet(this);
        if (!sGElementGroupArrow.initDrawingElement(this.mStartPointsArray, this.mEndPointsArray)) {
            throw new Error();
        }
        this.mDrawingElementGroupList.add(sGElementGroupArrow);
        return true;
    }

    @Override
    public boolean isDirectionInvariant() {
        return this.mDirectionFixedFlag;
    }

    @Override
    public boolean setDirectionInvariant(boolean bl) {
        this.mDirectionFixedFlag = bl;
        return true;
    }

    @Override
    public boolean updateDrawingElementsLocation(SGIData sGIData) {
        if (!(sGIData instanceof SGIVXYTypeData)) {
            return false;
        }
        SGIVXYTypeData sGIVXYTypeData = (SGIVXYTypeData)sGIData;
        if (this.isGridMode()) {
            double[] dArray = sGIVXYTypeData.getXCoordinateArray();
            double[] dArray2 = sGIVXYTypeData.getYCoordinateArray();
            this.initPointsArray(dArray.length, dArray2.length);
            if (!this.mGraph.calcLocationOfPoints(dArray, this.getXAxis(), true, this.mXArray)) {
                return false;
            }
            if (!this.mGraph.calcLocationOfPoints(dArray2, this.getYAxis(), false, this.mYArray)) {
                return false;
            }
            List list = this.mDrawingElementGroupList;
            for (int i = 0; i < list.size(); ++i) {
                SGElementGroupArrow sGElementGroupArrow;
                SGElementGroup sGElementGroup = (SGElementGroup)list.get(i);
                if (!sGElementGroup.isVisible() || !(sGElementGroup instanceof SGElementGroupArrow) || (sGElementGroupArrow = (SGElementGroupArrow)sGElementGroup).setLocation(this.mXArray, this.mYArray)) continue;
                return false;
            }
        } else {
            int n = sGIVXYTypeData.getPointsNumber();
            this.initPointsArray(n);
            SGAxis sGAxis = this.getXAxis();
            SGAxis sGAxis2 = this.getYAxis();
            if (!this.mGraph.calcLocationOfPoints(sGIVXYTypeData.getCoordinateArray(), sGAxis, sGAxis2, this.mStartPointsArray)) {
                return false;
            }
            if (!SGArrowUtility.calcEndLocation(sGIVXYTypeData, this.mGraph, this, this.getMagnitudePerCM(), this.isDirectionInvariant(), null, null, this.mStartPointsArray, this.mEndPointsArray)) {
                return false;
            }
            for (int i = 0; i < this.mDrawingElementGroupList.size(); ++i) {
                SGElementGroup sGElementGroup = (SGElementGroup)this.mDrawingElementGroupList.get(i);
                if (!sGElementGroup.isVisible() || !(sGElementGroup instanceof SGElementGroupArrowInGraph)) continue;
                SGElementGroupArrowInGraph sGElementGroupArrowInGraph = (SGElementGroupArrowInGraph)sGElementGroup;
                sGElementGroupArrowInGraph.setLocation(this.mStartPointsArray, this.mEndPointsArray);
            }
        }
        return true;
    }

    @Override
    public void paintGraphics2D(Graphics2D graphics2D) {
        Rectangle2D rectangle2D = null;
        if (!this.getClipFlag()) {
            rectangle2D = this.mGraph.getGraphRect();
        }
        List list = this.mDrawingElementGroupList;
        for (int i = 0; i < list.size(); ++i) {
            SGElementGroupArrowInGraph sGElementGroupArrowInGraph = (SGElementGroupArrowInGraph)list.get(i);
            if (!sGElementGroupArrowInGraph.isVisible()) continue;
            sGElementGroupArrowInGraph.paintElement(graphics2D, rectangle2D);
        }
    }

    @Override
    public boolean getLegendVisibleFlag() {
        return this.isVisibleInLegend();
    }

    @Override
    public int getXAxisLocation() {
        return this.mGraph.getAxisElement().getLocationInPlane(this.getXAxis());
    }

    @Override
    public int getYAxisLocation() {
        return this.mGraph.getAxisElement().getLocationInPlane(this.getYAxis());
    }

    @Override
    public boolean prepare() {
        this.mTemporaryProperties = this.getProperties();
        return true;
    }

    @Override
    public boolean writeProperty(Element element, int n) {
        if (!super.writeProperty(element, n)) {
            return false;
        }
        String string = this.mGraph.getAxisElement().getLocationName(this.getXAxis());
        String string2 = this.mGraph.getAxisElement().getLocationName(this.getYAxis());
        element.setAttribute("XAxisPosition", string);
        element.setAttribute("YAxisPosition", string2);
        SGIVXYTypeData sGIVXYTypeData = (SGIVXYTypeData)((Object)this.mGraph.getData(this));
        boolean bl = sGIVXYTypeData.isPolar();
        element.setAttribute("Polar", Boolean.toString(bl));
        float f = this.getMagnitudePerCM();
        element.setAttribute("MagnitudePerCM", Float.toString(f));
        boolean bl2 = this.isDirectionInvariant();
        element.setAttribute("DirectionInvariant", Boolean.toString(bl2));
        return true;
    }

    @Override
    public SGProperties getProperties() {
        ElementGroupSetInVXYGraphProperties elementGroupSetInVXYGraphProperties = new ElementGroupSetInVXYGraphProperties();
        if (!this.getProperties(elementGroupSetInVXYGraphProperties)) {
            return null;
        }
        return elementGroupSetInVXYGraphProperties;
    }

    @Override
    public boolean getProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof ElementGroupSetInVXYGraphProperties)) {
            return false;
        }
        if (!super.getProperties(sGProperties)) {
            return false;
        }
        ElementGroupSetInVXYGraphProperties elementGroupSetInVXYGraphProperties = (ElementGroupSetInVXYGraphProperties)sGProperties;
        elementGroupSetInVXYGraphProperties.mMagnitudeScalingFactor = this.getMagnitudePerCM();
        elementGroupSetInVXYGraphProperties.mDirectionInvariant = this.isDirectionInvariant();
        return true;
    }

    @Override
    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof ElementGroupSetInVXYGraphProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        ElementGroupSetInVXYGraphProperties elementGroupSetInVXYGraphProperties = (ElementGroupSetInVXYGraphProperties)sGProperties;
        this.setMagnitudePerCM(elementGroupSetInVXYGraphProperties.mMagnitudeScalingFactor);
        this.setDirectionInvariant(elementGroupSetInVXYGraphProperties.mDirectionInvariant);
        this.updateGridMode();
        return true;
    }

    @Override
    public float getLineWidth(String string) {
        return this.getArrowGroup().getLineWidth(string);
    }

    @Override
    public int getLineType() {
        return this.getArrowGroup().getLineType();
    }

    @Override
    public Color getColor() {
        return this.getArrowGroup().getColor();
    }

    @Override
    public float getHeadSize(String string) {
        return this.getArrowGroup().getHeadSize(string);
    }

    @Override
    public float getHeadOpenAngle() {
        return this.getArrowGroup().getHeadOpenAngle();
    }

    @Override
    public float getHeadCloseAngle() {
        return this.getArrowGroup().getHeadCloseAngle();
    }

    @Override
    public int getStartHeadType() {
        return this.getArrowGroup().getStartHeadType();
    }

    @Override
    public int getEndHeadType() {
        return this.getArrowGroup().getEndHeadType();
    }

    @Override
    public boolean setLineWidth(float f, String string) {
        return this.getArrowGroup().setLineWidth(f, string);
    }

    @Override
    public boolean setLineType(int n) {
        return this.getArrowGroup().setLineType(n);
    }

    @Override
    public boolean setColor(Color color) {
        return this.getArrowGroup().setColor(color);
    }

    @Override
    public boolean setHeadSize(float f, String string) {
        return this.getArrowGroup().setHeadSize(f, string);
    }

    @Override
    public boolean setHeadAngle(Float f, Float f2) {
        return this.getArrowGroup().setHeadAngle(f.floatValue(), f2.floatValue());
    }

    @Override
    public boolean setStartHeadType(int n) {
        return this.getArrowGroup().setStartHeadType(n);
    }

    @Override
    public boolean setEndHeadType(int n) {
        return this.getArrowGroup().setEndHeadType(n);
    }

    @Override
    public boolean hasValidAngle(Number number, Number number2) {
        float f = number != null ? number.floatValue() : this.getHeadOpenAngle();
        float f2 = number2 != null ? number2.floatValue() : this.getHeadCloseAngle();
        return f < f2;
    }

    public SGTuple2f getStartLocation(int n) {
        if (this.isGridMode()) {
            if (this.mXArray == null || this.mYArray == null) {
                return null;
            }
            int n2 = n / this.mXArray.length;
            int n3 = n % this.mXArray.length;
            if (n2 < 0 || n2 >= this.mYArray.length) {
                throw new IllegalArgumentException("Index out of bounds: " + n);
            }
            return new SGTuple2f(this.mXArray[n3], this.mYArray[n2]);
        }
        if (this.mStartPointsArray == null) {
            return null;
        }
        if (n < 0 || n >= this.mStartPointsArray.length) {
            throw new IllegalArgumentException("Index out of bounds: " + n);
        }
        return this.mStartPointsArray[n];
    }

    public SGTuple2f getEndLocation(int n) {
        if (this.mEndPointsArray == null) {
            return null;
        }
        if (n < 0 || n >= this.mEndPointsArray.length) {
            throw new IllegalArgumentException("Index out of bounds: " + n);
        }
        return this.mEndPointsArray[n];
    }

    @Override
    protected SGPropertyResults setProperties(SGPropertyMap sGPropertyMap, SGPropertyResults sGPropertyResults) {
        Object object;
        Object object2;
        SGPropertyResults sGPropertyResults2 = (SGPropertyResults)sGPropertyResults.clone();
        if ((sGPropertyResults2 = super.setProperties(sGPropertyMap, sGPropertyResults2)) == null) {
            return null;
        }
        Iterator<String> iterator = sGPropertyMap.getKeyIterator();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            String string = sGPropertyMap.getValueString((String)object2);
            if ("ArrowMagnitudePerCM".equalsIgnoreCase((String)object2)) {
                object = SGUtilityText.getFloat(string);
                if (object == null) {
                    sGPropertyResults2.putResult("ArrowMagnitudePerCM", 1);
                    continue;
                }
                if (!SGUtility.isValidPropertyValue(((Float)object).floatValue())) {
                    sGPropertyResults2.putResult("ArrowMagnitudePerCM", 1);
                    continue;
                }
                if (!this.setMagnitudePerCM(((Float)object).floatValue())) {
                    sGPropertyResults2.putResult("ArrowMagnitudePerCM", 1);
                    continue;
                }
                sGPropertyResults2.putResult("ArrowMagnitudePerCM", 0);
                continue;
            }
            if (!"ArrowDirectionInvariant".equalsIgnoreCase((String)object2)) continue;
            object = SGUtilityText.getBoolean(string);
            if (object == null) {
                sGPropertyResults2.putResult("ArrowDirectionInvariant", 1);
                continue;
            }
            if (!this.setDirectionInvariant((Boolean)object)) {
                sGPropertyResults2.putResult("ArrowDirectionInvariant", 1);
                continue;
            }
            sGPropertyResults2.putResult("ArrowDirectionInvariant", 0);
        }
        object2 = this.getArrowGroups();
        for (int i = 0; i < object2.size(); ++i) {
            object = (SGElementGroupArrowForData)object2.get(i);
            sGPropertyResults2 = ((SGElementGroupArrowForData)object).setProperties(sGPropertyMap, sGPropertyResults2);
            if (sGPropertyResults2 != null) continue;
            return null;
        }
        return sGPropertyResults2;
    }

    @Override
    public List<SGElementGroupArrow> getArrowGroups() {
        ArrayList<SGElementGroupArrow> arrayList = new ArrayList<SGElementGroupArrow>();
        List<SGElementGroup> list = SGUtilityForFigureElement.getGroups(SGElementGroupArrow.class, this.mDrawingElementGroupList);
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add((SGElementGroupArrow)list.get(i));
        }
        return arrayList;
    }

    @Override
    public SGElementGroupArrow getArrowGroup() {
        return (SGElementGroupArrow)SGUtilityForFigureElement.getGroup(SGElementGroupArrow.class, this.mDrawingElementGroupList);
    }

    @Override
    protected boolean setElementGroupProperties(List list) {
        for (int i = 0; i < list.size(); ++i) {
            SGProperties sGProperties = (SGProperties)list.get(i);
            SGElementGroupArrow sGElementGroupArrow = null;
            if (!(sGProperties instanceof SGElementGroupArrow.ArrowProperties)) {
                throw new Error("Illegal group property: " + sGProperties);
            }
            sGElementGroupArrow = this.getArrowGroup();
            if (sGElementGroupArrow == null || ((SGElementGroup)sGElementGroupArrow).setProperties(sGProperties)) continue;
            return false;
        }
        return true;
    }

    public boolean isGridMode() {
        return this.isGridMode(this.getData());
    }

    public boolean isGridMode(SGData sGData) {
        if (SGDataUtility.isNetCDFData(sGData)) {
            SGNetCDFData sGNetCDFData = (SGNetCDFData)sGData;
            return !sGNetCDFData.isSerialNumberAvailable();
        }
        return false;
    }

    private boolean updateGridMode() {
        boolean bl = this.isGridMode();
        List<SGElementGroupArrow> list = this.getArrowGroups();
        for (int i = 0; i < list.size(); ++i) {
            SGElementGroupArrow sGElementGroupArrow = list.get(i);
            if (sGElementGroupArrow.setGridMode(bl)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean setColumnInfo(SGDataColumnInfo[] sGDataColumnInfoArray, String string) {
        if (!super.setColumnInfo(sGDataColumnInfoArray, string)) {
            return false;
        }
        SGIVXYTypeData sGIVXYTypeData = (SGIVXYTypeData)((Object)this.getData());
        this.initPointsArray(sGIVXYTypeData.getPointsNumber());
        return this.updateGridMode();
    }

    public static class ElementGroupSetInVXYGraphProperties
    extends SGElementGroupSetInFigureElement.ElementGroupSetPropertiesInFigureElement {
        float mMagnitudeScalingFactor;
        boolean mDirectionInvariant;

        public boolean equals(Object object) {
            if (!(object instanceof ElementGroupSetInVXYGraphProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            ElementGroupSetInVXYGraphProperties elementGroupSetInVXYGraphProperties = (ElementGroupSetInVXYGraphProperties)object;
            if (elementGroupSetInVXYGraphProperties.mMagnitudeScalingFactor != this.mMagnitudeScalingFactor) {
                return false;
            }
            return elementGroupSetInVXYGraphProperties.mDirectionInvariant == this.mDirectionInvariant;
        }

        public String toString() {
            String string = super.toString();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[");
            stringBuffer.append(string);
            stringBuffer.append(", Magnitude Scaling Factor=");
            stringBuffer.append(this.mMagnitudeScalingFactor);
            stringBuffer.append(", Direction Invariant=");
            stringBuffer.append(this.mDirectionInvariant);
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }
}

