/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementString;
import jp.riken.brain.ni.samuraigraph.figure.SGElementGroup;
import jp.riken.brain.ni.samuraigraph.figure.SGIFigureDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGIStringConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementString2DExtended;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSXY;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIElementGroupConstants;
import org.w3c.dom.Element;

public abstract class SGElementGroupString
extends SGElementGroupSXY
implements SGIStringConstants,
SGIElementGroupConstants,
SGIFigureDrawingElementConstants {
    protected String mFontName;
    protected float mFontSize;
    protected int mFontStyle;
    protected Color mColor = null;
    protected float mAngle;
    protected int mDecimalPlaces;
    protected int mExponent;

    public void dispose() {
        super.dispose();
        this.mFontName = null;
    }

    public boolean setStrings(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("array == null");
        }
        if (stringArray.length != this.mDrawingElementArray.length) {
            throw new IllegalArgumentException("Array length is different: " + stringArray.length);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            SGDrawingElementString sGDrawingElementString = (SGDrawingElementString)this.mDrawingElementArray[i];
            sGDrawingElementString.setString(stringArray[i]);
        }
        return true;
    }

    public boolean setFont(String string, int n, float f) {
        if (!SGUtility.equals(this.mFontName, string) || this.mFontStyle != n || this.mFontSize != f) {
            this.mFontName = string;
            this.mFontStyle = n;
            this.mFontSize = f;
            if (this.mDrawingElementArray != null) {
                for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                    SGDrawingElementString sGDrawingElementString = (SGDrawingElementString)this.mDrawingElementArray[i];
                    sGDrawingElementString.setFont(string, n, f);
                }
            }
        }
        return true;
    }

    public boolean setFontName(String string) {
        if (!SGUtility.equals(this.mFontName, string)) {
            this.mFontName = string;
            if (this.mDrawingElementArray != null) {
                for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                    SGDrawingElementString sGDrawingElementString = (SGDrawingElementString)this.mDrawingElementArray[i];
                    sGDrawingElementString.setFontName(string);
                }
            }
        }
        return true;
    }

    public boolean setFontSize(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("size < 0.0f");
        }
        if (this.mFontSize != f) {
            this.mFontSize = f;
            if (this.mDrawingElementArray != null) {
                for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                    SGDrawingElementString sGDrawingElementString = (SGDrawingElementString)this.mDrawingElementArray[i];
                    sGDrawingElementString.setFontSize(f);
                }
            }
        }
        return true;
    }

    public abstract boolean setFontSize(float var1, String var2);

    public boolean setFontStyle(int n) {
        if (!SGUtilityText.isValidFontStyle(n)) {
            return false;
        }
        if (this.mFontStyle != n) {
            this.mFontStyle = n;
            if (this.mDrawingElementArray != null) {
                for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                    SGDrawingElementString sGDrawingElementString = (SGDrawingElementString)this.mDrawingElementArray[i];
                    sGDrawingElementString.setFontStyle(n);
                }
            }
        }
        return true;
    }

    public boolean setAngle(float f) {
        Float f2 = SGUtility.calcPropertyValue(f, null, null, -180.0, 180.0, -2);
        if (f2 == null) {
            return false;
        }
        if (this.mAngle != f) {
            this.mAngle = f;
            if (this.mDrawingElementArray != null) {
                for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                    SGDrawingElementString sGDrawingElementString = (SGDrawingElementString)this.mDrawingElementArray[i];
                    sGDrawingElementString.setAngle(f);
                }
            }
        }
        return true;
    }

    public boolean setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color == null");
        }
        if (!SGUtility.equals(this.mColor, color)) {
            this.mColor = color;
            if (this.mDrawingElementArray != null) {
                for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                    SGDrawingElementString sGDrawingElementString = (SGDrawingElementString)this.mDrawingElementArray[i];
                    sGDrawingElementString.setColor(color);
                }
            }
        }
        return true;
    }

    public String getFontName() {
        return this.mFontName;
    }

    public float getFontSize() {
        return this.mFontSize;
    }

    public float getFontSize(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getFontSize(), string);
    }

    public int getFontStyle() {
        return this.mFontStyle;
    }

    public Color getColor() {
        return this.mColor;
    }

    public float getAngle() {
        return this.mAngle;
    }

    public boolean setDecimalPlaces(int n) {
        int n2;
        if (n < 0) {
            return false;
        }
        if (n > 10) {
            return false;
        }
        this.mDecimalPlaces = n2 = n;
        return true;
    }

    public boolean setExponent(int n) {
        int n2;
        if (n < -10) {
            return false;
        }
        if (n > 10) {
            return false;
        }
        this.mExponent = n2 = n;
        return true;
    }

    public int getDecimalPlaces() {
        return this.mDecimalPlaces;
    }

    public int getExponent() {
        return this.mExponent;
    }

    protected boolean initDrawingElement(SGTuple2f[] sGTuple2fArray) {
        int n = sGTuple2fArray.length;
        this.initDrawingElement(n);
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        for (int i = 0; i < n; ++i) {
            ((SGDrawingElementString)sGDrawingElementArray[i]).setLocation(sGTuple2fArray[i]);
        }
        return true;
    }

    public boolean paintElement(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (this.mDrawingElementArray != null) {
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                SGDrawingElementString2DExtended sGDrawingElementString2DExtended = (SGDrawingElementString2DExtended)this.mDrawingElementArray[i];
                sGDrawingElementString2DExtended.paint(graphics2D);
            }
        }
        return true;
    }

    public boolean setLocation(SGTuple2f[] sGTuple2fArray) {
        if (sGTuple2fArray == null) {
            throw new IllegalArgumentException("pointArray==null");
        }
        if (sGTuple2fArray.length != this.mDrawingElementArray.length) {
            this.initDrawingElement(sGTuple2fArray);
        }
        for (int i = 0; i < sGTuple2fArray.length; ++i) {
            SGDrawingElementString2DExtended sGDrawingElementString2DExtended = (SGDrawingElementString2DExtended)this.mDrawingElementArray[i];
            boolean bl = !sGTuple2fArray[i].isInfinite() && !sGTuple2fArray[i].isNaN();
            sGDrawingElementString2DExtended.setVisible(bl);
            if (!bl) continue;
            sGDrawingElementString2DExtended.setLocation(sGTuple2fArray[i]);
        }
        return true;
    }

    public String getTagName() {
        return "Label";
    }

    public boolean writeProperty(Element element) {
        float f = (float)SGUtilityNumber.roundOffNumber(this.mFontSize, -3);
        float f2 = (float)SGUtilityNumber.roundOffNumber(-this.mAngle, -3);
        ArrayList<Color> arrayList = new ArrayList<Color>();
        arrayList.add(this.getColor());
        element.setAttribute("FontSize", Float.toString(f) + "pt");
        element.setAttribute("FontName", this.mFontName);
        element.setAttribute("FontStyle", SGUtilityText.getFontStyleName(this.mFontStyle));
        element.setAttribute("Angle", Float.toString(f2));
        element.setAttribute("DecimalPlaces", Integer.toString(this.mDecimalPlaces));
        element.setAttribute("Exponent", Integer.toString(this.mExponent));
        element.setAttribute("Color", SGUtilityText.getColorListString(arrayList));
        return true;
    }

    public boolean readProperty(Element element) {
        Serializable serializable;
        String string = null;
        Number number = null;
        List<Color> list = null;
        string = element.getAttribute("FontSize");
        if (string.length() != 0) {
            serializable = new StringBuffer();
            number = SGUtilityText.getNumber(string, serializable);
            if (number == null) {
                return false;
            }
            if (!this.setFontSize(number.floatValue(), serializable.toString())) {
                return false;
            }
        }
        if ((string = element.getAttribute("FontName")).length() != 0 && !this.setFontName(string)) {
            return false;
        }
        string = element.getAttribute("FontStyle");
        if (string.length() != 0) {
            serializable = SGUtilityText.getFontStyle(string);
            if (serializable == null) {
                return false;
            }
            if (!this.setFontStyle((Integer)serializable)) {
                return false;
            }
        }
        if ((string = element.getAttribute("Color")).length() != 0) {
            list = SGUtilityText.getColorList(string);
            if (list == null) {
                return false;
            }
            if (list.size() < 1) {
                return false;
            }
            serializable = list.get(0);
            if (!this.setColor((Color)serializable)) {
                return false;
            }
        }
        if ((string = element.getAttribute("DecimalPlaces")).length() != 0) {
            number = SGUtilityText.getInteger(string);
            if (number == null) {
                return false;
            }
            if (number.intValue() < 0) {
                return false;
            }
            this.setDecimalPlaces(number.intValue());
        }
        if ((string = element.getAttribute("Exponent")).length() != 0) {
            number = SGUtilityText.getInteger(string);
            if (number == null) {
                return false;
            }
            int n = number.intValue();
            this.setExponent(n);
        }
        return true;
    }

    public SGProperties getProperties() {
        StringProperties stringProperties = new StringProperties();
        if (!this.getProperties(stringProperties)) {
            return null;
        }
        return stringProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof StringProperties)) {
            return false;
        }
        if (!super.getProperties(sGProperties)) {
            return false;
        }
        StringProperties stringProperties = (StringProperties)sGProperties;
        stringProperties.setFontName(this.getFontName());
        stringProperties.setFontSize(this.getFontSize());
        stringProperties.setFontStyle(this.getFontStyle());
        stringProperties.setAngle(this.getAngle());
        stringProperties.setColor(this.getColor());
        stringProperties.mDecimalPlaces = this.getDecimalPlaces();
        stringProperties.mExponent = this.getExponent();
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof StringProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        StringProperties stringProperties = (StringProperties)sGProperties;
        Float f = stringProperties.getFontSize();
        if (f == null) {
            return false;
        }
        Integer n = stringProperties.getFontStyle();
        if (n == null) {
            return false;
        }
        this.setFont(stringProperties.getFontName(), n, f.floatValue());
        Float f2 = stringProperties.getAngle();
        if (f2 == null) {
            return false;
        }
        this.setAngle(f2.floatValue());
        this.setDecimalPlaces(stringProperties.mDecimalPlaces);
        this.setExponent(stringProperties.mExponent);
        Color color = stringProperties.getColor();
        if (color == null) {
            return false;
        }
        this.setColor(color);
        return true;
    }

    public boolean setMagnification(float f) {
        if (!super.setMagnification(f)) {
            return false;
        }
        if (this.mDrawingElementArray != null) {
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                this.mDrawingElementArray[i].setMagnification(f);
            }
        }
        return true;
    }

    public static class StringProperties
    extends SGElementGroup.ElementGroupProperties {
        protected SGDrawingElementString.StringProperties mStringProperties = new SGDrawingElementString.StringProperties();
        protected int mDecimalPlaces;
        protected int mExponent;

        public Object copy() {
            Object object = super.copy();
            StringProperties stringProperties = (StringProperties)object;
            stringProperties.mStringProperties = (SGDrawingElementString.StringProperties)this.mStringProperties.copy();
            return stringProperties;
        }

        public void dispose() {
            super.dispose();
            this.mStringProperties.dispose();
        }

        public boolean equals(Object object) {
            if (!(object instanceof StringProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            StringProperties stringProperties = (StringProperties)object;
            if (!this.mStringProperties.equals(stringProperties.mStringProperties)) {
                return false;
            }
            if (this.mDecimalPlaces != stringProperties.mDecimalPlaces) {
                return false;
            }
            return this.mExponent == stringProperties.mExponent;
        }

        public Float getFontSize() {
            return this.mStringProperties.getFontSize();
        }

        public Integer getFontStyle() {
            return this.mStringProperties.getFontStyle();
        }

        public String getFontName() {
            return this.mStringProperties.getFontName();
        }

        public Float getAngle() {
            return this.mStringProperties.getAngle();
        }

        public Color getColor() {
            return this.mStringProperties.getColor();
        }

        public boolean setFontSize(float f) {
            return this.mStringProperties.setFontSize(f);
        }

        public boolean setFontStyle(int n) {
            return this.mStringProperties.setFontStyle(n);
        }

        public boolean setFontName(String string) {
            return this.mStringProperties.setFontName(string);
        }

        public boolean setAngle(float f) {
            return this.mStringProperties.setAngle(f);
        }

        public boolean setColor(Color color) {
            return this.mStringProperties.setColor(color);
        }
    }
}

