/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.data.SGISXYData;
import jp.riken.brain.ni.samuraigraph.figure.SGIFigureDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGISXYDataConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementSymbol2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSetInGraph;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSetInGraphSXY;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSymbolForData;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGFigureElementGraph;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIElementGroupInGraph;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityForFigureElementJava2D;
import org.w3c.dom.Element;

public class SGElementGroupSymbolInGraph
extends SGElementGroupSymbolForData
implements SGIElementGroupInGraph,
SGISXYDataConstants,
SGIFigureDrawingElementConstants {
    public static final int MAX_NUMBER_OF_ANCHORS = 8;
    private SGFigureElementGraph mGraph = null;
    protected SGElementGroupSetInGraph mGroupSet = null;
    private boolean mFocusedFlag = false;

    public boolean setElementGroupSet(SGElementGroupSetInGraph sGElementGroupSetInGraph) {
        this.mGroupSet = sGElementGroupSetInGraph;
        return true;
    }

    public void setFocused(boolean bl) {
        this.mFocusedFlag = bl;
    }

    public boolean isFocused() {
        return this.mFocusedFlag;
    }

    public SGElementGroupSymbolInGraph(SGISXYData sGISXYData, SGFigureElementGraph sGFigureElementGraph) {
        super(sGISXYData);
        this.mGraph = sGFigureElementGraph;
    }

    public boolean writeProperty(Element element) {
        if (!super.writeProperty(element)) {
            return false;
        }
        element.setAttribute("Visible", Boolean.toString(this.mVisibleFlag));
        return true;
    }

    public boolean readProperty(Element element) {
        if (!super.readProperty(element)) {
            return false;
        }
        return this.mGraph.readProperty(this, element);
    }

    public boolean paintElement(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        block4: {
            super.paintElement(graphics2D, rectangle2D);
            SGElementGroupSetInGraphSXY sGElementGroupSetInGraphSXY = (SGElementGroupSetInGraphSXY)this.mGroupSet;
            SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
            if (!this.isFocused() || !this.mGraph.isSymbolsVisibleAroundFocusedObjects() || sGElementGroupSetInGraphSXY.isBarVisible()) break block4;
            int n = sGDrawingElementArray.length;
            if (n <= 8) {
                for (int i = 0; i < n; ++i) {
                    SGDrawingElementSymbol2D sGDrawingElementSymbol2D = (SGDrawingElementSymbol2D)sGDrawingElementArray[i];
                    this.emphasisSymbol(sGDrawingElementSymbol2D, graphics2D);
                }
            } else {
                int n2 = n / 8;
                int n3 = 0;
                do {
                    SGDrawingElementSymbol2D sGDrawingElementSymbol2D = (SGDrawingElementSymbol2D)sGDrawingElementArray[n3];
                    this.emphasisSymbol(sGDrawingElementSymbol2D, graphics2D);
                } while ((n3 += n2) < n);
            }
        }
        return true;
    }

    private boolean emphasisSymbol(SGDrawingElementSymbol2D sGDrawingElementSymbol2D, Graphics2D graphics2D) {
        SGUtilityForFigureElementJava2D.drawAnchorsOnRectangle(sGDrawingElementSymbol2D.getElementBounds(), graphics2D);
        return true;
    }

    public boolean contains(int n, int n2) {
        Rectangle2D rectangle2D = this.mGraph.getGraphRect();
        if (!rectangle2D.contains(n, n2)) {
            return false;
        }
        return super.contains(n, n2);
    }

    public SGTuple2f getLocation(int n) {
        if (this.mGroupSet instanceof SGElementGroupSetInGraphSXY) {
            SGElementGroupSetInGraphSXY sGElementGroupSetInGraphSXY = (SGElementGroupSetInGraphSXY)this.mGroupSet;
            SGTuple2f sGTuple2f = sGElementGroupSetInGraphSXY.getSymbolLocation(n);
            return new SGTuple2f(sGTuple2f.x, sGTuple2f.y);
        }
        throw new Error("Not supported.");
    }
}

