/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGITickLabelConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupString;
import org.w3c.dom.Element;

public abstract class SGElementGroupTickLabel
extends SGElementGroupString
implements SGITickLabelConstants {
    protected boolean mAlignHorizontalFlag;

    public boolean writeProperty(Element element) {
        if (!super.writeProperty(element)) {
            return false;
        }
        element.setAttribute("Angle", Float.toString(this.mAngle));
        element.setAttribute("AlignHorizontally", Boolean.toString(this.mAlignHorizontalFlag));
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean readProperty(Element element) {
        String string = null;
        Float f = null;
        Boolean bl = null;
        if (!super.readProperty(element)) {
            return false;
        }
        string = element.getAttribute("Angle");
        if (string.length() != 0) {
            f = SGUtilityText.getFloat(string, SGIConstants.degree);
            if (f == null) {
                if (string.trim().equalsIgnoreCase("Horizontal")) {
                    if (!this.setAngle(0.0f)) {
                        return false;
                    }
                } else {
                    if (!string.trim().equalsIgnoreCase("Inclined")) return false;
                    if (!this.setAngle(30.0f)) {
                        return false;
                    }
                }
            } else if (!this.setAngle(((Number)f).floatValue())) {
                return false;
            }
        }
        if ((string = element.getAttribute("AlignHorizontally")).length() == 0) return true;
        bl = SGUtilityText.getBoolean(string);
        if (bl == null) {
            return false;
        }
        if (this.setHorizontalAlignment(bl)) return true;
        return false;
    }

    public abstract boolean updateLocation();

    public boolean hasHorizontalAlignment() {
        return this.mAlignHorizontalFlag;
    }

    public boolean setHorizontalAlignment(boolean bl) {
        this.mAlignHorizontalFlag = bl;
        return true;
    }

    public SGProperties getProperties() {
        TickLabelProperties tickLabelProperties = new TickLabelProperties();
        if (!this.getProperties(tickLabelProperties)) {
            return null;
        }
        return tickLabelProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof TickLabelProperties)) {
            return false;
        }
        if (!super.getProperties(sGProperties)) {
            return false;
        }
        TickLabelProperties tickLabelProperties = (TickLabelProperties)sGProperties;
        tickLabelProperties.mAlignmentHorizontal = this.mAlignHorizontalFlag;
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof TickLabelProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        TickLabelProperties tickLabelProperties = (TickLabelProperties)sGProperties;
        this.mAlignHorizontalFlag = tickLabelProperties.mAlignmentHorizontal;
        return true;
    }

    public static class TickLabelProperties
    extends SGElementGroupString.StringProperties {
        protected boolean mAlignmentHorizontal;

        public boolean equals(Object object) {
            if (!(object instanceof TickLabelProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            TickLabelProperties tickLabelProperties = (TickLabelProperties)object;
            return this.mAlignmentHorizontal == tickLabelProperties.mAlignmentHorizontal;
        }
    }
}

