/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIData;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.data.SGISXYData;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementString2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementString2DExtended;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSetInGraph;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupTickLabelForData;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGFigureElementGraph;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIElementGroupInGraph;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityForFigureElementJava2D;
import org.w3c.dom.Element;

public abstract class SGElementGroupTickLabelInGraph
extends SGElementGroupTickLabelForData
implements SGIElementGroupInGraph {
    public static final int MAX_NUMBER_OF_ANCHORS = 8;
    protected SGFigureElementGraph mGraph = null;
    protected SGElementGroupSetInGraph mGroupSet = null;
    protected SGTuple2f[] mPointsArray = null;
    protected boolean mFocusedFlag = false;

    public boolean setElementGroupSet(SGElementGroupSetInGraph sGElementGroupSetInGraph) {
        this.mGroupSet = sGElementGroupSetInGraph;
        return true;
    }

    protected void initPointsArray(int n) {
        SGTuple2f[] sGTuple2fArray = new SGTuple2f[n];
        for (int i = 0; i < n; ++i) {
            sGTuple2fArray[i] = new SGTuple2f();
        }
        this.mPointsArray = sGTuple2fArray;
    }

    public void setFocused(boolean bl) {
        this.mFocusedFlag = bl;
    }

    public boolean isFocused() {
        return this.mFocusedFlag;
    }

    protected SGElementGroupTickLabelInGraph(SGISXYData sGISXYData, SGFigureElementGraph sGFigureElementGraph) {
        super(sGISXYData);
        this.mGraph = sGFigureElementGraph;
    }

    protected SGDrawingElement createDrawingElementInstance(int n) {
        return new TickLabelStringElement();
    }

    public void dispose() {
        super.dispose();
        this.mPointsArray = null;
    }

    public String getTagName() {
        return "TickLabels";
    }

    public boolean writeProperty(Element element) {
        if (!super.writeProperty(element)) {
            return false;
        }
        element.setAttribute("Visible", Boolean.toString(this.mVisibleFlag));
        return true;
    }

    public boolean readProperty(Element element) {
        if (!super.readProperty(element)) {
            return false;
        }
        return this.mGraph.readProperty(this, element);
    }

    public boolean updateLocation() {
        return this.setLocation(this.mPointsArray);
    }

    public boolean paintElement(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        block5: {
            if (!super.paintElement(graphics2D, rectangle2D)) {
                return false;
            }
            SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
            if (!this.isFocused() || !this.mGraph.isSymbolsVisibleAroundFocusedObjects()) break block5;
            int n = sGDrawingElementArray.length;
            if (n <= 8) {
                for (int i = 0; i < n; ++i) {
                    SGDrawingElementString2D sGDrawingElementString2D = (SGDrawingElementString2D)sGDrawingElementArray[i];
                    if (!sGDrawingElementString2D.isVisible()) continue;
                    this.emphasisLabel(sGDrawingElementString2D, graphics2D);
                }
            } else {
                int n2 = n / 8 + 1;
                int n3 = 0;
                do {
                    SGDrawingElementString2D sGDrawingElementString2D;
                    if (!(sGDrawingElementString2D = (SGDrawingElementString2D)sGDrawingElementArray[n3]).isVisible()) continue;
                    this.emphasisLabel(sGDrawingElementString2D, graphics2D);
                } while ((n3 += n2) < n);
            }
        }
        return true;
    }

    private void emphasisLabel(SGDrawingElementString2D sGDrawingElementString2D, Graphics2D graphics2D) {
        SGUtilityForFigureElementJava2D.drawAnchorsOnRectangle(sGDrawingElementString2D.getElementBounds(), graphics2D);
    }

    public boolean contains(int n, int n2) {
        Rectangle2D rectangle2D = this.mGraph.getGraphRect();
        if (rectangle2D.contains(n, n2)) {
            return false;
        }
        return super.contains(n, n2);
    }

    protected abstract boolean updateLocation(SGIData var1, SGAxis var2, SGAxis var3);

    protected static class TickLabelStringElement
    extends SGDrawingElementString2DExtended {
        protected TickLabelStringElement() {
        }
    }
}

