/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGColorBarModel;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDataAxisInfo;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIChildObject;
import jp.riken.brain.ni.samuraigraph.base.SGIColorBar;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGICopiable;
import jp.riken.brain.ni.samuraigraph.base.SGIDisposable;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementAxis;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementAxisBreak;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementForData;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementGraph;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementGrid;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementLegend;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementShape;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementSignificantDifference;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementString;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementTimingLine;
import jp.riken.brain.ni.samuraigraph.base.SGIMovable;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGISelectable;
import jp.riken.brain.ni.samuraigraph.base.SGIUndoable;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyMap;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyResults;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2d;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUndoManager;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.base.SGValueRange;
import jp.riken.brain.ni.samuraigraph.data.SGDataUtility;
import jp.riken.brain.ni.samuraigraph.data.SGISXYData;
import jp.riken.brain.ni.samuraigraph.data.SGISXYZTypeData;
import jp.riken.brain.ni.samuraigraph.data.SGIThreeDimensionalData;
import jp.riken.brain.ni.samuraigraph.data.SGITwoDimensionalData;
import jp.riken.brain.ni.samuraigraph.data.SGIVXYTypeData;
import jp.riken.brain.ni.samuraigraph.figure.SGColorBarDialog;
import jp.riken.brain.ni.samuraigraph.figure.SGColorBarStyleManager;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementString;
import jp.riken.brain.ni.samuraigraph.figure.SGIAxisConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGIAxisPanelObserver;
import jp.riken.brain.ni.samuraigraph.figure.SGIColorBarConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGIColorBarDialogObserver;
import jp.riken.brain.ni.samuraigraph.figure.SGIStringConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGStroke;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGAxisDialog;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementLine2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementString2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementString2DExtended;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSetInFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSetInGraph;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGFigureElement2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIAxisDialogObserver;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGISXYAxisShiftEnabled;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGSimpleLine2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityForFigureElementJava2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityJava2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGFigureElementAxis
extends SGFigureElement2D
implements SGIFigureElementAxis,
SGIStringConstants,
SGIAxisDialogObserver,
CaretListener,
DocumentListener,
ActionListener,
KeyListener,
SGIAxisConstants,
SGIColorBarConstants {
    public static final int AXIS_NORMAL_HORIZONTAL_LOWER = 10;
    public static final int AXIS_NORMAL_HORIZONTAL_UPPER = 11;
    public static final int AXIS_NORMAL_PERPENDICULAR_LEFT = 12;
    public static final int AXIS_NORMAL_PERPENDICULAR_RIGHT = 13;
    private ArrayList<ElementsGroupOfAxis> mElementsGroupList = new ArrayList();
    private ElementsGroupColorBar mZAxisElementsGroup = null;
    private boolean mColorBarAvailableFlag = false;
    private Color mLineColor = DEFAULT_LINE_COLOR;
    private Color mAxisFontColor = DEFAULT_FONT_COLOR;
    private String mTitleFontName = "Serif";
    private float mTitleFontSize = 16.0f;
    private int mTitleFontStyle = -1;
    private String mScaleFontName = "Serif";
    private float mScaleFontSize = 16.0f;
    private int mScaleFontStyle = -1;
    private float mTickMarkLength = 0.25f;
    private float mSpaceAxisLineAndNumber;
    private float mSpaceNumberAndTitle;
    private boolean mFrameLineVisibleFlag = true;
    private Color mFrameLineColor = DEFAULT_FRAME_LINE_COLOR;
    private SGDrawingElement mPressedElement = null;
    private Point mPressedElementOrigin = null;
    private SGPropertyDialog mPropertyDialog = null;
    private SGPropertyDialog mColorBarPropertyDialog = null;
    private static boolean mNotifyChangeOnDraggingFlag = true;
    private JTextField mTextField = new JTextField();
    private boolean mStartFlag = true;
    private SGColorBarStyleManager mColorBarStyleManager = new SGColorBarStyleManager();
    private SGColorBarModel mColorBarModel = null;
    private SGStroke mAxisLineStroke = new SGStroke();
    private SGStroke mTickMarkStroke = new SGStroke();
    private SGStroke mFrameLineStroke = new SGStroke();
    private int mTempAxisLocation = -1;
    private SGProperties mTemporaryProperties = null;
    private SGPropertyDialog mCurrentPropertyDialog = null;
    private SGDrawingElementString2D mEditingStringElement = null;

    public SGFigureElementAxis() {
        this.initEditField();
        this.init();
    }

    private void init() {
        this.setAxisLineWidth(1.5f, "pt");
        this.setTickMarkWidth(1.5f, "pt");
        this.setTickMarkLength(0.25f, "cm");
        this.setLineColor(DEFAULT_LINE_COLOR);
        this.setFrameVisible(false);
        this.setFrameLineWidth(1.5f, "pt");
        this.setFrameLineColor(DEFAULT_FRAME_LINE_COLOR);
        this.setFontColor(DEFAULT_FONT_COLOR);
        this.setTitleFontName("Serif");
        this.setTitleFontSize(16.0f, "pt");
        this.setTitleFontStyle(0);
        this.setScaleFontName("Serif");
        this.setScaleFontSize(16.0f, "pt");
        this.setScaleFontStyle(0);
        this.setSpaceAxisLineAndNumber(0.2f, "cm");
        this.setSpaceNumberAndTitle(0.2f, "cm");
        String string = "Gradient Colors";
        this.mColorBarModel = this.mColorBarStyleManager.getColorBarModel(string);
        this.createXYAxisGroups(new SGTuple2d(0.0, 1.0), new SGTuple2d(0.0, 1.0), "X Label", "Y Label");
        SGAxis sGAxis = this.mColorBarModel.getAxis();
        ElementsGroupColorBar elementsGroupColorBar = new ElementsGroupColorBar();
        elementsGroupColorBar.setLocationInPlane(4);
        elementsGroupColorBar.mAxis = sGAxis;
        elementsGroupColorBar.setAxisVisible(false);
        elementsGroupColorBar.setTitle("Z Label");
        this.mZAxisElementsGroup = elementsGroupColorBar;
        this.createAllDrawingElements();
    }

    private void initEditField() {
        this.mTextField.setVisible(false);
        this.mTextField.addActionListener(this);
        this.mTextField.addCaretListener(this);
        this.mTextField.getDocument().addDocumentListener(this);
        this.mTextField.addKeyListener(this);
    }

    @Override
    public boolean initPropertiesHistory() {
        if (!super.initPropertiesHistory()) {
            return false;
        }
        if (!this.mZAxisElementsGroup.initPropertiesHistory()) {
            return false;
        }
        this.mStartFlag = false;
        return true;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.mColorBarModel = null;
        this.mColorBarStyleManager = null;
        if (this.mPropertyDialog != null) {
            this.mPropertyDialog.dispose();
            this.mPropertyDialog = null;
        }
        this.mEditingStringElement = null;
        this.mFrameLineColor = null;
        this.mLineColor = null;
        this.mPressedElement = null;
        this.mPressedElementOrigin = null;
        this.mPressedPoint = null;
        this.mTemporaryProperties = null;
        this.mTextField = null;
        this.mAxisFontColor = null;
        this.mTitleFontName = null;
        this.mScaleFontName = null;
        for (int i = 0; i < this.mElementsGroupList.size(); ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = this.mElementsGroupList.get(i);
            elementsGroupOfAxis.dispose();
        }
        this.mElementsGroupList.clear();
        this.mElementsGroupList = null;
        this.mZAxisElementsGroup.dispose();
        this.mZAxisElementsGroup = null;
    }

    @Override
    public void setComponent(JComponent jComponent) {
        super.setComponent(jComponent);
        jComponent.add(this.mTextField);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.mTextField)) {
            this.closeTextField();
            return;
        }
    }

    @Override
    public boolean closeTextField() {
        this.commitEdit();
        this.hideEditField();
        return true;
    }

    private boolean commitEdit() {
        String string = this.mTextField.getText();
        if (!SGUtilityText.isValidString(string)) {
            return false;
        }
        String string2 = this.mEditingStringElement.getString();
        String string3 = string;
        this.mEditingStringElement.setString(string3);
        if (!string2.equals(string3)) {
            if (this.mEditingStringElement.equals(this.mZAxisElementsGroup.mTitle)) {
                this.mZAxisElementsGroup.setChanged(true);
            } else {
                this.setChanged(true);
            }
        }
        this.createAllDrawingElements();
        this.repaint();
        this.notifyChange();
        this.notifyToRoot();
        return true;
    }

    private boolean hideEditField() {
        this.mTextField.setText("");
        this.mTextField.setVisible(false);
        return true;
    }

    @Override
    public String getTitleFontName() {
        return this.mTitleFontName;
    }

    @Override
    public int getTitleFontStyle() {
        return this.mTitleFontStyle;
    }

    @Override
    public float getTitleFontSize() {
        return this.mTitleFontSize;
    }

    @Override
    public float getTitleFontSize(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getTitleFontSize(), string);
    }

    public String getScaleFontName() {
        return this.mScaleFontName;
    }

    public int getScaleFontStyle() {
        return this.mScaleFontStyle;
    }

    @Override
    public float getScaleFontSize() {
        return this.mScaleFontSize;
    }

    public float getScaleFontSize(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getScaleFontSize(), string);
    }

    @Override
    public Color getStringColor() {
        return this.mAxisFontColor;
    }

    @Override
    public boolean isFrameLineVisible() {
        return this.mFrameLineVisibleFlag;
    }

    public float getFrameLineWidth() {
        return this.mFrameLineStroke.getLineWidth();
    }

    @Override
    public float getFrameLineWidth(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getFrameLineWidth(), string);
    }

    @Override
    public Color getFrameLineColor() {
        return this.mFrameLineColor;
    }

    public float getAxisLineWidth() {
        return this.mAxisLineStroke.getLineWidth();
    }

    @Override
    public float getAxisLineWidth(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getAxisLineWidth(), string);
    }

    public float getTickMarkWidth() {
        return this.mTickMarkStroke.getLineWidth();
    }

    @Override
    public float getTickMarkWidth(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getTickMarkWidth(), string);
    }

    public float getTickMarkLength() {
        return this.mTickMarkLength;
    }

    @Override
    public float getTickMarkLength(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getTickMarkLength(), string);
    }

    @Override
    public Color getLineColor() {
        return this.mLineColor;
    }

    @Override
    public boolean setFrameVisible(boolean bl) {
        this.mFrameLineVisibleFlag = bl;
        return true;
    }

    public boolean setTickMarkWidth(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("lw < 0.0f");
        }
        this.mTickMarkStroke.setLineWidth(f);
        return true;
    }

    @Override
    public boolean setTickMarkWidth(float f, String string) {
        Float f2 = SGUtility.getLineWidth(f, string);
        if (f2 == null) {
            return false;
        }
        return this.setTickMarkWidth(f2.floatValue());
    }

    public boolean setTickMarkLength(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("len < 0.0f");
        }
        this.mTickMarkLength = f;
        return true;
    }

    @Override
    public boolean setTickMarkLength(float f, String string) {
        Float f2 = SGUtility.calcPropertyValue(f, string, "cm", 0.0, 0.5, -2);
        if (f2 == null) {
            return false;
        }
        return this.setTickMarkLength(f2.floatValue());
    }

    @Override
    public boolean setLineColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("cl == null");
        }
        this.mLineColor = color;
        return true;
    }

    @Override
    public int getAxisLocationForSelectedTab() {
        return this.mTempAxisLocation;
    }

    private void showPropertyDialog() {
        this.mCurrentPropertyDialog = this.mPropertyDialog;
        this.setPropertiesOfSelectedObjects();
        this.mCurrentPropertyDialog = null;
    }

    @Override
    public boolean synchronize(SGIFigureElement sGIFigureElement, String string) {
        boolean bl = true;
        if (sGIFigureElement instanceof SGIFigureElementGraph) {
            SGIFigureElementGraph sGIFigureElementGraph = (SGIFigureElementGraph)sGIFigureElement;
            this.synchronizeColorBar(sGIFigureElementGraph, string);
            this.synchronizeDataColumnChange(sGIFigureElementGraph, string);
        } else if (!(sGIFigureElement instanceof SGIFigureElementString)) {
            if (sGIFigureElement instanceof SGIFigureElementLegend) {
                SGIFigureElementLegend sGIFigureElementLegend = (SGIFigureElementLegend)sGIFigureElement;
                this.synchronizeColorBar(sGIFigureElementLegend, string);
                this.synchronizeDataColumnChange(sGIFigureElementLegend, string);
            } else if (!(sGIFigureElement instanceof SGIFigureElementAxis || sGIFigureElement instanceof SGIFigureElementAxisBreak || sGIFigureElement instanceof SGIFigureElementSignificantDifference || sGIFigureElement instanceof SGIFigureElementTimingLine || sGIFigureElement instanceof SGIFigureElementGrid || sGIFigureElement instanceof SGIFigureElementShape)) {
                bl = sGIFigureElement.synchronizeArgument(this, string);
            }
        }
        return bl;
    }

    private void synchronizeColorBar(SGIFigureElementForData sGIFigureElementForData, String string) {
        if ("Data objects are hidden".equals(string) || "Notify the change on undo".equals(string)) {
            List<SGData> list = this.getDataList();
            boolean bl = false;
            for (int i = 0; i < list.size(); ++i) {
                boolean bl2;
                SGData sGData = list.get(i);
                if (!(sGData instanceof SGISXYZTypeData) || !(bl2 = sGIFigureElementForData.isDataVisible(sGData))) continue;
                bl = true;
                break;
            }
            this.mColorBarAvailableFlag = bl;
        }
    }

    @Override
    public boolean synchronizeArgument(SGIFigureElement sGIFigureElement, String string) {
        throw new Error();
    }

    @Override
    public boolean setMagnification(float f) {
        super.setMagnification(f);
        List<ElementsGroupOfAxis> list = this.getAllAxisGroupList();
        for (int i = 0; i < list.size(); ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = list.get(i);
            elementsGroupOfAxis.setMagnification(f);
        }
        this.mFrameLineStroke.setMagnification(f);
        this.mAxisLineStroke.setMagnification(f);
        this.mTickMarkStroke.setMagnification(f);
        return true;
    }

    @Override
    public boolean onMouseClicked(MouseEvent mouseEvent) {
        if (this.mZAxisElementsGroup.isAxisVisible() && this.mZAxisElementsGroup.onMouseClicked(mouseEvent)) {
            return true;
        }
        List<ElementsGroupOfAxis> list = this.getAxisGroupList();
        for (int i = 0; i < list.size(); ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = list.get(i);
            boolean bl = elementsGroupOfAxis.onMouseClicked(mouseEvent);
            if (!bl) continue;
            return true;
        }
        if (this.mTextField.isVisible()) {
            this.closeTextField();
        } else {
            this.hideEditField();
        }
        return false;
    }

    @Override
    public boolean onMousePressed(MouseEvent mouseEvent) {
        if (this.mZAxisElementsGroup.isAxisVisible() && this.mZAxisElementsGroup.onMousePressed(mouseEvent)) {
            this.mPressedPoint = mouseEvent.getPoint();
            return true;
        }
        List<ElementsGroupOfAxis> list = this.getAxisGroupList();
        for (int i = 0; i < list.size(); ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = list.get(i);
            boolean bl = elementsGroupOfAxis.onMousePressed(mouseEvent);
            if (!bl) continue;
            this.mPressedPoint = mouseEvent.getPoint();
            return true;
        }
        return false;
    }

    @Override
    public boolean onMouseDragged(MouseEvent mouseEvent) {
        if (this.mZAxisElementsGroup.isAxisVisible() && this.mZAxisElementsGroup.onMouseDragged(mouseEvent)) {
            return true;
        }
        List<ElementsGroupOfAxis> list = this.getAxisGroupList();
        for (int i = 0; i < list.size(); ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = list.get(i);
            boolean bl = elementsGroupOfAxis.onMouseDragged(mouseEvent);
            if (!bl) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean onMouseReleased(MouseEvent mouseEvent) {
        boolean bl = false;
        if (this.mZAxisElementsGroup.isAxisVisible() && this.mZAxisElementsGroup.onMouseReleased(mouseEvent) && this.mZAxisElementsGroup.isChanged()) {
            bl = true;
        }
        List<ElementsGroupOfAxis> list = this.getAxisGroupList();
        for (int i = 0; i < list.size(); ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = list.get(i);
            if (!elementsGroupOfAxis.onMouseReleased(mouseEvent)) continue;
            if (!this.isChanged()) break;
            bl = true;
            break;
        }
        this.initializePressedElement();
        if (bl) {
            this.notifyChange();
            this.notifyToRoot();
        }
        this.repaint();
        return true;
    }

    @Override
    public boolean onDrawingElement(int n, int n2) {
        List<ElementsGroupOfAxis> list = this.getAxisGroupList();
        for (int i = 0; i < list.size(); ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = list.get(i);
            if (!elementsGroupOfAxis.onDrawingElement(n, n2)) continue;
            return true;
        }
        return this.mZAxisElementsGroup.isAxisVisible() && this.mZAxisElementsGroup.onDrawingElement(n, n2);
    }

    @Override
    public boolean setTemporaryPropertiesOfFocusedObjects() {
        return true;
    }

    @Override
    public boolean setChangedFocusedObjects() {
        return true;
    }

    private void initializePressedElement() {
        this.mPressedElement = null;
        this.mPressedElementOrigin = null;
    }

    @Override
    public boolean prepare() {
        this.mTemporaryProperties = this.getProperties();
        return true;
    }

    private SGValueRange calcRange(double d, double d2, double d3) {
        double d4 = d2 - d;
        double d5 = d;
        double d6 = d2;
        if (Math.abs(d2 - d) < Double.MIN_VALUE) {
            d5 = d - 1.0;
            d6 = d2 + 1.0;
        } else {
            double d7 = d3 * d4;
            d5 = d - d7;
            d6 = d2 + d7;
            d5 = SGUtilityNumber.getNumberInRangeOrder(d5, d, d2, 4, 4);
            d6 = SGUtilityNumber.getNumberInRangeOrder(d6, d, d2, 4, 4);
        }
        SGValueRange sGValueRange = new SGValueRange(d5, d6);
        return sGValueRange;
    }

    private String createTitleString(String string, int n) {
        String string2 = null;
        if (string == null || "".equals(string)) {
            switch (n) {
                case 0: {
                    string2 = "X Label";
                    break;
                }
                case 1: {
                    string2 = "X Label";
                    break;
                }
                case 2: {
                    string2 = "Y Label";
                    break;
                }
                case 3: {
                    string2 = "Y Label";
                    break;
                }
                case 4: {
                    string2 = "Z Label";
                    break;
                }
            }
        } else {
            string2 = SGUtility.addEscapeChar(string);
        }
        return string2;
    }

    private void createXYAxisGroups(SGTuple2d sGTuple2d, SGTuple2d sGTuple2d2, String string, String string2) {
        this.createAxisGroup(sGTuple2d, 0, string, true);
        this.createAxisGroup(sGTuple2d, 1, string, false);
        this.createAxisGroup(sGTuple2d2, 2, string2, true);
        this.createAxisGroup(sGTuple2d2, 3, string2, false);
    }

    private ElementsGroupOfAxis createAxisGroup(SGTuple2d sGTuple2d, int n, String string, boolean bl) {
        SGAxis sGAxis = new SGAxis(sGTuple2d);
        ElementsGroupOfAxis elementsGroupOfAxis = new ElementsGroupOfAxis();
        elementsGroupOfAxis.setLocationInPlane(n);
        elementsGroupOfAxis.mAxis = sGAxis;
        elementsGroupOfAxis.setAxisVisible(bl);
        elementsGroupOfAxis.setTitle(string);
        this.mElementsGroupList.add(elementsGroupOfAxis);
        return elementsGroupOfAxis;
    }

    private void setupXYAxisGroups(String string, String string2) {
        ElementsGroupOfAxis elementsGroupOfAxis = this.getAxisGroup(0);
        ElementsGroupOfAxis elementsGroupOfAxis2 = this.getAxisGroup(1);
        ElementsGroupOfAxis elementsGroupOfAxis3 = this.getAxisGroup(2);
        ElementsGroupOfAxis elementsGroupOfAxis4 = this.getAxisGroup(3);
        float f = this.getMagnification();
        elementsGroupOfAxis.setMagnification(f);
        elementsGroupOfAxis2.setMagnification(f);
        elementsGroupOfAxis3.setMagnification(f);
        elementsGroupOfAxis4.setMagnification(f);
        elementsGroupOfAxis.setTitle(string);
        elementsGroupOfAxis2.setTitle(string);
        elementsGroupOfAxis3.setTitle(string2);
        elementsGroupOfAxis4.setTitle(string2);
    }

    @Override
    public boolean addData(SGData sGData, String string) {
        if (!super.addData(sGData, string)) {
            return false;
        }
        SGData[] sGDataArray = new SGData[]{sGData};
        return this.setupAxes(sGDataArray);
    }

    private boolean setupAxes(SGData[] sGDataArray) {
        SGIDisposable sGIDisposable;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        if (this.mStartFlag) {
            Object object6;
            SGIDisposable sGIDisposable2;
            object5 = "";
            object4 = "";
            if (sGDataArray.length > 0 && sGDataArray[0] instanceof SGITwoDimensionalData) {
                object3 = (SGITwoDimensionalData)((Object)sGDataArray[0]);
                object5 = object3.getTitleX();
                if (object5 == null) {
                    object5 = "";
                }
                if ((object4 = object3.getTitleY()) == null) {
                    object4 = "";
                }
                if (sGDataArray.length > 1) {
                    int n;
                    for (n = 1; n < sGDataArray.length; ++n) {
                        if (!(sGDataArray[n] instanceof SGITwoDimensionalData)) continue;
                        sGIDisposable2 = (SGITwoDimensionalData)((Object)sGDataArray[n]);
                        object6 = sGIDisposable2.getTitleX();
                        if (object6 == null) {
                            object6 = "";
                        }
                        if (((String)object6).equals(object5)) continue;
                        object5 = "";
                        break;
                    }
                    for (n = 1; n < sGDataArray.length; ++n) {
                        if (!(sGDataArray[n] instanceof SGITwoDimensionalData)) continue;
                        sGIDisposable2 = (SGITwoDimensionalData)((Object)sGDataArray[n]);
                        object6 = sGIDisposable2.getTitleY();
                        if (object6 == null) {
                            object6 = "";
                        }
                        if (((String)object6).equals(object4)) continue;
                        object4 = "";
                        break;
                    }
                }
            }
            object3 = this.createTitleString((String)object5, 0);
            String string = this.createTitleString((String)object4, 2);
            this.setupXYAxisGroups((String)object3, string);
            if (sGDataArray.length == 1 && sGDataArray[0] instanceof SGISXYData && (sGIDisposable2 = (SGISXYData)((Object)sGDataArray[0])).isTickLabelAvailable()) {
                object6 = sGIDisposable2.isTickLabelHorizontal() != false ? this.getAxisGroup(0) : this.getAxisGroup(2);
                ((ElementsGroupOfAxis)object6).setNumbersVisible(false);
                ((ElementsGroupOfAxis)object6).setTickMarksVisible(false);
            }
            sGIDisposable2 = this.getAxisGroup(0);
            object6 = this.getAxisGroup(1);
            ElementsGroupOfAxis elementsGroupOfAxis = this.getAxisGroup(2);
            object2 = this.getAxisGroup(3);
            object = new HashMap<SGData, List<SGDataAxisInfo>>();
            for (int i = 0; i < sGDataArray.length; ++i) {
                if (!(sGDataArray[i] instanceof SGITwoDimensionalData)) continue;
                sGIDisposable = (SGITwoDimensionalData)((Object)sGDataArray[i]);
                SGValueRange sGValueRange = sGIDisposable.getBoundsX();
                SGValueRange sGValueRange2 = sGIDisposable.getBoundsY();
                ArrayList<SGDataAxisInfo> arrayList = new ArrayList<SGDataAxisInfo>();
                SGDataAxisInfo sGDataAxisInfo = new SGDataAxisInfo(sGDataArray[i], ((ElementsGroupOfAxis)sGIDisposable2).mAxis, sGValueRange, (String)object3, 0);
                SGDataAxisInfo sGDataAxisInfo2 = new SGDataAxisInfo(sGDataArray[i], elementsGroupOfAxis.mAxis, sGValueRange2, string, 2);
                arrayList.add(sGDataAxisInfo);
                arrayList.add(sGDataAxisInfo2);
                object.put(sGDataArray[i], arrayList);
            }
            this.fitAxes(sGDataArray, (Map<SGData, List<SGDataAxisInfo>>)object, (Map<SGData, SGISXYAxisShiftEnabled>)new HashMap<SGData, SGISXYAxisShiftEnabled>());
            ((ElementsGroupOfAxis)object6).mAxis.setScale(((ElementsGroupOfAxis)sGIDisposable2).getRange());
            ((ElementsGroupOfAxis)object2).mAxis.setScale(elementsGroupOfAxis.getRange());
            this.createAllDrawingElements();
        }
        if (!this.mColorBarAvailableFlag && sGDataArray.length > 0 && (object5 = sGDataArray[0]) instanceof SGIThreeDimensionalData) {
            double d;
            object4 = (SGIThreeDimensionalData)object5;
            object3 = object4.getBoundsZ();
            if (object3 == null) {
                return false;
            }
            double d2 = ((SGValueRange)object3).isMinValid() ? ((SGValueRange)object3).getMinValue() : -1.0;
            if (d2 == (d = ((SGValueRange)object3).isMaxValid() ? ((SGValueRange)object3).getMaxValue() : -1.0)) {
                d2 = -1.0;
                d = 1.0;
            }
            object2 = this.calcRange(d2, d, 0.0);
            object = null;
            String string = object5.getDataType();
            if (!string.equals("SXYZ") && !string.equals("SXYZ_NETCDF")) {
                throw new Error("Unsupported data type: " + object5.getDataType());
            }
            object = this.createTitleString(object4.getTitleZ(), 4);
            sGIDisposable = this.getColorBarModel();
            ((SGColorBarModel)sGIDisposable).setValueRange(((SGValueRange)object2).getMinValue(), ((SGValueRange)object2).getMaxValue());
            this.mZAxisElementsGroup.setTitle((String)object);
            this.mZAxisElementsGroup.setMagnification(this.getMagnification());
            float f = this.mGraphRectX;
            float f2 = this.mGraphRectY;
            float f3 = this.mGraphRectWidth;
            float f4 = this.mGraphRectHeight;
            this.mZAxisElementsGroup.setDirection("Horizontal Lower");
            this.mZAxisElementsGroup.setLocation(f, f2 + 1.2f * f4);
            this.mZAxisElementsGroup.setSize(f3 / this.mMagnification, 19.84252f);
            this.mZAxisElementsGroup.setAxisVisible(true);
            this.createAllDrawingElements();
            if (!this.mZAxisElementsGroup.initPropertiesHistory()) {
                return false;
            }
            this.mColorBarAvailableFlag = true;
        }
        return true;
    }

    private SGValueRange getRange(List<Double> list, List<Double> list2) {
        double d;
        double d2 = list.size() != 0 ? SGDataUtility.getMinValue(SGUtilityNumber.toArray(list)) : -1.0;
        if (d2 >= (d = list2.size() != 0 ? SGDataUtility.getMaxValue(SGUtilityNumber.toArray(list2)) : 1.0)) {
            d2 = -1.0;
            d = 1.0;
        }
        return new SGValueRange(d2, d);
    }

    @Override
    public boolean addData(SGData[] sGDataArray, String[] stringArray, Map<String, Object> map) {
        if (sGDataArray.length != stringArray.length) {
            return false;
        }
        for (int i = 0; i < sGDataArray.length; ++i) {
            if (super.addData(sGDataArray[i], stringArray[i])) continue;
            return false;
        }
        return this.setupAxes(sGDataArray);
    }

    @Override
    public boolean addData(SGData sGData, String string, SGProperties sGProperties) {
        if (!super.addData(sGData, string, sGProperties)) {
            return false;
        }
        if (sGData instanceof SGIThreeDimensionalData && sGData instanceof SGISXYZTypeData) {
            this.mColorBarAvailableFlag = true;
        }
        return true;
    }

    @Override
    public boolean setGraphRect(float f, float f2, float f3, float f4) {
        super.setGraphRect(f, f2, f3, f4);
        if (this.mTextField.isVisible() && !this.closeTextField()) {
            return false;
        }
        this.setLocationOfAllDrawingElements();
        return true;
    }

    @Override
    public boolean getMarginAroundGraphRect(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        if (!super.getMarginAroundGraphRect(sGTuple2f, sGTuple2f2)) {
            return false;
        }
        ElementsGroupOfAxis elementsGroupOfAxis = this.getAxisGroup(1);
        ElementsGroupOfAxis elementsGroupOfAxis2 = this.getAxisGroup(0);
        ElementsGroupOfAxis elementsGroupOfAxis3 = this.getAxisGroup(2);
        ElementsGroupOfAxis elementsGroupOfAxis4 = this.getAxisGroup(3);
        if (elementsGroupOfAxis == null || elementsGroupOfAxis2 == null || elementsGroupOfAxis3 == null || elementsGroupOfAxis4 == null) {
            return false;
        }
        Rectangle2D rectangle2D = elementsGroupOfAxis.getBoundingBox();
        Rectangle2D rectangle2D2 = elementsGroupOfAxis2.getBoundingBox();
        Rectangle2D rectangle2D3 = elementsGroupOfAxis3.getBoundingBox();
        Rectangle2D rectangle2D4 = elementsGroupOfAxis4.getBoundingBox();
        Rectangle2D rectangle2D5 = this.getGraphRect();
        ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
        arrayList.add(rectangle2D5);
        if (rectangle2D != null) {
            arrayList.add(rectangle2D);
        }
        if (rectangle2D2 != null) {
            arrayList.add(rectangle2D2);
        }
        if (rectangle2D3 != null) {
            arrayList.add(rectangle2D3);
        }
        if (rectangle2D4 != null) {
            arrayList.add(rectangle2D4);
        }
        if (this.mZAxisElementsGroup.isAxisVisible()) {
            arrayList.add(this.mZAxisElementsGroup.getBoundingBox());
        }
        Rectangle2D rectangle2D6 = SGUtility.createUnion(arrayList);
        float f = (float)(rectangle2D5.getY() - rectangle2D6.getY());
        float f2 = (float)(rectangle2D6.getY() + rectangle2D6.getHeight() - (rectangle2D5.getY() + rectangle2D5.getHeight()));
        float f3 = (float)(rectangle2D5.getX() - rectangle2D6.getX());
        float f4 = (float)(rectangle2D6.getX() + rectangle2D6.getWidth() - (rectangle2D5.getX() + rectangle2D5.getWidth()));
        sGTuple2f.x += f;
        sGTuple2f.y += f2;
        sGTuple2f2.x += f3;
        sGTuple2f2.y += f4;
        return true;
    }

    @Override
    public boolean setTitleFontName(String string) {
        this.mTitleFontName = string;
        this.mScaleFontName = string;
        return true;
    }

    @Override
    public boolean setTitleFontStyle(int n) {
        if (!SGUtilityText.isValidFontStyle(n)) {
            return false;
        }
        this.mTitleFontStyle = n;
        this.mScaleFontStyle = n;
        return true;
    }

    @Override
    public boolean setTitleFontSize(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("size < 0");
        }
        this.mTitleFontSize = f;
        this.mScaleFontSize = f;
        return true;
    }

    public boolean setAxisLineWidth(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("lw < 0.0f");
        }
        this.mAxisLineStroke.setLineWidth(f);
        return true;
    }

    @Override
    public boolean setAxisLineWidth(float f, String string) {
        Float f2 = SGUtility.getLineWidth(f, string);
        if (f2 == null) {
            return false;
        }
        return this.setAxisLineWidth(f2.floatValue());
    }

    @Override
    public boolean setFontColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color == null");
        }
        this.mAxisFontColor = color;
        return true;
    }

    public boolean setTitleFontSize(float f, String string) {
        Float f2 = SGUtility.getFontSize(f, string);
        if (f2 == null) {
            return false;
        }
        return this.setTitleFontSize(f2.floatValue());
    }

    public boolean setScaleFontSize(float f, String string) {
        Float f2 = SGUtility.getFontSize(f, string);
        if (f2 == null) {
            return false;
        }
        return this.setScaleFontSize(f2.floatValue());
    }

    public boolean setScaleFontSize(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("size < 0");
        }
        this.mScaleFontSize = f;
        return true;
    }

    public boolean setScaleFontStyle(int n) {
        if (!SGUtilityText.isValidFontStyle(n)) {
            return false;
        }
        this.mScaleFontStyle = n;
        return true;
    }

    public boolean setScaleFontName(String string) {
        this.mScaleFontName = string;
        return true;
    }

    public boolean setFrameLineWidth(float f) {
        this.mFrameLineStroke.setLineWidth(f);
        return true;
    }

    @Override
    public boolean setFrameLineWidth(float f, String string) {
        Float f2 = SGUtility.getLineWidth(f, string);
        if (f2 == null) {
            return false;
        }
        return this.setFrameLineWidth(f2.floatValue());
    }

    @Override
    public boolean setFrameLineColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("cl == null");
        }
        this.mFrameLineColor = color;
        return true;
    }

    @Override
    public boolean setSpaceAxisLineAndNumber(float f) {
        this.mSpaceAxisLineAndNumber = f;
        return true;
    }

    @Override
    public boolean setSpaceAxisLineAndNumber(float f, String string) {
        double d = SGUtilityText.convert(f, string, "cm");
        if (d < 0.0) {
            return false;
        }
        if (d > 5.0) {
            return false;
        }
        return this.setSpaceAxisLineAndNumber((float)SGUtilityText.convertToPoint(f, string));
    }

    @Override
    public boolean setSpaceNumberAndTitle(float f) {
        this.mSpaceNumberAndTitle = f;
        return true;
    }

    @Override
    public boolean setSpaceNumberAndTitle(float f, String string) {
        double d = SGUtilityText.convert(f, string, "cm");
        if (d < 0.0) {
            return false;
        }
        if (d > 5.0) {
            return false;
        }
        return this.setSpaceNumberAndTitle((float)SGUtilityText.convertToPoint(f, string));
    }

    @Override
    public float getSpaceAxisLineAndNumber() {
        return this.mSpaceAxisLineAndNumber;
    }

    @Override
    public float getSpaceNumberAndTitle() {
        return this.mSpaceNumberAndTitle;
    }

    @Override
    public boolean getFocusedObjectsList(List<SGISelectable> list) {
        if (this.mZAxisElementsGroup.isAxisVisible() && this.mZAxisElementsGroup.isSelected()) {
            list.add(this.mZAxisElementsGroup);
        }
        return true;
    }

    @Override
    public boolean hideSelectedObject(SGISelectable sGISelectable) {
        return true;
    }

    @Override
    public double getValue(int n, int n2, int n3) {
        ElementsGroupOfAxis elementsGroupOfAxis = this.getAxisGroup(n);
        SGAxis sGAxis = elementsGroupOfAxis.mAxis;
        double d = 0.0;
        if (n == 0 || n == 1) {
            d = this.calcValue(n2, sGAxis, true);
        } else if (n == 2 || n == 3) {
            d = this.calcValue(n3, sGAxis, false);
        } else {
            throw new Error();
        }
        d = this.getNumberInRangeOrder(d, sGAxis);
        return d;
    }

    @Override
    public void paintGraphics(Graphics graphics, boolean bl) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.mFrameLineVisibleFlag) {
            this.drawGraphAreaBoundsLines(graphics2D);
        }
        List<ElementsGroupOfAxis> list = this.getAxisGroupList();
        for (int i = 0; i < list.size(); ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = list.get(i);
            if (!elementsGroupOfAxis.isAxisVisible()) continue;
            elementsGroupOfAxis.paintGraphics2D(graphics2D);
        }
        if (this.isColorBarAvailable() && this.isColorBarVisible()) {
            this.mZAxisElementsGroup.paintGraphics2D(graphics2D);
        }
    }

    private boolean drawGraphAreaBoundsLines(Graphics2D graphics2D) {
        if (graphics2D == null) {
            return false;
        }
        graphics2D.setPaint(this.mFrameLineColor);
        graphics2D.setStroke(new BasicStroke(this.getFrameLineWidth()));
        graphics2D.drawRect((int)this.mGraphRectX, (int)this.mGraphRectY, (int)this.mGraphRectWidth, (int)this.mGraphRectHeight);
        return true;
    }

    private boolean drawStringBounds(SGDrawingElementString2D sGDrawingElementString2D, Graphics2D graphics2D) {
        if (sGDrawingElementString2D == null || graphics2D == null) {
            return false;
        }
        Color color = Color.BLACK;
        graphics2D.setPaint(color);
        graphics2D.setStroke(new BasicStroke(1.0f));
        Rectangle2D rectangle2D = sGDrawingElementString2D.getElementBounds();
        graphics2D.drawRect((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        return true;
    }

    private boolean drawString(SGDrawingElementString2D sGDrawingElementString2D, Graphics2D graphics2D) {
        if (sGDrawingElementString2D == null || graphics2D == null) {
            return false;
        }
        sGDrawingElementString2D.paint(graphics2D);
        return true;
    }

    private boolean drawLine(SGDrawingElementLine2D sGDrawingElementLine2D, Graphics2D graphics2D, BasicStroke basicStroke) {
        if (sGDrawingElementLine2D == null || graphics2D == null) {
            return false;
        }
        graphics2D.setPaint(sGDrawingElementLine2D.getColor());
        graphics2D.setStroke(basicStroke);
        SGTuple2f sGTuple2f = sGDrawingElementLine2D.getStart();
        SGTuple2f sGTuple2f2 = sGDrawingElementLine2D.getEnd();
        Line2D.Float float_ = new Line2D.Float(sGTuple2f.x, sGTuple2f.y, sGTuple2f2.x, sGTuple2f2.y);
        graphics2D.draw(float_);
        return true;
    }

    @Override
    public boolean isHorizontal(SGAxis sGAxis) {
        return this.getHorizontalAxisList().contains(sGAxis);
    }

    @Override
    public boolean isPerpendicular(SGAxis sGAxis) {
        return this.getPerpendicularAxisList().contains(sGAxis);
    }

    @Override
    public boolean isNormal(SGAxis sGAxis) {
        return this.mZAxisElementsGroup.mAxis.equals(sGAxis);
    }

    @Override
    public ArrayList getAxisList() {
        ArrayList<SGAxis> arrayList = new ArrayList<SGAxis>();
        List<ElementsGroupOfAxis> list = this.getAllAxisGroupList();
        for (int i = 0; i < list.size(); ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = list.get(i);
            arrayList.add(elementsGroupOfAxis.mAxis);
        }
        return arrayList;
    }

    @Override
    public ArrayList getHorizontalAxisList() {
        ArrayList<SGAxis> arrayList = new ArrayList<SGAxis>();
        for (int i = 0; i < this.mElementsGroupList.size(); ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = this.mElementsGroupList.get(i);
            int n = elementsGroupOfAxis.mLocationInPlane;
            if (n != 0 && n != 1) continue;
            arrayList.add(elementsGroupOfAxis.mAxis);
        }
        return arrayList;
    }

    @Override
    public ArrayList getPerpendicularAxisList() {
        ArrayList<SGAxis> arrayList = new ArrayList<SGAxis>();
        for (int i = 0; i < this.mElementsGroupList.size(); ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = this.mElementsGroupList.get(i);
            int n = elementsGroupOfAxis.mLocationInPlane;
            if (n != 2 && n != 3) continue;
            arrayList.add(elementsGroupOfAxis.mAxis);
        }
        return arrayList;
    }

    @Override
    public ArrayList getNormalAxisList() {
        ArrayList<SGAxis> arrayList = new ArrayList<SGAxis>();
        arrayList.add(this.mZAxisElementsGroup.mAxis);
        return arrayList;
    }

    @Override
    public SGAxis getAxisInPlane(int n) {
        ElementsGroupOfAxis elementsGroupOfAxis = this.getAxisGroup(n);
        if (elementsGroupOfAxis == null) {
            return null;
        }
        return elementsGroupOfAxis.mAxis;
    }

    @Override
    public SGIAxisPanelObserver getAxisPanelObserverInPlane(int n) {
        return this.getAxisGroup(n);
    }

    private ElementsGroupOfAxis getAxisGroup(int n) {
        List<ElementsGroupOfAxis> list = this.getAllAxisGroupList();
        for (int i = 0; i < list.size(); ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = list.get(i);
            if (elementsGroupOfAxis.getLocation() != n) continue;
            return elementsGroupOfAxis;
        }
        return null;
    }

    @Override
    public String getLocationName(SGAxis sGAxis) {
        int n = this.getLocationInPlane(sGAxis);
        return this.getLocationName(n);
    }

    @Override
    public String getLocationName(int n) {
        return SGUtility.getLocationName(n);
    }

    public int getLocationInPlane(String string) {
        return SGUtility.getLocationInPlane(string);
    }

    public String getLocationStringInPlane(SGAxis sGAxis) {
        int n = this.getLocationInPlane(sGAxis);
        return this.getLocationName(n);
    }

    @Override
    public int getLocationInPlane(SGAxis sGAxis) {
        if (sGAxis == null) {
            throw new IllegalArgumentException("axis==null");
        }
        for (int i = 0; i < this.mElementsGroupList.size(); ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = this.mElementsGroupList.get(i);
            if (!sGAxis.equals(elementsGroupOfAxis.mAxis)) continue;
            return elementsGroupOfAxis.mLocationInPlane;
        }
        return -1;
    }

    @Override
    public SGAxis getAxis(String string) {
        SGAxis sGAxis = this.getAxisGroup((String)string).mAxis;
        return sGAxis;
    }

    @Override
    public String getClassDescription() {
        return "Axes";
    }

    @Override
    public ArrayList getPropertyDialogObserverList() {
        ArrayList<SGIPropertyDialogObserver> arrayList = new ArrayList<SGIPropertyDialogObserver>();
        if (this.mPropertyDialog.equals(this.mCurrentPropertyDialog)) {
            arrayList.add(this);
        } else if (this.mZAxisElementsGroup.isAxisVisible() && this.mZAxisElementsGroup.isSelected()) {
            arrayList.add(this.mZAxisElementsGroup);
        }
        return arrayList;
    }

    @Override
    public ArrayList getChildNodes() {
        return new ArrayList();
    }

    @Override
    public SGPropertyDialog getPropertyDialog() {
        return this.mPropertyDialog;
    }

    private boolean isEditing() {
        return this.mTextField.isVisible();
    }

    @Override
    public boolean commit() {
        SGProperties sGProperties = this.mTemporaryProperties;
        SGProperties sGProperties2 = this.getProperties();
        if (!sGProperties.equals(sGProperties2)) {
            this.setChanged(true);
        }
        this.mTemporaryProperties = null;
        this.createAllDrawingElements();
        this.repaint();
        this.notifyChange();
        return true;
    }

    @Override
    public boolean cancel() {
        if (!this.setProperties(this.mTemporaryProperties)) {
            return false;
        }
        this.mTemporaryProperties = null;
        this.createAllDrawingElements();
        this.repaint();
        this.notifyChange();
        return true;
    }

    @Override
    public boolean preview() {
        if (!this.createAllDrawingElements()) {
            return false;
        }
        this.repaint();
        this.notifyChange();
        return true;
    }

    @Override
    public boolean setMementoBackward() {
        boolean bl = super.setMementoBackward();
        if (!bl) {
            return false;
        }
        this.createAllDrawingElements();
        this.notifyChangeOnUndo();
        return true;
    }

    @Override
    public boolean setMementoForward() {
        boolean bl = super.setMementoForward();
        if (!bl) {
            return false;
        }
        this.createAllDrawingElements();
        this.notifyChangeOnUndo();
        return true;
    }

    private float getMaxLengthOfScaleNumbers(ElementsGroupOfAxis elementsGroupOfAxis) {
        ArrayList arrayList = elementsGroupOfAxis.mNumberList;
        double d = Double.MIN_VALUE;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGDrawingElementString2D sGDrawingElementString2D = (SGDrawingElementString2D)arrayList.get(i);
            Rectangle2D rectangle2D = sGDrawingElementString2D.getElementBounds();
            double d2 = rectangle2D.getWidth();
            if (!(d2 > d)) continue;
            d = d2;
        }
        return (float)d;
    }

    private boolean createAllDrawingElements() {
        List<ElementsGroupOfAxis> list = this.getAllAxisGroupList();
        for (int i = 0; i < list.size(); ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = list.get(i);
            if (elementsGroupOfAxis.createDrawingElements()) continue;
            return false;
        }
        return true;
    }

    private boolean setLocationOfAllDrawingElements() {
        List<ElementsGroupOfAxis> list = this.getAllAxisGroupList();
        for (int i = 0; i < list.size(); ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = list.get(i);
            if (elementsGroupOfAxis.setLocationOfDrawingElements()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getTagName() {
        return "Axes";
    }

    @Override
    public Element[] createElement(Document document) {
        Element element = this.createThisElement(document);
        if (element == null) {
            return null;
        }
        List<ElementsGroupOfAxis> list = this.getAxisGroupList();
        for (int i = 0; i < list.size(); ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = list.get(i);
            Element element2 = elementsGroupOfAxis.createElement(document);
            if (element2 == null) {
                return null;
            }
            element.appendChild(element2);
        }
        Element element3 = this.mZAxisElementsGroup.createElement(document);
        if (element3 == null) {
            return null;
        }
        return new Element[]{element, element3};
    }

    @Override
    public boolean createDataObject(Element element, SGData sGData, boolean bl) {
        if (!super.createDataObject(element, sGData, bl)) {
            return false;
        }
        if (sGData instanceof SGIThreeDimensionalData && sGData instanceof SGISXYZTypeData) {
            this.mColorBarAvailableFlag = true;
        }
        this.mStartFlag = false;
        return true;
    }

    @Override
    public boolean writeProperty(Element element) {
        float f = (float)SGUtilityNumber.roundOffNumber(this.getAxisLineWidth(), -3);
        float f2 = (float)SGUtilityNumber.roundOffNumber(this.getTickMarkWidth(), -3);
        float f3 = (float)SGUtilityNumber.roundOffNumber(this.mTickMarkLength * 0.035277776f, -3);
        float f4 = (float)SGUtilityNumber.roundOffNumber(this.mTitleFontSize, -3);
        float f5 = (float)SGUtilityNumber.roundOffNumber(this.getFrameLineWidth(), -3);
        element.setAttribute("AxisLineWidth", Float.toString(f) + "pt");
        element.setAttribute("TickMarkWidth", Float.toString(f2) + "pt");
        element.setAttribute("TickMarkLength", Float.toString(f3) + "cm");
        element.setAttribute("LineColor", SGUtilityText.getColorString(this.mLineColor));
        element.setAttribute("StringColor", SGUtilityText.getColorString(this.mAxisFontColor));
        element.setAttribute("FontName", this.mTitleFontName);
        element.setAttribute("FontSize", Float.toString(f4) + "pt");
        element.setAttribute("FontStyle", SGUtilityText.getFontStyleName(this.mTitleFontStyle));
        element.setAttribute("FrameLineVisible", Boolean.toString(this.mFrameLineVisibleFlag));
        element.setAttribute("FrameLineWidth", Float.toString(f5) + "pt");
        element.setAttribute("FrameLineColor", SGUtilityText.getColorString(this.mFrameLineColor));
        return true;
    }

    @Override
    public boolean readProperty(Element element) {
        Element element2;
        Object object;
        Object object2;
        Node node;
        if (!this.setCommonProperties(element)) {
            return false;
        }
        this.mStartFlag = false;
        NodeList nodeList = element.getElementsByTagName("Axis");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            object2 = (Element)node;
            object = object2.getAttribute("Position");
            if (((String)object).length() == 0) {
                return false;
            }
            int n = this.getLocationInPlane((String)object);
            if (n == -1) {
                return false;
            }
            ElementsGroupOfAxis elementsGroupOfAxis = this.getAxisGroup(n);
            if (!elementsGroupOfAxis.readProperties((Element)object2)) {
                return false;
            }
            if (elementsGroupOfAxis.createDrawingElements()) continue;
            return false;
        }
        Node node2 = element.getParentNode();
        node = (Element)node2;
        object2 = node.getElementsByTagName("ColorBar");
        if (object2.getLength() > 0 && (object = object2.item(0)) instanceof Element && !this.mZAxisElementsGroup.readProperties(element2 = (Element)object)) {
            return false;
        }
        return this.createAllDrawingElements();
    }

    private boolean setCommonProperties(Element element) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        String string = null;
        Number number = null;
        Color color = null;
        Boolean bl4 = null;
        string = element.getAttribute("AxisLineWidth");
        if (string.length() == 0) {
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer();
        number = SGUtilityText.getNumber(string, stringBuffer);
        if (number == null) {
            return false;
        }
        float f = number.floatValue();
        string = element.getAttribute("TickMarkWidth");
        if (string.length() == 0) {
            return false;
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        number = SGUtilityText.getNumber(string, stringBuffer2);
        if (number == null) {
            return false;
        }
        float f2 = number.floatValue();
        string = element.getAttribute("TickMarkLength");
        if (string.length() == 0) {
            return false;
        }
        StringBuffer stringBuffer3 = new StringBuffer();
        number = SGUtilityText.getNumber(string, stringBuffer3);
        if (number == null) {
            return false;
        }
        float f3 = number.floatValue();
        string = element.getAttribute("LineColor");
        if (string.length() == 0) {
            return false;
        }
        Color color2 = SGUtilityText.parseColor(string);
        String string2 = string = element.getAttribute("FontName");
        String string3 = string = element.getAttribute("TitleFontName");
        String string4 = string = element.getAttribute("ScaleFontName");
        if (string2.length() != 0) {
            bl3 = true;
        } else if (string3.length() != 0 && string4.length() != 0) {
            bl3 = false;
        } else {
            return false;
        }
        String string5 = string = element.getAttribute("FontStyle");
        String string6 = string = element.getAttribute("TitleFontStyle");
        String string7 = string = element.getAttribute("ScaleFontStyle");
        if (string5.length() != 0) {
            bl2 = true;
        } else if (string6.length() != 0 && string7.length() != 0) {
            bl2 = false;
        } else {
            return false;
        }
        Integer n = null;
        Integer n2 = null;
        Integer n3 = null;
        if (bl2) {
            n = SGUtilityText.getFontStyle(string5);
            if (n == null) {
                return false;
            }
        } else {
            n2 = SGUtilityText.getFontStyle(string6);
            if (n2 == null) {
                return false;
            }
            n3 = SGUtilityText.getFontStyle(string7);
            if (n3 == null) {
                return false;
            }
        }
        String string8 = string = element.getAttribute("FontSize");
        String string9 = string = element.getAttribute("TitleFontSize");
        String string10 = string = element.getAttribute("ScaleFontSize");
        if (string8.length() != 0) {
            bl = true;
        } else if (string9.length() != 0 && string10.length() != 0) {
            bl = false;
        } else {
            return false;
        }
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        StringBuffer stringBuffer4 = new StringBuffer();
        StringBuffer stringBuffer5 = new StringBuffer();
        StringBuffer stringBuffer6 = new StringBuffer();
        if (bl) {
            number = SGUtilityText.getNumber(string8, stringBuffer4);
            if (number == null) {
                return false;
            }
            f4 = number.floatValue();
        } else {
            number = SGUtilityText.getNumber(string9, stringBuffer5);
            if (number == null) {
                return false;
            }
            f5 = number.floatValue();
            number = SGUtilityText.getNumber(string10, stringBuffer6);
            if (number == null) {
                return false;
            }
            f6 = number.floatValue();
        }
        string = element.getAttribute("StringColor");
        if (string.length() == 0) {
            return false;
        }
        color = SGUtilityText.parseColor(string);
        if (color == null) {
            return false;
        }
        Color color3 = color;
        string = element.getAttribute("FrameLineVisible");
        if (string.length() == 0) {
            return false;
        }
        bl4 = SGUtilityText.getBoolean(string);
        if (bl4 == null) {
            return false;
        }
        boolean bl5 = bl4;
        string = element.getAttribute("FrameLineWidth");
        if (string.length() == 0) {
            return false;
        }
        StringBuffer stringBuffer7 = new StringBuffer();
        number = SGUtilityText.getNumber(string, stringBuffer7);
        if (number == null) {
            return false;
        }
        float f7 = number.floatValue();
        string = element.getAttribute("FrameLineColor");
        if (string.length() == 0) {
            return false;
        }
        color = SGUtilityText.parseColor(string);
        if (color == null) {
            return false;
        }
        Color color4 = color;
        if (!this.setAxisLineWidth(f, stringBuffer.toString())) {
            return false;
        }
        if (!this.setTickMarkWidth(f2, stringBuffer2.toString())) {
            return false;
        }
        if (!this.setTickMarkLength(f3, stringBuffer3.toString())) {
            return false;
        }
        if (!this.setLineColor(color2)) {
            return false;
        }
        if (!this.setFontColor(color3)) {
            return false;
        }
        if (bl3) {
            if (!this.setTitleFontName(string2)) {
                return false;
            }
            if (!this.setScaleFontName(string2)) {
                return false;
            }
        } else {
            if (!this.setTitleFontName(string3)) {
                return false;
            }
            if (!this.setScaleFontName(string4)) {
                return false;
            }
        }
        if (bl2) {
            if (!this.setTitleFontStyle(n)) {
                return false;
            }
            if (!this.setScaleFontStyle(n)) {
                return false;
            }
        } else {
            if (!this.setTitleFontStyle(n2)) {
                return false;
            }
            if (!this.setScaleFontStyle(n3)) {
                return false;
            }
        }
        if (bl) {
            if (!this.setTitleFontSize(f4, stringBuffer4.toString())) {
                return false;
            }
            if (!this.setScaleFontSize(f4, stringBuffer4.toString())) {
                return false;
            }
        } else {
            if (!this.setTitleFontSize(f5, stringBuffer5.toString())) {
                return false;
            }
            if (!this.setScaleFontSize(f6, stringBuffer6.toString())) {
                return false;
            }
        }
        if (!this.setFrameVisible(bl5)) {
            return false;
        }
        if (!this.setFrameLineWidth(f7, stringBuffer7.toString())) {
            return false;
        }
        return this.setFrameLineColor(color4);
    }

    private ElementsGroupOfAxis getAxisGroup(String string) {
        int n = -1;
        if (SGUtilityText.isEqualString("Bottom", string)) {
            n = 0;
        } else if (SGUtilityText.isEqualString("Top", string)) {
            n = 1;
        } else if (SGUtilityText.isEqualString("Left", string)) {
            n = 2;
        } else if (SGUtilityText.isEqualString("Right", string)) {
            n = 3;
        } else if (SGUtilityText.isEqualString("ColorBar", string)) {
            n = 4;
        }
        return this.getAxisGroup(n);
    }

    @Override
    public SGProperties getProperties() {
        List<ElementsGroupOfAxis> list = this.getAxisGroupList();
        AxisProperties axisProperties = new AxisProperties();
        axisProperties.cp = this.getCommonProperties();
        axisProperties.ipArray = new AxisIndividualProperties[list.size()];
        for (int i = 0; i < axisProperties.ipArray.length; ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = list.get(i);
            axisProperties.ipArray[i] = (AxisIndividualProperties)elementsGroupOfAxis.getProperties();
        }
        return axisProperties;
    }

    @Override
    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof AxisProperties)) {
            return false;
        }
        AxisProperties axisProperties = (AxisProperties)sGProperties;
        if (!this.setCommonProperties(axisProperties.cp)) {
            return false;
        }
        AxisIndividualProperties[] axisIndividualPropertiesArray = axisProperties.ipArray;
        for (int i = 0; i < axisIndividualPropertiesArray.length; ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = this.getAxisGroup(axisIndividualPropertiesArray[i].location);
            if (elementsGroupOfAxis.setProperties(axisIndividualPropertiesArray[i])) continue;
            return false;
        }
        return true;
    }

    private AxisCommonProperties getCommonProperties() {
        AxisCommonProperties axisCommonProperties = new AxisCommonProperties();
        axisCommonProperties.frameLinesVisibleFlag = this.mFrameLineVisibleFlag;
        axisCommonProperties.frameLineWidth = this.getFrameLineWidth();
        axisCommonProperties.frameLineColor = this.mFrameLineColor;
        axisCommonProperties.lineColor = this.mLineColor;
        axisCommonProperties.axisLineWidth = this.getAxisLineWidth();
        axisCommonProperties.tickMarkWidth = this.getTickMarkWidth();
        axisCommonProperties.tickMarkLength = this.mTickMarkLength;
        axisCommonProperties.stringColor = this.mAxisFontColor;
        axisCommonProperties.titleFontName = this.mTitleFontName;
        axisCommonProperties.titleFontStyle = this.mTitleFontStyle;
        axisCommonProperties.titleFontSize = this.mTitleFontSize;
        axisCommonProperties.scaleFontName = this.mScaleFontName;
        axisCommonProperties.scaleFontStyle = this.mScaleFontStyle;
        axisCommonProperties.scaleFontSize = this.mScaleFontSize;
        return axisCommonProperties;
    }

    private boolean setCommonProperties(AxisCommonProperties axisCommonProperties) {
        this.setFrameVisible(axisCommonProperties.frameLinesVisibleFlag);
        this.setFrameLineWidth(axisCommonProperties.frameLineWidth);
        this.setFrameLineColor(axisCommonProperties.frameLineColor);
        this.setLineColor(axisCommonProperties.lineColor);
        this.setAxisLineWidth(axisCommonProperties.axisLineWidth);
        this.setTickMarkWidth(axisCommonProperties.tickMarkWidth);
        this.setTickMarkLength(axisCommonProperties.tickMarkLength);
        this.setFontColor(axisCommonProperties.stringColor);
        this.setTitleFontName(axisCommonProperties.titleFontName);
        this.setTitleFontStyle(axisCommonProperties.titleFontStyle);
        this.setTitleFontSize(axisCommonProperties.titleFontSize);
        this.setScaleFontName(axisCommonProperties.scaleFontName);
        this.setScaleFontStyle(axisCommonProperties.scaleFontStyle);
        this.setScaleFontSize(axisCommonProperties.scaleFontSize);
        return true;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        char c = keyEvent.getKeyChar();
        if (object.equals(this.mTextField) && c == '\u001b') {
            this.hideEditField();
            this.mEditingStringElement = null;
        }
    }

    @Override
    public boolean setDialogOwner(Frame frame) {
        if (!super.setDialogOwner(frame)) {
            return false;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (SGFigureElementAxis.this.mPropertyDialog == null) {
                    SGFigureElementAxis.this.mPropertyDialog = new SGAxisDialog(SGFigureElementAxis.this.mDialogOwner, true, new int[]{0, 1, 2, 3});
                    SGFigureElementAxis.this.mColorBarPropertyDialog = new SGColorBarDialog(SGFigureElementAxis.this.mDialogOwner, true);
                }
            }
        });
        return true;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateLabelTextField();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateLabelTextField();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateLabelTextField();
    }

    private void updateLabelTextField() {
        Font font = new Font(this.getTitleFontName(), this.getTitleFontStyle(), (int)(this.getTitleFontSize() * this.getMagnification()));
        this.updateTextField(this.mTextField, font);
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
    }

    @Override
    public void onMenuSelected() {
        if (this.mTextField.isVisible()) {
            this.closeTextField();
        }
    }

    @Override
    public SGAxis getZAxis() {
        return this.mZAxisElementsGroup.mAxis;
    }

    private List<ElementsGroupOfAxis> getAxisGroupList() {
        ArrayList<ElementsGroupOfAxis> arrayList = new ArrayList<ElementsGroupOfAxis>();
        arrayList.addAll(this.mElementsGroupList);
        return arrayList;
    }

    private List<ElementsGroupOfAxis> getAllAxisGroupList() {
        List<ElementsGroupOfAxis> list = this.getAxisGroupList();
        if (this.mZAxisElementsGroup != null) {
            list.add(0, this.mZAxisElementsGroup);
        }
        return list;
    }

    @Override
    public boolean isAxisAvailable(String string) {
        if ("ColorBar".equals(string)) {
            return true;
        }
        return "Bottom".equals(string) || "Top".equals(string) || "Left".equals(string) || "Right".equals(string);
    }

    @Override
    public SGColorBarModel getColorBarModel() {
        return this.mColorBarModel;
    }

    protected ArrayList getUndoableChildList() {
        ArrayList<ElementsGroupColorBar> arrayList = new ArrayList<ElementsGroupColorBar>();
        arrayList.add(this.mZAxisElementsGroup);
        return arrayList;
    }

    @Override
    public SGIColorBar getColorBar() {
        return this.mZAxisElementsGroup;
    }

    @Override
    public boolean isColorBarVisible() {
        return this.mZAxisElementsGroup.isAxisVisible();
    }

    @Override
    public boolean setColorBarVisible(boolean bl) {
        return this.mZAxisElementsGroup.setAxisVisible(bl);
    }

    @Override
    public boolean isColorBarAvailable() {
        return this.mColorBarAvailableFlag;
    }

    @Override
    public boolean fitAxisRangeToFocusedData(SGIFigureElementForData sGIFigureElementForData) {
        List<SGData> list = sGIFigureElementForData.getFocusedDataList();
        return this.fitAxisRangeToData(sGIFigureElementForData, list);
    }

    @Override
    public boolean fitAxisRangeToData(SGIFigureElementForData sGIFigureElementForData, List<SGData> list) {
        Object object;
        List<SGIChildObject> list2 = sGIFigureElementForData.getVisibleChildList();
        HashMap<SGData, SGISXYAxisShiftEnabled> hashMap = new HashMap<SGData, SGISXYAxisShiftEnabled>();
        for (int i = 0; i < list2.size(); ++i) {
            SGIChildObject sGIChildObject = list2.get(i);
            if (!(sGIChildObject instanceof SGElementGroupSetInGraph) || !((object = (SGElementGroupSetInGraph)sGIChildObject) instanceof SGISXYAxisShiftEnabled)) continue;
            hashMap.put(((SGElementGroupSetInFigureElement)object).getData(), (SGISXYAxisShiftEnabled)object);
        }
        HashMap<SGData, List<SGDataAxisInfo>> hashMap2 = new HashMap<SGData, List<SGDataAxisInfo>>();
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            List<SGDataAxisInfo> list3 = sGIFigureElementForData.getAxisInfoList((SGData)object);
            hashMap2.put((SGData)object, list3);
        }
        SGData[] sGDataArray = new SGData[list.size()];
        list.toArray(sGDataArray);
        object = this.fitAxes(sGDataArray, hashMap2, hashMap);
        boolean bl = ((FitAxisResult)object).axesChanged;
        boolean bl2 = ((FitAxisResult)object).colorBarChanged;
        if (bl || bl2) {
            this.createAllDrawingElements();
            this.notifyChange();
            if (bl) {
                this.setChanged(true);
            }
            if (bl2 && this.isColorBarAvailable()) {
                this.mZAxisElementsGroup.setChanged(true);
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private FitAxisResult fitAxes(SGData[] sGDataArray, Map<SGData, List<SGDataAxisInfo>> map, Map<SGData, SGISXYAxisShiftEnabled> map2) {
        boolean bl;
        void var15_27;
        double d;
        Object object;
        Cloneable cloneable;
        int n;
        FitAxisResult fitAxisResult = new FitAxisResult();
        boolean bl2 = true;
        for (n = 0; n < sGDataArray.length; ++n) {
            if (sGDataArray[n] instanceof SGISXYData) continue;
            bl2 = false;
            break;
        }
        n = 1;
        for (int i = 0; i < sGDataArray.length; ++i) {
            cloneable = sGDataArray[i];
            if (cloneable instanceof SGIVXYTypeData) continue;
            n = 0;
            break;
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        cloneable = new ArrayList();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        ArrayList<Double> arrayList3 = new ArrayList<Double>();
        HashMap hashMap = new HashMap();
        for (SGData sGData : sGDataArray) {
            SGAxis sGAxis;
            SGValueRange sGValueRange;
            List<SGDataAxisInfo> list = map.get(sGData);
            for (SGDataAxisInfo sGDataAxisInfo : list) {
                SGISXYAxisShiftEnabled sGISXYAxisShiftEnabled;
                sGValueRange = sGDataAxisInfo.getRange();
                sGAxis = sGDataAxisInfo.getAxis();
                ArrayList<SGValueRange> arrayList4 = (ArrayList<SGValueRange>)hashMap.get(sGAxis);
                if (arrayList4 == null) {
                    arrayList4 = new ArrayList<SGValueRange>();
                    hashMap.put(sGAxis, arrayList4);
                }
                if (null != (sGISXYAxisShiftEnabled = map2.get(sGData))) {
                    Object object2;
                    Double d2 = sGISXYAxisShiftEnabled.getShiftMinValue(sGAxis);
                    Double d3 = sGISXYAxisShiftEnabled.getShiftMaxValue(sGAxis);
                    object = sGValueRange.getRange();
                    d = ((SGTuple2d)object).x;
                    double d4 = ((SGTuple2d)object).y;
                    if (null != d2) {
                        d += d2.doubleValue();
                    }
                    if (null != d3) {
                        d4 += d3.doubleValue();
                    }
                    if (null != (object2 = sGISXYAxisShiftEnabled.getBarBaselineForAxis(sGAxis))) {
                        if (d > (Double)object2) {
                            d = (Double)object2;
                        }
                        if (d4 < (Double)object2) {
                            d4 = (Double)object2;
                        }
                    }
                    sGValueRange.setRange(d, d4);
                }
                arrayList4.add(sGValueRange);
            }
            if (n == 0) continue;
            for (SGDataAxisInfo sGDataAxisInfo : list) {
                sGValueRange = sGDataAxisInfo.getRange();
                sGAxis = sGDataAxisInfo.getAxis();
                if (this.isHorizontal(sGAxis)) {
                    arrayList.add(sGValueRange.getMinValue());
                    cloneable.add(sGValueRange.getMaxValue());
                    continue;
                }
                if (!this.isPerpendicular(sGAxis)) continue;
                arrayList2.add(sGValueRange.getMinValue());
                arrayList3.add(sGValueRange.getMaxValue());
            }
        }
        if (n != 0) {
            SGValueRange sGValueRange;
            SGValueRange sGValueRange2;
            double[] bl22 = SGUtilityNumber.toArray(arrayList);
            double[] dArray = SGUtilityNumber.toArray((List<Double>)((Object)cloneable));
            double[] dArray2 = SGUtilityNumber.toArray(arrayList2);
            double[] dArray3 = SGUtilityNumber.toArray(arrayList3);
            double d5 = SGUtilityNumber.min(bl22);
            double d6 = SGUtilityNumber.max(dArray);
            double d7 = SGUtilityNumber.min(dArray2);
            double d8 = d6 - d5;
            double d9 = SGUtilityNumber.max(dArray3);
            d = d9 - d7;
            if (d8 < d) {
                sGValueRange2 = this.calcRange(d5, d5 + d, 0.0);
                sGValueRange = this.calcRange(d7, d9, 0.0);
            } else {
                sGValueRange2 = this.calcRange(d5, d6, 0.0);
                sGValueRange = this.calcRange(d7, d7 + d8, 0.0);
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                List list;
                SGAxis sGAxis = (SGAxis)entry.getKey();
                if (this.isHorizontal(sGAxis)) {
                    list = (List)entry.getValue();
                    for (SGValueRange sGValueRange3 : list) {
                        sGValueRange3.setRange(sGValueRange2);
                    }
                    continue;
                }
                if (!this.isPerpendicular(sGAxis)) continue;
                list = (List)entry.getValue();
                for (SGValueRange sGValueRange3 : list) {
                    sGValueRange3.setRange(sGValueRange);
                }
            }
        }
        boolean bl3 = false;
        int n2 = 0;
        List<ElementsGroupOfAxis> list = this.getAllAxisGroupList();
        boolean bl4 = false;
        while (var15_27 < list.size()) {
            ElementsGroupOfAxis elementsGroupOfAxis = list.get((int)var15_27);
            SGAxis sGAxis = elementsGroupOfAxis.mAxis;
            List list2 = (List)hashMap.get(sGAxis);
            if (list2 != null) {
                boolean bl5 = false;
                boolean bl6 = false;
                double d10 = Double.MAX_VALUE;
                double d11 = -1.7976931348623157E308;
                for (int i = 0; i < list2.size(); ++i) {
                    SGValueRange sGValueRange = (SGValueRange)list2.get(i);
                    double d12 = sGValueRange.getMinValue();
                    double d13 = sGValueRange.getMaxValue();
                    if (!Double.isNaN(d12) && d12 < d10) {
                        d10 = d12;
                        bl5 = true;
                    }
                    if (Double.isNaN(d13) || !(d13 > d11)) continue;
                    d11 = d13;
                    bl6 = true;
                }
                if (!bl5 && !bl6) {
                    d10 = -1.0;
                    d11 = 1.0;
                } else {
                    if (!bl5) {
                        d10 = d11 - 1.0;
                    }
                    if (!bl6) {
                        d11 = d10 + 1.0;
                    }
                }
                object = null;
                if (bl2) {
                    if (this.isHorizontal(sGAxis)) {
                        object = this.calcRange(d10, d11, 0.0);
                    } else if (this.isPerpendicular(sGAxis)) {
                        object = this.calcRange(d10, d11, 0.05);
                    }
                } else if (n != 0) {
                    object = this.calcRange(d10, d11, 0.1);
                }
                if (object != null) {
                    d10 = ((SGValueRange)object).getMinValue();
                    d11 = ((SGValueRange)object).getMaxValue();
                }
                if (d10 >= d11) {
                    d10 = -1.0;
                    d11 = 1.0;
                }
                SGTuple2d sGTuple2d = sGAxis.getRange();
                SGTuple2d sGTuple2d2 = new SGTuple2d(d10, d11);
                if (sGAxis.isValidValue(d10) && sGAxis.isValidValue(d11)) {
                    sGAxis.setScale(sGTuple2d2);
                    if (!sGTuple2d2.equals(sGTuple2d)) {
                        bl = true;
                        if (this.isColorBarAvailable() && sGAxis.equals(this.mZAxisElementsGroup.mAxis)) {
                            n2 = 1;
                        }
                    }
                }
            }
            ++var15_27;
        }
        fitAxisResult.axesChanged = bl;
        fitAxisResult.colorBarChanged = n2;
        return fitAxisResult;
    }

    private boolean synchronizeAxis(SGIFigureElementForData sGIFigureElementForData, SGData sGData) {
        Object object;
        int n;
        Object object2;
        List<SGDataAxisInfo> list = sGIFigureElementForData.getAxisInfoList(sGData);
        List<ElementsGroupOfAxis> list2 = this.getAllAxisGroupList();
        for (int i = 0; i < list2.size(); ++i) {
            object2 = list2.get(i);
            for (n = 0; n < list.size(); ++n) {
                object = list.get(n);
                if (!((SGDataAxisInfo)object).getAxis().equals(((ElementsGroupOfAxis)object2).mAxis)) continue;
                String string = ((SGDataAxisInfo)object).getTitle();
                int n2 = ((SGDataAxisInfo)object).getLocation();
                String string2 = this.createTitleString(string, n2);
                ((ElementsGroupOfAxis)object2).setTitle(string2);
            }
        }
        if (sGData instanceof SGISXYData) {
            SGISXYData sGISXYData = (SGISXYData)((Object)sGData);
            object2 = sGISXYData.isTickLabelHorizontal();
            if (sGISXYData.isTickLabelAvailable()) {
                for (n = 0; n < list2.size(); ++n) {
                    object = list2.get(n);
                    for (int i = 0; i < list.size(); ++i) {
                        SGDataAxisInfo sGDataAxisInfo = list.get(i);
                        if (!sGDataAxisInfo.getAxis().equals(((ElementsGroupOfAxis)object).mAxis)) continue;
                        boolean bl = this.isHorizontal(((ElementsGroupOfAxis)object).mAxis) != ((Boolean)object2).booleanValue();
                        ((ElementsGroupOfAxis)object).setNumbersVisible(bl);
                        ((ElementsGroupOfAxis)object).setTickMarksVisible(bl);
                    }
                }
            }
        }
        return this.createAllDrawingElements();
    }

    private void synchronizeDataColumnChange(SGIFigureElementForData sGIFigureElementForData, String string) {
        if ("Data columns are changed on preview".equals(string) || "Data columns are changed on commit".equals(string)) {
            List<SGData> list;
            if (this.mTemporaryProperties == null) {
                this.mTemporaryProperties = this.getProperties();
            }
            if ((list = sGIFigureElementForData.getFocusedDataList()).size() != 1) {
                if (list.size() == 0) {
                    this.mTemporaryProperties = null;
                    return;
                }
                throw new Error("Data column selection for multiple data is not supported. dList.size=" + list.size());
            }
            SGICopiable sGICopiable = list.get(0);
            this.fitAxisRangeToData(sGIFigureElementForData, list);
            this.synchronizeAxis(sGIFigureElementForData, (SGData)sGICopiable);
            if ("Data columns are changed on commit".equals(string)) {
                sGICopiable = this.getProperties();
                if (!sGICopiable.equals(this.mTemporaryProperties)) {
                    this.setChanged(true);
                }
                this.mTemporaryProperties = null;
            }
        } else if ("Data columns are changed on cancel".equals(string)) {
            this.setProperties(this.mTemporaryProperties);
            this.createAllDrawingElements();
            this.notifyChange();
            this.repaint();
            this.mTemporaryProperties = null;
        }
    }

    @Override
    public SGPropertyResults setProperties(SGPropertyMap sGPropertyMap) {
        SGPropertyResults sGPropertyResults = new SGPropertyResults();
        if (!this.prepare()) {
            return null;
        }
        Iterator<String> iterator = sGPropertyMap.getKeyIterator();
        while (iterator.hasNext()) {
            Number number;
            Object object;
            String string = iterator.next();
            String string2 = sGPropertyMap.getValueString(string);
            if ("FontName".equalsIgnoreCase(string)) {
                object = SGUtility.findFontFamilyName(string2);
                if (object == null) {
                    sGPropertyResults.putResult("FontName", 1);
                    continue;
                }
                if (!this.setTitleFontName((String)object)) {
                    sGPropertyResults.putResult("FontName", 1);
                    continue;
                }
                sGPropertyResults.putResult("FontName", 0);
                continue;
            }
            if ("FontStyle".equalsIgnoreCase(string)) {
                object = SGUtilityText.getFontStyle(string2);
                if (object == null) {
                    sGPropertyResults.putResult("FontStyle", 1);
                    continue;
                }
                if (!this.setTitleFontStyle((Integer)object)) {
                    sGPropertyResults.putResult("FontStyle", 1);
                    continue;
                }
                sGPropertyResults.putResult("FontStyle", 0);
                continue;
            }
            if ("FontSize".equalsIgnoreCase(string)) {
                object = new StringBuffer();
                number = SGUtilityText.getNumber(string2, (StringBuffer)object);
                if (number == null) {
                    sGPropertyResults.putResult("FontSize", 1);
                    continue;
                }
                if (!this.setTitleFontSize(number.floatValue(), ((StringBuffer)object).toString())) {
                    sGPropertyResults.putResult("FontSize", 1);
                    continue;
                }
                sGPropertyResults.putResult("FontSize", 0);
                continue;
            }
            if ("FontColor".equalsIgnoreCase(string)) {
                object = SGUtilityText.getColor(string2);
                if (object != null) {
                    if (!this.setFontColor((Color)object)) {
                        sGPropertyResults.putResult("FontColor", 1);
                        continue;
                    }
                } else {
                    object = SGUtilityText.parseColor(string2);
                    if (object == null) {
                        sGPropertyResults.putResult("FontColor", 1);
                        continue;
                    }
                    if (!this.setFontColor((Color)object)) {
                        sGPropertyResults.putResult("FontColor", 1);
                        continue;
                    }
                }
                sGPropertyResults.putResult("FontColor", 0);
                continue;
            }
            if ("FrameVisible".equalsIgnoreCase(string)) {
                object = SGUtilityText.getBoolean(string2);
                if (object == null) {
                    sGPropertyResults.putResult("FrameVisible", 1);
                    continue;
                }
                if (!this.setFrameVisible((Boolean)object)) {
                    sGPropertyResults.putResult("FrameVisible", 1);
                    continue;
                }
                sGPropertyResults.putResult("FrameVisible", 0);
                continue;
            }
            if ("FrameLineWidth".equalsIgnoreCase(string)) {
                object = new StringBuffer();
                number = SGUtilityText.getNumber(string2, (StringBuffer)object);
                if (number == null) {
                    sGPropertyResults.putResult("FrameLineWidth", 1);
                    continue;
                }
                if (!this.setFrameLineWidth(number.floatValue(), ((StringBuffer)object).toString())) {
                    sGPropertyResults.putResult("FrameLineWidth", 1);
                    continue;
                }
                sGPropertyResults.putResult("FrameLineWidth", 0);
                continue;
            }
            if ("FrameColor".equalsIgnoreCase(string)) {
                object = SGUtilityText.getColor(string2);
                if (object != null) {
                    if (!this.setFrameLineColor((Color)object)) {
                        sGPropertyResults.putResult("FrameColor", 1);
                        continue;
                    }
                } else {
                    object = SGUtilityText.parseColor(string2);
                    if (object == null) {
                        sGPropertyResults.putResult("FrameColor", 1);
                        continue;
                    }
                    if (!this.setFrameLineColor((Color)object)) {
                        sGPropertyResults.putResult("FrameColor", 1);
                        continue;
                    }
                }
                sGPropertyResults.putResult("FrameColor", 0);
                continue;
            }
            if ("LineWidth".equalsIgnoreCase(string)) {
                object = new StringBuffer();
                number = SGUtilityText.getNumber(string2, (StringBuffer)object);
                if (number == null) {
                    sGPropertyResults.putResult("LineWidth", 1);
                    continue;
                }
                if (!this.setAxisLineWidth(number.floatValue(), ((StringBuffer)object).toString())) {
                    sGPropertyResults.putResult("LineWidth", 1);
                    continue;
                }
                sGPropertyResults.putResult("LineWidth", 0);
                continue;
            }
            if ("TickMarkWidth".equalsIgnoreCase(string)) {
                object = new StringBuffer();
                number = SGUtilityText.getNumber(string2, (StringBuffer)object);
                if (number == null) {
                    sGPropertyResults.putResult("TickMarkWidth", 1);
                    continue;
                }
                if (!this.setTickMarkWidth(number.floatValue(), ((StringBuffer)object).toString())) {
                    sGPropertyResults.putResult("TickMarkWidth", 1);
                    continue;
                }
                sGPropertyResults.putResult("TickMarkWidth", 0);
                continue;
            }
            if ("TickMarkLength".equalsIgnoreCase(string)) {
                object = new StringBuffer();
                number = SGUtilityText.getNumber(string2, (StringBuffer)object);
                if (number == null) {
                    sGPropertyResults.putResult("TickMarkLength", 1);
                    continue;
                }
                if (!this.setTickMarkLength(number.floatValue(), ((StringBuffer)object).toString())) {
                    sGPropertyResults.putResult("TickMarkLength", 1);
                    continue;
                }
                sGPropertyResults.putResult("TickMarkLength", 0);
                continue;
            }
            if (!"LineColor".equalsIgnoreCase(string)) continue;
            object = SGUtilityText.getColor(string2);
            if (object != null) {
                if (!this.setLineColor((Color)object)) {
                    sGPropertyResults.putResult("LineColor", 1);
                    continue;
                }
            } else {
                object = SGUtilityText.parseColor(string2);
                if (object == null) {
                    sGPropertyResults.putResult("LineColor", 1);
                    continue;
                }
                if (!this.setLineColor((Color)object)) {
                    sGPropertyResults.putResult("LineColor", 1);
                    continue;
                }
            }
            sGPropertyResults.putResult("LineColor", 0);
        }
        if (!this.commit()) {
            return null;
        }
        this.notifyToRoot();
        this.notifyChange();
        this.repaint();
        return sGPropertyResults;
    }

    @Override
    public SGPropertyResults setChildProperties(int n, SGPropertyMap sGPropertyMap) {
        List<ElementsGroupOfAxis> list = this.getAllAxisGroupList();
        for (ElementsGroupOfAxis elementsGroupOfAxis : list) {
            if (elementsGroupOfAxis.getLocation() != n) continue;
            return elementsGroupOfAxis.setProperties(sGPropertyMap);
        }
        return null;
    }

    static class FitAxisResult {
        boolean axesChanged = true;
        boolean colorBarChanged = true;

        FitAxisResult() {
        }
    }

    public static class ColorBarProperties
    extends AxisIndividualProperties {
        SGAxis xAxis = null;
        SGAxis yAxis = null;
        float x;
        float y;
        float barWidth;
        float barLength;
        float toScale;
        float toTitle;
        String direction;
        boolean reversedOrder;
        String colorBarStyle;
        float frameLineWidth;
        float tickMarkWidth;
        float tickMarkLength;
        Color lineColor;
        String fontName;
        int fontStyle;
        float fontSize;
        Color fontColor;

        public void dispose() {
            this.xAxis = null;
            this.yAxis = null;
            this.lineColor = null;
            this.fontColor = null;
            this.colorBarStyle = null;
            this.fontName = null;
            super.dispose();
        }

        public boolean equals(Object object) {
            if (!(object instanceof ColorBarProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            ColorBarProperties colorBarProperties = (ColorBarProperties)object;
            if (this.xAxis != null ? !this.xAxis.equals(colorBarProperties.xAxis) : colorBarProperties.xAxis != null) {
                return false;
            }
            if (this.yAxis != null ? !this.yAxis.equals(colorBarProperties.yAxis) : colorBarProperties.yAxis != null) {
                return false;
            }
            if (this.x != colorBarProperties.x) {
                return false;
            }
            if (this.y != colorBarProperties.y) {
                return false;
            }
            if (this.barWidth != colorBarProperties.barWidth) {
                return false;
            }
            if (this.barLength != colorBarProperties.barLength) {
                return false;
            }
            if (this.toScale != colorBarProperties.toScale) {
                return false;
            }
            if (this.toTitle != colorBarProperties.toTitle) {
                return false;
            }
            if (this.direction != colorBarProperties.direction) {
                return false;
            }
            if (this.colorBarStyle != null ? !this.colorBarStyle.equals(colorBarProperties.colorBarStyle) : colorBarProperties.colorBarStyle != null) {
                return false;
            }
            if (this.reversedOrder != colorBarProperties.reversedOrder) {
                return false;
            }
            if (this.frameLineWidth != colorBarProperties.frameLineWidth) {
                return false;
            }
            if (this.tickMarkWidth != colorBarProperties.tickMarkWidth) {
                return false;
            }
            if (this.tickMarkLength != colorBarProperties.tickMarkLength) {
                return false;
            }
            if (this.lineColor != null ? !this.lineColor.equals(colorBarProperties.lineColor) : colorBarProperties.lineColor != null) {
                return false;
            }
            if (this.fontName != null ? !this.fontName.equals(colorBarProperties.fontName) : colorBarProperties.fontName != null) {
                return false;
            }
            if (this.fontStyle != colorBarProperties.fontStyle) {
                return false;
            }
            if (this.fontSize != colorBarProperties.fontSize) {
                return false;
            }
            return !(this.fontColor != null ? !this.fontColor.equals(colorBarProperties.fontColor) : colorBarProperties.fontColor != null);
        }
    }

    private class ElementsGroupColorBar
    extends ElementsGroupOfAxis
    implements SGIColorBar,
    SGISelectable,
    SGIMovable,
    SGIColorBarDialogObserver,
    SGIColorBarConstants,
    SGIFigureConstants,
    SGIUndoable {
        float mX;
        float mY;
        float mBarWidth;
        float mBarLength;
        float mSpaceAxisLineAndNumber;
        float mSpaceNumberAndTitle;
        String mDirection;
        Color mLineColor;
        float mFrameLineWidth;
        float mTickMarkLength;
        Color mFontColor;
        String mTitleFontName;
        float mTitleFontSize;
        int mTitleFontStyle;
        String mScaleFontName;
        float mScaleFontSize;
        int mScaleFontStyle;
        boolean mSelectedFlag;
        SGAxis mXAxis;
        SGAxis mYAxis;
        SGStroke mTickMarkStroke;
        private SGProperties mTemporaryProperties;
        private SGUndoManager mUndoManager;

        ElementsGroupColorBar() {
            this.mX = 0.0f;
            this.mY = 0.0f;
            this.mBarWidth = 0.0f;
            this.mBarLength = 0.0f;
            this.mDirection = "Horizontal Lower";
            this.mLineColor = SGIAxisConstants.DEFAULT_LINE_COLOR;
            this.mFrameLineWidth = 1.5f;
            this.mTickMarkLength = 1.5f;
            this.mFontColor = SGIAxisConstants.DEFAULT_FONT_COLOR;
            this.mTitleFontName = "Serif";
            this.mTitleFontSize = 16.0f;
            this.mTitleFontStyle = 0;
            this.mScaleFontName = "Serif";
            this.mScaleFontSize = 16.0f;
            this.mScaleFontStyle = 0;
            this.mSelectedFlag = false;
            this.mXAxis = null;
            this.mYAxis = null;
            this.mTickMarkStroke = new SGStroke();
            this.mTemporaryProperties = null;
            this.mUndoManager = new SGUndoManager(this);
            this.init();
        }

        private void init() {
            SGAxis sGAxis = SGFigureElementAxis.this.getAxis("Bottom");
            SGAxis sGAxis2 = SGFigureElementAxis.this.getAxis("Left");
            this.mXAxis = sGAxis;
            this.mYAxis = sGAxis2;
            this.setFrameLineWidth(1.5f, "pt");
            this.setTickMarkWidth(1.5f, "pt");
            this.setTickMarkLength(0.25f, "cm");
            this.setLineColor(SGIAxisConstants.DEFAULT_LINE_COLOR);
            this.setFontColor(SGIAxisConstants.DEFAULT_FONT_COLOR);
            this.setFontName("Serif");
            this.setFontSize(16.0f, "pt");
            this.setFontStyle(0);
            this.setBarWidth(0.7f, "cm");
            this.setBarLength(8.0f, "cm");
            this.setSpaceToScale(0.2f, "cm");
            this.setSpaceToTitle(0.2f, "cm");
        }

        protected JPopupMenu createPopupMenu() {
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.setBounds(0, 0, 100, 100);
            jPopupMenu.add(new JLabel("  -- Color Bar --"));
            jPopupMenu.addSeparator();
            SGUtility.addItem(jPopupMenu, this, "Hide");
            jPopupMenu.addSeparator();
            SGUtility.addItem(jPopupMenu, this, "Property");
            return jPopupMenu;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            String string = actionEvent.getActionCommand();
            if (string.equals("Hide")) {
                this.mVisibleFlag = false;
                SGFigureElementAxis.this.repaint();
                this.setChanged(true);
                this.notifyToRoot();
                return;
            }
        }

        protected ElementStringOfScale createSingleTickMarkInstance(String string) {
            ElementStringOfScale elementStringOfScale = new ElementStringOfScale(string, this.mScaleFontName, this.mScaleFontStyle, this.mScaleFontSize, this.mFontColor, SGFigureElementAxis.this.mMagnification, this.mNumbersAngle, this.getLocationInPlane());
            return elementStringOfScale;
        }

        protected SGDrawingElementString2DExtended createExponentStringElement(String string) {
            SGDrawingElementString2DExtended sGDrawingElementString2DExtended = new SGDrawingElementString2DExtended(string, this.mScaleFontName, this.mScaleFontStyle, this.mScaleFontSize, this.mFontColor, SGFigureElementAxis.this.mMagnification, 0.0f);
            return sGDrawingElementString2DExtended;
        }

        protected int getLocationInPlane() {
            if ("Horizontal Lower".equals(this.mDirection)) {
                return 10;
            }
            if ("Horizontal Upper".equals(this.mDirection)) {
                return 11;
            }
            if ("Perpendicular Left".equals(this.mDirection)) {
                return 12;
            }
            if ("Perpendicular Right".equals(this.mDirection)) {
                return 13;
            }
            return -1;
        }

        protected int getLocation() {
            return 4;
        }

        protected boolean setAxisLineProperties() {
            for (int i = 0; i < this.mAxisLines.length; ++i) {
                this.mAxisLines[i].setLineWidth(this.mFrameLineWidth);
                this.mAxisLines[i].setColor(this.mLineColor);
            }
            return true;
        }

        protected boolean setTitleProperties() {
            this.mTitle.setColor(this.mFontColor);
            this.mTitle.setFont(this.mTitleFontName, this.mTitleFontStyle, this.mTitleFontSize);
            return true;
        }

        protected ElementLineOfAxis[] createAxisLines() {
            ElementLineOfAxis[] elementLineOfAxisArray = new ElementLineOfAxis[4];
            for (int i = 0; i < elementLineOfAxisArray.length; ++i) {
                elementLineOfAxisArray[i] = new ElementLineOfAxis();
            }
            return elementLineOfAxisArray;
        }

        protected boolean createTickMarks() {
            this.mTickMarksList.clear();
            float f = this.mTickMarkStroke.getLineWidth();
            boolean bl = true;
            switch (this.mAxis.getScaleType()) {
                case 0: {
                    bl = this.createTickMarksInLinearScale(f, this.mTickMarkLength, this.mLineColor);
                    break;
                }
                case 1: {
                    bl = this.createTickMarksInLogScale(f, this.mTickMarkLength, this.mLineColor);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            return bl;
        }

        public void setLocation(float f, float f2) {
            this.mX = (f - SGFigureElementAxis.this.mGraphRectX) / SGFigureElementAxis.this.mMagnification;
            this.mY = (f2 - SGFigureElementAxis.this.mGraphRectY) / SGFigureElementAxis.this.mMagnification;
        }

        public void setSize(float f, float f2) {
            this.mBarLength = f;
            this.mBarWidth = f2;
        }

        public float getX() {
            return SGFigureElementAxis.this.mGraphRectX + this.mX * SGFigureElementAxis.this.mMagnification;
        }

        public float getY() {
            return SGFigureElementAxis.this.mGraphRectY + this.mY * SGFigureElementAxis.this.mMagnification;
        }

        public float getLength() {
            return this.mBarLength * SGFigureElementAxis.this.mMagnification;
        }

        public float getBarWidth() {
            return this.mBarWidth * SGFigureElementAxis.this.mMagnification;
        }

        public Rectangle2D getColorBarRectangle() {
            double d;
            double d2;
            double d3 = this.getLength();
            double d4 = this.getBarWidth();
            if ("Horizontal Lower".equals(this.mDirection) || "Horizontal Upper".equals(this.mDirection)) {
                d2 = d3;
                d = d4;
            } else if ("Perpendicular Left".equals(this.mDirection) || "Perpendicular Right".equals(this.mDirection)) {
                d2 = d4;
                d = d3;
            } else {
                throw new Error();
            }
            Rectangle2D.Double double_ = new Rectangle2D.Double(this.getX(), this.getY(), d2, d);
            return double_;
        }

        public void paintGraphics2D(Graphics2D graphics2D) {
            double d;
            double d2;
            int n;
            int n2;
            double d3;
            double d4;
            double d5;
            double d6;
            if (!this.mVisibleFlag) {
                return;
            }
            Rectangle2D rectangle2D = this.getColorBarRectangle();
            double d7 = this.getBarWidth();
            if ("Horizontal Lower".equals(this.mDirection) || "Horizontal Upper".equals(this.mDirection)) {
                d6 = rectangle2D.getMinX();
                d5 = rectangle2D.getMinY();
                d4 = 1.0;
                d3 = d7;
                n2 = (int)d6;
                n = (int)rectangle2D.getMaxX();
                d2 = 1.0;
                d = 0.0;
            } else if ("Perpendicular Left".equals(this.mDirection) || "Perpendicular Right".equals(this.mDirection)) {
                d6 = rectangle2D.getMinX();
                d5 = rectangle2D.getMaxY();
                d4 = d7;
                d3 = 1.0;
                n2 = (int)d5;
                n = (int)rectangle2D.getMinY();
                d2 = 0.0;
                d = -1.0;
            } else {
                throw new Error();
            }
            double d8 = SGFigureElementAxis.this.mColorBarModel.getMinValue();
            double d9 = SGFigureElementAxis.this.mColorBarModel.getMaxValue();
            double d10 = d9 - d8;
            Rectangle2D.Double double_ = new Rectangle2D.Double();
            int n3 = Math.abs(n - n2);
            for (int i = 0; i <= n3; ++i) {
                ((Rectangle2D)double_).setRect(d6 + d2 * (double)i, d5 + d * (double)i, d4, d3);
                double d11 = (double)i / (double)n3;
                if (this.mAxis.isInvertCoordinates()) {
                    d11 = 1.0 - d11;
                }
                double d12 = d8 + d11 * d10;
                Color color = SGFigureElementAxis.this.mColorBarModel.evaluate(d12, 0);
                graphics2D.setColor(color);
                graphics2D.fill(double_);
            }
            super.paintGraphics2D(graphics2D);
            if (SGFigureElementAxis.this.mSymbolsVisibleFlagAroundFocusedObjects && this.isSelected()) {
                ArrayList arrayList = this.getAnchorPointList();
                SGUtilityForFigureElementJava2D.drawAnchorAsFocusedObject(arrayList, graphics2D);
            }
            if (SGFigureElementAxis.this.mSymbolsVisibleFlagAroundAllObjects) {
                ArrayList arrayList = this.getAnchorPointList();
                SGUtilityForFigureElementJava2D.drawAnchorAsChildObject(arrayList, graphics2D);
            }
        }

        private ArrayList getAnchorPointList() {
            ArrayList<Point2D.Float> arrayList = new ArrayList<Point2D.Float>();
            Rectangle2D rectangle2D = this.getColorBarRectangle();
            float f = (float)rectangle2D.getX();
            float f2 = (float)rectangle2D.getY();
            float f3 = (float)rectangle2D.getWidth();
            float f4 = (float)rectangle2D.getHeight();
            Point2D.Float float_ = new Point2D.Float(f, f2);
            Point2D.Float float_2 = new Point2D.Float(f, f2 + f4);
            Point2D.Float float_3 = new Point2D.Float(f + f3, f2);
            Point2D.Float float_4 = new Point2D.Float(f + f3, f2 + f4);
            arrayList.add(float_);
            arrayList.add(float_2);
            arrayList.add(float_3);
            arrayList.add(float_4);
            return arrayList;
        }

        public boolean onMousePressed(MouseEvent mouseEvent) {
            if (super.onMousePressed(mouseEvent)) {
                return true;
            }
            Rectangle2D rectangle2D = this.getColorBarRectangle();
            if (rectangle2D.contains(mouseEvent.getPoint())) {
                this.prepare();
                return true;
            }
            return false;
        }

        public boolean onMouseReleased(MouseEvent mouseEvent) {
            if (!this.mVisibleFlag) {
                return false;
            }
            if (this.mTempRange != null || this.mDraggingElement != null) {
                this.mTempRange = null;
                this.mDraggingElement = null;
                if (!SGFigureElementAxis.this.createAllDrawingElements()) {
                    return false;
                }
                SGFigureElementAxis.this.initializePressedElement();
                SGProperties sGProperties = this.mTemporaryProperties;
                SGProperties sGProperties2 = this.getProperties();
                if (!sGProperties.equals(sGProperties2)) {
                    this.setChanged(true);
                }
                this.mTemporaryProperties = null;
                return true;
            }
            if (this.mTemporaryProperties != null) {
                SGProperties sGProperties = this.mTemporaryProperties;
                SGProperties sGProperties3 = this.getProperties();
                if (!sGProperties.equals(sGProperties3)) {
                    this.setChanged(true);
                }
                this.mTemporaryProperties = null;
                return true;
            }
            return false;
        }

        public boolean onDrawingElement(int n, int n2) {
            if (!this.mVisibleFlag) {
                return false;
            }
            if (super.onDrawingElement(n, n2)) {
                return true;
            }
            Rectangle2D rectangle2D = this.getColorBarRectangle();
            return rectangle2D.contains(n, n2);
        }

        public boolean onMouseClicked(MouseEvent mouseEvent) {
            if (!this.mVisibleFlag) {
                return false;
            }
            if (super.onMouseClicked(mouseEvent)) {
                return true;
            }
            Rectangle2D rectangle2D = this.getColorBarRectangle();
            if (rectangle2D.contains(mouseEvent.getPoint())) {
                SGFigureElementAxis.this.updateFocusedObjectsList((SGISelectable)this, mouseEvent);
                if (this.clicked(mouseEvent)) {
                    return true;
                }
            }
            return false;
        }

        public boolean onMouseDragged(MouseEvent mouseEvent) {
            if (!this.mVisibleFlag) {
                return false;
            }
            if (SGFigureElementAxis.this.mPressedPoint == null) {
                return false;
            }
            int n = ((SGFigureElementAxis)SGFigureElementAxis.this).mPressedPoint.x;
            int n2 = ((SGFigureElementAxis)SGFigureElementAxis.this).mPressedPoint.y;
            if (this.isSelected() && this.mDraggingElement == null && SGFigureElementAxis.this.mPressedElement == null) {
                int n3 = mouseEvent.getX() - n;
                int n4 = mouseEvent.getY() - n2;
                this.translate(n3, n4);
                SGFigureElementAxis.this.mPressedPoint = mouseEvent.getPoint();
                this.createDrawingElements();
                return true;
            }
            if (!super.onMouseDragged(mouseEvent)) {
                return false;
            }
            SGFigureElementAxis.this.mColorBarModel.setValueRange(this.mAxis.getMinValue(), this.mAxis.getMaxValue());
            return true;
        }

        public void setSelected(boolean bl) {
            this.mSelectedFlag = bl;
        }

        public boolean isSelected() {
            return this.mSelectedFlag;
        }

        protected boolean setLocationOfAxisLines() {
            if ("Horizontal Lower".equals(this.mDirection) || "Horizontal Upper".equals(this.mDirection)) {
                float f = this.getX();
                float f2 = this.getY();
                float f3 = f + this.getLength();
                float f4 = f2 + this.getBarWidth();
                this.mAxisLines[0].setTermPoints(f, f2, f3, f2);
                this.mAxisLines[1].setTermPoints(f, f2, f, f4);
                this.mAxisLines[2].setTermPoints(f, f4, f3, f4);
                this.mAxisLines[3].setTermPoints(f3, f2, f3, f4);
            } else if ("Perpendicular Left".equals(this.mDirection) || "Perpendicular Right".equals(this.mDirection)) {
                float f = this.getX();
                float f5 = this.getY();
                float f6 = f + this.getBarWidth();
                float f7 = f5 + this.getLength();
                this.mAxisLines[0].setTermPoints(f, f7, f, f5);
                this.mAxisLines[1].setTermPoints(f, f7, f6, f7);
                this.mAxisLines[2].setTermPoints(f6, f7, f6, f5);
                this.mAxisLines[3].setTermPoints(f, f5, f6, f5);
            } else {
                throw new Error();
            }
            return true;
        }

        protected ElementLineOfScale createSingleTickMark(double d, float f, float f2) {
            SGTuple2f sGTuple2f;
            SGTuple2f sGTuple2f2;
            double d2;
            double d3;
            double d4;
            if (!this.mAxis.insideRange(d)) {
                return null;
            }
            float f3 = SGFigureElementAxis.this.mMagnification;
            boolean bl = this.isTickMarksInside();
            boolean bl2 = this.isInvertCoordinates();
            switch (this.mAxis.getScaleType()) {
                case 0: {
                    d4 = this.mAxis.getMinValue();
                    d3 = this.mAxis.getMaxValue();
                    d2 = d;
                    break;
                }
                case 1: {
                    d4 = Math.log(this.mAxis.getMinValue());
                    d3 = Math.log(this.mAxis.getMaxValue());
                    d2 = Math.log(d);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            ElementLineOfColorBarScale elementLineOfColorBarScale = null;
            float f4 = this.getLength();
            if ("Horizontal Lower".equals(this.mDirection) || "Horizontal Upper".equals(this.mDirection)) {
                double d5 = bl2 ? (double)this.getX() + (double)f4 * (d3 - d2) / (d3 - d4) : (double)this.getX() + (double)f4 * (d2 - d4) / (d3 - d4);
                double d6 = this.getY() + this.getBarWidth();
                double d7 = bl ? d6 - (double)f2 : d6 + (double)f2;
                sGTuple2f2 = new SGTuple2f((float)d5, (float)d6);
                sGTuple2f = new SGTuple2f((float)d5, (float)d7);
            } else if ("Perpendicular Left".equals(this.mDirection) || "Perpendicular Right".equals(this.mDirection)) {
                double d8 = bl2 ? (double)this.getY() + (double)f4 * (1.0 - (d3 - d2) / (d3 - d4)) : (double)this.getY() + (double)f4 * (1.0 - (d2 - d4) / (d3 - d4));
                double d9 = this.getX();
                double d10 = bl ? d9 + (double)f2 : d9 - (double)f2;
                sGTuple2f2 = new SGTuple2f((float)d9, (float)d8);
                sGTuple2f = new SGTuple2f((float)d10, (float)d8);
            } else {
                throw new Error();
            }
            elementLineOfColorBarScale = new ElementLineOfColorBarScale(sGTuple2f2, sGTuple2f);
            elementLineOfColorBarScale.setLineWidth(f);
            elementLineOfColorBarScale.setMagnification(f3);
            return elementLineOfColorBarScale;
        }

        protected ElementLineOfScale createSingleTickMarkCounter(double d, float f, float f2) {
            ElementLineOfScale elementLineOfScale = this.createSingleTickMark(d, f, f2);
            if (elementLineOfScale == null) {
                return null;
            }
            SGTuple2f sGTuple2f = elementLineOfScale.getStart();
            SGTuple2f sGTuple2f2 = elementLineOfScale.getEnd();
            boolean bl = this.isTickMarksInside();
            if ("Horizontal Lower".equals(this.mDirection) || "Horizontal Upper".equals(this.mDirection)) {
                double d2 = sGTuple2f.y - this.getBarWidth();
                double d3 = bl ? d2 + (double)f2 : d2 - (double)f2;
                sGTuple2f.y = (float)d2;
                sGTuple2f2.y = (float)d3;
            } else if ("Perpendicular Left".equals(this.mDirection) || "Perpendicular Right".equals(this.mDirection)) {
                double d4 = sGTuple2f.x + this.getBarWidth();
                double d5 = bl ? d4 - (double)f2 : d4 + (double)f2;
                sGTuple2f.x = (float)d4;
                sGTuple2f2.x = (float)d5;
            } else {
                throw new Error();
            }
            return elementLineOfScale;
        }

        protected boolean setLocationOfTitle() {
            float f = SGFigureElementAxis.this.mMagnification;
            float f2 = this.mSpaceAxisLineAndNumber * f;
            float f3 = this.mSpaceNumberAndTitle * f;
            float f4 = this.getBarWidth();
            float f5 = 0.0f;
            float f6 = 0.0f;
            f5 = (float)this.getScaleHeight();
            f6 = SGFigureElementAxis.this.getMaxLengthOfScaleNumbers(this);
            Rectangle2D rectangle2D = this.mTitle.getElementBounds();
            if ("Horizontal Lower".equals(this.mDirection) || "Horizontal Upper".equals(this.mDirection)) {
                this.mTitle.setAngle(0.0f);
                float f7 = this.getX() + (this.getLength() - (float)rectangle2D.getWidth()) / 2.0f;
                float f8 = "Horizontal Lower".equals(this.mDirection) ? this.getY() + f4 + f2 + f5 + f3 : this.getY() - (f2 + f5 + f3 + (float)rectangle2D.getHeight());
                this.mTitle.setLocation(f7, f8);
            } else if ("Perpendicular Left".equals(this.mDirection) || "Perpendicular Right".equals(this.mDirection)) {
                this.mTitle.setAngle(90.0f);
                float f9 = this.getY() + (this.getLength() + (float)rectangle2D.getHeight()) / 2.0f;
                float f10 = "Perpendicular Left".equals(this.mDirection) ? this.getX() - (f2 + f6 + f3 + (float)rectangle2D.getWidth()) : this.getX() + f4 + (f2 + f6 + f3);
                this.mTitle.setLocation(f10, f9);
            } else {
                throw new Error();
            }
            return true;
        }

        protected boolean setLocationOfScaleNumbers() {
            boolean bl = this.isInvertCoordinates();
            int n = this.mAxis.getScaleType();
            float f = SGFigureElementAxis.this.mMagnification;
            float f2 = this.mSpaceAxisLineAndNumber * f;
            double[] dArray = null;
            if (n == 0) {
                dArray = this.mAxisValueArray;
            } else if (n == 1) {
                dArray = new double[this.mAxisValueArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    dArray[i] = Math.log(this.mAxisValueArray[i]);
                }
            }
            double d = 0.0;
            double d2 = 0.0;
            if (n == 0) {
                d = this.mAxis.getMinValue();
                d2 = this.mAxis.getMaxValue();
            } else if (n == 1) {
                d = Math.log(this.mAxis.getMinValue());
                d2 = Math.log(this.mAxis.getMaxValue());
            }
            float f3 = this.getBarWidth();
            float f4 = this.getLength();
            for (int i = 0; i < this.mNumberList.size(); ++i) {
                float f5;
                float f6;
                ElementStringOfScale elementStringOfScale = (ElementStringOfScale)this.mNumberList.get(i);
                Rectangle2D rectangle2D = elementStringOfScale.getElementBounds();
                float f7 = (float)rectangle2D.getWidth();
                float f8 = (float)rectangle2D.getHeight();
                if ("Horizontal Lower".equals(this.mDirection) || "Horizontal Upper".equals(this.mDirection)) {
                    f6 = bl ? (float)((double)this.getX() + (double)f4 * (d2 - dArray[i]) / (d2 - d)) : (float)((double)this.getX() + (double)f4 * (dArray[i] - d) / (d2 - d));
                    f5 = "Horizontal Lower".equals(this.mDirection) ? this.getY() + f3 + f2 : this.getY() - f2 - (float)rectangle2D.getHeight();
                    elementStringOfScale.setLocation(f6 - 0.5f * f7, f5);
                    continue;
                }
                if ("Perpendicular Left".equals(this.mDirection) || "Perpendicular Right".equals(this.mDirection)) {
                    f6 = bl ? (float)((double)this.getY() + (double)f4 * (1.0 - (d2 - dArray[i]) / (d2 - d))) : (float)((double)this.getY() + (double)f4 * (1.0 - (dArray[i] - d) / (d2 - d)));
                    f5 = "Perpendicular Left".equals(this.mDirection) ? (float)((double)(this.getX() - f2) - rectangle2D.getWidth()) : this.getX() + f3 + f2;
                    elementStringOfScale.setLocation(f5, f6 - 0.5f * f8);
                    continue;
                }
                throw new Error();
            }
            if (this.getExponentFlag()) {
                this.setLocationOfExponentDrawingElement();
            }
            return true;
        }

        protected boolean setLocationOfExponentDrawingElement() {
            SGDrawingElementString2DExtended sGDrawingElementString2DExtended = this.mExponentDrawingElement;
            Rectangle2D rectangle2D = ((SGDrawingElementString2D)sGDrawingElementString2DExtended).getElementBounds();
            float f = SGFigureElementAxis.this.mMagnification;
            float f2 = this.mSpaceAxisLineAndNumber * f;
            float f3 = this.mSpaceNumberAndTitle * f;
            float f4 = this.getLength();
            float f5 = this.getBarWidth();
            float f6 = 0.0f;
            float f7 = 0.0f;
            if ("Horizontal Lower".equals(this.mDirection) || "Horizontal Upper".equals(this.mDirection)) {
                f6 = this.getX() + f4;
                f7 = "Horizontal Lower".equals(this.mDirection) ? this.getY() + f5 + f2 + (float)this.getScaleHeight() + f3 : this.getY() + -(f2 + (float)this.getScaleHeight() + f3 + (float)rectangle2D.getHeight());
            } else if ("Perpendicular Left".equals(this.mDirection) || "Perpendicular Right".equals(this.mDirection)) {
                f7 = this.getY() - (float)rectangle2D.getHeight();
                f6 = "Perpendicular Left".equals(this.mDirection) ? this.getX() - (float)((double)(f2 + SGFigureElementAxis.this.getMaxLengthOfScaleNumbers(this) + f3) + rectangle2D.getWidth()) : this.getX() + f5 + (f2 + SGFigureElementAxis.this.getMaxLengthOfScaleNumbers(this) + f3);
            } else {
                throw new Error();
            }
            sGDrawingElementString2DExtended.setLocation(f6, f7);
            return true;
        }

        public void translate(float f, float f2) {
            this.setLocation(this.getX() + f, this.getY() + f2);
        }

        protected void showPropertyDialog() {
            SGFigureElementAxis.this.mCurrentPropertyDialog = SGFigureElementAxis.this.mColorBarPropertyDialog;
            SGFigureElementAxis.this.setPropertiesOfSelectedObjects();
            SGFigureElementAxis.this.mCurrentPropertyDialog = null;
        }

        public int getXAxisLocation() {
            return SGFigureElementAxis.this.getLocationInPlane(this.mXAxis);
        }

        public int getYAxisLocation() {
            return SGFigureElementAxis.this.getLocationInPlane(this.mYAxis);
        }

        public double getXValue() {
            SGAxis sGAxis = this.mXAxis;
            double d = SGFigureElementAxis.this.calcValue(this.getX(), sGAxis, true);
            if (Double.isNaN(d)) {
                return d;
            }
            d = SGFigureElementAxis.this.getNumberInRangeOrder(d, sGAxis);
            return d;
        }

        public double getYValue() {
            SGAxis sGAxis = this.mYAxis;
            double d = SGFigureElementAxis.this.calcValue(this.getY(), sGAxis, false);
            if (Double.isNaN(d)) {
                return d;
            }
            d = SGFigureElementAxis.this.getNumberInRangeOrder(d, sGAxis);
            return d;
        }

        public float getBarWidth(String string) {
            return (float)SGUtilityText.convertFromPoint(this.mBarWidth, string);
        }

        public float getBarLength(String string) {
            return (float)SGUtilityText.convertFromPoint(this.mBarLength, string);
        }

        public String getDirection() {
            return this.mDirection;
        }

        public boolean isReversedOrder() {
            return SGFigureElementAxis.this.mColorBarModel.isReversedOrder();
        }

        public String getColorBarStyle() {
            return SGFigureElementAxis.this.mColorBarStyleManager.getColorBarName(SGFigureElementAxis.this.mColorBarModel);
        }

        public Color getFontColor() {
            return this.mFontColor;
        }

        public String getFontName() {
            return this.mTitleFontName;
        }

        public float getFontSize(String string) {
            return (float)SGUtilityText.convertFromPoint(this.mTitleFontSize, string);
        }

        public int getFontStyle() {
            return this.mTitleFontStyle;
        }

        public float getSpaceToScale(String string) {
            return (float)SGUtilityText.convertFromPoint(this.mSpaceAxisLineAndNumber, string);
        }

        public float getSpaceToTitle(String string) {
            return (float)SGUtilityText.convertFromPoint(this.mSpaceNumberAndTitle, string);
        }

        public float getFrameLineWidth(String string) {
            return (float)SGUtilityText.convertFromPoint(this.mFrameLineWidth, string);
        }

        public Color getLineColor() {
            return this.mLineColor;
        }

        public float getTickMarkWidth(String string) {
            float f = this.mTickMarkStroke.getLineWidth();
            return (float)SGUtilityText.convertFromPoint(f, string);
        }

        public float getTickMarkLength(String string) {
            return (float)SGUtilityText.convertFromPoint(this.mTickMarkLength, string);
        }

        public boolean setXAxisLocation(int n) {
            if (n != 0 && n != 1) {
                return false;
            }
            this.mXAxis = SGFigureElementAxis.this.getAxisInPlane(n);
            return true;
        }

        public boolean setYAxisLocation(int n) {
            if (n != 2 && n != 3) {
                return false;
            }
            this.mYAxis = SGFigureElementAxis.this.getAxisInPlane(n);
            return true;
        }

        public boolean setXValue(double d) {
            float f;
            SGAxis sGAxis = this.mXAxis;
            double d2 = SGFigureElementAxis.this.calcValue(SGFigureElementAxis.this.getComponent().getX(), sGAxis, true);
            if (d == (d2 = SGFigureElementAxis.this.getNumberInRangeOrder(d2, sGAxis))) {
                f = this.mX;
            } else {
                float f2 = SGFigureElementAxis.this.calcLocation(d, sGAxis, true);
                f = (f2 - SGFigureElementAxis.this.mGraphRectX) / SGFigureElementAxis.this.mMagnification;
            }
            this.mX = f;
            return true;
        }

        public boolean setYValue(double d) {
            float f;
            SGAxis sGAxis = this.mYAxis;
            double d2 = SGFigureElementAxis.this.calcValue(SGFigureElementAxis.this.getComponent().getY(), sGAxis, false);
            if (d == (d2 = SGFigureElementAxis.this.getNumberInRangeOrder(d2, sGAxis))) {
                f = this.mY;
            } else {
                float f2 = SGFigureElementAxis.this.calcLocation(d, sGAxis, false);
                f = (f2 - SGFigureElementAxis.this.mGraphRectY) / SGFigureElementAxis.this.mMagnification;
            }
            this.mY = f;
            return true;
        }

        public boolean setBarWidth(float f) {
            if (f < 0.0f) {
                throw new IllegalArgumentException("w < 0.0f");
            }
            this.mBarWidth = f;
            return true;
        }

        public boolean setBarWidth(float f, String string) {
            Float f2 = SGUtility.calcPropertyValue(f, string, "cm", 0.5, 10.0, -2);
            if (f2 == null) {
                return false;
            }
            return this.setBarWidth(f2.floatValue());
        }

        public boolean setBarLength(float f) {
            if (f < 0.0f) {
                throw new IllegalArgumentException("len < 0.0f");
            }
            this.mBarLength = f;
            return true;
        }

        public boolean setBarLength(float f, String string) {
            Float f2 = SGUtility.calcPropertyValue(f, string, "cm", 1.0, 50.0, -2);
            if (f2 == null) {
                return false;
            }
            return this.setBarLength(f2.floatValue());
        }

        public boolean setSpaceToScale(float f) {
            this.mSpaceAxisLineAndNumber = f;
            return true;
        }

        public boolean setSpaceToScale(float f, String string) {
            Float f2 = SGUtility.calcPropertyValue(f, string, "cm", 0.0, 5.0, -2);
            if (f2 == null) {
                return false;
            }
            return this.setSpaceToScale(f2.floatValue());
        }

        public boolean setSpaceToTitle(float f) {
            this.mSpaceNumberAndTitle = f;
            return true;
        }

        public boolean setSpaceToTitle(float f, String string) {
            Float f2 = SGUtility.calcPropertyValue(f, string, "cm", 0.0, 5.0, -2);
            if (f2 == null) {
                return false;
            }
            return this.setSpaceToTitle(f2.floatValue());
        }

        public boolean setDirection(String string) {
            String string2;
            if (SGUtilityText.isEqualString("Horizontal Lower", string)) {
                string2 = "Horizontal Lower";
            } else if (SGUtilityText.isEqualString("Horizontal Upper", string)) {
                string2 = "Horizontal Upper";
            } else if (SGUtilityText.isEqualString("Perpendicular Left", string)) {
                string2 = "Perpendicular Left";
            } else if (SGUtilityText.isEqualString("Perpendicular Right", string)) {
                string2 = "Perpendicular Right";
            } else {
                return false;
            }
            this.mDirection = string2;
            return true;
        }

        public boolean setReversedOrder(boolean bl) {
            SGFigureElementAxis.this.mColorBarStyleManager.setReversedOrder(bl);
            return true;
        }

        public boolean setColorBarStyle(String string) {
            SGColorBarModel sGColorBarModel = SGFigureElementAxis.this.mColorBarStyleManager.getColorBarModel(string);
            if (sGColorBarModel == null) {
                return false;
            }
            double d = SGFigureElementAxis.this.mColorBarModel.getMinValue();
            double d2 = SGFigureElementAxis.this.mColorBarModel.getMaxValue();
            int n = SGFigureElementAxis.this.mColorBarModel.getScaleType();
            sGColorBarModel.setValueRange(d, d2, n);
            SGFigureElementAxis.this.mColorBarModel = sGColorBarModel;
            return true;
        }

        public boolean setFrameLineWidth(float f) {
            if (f < 0.0f) {
                throw new IllegalArgumentException("lw < 0.0f");
            }
            this.mFrameLineWidth = f;
            return true;
        }

        public boolean setFrameLineWidth(float f, String string) {
            Float f2 = SGUtility.getLineWidth(f, string);
            if (f2 == null) {
                return false;
            }
            return this.setFrameLineWidth(f2.floatValue());
        }

        public boolean setLineColor(Color color) {
            this.mLineColor = color;
            return true;
        }

        public boolean setTickMarkWidth(float f) {
            if (f < 0.0f) {
                throw new IllegalArgumentException("lw < 0.0f");
            }
            this.mTickMarkStroke.setLineWidth(f);
            return true;
        }

        public boolean setTickMarkWidth(float f, String string) {
            Float f2 = SGUtility.getLineWidth(f, string);
            if (f2 == null) {
                return false;
            }
            return this.setTickMarkWidth(f2.floatValue());
        }

        public boolean setTickMarkLength(float f) {
            if (f < 0.0f) {
                throw new IllegalArgumentException("len < 0.0f");
            }
            this.mTickMarkLength = f;
            return true;
        }

        public boolean setTickMarkLength(float f, String string) {
            Float f2 = SGUtility.calcPropertyValue(f, string, "cm", 0.0, 0.5, -2);
            if (f2 == null) {
                return false;
            }
            return this.setTickMarkLength(f2.floatValue());
        }

        public boolean setFontName(String string) {
            this.mTitleFontName = string;
            this.mScaleFontName = string;
            return true;
        }

        public boolean setFontSize(float f) {
            this.mTitleFontSize = f;
            this.mScaleFontSize = f;
            return true;
        }

        public boolean setFontSize(float f, String string) {
            Float f2 = SGUtility.getFontSize(f, string);
            if (f2 == null) {
                return false;
            }
            return this.setFontSize(f2.floatValue());
        }

        public boolean setFontStyle(int n) {
            this.mTitleFontStyle = n;
            this.mScaleFontStyle = n;
            return true;
        }

        public boolean setFontColor(Color color) {
            if (color == null) {
                throw new IllegalArgumentException("cl == null");
            }
            this.mFontColor = color;
            return true;
        }

        public boolean setScale(Number number, Number number2, Integer n) {
            if (!super.setScale(number, number2, n)) {
                return false;
            }
            double d = number == null ? SGFigureElementAxis.this.mColorBarModel.getMinValue() : number.doubleValue();
            double d2 = number2 == null ? SGFigureElementAxis.this.mColorBarModel.getMaxValue() : number2.doubleValue();
            int n2 = n == null ? SGFigureElementAxis.this.mColorBarModel.getScaleType() : n.intValue();
            SGFigureElementAxis.this.mColorBarModel.setValueRange(d, d2, n2);
            return true;
        }

        public boolean setInvertCoordinates(boolean bl) {
            if (!super.setInvertCoordinates(bl)) {
                return false;
            }
            SGFigureElementAxis.this.mColorBarModel.setInvertCoordinates(bl);
            return true;
        }

        public boolean hasValidXAxisValue(int n, Number number) {
            SGAxis sGAxis = n == -1 ? this.mXAxis : SGFigureElementAxis.this.getAxisInPlane(n);
            double d = number != null ? number.doubleValue() : this.getXValue();
            return sGAxis.isValidValue(d);
        }

        public boolean hasValidYAxisValue(int n, Number number) {
            SGAxis sGAxis = n == -1 ? this.mYAxis : SGFigureElementAxis.this.getAxisInPlane(n);
            double d = number != null ? number.doubleValue() : this.getYValue();
            return sGAxis.isValidValue(d);
        }

        public SGPropertyDialog getPropertyDialog() {
            return SGFigureElementAxis.this.mColorBarPropertyDialog;
        }

        protected boolean clicked(MouseEvent mouseEvent) {
            this.setSelected(true);
            return super.clicked(mouseEvent);
        }

        public boolean commit() {
            SGProperties sGProperties = this.mTemporaryProperties;
            SGProperties sGProperties2 = this.getProperties();
            if (!sGProperties.equals(sGProperties2)) {
                this.setChanged(true);
            }
            this.mTemporaryProperties = null;
            if (!this.createDrawingElements()) {
                return false;
            }
            SGFigureElementAxis.this.repaint();
            SGFigureElementAxis.this.notifyChange();
            return true;
        }

        public boolean cancel() {
            if (!this.setProperties(this.mTemporaryProperties)) {
                return false;
            }
            this.mTemporaryProperties = null;
            if (!this.createDrawingElements()) {
                return false;
            }
            SGFigureElementAxis.this.repaint();
            SGFigureElementAxis.this.notifyChange();
            return true;
        }

        public boolean prepare() {
            this.mTemporaryProperties = this.getProperties();
            return true;
        }

        public boolean preview() {
            if (!this.createDrawingElements()) {
                return false;
            }
            SGFigureElementAxis.this.repaint();
            SGFigureElementAxis.this.notifyChange();
            return true;
        }

        public SGProperties getProperties() {
            ColorBarProperties colorBarProperties = new ColorBarProperties();
            if (!this.getProperties(colorBarProperties)) {
                return null;
            }
            return colorBarProperties;
        }

        public boolean getProperties(SGProperties sGProperties) {
            if (!super.getProperties(sGProperties)) {
                return false;
            }
            ColorBarProperties colorBarProperties = (ColorBarProperties)sGProperties;
            colorBarProperties.xAxis = this.mXAxis;
            colorBarProperties.yAxis = this.mYAxis;
            colorBarProperties.x = this.mX;
            colorBarProperties.y = this.mY;
            colorBarProperties.barWidth = this.mBarWidth;
            colorBarProperties.barLength = this.mBarLength;
            colorBarProperties.toScale = this.mSpaceAxisLineAndNumber;
            colorBarProperties.toTitle = this.mSpaceNumberAndTitle;
            colorBarProperties.direction = this.mDirection;
            colorBarProperties.reversedOrder = this.isReversedOrder();
            colorBarProperties.colorBarStyle = this.getColorBarStyle();
            colorBarProperties.frameLineWidth = this.mFrameLineWidth;
            colorBarProperties.tickMarkWidth = this.mTickMarkStroke.getLineWidth();
            colorBarProperties.tickMarkLength = this.mTickMarkLength;
            colorBarProperties.lineColor = this.mLineColor;
            colorBarProperties.fontName = this.mTitleFontName;
            colorBarProperties.fontStyle = this.mTitleFontStyle;
            colorBarProperties.fontSize = this.mTitleFontSize;
            colorBarProperties.fontColor = this.mFontColor;
            return true;
        }

        public boolean setProperties(SGProperties sGProperties) {
            if (!super.setProperties(sGProperties)) {
                return false;
            }
            ColorBarProperties colorBarProperties = (ColorBarProperties)sGProperties;
            this.mXAxis = colorBarProperties.xAxis;
            this.mYAxis = colorBarProperties.yAxis;
            this.mX = colorBarProperties.x;
            this.mY = colorBarProperties.y;
            this.mBarWidth = colorBarProperties.barWidth;
            this.mBarLength = colorBarProperties.barLength;
            this.mSpaceAxisLineAndNumber = colorBarProperties.toScale;
            this.mSpaceNumberAndTitle = colorBarProperties.toTitle;
            this.mDirection = colorBarProperties.direction;
            SGFigureElementAxis.this.mColorBarModel = SGFigureElementAxis.this.mColorBarStyleManager.getColorBarModel(colorBarProperties.colorBarStyle);
            SGFigureElementAxis.this.mColorBarModel.setValueRange(this.mAxis.getMinValue(), this.mAxis.getMaxValue(), this.mAxis.getScaleType());
            this.setReversedOrder(colorBarProperties.reversedOrder);
            this.mFrameLineWidth = colorBarProperties.frameLineWidth;
            this.mTickMarkStroke.setLineWidth(colorBarProperties.tickMarkWidth);
            this.mTickMarkLength = colorBarProperties.tickMarkLength;
            this.mLineColor = colorBarProperties.lineColor;
            this.mTitleFontName = colorBarProperties.fontName;
            this.mScaleFontName = colorBarProperties.fontName;
            this.mTitleFontStyle = colorBarProperties.fontStyle;
            this.mScaleFontStyle = colorBarProperties.fontStyle;
            this.mTitleFontSize = colorBarProperties.fontSize;
            this.mScaleFontSize = colorBarProperties.fontSize;
            this.mFontColor = colorBarProperties.fontColor;
            return true;
        }

        public SGProperties getMemento() {
            return this.getProperties();
        }

        public boolean setMemento(SGProperties sGProperties) {
            return this.setProperties(sGProperties);
        }

        public boolean isUndoable() {
            return this.mUndoManager.isUndoable();
        }

        public boolean isRedoable() {
            return this.mUndoManager.isRedoable();
        }

        public boolean initPropertiesHistory() {
            return this.mUndoManager.initPropertiesHistory();
        }

        public boolean setMementoBackward() {
            if (!this.mUndoManager.setMementoBackward()) {
                return false;
            }
            if (!this.createDrawingElements()) {
                return false;
            }
            SGFigureElementAxis.this.notifyChange();
            return true;
        }

        public boolean setMementoForward() {
            if (!this.mUndoManager.setMementoForward()) {
                return false;
            }
            if (!this.createDrawingElements()) {
                return false;
            }
            SGFigureElementAxis.this.notifyChange();
            return true;
        }

        public boolean undo() {
            return this.setMementoBackward();
        }

        public boolean redo() {
            return this.setMementoForward();
        }

        public boolean updateHistory() {
            return this.mUndoManager.updateHistory();
        }

        public void initUndoBuffer() {
            this.mUndoManager.initUndoBuffer();
        }

        public boolean isChanged() {
            return this.mUndoManager.isChanged();
        }

        public void setChanged(boolean bl) {
            this.mUndoManager.setChanged(bl);
        }

        public boolean deleteForwardHistory() {
            return this.mUndoManager.deleteForwardHistory();
        }

        public boolean isChangedRoot() {
            return this.isChanged();
        }

        public void clearChanged() {
            this.setChanged(false);
        }

        public void notifyToRoot() {
            SGFigureElementAxis.this.notifyToRoot();
        }

        public ArrayList getChildNodes() {
            return new ArrayList();
        }

        public String getClassDescription() {
            return "Color Bar";
        }

        public String getInstanceDescription() {
            return "Color Bar";
        }

        public String getTagName() {
            return "ColorBar";
        }

        public boolean writeProperty(Element element) {
            float f = (float)SGUtilityNumber.roundOffNumber(this.getBarWidth() * 0.035277776f, -3);
            float f2 = (float)SGUtilityNumber.roundOffNumber(this.getLength() * 0.035277776f, -3);
            float f3 = (float)SGUtilityNumber.roundOffNumber(this.mSpaceAxisLineAndNumber * 0.035277776f, -3);
            float f4 = (float)SGUtilityNumber.roundOffNumber(this.mSpaceNumberAndTitle * 0.035277776f, -3);
            float f5 = (float)SGUtilityNumber.roundOffNumber(this.mTickMarkStroke.getLineWidth(), -3);
            float f6 = (float)SGUtilityNumber.roundOffNumber(this.mTickMarkLength * 0.035277776f, -3);
            float f7 = (float)SGUtilityNumber.roundOffNumber(this.mFrameLineWidth, -3);
            float f8 = (float)SGUtilityNumber.roundOffNumber(this.mTitleFontSize, -3);
            String string = SGFigureElementAxis.this.getLocationName(this.mXAxis);
            String string2 = SGFigureElementAxis.this.getLocationName(this.mYAxis);
            element.setAttribute("Visible", Boolean.toString(this.mVisibleFlag));
            element.setAttribute("XAxisPosition", string);
            element.setAttribute("YAxisPosition", string2);
            element.setAttribute("XValue", Double.toString(this.getXValue()));
            element.setAttribute("YValue", Double.toString(this.getYValue()));
            element.setAttribute("BarWidth", Float.toString(f) + "cm");
            element.setAttribute("BarLength", Float.toString(f2) + "cm");
            element.setAttribute("SpaceLineAndNumber", Float.toString(f3) + "cm");
            element.setAttribute("SpaceNumberAndTitle", Float.toString(f4) + "cm");
            element.setAttribute("Direction", this.mDirection);
            element.setAttribute("ColorBarStyle", this.getColorBarStyle());
            element.setAttribute("ReversedOrder", Boolean.toString(SGFigureElementAxis.this.mColorBarStyleManager.isReversedOrder()));
            element.setAttribute("FrameLineWidth", Float.toString(f7) + "pt");
            element.setAttribute("LineColor", SGUtilityText.getColorString(this.mLineColor));
            element.setAttribute("TickMarkWidth", Float.toString(f5) + "pt");
            element.setAttribute("TickMarkLength", Float.toString(f6) + "cm");
            element.setAttribute("FontName", this.mTitleFontName);
            element.setAttribute("FontSize", Float.toString(f8) + "pt");
            element.setAttribute("FontStyle", SGUtilityText.getFontStyleName(this.mTitleFontStyle));
            element.setAttribute("StringColor", SGUtilityText.getColorString(this.mFontColor));
            return this.writeCommonProperties(element);
        }

        protected boolean readProperties(Element element) {
            if (!super.readCommonProperties(element)) {
                return false;
            }
            String string = null;
            Number number = null;
            Color color = null;
            Boolean bl = null;
            StringBuffer stringBuffer = new StringBuffer();
            string = element.getAttribute("Visible");
            if (string.length() == 0) {
                return false;
            }
            bl = SGUtilityText.getBoolean(string);
            if (bl == null) {
                return false;
            }
            boolean bl2 = bl;
            string = element.getAttribute("XAxisPosition");
            if (string.length() != 0) {
                this.mXAxis = SGFigureElementAxis.this.getAxis(string);
            }
            if ((string = element.getAttribute("YAxisPosition")).length() != 0) {
                this.mYAxis = SGFigureElementAxis.this.getAxis(string);
            }
            if ((string = element.getAttribute("XValue")).length() == 0) {
                return false;
            }
            number = SGUtilityText.getDouble(string);
            if (number == null) {
                return false;
            }
            double d = number.doubleValue();
            string = element.getAttribute("YValue");
            if (string.length() == 0) {
                return false;
            }
            number = SGUtilityText.getDouble(string);
            if (number == null) {
                return false;
            }
            double d2 = number.doubleValue();
            string = element.getAttribute("BarWidth");
            if (string.length() == 0) {
                return false;
            }
            stringBuffer.setLength(0);
            number = SGUtilityText.getNumber(string, stringBuffer);
            if (number == null) {
                return false;
            }
            float f = number.floatValue();
            string = element.getAttribute("BarLength");
            if (string.length() == 0) {
                return false;
            }
            stringBuffer.setLength(0);
            number = SGUtilityText.getNumber(string, stringBuffer);
            if (number == null) {
                return false;
            }
            float f2 = number.floatValue();
            string = element.getAttribute("SpaceLineAndNumber");
            if (string.length() == 0) {
                return false;
            }
            stringBuffer.setLength(0);
            number = SGUtilityText.getNumber(string, stringBuffer);
            if (number == null) {
                return false;
            }
            float f3 = number.floatValue();
            string = element.getAttribute("SpaceNumberAndTitle");
            if (string.length() == 0) {
                return false;
            }
            stringBuffer.setLength(0);
            number = SGUtilityText.getNumber(string, stringBuffer);
            if (number == null) {
                return false;
            }
            float f4 = number.floatValue();
            string = element.getAttribute("Direction");
            if (string.length() == 0) {
                return false;
            }
            String string2 = string;
            string = element.getAttribute("ColorBarStyle");
            if (SGFigureElementAxis.this.mColorBarStyleManager.getColorBarModel(string) == null) {
                return false;
            }
            String string3 = string;
            string = element.getAttribute("ReversedOrder");
            if (string.length() == 0) {
                return false;
            }
            bl = SGUtilityText.getBoolean(string);
            if (bl == null) {
                return false;
            }
            boolean bl3 = bl;
            string = element.getAttribute("FrameLineWidth");
            if (string.length() == 0) {
                return false;
            }
            stringBuffer.setLength(0);
            number = SGUtilityText.getNumber(string, stringBuffer);
            if (number == null) {
                return false;
            }
            float f5 = number.floatValue();
            string = element.getAttribute("LineColor");
            if (string.length() == 0) {
                return false;
            }
            color = SGUtilityText.parseColor(string);
            if (color == null) {
                return false;
            }
            Color color2 = color;
            string = element.getAttribute("TickMarkWidth");
            if (string.length() == 0) {
                return false;
            }
            stringBuffer.setLength(0);
            number = SGUtilityText.getNumber(string, stringBuffer);
            if (number == null) {
                return false;
            }
            float f6 = number.floatValue();
            string = element.getAttribute("TickMarkLength");
            if (string.length() == 0) {
                return false;
            }
            stringBuffer.setLength(0);
            number = SGUtilityText.getNumber(string, stringBuffer);
            if (number == null) {
                return false;
            }
            float f7 = number.floatValue();
            string = element.getAttribute("FontName");
            if (string.length() == 0) {
                return false;
            }
            String string4 = string;
            string = element.getAttribute("FontSize");
            if (string.length() == 0) {
                return false;
            }
            stringBuffer.setLength(0);
            number = SGUtilityText.getNumber(string, stringBuffer);
            if (number == null) {
                return false;
            }
            float f8 = number.floatValue();
            string = element.getAttribute("FontStyle");
            if (string.length() == 0) {
                return false;
            }
            Integer n = SGUtilityText.getFontStyle(string);
            if (n == null) {
                return false;
            }
            string = element.getAttribute("StringColor");
            if (string.length() == 0) {
                return false;
            }
            color = SGUtilityText.parseColor(string);
            if (color == null) {
                return false;
            }
            Color color3 = color;
            if (!this.setAxisVisible(bl2)) {
                return false;
            }
            if (!this.setXValue(d)) {
                return false;
            }
            if (!this.setYValue(d2)) {
                return false;
            }
            if (!this.setBarWidth(f, "cm")) {
                return false;
            }
            if (!this.setBarLength(f2, "cm")) {
                return false;
            }
            if (!this.setSpaceToScale(f3, "cm")) {
                return false;
            }
            if (!this.setSpaceToTitle(f4, "cm")) {
                return false;
            }
            if (!this.setDirection(string2)) {
                return false;
            }
            if (!this.setColorBarStyle(string3)) {
                return false;
            }
            if (!this.setReversedOrder(bl3)) {
                return false;
            }
            if (!this.setFrameLineWidth(f5, "pt")) {
                return false;
            }
            if (!this.setTickMarkWidth(f6, "pt")) {
                return false;
            }
            if (!this.setTickMarkLength(f7, "cm")) {
                return false;
            }
            if (!this.setLineColor(color2)) {
                return false;
            }
            if (!this.setFontName(string4)) {
                return false;
            }
            if (!this.setFontSize(f8, "pt")) {
                return false;
            }
            if (!this.setFontStyle(n)) {
                return false;
            }
            return this.setFontColor(color3);
        }

        protected SGPropertyResults setProperties(SGPropertyMap sGPropertyMap, SGPropertyResults sGPropertyResults) {
            SGPropertyResults sGPropertyResults2 = (SGPropertyResults)sGPropertyResults.clone();
            if ((sGPropertyResults2 = super.setProperties(sGPropertyMap, sGPropertyResults2)) == null) {
                return null;
            }
            Iterator<String> iterator = sGPropertyMap.getKeyIterator();
            while (iterator.hasNext()) {
                Number number;
                String string = iterator.next();
                String string2 = sGPropertyMap.getValueString(string);
                if ("AxisX".equalsIgnoreCase(string)) {
                    int n = SGUtility.getAxisLocation(string2);
                    if (n == -1) {
                        sGPropertyResults2.putResult("AxisX", 1);
                        continue;
                    }
                    if (!this.setXAxisLocation(n)) {
                        sGPropertyResults2.putResult("AxisX", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("AxisX", 0);
                    continue;
                }
                if ("AxisY".equalsIgnoreCase(string)) {
                    int n = SGUtility.getAxisLocation(string2);
                    if (n == -1) {
                        sGPropertyResults2.putResult("AxisY", 1);
                        continue;
                    }
                    if (!this.setYAxisLocation(n)) {
                        sGPropertyResults2.putResult("AxisY", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("AxisY", 0);
                    continue;
                }
                if ("X".equalsIgnoreCase(string)) {
                    Double d = SGUtilityText.getDouble(string2);
                    if (d == null) {
                        sGPropertyResults2.putResult("X", 1);
                        continue;
                    }
                    if (!SGUtility.isValidPropertyValue(d)) {
                        sGPropertyResults2.putResult("X", 1);
                        continue;
                    }
                    if (!this.setXValue(d)) {
                        sGPropertyResults2.putResult("X", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("X", 0);
                    continue;
                }
                if ("Y".equalsIgnoreCase(string)) {
                    Double d = SGUtilityText.getDouble(string2);
                    if (d == null) {
                        sGPropertyResults2.putResult("Y", 1);
                        continue;
                    }
                    if (!SGUtility.isValidPropertyValue(d)) {
                        sGPropertyResults2.putResult("Y", 1);
                        continue;
                    }
                    if (!this.setYValue(d)) {
                        sGPropertyResults2.putResult("Y", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("Y", 0);
                    continue;
                }
                if ("Width".equalsIgnoreCase(string)) {
                    StringBuffer stringBuffer = new StringBuffer();
                    number = SGUtilityText.getNumber(string2, stringBuffer);
                    if (number == null) {
                        sGPropertyResults2.putResult("Width", 1);
                        continue;
                    }
                    if (!this.setBarWidth(number.floatValue(), stringBuffer.toString())) {
                        sGPropertyResults2.putResult("Width", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("Width", 0);
                    continue;
                }
                if ("Length".equalsIgnoreCase(string)) {
                    StringBuffer stringBuffer = new StringBuffer();
                    number = SGUtilityText.getNumber(string2, stringBuffer);
                    if (number == null) {
                        sGPropertyResults2.putResult("Length", 1);
                        continue;
                    }
                    if (!this.setBarLength(number.floatValue(), stringBuffer.toString())) {
                        sGPropertyResults2.putResult("Length", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("Length", 0);
                    continue;
                }
                if ("SpaceToScale".equalsIgnoreCase(string)) {
                    StringBuffer stringBuffer = new StringBuffer();
                    number = SGUtilityText.getNumber(string2, stringBuffer);
                    if (number == null) {
                        sGPropertyResults2.putResult("SpaceToScale", 1);
                        continue;
                    }
                    if (!this.setSpaceToScale(number.floatValue(), stringBuffer.toString())) {
                        sGPropertyResults2.putResult("SpaceToScale", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("SpaceToScale", 0);
                    continue;
                }
                if ("SpaceToTitle".equalsIgnoreCase(string)) {
                    StringBuffer stringBuffer = new StringBuffer();
                    number = SGUtilityText.getNumber(string2, stringBuffer);
                    if (number == null) {
                        sGPropertyResults2.putResult("SpaceToTitle", 1);
                        continue;
                    }
                    if (!this.setSpaceToTitle(number.floatValue(), stringBuffer.toString())) {
                        sGPropertyResults2.putResult("SpaceToTitle", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("SpaceToTitle", 0);
                    continue;
                }
                if ("Direction".equalsIgnoreCase(string)) {
                    if (!this.setDirection(string2)) {
                        sGPropertyResults2.putResult("Direction", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("Direction", 0);
                    continue;
                }
                if ("Style".equalsIgnoreCase(string)) {
                    if (!this.setColorBarStyle(string2)) {
                        sGPropertyResults2.putResult("Style", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("Style", 0);
                    continue;
                }
                if ("ReversedOrder".equalsIgnoreCase(string)) {
                    Boolean bl = SGUtilityText.getBoolean(string2);
                    if (bl == null) {
                        sGPropertyResults2.putResult("ReversedOrder", 1);
                        continue;
                    }
                    if (!this.setReversedOrder(bl)) {
                        sGPropertyResults2.putResult("ReversedOrder", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("ReversedOrder", 0);
                    continue;
                }
                if ("FrameLineWidth".equalsIgnoreCase(string)) {
                    StringBuffer stringBuffer = new StringBuffer();
                    number = SGUtilityText.getNumber(string2, stringBuffer);
                    if (number == null) {
                        sGPropertyResults2.putResult("FrameLineWidth", 1);
                        continue;
                    }
                    if (!this.setFrameLineWidth(number.floatValue(), stringBuffer.toString())) {
                        sGPropertyResults2.putResult("FrameLineWidth", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("FrameLineWidth", 0);
                    continue;
                }
                if ("TickMarkWidth".equalsIgnoreCase(string)) {
                    StringBuffer stringBuffer = new StringBuffer();
                    number = SGUtilityText.getNumber(string2, stringBuffer);
                    if (number == null) {
                        sGPropertyResults2.putResult("TickMarkWidth", 1);
                        continue;
                    }
                    if (!this.setTickMarkWidth(number.floatValue(), stringBuffer.toString())) {
                        sGPropertyResults2.putResult("TickMarkWidth", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("TickMarkWidth", 0);
                    continue;
                }
                if ("TickMarkLength".equalsIgnoreCase(string)) {
                    StringBuffer stringBuffer = new StringBuffer();
                    number = SGUtilityText.getNumber(string2, stringBuffer);
                    if (number == null) {
                        sGPropertyResults2.putResult("TickMarkLength", 1);
                        continue;
                    }
                    if (!this.setTickMarkLength(number.floatValue(), stringBuffer.toString())) {
                        sGPropertyResults2.putResult("TickMarkLength", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("TickMarkLength", 0);
                    continue;
                }
                if ("LineColor".equalsIgnoreCase(string)) {
                    Color color = SGUtilityText.getColor(string2);
                    if (color != null) {
                        if (!this.setLineColor(color)) {
                            sGPropertyResults2.putResult("LineColor", 1);
                            continue;
                        }
                    } else {
                        color = SGUtilityText.parseColor(string2);
                        if (color == null) {
                            sGPropertyResults2.putResult("LineColor", 1);
                            continue;
                        }
                        if (!this.setLineColor(color)) {
                            sGPropertyResults2.putResult("LineColor", 1);
                            continue;
                        }
                    }
                    sGPropertyResults2.putResult("LineColor", 0);
                    continue;
                }
                if ("FontName".equalsIgnoreCase(string)) {
                    String string3 = SGUtility.findFontFamilyName(string2);
                    if (string3 == null) {
                        sGPropertyResults2.putResult("FontName", 1);
                        continue;
                    }
                    if (!this.setFontName(string3)) {
                        sGPropertyResults2.putResult("FontName", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("FontName", 0);
                    continue;
                }
                if ("FontStyle".equalsIgnoreCase(string)) {
                    Integer n = SGUtilityText.getFontStyle(string2);
                    if (n == null) {
                        sGPropertyResults2.putResult("FontStyle", 1);
                        continue;
                    }
                    if (!this.setFontStyle(n)) {
                        sGPropertyResults2.putResult("FontStyle", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("FontStyle", 0);
                    continue;
                }
                if ("FontSize".equalsIgnoreCase(string)) {
                    StringBuffer stringBuffer = new StringBuffer();
                    number = SGUtilityText.getNumber(string2, stringBuffer);
                    if (number == null) {
                        sGPropertyResults2.putResult("FontSize", 1);
                        continue;
                    }
                    if (!this.setFontSize(number.floatValue(), stringBuffer.toString())) {
                        sGPropertyResults2.putResult("FontSize", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("FontSize", 0);
                    continue;
                }
                if (!"FontColor".equalsIgnoreCase(string)) continue;
                Color color = SGUtilityText.getColor(string2);
                if (color != null) {
                    if (!this.setFontColor(color)) {
                        sGPropertyResults2.putResult("FontColor", 1);
                        continue;
                    }
                } else {
                    color = SGUtilityText.parseColor(string2);
                    if (color == null) {
                        sGPropertyResults2.putResult("FontColor", 1);
                        continue;
                    }
                    if (!this.setFontColor(color)) {
                        sGPropertyResults2.putResult("FontColor", 1);
                        continue;
                    }
                }
                sGPropertyResults2.putResult("FontColor", 0);
            }
            return sGPropertyResults2;
        }

        public boolean setMagnification(float f) {
            if (!super.setMagnification(f)) {
                return false;
            }
            this.mTickMarkStroke.setMagnification(f);
            return true;
        }

        protected ElementLineOfScale createScaleLineInstance(ElementLineOfScale elementLineOfScale) {
            return new ElementLineOfColorBarScale(elementLineOfScale);
        }

        private class ElementLineOfColorBarScale
        extends ElementLineOfScale {
            ElementLineOfColorBarScale(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
                super(sGTuple2f, sGTuple2f2);
            }

            ElementLineOfColorBarScale(ElementLineOfScale elementLineOfScale) {
                super(elementLineOfScale);
            }

            public Color getColor() {
                return ElementsGroupColorBar.this.mLineColor;
            }

            public SGStroke getStroke() {
                return ElementsGroupColorBar.this.mTickMarkStroke;
            }
        }
    }

    public static class AxisIndividualProperties
    extends SGProperties {
        int location;
        int scaleType;
        double minValue;
        double maxValue;
        boolean invertCoordinatesFlag;
        boolean autoCalcAxisNumberFlag;
        double incrementValue;
        double baseTickValue;
        String titleString;
        boolean axisVisibleFlag;
        boolean titleVisibleFlag;
        boolean scaleLinesVisibleFlag;
        boolean scaleNumbersVisibleFlag;
        boolean scaleLinesInsideFlag;
        boolean scaleNumbersIntegerFlag;
        boolean exponentFlag;
        int exponentValue;
        float scaleNumbersAngle;

        public void dispose() {
            super.dispose();
            this.titleString = null;
        }

        public boolean equals(Object object) {
            if (!(object instanceof AxisIndividualProperties)) {
                return false;
            }
            AxisIndividualProperties axisIndividualProperties = (AxisIndividualProperties)object;
            if (axisIndividualProperties.location != this.location) {
                return false;
            }
            if (axisIndividualProperties.scaleType != this.scaleType) {
                return false;
            }
            if (axisIndividualProperties.minValue != this.minValue) {
                return false;
            }
            if (axisIndividualProperties.maxValue != this.maxValue) {
                return false;
            }
            if (axisIndividualProperties.invertCoordinatesFlag != this.invertCoordinatesFlag) {
                return false;
            }
            if (axisIndividualProperties.autoCalcAxisNumberFlag != this.autoCalcAxisNumberFlag) {
                return false;
            }
            if (axisIndividualProperties.incrementValue != this.incrementValue) {
                return false;
            }
            if (axisIndividualProperties.baseTickValue != this.baseTickValue) {
                return false;
            }
            if (!axisIndividualProperties.titleString.equals(this.titleString)) {
                return false;
            }
            if (axisIndividualProperties.axisVisibleFlag != this.axisVisibleFlag) {
                return false;
            }
            if (axisIndividualProperties.titleVisibleFlag != this.titleVisibleFlag) {
                return false;
            }
            if (axisIndividualProperties.scaleLinesVisibleFlag != this.scaleLinesVisibleFlag) {
                return false;
            }
            if (axisIndividualProperties.scaleNumbersVisibleFlag != this.scaleNumbersVisibleFlag) {
                return false;
            }
            if (axisIndividualProperties.scaleLinesInsideFlag != this.scaleLinesInsideFlag) {
                return false;
            }
            if (axisIndividualProperties.scaleNumbersIntegerFlag != this.scaleNumbersIntegerFlag) {
                return false;
            }
            if (axisIndividualProperties.exponentFlag != this.exponentFlag) {
                return false;
            }
            if (axisIndividualProperties.exponentValue != this.exponentValue) {
                return false;
            }
            return axisIndividualProperties.scaleNumbersAngle == this.scaleNumbersAngle;
        }
    }

    public static class AxisCommonProperties
    extends SGProperties {
        boolean frameLinesVisibleFlag;
        float frameLineWidth;
        Color frameLineColor;
        Color lineColor;
        float axisLineWidth;
        float tickMarkWidth;
        float tickMarkLength;
        Color stringColor;
        String titleFontName;
        int titleFontStyle;
        float titleFontSize;
        String scaleFontName;
        int scaleFontStyle;
        float scaleFontSize;

        public void dispose() {
            super.dispose();
            this.frameLineColor = null;
            this.lineColor = null;
            this.stringColor = null;
            this.titleFontName = null;
            this.scaleFontName = null;
        }

        public boolean equals(Object object) {
            if (!(object instanceof AxisCommonProperties)) {
                return false;
            }
            AxisCommonProperties axisCommonProperties = (AxisCommonProperties)object;
            if (axisCommonProperties.frameLinesVisibleFlag != this.frameLinesVisibleFlag) {
                return false;
            }
            if (axisCommonProperties.frameLineWidth != this.frameLineWidth) {
                return false;
            }
            if (!axisCommonProperties.frameLineColor.equals(this.frameLineColor)) {
                return false;
            }
            if (!axisCommonProperties.lineColor.equals(this.lineColor)) {
                return false;
            }
            if (!axisCommonProperties.stringColor.equals(this.stringColor)) {
                return false;
            }
            if (axisCommonProperties.axisLineWidth != this.axisLineWidth) {
                return false;
            }
            if (axisCommonProperties.tickMarkWidth != this.tickMarkWidth) {
                return false;
            }
            if (axisCommonProperties.tickMarkLength != this.tickMarkLength) {
                return false;
            }
            if (axisCommonProperties.titleFontSize != this.titleFontSize) {
                return false;
            }
            if (!axisCommonProperties.titleFontName.equals(this.titleFontName)) {
                return false;
            }
            if (axisCommonProperties.titleFontStyle != this.titleFontStyle) {
                return false;
            }
            if (axisCommonProperties.scaleFontSize != this.scaleFontSize) {
                return false;
            }
            if (!axisCommonProperties.scaleFontName.equals(this.scaleFontName)) {
                return false;
            }
            return axisCommonProperties.scaleFontStyle == this.scaleFontStyle;
        }
    }

    public static class AxisProperties
    extends SGProperties {
        AxisCommonProperties cp;
        AxisIndividualProperties[] ipArray;

        AxisProperties() {
        }

        public void dispose() {
            super.dispose();
            this.cp.dispose();
            this.cp = null;
            AxisIndividualProperties[] axisIndividualPropertiesArray = this.ipArray;
            for (int i = 0; i < axisIndividualPropertiesArray.length; ++i) {
                this.ipArray[i].dispose();
            }
            this.ipArray = null;
        }

        public boolean equals(Object object) {
            if (!(object instanceof AxisProperties)) {
                return false;
            }
            AxisProperties axisProperties = (AxisProperties)object;
            if (!axisProperties.cp.equals(this.cp)) {
                return false;
            }
            if (axisProperties.ipArray.length != this.ipArray.length) {
                return false;
            }
            for (int i = 0; i < this.ipArray.length; ++i) {
                if (axisProperties.ipArray[i].equals(this.ipArray[i])) continue;
                return false;
            }
            return true;
        }
    }

    private class ElementsGroupOfAxis
    implements ActionListener,
    SGIAxisPanelObserver,
    SGIDisposable {
        private int mLocationInPlane = -1;
        protected SGAxis mAxis = null;
        protected ElementLineOfAxis[] mAxisLines = null;
        protected ElementStringOfTitle mTitle = new ElementStringOfTitle();
        protected final ArrayList mNumberList = new ArrayList();
        protected final ArrayList mTickMarksList = new ArrayList();
        protected boolean mVisibleFlag = true;
        protected boolean mTitleVisibleFlag = true;
        protected boolean mNumbersVisibleFlag = true;
        protected boolean mTickMarksVisibleFlag = true;
        protected boolean mTickMarksInsideFlag = true;
        protected double[] mAxisValueArray = null;
        protected boolean mAutoCalcFlag = true;
        protected double mStepValue = 1.0;
        protected double mBaselineValue = 0.0;
        protected boolean mScaleNumbersIntegerFlag = false;
        protected boolean mExponentFlag = false;
        protected int mExponentValue = 0;
        protected float mNumbersAngle = 0.0f;
        protected SGDrawingElementString2DExtended mExponentDrawingElement = null;
        protected SGDrawingElement mDraggingElement = null;
        protected JPopupMenu mPopupMenu = null;
        private boolean mDisposed = false;
        protected SGTuple2d mTempRange = null;

        protected ElementsGroupOfAxis() {
            this.mAxisLines = this.createAxisLines();
            this.setNumbersVisible(true);
            this.setNumbersInteger(false);
            this.setTickMarksVisible(true);
            this.setTickMarksInside(true);
            this.setNumbersAngle(0.0f);
        }

        public boolean prepare() {
            return SGFigureElementAxis.this.prepare();
        }

        public boolean commit() {
            return SGFigureElementAxis.this.commit();
        }

        protected ElementLineOfAxis[] createAxisLines() {
            ElementLineOfAxis[] elementLineOfAxisArray = new ElementLineOfAxis[]{new ElementLineOfAxis()};
            return elementLineOfAxisArray;
        }

        public void dispose() {
            SGDrawingElement sGDrawingElement;
            int n;
            this.mDisposed = true;
            this.mAxis = null;
            this.mAxisValueArray = null;
            for (n = 0; n < this.mAxisLines.length; ++n) {
                this.mAxisLines[n].dispose();
            }
            this.mAxisLines = null;
            for (n = 0; n < this.mNumberList.size(); ++n) {
                sGDrawingElement = (SGDrawingElementString)this.mNumberList.get(n);
                ((SGDrawingElementString)sGDrawingElement).dispose();
            }
            this.mNumberList.clear();
            for (n = 0; n < this.mTickMarksList.size(); ++n) {
                sGDrawingElement = (SGDrawingElementLine)this.mTickMarksList.get(n);
                sGDrawingElement.dispose();
            }
            this.mTickMarksList.clear();
            this.mTitle.dispose();
            this.mTitle = null;
            this.mPopupMenu = null;
        }

        public boolean isDisposed() {
            return this.mDisposed;
        }

        public SGAxis getAxis() {
            return this.mAxis;
        }

        public boolean setScale(double d, double d2) {
            return this.getAxis().setScale(d, d2);
        }

        public boolean isAxisVisible() {
            return this.mVisibleFlag;
        }

        public boolean isTitleVisible() {
            return this.mTitleVisibleFlag;
        }

        public String getTitleString() {
            return this.mTitle.getString();
        }

        public double getMinValue() {
            return this.mAxis.getMinValue();
        }

        public double getMaxValue() {
            return this.mAxis.getMaxValue();
        }

        public SGTuple2d getRange() {
            return this.mAxis.getRange();
        }

        public boolean isInvertCoordinates() {
            return this.mAxis.isInvertCoordinates();
        }

        public int getScaleType() {
            return this.mAxis.getScaleType();
        }

        public boolean isCalculateAutomatically() {
            return this.mAutoCalcFlag;
        }

        public double getStepValue() {
            return this.mStepValue;
        }

        public double getBaselineValue() {
            return this.mBaselineValue;
        }

        public boolean isTickMarksVisible() {
            return this.mTickMarksVisibleFlag;
        }

        public boolean isTickMarksInside() {
            return this.mTickMarksInsideFlag;
        }

        public boolean isNumbersVisible() {
            return this.mNumbersVisibleFlag;
        }

        public boolean isNumbersInteger() {
            return this.mScaleNumbersIntegerFlag;
        }

        public boolean getExponentFlag() {
            return this.mExponentFlag;
        }

        public int getExponentValue() {
            return this.mExponentValue;
        }

        public float getNumbersAngle() {
            return this.mNumbersAngle;
        }

        public boolean setAxisVisible(boolean bl) {
            this.mVisibleFlag = bl;
            return true;
        }

        public boolean setTitleVisible(boolean bl) {
            this.mTitleVisibleFlag = bl;
            return true;
        }

        public boolean setTitle(String string) {
            if (!SGUtilityText.isValidString(string)) {
                return false;
            }
            this.mTitle.setString(string);
            return true;
        }

        public boolean setInvertCoordinates(boolean bl) {
            return this.mAxis.setInvertCoordinates(bl);
        }

        public boolean setScale(Number number, Number number2, Integer n) {
            int n2;
            double d = number != null ? number.doubleValue() : this.getMinValue();
            double d2 = number2 != null ? number2.doubleValue() : this.getMaxValue();
            int n3 = n2 = n != null ? n.intValue() : this.getScaleType();
            if (d2 <= d) {
                return false;
            }
            if (!SGAxis.isValidValue(d, n2) || !SGAxis.isValidValue(d2, n2)) {
                return false;
            }
            return this.mAxis.setScale(d, d2, n2);
        }

        public boolean setScale(Number number, Number number2) {
            return this.setScale(number, number2, this.mAxis.getScaleType());
        }

        public boolean setScaleType(int n) {
            if (!SGAxis.isValidScaleType(n)) {
                return false;
            }
            double d = this.mAxis.getMinValue();
            double d2 = this.mAxis.getMaxValue();
            if (!SGAxis.isValidValue(d, n) || !SGAxis.isValidValue(d2, n)) {
                return false;
            }
            return this.mAxis.setScale(d, d2, n);
        }

        public boolean setCalculateAutomatically(boolean bl) {
            this.mAutoCalcFlag = bl;
            return true;
        }

        public boolean setStepValue(double d) {
            if (d == 0.0) {
                return false;
            }
            this.mStepValue = d;
            return true;
        }

        public boolean setBaselineValue(double d) {
            this.mBaselineValue = d;
            return true;
        }

        public boolean setTickMarksVisible(boolean bl) {
            this.mTickMarksVisibleFlag = bl;
            return true;
        }

        public boolean setTickMarksInside(boolean bl) {
            this.mTickMarksInsideFlag = bl;
            return true;
        }

        public boolean setNumbersVisible(boolean bl) {
            this.mNumbersVisibleFlag = bl;
            return true;
        }

        public boolean setNumbersInteger(boolean bl) {
            this.mScaleNumbersIntegerFlag = bl;
            return true;
        }

        public boolean setExponentFlag(boolean bl) {
            this.mExponentFlag = bl;
            return true;
        }

        public boolean setExponentValue(int n) {
            int n2;
            if (n < -10) {
                return false;
            }
            if (n > 10) {
                return false;
            }
            this.mExponentValue = n2 = n;
            return true;
        }

        public boolean setNumbersAngle(float f) {
            Float f2 = SGUtility.calcPropertyValue(f, null, null, -180.0, 180.0, -2);
            if (f2 == null) {
                return false;
            }
            this.mNumbersAngle = f2.floatValue();
            return true;
        }

        public boolean hasValidAxisValues(Number number, Number number2, Integer n, Number number3, Number number4) {
            double d;
            double d2 = number != null ? number.doubleValue() : this.getMinValue();
            double d3 = number2 != null ? number2.doubleValue() : this.getMaxValue();
            int n2 = n != null ? n.intValue() : this.getScaleType();
            double d4 = d = number4 != null ? number4.doubleValue() : this.getStepValue();
            if (d2 >= d3) {
                return false;
            }
            if (n2 == 1 && d2 <= 0.0) {
                return false;
            }
            return d != 0.0;
        }

        public boolean hasValidAxisRange(Number number, Number number2, Integer n) {
            double d;
            int n2 = n != null ? n.intValue() : this.getScaleType();
            double d2 = number != null ? number.doubleValue() : this.getMinValue();
            double d3 = d = number2 != null ? number2.doubleValue() : this.getMaxValue();
            if (d2 >= d) {
                return false;
            }
            return n2 != 1 || !(d2 <= 0.0);
        }

        public boolean hasValidAxisValues(Number number, Number number2, Integer n) {
            double d;
            double d2 = d = number2 != null ? number2.doubleValue() : this.getStepValue();
            return d != 0.0;
        }

        public JPopupMenu getPopupMenu() {
            JPopupMenu jPopupMenu = null;
            if (this.mPopupMenu != null) {
                jPopupMenu = this.mPopupMenu;
            } else {
                this.mPopupMenu = jPopupMenu = this.createPopupMenu();
            }
            Component[] componentArray = jPopupMenu.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                if (!(componentArray[i] instanceof JCheckBoxMenuItem)) continue;
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)componentArray[i];
                String string = jCheckBoxMenuItem.getActionCommand();
                if ("Draw Later".equals(string)) {
                    jCheckBoxMenuItem.setSelected(!mNotifyChangeOnDraggingFlag);
                    continue;
                }
                if (!"Show Axis".equals(string)) continue;
                jCheckBoxMenuItem.setSelected(this.isAxisVisible());
            }
            return jPopupMenu;
        }

        protected JPopupMenu createPopupMenu() {
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.setBounds(0, 0, 100, 100);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("  -- Axis: ");
            stringBuffer.append(SGFigureElementAxis.this.getLocationName(this.mAxis));
            stringBuffer.append(" --");
            jPopupMenu.add(new JLabel(stringBuffer.toString()));
            jPopupMenu.addSeparator();
            SGUtility.addCheckBoxItem(jPopupMenu, this, "Show Axis");
            jPopupMenu.addSeparator();
            SGUtility.addCheckBoxItem(jPopupMenu, this, "Draw Later");
            jPopupMenu.addSeparator();
            SGUtility.addItem(jPopupMenu, this, "Property");
            return jPopupMenu;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("Show Axis")) {
                this.setAxisVisible(!this.isAxisVisible());
                SGFigureElementAxis.this.repaint();
                SGFigureElementAxis.this.setChanged(true);
                SGFigureElementAxis.this.notifyToRoot();
                return;
            }
            if (string.equals("Property")) {
                this.showPropertyDialog();
            } else if (string.equals("Draw Later")) {
                mNotifyChangeOnDraggingFlag = !mNotifyChangeOnDraggingFlag;
            }
        }

        protected void showPropertyDialog() {
            SGFigureElementAxis.this.mTempAxisLocation = this.getLocationInPlane();
            SGFigureElementAxis.this.showPropertyDialog();
            SGFigureElementAxis.this.mTempAxisLocation = -1;
        }

        protected void showPopupMenu(int n, int n2) {
            SGFigureElementAxis.this.showPopupMenu(this.getPopupMenu(), n, n2);
        }

        public void paintGraphics2D(Graphics2D graphics2D) {
            if (this.isAxisVisible()) {
                this.drawAxisLine(graphics2D);
                if (this.isTitleVisible()) {
                    this.drawTitle(graphics2D);
                }
                if (this.isNumbersVisible()) {
                    this.drawScaleNumbers(graphics2D);
                }
                if (this.isTickMarksVisible()) {
                    this.drawTickMarks(graphics2D);
                }
            }
        }

        protected void drawAxisLine(Graphics2D graphics2D) {
            for (int i = 0; i < this.mAxisLines.length; ++i) {
                ElementLineOfAxis elementLineOfAxis = this.mAxisLines[i];
                float f = SGFigureElementAxis.this.mMagnification * elementLineOfAxis.getLineWidth();
                BasicStroke basicStroke = new BasicStroke(f, 2, 0);
                SGFigureElementAxis.this.drawLine(elementLineOfAxis, graphics2D, basicStroke);
            }
        }

        protected void drawTitle(Graphics2D graphics2D) {
            SGFigureElementAxis.this.drawString(this.mTitle, graphics2D);
            if (this.mTitle.equals(SGFigureElementAxis.this.mPressedElement)) {
                SGFigureElementAxis.this.drawStringBounds(this.mTitle, graphics2D);
            }
        }

        protected void drawScaleNumbers(Graphics2D graphics2D) {
            ArrayList arrayList = this.mNumberList;
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementStringOfScale elementStringOfScale = (ElementStringOfScale)arrayList.get(i);
                SGFigureElementAxis.this.drawString(elementStringOfScale, graphics2D);
            }
            if (this.mDraggingElement != null && this.mDraggingElement instanceof ElementStringOfScale) {
                ElementStringOfScale elementStringOfScale = (ElementStringOfScale)this.mDraggingElement;
                SGFigureElementAxis.this.drawString(elementStringOfScale, graphics2D);
                SGFigureElementAxis.this.drawStringBounds(elementStringOfScale, graphics2D);
            }
            if (this.getExponentFlag()) {
                SGFigureElementAxis.this.drawString(this.mExponentDrawingElement, graphics2D);
            }
        }

        protected void drawTickMarks(Graphics2D graphics2D) {
            ArrayList arrayList = this.mTickMarksList;
            boolean bl = this.mDraggingElement != null && this.mDraggingElement instanceof ElementLineOfScale;
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementLineOfScale elementLineOfScale = (ElementLineOfScale)arrayList.get(i);
                float f = SGFigureElementAxis.this.mMagnification * elementLineOfScale.getLineWidth();
                float f2 = bl ? f * 2.0f : f;
                BasicStroke basicStroke = new BasicStroke(f2, 0, 2);
                if (bl) {
                    elementLineOfScale.setLineWidth(f2);
                }
                SGFigureElementAxis.this.drawLine(elementLineOfScale, graphics2D, basicStroke);
                if (!bl) continue;
                elementLineOfScale.setLineWidth(f);
            }
        }

        private double getTitleHeight() {
            Rectangle2D rectangle2D = this.mTitle.getStringRect();
            return rectangle2D.getHeight();
        }

        protected double getScaleHeight() {
            double d = 0.0;
            if (this.mNumberList.size() == 0) {
                Font font = new Font(SGFigureElementAxis.this.mScaleFontName, SGFigureElementAxis.this.mScaleFontStyle, (int)(SGFigureElementAxis.this.mMagnification * SGFigureElementAxis.this.mScaleFontSize));
                FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
                TextLayout textLayout = new TextLayout("0", font, fontRenderContext);
                Rectangle2D rectangle2D = textLayout.getOutline(new AffineTransform()).getBounds2D();
                d = rectangle2D.getHeight();
            } else {
                SGDrawingElementString2D sGDrawingElementString2D = (SGDrawingElementString2D)this.mNumberList.get(0);
                Rectangle2D rectangle2D = sGDrawingElementString2D.getStringRect();
                d = rectangle2D.getHeight();
            }
            return d;
        }

        protected int getLocationInPlane() {
            return this.mLocationInPlane;
        }

        protected boolean setLocationInPlane(int n) {
            this.mLocationInPlane = n;
            return true;
        }

        protected int getLocation() {
            return this.getLocationInPlane();
        }

        public boolean setMagnification(float f) {
            this.mTitle.setMagnification(f);
            ArrayList arrayList = this.mNumberList;
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementStringOfScale elementStringOfScale = (ElementStringOfScale)arrayList.get(i);
                elementStringOfScale.setMagnification(f);
            }
            if (this.mExponentDrawingElement != null) {
                this.mExponentDrawingElement.setMagnification(f);
            }
            return true;
        }

        protected Rectangle2D getBoundingBox() {
            if (!this.isAxisVisible()) {
                return null;
            }
            Rectangle2D.Float float_ = new Rectangle2D.Float();
            ArrayList<SGDrawingElement> arrayList = new ArrayList<SGDrawingElement>();
            for (int i = 0; i < this.mAxisLines.length; ++i) {
                arrayList.add(this.mAxisLines[i]);
            }
            if (this.isTitleVisible()) {
                arrayList.add(this.mTitle);
            }
            if (this.isNumbersVisible()) {
                ArrayList arrayList2 = this.mNumberList;
                for (int i = 0; i < arrayList2.size(); ++i) {
                    ElementStringOfScale elementStringOfScale = (ElementStringOfScale)arrayList2.get(i);
                    if (!elementStringOfScale.isVisible()) continue;
                    arrayList.add(elementStringOfScale);
                }
                if (this.getExponentFlag()) {
                    arrayList.add(this.mExponentDrawingElement);
                }
            }
            if (arrayList.size() != 0) {
                ((Rectangle2D)float_).setRect(SGUtilityJava2D.getBoundingBox(arrayList));
            }
            return float_;
        }

        public boolean onMouseClicked(MouseEvent mouseEvent) {
            SGDrawingElement sGDrawingElement;
            int n;
            boolean bl;
            int n2;
            int n3 = mouseEvent.getX();
            int n4 = mouseEvent.getY();
            for (n2 = 0; n2 < this.mAxisLines.length; ++n2) {
                bl = this.mAxisLines[n2].contains(n3, n4);
                if (!bl) continue;
                return this.clicked(mouseEvent);
            }
            if (!this.isAxisVisible()) {
                return false;
            }
            if (this.isTitleVisible() && (bl = this.mTitle.contains(n3, n4))) {
                if (SGFigureElementAxis.this.isEditing()) {
                    SGFigureElementAxis.this.closeTextField();
                }
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 1) {
                    SGFigureElementAxis.this.mEditingStringElement = this.mTitle;
                    n2 = ((SGFigureElementAxis)SGFigureElementAxis.this).mPressedPoint.x - (int)this.mTitle.getX();
                    int n5 = ((SGFigureElementAxis)SGFigureElementAxis.this).mPressedPoint.y - (int)this.mTitle.getY();
                    SGFigureElementAxis.this.showEditField(SGFigureElementAxis.this.mTextField, this.mTitle, n2, n5);
                    return true;
                }
                return this.clicked(mouseEvent);
            }
            if (this.isNumbersVisible()) {
                ArrayList arrayList = this.mNumberList;
                for (n = 0; n < arrayList.size(); ++n) {
                    sGDrawingElement = (ElementStringOfScale)arrayList.get(n);
                    bl = ((SGDrawingElementString2D)sGDrawingElement).contains(n3, n4);
                    if (!bl) continue;
                    return this.clicked(mouseEvent);
                }
            }
            if (this.mExponentDrawingElement != null && this.mExponentDrawingElement.isVisible() && (bl = this.mExponentDrawingElement.contains(n3, n4))) {
                return this.clicked(mouseEvent);
            }
            if (this.isTickMarksVisible()) {
                ArrayList arrayList = this.mTickMarksList;
                for (n = 0; n < arrayList.size(); ++n) {
                    sGDrawingElement = (ElementLineOfScale)arrayList.get(n);
                    bl = ((SGDrawingElementLine2D)sGDrawingElement).contains(n3, n4);
                    if (!bl) continue;
                    return this.clicked(mouseEvent);
                }
            }
            return false;
        }

        protected boolean clicked(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = mouseEvent.getClickCount();
            if (SwingUtilities.isRightMouseButton(mouseEvent) && n3 == 1) {
                this.showPopupMenu(n, n2);
            } else if (SwingUtilities.isLeftMouseButton(mouseEvent) && n3 == 2) {
                this.showPropertyDialog();
            }
            return true;
        }

        public boolean onMousePressed(MouseEvent mouseEvent) {
            SGDrawingElement sGDrawingElement;
            int n;
            boolean bl;
            if (!this.isAxisVisible()) {
                return false;
            }
            int n2 = mouseEvent.getX();
            int n3 = mouseEvent.getY();
            for (int i = 0; i < this.mAxisLines.length; ++i) {
                bl = this.mAxisLines[i].contains(n2, n3);
                if (!bl) continue;
                SGFigureElementAxis.this.prepare();
                return true;
            }
            if (this.isTitleVisible() && (bl = this.mTitle.contains(n2, n3))) {
                SGFigureElementAxis.this.mPressedElement = this.mTitle;
                SGFigureElementAxis.this.mPressedElementOrigin = new Point((int)((float)mouseEvent.getX() - this.mTitle.getX()), (int)((float)mouseEvent.getY() - this.mTitle.getY()));
                this.prepare();
                return true;
            }
            if (this.mExponentDrawingElement != null && this.mExponentDrawingElement.isVisible() && (bl = this.mExponentDrawingElement.contains(n2, n3))) {
                SGFigureElementAxis.this.mPressedElement = this.mExponentDrawingElement;
                SGFigureElementAxis.this.mPressedElementOrigin = new Point((int)((float)mouseEvent.getX() - this.mExponentDrawingElement.getX()), (int)((float)mouseEvent.getY() - this.mExponentDrawingElement.getY()));
                this.prepare();
                return true;
            }
            if (this.isNumbersVisible()) {
                ArrayList arrayList = this.mNumberList;
                for (n = 0; n < arrayList.size(); ++n) {
                    sGDrawingElement = (ElementStringOfScale)arrayList.get(n);
                    if (!sGDrawingElement.isVisible() || !((SGDrawingElementString2D)sGDrawingElement).contains(n2, n3)) continue;
                    SGFigureElementAxis.this.mPressedElement = sGDrawingElement;
                    SGFigureElementAxis.this.mPressedElementOrigin = new Point((int)((float)mouseEvent.getX() - ((SGDrawingElementString)sGDrawingElement).getX()), (int)((float)mouseEvent.getY() - ((SGDrawingElementString)sGDrawingElement).getY()));
                    this.mTempRange = this.mAxis.getRange();
                    this.mDraggingElement = new ElementStringOfScale((ElementStringOfScale)sGDrawingElement);
                    this.mDraggingElement.setMagnification(((SGDrawingElementString)sGDrawingElement).getMagnification());
                    this.prepare();
                    return true;
                }
            }
            if (this.isTickMarksVisible()) {
                ArrayList arrayList = this.mTickMarksList;
                for (n = 0; n < arrayList.size(); ++n) {
                    sGDrawingElement = (ElementLineOfScale)arrayList.get(n);
                    if (!sGDrawingElement.isVisible() || !((SGDrawingElementLine2D)sGDrawingElement).contains(n2, n3)) continue;
                    SGFigureElementAxis.this.mPressedElement = sGDrawingElement;
                    SGFigureElementAxis.this.mPressedElementOrigin = mouseEvent.getPoint();
                    this.mTempRange = this.mAxis.getRange();
                    this.mDraggingElement = this.createScaleLineInstance((ElementLineOfScale)sGDrawingElement);
                    this.mDraggingElement.setMagnification(((ElementLineOfScale)sGDrawingElement).getMagnification());
                    this.prepare();
                    return true;
                }
            }
            return false;
        }

        protected ElementLineOfScale createScaleLineInstance(ElementLineOfScale elementLineOfScale) {
            return new ElementLineOfScale(elementLineOfScale);
        }

        public boolean onMouseDragged(MouseEvent mouseEvent) {
            Object object;
            if (this.mDraggingElement == null || this.mTempRange == null) {
                return false;
            }
            int n = this.getLocationInPlane();
            boolean bl = this.mAxis.isInvertCoordinates();
            int n2 = this.mAxis.getScaleType();
            Rectangle2D rectangle2D = SGFigureElementAxis.this.getGraphRect();
            int n3 = (int)rectangle2D.getX();
            int n4 = (int)rectangle2D.getY();
            int n5 = (int)rectangle2D.getWidth();
            int n6 = (int)rectangle2D.getHeight();
            int n7 = n3;
            int n8 = n4;
            int n9 = n5;
            int n10 = n6;
            if (this.mDraggingElement instanceof ElementStringOfScale) {
                double d;
                double d2;
                double d3;
                double d4;
                float f;
                double d5;
                double d6;
                double d7;
                object = (ElementStringOfScale)this.mDraggingElement;
                Rectangle2D rectangle2D2 = ((ElementStringOfScale)object).getElementBounds();
                if (n2 == 0) {
                    d7 = this.mTempRange.x;
                    d6 = this.mTempRange.y;
                    d5 = ((ElementStringOfScale)object).mValue;
                } else if (n2 == 1) {
                    d7 = Math.log10(this.mTempRange.x);
                    d6 = Math.log10(this.mTempRange.y);
                    d5 = Math.log10(((ElementStringOfScale)object).mValue);
                } else {
                    throw new Error();
                }
                if (n == 0 || n == 1 || n == 10 || n == 11) {
                    double d8 = (double)(mouseEvent.getX() - ((SGFigureElementAxis)SGFigureElementAxis.this).mPressedElementOrigin.x) + rectangle2D2.getWidth() / 2.0;
                    f = this.mAxisLines[0].getStart().x;
                    float f2 = this.mAxisLines[0].getEnd().x;
                    if (bl) {
                        if (d8 < (double)f) {
                            d8 = f;
                        }
                        if (d8 >= (double)f2) {
                            return false;
                        }
                    } else {
                        if (d8 > (double)f2) {
                            d8 = f2;
                        }
                        if (d8 <= (double)f) {
                            return false;
                        }
                    }
                    double d9 = bl ? d7 + (d6 - d7) * ((double)f2 - d8) / (double)(f2 - f) : d7 + (d6 - d7) * (d8 - (double)f) / (double)(f2 - f);
                    d4 = d7;
                    d3 = d7 + (d6 - d7) * (d5 - d7) / (d9 - d7);
                    d4 = SGFigureElementAxis.this.getNumberInRangeOrder(d4, this.mAxis);
                    d3 = SGFigureElementAxis.this.getNumberInRangeOrder(d3, this.mAxis);
                    float f3 = (float)(d8 - rectangle2D2.getWidth() / 2.0);
                    ((SGDrawingElementString2DExtended)object).setX(f3);
                    float f4 = (float)((d3 - d4) / (d6 - d7));
                    if ((double)f4 < 0.05) {
                        return false;
                    }
                    n9 = (int)((float)n5 / f4);
                } else if (n == 2 || n == 3 || n == 12 || n == 13) {
                    float f5 = (float)(mouseEvent.getY() - ((SGFigureElementAxis)SGFigureElementAxis.this).mPressedElementOrigin.y) + (float)rectangle2D2.getHeight() / 2.0f;
                    float f6 = this.mAxisLines[0].getEnd().y;
                    f = this.mAxisLines[0].getStart().y;
                    if (bl) {
                        if (f5 <= f6) {
                            return false;
                        }
                        if (f5 > f) {
                            f5 = f;
                        }
                    } else {
                        if (f5 >= f) {
                            return false;
                        }
                        if (f5 < f6) {
                            f5 = f6;
                        }
                    }
                    double d10 = bl ? d7 + (d6 - d7) * (1.0 - (double)((f - f5) / (f - f6))) : d7 + (d6 - d7) * (1.0 - (double)((f5 - f6) / (f - f6)));
                    d4 = d7;
                    d3 = d7 + (d6 - d7) * (d5 - d7) / (d10 - d7);
                    d4 = SGFigureElementAxis.this.getNumberInRangeOrder(d4, this.mAxis);
                    d3 = SGFigureElementAxis.this.getNumberInRangeOrder(d3, this.mAxis);
                    float f7 = (float)((double)f5 - rectangle2D2.getHeight() / 2.0);
                    ((SGDrawingElementString2DExtended)object).setY(f7);
                    float f8 = (float)((d3 - d4) / (d6 - d7));
                    if ((double)f8 < 0.05) {
                        return false;
                    }
                    n10 = (int)((float)n6 / f8);
                    n8 = n4 + n6 - n10;
                } else {
                    throw new Error();
                }
                if (n2 == 0) {
                    d2 = d4;
                    d = d3;
                } else if (n2 == 1) {
                    d2 = Math.pow(10.0, d4);
                    d = Math.pow(10.0, d3);
                } else {
                    throw new Error();
                }
                this.mAxis.setScale(d2, d, n2);
            } else if (this.mDraggingElement instanceof ElementLineOfScale) {
                double d;
                double d11;
                double d12;
                double d13;
                float f;
                float f9;
                double d14;
                double d15;
                double d16;
                object = (ElementLineOfScale)this.mDraggingElement;
                if (n2 == 0) {
                    d16 = this.mTempRange.x;
                    d15 = this.mTempRange.y;
                    d14 = ((ElementLineOfScale)object).mValue;
                } else if (n2 == 1) {
                    d16 = Math.log(this.mTempRange.x) / Math.log(10.0);
                    d15 = Math.log(this.mTempRange.y) / Math.log(10.0);
                    d14 = Math.log(((ElementLineOfScale)object).mValue) / Math.log(10.0);
                } else {
                    throw new Error();
                }
                if (n == 0 || n == 1 || n == 10 || n == 11) {
                    f9 = mouseEvent.getX();
                    if ((float)((SGFigureElementAxis)SGFigureElementAxis.this).mPressedElementOrigin.x == f9) {
                        return false;
                    }
                    float f10 = this.mAxisLines[0].getStart().x;
                    f = this.mAxisLines[0].getEnd().x;
                    if (f9 > f) {
                        f9 = f;
                    }
                    if (f9 < f10) {
                        f9 = f10;
                    }
                    double d17 = bl ? d16 + (d15 - d16) * (double)(f - f9) / (double)(f - f10) : d16 + (d15 - d16) * (double)(f9 - f10) / (double)(f - f10);
                    double d18 = Math.abs(d17 - d14);
                    if (d17 > d14) {
                        d13 = d16 - d18;
                        d12 = d15 - d18;
                    } else {
                        d13 = d16 + d18;
                        d12 = d15 + d18;
                    }
                    d13 = SGFigureElementAxis.this.getNumberInRangeOrder(d13, this.mAxis);
                    d12 = SGFigureElementAxis.this.getNumberInRangeOrder(d12, this.mAxis);
                } else if (n == 2 || n == 3 || n == 12 || n == 13) {
                    f9 = mouseEvent.getY();
                    if ((float)((SGFigureElementAxis)SGFigureElementAxis.this).mPressedElementOrigin.y == f9) {
                        return false;
                    }
                    float f11 = this.mAxisLines[0].getEnd().y;
                    f = this.mAxisLines[0].getStart().y;
                    if (f9 > f) {
                        f9 = f;
                    }
                    if (f9 < f11) {
                        f9 = f11;
                    }
                    double d19 = bl ? d16 + (d15 - d16) * (1.0 - (double)((f - f9) / (f - f11))) : d16 + (d15 - d16) * (1.0 - (double)((f9 - f11) / (f - f11)));
                    double d20 = Math.abs(d19 - d14);
                    if (d19 > d14) {
                        d13 = d16 - d20;
                        d12 = d15 - d20;
                    } else {
                        d13 = d16 + d20;
                        d12 = d15 + d20;
                    }
                    d13 = SGFigureElementAxis.this.getNumberInRangeOrder(d13, this.mAxis);
                    d12 = SGFigureElementAxis.this.getNumberInRangeOrder(d12, this.mAxis);
                } else {
                    throw new Error();
                }
                if (n2 == 0) {
                    d11 = d13;
                    d = d12;
                } else if (n2 == 1) {
                    d11 = Math.pow(10.0, d13);
                    d = Math.pow(10.0, d12);
                } else {
                    throw new Error();
                }
                this.mAxis.setScale(d11, d, n2);
            }
            if (!this.createDrawingElements()) {
                return false;
            }
            object = new Rectangle();
            ((Rectangle)object).setRect(n7, n8, n9, n10);
            if (mNotifyChangeOnDraggingFlag) {
                SGFigureElementAxis.this.notifyChange();
            }
            return true;
        }

        public boolean onMouseReleased(MouseEvent mouseEvent) {
            if (this.mTempRange != null || this.mDraggingElement != null) {
                this.mTempRange = null;
                this.mDraggingElement = null;
                if (!SGFigureElementAxis.this.createAllDrawingElements()) {
                    return false;
                }
                SGFigureElementAxis.this.initializePressedElement();
                SGProperties sGProperties = SGFigureElementAxis.this.mTemporaryProperties;
                SGProperties sGProperties2 = SGFigureElementAxis.this.getProperties();
                if (!sGProperties.equals(sGProperties2)) {
                    SGFigureElementAxis.this.setChanged(true);
                }
                SGFigureElementAxis.this.mTemporaryProperties = null;
                return true;
            }
            return false;
        }

        public boolean onDrawingElement(int n, int n2) {
            boolean bl = false;
            if (this.isAxisVisible()) {
                bl = this.contains(n, n2);
            } else {
                for (int i = 0; i < this.mAxisLines.length && !(bl = this.mAxisLines[i].contains(n, n2)); ++i) {
                }
            }
            if (bl) {
                SGFigureElementAxis.this.setMouseCursor(12);
                return true;
            }
            return false;
        }

        public boolean contains(int n, int n2) {
            SGDrawingElement sGDrawingElement;
            int n3;
            for (int i = 0; i < this.mAxisLines.length; ++i) {
                if (!this.mAxisLines[i].contains(n, n2)) continue;
                return true;
            }
            if (this.isTitleVisible() && this.mTitle.contains(n, n2)) {
                return true;
            }
            if (this.isNumbersVisible()) {
                ArrayList arrayList = this.mNumberList;
                for (n3 = 0; n3 < arrayList.size(); ++n3) {
                    sGDrawingElement = (ElementStringOfScale)arrayList.get(n3);
                    if (!((SGDrawingElementString2D)sGDrawingElement).contains(n, n2)) continue;
                    return true;
                }
            }
            if (this.isTickMarksVisible()) {
                ArrayList arrayList = this.mTickMarksList;
                for (n3 = 0; n3 < arrayList.size(); ++n3) {
                    sGDrawingElement = (ElementLineOfScale)arrayList.get(n3);
                    if (!((SGDrawingElementLine2D)sGDrawingElement).contains(n, n2)) continue;
                    return true;
                }
            }
            return this.getExponentFlag() && this.mExponentDrawingElement.contains(n, n2);
        }

        protected boolean createDrawingElements() {
            if (!this.setAxisLineProperties()) {
                return false;
            }
            if (!this.setLocationOfAxisLines()) {
                return false;
            }
            if (!this.createScaleDrawingElements()) {
                return false;
            }
            if (!this.setTitleProperties()) {
                return false;
            }
            return this.setLocationOfTitle();
        }

        private boolean setLocationOfDrawingElements() {
            if (!this.setLocationOfAxisLines()) {
                return false;
            }
            if (this.isNumbersVisible() && !this.setLocationOfScaleNumbers()) {
                return false;
            }
            if (this.isTickMarksVisible() && !this.createTickMarks()) {
                return false;
            }
            return !this.isTitleVisible() || this.setLocationOfTitle();
        }

        private boolean createScaleDrawingElements() {
            if (!this.calcValueArrayInScale()) {
                return false;
            }
            if (!this.createScaleNumberInstances()) {
                return false;
            }
            if (!this.setLocationOfScaleNumbers()) {
                return false;
            }
            return this.createTickMarks();
        }

        protected boolean setLocationOfAxisLines() {
            float f;
            float f2;
            float f3;
            float f4;
            float f5 = SGFigureElementAxis.this.mGraphRectX;
            float f6 = SGFigureElementAxis.this.mGraphRectY;
            float f7 = SGFigureElementAxis.this.mGraphRectWidth;
            float f8 = SGFigureElementAxis.this.mGraphRectHeight;
            switch (this.getLocationInPlane()) {
                case 0: {
                    f4 = f5;
                    f3 = f6 + f8;
                    f2 = f5 + f7;
                    f = f3;
                    break;
                }
                case 1: {
                    f4 = f5;
                    f3 = f6;
                    f2 = f5 + f7;
                    f = f3;
                    break;
                }
                case 2: {
                    f4 = f5;
                    f3 = f6 + f8;
                    f2 = f4;
                    f = f6;
                    break;
                }
                case 3: {
                    f4 = f5 + f7;
                    f3 = f6 + f8;
                    f2 = f4;
                    f = f6;
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            this.mAxisLines[0].setTermPoints(f4, f3, f2, f);
            return true;
        }

        protected boolean setAxisLineProperties() {
            for (int i = 0; i < this.mAxisLines.length; ++i) {
                this.mAxisLines[i].setLineWidth(SGFigureElementAxis.this.getAxisLineWidth());
                this.mAxisLines[i].setColor(SGFigureElementAxis.this.mLineColor);
            }
            return true;
        }

        protected boolean setLocationOfTitle() {
            float f = SGFigureElementAxis.this.mGraphRectX;
            float f2 = SGFigureElementAxis.this.mGraphRectY;
            float f3 = SGFigureElementAxis.this.mGraphRectWidth;
            float f4 = SGFigureElementAxis.this.mGraphRectHeight;
            float f5 = SGFigureElementAxis.this.mMagnification;
            float f6 = SGFigureElementAxis.this.getSpaceAxisLineAndNumber() * f5;
            float f7 = SGFigureElementAxis.this.getSpaceNumberAndTitle() * f5;
            float f8 = 0.0f;
            float f9 = 0.0f;
            f8 = (float)this.getScaleHeight();
            f9 = SGFigureElementAxis.this.getMaxLengthOfScaleNumbers(this);
            switch (this.getLocationInPlane()) {
                case 0: {
                    Rectangle2D rectangle2D = this.mTitle.getElementBounds();
                    this.mTitle.setLocation(f + (f3 - (float)rectangle2D.getWidth()) / 2.0f, f2 + f4 + f8 + (f6 + f7));
                    break;
                }
                case 1: {
                    Rectangle2D rectangle2D = this.mTitle.getElementBounds();
                    this.mTitle.setLocation(f + (f3 - (float)rectangle2D.getWidth()) / 2.0f, f2 - f8 - (float)rectangle2D.getHeight() - (f6 + f7));
                    break;
                }
                case 2: {
                    this.mTitle.setAngle(90.0f);
                    Rectangle2D rectangle2D = this.mTitle.getElementBounds();
                    this.mTitle.setLocation(f - f9 - (float)rectangle2D.getWidth() - (f6 + f7), f2 + (f4 + (float)rectangle2D.getHeight()) / 2.0f);
                    break;
                }
                case 3: {
                    this.mTitle.setAngle(90.0f);
                    Rectangle2D rectangle2D = this.mTitle.getElementBounds();
                    this.mTitle.setLocation(f + f3 + f9 + (f6 + f7), f2 + (f4 + (float)rectangle2D.getHeight()) / 2.0f);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            return true;
        }

        protected boolean setTitleProperties() {
            this.mTitle.setColor(SGFigureElementAxis.this.mAxisFontColor);
            this.mTitle.setFont(SGFigureElementAxis.this.mTitleFontName, SGFigureElementAxis.this.mTitleFontStyle, SGFigureElementAxis.this.mTitleFontSize);
            return true;
        }

        private boolean createScaleNumberInstances() {
            int n;
            this.mNumberList.clear();
            this.mExponentDrawingElement = null;
            int n2 = this.mAxis.getScaleType();
            double[] dArray = this.mAxisValueArray;
            double[] dArray2 = null;
            int n3 = this.getExponentValue();
            if (this.getExponentFlag()) {
                dArray2 = new double[this.mAxisValueArray.length];
                for (int i = 0; i < dArray2.length; ++i) {
                    BigDecimal bigDecimal = new BigDecimal(Double.toString(dArray[i]));
                    bigDecimal = bigDecimal.movePointLeft(n3);
                    dArray2[i] = bigDecimal.doubleValue();
                }
            } else {
                dArray2 = dArray;
            }
            String[] stringArray = new String[dArray2.length];
            if (n2 == 0) {
                if (this.isNumbersInteger()) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringArray[i] = Integer.toString((int)dArray2[i]);
                    }
                } else {
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringArray[i] = Double.toString(dArray2[i]);
                    }
                }
            } else if (n2 == 1) {
                for (int i = 0; i < stringArray.length; ++i) {
                    n = SGUtilityNumber.getOrder(dArray2[i]);
                    stringArray[i] = SGUtilityText.getSuperscriptString("10", Integer.toString(n));
                }
            }
            float f = SGFigureElementAxis.this.mMagnification;
            for (n = 0; n < dArray.length; ++n) {
                ElementStringOfScale elementStringOfScale = this.createSingleTickMarkInstance(stringArray[n]);
                elementStringOfScale.mValue = dArray[n];
                if (!this.mAxis.insideRange(elementStringOfScale.mValue)) {
                    elementStringOfScale.setVisible(false);
                }
                elementStringOfScale.setMagnification(f);
                this.mNumberList.add(elementStringOfScale);
            }
            if (this.getExponentFlag()) {
                this.createExponentDrawingElement();
            }
            return true;
        }

        protected ElementStringOfScale createSingleTickMarkInstance(String string) {
            ElementStringOfScale elementStringOfScale = new ElementStringOfScale(string, SGFigureElementAxis.this.mScaleFontName, SGFigureElementAxis.this.mScaleFontStyle, SGFigureElementAxis.this.mScaleFontSize, SGFigureElementAxis.this.mAxisFontColor, SGFigureElementAxis.this.mMagnification, this.mNumbersAngle, this.mLocationInPlane);
            return elementStringOfScale;
        }

        private boolean createExponentDrawingElement() {
            String string = SGIConstants.multiply + "10";
            string = SGUtilityText.getSuperscriptString(string, Integer.toString(this.getExponentValue()));
            this.mExponentDrawingElement = this.createExponentStringElement(string);
            this.setLocationOfExponentDrawingElement();
            return true;
        }

        protected SGDrawingElementString2DExtended createExponentStringElement(String string) {
            SGDrawingElementString2DExtended sGDrawingElementString2DExtended = new SGDrawingElementString2DExtended(string, SGFigureElementAxis.this.mScaleFontName, SGFigureElementAxis.this.mScaleFontStyle, SGFigureElementAxis.this.mScaleFontSize, SGFigureElementAxis.this.mAxisFontColor, SGFigureElementAxis.this.mMagnification, 0.0f);
            return sGDrawingElementString2DExtended;
        }

        protected boolean setLocationOfExponentDrawingElement() {
            SGDrawingElementString2DExtended sGDrawingElementString2DExtended = this.mExponentDrawingElement;
            Rectangle2D rectangle2D = ((SGDrawingElementString2D)sGDrawingElementString2DExtended).getElementBounds();
            float f = SGFigureElementAxis.this.mGraphRectX;
            float f2 = SGFigureElementAxis.this.mGraphRectY;
            float f3 = SGFigureElementAxis.this.mGraphRectWidth;
            float f4 = SGFigureElementAxis.this.mGraphRectHeight;
            float f5 = SGFigureElementAxis.this.mMagnification;
            float f6 = SGFigureElementAxis.this.getSpaceAxisLineAndNumber() * f5;
            float f7 = SGFigureElementAxis.this.getSpaceNumberAndTitle() * f5;
            float f8 = 0.0f;
            float f9 = 0.0f;
            switch (this.getLocationInPlane()) {
                case 0: {
                    f8 = f + f3 - 0.0f * (float)rectangle2D.getWidth();
                    f9 = f2 + f4 + (float)((double)f6 + this.getScaleHeight() + (double)f7);
                    break;
                }
                case 1: {
                    f8 = f + f3 - 0.0f * (float)rectangle2D.getWidth();
                    f9 = f2 - (float)((double)f6 + this.getScaleHeight() + (double)f7 + this.getTitleHeight());
                    break;
                }
                case 2: {
                    f8 = f - (float)((double)(f6 + SGFigureElementAxis.this.getMaxLengthOfScaleNumbers(this) + f7) + rectangle2D.getWidth());
                    f9 = f2 - (float)rectangle2D.getHeight();
                    break;
                }
                case 3: {
                    f8 = f + f3 + f6 + SGFigureElementAxis.this.getMaxLengthOfScaleNumbers(this) + f7;
                    f9 = f2 - (float)rectangle2D.getHeight();
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            sGDrawingElementString2DExtended.setLocation(f8, f9);
            return true;
        }

        protected boolean setLocationOfScaleNumbers() {
            int n = this.getLocationInPlane();
            boolean bl = this.isInvertCoordinates();
            float f = SGFigureElementAxis.this.mGraphRectX;
            float f2 = SGFigureElementAxis.this.mGraphRectY;
            float f3 = SGFigureElementAxis.this.mGraphRectWidth;
            float f4 = SGFigureElementAxis.this.mGraphRectHeight;
            int n2 = this.mAxis.getScaleType();
            double[] dArray = null;
            if (n2 == 0) {
                dArray = this.mAxisValueArray;
            } else if (n2 == 1) {
                dArray = new double[this.mAxisValueArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    dArray[i] = Math.log(this.mAxisValueArray[i]);
                }
            }
            double d = 0.0;
            double d2 = 0.0;
            if (n2 == 0) {
                d = this.mAxis.getMinValue();
                d2 = this.mAxis.getMaxValue();
            } else if (n2 == 1) {
                d = Math.log(this.mAxis.getMinValue());
                d2 = Math.log(this.mAxis.getMaxValue());
            }
            float f5 = SGFigureElementAxis.this.mMagnification;
            float f6 = SGFigureElementAxis.this.getSpaceAxisLineAndNumber() * f5;
            block7: for (int i = 0; i < this.mNumberList.size(); ++i) {
                ElementStringOfScale elementStringOfScale = (ElementStringOfScale)this.mNumberList.get(i);
                Rectangle2D rectangle2D = elementStringOfScale.getElementBounds();
                float f7 = (float)rectangle2D.getWidth();
                float f8 = (float)rectangle2D.getHeight();
                switch (n) {
                    case 0: {
                        float f9 = bl ? (float)((double)f + (double)f3 * (d2 - dArray[i]) / (d2 - d)) : (float)((double)f + (double)f3 * (dArray[i] - d) / (d2 - d));
                        float f10 = f2 + f4 + f6;
                        elementStringOfScale.setLocation(f9 - 0.5f * f7, f10);
                        continue block7;
                    }
                    case 1: {
                        float f9 = bl ? (float)((double)f + (double)f3 * (d2 - dArray[i]) / (d2 - d)) : (float)((double)f + (double)f3 * (dArray[i] - d) / (d2 - d));
                        float f10 = (float)((double)(f2 - f6) - rectangle2D.getHeight());
                        elementStringOfScale.setLocation(f9 - 0.5f * f7, f10);
                        continue block7;
                    }
                    case 2: {
                        float f9 = bl ? (float)((double)f2 + (double)f4 * (1.0 - (d2 - dArray[i]) / (d2 - d))) : (float)((double)f2 + (double)f4 * (1.0 - (dArray[i] - d) / (d2 - d)));
                        float f10 = (float)((double)(f - f6) - rectangle2D.getWidth());
                        elementStringOfScale.setLocation(f10, f9 - 0.5f * f8);
                        continue block7;
                    }
                    case 3: {
                        float f9 = bl ? (float)((double)f2 + (double)f4 * (1.0 - (d2 - dArray[i]) / (d2 - d))) : (float)((double)f2 + (double)f4 * (1.0 - (dArray[i] - d) / (d2 - d)));
                        float f10 = f + f3 + f6;
                        elementStringOfScale.setLocation(f10, f9 - 0.5f * f8);
                        continue block7;
                    }
                    default: {
                        throw new Error();
                    }
                }
            }
            if (this.getExponentFlag()) {
                this.setLocationOfExponentDrawingElement();
            }
            return true;
        }

        protected boolean createTickMarks() {
            this.mTickMarksList.clear();
            boolean bl = true;
            switch (this.mAxis.getScaleType()) {
                case 0: {
                    bl = this.createTickMarksInLinearScale(SGFigureElementAxis.this.getTickMarkWidth(), SGFigureElementAxis.this.mTickMarkLength, SGFigureElementAxis.this.mLineColor);
                    break;
                }
                case 1: {
                    bl = this.createTickMarksInLogScale(SGFigureElementAxis.this.getTickMarkWidth(), SGFigureElementAxis.this.mTickMarkLength, SGFigureElementAxis.this.mLineColor);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            return bl;
        }

        protected boolean createTickMarksInLinearScale(float f, float f2, Color color) {
            double d;
            int n;
            float f3 = SGFigureElementAxis.this.mMagnification * f2;
            double[] dArray = this.mAxisValueArray;
            for (n = 0; n < dArray.length; ++n) {
                d = dArray[n];
                this.createTickMarkPair(d, f, f3, color);
            }
            for (n = 0; n < dArray.length && n != dArray.length - 1; ++n) {
                d = (dArray[n] + dArray[n + 1]) / 2.0;
                this.createTickMarkPair(d, f, f3, color);
            }
            return true;
        }

        private void createTickMarkPair(double d, float f, float f2, Color color) {
            ElementLineOfScale elementLineOfScale;
            ElementLineOfScale elementLineOfScale2 = this.createSingleTickMark(d, f, f2);
            if (elementLineOfScale2 != null) {
                this.setupCreatedScaleLineProperties(elementLineOfScale2, d, color);
            }
            if ((elementLineOfScale = this.createSingleTickMarkCounter(d, f, f2)) != null) {
                this.setupCreatedScaleLineProperties(elementLineOfScale, d, color);
            }
        }

        protected boolean createTickMarksInLogScale(float f, float f2, Color color) {
            ElementLineOfScale elementLineOfScale;
            int n;
            ElementLineOfScale elementLineOfScale2;
            float f3 = SGFigureElementAxis.this.mMagnification * f2;
            for (int i = 0; i < this.mAxisValueArray.length; ++i) {
                double d = this.mAxisValueArray[i];
                ElementLineOfScale elementLineOfScale3 = this.createSingleTickMark(d, f, f3);
                if (elementLineOfScale3 != null) {
                    this.setupCreatedScaleLineProperties(elementLineOfScale3, d, color);
                }
                if ((elementLineOfScale2 = this.createSingleTickMarkCounter(d, f, f3)) == null) continue;
                this.setupCreatedScaleLineProperties(elementLineOfScale2, d, color);
            }
            for (n = 0; n < this.mAxisValueArray.length; ++n) {
                for (int i = 2; i < 10; ++i) {
                    ElementLineOfScale elementLineOfScale4;
                    double d = this.mAxisValueArray[n] * 0.1 * (double)i;
                    elementLineOfScale = this.createSingleTickMark(d, f, 1.0f * f3);
                    if (elementLineOfScale != null) {
                        this.setupCreatedScaleLineProperties(elementLineOfScale, d, color);
                    }
                    if ((elementLineOfScale4 = this.createSingleTickMarkCounter(d, f, f3)) == null) continue;
                    this.setupCreatedScaleLineProperties(elementLineOfScale4, d, color);
                }
            }
            if (this.mAxisValueArray.length >= 1) {
                for (n = 2; n < 10; ++n) {
                    double d = this.mAxisValueArray[this.mAxisValueArray.length - 1] * (double)n;
                    elementLineOfScale2 = this.createSingleTickMark(d, f, 1.0f * f3);
                    if (elementLineOfScale2 != null) {
                        this.setupCreatedScaleLineProperties(elementLineOfScale2, d, color);
                    }
                    if ((elementLineOfScale = this.createSingleTickMarkCounter(d, f, f3)) == null) continue;
                    this.setupCreatedScaleLineProperties(elementLineOfScale, d, color);
                }
            }
            return true;
        }

        protected void setupCreatedScaleLineProperties(ElementLineOfScale elementLineOfScale, double d, Color color) {
            elementLineOfScale.mValue = d;
            elementLineOfScale.setMagnification(SGFigureElementAxis.this.mMagnification);
            elementLineOfScale.setColor(color);
            this.mTickMarksList.add(elementLineOfScale);
        }

        protected ElementLineOfScale createSingleTickMark(double d, float f, float f2) {
            SGTuple2f sGTuple2f;
            SGTuple2f sGTuple2f2;
            double d2;
            double d3;
            double d4;
            if (!this.mAxis.insideRange(d)) {
                return null;
            }
            float f3 = SGFigureElementAxis.this.mGraphRectX;
            float f4 = SGFigureElementAxis.this.mGraphRectY;
            float f5 = SGFigureElementAxis.this.mGraphRectWidth;
            float f6 = SGFigureElementAxis.this.mGraphRectHeight;
            float f7 = SGFigureElementAxis.this.mMagnification;
            boolean bl = this.isTickMarksInside();
            boolean bl2 = this.isInvertCoordinates();
            switch (this.mAxis.getScaleType()) {
                case 0: {
                    d4 = this.mAxis.getMinValue();
                    d3 = this.mAxis.getMaxValue();
                    d2 = d;
                    break;
                }
                case 1: {
                    d4 = Math.log(this.mAxis.getMinValue());
                    d3 = Math.log(this.mAxis.getMaxValue());
                    d2 = Math.log(d);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            ElementLineOfScale elementLineOfScale = null;
            switch (this.getLocationInPlane()) {
                case 0: {
                    double d5 = bl2 ? (double)f3 + (double)f5 * (d3 - d2) / (d3 - d4) : (double)f3 + (double)f5 * (d2 - d4) / (d3 - d4);
                    double d6 = f4 + f6;
                    double d7 = bl ? d6 - (double)f2 : d6 + (double)f2;
                    sGTuple2f2 = new SGTuple2f((float)d5, (float)d6);
                    sGTuple2f = new SGTuple2f((float)d5, (float)d7);
                    break;
                }
                case 1: {
                    double d8 = bl2 ? (double)f3 + (double)f5 * (d3 - d2) / (d3 - d4) : (double)f3 + (double)f5 * (d2 - d4) / (d3 - d4);
                    double d9 = f4;
                    double d10 = bl ? d9 + (double)f2 : d9 - (double)f2;
                    sGTuple2f2 = new SGTuple2f((float)d8, (float)d9);
                    sGTuple2f = new SGTuple2f((float)d8, (float)d10);
                    break;
                }
                case 2: {
                    double d11 = bl2 ? (double)f4 + (double)f6 * (1.0 - (d3 - d2) / (d3 - d4)) : (double)f4 + (double)f6 * (1.0 - (d2 - d4) / (d3 - d4));
                    double d12 = f3;
                    double d13 = bl ? d12 + (double)f2 : d12 - (double)f2;
                    sGTuple2f2 = new SGTuple2f((float)d12, (float)d11);
                    sGTuple2f = new SGTuple2f((float)d13, (float)d11);
                    break;
                }
                case 3: {
                    double d14 = bl2 ? (double)f4 + (double)f6 * (1.0 - (d3 - d2) / (d3 - d4)) : (double)f4 + (double)f6 * (1.0 - (d2 - d4) / (d3 - d4));
                    double d15 = f3 + f5;
                    double d16 = bl ? d15 - (double)f2 : d15 + (double)f2;
                    sGTuple2f2 = new SGTuple2f((float)d15, (float)d14);
                    sGTuple2f = new SGTuple2f((float)d16, (float)d14);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            elementLineOfScale = new ElementLineOfScale(sGTuple2f2, sGTuple2f);
            elementLineOfScale.setLineWidth(f);
            elementLineOfScale.setMagnification(f7);
            return elementLineOfScale;
        }

        protected ElementLineOfScale createSingleTickMarkCounter(double d, float f, float f2) {
            return null;
        }

        private boolean calcValueArrayInScale() {
            double[] dArray = null;
            switch (this.mAxis.getScaleType()) {
                case 0: {
                    dArray = this.calcScaleValuesInLinearScale();
                    break;
                }
                case 1: {
                    dArray = this.calcScaleValuesInLogScale();
                    break;
                }
            }
            this.mAxisValueArray = dArray;
            return true;
        }

        private double[] calcScaleValuesInLinearScale() {
            double d;
            int n;
            double d2;
            double d3;
            SGAxis sGAxis = this.mAxis;
            if (this.isCalculateAutomatically()) {
                d3 = 0.0;
                d2 = SGFigureElementAxis.this.calcStepValue(sGAxis);
                this.mBaselineValue = d3;
                this.mStepValue = d2;
            } else {
                d3 = this.getBaselineValue();
                d2 = Math.abs(this.getStepValue());
            }
            double[] dArray = SGUtilityNumber.calcStepValueSorted(sGAxis.getMinValue(), sGAxis.getMaxValue(), d3, d2, 4);
            if (SGFigureElementAxis.this.mStartFlag) {
                boolean bl = true;
                for (n = 0; n < dArray.length; ++n) {
                    d = dArray[n];
                    long l = Math.round(d);
                    double d4 = Math.abs(d - (double)l);
                    if (d4 == 0.0) continue;
                    bl = false;
                    break;
                }
                this.setNumbersInteger(bl);
            }
            if (this.isNumbersInteger()) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (n = 0; n < dArray.length; ++n) {
                    if (this.getExponentFlag()) {
                        BigDecimal bigDecimal = new BigDecimal(Double.toString(dArray[n]));
                        bigDecimal = bigDecimal.movePointLeft(this.getExponentValue());
                        d = bigDecimal.doubleValue();
                    } else {
                        d = dArray[n];
                    }
                    int n2 = (int)d;
                    if (!(Math.abs((double)n2 - d) < Double.MIN_VALUE)) continue;
                    arrayList.add(n2);
                }
                block2: for (n = arrayList.size() - 1; n >= 1; --n) {
                    Integer n3 = (Integer)arrayList.get(n);
                    for (int i = n - 1; i >= 0; --i) {
                        Integer n4 = (Integer)arrayList.get(i);
                        if (n4.intValue() != n3.intValue()) continue;
                        arrayList.remove(n);
                        continue block2;
                    }
                }
                double[] dArray2 = new double[arrayList.size()];
                for (int i = 0; i < dArray2.length; ++i) {
                    double d5 = ((Integer)arrayList.get(i)).doubleValue();
                    if (this.getExponentFlag()) {
                        BigDecimal bigDecimal = new BigDecimal(Double.toString(d5));
                        bigDecimal = bigDecimal.movePointRight(this.getExponentValue());
                        d5 = bigDecimal.doubleValue();
                    }
                    dArray2[i] = d5;
                }
                dArray = dArray2;
            }
            return dArray;
        }

        private double[] calcScaleValuesInLogScale() {
            int n;
            SGTuple2d sGTuple2d = this.mAxis.getRange();
            double d = sGTuple2d.x;
            double d2 = sGTuple2d.y;
            double[] dArray = null;
            int n2 = SGUtilityNumber.getOrder(d);
            int n3 = SGUtilityNumber.getOrder(d2);
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (n = n2; n <= n3; ++n) {
                arrayList.add(n);
            }
            dArray = new double[arrayList.size()];
            for (n = 0; n < dArray.length; ++n) {
                int n4 = (Integer)arrayList.get(n);
                dArray[n] = SGUtilityNumber.getPowersOfTen(n4);
            }
            return dArray;
        }

        public String getTagName() {
            return "Axis";
        }

        public Element createElement(Document document) {
            Element element = document.createElement(this.getTagName());
            if (!this.writeProperty(element)) {
                return null;
            }
            return element;
        }

        public boolean writeProperty(Element element) {
            int n = this.getLocationInPlane();
            String string = SGFigureElementAxis.this.getLocationName(n);
            element.setAttribute("Position", string);
            element.setAttribute("AxisVisible", Boolean.toString(this.isAxisVisible()));
            return this.writeCommonProperties(element);
        }

        protected boolean writeCommonProperties(Element element) {
            SGTuple2d sGTuple2d = this.mAxis.getRange();
            element.setAttribute("ScaleType", SGUtilityText.getScaleTypeName(this.mAxis.getScaleType()));
            element.setAttribute("MinValue", Double.toString(sGTuple2d.x));
            element.setAttribute("MaxValue", Double.toString(sGTuple2d.y));
            element.setAttribute("InvertCoordinates", Boolean.toString(this.isInvertCoordinates()));
            element.setAttribute("AutomaticCalculationOfTick", Boolean.toString(this.isCalculateAutomatically()));
            element.setAttribute("StepValue", Double.toString(this.getStepValue()));
            element.setAttribute("BaselineValue", Double.toString(this.getBaselineValue()));
            element.setAttribute("TitleVisible", Boolean.toString(this.isTitleVisible()));
            element.setAttribute("Title", this.getTitleString());
            element.setAttribute("NumberVisible", Boolean.toString(this.isNumbersVisible()));
            element.setAttribute("NumberInteger", Boolean.toString(this.isNumbersInteger()));
            element.setAttribute("TickMarkVisible", Boolean.toString(this.isTickMarksVisible()));
            element.setAttribute("TickMarkInside", Boolean.toString(this.isTickMarksInside()));
            element.setAttribute("Exponent", Boolean.toString(this.getExponentFlag()));
            element.setAttribute("ExponentValue", Integer.toString(this.getExponentValue()));
            element.setAttribute("NumberAngle", Float.toString(this.getNumbersAngle()));
            return true;
        }

        protected boolean readCommonProperties(Element element) {
            String string = null;
            Number number = null;
            Boolean bl = null;
            string = element.getAttribute("ScaleType");
            if (string.length() == 0) {
                return false;
            }
            int n = SGUtilityText.getScaleType(string);
            if (n == -1) {
                return false;
            }
            string = element.getAttribute("MinValue");
            if (string.length() == 0) {
                return false;
            }
            number = SGUtilityText.getDouble(string);
            if (number == null) {
                return false;
            }
            double d = number.doubleValue();
            string = element.getAttribute("MaxValue");
            if (string.length() == 0) {
                return false;
            }
            number = SGUtilityText.getDouble(string);
            if (number == null) {
                return false;
            }
            double d2 = number.doubleValue();
            string = element.getAttribute("InvertCoordinates");
            bl = string.length() == 0 ? Boolean.FALSE : SGUtilityText.getBoolean(string);
            boolean bl2 = bl;
            string = element.getAttribute("AutomaticCalculationOfTick");
            if (string.length() == 0) {
                return false;
            }
            bl = SGUtilityText.getBoolean(string);
            if (bl == null) {
                return false;
            }
            boolean bl3 = bl;
            string = element.getAttribute("StepValue");
            if (string.length() == 0) {
                return false;
            }
            number = SGUtilityText.getDouble(string);
            if (number == null) {
                return false;
            }
            double d3 = number.doubleValue();
            string = element.getAttribute("BaselineValue");
            if (string.length() == 0) {
                return false;
            }
            number = SGUtilityText.getDouble(string);
            if (number == null) {
                return false;
            }
            double d4 = number.doubleValue();
            string = element.getAttribute("TitleVisible");
            if (string.length() == 0) {
                return false;
            }
            bl = SGUtilityText.getBoolean(string);
            if (bl == null) {
                return false;
            }
            boolean bl4 = bl;
            String string2 = string = element.getAttribute("Title");
            string = element.getAttribute("NumberVisible");
            if (string.length() == 0) {
                return false;
            }
            bl = SGUtilityText.getBoolean(string);
            if (bl == null) {
                return false;
            }
            boolean bl5 = bl;
            string = element.getAttribute("NumberInteger");
            if (string.length() == 0) {
                return false;
            }
            bl = SGUtilityText.getBoolean(string);
            if (bl == null) {
                return false;
            }
            boolean bl6 = bl;
            string = element.getAttribute("TickMarkVisible");
            if (string.length() == 0) {
                return false;
            }
            bl = SGUtilityText.getBoolean(string);
            if (bl == null) {
                return false;
            }
            boolean bl7 = bl;
            string = element.getAttribute("TickMarkInside");
            if (string.length() == 0) {
                return false;
            }
            bl = SGUtilityText.getBoolean(string);
            if (bl == null) {
                return false;
            }
            boolean bl8 = bl;
            string = element.getAttribute("Exponent");
            if (string.length() == 0) {
                return false;
            }
            bl = SGUtilityText.getBoolean(string);
            if (bl == null) {
                return false;
            }
            boolean bl9 = bl;
            string = element.getAttribute("ExponentValue");
            if (string.length() == 0) {
                return false;
            }
            number = SGUtilityText.getInteger(string);
            if (number == null) {
                return false;
            }
            int n2 = number.intValue();
            float f = 0.0f;
            string = element.getAttribute("NumberAngle");
            if (string.length() != 0) {
                number = SGUtilityText.getFloat(string);
                if (number == null) {
                    return false;
                }
                f = number.floatValue();
            }
            if (!this.setScale(d, d2, n)) {
                return false;
            }
            if (!this.setInvertCoordinates(bl2)) {
                return false;
            }
            if (!this.setCalculateAutomatically(bl3)) {
                return false;
            }
            if (!this.setStepValue(d3)) {
                return false;
            }
            if (!this.setBaselineValue(d4)) {
                return false;
            }
            if (!this.setTitleVisible(bl4)) {
                return false;
            }
            if (!this.setTitle(string2)) {
                return false;
            }
            if (!this.setNumbersVisible(bl5)) {
                return false;
            }
            if (!this.setNumbersInteger(bl6)) {
                return false;
            }
            if (!this.setTickMarksVisible(bl7)) {
                return false;
            }
            if (!this.setTickMarksInside(bl8)) {
                return false;
            }
            if (!this.setExponentFlag(bl9)) {
                return false;
            }
            if (!this.setExponentValue(n2)) {
                return false;
            }
            return this.setNumbersAngle(f);
        }

        protected boolean readProperties(Element element) {
            if (!this.readCommonProperties(element)) {
                return false;
            }
            String string = null;
            Boolean bl = null;
            string = element.getAttribute("AxisVisible");
            if (string.length() == 0) {
                return false;
            }
            bl = SGUtilityText.getBoolean(string);
            if (bl == null) {
                return false;
            }
            boolean bl2 = bl;
            return this.setAxisVisible(bl2);
        }

        public SGProperties getProperties() {
            AxisIndividualProperties axisIndividualProperties = new AxisIndividualProperties();
            if (!this.getProperties(axisIndividualProperties)) {
                return null;
            }
            return axisIndividualProperties;
        }

        public boolean getProperties(SGProperties sGProperties) {
            AxisIndividualProperties axisIndividualProperties = (AxisIndividualProperties)sGProperties;
            axisIndividualProperties.location = this.getLocationInPlane();
            axisIndividualProperties.scaleType = this.mAxis.getScaleType();
            SGTuple2d sGTuple2d = this.mAxis.getRange();
            axisIndividualProperties.minValue = sGTuple2d.x;
            axisIndividualProperties.maxValue = sGTuple2d.y;
            axisIndividualProperties.invertCoordinatesFlag = this.isInvertCoordinates();
            axisIndividualProperties.autoCalcAxisNumberFlag = this.isCalculateAutomatically();
            axisIndividualProperties.incrementValue = this.getStepValue();
            axisIndividualProperties.baseTickValue = this.getBaselineValue();
            axisIndividualProperties.titleString = this.mTitle.getString();
            axisIndividualProperties.axisVisibleFlag = this.isAxisVisible();
            axisIndividualProperties.titleVisibleFlag = this.isTitleVisible();
            axisIndividualProperties.scaleLinesVisibleFlag = this.isTickMarksVisible();
            axisIndividualProperties.scaleNumbersVisibleFlag = this.isNumbersVisible();
            axisIndividualProperties.scaleLinesInsideFlag = this.isTickMarksInside();
            axisIndividualProperties.scaleNumbersIntegerFlag = this.isNumbersInteger();
            axisIndividualProperties.exponentFlag = this.getExponentFlag();
            axisIndividualProperties.exponentValue = this.getExponentValue();
            axisIndividualProperties.scaleNumbersAngle = this.getNumbersAngle();
            return true;
        }

        public boolean setProperties(SGProperties sGProperties) {
            AxisIndividualProperties axisIndividualProperties = (AxisIndividualProperties)sGProperties;
            this.mLocationInPlane = axisIndividualProperties.location;
            this.mAxis.setScale(axisIndividualProperties.minValue, axisIndividualProperties.maxValue, axisIndividualProperties.scaleType);
            this.setInvertCoordinates(axisIndividualProperties.invertCoordinatesFlag);
            this.setCalculateAutomatically(axisIndividualProperties.autoCalcAxisNumberFlag);
            this.setStepValue(axisIndividualProperties.incrementValue);
            this.setBaselineValue(axisIndividualProperties.baseTickValue);
            this.setTitle(axisIndividualProperties.titleString);
            this.setAxisVisible(axisIndividualProperties.axisVisibleFlag);
            this.setTitleVisible(axisIndividualProperties.titleVisibleFlag);
            this.setTickMarksVisible(axisIndividualProperties.scaleLinesVisibleFlag);
            this.setNumbersVisible(axisIndividualProperties.scaleNumbersVisibleFlag);
            this.setTickMarksInside(axisIndividualProperties.scaleLinesInsideFlag);
            this.setNumbersInteger(axisIndividualProperties.scaleNumbersIntegerFlag);
            this.setExponentFlag(axisIndividualProperties.exponentFlag);
            this.setExponentValue(axisIndividualProperties.exponentValue);
            this.setNumbersAngle(axisIndividualProperties.scaleNumbersAngle);
            return true;
        }

        public SGPropertyResults setProperties(SGPropertyMap sGPropertyMap) {
            SGPropertyResults sGPropertyResults = new SGPropertyResults();
            if (!this.prepare()) {
                return null;
            }
            if ((sGPropertyResults = this.setProperties(sGPropertyMap, sGPropertyResults)) == null) {
                return null;
            }
            if (!this.commit()) {
                return null;
            }
            SGFigureElementAxis.this.notifyToRoot();
            SGFigureElementAxis.this.notifyChange();
            SGFigureElementAxis.this.repaint();
            return sGPropertyResults;
        }

        protected SGPropertyResults setProperties(SGPropertyMap sGPropertyMap, SGPropertyResults sGPropertyResults) {
            SGPropertyResults sGPropertyResults2 = (SGPropertyResults)sGPropertyResults.clone();
            Iterator<String> iterator = sGPropertyMap.getKeyIterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                String string2 = sGPropertyMap.getValueString(string);
                if ("Visible".equalsIgnoreCase(string)) {
                    Boolean bl = SGUtilityText.getBoolean(string2);
                    if (bl == null) {
                        sGPropertyResults2.putResult("Visible", 1);
                        continue;
                    }
                    if (!this.setAxisVisible(bl)) {
                        sGPropertyResults2.putResult("Visible", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("Visible", 0);
                    continue;
                }
                if ("TitleVisible".equalsIgnoreCase(string)) {
                    Boolean bl = SGUtilityText.getBoolean(string2);
                    if (bl == null) {
                        sGPropertyResults2.putResult("TitleVisible", 1);
                        continue;
                    }
                    if (!this.setTitleVisible(bl)) {
                        sGPropertyResults2.putResult("TitleVisible", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("TitleVisible", 0);
                    continue;
                }
                if ("TitleText".equalsIgnoreCase(string)) {
                    if (!sGPropertyMap.isDoubleQuoted(string)) {
                        sGPropertyResults2.putResult("TitleText", 1);
                        continue;
                    }
                    if (!this.setTitle(string2)) {
                        sGPropertyResults2.putResult("TitleText", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("TitleText", 0);
                    continue;
                }
                if ("ScaleMinValue".equalsIgnoreCase(string)) {
                    Double d = SGUtilityText.getDouble(string2);
                    if (d == null) {
                        sGPropertyResults2.putResult("ScaleMinValue", 1);
                        continue;
                    }
                    if (!SGUtility.isValidPropertyValue(d)) {
                        sGPropertyResults2.putResult("ScaleMinValue", 1);
                        continue;
                    }
                    if (!this.setScale(d, null)) {
                        sGPropertyResults2.putResult("ScaleMinValue", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("ScaleMinValue", 0);
                    continue;
                }
                if ("ScaleMaxValue".equalsIgnoreCase(string)) {
                    Double d = SGUtilityText.getDouble(string2);
                    if (d == null) {
                        sGPropertyResults2.putResult("ScaleMaxValue", 1);
                        continue;
                    }
                    if (!SGUtility.isValidPropertyValue(d)) {
                        sGPropertyResults2.putResult("ScaleMaxValue", 1);
                        continue;
                    }
                    if (!this.setScale(null, d)) {
                        sGPropertyResults2.putResult("ScaleMaxValue", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("ScaleMaxValue", 0);
                    continue;
                }
                if ("ScaleRange".equalsIgnoreCase(string)) {
                    String[] stringArray = SGUtilityText.getStringsInBracket(string2);
                    if (stringArray == null) {
                        sGPropertyResults2.putResult("ScaleRange", 1);
                        continue;
                    }
                    Double d = null;
                    Double d2 = null;
                    if (stringArray.length >= 2) {
                        d = SGUtilityText.getDouble(stringArray[0]);
                        d2 = SGUtilityText.getDouble(stringArray[1]);
                    }
                    if (d == null || d2 == null) {
                        sGPropertyResults2.putResult("ScaleRange", 1);
                        continue;
                    }
                    if (!SGUtility.isValidPropertyValue(d)) {
                        sGPropertyResults2.putResult("ScaleRange", 1);
                        continue;
                    }
                    if (!SGUtility.isValidPropertyValue(d2)) {
                        sGPropertyResults2.putResult("ScaleRange", 1);
                        continue;
                    }
                    if (stringArray.length == 2) {
                        if (!this.setScale(d, d2)) {
                            sGPropertyResults2.putResult("ScaleRange", 1);
                            continue;
                        }
                    } else if (stringArray.length == 3) {
                        int n = SGUtilityText.getScaleType(stringArray[2]);
                        if (n == -1) {
                            sGPropertyResults2.putResult("ScaleRange", 1);
                            continue;
                        }
                        if (!this.setScale(d, d2, n)) {
                            sGPropertyResults2.putResult("ScaleRange", 1);
                            continue;
                        }
                    } else {
                        sGPropertyResults2.putResult("ScaleRange", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("ScaleRange", 0);
                    continue;
                }
                if ("ScaleType".equalsIgnoreCase(string)) {
                    int n = SGUtilityText.getScaleType(string2);
                    if (n == -1) {
                        sGPropertyResults2.putResult("ScaleType", 1);
                        continue;
                    }
                    if (!this.setScaleType(n)) {
                        sGPropertyResults2.putResult("ScaleType", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("ScaleType", 0);
                    continue;
                }
                if ("InvertCoordinates".equalsIgnoreCase(string)) {
                    Boolean bl = SGUtilityText.getBoolean(string2);
                    if (bl == null) {
                        sGPropertyResults2.putResult("InvertCoordinates", 1);
                        continue;
                    }
                    if (!this.setInvertCoordinates(bl)) {
                        sGPropertyResults2.putResult("InvertCoordinates", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("InvertCoordinates", 0);
                    continue;
                }
                if ("TickMarkVisible".equalsIgnoreCase(string)) {
                    Boolean bl = SGUtilityText.getBoolean(string2);
                    if (bl == null) {
                        sGPropertyResults2.putResult("TickMarkVisible", 1);
                        continue;
                    }
                    if (!this.setTickMarksVisible(bl)) {
                        sGPropertyResults2.putResult("TickMarkVisible", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("TickMarkVisible", 0);
                    continue;
                }
                if ("TickMarkAuto".equalsIgnoreCase(string)) {
                    Boolean bl = SGUtilityText.getBoolean(string2);
                    if (bl == null) {
                        sGPropertyResults2.putResult("TickMarkAuto", 1);
                        continue;
                    }
                    if (!this.setCalculateAutomatically(bl)) {
                        sGPropertyResults2.putResult("TickMarkAuto", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("TickMarkAuto", 0);
                    continue;
                }
                if ("TickMarkStep".equalsIgnoreCase(string)) {
                    Double d = SGUtilityText.getDouble(string2);
                    if (d == null) {
                        sGPropertyResults2.putResult("TickMarkStep", 1);
                        continue;
                    }
                    if (!SGUtility.isValidPropertyValue(d)) {
                        sGPropertyResults2.putResult("TickMarkStep", 1);
                        continue;
                    }
                    if (!this.setStepValue(d)) {
                        sGPropertyResults2.putResult("TickMarkStep", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("TickMarkStep", 0);
                    continue;
                }
                if ("TickMarkBase".equalsIgnoreCase(string)) {
                    Double d = SGUtilityText.getDouble(string2);
                    if (d == null) {
                        sGPropertyResults2.putResult("TickMarkBase", 1);
                        continue;
                    }
                    if (!SGUtility.isValidPropertyValue(d)) {
                        sGPropertyResults2.putResult("TickMarkBase", 1);
                        continue;
                    }
                    if (!this.setBaselineValue(d)) {
                        sGPropertyResults2.putResult("TickMarkBase", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("TickMarkBase", 0);
                    continue;
                }
                if ("TickMarkInner".equalsIgnoreCase(string)) {
                    Boolean bl = SGUtilityText.getBoolean(string2);
                    if (bl == null) {
                        sGPropertyResults2.putResult("TickMarkInner", 1);
                        continue;
                    }
                    if (!this.setTickMarksInside(bl)) {
                        sGPropertyResults2.putResult("TickMarkInner", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("TickMarkInner", 0);
                    continue;
                }
                if ("NumberVisible".equalsIgnoreCase(string)) {
                    Boolean bl = SGUtilityText.getBoolean(string2);
                    if (bl == null) {
                        sGPropertyResults2.putResult("NumberVisible", 1);
                        continue;
                    }
                    if (!this.setNumbersVisible(bl)) {
                        sGPropertyResults2.putResult("NumberVisible", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("NumberVisible", 0);
                    continue;
                }
                if ("NumberInteger".equalsIgnoreCase(string)) {
                    Boolean bl = SGUtilityText.getBoolean(string2);
                    if (bl == null) {
                        sGPropertyResults2.putResult("NumberInteger", 1);
                        continue;
                    }
                    if (!this.setNumbersInteger(bl)) {
                        sGPropertyResults2.putResult("NumberInteger", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("NumberInteger", 0);
                    continue;
                }
                if ("NumberFormatExponentVisible".equalsIgnoreCase(string)) {
                    Boolean bl = SGUtilityText.getBoolean(string2);
                    if (bl == null) {
                        sGPropertyResults2.putResult("NumberFormatExponentVisible", 1);
                        continue;
                    }
                    if (!this.setExponentFlag(bl)) {
                        sGPropertyResults2.putResult("NumberFormatExponentVisible", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("NumberFormatExponentVisible", 0);
                    continue;
                }
                if ("NumberFormatExponentValue".equalsIgnoreCase(string)) {
                    Integer n = SGUtilityText.getInteger(string2);
                    if (n == null) {
                        sGPropertyResults2.putResult("NumberFormatExponentValue", 1);
                        continue;
                    }
                    if (!this.setExponentValue(n)) {
                        sGPropertyResults2.putResult("NumberFormatExponentValue", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("NumberFormatExponentValue", 0);
                    continue;
                }
                if (!"NumberAngle".equalsIgnoreCase(string)) continue;
                Float f = SGUtilityText.getFloat(string2);
                if (f == null) {
                    sGPropertyResults2.putResult("NumberAngle", 1);
                    continue;
                }
                if (!this.setNumbersAngle(f.intValue())) {
                    sGPropertyResults2.putResult("NumberAngle", 1);
                    continue;
                }
                sGPropertyResults2.putResult("NumberAngle", 0);
            }
            return sGPropertyResults2;
        }
    }

    private static class ElementStringOfScale
    extends SGDrawingElementString2DExtended {
        private double mValue;
        private final int mLocationInPlane;

        ElementStringOfScale(String string, String string2, int n, float f, Color color, float f2, float f3, int n2) {
            super(string, string2, n, f, color, f2, f3);
            this.mLocationInPlane = n2;
        }

        ElementStringOfScale(ElementStringOfScale elementStringOfScale) {
            super(elementStringOfScale);
            this.mValue = elementStringOfScale.mValue;
            this.mLocationInPlane = elementStringOfScale.mLocationInPlane;
        }

        private float[] movePositionForRotation() {
            Rectangle2D rectangle2D;
            float f;
            float f2;
            float f3 = this.getX();
            float f4 = this.getY();
            float f5 = this.getAngle();
            Rectangle2D rectangle2D2 = super.getElementBounds();
            if ((double)f4 > rectangle2D2.getY()) {
                f2 = f4 - (float)rectangle2D2.getY();
                this.setY(f4 + f2);
            }
            if (f5 > 90.0f && f5 <= 120.0f) {
                f2 = (float)rectangle2D2.getWidth();
                this.setX(f3 + f2 / 30.0f * (f5 - 90.0f));
            } else if (f5 > 120.0f) {
                f2 = (float)rectangle2D2.getWidth();
                this.setX(f3 + f2);
            } else if ((double)f5 < 0.0 && f5 >= -90.0f) {
                f2 = (float)rectangle2D2.getWidth();
                this.setX(f3 + f2 / 90.0f * -f5);
            } else if (f5 < -90.0f) {
                f2 = (float)rectangle2D2.getWidth();
                this.setX(f3 + f2);
            }
            if (this.mLocationInPlane == 2 || this.mLocationInPlane == 12) {
                Rectangle2D rectangle2D3 = super.getElementBounds();
                float f6 = (float)(rectangle2D3.getX() + rectangle2D3.getWidth() - (double)f3 - rectangle2D2.getWidth());
                if (f6 > 0.0f) {
                    this.setX(this.getX() - f6);
                }
            } else if ((this.mLocationInPlane == 3 || this.mLocationInPlane == 13) && (f = (float)((rectangle2D = super.getElementBounds()).getX() - (double)f3)) > 0.0f) {
                this.setX(this.getX() - f);
            }
            return new float[]{f3, f4};
        }

        public void paint(Graphics2D graphics2D) {
            float[] fArray = this.movePositionForRotation();
            super.paint(graphics2D);
            this.setX(fArray[0]);
            this.setY(fArray[1]);
        }

        public Rectangle2D getElementBounds() {
            float[] fArray = this.movePositionForRotation();
            Rectangle2D rectangle2D = super.getElementBounds();
            this.setX(fArray[0]);
            this.setY(fArray[1]);
            return rectangle2D;
        }
    }

    private class ElementLineOfScale
    extends SGDrawingElementLine2D {
        private SGTuple2f mStart = new SGTuple2f();
        private SGTuple2f mEnd = new SGTuple2f();
        private double mValue;

        ElementLineOfScale(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
            this.mStart.setValues(sGTuple2f);
            this.mEnd.setValues(sGTuple2f2);
        }

        ElementLineOfScale(ElementLineOfScale elementLineOfScale) {
            this.mValue = elementLineOfScale.mValue;
        }

        public Color getColor() {
            return SGFigureElementAxis.this.getLineColor();
        }

        public SGTuple2f getEnd() {
            return this.mEnd;
        }

        public SGTuple2f getStart() {
            return this.mStart;
        }

        protected SGStroke getStroke() {
            return SGFigureElementAxis.this.mTickMarkStroke;
        }

        public boolean setColor(Color color) {
            return true;
        }

        public boolean setLineType(int n) {
            return true;
        }

        public boolean setLineWidth(float f) {
            return true;
        }

        public boolean setTermPoints(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
            this.mStart.setValues(sGTuple2f);
            this.mEnd.setValues(sGTuple2f2);
            return true;
        }

        public float getMagnification() {
            return SGFigureElementAxis.this.getMagnification();
        }

        public boolean setMagnification(float f) {
            return true;
        }
    }

    private static class ElementStringOfTitle
    extends SGDrawingElementString2DExtended {
        ElementStringOfTitle() {
        }
    }

    private static class ElementLineOfAxis
    extends SGSimpleLine2D {
        ElementLineOfAxis() {
        }
    }
}

