/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGGradationPaint;
import jp.riken.brain.ni.samuraigraph.base.SGIAnchored;
import jp.riken.brain.ni.samuraigraph.base.SGIChildObject;
import jp.riken.brain.ni.samuraigraph.base.SGICopiable;
import jp.riken.brain.ni.samuraigraph.base.SGIDisposable;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementAxis;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementAxisBreak;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementGraph;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementGrid;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementLegend;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementShape;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementSignificantDifference;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementString;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementTimingLine;
import jp.riken.brain.ni.samuraigraph.base.SGINode;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGISelectable;
import jp.riken.brain.ni.samuraigraph.base.SGIUndoable;
import jp.riken.brain.ni.samuraigraph.base.SGPatternPaint;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyMap;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyResults;
import jp.riken.brain.ni.samuraigraph.base.SGSelectablePaint;
import jp.riken.brain.ni.samuraigraph.base.SGUndoManager;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementArrow;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementRectangle;
import jp.riken.brain.ni.samuraigraph.figure.SGFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.SGIArrowConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGIRectangleConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGIShapeConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGArrowDialog;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGFigureElement2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIArrowDialogObserver;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIDrawingElementJava2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIRectangularShapeDialogObserver;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGRectangularShapeDialog;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGSimpleArrow2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGSimpleRectangle2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityForFigureElementJava2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGFigureElementShape
extends SGFigureElement2D
implements SGIFigureElementShape,
SGIShapeConstants {
    private SGIFigureElementAxis mAxisElement = null;
    private HashMap mShapeDialogMap = new HashMap();

    @Override
    public void setAxisElement(SGIFigureElementAxis sGIFigureElementAxis) {
        this.mAxisElement = sGIFigureElementAxis;
    }

    @Override
    public void dispose() {
        super.dispose();
        for (SGPropertyDialog sGPropertyDialog : this.mShapeDialogMap.values()) {
            sGPropertyDialog.dispose();
        }
        this.mShapeDialogMap.clear();
        this.mShapeDialogMap = null;
        this.mAxisElement = null;
    }

    public SGIFigureElementAxis getAxisElement() {
        return this.mAxisElement;
    }

    private SGPropertyDialog getShapeDialog(IElement iElement) {
        String string = null;
        if (iElement instanceof Rect) {
            string = "Rectangle";
        } else if (iElement instanceof Arrow) {
            string = "Arrow";
        } else {
            throw new Error("Unsupported shape: " + iElement);
        }
        Object v = this.mShapeDialogMap.get(string);
        SGPropertyDialog sGPropertyDialog = null;
        if (v != null) {
            sGPropertyDialog = (SGPropertyDialog)v;
        } else {
            if (iElement instanceof Rect) {
                sGPropertyDialog = new SGRectangularShapeDialog(this.mDialogOwner, true);
            } else if (iElement instanceof Arrow) {
                sGPropertyDialog = new SGArrowDialog(this.mDialogOwner, true);
            }
            this.mShapeDialogMap.put(string, sGPropertyDialog);
        }
        return sGPropertyDialog;
    }

    @Override
    public boolean synchronize(SGIFigureElement sGIFigureElement, String string) {
        boolean bl = true;
        if (!(sGIFigureElement instanceof SGIFigureElementGraph || sGIFigureElement instanceof SGIFigureElementString || sGIFigureElement instanceof SGIFigureElementLegend)) {
            if (sGIFigureElement instanceof SGIFigureElementAxis) {
                bl = this.synchronizeToAxisElement((SGIFigureElementAxis)sGIFigureElement, string);
            } else if (!(sGIFigureElement instanceof SGIFigureElementAxisBreak || sGIFigureElement instanceof SGIFigureElementSignificantDifference || sGIFigureElement instanceof SGIFigureElementTimingLine || sGIFigureElement instanceof SGIFigureElementGrid || sGIFigureElement instanceof SGIFigureElementShape)) {
                bl = sGIFigureElement.synchronizeArgument(this, string);
            }
        }
        return bl;
    }

    private boolean synchronizeToAxisElement(SGIFigureElementAxis sGIFigureElementAxis, String string) {
        List<SGIChildObject> list = this.getVisibleChildList();
        for (int i = 0; i < list.size(); ++i) {
            ShapeObject shapeObject = (ShapeObject)list.get(i);
            if (!shapeObject.getIElement().isAnchored()) {
                shapeObject.setShapeWithAxesValues();
                continue;
            }
            shapeObject.setAxisValuesWithShape();
            shapeObject.setChanged(true);
        }
        return true;
    }

    @Override
    public boolean synchronizeArgument(SGIFigureElement sGIFigureElement, String string) {
        throw new Error();
    }

    @Override
    public boolean addShape(int n, float f, float f2) {
        if (!this.getGraphRect().contains(f, f2)) {
            return false;
        }
        SGAxis sGAxis = this.mAxisElement.getAxis("Bottom");
        SGAxis sGAxis2 = this.mAxisElement.getAxis("Left");
        return this.addShape(this.assignChildId(), n, f, f2, sGAxis, sGAxis2);
    }

    private boolean addShape(int n, int n2, float f, float f2, SGAxis sGAxis, SGAxis sGAxis2) {
        float f3 = this.getMagnification();
        if (n2 == 0) {
            return this.addRectangle(n, f, f2, sGAxis, sGAxis2);
        }
        if (n2 == 1) {
            return this.addEllipse(n, f, f2, sGAxis, sGAxis2);
        }
        if (n2 == 2) {
            float f4 = f + f3 * 60.0f;
            float f5 = f2 + f3 * 20.0f;
            return this.addArrow(n, f, f2, f4, f5, sGAxis, sGAxis2);
        }
        if (n2 == 3) {
            float f6 = f + f3 * 60.0f;
            float f7 = f2 + f3 * 20.0f;
            return this.addLine(n, f, f2, f6, f7, sGAxis, sGAxis2);
        }
        return true;
    }

    @Override
    public boolean addShape(int n, int n2, double d, double d2) {
        return this.addShape(n, n2, d, d2, "Bottom", "Left");
    }

    @Override
    public boolean addShape(int n, int n2, double d, double d2, String string, String string2) {
        float f;
        SGAxis sGAxis = this.mAxisElement.getAxis(string);
        SGAxis sGAxis2 = this.mAxisElement.getAxis(string2);
        if (sGAxis == null || sGAxis2 == null) {
            return false;
        }
        if (!sGAxis.isValidValue(d)) {
            return false;
        }
        if (!sGAxis2.isValidValue(d2)) {
            return false;
        }
        float f2 = this.calcLocation(d, sGAxis, true);
        return this.addShape(n, n2, f2, f = this.calcLocation(d2, sGAxis2, false), sGAxis, sGAxis2);
    }

    private boolean addRectangle(int n, float f, float f2, SGAxis sGAxis, SGAxis sGAxis2) {
        Rect rect = new Rect();
        rect.setMagnification(this.getMagnification());
        ShapeObject shapeObject = new ShapeObject(n, rect, sGAxis, sGAxis2);
        rect.setShapeObject(shapeObject);
        rect.setLocation(f, f2);
        rect.setAxisValuesWithShape();
        return this.addShape(n, shapeObject);
    }

    private boolean addEllipse(int n, float f, float f2, SGAxis sGAxis, SGAxis sGAxis2) {
        Ellipse ellipse = new Ellipse();
        ellipse.setMagnification(this.getMagnification());
        ShapeObject shapeObject = new ShapeObject(n, ellipse, sGAxis, sGAxis2);
        ellipse.setShapeObject(shapeObject);
        ellipse.setLocation(f, f2);
        ellipse.setAxisValuesWithShape();
        return this.addShape(n, shapeObject);
    }

    private boolean addRectangularShape(int n, Rect rect, double d, double d2, double d3, double d4, SGAxis sGAxis, SGAxis sGAxis2) {
        rect.setMagnification(this.getMagnification());
        ShapeObject shapeObject = new ShapeObject(n, rect, sGAxis, sGAxis2);
        rect.setShapeObject(shapeObject);
        if (!rect.setLeftXValue(d)) {
            return false;
        }
        if (!rect.setRightXValue(d2)) {
            return false;
        }
        if (!rect.setTopYValue(d3)) {
            return false;
        }
        if (!rect.setBottomYValue(d4)) {
            return false;
        }
        return this.addShape(n, shapeObject);
    }

    private boolean addArrow(int n, float f, float f2, float f3, float f4, SGAxis sGAxis, SGAxis sGAxis2) {
        Arrow arrow = new Arrow();
        return this.addArrow(n, arrow, -1, 10, f, f2, f3, f4, sGAxis, sGAxis2);
    }

    private boolean addLine(int n, float f, float f2, float f3, float f4, SGAxis sGAxis, SGAxis sGAxis2) {
        Arrow arrow = new Arrow();
        return this.addArrow(n, arrow, -1, -1, f, f2, f3, f4, sGAxis, sGAxis2);
    }

    private boolean addArrow(int n, Arrow arrow, int n2, int n3, float f, float f2, float f3, float f4, SGAxis sGAxis, SGAxis sGAxis2) {
        ShapeObject shapeObject = new ShapeObject(n, arrow, sGAxis, sGAxis2);
        arrow.setMagnification(this.getMagnification());
        arrow.setShapeObject(shapeObject);
        arrow.setStartHeadType(n2);
        arrow.setEndHeadType(n3);
        arrow.setStartX(f);
        arrow.setStartY(f2);
        arrow.setEndX(f3);
        arrow.setEndY(f4);
        arrow.setAxisValuesWithShape();
        return this.addShape(n, shapeObject);
    }

    private boolean addArrowShape(int n, Arrow arrow, double d, double d2, double d3, double d4, SGAxis sGAxis, SGAxis sGAxis2) {
        if (!sGAxis.isValidValue(d)) {
            return false;
        }
        if (!sGAxis2.isValidValue(d2)) {
            return false;
        }
        if (!sGAxis.isValidValue(d3)) {
            return false;
        }
        if (!sGAxis2.isValidValue(d4)) {
            return false;
        }
        arrow.setMagnification(this.getMagnification());
        ShapeObject shapeObject = new ShapeObject(n, arrow, sGAxis, sGAxis2);
        arrow.setShapeObject(shapeObject);
        arrow.setStartXValue(d);
        arrow.setStartYValue(d2);
        arrow.setEndXValue(d3);
        arrow.setEndYValue(d4);
        return this.addShape(n, shapeObject);
    }

    private boolean addShape(int n, ShapeObject shapeObject) {
        if (!this.addToList(n, shapeObject)) {
            return false;
        }
        shapeObject.initPropertiesHistory();
        this.setChanged(true);
        this.notifyToRoot();
        return true;
    }

    private boolean clearFocusedObjectOtherThan(ShapeObject shapeObject) {
        Class<?> clazz = shapeObject.getIElement().getClass();
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            ShapeObject shapeObject2 = (ShapeObject)arrayList.get(i);
            Class<?> clazz2 = shapeObject2.getIElement().getClass();
            if (clazz2.isAssignableFrom(clazz) || clazz.isAssignableFrom(clazz2)) continue;
            shapeObject2.setSelected(false);
        }
        return true;
    }

    @Override
    public boolean setGraphRect(float f, float f2, float f3, float f4) {
        if (!super.setGraphRect(f, f2, f3, f4)) {
            return false;
        }
        List list = this.mChildList;
        for (int i = 0; i < list.size(); ++i) {
            ShapeObject shapeObject = (ShapeObject)list.get(i);
            if (!shapeObject.getIElement().isAnchored()) {
                shapeObject.setShapeWithAxesValues();
                continue;
            }
            shapeObject.setAxisValuesWithShape();
        }
        return true;
    }

    @Override
    public SGProperties getProperties() {
        ShapeElementProperties shapeElementProperties = new ShapeElementProperties();
        shapeElementProperties.visibleShapeList = new ArrayList<SGIChildObject>(this.getVisibleChildList());
        return shapeElementProperties;
    }

    @Override
    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof ShapeElementProperties)) {
            return false;
        }
        ShapeElementProperties shapeElementProperties = (ShapeElementProperties)sGProperties;
        boolean bl = this.setVisibleChildList(shapeElementProperties.visibleShapeList);
        return bl;
    }

    @Override
    public boolean setMementoBackward() {
        boolean bl = super.setMementoBackward();
        if (!bl) {
            return false;
        }
        this.clearFocusedObjects();
        this.notifyChangeOnUndo();
        return true;
    }

    @Override
    public boolean setMementoForward() {
        boolean bl = super.setMementoForward();
        if (!bl) {
            return false;
        }
        this.clearFocusedObjects();
        this.notifyChangeOnUndo();
        return true;
    }

    @Override
    public boolean duplicateFocusedObjects() {
        int n = (int)(this.mMagnification * 10.0f);
        int n2 = (int)(this.mMagnification * 10.0f);
        List<SGICopiable> list = this.duplicateObjects();
        for (int i = 0; i < list.size(); ++i) {
            ShapeObject shapeObject = (ShapeObject)list.get(i);
            shapeObject.translate(n, n2);
            shapeObject.setSelected(true);
            this.addToList(shapeObject);
            shapeObject.initPropertiesHistory();
        }
        if (list.size() != 0) {
            this.setChanged(true);
        }
        return true;
    }

    @Override
    public boolean paste(List<SGICopiable> list) {
        float f = this.getMagnification();
        int n = (int)(f * 10.0f);
        int n2 = (int)(f * 10.0f);
        int n3 = 0;
        for (int i = 0; i < list.size(); ++i) {
            SGICopiable sGICopiable = list.get(i);
            if (!(sGICopiable instanceof ShapeObject)) continue;
            ShapeObject shapeObject = (ShapeObject)sGICopiable;
            shapeObject.translate(n, n2);
            SGProperties sGProperties = shapeObject.getMemento();
            IElement iElement = (IElement)shapeObject.getIElement().copy();
            ShapeObject shapeObject2 = new ShapeObject(iElement);
            iElement.setShapeObject(shapeObject2);
            shapeObject2.setMagnification(f);
            shapeObject2.setMemento(sGProperties);
            shapeObject2.setXAxis(this.mAxisElement.getAxisInPlane(shapeObject.mTempXAxis));
            shapeObject2.setYAxis(this.mAxisElement.getAxisInPlane(shapeObject.mTempYAxis));
            shapeObject2.setShapeWithAxesValues();
            this.addToList(shapeObject2);
            shapeObject2.initPropertiesHistory();
            ++n3;
        }
        if (n3 != 0) {
            this.setChanged(true);
        }
        return true;
    }

    @Override
    public String getTagName() {
        return "Shape";
    }

    @Override
    public boolean writeProperty(Element element) {
        return true;
    }

    @Override
    public boolean onMouseClicked(MouseEvent mouseEvent) {
        List<SGIChildObject> list = this.getVisibleChildList();
        for (int i = list.size() - 1; i >= 0; --i) {
            ShapeObject shapeObject = (ShapeObject)list.get(i);
            if (!shapeObject.isValid() || !this.clickDrawingElements(shapeObject, mouseEvent)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ArrayList getPropertyDialogObserverList() {
        ArrayList arrayList = this.getFocusedObjectsList();
        ArrayList<IElement> arrayList2 = new ArrayList<IElement>();
        for (int i = 0; i < arrayList.size(); ++i) {
            ShapeObject shapeObject = (ShapeObject)arrayList.get(i);
            arrayList2.add(shapeObject.getIElement());
        }
        return arrayList2;
    }

    private boolean clickDrawingElements(ShapeObject shapeObject, MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = mouseEvent.getClickCount();
        if (shapeObject.contains(n, n2)) {
            this.updateFocusedObjectsList((SGISelectable)shapeObject, mouseEvent);
            if (!SwingUtilities.isLeftMouseButton(mouseEvent) || n3 != 1) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && n3 == 2) {
                    this.setPropertiesOfSelectedObjects();
                } else if (SwingUtilities.isRightMouseButton(mouseEvent) && n3 == 1) {
                    shapeObject.getPopupMenu().show(this.getComponent(), n, n2);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onMousePressed(MouseEvent mouseEvent) {
        List<SGIChildObject> list = this.getVisibleChildList();
        for (int i = list.size() - 1; i >= 0; --i) {
            ShapeObject shapeObject = (ShapeObject)list.get(i);
            if (!shapeObject.isValid() || !shapeObject.press(mouseEvent)) continue;
            this.mPressedPoint = mouseEvent.getPoint();
            if (shapeObject.isSelected()) {
                this.mDraggableFlag = true;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onMouseDragged(MouseEvent mouseEvent) {
        if (this.mPressedPoint == null) {
            return false;
        }
        if (!this.mDraggableFlag) {
            return false;
        }
        ArrayList arrayList = this.getFocusedObjectsList();
        if (arrayList.size() == 1) {
            ShapeObject shapeObject = (ShapeObject)arrayList.get(0);
            if (!shapeObject.drag(mouseEvent)) {
                return false;
            }
            shapeObject.setAxisValuesWithShape();
        } else {
            int n = mouseEvent.getX() - this.mPressedPoint.x;
            int n2 = mouseEvent.getY() - this.mPressedPoint.y;
            for (int i = 0; i < arrayList.size(); ++i) {
                ShapeObject shapeObject = (ShapeObject)arrayList.get(i);
                if (!shapeObject.isValid()) continue;
                shapeObject.translate(n, n2);
                shapeObject.setAxisValuesWithShape();
            }
        }
        this.mPressedPoint = mouseEvent.getPoint();
        return true;
    }

    @Override
    public boolean onMouseReleased(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            ShapeObject shapeObject = (ShapeObject)arrayList.get(i);
            if (!shapeObject.isValid()) continue;
            if (shapeObject.contains(n, n2)) {
                this.setMouseCursor(12);
                continue;
            }
            this.setMouseCursor(0);
        }
        this.mDraggableFlag = false;
        this.notifyToRoot();
        return false;
    }

    @Override
    public boolean onDrawingElement(int n, int n2) {
        List<SGIChildObject> list = this.getVisibleChildList();
        for (int i = list.size() - 1; i >= 0; --i) {
            boolean bl;
            ShapeObject shapeObject = (ShapeObject)list.get(i);
            if (!shapeObject.isValid() || !(bl = shapeObject.contains(n, n2))) continue;
            if (shapeObject.isSelected()) {
                int n3 = shapeObject.getMouseLocation(n, n2);
                shapeObject.mMouseLocation = n3;
                this.setMouseCursor(shapeObject.getCursor(n3));
                return true;
            }
            this.setMouseCursor(12);
            return true;
        }
        return false;
    }

    @Override
    public Element[] createElement(Document document) {
        Element element = this.createThisElement(document);
        if (element == null) {
            return null;
        }
        List<SGIChildObject> list = this.getVisibleChildList();
        for (int i = 0; i < list.size(); ++i) {
            ShapeObject shapeObject = (ShapeObject)list.get(i);
            if (!shapeObject.isValid()) continue;
            Element element2 = shapeObject.createElement(document);
            if (element2 == null) {
                return null;
            }
            element.appendChild(element2);
        }
        return new Element[]{element};
    }

    @Override
    public boolean readProperty(Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            ShapeObject shapeObject = new ShapeObject();
            Element element2 = (Element)node;
            if (!shapeObject.readProperty(element2)) {
                return false;
            }
            shapeObject.initPropertiesHistory();
            this.addToList(shapeObject);
        }
        return true;
    }

    @Override
    public boolean setTemporaryPropertiesOfFocusedObjects() {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            ShapeObject shapeObject = (ShapeObject)arrayList.get(i);
            shapeObject.mTemporaryProperties = shapeObject.getMemento();
        }
        return true;
    }

    @Override
    public boolean setChangedFocusedObjects() {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGProperties sGProperties;
            ShapeObject shapeObject = (ShapeObject)arrayList.get(i);
            SGProperties sGProperties2 = shapeObject.mTemporaryProperties;
            if (sGProperties2 == null || (sGProperties = shapeObject.getMemento()).equals(sGProperties2)) continue;
            shapeObject.setChanged(true);
        }
        return true;
    }

    @Override
    public void paintGraphics(Graphics graphics, boolean bl) {
        Object object;
        ShapeObject shapeObject;
        int n;
        Graphics2D graphics2D = (Graphics2D)graphics;
        List<SGIChildObject> list = this.getVisibleChildList();
        for (n = 0; n < list.size(); ++n) {
            shapeObject = (ShapeObject)list.get(n);
            if (!shapeObject.isValid()) continue;
            shapeObject.paintElement(graphics2D);
        }
        if (this.mSymbolsVisibleFlagAroundAllObjects) {
            for (n = 0; n < list.size(); ++n) {
                shapeObject = (ShapeObject)list.get(n);
                if (!shapeObject.isValid()) continue;
                object = shapeObject.getAnchorPointList();
                if (!shapeObject.getIElement().isAnchored()) {
                    SGUtilityForFigureElementJava2D.drawAnchorAsChildObject((List)object, graphics2D);
                    continue;
                }
                SGUtilityForFigureElementJava2D.drawAnchorPointsAsAnchoredChildObject((List<Point2D>)object, graphics2D);
            }
        }
        if (this.mSymbolsVisibleFlagAroundFocusedObjects) {
            ArrayList<SGISelectable> arrayList = new ArrayList<SGISelectable>();
            this.getFocusedObjectsList(arrayList);
            for (int i = 0; i < arrayList.size(); ++i) {
                object = (ShapeObject)arrayList.get(i);
                if (!((ShapeObject)object).isValid()) continue;
                List list2 = ((ShapeObject)object).getAnchorPointList();
                if (!((ShapeObject)object).getIElement().isAnchored()) {
                    SGUtilityForFigureElementJava2D.drawAnchorAsFocusedObject(list2, graphics2D);
                    continue;
                }
                SGUtilityForFigureElementJava2D.drawAnchorPointsAsAnchoredForcusObject(list2, graphics2D);
            }
        }
    }

    @Override
    public ArrayList getChildNodes() {
        ArrayList<IElement> arrayList = new ArrayList<IElement>();
        ArrayList arrayList2 = new ArrayList(this.mChildList);
        for (int i = 0; i < arrayList2.size(); ++i) {
            ShapeObject shapeObject = (ShapeObject)arrayList2.get(i);
            if (!shapeObject.isVisible()) continue;
            arrayList.add(shapeObject.mElement);
        }
        return arrayList;
    }

    @Override
    public String getClassDescription() {
        return "Shape";
    }

    private static boolean isInside(int n, int n2, int n3, int n4) {
        return Math.abs(n - n3) < 7 && Math.abs(n2 - n4) < 7;
    }

    @Override
    protected Set getAvailableChildSet() {
        HashSet hashSet = new HashSet();
        List list = this.getMementoList();
        for (int i = 0; i < list.size(); ++i) {
            ShapeElementProperties shapeElementProperties = (ShapeElementProperties)list.get(i);
            hashSet.addAll(shapeElementProperties.visibleShapeList);
        }
        return hashSet;
    }

    @Override
    public boolean setDialogOwner(Frame frame) {
        if (!super.setDialogOwner(frame)) {
            return false;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (SGFigureElementShape.this.mShapeDialogMap != null) {
                    if (SGFigureElementShape.this.mShapeDialogMap.get("Rectangle") == null) {
                        SGFigureElementShape.this.mShapeDialogMap.put("Rectangle", new SGRectangularShapeDialog(SGFigureElementShape.this.mDialogOwner, true));
                    }
                    if (SGFigureElementShape.this.mShapeDialogMap.get("Arrow") == null) {
                        SGFigureElementShape.this.mShapeDialogMap.put("Arrow", new SGArrowDialog(SGFigureElementShape.this.mDialogOwner, true));
                    }
                }
            }
        });
        return true;
    }

    @Override
    public SGPropertyResults setChildProperties(int n, SGPropertyMap sGPropertyMap) {
        Object object;
        SGIChildObject sGIChildObject = this.getVisibleChild(n);
        boolean bl = false;
        if (sGIChildObject == null) {
            int n2;
            object = null;
            String string = null;
            String string2 = null;
            Iterator<String> iterator = sGPropertyMap.getKeyIterator();
            while (iterator.hasNext()) {
                String string3 = iterator.next();
                if ("ShapeType".equalsIgnoreCase(string3)) {
                    object = sGPropertyMap.getValueString(string3);
                    continue;
                }
                if ("AxisX".equalsIgnoreCase(string3)) {
                    string = sGPropertyMap.getValueString(string3);
                    continue;
                }
                if (!"AxisY".equalsIgnoreCase(string3)) continue;
                string2 = sGPropertyMap.getValueString(string3);
            }
            if (object == null) {
                return null;
            }
            if ("Rectangle".equalsIgnoreCase((String)object)) {
                n2 = 0;
            } else if ("Ellipse".equalsIgnoreCase((String)object)) {
                n2 = 1;
            } else if ("Arrow".equalsIgnoreCase((String)object)) {
                n2 = 2;
            } else if ("Line".equalsIgnoreCase((String)object)) {
                n2 = 3;
            } else {
                return null;
            }
            String string4 = string != null ? string : "Bottom";
            String string5 = string2 != null ? string2 : "Left";
            SGAxis sGAxis = this.mAxisElement.getAxis(string4);
            SGAxis sGAxis2 = this.mAxisElement.getAxis(string5);
            if (sGAxis == null || sGAxis2 == null) {
                return null;
            }
            iterator = sGPropertyMap.getKeyIterator();
            switch (n2) {
                case 0: 
                case 1: {
                    Object object2;
                    Object object3;
                    String string6 = null;
                    String string7 = null;
                    String string8 = null;
                    String string9 = null;
                    while (iterator.hasNext()) {
                        object3 = iterator.next();
                        object2 = object3.toString();
                        if ("LeftX".equalsIgnoreCase((String)object2)) {
                            string6 = sGPropertyMap.getValueString((String)object2);
                            continue;
                        }
                        if ("RightX".equalsIgnoreCase((String)object2)) {
                            string7 = sGPropertyMap.getValueString((String)object2);
                            continue;
                        }
                        if ("BottomY".equalsIgnoreCase((String)object2)) {
                            string8 = sGPropertyMap.getValueString((String)object2);
                            continue;
                        }
                        if (!"TopY".equalsIgnoreCase((String)object2)) continue;
                        string9 = sGPropertyMap.getValueString((String)object2);
                    }
                    if (string6 == null) {
                        return null;
                    }
                    if (string7 == null) {
                        return null;
                    }
                    if (string9 == null) {
                        return null;
                    }
                    if (string8 == null) {
                        return null;
                    }
                    object3 = SGUtilityText.getDouble(string6);
                    object2 = SGUtilityText.getDouble(string7);
                    Double d = SGUtilityText.getDouble(string9);
                    Double d2 = SGUtilityText.getDouble(string8);
                    if (object3 == null) {
                        return null;
                    }
                    if (object2 == null) {
                        return null;
                    }
                    if (d == null) {
                        return null;
                    }
                    if (d2 == null) {
                        return null;
                    }
                    if (!SGUtility.isValidPropertyValue((Double)object3)) {
                        return null;
                    }
                    if (!SGUtility.isValidPropertyValue((Double)object2)) {
                        return null;
                    }
                    if (!SGUtility.isValidPropertyValue(d)) {
                        return null;
                    }
                    if (!SGUtility.isValidPropertyValue(d2)) {
                        return null;
                    }
                    Rect rect = null;
                    rect = n2 == 0 ? new Rect() : new Ellipse();
                    if (this.addRectangularShape(n, rect, (Double)object3, (Double)object2, d, d2, sGAxis, sGAxis2)) break;
                    return null;
                }
                case 2: 
                case 3: {
                    Object object4;
                    Object object5;
                    String string10 = null;
                    String string11 = null;
                    String string12 = null;
                    String string13 = null;
                    while (iterator.hasNext()) {
                        object5 = iterator.next();
                        object4 = object5.toString();
                        if ("StartX".equalsIgnoreCase((String)object4)) {
                            string10 = sGPropertyMap.getValueString((String)object4);
                            continue;
                        }
                        if ("StartY".equalsIgnoreCase((String)object4)) {
                            string11 = sGPropertyMap.getValueString((String)object4);
                            continue;
                        }
                        if ("EndX".equalsIgnoreCase((String)object4)) {
                            string12 = sGPropertyMap.getValueString((String)object4);
                            continue;
                        }
                        if (!"EndY".equalsIgnoreCase((String)object4)) continue;
                        string13 = sGPropertyMap.getValueString((String)object4);
                    }
                    if (string10 == null) {
                        return null;
                    }
                    if (string11 == null) {
                        return null;
                    }
                    if (string12 == null) {
                        return null;
                    }
                    if (string13 == null) {
                        return null;
                    }
                    object5 = SGUtilityText.getDouble(string10);
                    object4 = SGUtilityText.getDouble(string11);
                    Double d = SGUtilityText.getDouble(string12);
                    Double d3 = SGUtilityText.getDouble(string13);
                    if (object5 == null) {
                        return null;
                    }
                    if (object4 == null) {
                        return null;
                    }
                    if (d == null) {
                        return null;
                    }
                    if (d3 == null) {
                        return null;
                    }
                    if (!SGUtility.isValidPropertyValue((Double)object5)) {
                        return null;
                    }
                    if (!SGUtility.isValidPropertyValue((Double)object4)) {
                        return null;
                    }
                    if (!SGUtility.isValidPropertyValue(d)) {
                        return null;
                    }
                    if (!SGUtility.isValidPropertyValue(d3)) {
                        return null;
                    }
                    Arrow arrow = new Arrow();
                    if (n2 == 2) {
                        arrow.setStartHeadType(-1);
                        arrow.setEndHeadType(10);
                    } else {
                        arrow.setStartHeadType(-1);
                        arrow.setEndHeadType(-1);
                    }
                    if (this.addArrowShape(n, arrow, (Double)object5, (Double)object4, d, d3, sGAxis, sGAxis2)) break;
                    return null;
                }
                default: {
                    return null;
                }
            }
            sGIChildObject = this.getVisibleChild(n);
            bl = true;
        }
        object = sGIChildObject.setProperties(sGPropertyMap);
        if (bl) {
            ((SGPropertyResults)object).putResult("ShapeType", 0);
        }
        return object;
    }

    private static class ArrowShapeProperties
    extends SGDrawingElementArrow.ArrowProperties
    implements PropertyWithAxes {
        private double mStartXValue = 0.0;
        private double mStartYValue = 0.0;
        private double mEndXValue = 0.0;
        private double mEndYValue = 0.0;
        private int mXAxisLocation = -1;
        private int mYAxisLocation = -1;
        private boolean mAnchored = false;

        public boolean equals(Object object) {
            if (!(object instanceof ArrowShapeProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            ArrowShapeProperties arrowShapeProperties = (ArrowShapeProperties)object;
            if (arrowShapeProperties.mStartXValue != this.mStartXValue) {
                return false;
            }
            if (arrowShapeProperties.mStartYValue != this.mStartYValue) {
                return false;
            }
            if (arrowShapeProperties.mEndXValue != this.mEndXValue) {
                return false;
            }
            if (arrowShapeProperties.mEndYValue != this.mEndYValue) {
                return false;
            }
            if (this.mXAxisLocation != arrowShapeProperties.mXAxisLocation) {
                return false;
            }
            if (this.mYAxisLocation != arrowShapeProperties.mYAxisLocation) {
                return false;
            }
            return this.mAnchored == arrowShapeProperties.mAnchored;
        }

        public Double getStartXValue() {
            return this.mStartXValue;
        }

        public Double getStartYValue() {
            return this.mStartYValue;
        }

        public Double getEndXValue() {
            return this.mEndXValue;
        }

        public Double getEndYValue() {
            return this.mEndYValue;
        }

        public int getXAxisLocation() {
            return this.mXAxisLocation;
        }

        public int getYAxisLocation() {
            return this.mYAxisLocation;
        }

        public boolean setStartXValue(double d) {
            this.mStartXValue = d;
            return true;
        }

        public boolean setStartYValue(double d) {
            this.mStartYValue = d;
            return true;
        }

        public boolean setEndXValue(double d) {
            this.mEndXValue = d;
            return true;
        }

        public boolean setEndYValue(double d) {
            this.mEndYValue = d;
            return true;
        }

        private boolean setXAxisLocation(int n) {
            this.mXAxisLocation = n;
            return true;
        }

        private boolean setYAxisLocation(int n) {
            this.mYAxisLocation = n;
            return true;
        }

        public boolean setAnchored(boolean bl) {
            this.mAnchored = bl;
            return true;
        }

        public boolean getAnchored() {
            return this.mAnchored;
        }
    }

    private class Arrow
    extends SGSimpleArrow2D
    implements IElement,
    SGIArrowConstants,
    SGIArrowDialogObserver {
        public static final String NAME = "Arrow";
        public static final String KEY_START_X_VALUE = "StartXValue";
        public static final String KEY_START_Y_VALUE = "StartYValue";
        public static final String KEY_END_X_VALUE = "EndXValue";
        public static final String KEY_END_Y_VALUE = "EndYValue";
        public static final String KEY_ANCHORED = "Anchored";
        private float mStartX;
        private float mStartY;
        private float mEndX;
        private float mEndY;
        private double mStartXValue;
        private double mStartYValue;
        private double mEndXValue;
        private double mEndYValue;
        private ShapeObject mShape = null;
        private boolean mIsAnchored;
        private static final int START = 6;
        private static final int END = 8;
        private static final int BODY = 0;
        private SGProperties mTemporaryProperties = null;

        private Arrow() {
            this.setLineWidth(1.5f, "pt");
            this.setLineType(1);
            this.setColor(SGIShapeConstants.DEFAULT_SHAPE_ARROW_COLOR);
            this.setHeadSize(0.4f, "cm");
            this.setHeadAngle(Float.valueOf(30.0f), Float.valueOf(60.0f));
            this.setAnchored(false);
        }

        public void dispose() {
            super.dispose();
            this.mShape = null;
            if (this.mTemporaryProperties != null) {
                this.mTemporaryProperties.dispose();
                this.mTemporaryProperties = null;
            }
        }

        protected SGFigureElementShape getShapeElement() {
            return this.mShape.getShapeElement();
        }

        public void setShapeObject(ShapeObject shapeObject) {
            this.mShape = shapeObject;
        }

        protected int getID() {
            return this.mShape.getID();
        }

        protected SGAxis getXAxis() {
            return this.mShape.getXAxis();
        }

        protected SGAxis getYAxis() {
            return this.mShape.getYAxis();
        }

        public int getMouseLocation(int n, int n2) {
            int n3 = (int)this.getStartX();
            int n4 = (int)this.getStartY();
            int n5 = (int)this.getEndX();
            int n6 = (int)this.getEndY();
            int n7 = -1;
            n7 = SGFigureElementShape.isInside(n3, n4, n, n2) ? 6 : (SGFigureElementShape.isInside(n5, n6, n, n2) ? 8 : 0);
            return n7;
        }

        public int getXAxisLocation() {
            return this.mShape.getAxisConfiguration(this.getXAxis());
        }

        public int getYAxisLocation() {
            return this.mShape.getAxisConfiguration(this.getYAxis());
        }

        public float getStartX() {
            return this.getShapeElement().getXFromGraphRectValue(this.mStartX);
        }

        public float getStartY() {
            return this.getShapeElement().getYFromGraphRectValue(this.mStartY);
        }

        public float getEndX() {
            return this.getShapeElement().getXFromGraphRectValue(this.mEndX);
        }

        public float getEndY() {
            return this.getShapeElement().getYFromGraphRectValue(this.mEndY);
        }

        public float getLineWidth(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getLineWidth(), string);
        }

        public float getHeadSize(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getHeadSize(), string);
        }

        public boolean setXAxisLocation(int n) {
            return this.mShape.setXAxis(n);
        }

        public boolean setYAxisLocation(int n) {
            return this.mShape.setYAxis(n);
        }

        public boolean setStartX(float f) {
            super.setStartX(f);
            this.mStartX = this.getShapeElement().getGraphRectValueX(f);
            return true;
        }

        public boolean setStartY(float f) {
            super.setStartY(f);
            this.mStartY = this.getShapeElement().getGraphRectValueY(f);
            return true;
        }

        public boolean setEndX(float f) {
            super.setEndX(f);
            this.mEndX = this.getShapeElement().getGraphRectValueX(f);
            return true;
        }

        public boolean setEndY(float f) {
            super.setEndY(f);
            this.mEndY = this.getShapeElement().getGraphRectValueY(f);
            return true;
        }

        public double getStartXValue() {
            return this.mStartXValue;
        }

        public double getStartYValue() {
            return this.mStartYValue;
        }

        public double getEndXValue() {
            return this.mEndXValue;
        }

        public double getEndYValue() {
            return this.mEndYValue;
        }

        public boolean setStartXValue(double d) {
            if (!this.getXAxis().isValidValue(d)) {
                return false;
            }
            this.mStartXValue = d;
            return true;
        }

        public boolean setStartYValue(double d) {
            if (!this.getYAxis().isValidValue(d)) {
                return false;
            }
            this.mStartYValue = d;
            return true;
        }

        public boolean setEndXValue(double d) {
            if (!this.getXAxis().isValidValue(d)) {
                return false;
            }
            this.mEndXValue = d;
            return true;
        }

        public boolean setEndYValue(double d) {
            if (!this.getYAxis().isValidValue(d)) {
                return false;
            }
            this.mEndYValue = d;
            return true;
        }

        public boolean isAnchored() {
            return this.mIsAnchored;
        }

        public boolean setAnchored(boolean bl) {
            this.mIsAnchored = bl;
            return true;
        }

        public boolean hasValidStartXValue(int n, Number number) {
            SGIFigureElementAxis sGIFigureElementAxis = this.getShapeElement().getAxisElement();
            SGAxis sGAxis = n == -1 ? this.getXAxis() : sGIFigureElementAxis.getAxisInPlane(n);
            double d = number != null ? number.doubleValue() : this.getStartXValue();
            return sGAxis.isValidValue(d);
        }

        public boolean hasValidStartYValue(int n, Number number) {
            SGIFigureElementAxis sGIFigureElementAxis = this.getShapeElement().getAxisElement();
            SGAxis sGAxis = n == -1 ? this.getYAxis() : sGIFigureElementAxis.getAxisInPlane(n);
            double d = number != null ? number.doubleValue() : this.getStartYValue();
            return sGAxis.isValidValue(d);
        }

        public boolean hasValidEndXValue(int n, Number number) {
            SGIFigureElementAxis sGIFigureElementAxis = this.getShapeElement().getAxisElement();
            SGAxis sGAxis = n == -1 ? this.getXAxis() : sGIFigureElementAxis.getAxisInPlane(n);
            double d = number != null ? number.doubleValue() : this.getEndXValue();
            return sGAxis.isValidValue(d);
        }

        public boolean hasValidEndYValue(int n, Number number) {
            SGIFigureElementAxis sGIFigureElementAxis = this.getShapeElement().getAxisElement();
            SGAxis sGAxis = n == -1 ? this.mShape.getYAxis() : sGIFigureElementAxis.getAxisInPlane(n);
            double d = number != null ? number.doubleValue() : this.getEndYValue();
            return sGAxis.isValidValue(d);
        }

        public boolean hasValidAngle(Number number, Number number2) {
            float f = number != null ? number.floatValue() : this.getHeadOpenAngle();
            float f2 = number2 != null ? number2.floatValue() : this.getHeadCloseAngle();
            return f < f2;
        }

        public boolean setAxisValuesWithShape() {
            SGAxis sGAxis = this.getXAxis();
            SGAxis sGAxis2 = this.getYAxis();
            SGFigureElementShape sGFigureElementShape = this.getShapeElement();
            double d = sGFigureElementShape.calcValue(this.getStartX(), sGAxis, true);
            double d2 = sGFigureElementShape.calcValue(this.getStartY(), sGAxis2, false);
            double d3 = sGFigureElementShape.calcValue(this.getEndX(), sGAxis, true);
            double d4 = sGFigureElementShape.calcValue(this.getEndY(), sGAxis2, false);
            this.mStartXValue = sGFigureElementShape.getNumberInRangeOrder(d, sGAxis);
            this.mStartYValue = sGFigureElementShape.getNumberInRangeOrder(d2, sGAxis2);
            this.mEndXValue = sGFigureElementShape.getNumberInRangeOrder(d3, sGAxis);
            this.mEndYValue = sGFigureElementShape.getNumberInRangeOrder(d4, sGAxis2);
            this.setShapeWithAxesValues();
            return true;
        }

        public boolean setShapeWithAxesValues() {
            ShapeObject shapeObject = this.mShape;
            SGAxis sGAxis = this.getXAxis();
            SGAxis sGAxis2 = this.getYAxis();
            SGFigureElementShape sGFigureElementShape = this.getShapeElement();
            float f = sGFigureElementShape.calcLocation(this.mStartXValue, sGAxis, true);
            float f2 = sGFigureElementShape.calcLocation(this.mStartYValue, sGAxis2, false);
            float f3 = sGFigureElementShape.calcLocation(this.mEndXValue, sGAxis, true);
            float f4 = sGFigureElementShape.calcLocation(this.mEndYValue, sGAxis2, false);
            if (Float.isNaN(f) || Float.isNaN(f2) || Float.isNaN(f3) || Float.isNaN(f4)) {
                shapeObject.setValid(false);
                return false;
            }
            shapeObject.setValid(true);
            this.setStartX(f);
            this.setStartY(f2);
            this.setEndX(f3);
            this.setEndY(f4);
            return true;
        }

        public List getAnchorPointList() {
            ArrayList<Point2D.Float> arrayList = new ArrayList<Point2D.Float>();
            Point2D.Float float_ = new Point2D.Float(this.getStartX(), this.getStartY());
            Point2D.Float float_2 = new Point2D.Float(this.getEndX(), this.getEndY());
            arrayList.add(float_);
            arrayList.add(float_2);
            return arrayList;
        }

        public Object copy() {
            Arrow arrow = new Arrow();
            arrow.setShapeObject(this.mShape);
            arrow.setMagnification(this.getMagnification());
            arrow.setProperties(this.getProperties());
            arrow.setShapeWithAxesValues();
            return arrow;
        }

        public boolean drag(MouseEvent mouseEvent, Point point, int n) {
            int n2 = mouseEvent.getX() - point.x;
            int n3 = mouseEvent.getY() - point.y;
            point.setLocation(point.getX() + (double)n2, point.getY() + (double)n3);
            if (n == 6) {
                this.setStartX(this.getStartX() + (float)n2);
                this.setStartY(this.getStartY() + (float)n3);
            } else if (n == 8) {
                this.setEndX(this.getEndX() + (float)n2);
                this.setEndY(this.getEndY() + (float)n3);
            }
            return true;
        }

        public void translate(float f, float f2) {
            this.setStartX(this.getStartX() + f);
            this.setStartY(this.getStartY() + f2);
            this.setEndX(this.getEndX() + f);
            this.setEndY(this.getEndY() + f2);
            this.setAxisValuesWithShape();
        }

        public String getName() {
            return NAME;
        }

        public String getClassDescription() {
            return "";
        }

        public String getInstanceDescription() {
            SGIFigureElementAxis sGIFigureElementAxis = SGFigureElementShape.this.mAxisElement;
            String string = sGIFigureElementAxis.getLocationName(this.getXAxis());
            String string2 = sGIFigureElementAxis.getLocationName(this.getYAxis());
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getID());
            stringBuffer.append(": ");
            stringBuffer.append(this.getName());
            stringBuffer.append(", AxisX=");
            stringBuffer.append(string.toString());
            stringBuffer.append(", AxisY=");
            stringBuffer.append(string2.toString());
            stringBuffer.append(", START=(");
            stringBuffer.append(this.mStartXValue);
            stringBuffer.append(", ");
            stringBuffer.append(this.mStartYValue);
            stringBuffer.append("), END=(");
            stringBuffer.append(this.mEndXValue);
            stringBuffer.append(", ");
            stringBuffer.append(this.mEndYValue);
            stringBuffer.append(")");
            return stringBuffer.toString();
        }

        public ArrayList getChildNodes() {
            return new ArrayList();
        }

        public SGProperties getMement() {
            return this.getProperties();
        }

        public boolean setMement(SGProperties sGProperties) {
            return this.setProperties(sGProperties);
        }

        public SGProperties getProperties() {
            ArrowShapeProperties arrowShapeProperties = new ArrowShapeProperties();
            if (!this.getProperties(arrowShapeProperties)) {
                return null;
            }
            return arrowShapeProperties;
        }

        public boolean getProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof ArrowShapeProperties)) {
                return false;
            }
            if (!super.getProperties(sGProperties)) {
                return false;
            }
            ArrowShapeProperties arrowShapeProperties = (ArrowShapeProperties)sGProperties;
            SGFigureElementShape sGFigureElementShape = this.getShapeElement();
            SGIFigureElementAxis sGIFigureElementAxis = sGFigureElementShape.getAxisElement();
            SGAxis sGAxis = this.getXAxis();
            SGAxis sGAxis2 = this.getYAxis();
            arrowShapeProperties.setXAxisLocation(sGIFigureElementAxis.getLocationInPlane(sGAxis));
            arrowShapeProperties.setYAxisLocation(sGIFigureElementAxis.getLocationInPlane(sGAxis2));
            arrowShapeProperties.setStartXValue(this.mStartXValue);
            arrowShapeProperties.setStartYValue(this.mStartYValue);
            arrowShapeProperties.setEndXValue(this.mEndXValue);
            arrowShapeProperties.setEndYValue(this.mEndYValue);
            arrowShapeProperties.setAnchored(this.mIsAnchored);
            return true;
        }

        public boolean setProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof ArrowShapeProperties)) {
                return false;
            }
            if (!super.setProperties(sGProperties)) {
                return false;
            }
            ArrowShapeProperties arrowShapeProperties = (ArrowShapeProperties)sGProperties;
            Double d = arrowShapeProperties.getStartXValue();
            if (d == null) {
                return false;
            }
            this.mStartXValue = d;
            Double d2 = arrowShapeProperties.getStartYValue();
            if (d2 == null) {
                return false;
            }
            this.mStartYValue = d2;
            Double d3 = arrowShapeProperties.getEndXValue();
            if (d3 == null) {
                return false;
            }
            this.mEndXValue = d3;
            Double d4 = arrowShapeProperties.getEndYValue();
            if (d4 == null) {
                return false;
            }
            this.mEndYValue = d4;
            Boolean bl = arrowShapeProperties.getAnchored();
            if (bl == null) {
                return false;
            }
            this.mIsAnchored = bl;
            return true;
        }

        public boolean prepare() {
            this.mTemporaryProperties = this.getProperties();
            return true;
        }

        public boolean commit() {
            SGProperties sGProperties = this.mTemporaryProperties;
            SGProperties sGProperties2 = this.getProperties();
            if (!sGProperties.equals(sGProperties2)) {
                this.mShape.setChanged(true);
            }
            this.setShapeWithAxesValues();
            SGFigureElementShape sGFigureElementShape = this.getShapeElement();
            sGFigureElementShape.repaint();
            sGFigureElementShape.notifyChange();
            return true;
        }

        public boolean cancel() {
            if (!this.setProperties(this.mTemporaryProperties)) {
                return false;
            }
            this.mTemporaryProperties = null;
            this.setShapeWithAxesValues();
            SGFigureElementShape sGFigureElementShape = this.getShapeElement();
            sGFigureElementShape.repaint();
            sGFigureElementShape.notifyChange();
            return true;
        }

        public boolean preview() {
            this.setShapeWithAxesValues();
            SGFigureElementShape sGFigureElementShape = this.getShapeElement();
            sGFigureElementShape.repaint();
            sGFigureElementShape.notifyChange();
            return true;
        }

        public SGPropertyDialog getPropertyDialog() {
            return SGFigureElementShape.this.getShapeDialog(this);
        }

        public boolean writeProperty(Element element) {
            if (!super.writeProperty(element)) {
                return false;
            }
            element.setAttribute(KEY_START_X_VALUE, Double.toString(this.getStartXValue()));
            element.setAttribute(KEY_START_Y_VALUE, Double.toString(this.getStartYValue()));
            element.setAttribute(KEY_END_X_VALUE, Double.toString(this.getEndXValue()));
            element.setAttribute(KEY_END_Y_VALUE, Double.toString(this.getEndYValue()));
            element.setAttribute(KEY_ANCHORED, Boolean.toString(this.mIsAnchored));
            return true;
        }

        public boolean readProperty(Element element) {
            double d;
            if (!super.readProperty(element)) {
                return false;
            }
            String string = null;
            Double d2 = null;
            string = element.getAttribute(KEY_START_X_VALUE);
            if (string.length() != 0) {
                d2 = SGUtilityText.getDouble(string);
                if (d2 == null) {
                    return false;
                }
                d = d2;
                if (!this.setStartXValue(d)) {
                    return false;
                }
            }
            if ((string = element.getAttribute(KEY_START_Y_VALUE)).length() != 0) {
                d2 = SGUtilityText.getDouble(string);
                if (d2 == null) {
                    return false;
                }
                d = d2;
                if (!this.setStartYValue(d)) {
                    return false;
                }
            }
            if ((string = element.getAttribute(KEY_END_X_VALUE)).length() != 0) {
                d2 = SGUtilityText.getDouble(string);
                if (d2 == null) {
                    return false;
                }
                d = d2;
                if (!this.setEndXValue(d)) {
                    return false;
                }
            }
            if ((string = element.getAttribute(KEY_END_Y_VALUE)).length() != 0) {
                d2 = SGUtilityText.getDouble(string);
                if (d2 == null) {
                    return false;
                }
                d = d2;
                if (!this.setEndYValue(d)) {
                    return false;
                }
            }
            if ((string = element.getAttribute(KEY_ANCHORED)).length() != 0) {
                Boolean bl = SGUtilityText.getBoolean(string);
                if (bl == null) {
                    return false;
                }
                this.setAnchored(bl);
                this.setShapeWithAxesValues();
            }
            return true;
        }

        public SGPropertyResults setProperties(SGPropertyMap sGPropertyMap, SGPropertyResults sGPropertyResults) {
            SGPropertyResults sGPropertyResults2 = (SGPropertyResults)sGPropertyResults.clone();
            Iterator<String> iterator = sGPropertyMap.getKeyIterator();
            while (iterator.hasNext()) {
                Number number;
                Object object;
                String string = iterator.next();
                String string2 = sGPropertyMap.getValueString(string);
                if ("StartX".equalsIgnoreCase(string)) {
                    object = SGUtilityText.getDouble(string2);
                    if (object == null) {
                        sGPropertyResults2.putResult("StartX", 1);
                        continue;
                    }
                    if (!SGUtility.isValidPropertyValue((Double)object)) {
                        sGPropertyResults2.putResult("StartX", 1);
                        continue;
                    }
                    if (!this.setStartXValue((Double)object)) {
                        sGPropertyResults2.putResult("StartX", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("StartX", 0);
                    continue;
                }
                if ("StartY".equalsIgnoreCase(string)) {
                    object = SGUtilityText.getDouble(string2);
                    if (object == null) {
                        sGPropertyResults2.putResult("StartY", 1);
                        continue;
                    }
                    if (!SGUtility.isValidPropertyValue((Double)object)) {
                        sGPropertyResults2.putResult("StartY", 1);
                        continue;
                    }
                    if (!this.setStartYValue((Double)object)) {
                        sGPropertyResults2.putResult("StartY", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("StartY", 0);
                    continue;
                }
                if ("EndX".equalsIgnoreCase(string)) {
                    object = SGUtilityText.getDouble(string2);
                    if (object == null) {
                        sGPropertyResults2.putResult("EndX", 1);
                        continue;
                    }
                    if (!SGUtility.isValidPropertyValue((Double)object)) {
                        sGPropertyResults2.putResult("EndX", 1);
                        continue;
                    }
                    if (!this.setEndXValue((Double)object)) {
                        sGPropertyResults2.putResult("EndX", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("EndX", 0);
                    continue;
                }
                if ("EndY".equalsIgnoreCase(string)) {
                    object = SGUtilityText.getDouble(string2);
                    if (object == null) {
                        sGPropertyResults2.putResult("EndY", 1);
                        continue;
                    }
                    if (!SGUtility.isValidPropertyValue((Double)object)) {
                        sGPropertyResults2.putResult("EndY", 1);
                        continue;
                    }
                    if (!this.setEndYValue((Double)object)) {
                        sGPropertyResults2.putResult("EndY", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("EndY", 0);
                    continue;
                }
                if ("LineWidth".equalsIgnoreCase(string)) {
                    object = new StringBuffer();
                    number = SGUtilityText.getNumber(string2, (StringBuffer)object);
                    if (number == null) {
                        sGPropertyResults2.putResult("LineWidth", 1);
                        continue;
                    }
                    if (!this.setLineWidth(number.floatValue(), ((StringBuffer)object).toString())) {
                        sGPropertyResults2.putResult("LineWidth", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("LineWidth", 0);
                    continue;
                }
                if ("LineType".equalsIgnoreCase(string)) {
                    object = SGDrawingElementLine.getLineTypeFromName(string2);
                    if (object == null) {
                        sGPropertyResults2.putResult("LineType", 1);
                        continue;
                    }
                    if (!this.setLineType((Integer)object)) {
                        sGPropertyResults2.putResult("LineType", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("LineType", 0);
                    continue;
                }
                if ("HeadSize".equalsIgnoreCase(string)) {
                    object = new StringBuffer();
                    number = SGUtilityText.getNumber(string2, object);
                    if (number == null) {
                        sGPropertyResults2.putResult("HeadSize", 1);
                        continue;
                    }
                    if (!this.setHeadSize(number.floatValue(), ((StringBuffer)object).toString())) {
                        sGPropertyResults2.putResult("HeadSize", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("HeadSize", 0);
                    continue;
                }
                if ("Color".equalsIgnoreCase(string)) {
                    object = SGUtilityText.getColor(string2);
                    if (object != null) {
                        if (!this.setColor((Color)object)) {
                            sGPropertyResults2.putResult("Color", 1);
                            continue;
                        }
                    } else {
                        object = SGUtilityText.parseColor(string2);
                        if (object == null) {
                            sGPropertyResults2.putResult("Color", 1);
                            continue;
                        }
                        if (!this.setColor((Color)object)) {
                            sGPropertyResults2.putResult("Color", 1);
                            continue;
                        }
                    }
                    sGPropertyResults2.putResult("Color", 0);
                    continue;
                }
                if ("StartType".equalsIgnoreCase(string)) {
                    object = SGDrawingElementArrow.getArrowHeadTypeFromName(string2);
                    if (object == null) {
                        sGPropertyResults2.putResult("StartType", 1);
                        continue;
                    }
                    if (!this.setStartHeadType((Integer)object)) {
                        sGPropertyResults2.putResult("StartType", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("StartType", 0);
                    continue;
                }
                if ("EndType".equalsIgnoreCase(string)) {
                    object = SGDrawingElementArrow.getArrowHeadTypeFromName(string2);
                    if (object == null) {
                        sGPropertyResults2.putResult("EndType", 1);
                        continue;
                    }
                    if (!this.setEndHeadType((Integer)object)) {
                        sGPropertyResults2.putResult("EndType", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("EndType", 0);
                    continue;
                }
                if ("HeadOpenAngle".equalsIgnoreCase(string)) {
                    object = SGUtilityText.getFloat(string2);
                    if (object == null) {
                        sGPropertyResults2.putResult("HeadOpenAngle", 1);
                        continue;
                    }
                    if (!this.setHeadAngle((Float)object, null)) {
                        sGPropertyResults2.putResult("HeadOpenAngle", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("HeadOpenAngle", 0);
                    continue;
                }
                if ("HeadCloseAngle".equalsIgnoreCase(string)) {
                    object = SGUtilityText.getFloat(string2);
                    if (object == null) {
                        sGPropertyResults2.putResult("HeadCloseAngle", 1);
                        continue;
                    }
                    if (!this.setHeadAngle(null, (Float)object)) {
                        sGPropertyResults2.putResult("HeadCloseAngle", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("HeadCloseAngle", 0);
                    continue;
                }
                if ("HeadAngle".equalsIgnoreCase(string)) {
                    object = SGUtilityText.getFloatArray(string2);
                    if (object == null) {
                        sGPropertyResults2.putResult("HeadAngle", 1);
                        continue;
                    }
                    if (((Object)object).length != 2) {
                        sGPropertyResults2.putResult("HeadAngle", 1);
                        continue;
                    }
                    if (!this.setHeadAngle(Float.valueOf((float)object[0]), Float.valueOf((float)object[1]))) {
                        sGPropertyResults2.putResult("HeadAngle", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("HeadAngle", 0);
                    continue;
                }
                if (!KEY_ANCHORED.equalsIgnoreCase(string)) continue;
                object = SGUtilityText.getBoolean(string2);
                if (object == null) {
                    sGPropertyResults2.putResult(KEY_ANCHORED, 1);
                    continue;
                }
                if (!this.setAnchored((Boolean)object)) {
                    sGPropertyResults2.putResult(KEY_ANCHORED, 1);
                    continue;
                }
                sGPropertyResults2.putResult(KEY_ANCHORED, 0);
            }
            return sGPropertyResults2;
        }
    }

    private static class RectangularShapeProperties
    extends SGDrawingElementRectangle.RectangleProperties
    implements PropertyWithAxes {
        private double mXValue1 = 0.0;
        private double mYValue1 = 0.0;
        private double mXValue2 = 0.0;
        private double mYValue2 = 0.0;
        private int mXAxisLocation = -1;
        private int mYAxisLocation = -1;
        private boolean isAnchored = false;

        public boolean equals(Object object) {
            if (!(object instanceof RectangularShapeProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            RectangularShapeProperties rectangularShapeProperties = (RectangularShapeProperties)object;
            if (rectangularShapeProperties.mXValue1 != this.mXValue1) {
                return false;
            }
            if (rectangularShapeProperties.mYValue1 != this.mYValue1) {
                return false;
            }
            if (rectangularShapeProperties.mXValue2 != this.mXValue2) {
                return false;
            }
            if (rectangularShapeProperties.mYValue2 != this.mYValue2) {
                return false;
            }
            if (this.mXAxisLocation != rectangularShapeProperties.mXAxisLocation) {
                return false;
            }
            if (this.mYAxisLocation != rectangularShapeProperties.mYAxisLocation) {
                return false;
            }
            return this.isAnchored == rectangularShapeProperties.isAnchored;
        }

        public Double getXValue1() {
            return this.mXValue1;
        }

        public Double getYValue1() {
            return this.mYValue1;
        }

        public Double getXValue2() {
            return this.mXValue2;
        }

        public Double getYValue2() {
            return this.mYValue2;
        }

        public int getXAxisLocation() {
            return this.mXAxisLocation;
        }

        public int getYAxisLocation() {
            return this.mYAxisLocation;
        }

        public Boolean getAnchored() {
            return this.isAnchored;
        }

        public boolean setXValue1(double d) {
            this.mXValue1 = d;
            return true;
        }

        public boolean setYValue1(double d) {
            this.mYValue1 = d;
            return true;
        }

        public boolean setXValue2(double d) {
            this.mXValue2 = d;
            return true;
        }

        public boolean setYValue2(double d) {
            this.mYValue2 = d;
            return true;
        }

        private boolean setXAxisLocation(int n) {
            this.mXAxisLocation = n;
            return true;
        }

        private boolean setYAxisLocation(int n) {
            this.mYAxisLocation = n;
            return true;
        }

        public boolean setAnchored(boolean bl) {
            this.isAnchored = bl;
            return true;
        }
    }

    private class Ellipse
    extends Rect {
        public static final String NAME = "Ellipse";

        private Ellipse() {
        }

        protected Shape getRectShape() {
            Rectangle2D rectangle2D = this.getElementBounds();
            Ellipse2D.Float float_ = new Ellipse2D.Float((float)rectangle2D.getX(), (float)rectangle2D.getY(), (float)rectangle2D.getWidth(), (float)rectangle2D.getHeight());
            return float_;
        }

        public Object copy() {
            Ellipse ellipse = new Ellipse();
            ellipse.setShapeObject(this.getShapeObject());
            ellipse.setMagnification(this.getMagnification());
            ellipse.setProperties(this.getProperties());
            ellipse.setShapeWithAxesValues();
            return ellipse;
        }

        public String getName() {
            return NAME;
        }
    }

    private class Rect
    extends SGSimpleRectangle2D
    implements IElement,
    SGIRectangleConstants,
    SGIRectangularShapeDialogObserver {
        public static final String NAME = "Rectangle";
        public static final String KEY_LEFT_X_VALUE = "LeftXValue";
        public static final String KEY_RIGHT_X_VALUE = "RightXValue";
        public static final String KEY_BOTTOM_Y_VALUE = "BottomYValue";
        public static final String KEY_TOP_Y_VALUE = "TopYValue";
        public static final String KEY_ANCHORED = "Anchored";
        private ShapeObject mShape = null;
        private double mXValue1;
        private double mYValue1;
        private double mXValue2;
        private double mYValue2;
        private boolean mIsAnchored;
        private SGProperties mTemporaryProperties = null;

        private Rect() {
            this.init();
        }

        private boolean init() {
            this.setWidth(5.0f, "cm");
            this.setHeight(4.0f, "cm");
            SGSelectablePaint sGSelectablePaint = new SGSelectablePaint();
            sGSelectablePaint.setFillColor(SGIShapeConstants.DEFAULT_SHAPE_RECTANGLE_INNER_COLOR);
            sGSelectablePaint.setSelectedPaintStyle(0);
            this.setInnerPaint(sGSelectablePaint);
            this.setEdgeLineWidth(1.5f, "pt");
            this.setEdgeLineType(1);
            this.setEdgeLineColor(SGIShapeConstants.DEFAULT_SHAPE_RECTANGLE_EDGE_LINE_COLOR);
            this.setEdgeLineVisible(true);
            this.setAnchored(false);
            return true;
        }

        public void dispose() {
            super.dispose();
            this.mShape = null;
            if (this.mTemporaryProperties != null) {
                this.mTemporaryProperties.dispose();
                this.mTemporaryProperties = null;
            }
        }

        protected ShapeObject getShapeObject() {
            return this.mShape;
        }

        public void setShapeObject(ShapeObject shapeObject) {
            this.mShape = shapeObject;
        }

        protected SGFigureElementShape getShapeElement() {
            return this.mShape.getShapeElement();
        }

        protected int getID() {
            return this.mShape.getID();
        }

        protected SGAxis getXAxis() {
            return this.mShape.getXAxis();
        }

        protected SGAxis getYAxis() {
            return this.mShape.getYAxis();
        }

        public float getLineWidth(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getLineWidth(), string);
        }

        protected boolean isHorizontallyReversed() {
            return this.getWidth() < 0.0f;
        }

        protected boolean isPerpendicularlyReversed() {
            return this.getHeight() < 0.0f;
        }

        public float getX1() {
            return this.getShapeElement().getXFromGraphRectValue(super.getX());
        }

        public float getX() {
            return this.getX1();
        }

        public float getX2() {
            return this.getX1() + this.getMagnification() * this.getWidth();
        }

        public float getY1() {
            return this.getShapeElement().getYFromGraphRectValue(super.getY());
        }

        public float getY() {
            return this.getY1();
        }

        public float getY2() {
            return this.getY1() + this.getMagnification() * this.getHeight();
        }

        public float getLeftX() {
            return !this.isHorizontallyReversed() ? this.getX1() : this.getX2();
        }

        public float getRightX() {
            return !this.isHorizontallyReversed() ? this.getX2() : this.getX1();
        }

        public float getCenterX() {
            return this.getX1() + 0.5f * this.getMagnification() * this.getWidth();
        }

        public float getTopY() {
            return !this.isPerpendicularlyReversed() ? this.getY1() : this.getY2();
        }

        public float getBottomY() {
            return !this.isPerpendicularlyReversed() ? this.getY2() : this.getY1();
        }

        public float getCenterY() {
            return this.getY1() + 0.5f * this.getMagnification() * this.getHeight();
        }

        public void setLeftX(float f) {
            if (!this.isHorizontallyReversed()) {
                this.setX1(f);
            } else {
                this.setX2(f);
            }
        }

        public void setRightX(float f) {
            if (!this.isHorizontallyReversed()) {
                this.setX2(f);
            } else {
                this.setX1(f);
            }
        }

        public void setTopY(float f) {
            if (!this.isPerpendicularlyReversed()) {
                this.setY1(f);
            } else {
                this.setY2(f);
            }
        }

        public void setBottomY(float f) {
            if (!this.isPerpendicularlyReversed()) {
                this.setY2(f);
            } else {
                this.setY1(f);
            }
        }

        public boolean setX1(float f) {
            return this.setX(f);
        }

        public boolean setX2(float f) {
            return this.setX(f - this.getMagnification() * this.getWidth());
        }

        public boolean setY1(float f) {
            return this.setY(f);
        }

        public boolean setY2(float f) {
            return this.setY(f - this.getMagnification() * this.getHeight());
        }

        public boolean setX(float f) {
            return super.setX(this.getShapeElement().getGraphRectValueX(f));
        }

        public boolean setY(float f) {
            return super.setY(this.getShapeElement().getGraphRectValueY(f));
        }

        public boolean setShapeWithAxesValues() {
            ShapeObject shapeObject = this.mShape;
            SGAxis sGAxis = this.getXAxis();
            SGAxis sGAxis2 = this.getYAxis();
            SGFigureElementShape sGFigureElementShape = this.getShapeElement();
            float f = sGFigureElementShape.calcLocation(this.mXValue1, sGAxis, true);
            float f2 = sGFigureElementShape.calcLocation(this.mYValue1, sGAxis2, false);
            float f3 = sGFigureElementShape.calcLocation(this.mXValue2, sGAxis, true);
            float f4 = sGFigureElementShape.calcLocation(this.mYValue2, sGAxis2, false);
            if (Float.isNaN(f) || Float.isNaN(f2) || Float.isNaN(f3) || Float.isNaN(f4)) {
                shapeObject.setValid(false);
                return false;
            }
            shapeObject.setValid(true);
            float f5 = this.getMagnification();
            float f6 = (f3 - f) / f5;
            float f7 = (f4 - f2) / f5;
            this.setLocation(f, f2);
            this.setWidth(f6);
            this.setHeight(f7);
            return true;
        }

        public boolean setAxisValuesWithShape() {
            SGAxis sGAxis = this.getXAxis();
            SGAxis sGAxis2 = this.getYAxis();
            SGFigureElementShape sGFigureElementShape = this.getShapeElement();
            double d = sGFigureElementShape.calcValue(this.getX1(), sGAxis, true);
            double d2 = sGFigureElementShape.calcValue(this.getY1(), sGAxis2, false);
            double d3 = sGFigureElementShape.calcValue(this.getX2(), sGAxis, true);
            double d4 = sGFigureElementShape.calcValue(this.getY2(), sGAxis2, false);
            this.mXValue1 = sGFigureElementShape.getNumberInRangeOrder(d, sGAxis);
            this.mYValue1 = sGFigureElementShape.getNumberInRangeOrder(d2, sGAxis2);
            this.mXValue2 = sGFigureElementShape.getNumberInRangeOrder(d3, sGAxis);
            this.mYValue2 = sGFigureElementShape.getNumberInRangeOrder(d4, sGAxis2);
            return true;
        }

        public int getMouseLocation(int n, int n2) {
            int n3 = (int)this.getLeftX();
            int n4 = (int)this.getRightX();
            int n5 = (int)this.getTopY();
            int n6 = (int)this.getBottomY();
            int n7 = (int)this.getCenterX();
            int n8 = (int)this.getCenterY();
            int n9 = -1;
            if (SGFigureElementShape.isInside(n3, n5, n, n2)) {
                n9 = 5;
            } else if (SGFigureElementShape.isInside(n3, n8, n, n2)) {
                n9 = 3;
            } else if (SGFigureElementShape.isInside(n3, n6, n, n2)) {
                n9 = 7;
            } else if (SGFigureElementShape.isInside(n4, n5, n, n2)) {
                n9 = 6;
            } else if (SGFigureElementShape.isInside(n4, n8, n, n2)) {
                n9 = 4;
            } else if (SGFigureElementShape.isInside(n4, n6, n, n2)) {
                n9 = 8;
            } else if (SGFigureElementShape.isInside(n7, n5, n, n2)) {
                n9 = 1;
            } else if (SGFigureElementShape.isInside(n7, n6, n, n2)) {
                n9 = 2;
            } else if (this.getElementBounds().contains(n, n2)) {
                n9 = 0;
            }
            return n9;
        }

        public List getAnchorPointList() {
            ArrayList<Point2D.Float> arrayList = new ArrayList<Point2D.Float>();
            float f = this.getMagnification();
            float f2 = this.getX();
            float f3 = this.getY();
            float f4 = f * this.getWidth();
            float f5 = f * this.getHeight();
            float f6 = f2 + 0.5f * f4;
            float f7 = f3 + 0.5f * f5;
            Point2D.Float float_ = new Point2D.Float(f2, f3);
            Point2D.Float float_2 = new Point2D.Float(f2 + f4, f3);
            Point2D.Float float_3 = new Point2D.Float(f2, f3 + f5);
            Point2D.Float float_4 = new Point2D.Float(f2 + f4, f3 + f5);
            Point2D.Float float_5 = new Point2D.Float(f2, f7);
            Point2D.Float float_6 = new Point2D.Float(f2 + f4, f7);
            Point2D.Float float_7 = new Point2D.Float(f6, f3);
            Point2D.Float float_8 = new Point2D.Float(f6, f3 + f5);
            arrayList.add(float_);
            arrayList.add(float_2);
            arrayList.add(float_3);
            arrayList.add(float_4);
            arrayList.add(float_5);
            arrayList.add(float_6);
            arrayList.add(float_7);
            arrayList.add(float_8);
            return arrayList;
        }

        public boolean drag(MouseEvent mouseEvent, Point point, int n) {
            Rectangle2D rectangle2D = this.getElementBounds();
            SGUtility.resizeRectangle(rectangle2D, point, mouseEvent, n);
            float f = this.getMagnification();
            float f2 = (float)rectangle2D.getX();
            float f3 = (float)rectangle2D.getY();
            float f4 = (float)rectangle2D.getWidth() / f;
            float f5 = (float)rectangle2D.getHeight() / f;
            this.setWidth(f4);
            this.setHeight(f5);
            this.setLeftX(f2);
            this.setTopY(f3);
            return true;
        }

        public Object copy() {
            Rect rect = new Rect();
            rect.setShapeObject(this.mShape);
            rect.setMagnification(this.getMagnification());
            rect.setProperties(this.getProperties());
            rect.setShapeWithAxesValues();
            return rect;
        }

        public void translate(float f, float f2) {
            this.setLocation(this.getX() + f, this.getY() + f2);
            this.setAxisValuesWithShape();
        }

        public boolean contains(int n, int n2) {
            if (super.contains(n, n2)) {
                return true;
            }
            if (this.mShape.isSelected()) {
                boolean bl;
                int n3 = (int)this.getLeftX();
                int n4 = (int)this.getRightX();
                int n5 = (int)this.getTopY();
                int n6 = (int)this.getBottomY();
                int n7 = (int)this.getCenterX();
                int n8 = (int)this.getCenterY();
                boolean bl2 = bl = SGFigureElementShape.isInside(n3, n5, n, n2) || SGFigureElementShape.isInside(n3, n8, n, n2) || SGFigureElementShape.isInside(n3, n6, n, n2) || SGFigureElementShape.isInside(n4, n5, n, n2) || SGFigureElementShape.isInside(n4, n8, n, n2) || SGFigureElementShape.isInside(n4, n6, n, n2) || SGFigureElementShape.isInside(n7, n5, n, n2) || SGFigureElementShape.isInside(n7, n6, n, n2);
                if (bl) {
                    return true;
                }
            }
            return false;
        }

        public String getName() {
            return NAME;
        }

        public String getClassDescription() {
            return "";
        }

        public String getInstanceDescription() {
            SGIFigureElementAxis sGIFigureElementAxis = SGFigureElementShape.this.mAxisElement;
            String string = sGIFigureElementAxis.getLocationName(this.getXAxis());
            String string2 = sGIFigureElementAxis.getLocationName(this.getYAxis());
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getID());
            stringBuffer.append(": ");
            stringBuffer.append(this.getName());
            stringBuffer.append(", AxisX=");
            stringBuffer.append(string.toString());
            stringBuffer.append(", AxisY=");
            stringBuffer.append(string2.toString());
            stringBuffer.append(", X=");
            stringBuffer.append(this.mXValue1);
            stringBuffer.append(", Y=");
            stringBuffer.append(this.mYValue1);
            return stringBuffer.toString();
        }

        public ArrayList getChildNodes() {
            return new ArrayList();
        }

        public SGProperties getProperties() {
            RectangularShapeProperties rectangularShapeProperties = new RectangularShapeProperties();
            if (!this.getProperties(rectangularShapeProperties)) {
                return null;
            }
            return rectangularShapeProperties;
        }

        public boolean getProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof RectangularShapeProperties)) {
                return false;
            }
            if (!super.getProperties(sGProperties)) {
                return false;
            }
            RectangularShapeProperties rectangularShapeProperties = (RectangularShapeProperties)sGProperties;
            SGFigureElementShape sGFigureElementShape = this.getShapeElement();
            SGIFigureElementAxis sGIFigureElementAxis = sGFigureElementShape.getAxisElement();
            SGAxis sGAxis = this.getXAxis();
            SGAxis sGAxis2 = this.getYAxis();
            rectangularShapeProperties.setXAxisLocation(sGIFigureElementAxis.getLocationInPlane(sGAxis));
            rectangularShapeProperties.setYAxisLocation(sGIFigureElementAxis.getLocationInPlane(sGAxis2));
            rectangularShapeProperties.setXValue1(this.mXValue1);
            rectangularShapeProperties.setYValue1(this.mYValue1);
            rectangularShapeProperties.setXValue2(this.mXValue2);
            rectangularShapeProperties.setYValue2(this.mYValue2);
            rectangularShapeProperties.setAnchored(this.mIsAnchored);
            return true;
        }

        public boolean setProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof RectangularShapeProperties)) {
                return false;
            }
            if (!super.setProperties(sGProperties)) {
                return false;
            }
            RectangularShapeProperties rectangularShapeProperties = (RectangularShapeProperties)sGProperties;
            Double d = rectangularShapeProperties.getXValue1();
            if (d == null) {
                return false;
            }
            this.mXValue1 = d;
            Double d2 = rectangularShapeProperties.getYValue1();
            if (d2 == null) {
                return false;
            }
            this.mYValue1 = d2;
            Double d3 = rectangularShapeProperties.getXValue2();
            if (d3 == null) {
                return false;
            }
            this.mXValue2 = d3;
            Double d4 = rectangularShapeProperties.getYValue2();
            if (d4 == null) {
                return false;
            }
            this.mYValue2 = d4;
            Boolean bl = rectangularShapeProperties.getAnchored();
            if (bl == null) {
                return false;
            }
            this.mIsAnchored = bl;
            return true;
        }

        public SGProperties getMement() {
            return this.getProperties();
        }

        public boolean setMement(SGProperties sGProperties) {
            return this.setProperties(sGProperties);
        }

        public double getLeftXValue() {
            return !this.isHorizontallyReversed() ? this.mXValue1 : this.mXValue2;
        }

        public double getTopYValue() {
            return !this.isPerpendicularlyReversed() ? this.mYValue1 : this.mYValue2;
        }

        public double getRightXValue() {
            return !this.isHorizontallyReversed() ? this.mXValue2 : this.mXValue1;
        }

        public double getBottomYValue() {
            return !this.isPerpendicularlyReversed() ? this.mYValue2 : this.mYValue1;
        }

        public boolean isAnchored() {
            return this.mIsAnchored;
        }

        public float getLineWidth() {
            return this.getEdgeLineWidth();
        }

        public int getLineType() {
            return this.getEdgeLineType();
        }

        public Color getLineColor() {
            return this.getEdgeLineColor();
        }

        public boolean isLineVisible() {
            return this.isEdgeLineVisible();
        }

        public boolean setLeftXValue(double d) {
            if (!this.getXAxis().isValidValue(d)) {
                return false;
            }
            if (!this.isHorizontallyReversed()) {
                this.mXValue1 = d;
            } else {
                this.mXValue2 = d;
            }
            return true;
        }

        public boolean setRightXValue(double d) {
            if (!this.getXAxis().isValidValue(d)) {
                return false;
            }
            if (!this.isHorizontallyReversed()) {
                this.mXValue2 = d;
            } else {
                this.mXValue1 = d;
            }
            return true;
        }

        public boolean setTopYValue(double d) {
            if (!this.getYAxis().isValidValue(d)) {
                return false;
            }
            if (!this.isPerpendicularlyReversed()) {
                this.mYValue1 = d;
            } else {
                this.mYValue2 = d;
            }
            return true;
        }

        public boolean setBottomYValue(double d) {
            if (!this.getYAxis().isValidValue(d)) {
                return false;
            }
            if (!this.isPerpendicularlyReversed()) {
                this.mYValue2 = d;
            } else {
                this.mYValue1 = d;
            }
            return true;
        }

        public boolean setAnchored(boolean bl) {
            this.mIsAnchored = bl;
            return true;
        }

        public boolean setLineWidth(float f, String string) {
            return this.setEdgeLineWidth(f, string);
        }

        public boolean setLineType(int n) {
            return this.setEdgeLineType(n);
        }

        public boolean setLineColor(Color color) {
            return this.setEdgeLineColor(color);
        }

        public boolean setLineVisible(boolean bl) {
            return this.setEdgeLineVisible(bl);
        }

        public int getXAxisLocation() {
            return this.mShape.getAxisConfiguration(this.getXAxis());
        }

        public int getYAxisLocation() {
            return this.mShape.getAxisConfiguration(this.getYAxis());
        }

        public boolean setXAxisLocation(int n) {
            if (n != 0 && n != 1) {
                return false;
            }
            this.mShape.setXAxis(n);
            return true;
        }

        public boolean setYAxisLocation(int n) {
            if (n != 2 && n != 3) {
                return false;
            }
            this.mShape.setYAxis(n);
            return true;
        }

        public boolean hasValidLeftXValue(int n, Number number) {
            SGIFigureElementAxis sGIFigureElementAxis = this.getShapeElement().getAxisElement();
            SGAxis sGAxis = n == -1 ? this.getXAxis() : sGIFigureElementAxis.getAxisInPlane(n);
            double d = number != null ? number.doubleValue() : this.getLeftXValue();
            return sGAxis.isValidValue(d);
        }

        public boolean hasValidTopYValue(int n, Number number) {
            SGIFigureElementAxis sGIFigureElementAxis = this.getShapeElement().getAxisElement();
            SGAxis sGAxis = n == -1 ? this.mShape.getYAxis() : sGIFigureElementAxis.getAxisInPlane(n);
            double d = number != null ? number.doubleValue() : this.getTopYValue();
            return sGAxis.isValidValue(d);
        }

        public boolean hasValidRightXValue(int n, Number number) {
            SGIFigureElementAxis sGIFigureElementAxis = this.getShapeElement().getAxisElement();
            SGAxis sGAxis = n == -1 ? this.getXAxis() : sGIFigureElementAxis.getAxisInPlane(n);
            double d = number != null ? number.doubleValue() : this.getRightXValue();
            return sGAxis.isValidValue(d);
        }

        public boolean hasValidBottomYValue(int n, Number number) {
            SGIFigureElementAxis sGIFigureElementAxis = this.getShapeElement().getAxisElement();
            SGAxis sGAxis = n == -1 ? this.getYAxis() : sGIFigureElementAxis.getAxisInPlane(n);
            double d = number != null ? number.doubleValue() : this.getBottomYValue();
            return sGAxis.isValidValue(d);
        }

        public boolean prepare() {
            this.mTemporaryProperties = this.getProperties();
            return true;
        }

        public boolean commit() {
            SGProperties sGProperties = this.mTemporaryProperties;
            SGProperties sGProperties2 = this.getProperties();
            if (!sGProperties.equals(sGProperties2)) {
                this.mShape.setChanged(true);
            }
            this.setShapeWithAxesValues();
            SGFigureElementShape sGFigureElementShape = this.getShapeElement();
            sGFigureElementShape.repaint();
            sGFigureElementShape.notifyChange();
            return true;
        }

        public boolean cancel() {
            if (!this.setProperties(this.mTemporaryProperties)) {
                return false;
            }
            this.mTemporaryProperties = null;
            this.setShapeWithAxesValues();
            SGFigureElementShape sGFigureElementShape = this.getShapeElement();
            sGFigureElementShape.repaint();
            sGFigureElementShape.notifyChange();
            return true;
        }

        public boolean preview() {
            this.setShapeWithAxesValues();
            SGFigureElementShape sGFigureElementShape = this.getShapeElement();
            sGFigureElementShape.repaint();
            sGFigureElementShape.notifyChange();
            return true;
        }

        public SGPropertyDialog getPropertyDialog() {
            return SGFigureElementShape.this.getShapeDialog(this);
        }

        public void dump() {
            System.out.println(this.mXValue1 + "  " + this.mXValue2);
            System.out.println(this.mYValue1 + "  " + this.mYValue2);
            System.out.println();
        }

        public boolean writeProperty(Element element) {
            if (!super.writeProperty(element)) {
                return false;
            }
            element.setAttribute(KEY_LEFT_X_VALUE, Double.toString(this.getLeftXValue()));
            element.setAttribute(KEY_RIGHT_X_VALUE, Double.toString(this.getRightXValue()));
            element.setAttribute(KEY_BOTTOM_Y_VALUE, Double.toString(this.getBottomYValue()));
            element.setAttribute(KEY_TOP_Y_VALUE, Double.toString(this.getTopYValue()));
            element.setAttribute(KEY_ANCHORED, Boolean.toString(this.mIsAnchored));
            return true;
        }

        public boolean readProperty(Element element) {
            double d;
            if (!super.readProperty(element)) {
                return false;
            }
            String string = null;
            Double d2 = null;
            Boolean bl = null;
            SGAxis sGAxis = this.getXAxis();
            SGAxis sGAxis2 = this.getYAxis();
            string = element.getAttribute(KEY_LEFT_X_VALUE);
            if (string.length() != 0) {
                d2 = SGUtilityText.getDouble(string);
                if (d2 == null) {
                    return false;
                }
                d = d2;
                if (!sGAxis.isValidValue(d)) {
                    return false;
                }
                this.setLeftXValue(d);
            }
            if ((string = element.getAttribute(KEY_RIGHT_X_VALUE)).length() != 0) {
                d2 = SGUtilityText.getDouble(string);
                if (d2 == null) {
                    return false;
                }
                d = d2;
                if (!sGAxis.isValidValue(d)) {
                    return false;
                }
                this.setRightXValue(d);
            }
            if ((string = element.getAttribute(KEY_BOTTOM_Y_VALUE)).length() != 0) {
                d2 = SGUtilityText.getDouble(string);
                if (d2 == null) {
                    return false;
                }
                d = d2;
                if (!sGAxis2.isValidValue(d)) {
                    return false;
                }
                this.setBottomYValue(d);
            }
            if ((string = element.getAttribute(KEY_TOP_Y_VALUE)).length() != 0) {
                d2 = SGUtilityText.getDouble(string);
                if (d2 == null) {
                    return false;
                }
                d = d2;
                if (!sGAxis2.isValidValue(d)) {
                    return false;
                }
                this.setTopYValue(d);
            }
            if ((string = element.getAttribute(KEY_ANCHORED)).length() != 0) {
                bl = SGUtilityText.getBoolean(string);
                if (bl == null) {
                    return false;
                }
                this.setAnchored(bl);
                this.setShapeWithAxesValues();
            }
            return true;
        }

        public SGPropertyResults setProperties(SGPropertyMap sGPropertyMap, SGPropertyResults sGPropertyResults) {
            SGPropertyResults sGPropertyResults2 = (SGPropertyResults)sGPropertyResults.clone();
            Iterator<String> iterator = sGPropertyMap.getKeyIterator();
            while (iterator.hasNext()) {
                Serializable serializable;
                String string = iterator.next();
                String string2 = sGPropertyMap.getValueString(string);
                if ("LeftX".equalsIgnoreCase(string)) {
                    serializable = SGUtilityText.getDouble(string2);
                    if (serializable == null) {
                        sGPropertyResults2.putResult("LeftX", 1);
                        continue;
                    }
                    if (!SGUtility.isValidPropertyValue((Double)serializable)) {
                        sGPropertyResults2.putResult("LeftX", 1);
                        continue;
                    }
                    if (!this.setLeftXValue((Double)serializable)) {
                        sGPropertyResults2.putResult("LeftX", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("LeftX", 0);
                    continue;
                }
                if ("RightX".equalsIgnoreCase(string)) {
                    serializable = SGUtilityText.getDouble(string2);
                    if (serializable == null) {
                        sGPropertyResults2.putResult("RightX", 1);
                        continue;
                    }
                    if (!SGUtility.isValidPropertyValue((Double)serializable)) {
                        sGPropertyResults2.putResult("RightX", 1);
                        continue;
                    }
                    if (!this.setRightXValue((Double)serializable)) {
                        sGPropertyResults2.putResult("RightX", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("RightX", 0);
                    continue;
                }
                if ("TopY".equalsIgnoreCase(string)) {
                    serializable = SGUtilityText.getDouble(string2);
                    if (serializable == null) {
                        sGPropertyResults2.putResult("TopY", 1);
                        continue;
                    }
                    if (!SGUtility.isValidPropertyValue((Double)serializable)) {
                        sGPropertyResults2.putResult("TopY", 1);
                        continue;
                    }
                    if (!this.setTopYValue((Double)serializable)) {
                        sGPropertyResults2.putResult("TopY", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("TopY", 0);
                    continue;
                }
                if ("BottomY".equalsIgnoreCase(string)) {
                    serializable = SGUtilityText.getDouble(string2);
                    if (serializable == null) {
                        sGPropertyResults2.putResult("BottomY", 1);
                        continue;
                    }
                    if (!SGUtility.isValidPropertyValue((Double)serializable)) {
                        sGPropertyResults2.putResult("BottomY", 1);
                        continue;
                    }
                    if (!this.setBottomYValue((Double)serializable)) {
                        sGPropertyResults2.putResult("BottomY", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("BottomY", 0);
                    continue;
                }
                if ("EdgeLineWidth".equalsIgnoreCase(string)) {
                    serializable = new StringBuffer();
                    Number number = SGUtilityText.getNumber(string2, (StringBuffer)serializable);
                    if (number == null) {
                        sGPropertyResults2.putResult("EdgeLineWidth", 1);
                        continue;
                    }
                    if (!this.setEdgeLineWidth(number.floatValue(), ((StringBuffer)serializable).toString())) {
                        sGPropertyResults2.putResult("EdgeLineWidth", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("EdgeLineWidth", 0);
                    continue;
                }
                if ("EdgeLineType".equalsIgnoreCase(string)) {
                    serializable = SGDrawingElementLine.getLineTypeFromName(string2);
                    if (serializable == null) {
                        sGPropertyResults2.putResult("EdgeLineType", 1);
                        continue;
                    }
                    if (!this.setEdgeLineType((Integer)serializable)) {
                        sGPropertyResults2.putResult("EdgeLineType", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("EdgeLineType", 0);
                    continue;
                }
                if ("EdgeLineColor".equalsIgnoreCase(string)) {
                    serializable = SGUtilityText.parseColorString(string2);
                    if (serializable == null) {
                        sGPropertyResults2.putResult("EdgeLineColor", 1);
                        continue;
                    }
                    if (!this.setLineColor((Color)serializable)) {
                        sGPropertyResults2.putResult("EdgeLineColor", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("EdgeLineColor", 0);
                    continue;
                }
                if ("EdgeLineVisible".equalsIgnoreCase(string)) {
                    serializable = SGUtilityText.getBoolean(string2);
                    if (serializable == null) {
                        sGPropertyResults2.putResult("EdgeLineVisible", 1);
                        continue;
                    }
                    if (!this.setLineVisible((Boolean)serializable)) {
                        sGPropertyResults2.putResult("EdgeLineVisible", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("EdgeLineVisible", 0);
                    continue;
                }
                if ("BackgroundPaintStyle".equalsIgnoreCase(string)) {
                    serializable = SGSelectablePaint.getStyleIndex(string2);
                    if (serializable == null) {
                        sGPropertyResults2.putResult("BackgroundPaintStyle", 1);
                        continue;
                    }
                    if (!this.setInnerPaintStyle((Integer)serializable)) {
                        sGPropertyResults2.putResult("BackgroundPaintStyle", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("BackgroundPaintStyle", 0);
                    continue;
                }
                if ("BackgroundFillColor".equalsIgnoreCase(string)) {
                    serializable = SGUtilityText.parseColorString(string2);
                    if (serializable == null) {
                        sGPropertyResults2.putResult("BackgroundFillColor", 1);
                        continue;
                    }
                    if (!this.setInnerFillColor((Color)serializable)) {
                        sGPropertyResults2.putResult("BackgroundFillColor", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("BackgroundFillColor", 0);
                    continue;
                }
                if ("BackgroundPatternColor".equalsIgnoreCase(string)) {
                    serializable = SGUtilityText.parseColorString(string2);
                    if (serializable == null) {
                        sGPropertyResults2.putResult("BackgroundPatternColor", 1);
                        continue;
                    }
                    if (!this.setInnerPatternColor((Color)serializable)) {
                        sGPropertyResults2.putResult("BackgroundPatternColor", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("BackgroundPatternColor", 0);
                    continue;
                }
                if ("BackgroundPatternType".equalsIgnoreCase(string)) {
                    serializable = SGPatternPaint.getTypeFromName(string2);
                    if (serializable == null) {
                        sGPropertyResults2.putResult("BackgroundPatternType", 1);
                        continue;
                    }
                    if (!this.setInnerPatternType((Integer)serializable)) {
                        sGPropertyResults2.putResult("BackgroundPatternType", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("BackgroundPatternType", 0);
                    continue;
                }
                if ("BackgroundGradationColor1".equalsIgnoreCase(string)) {
                    serializable = SGUtilityText.parseColorString(string2);
                    if (serializable == null) {
                        sGPropertyResults2.putResult("BackgroundGradationColor1", 1);
                        continue;
                    }
                    if (!this.setInnerGradationColor1((Color)serializable)) {
                        sGPropertyResults2.putResult("BackgroundGradationColor1", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("BackgroundGradationColor1", 0);
                    continue;
                }
                if ("BackgroundGradationColor2".equalsIgnoreCase(string)) {
                    serializable = SGUtilityText.parseColorString(string2);
                    if (serializable == null) {
                        sGPropertyResults2.putResult("BackgroundGradationColor2", 1);
                        continue;
                    }
                    if (!this.setInnerGradationColor2((Color)serializable)) {
                        sGPropertyResults2.putResult("BackgroundGradationColor2", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("BackgroundGradationColor2", 0);
                    continue;
                }
                if ("BackgroundGradationDirection".equalsIgnoreCase(string)) {
                    serializable = SGGradationPaint.getDirectionIndex(string2);
                    if (serializable == null) {
                        sGPropertyResults2.putResult("BackgroundGradationDirection", 1);
                        continue;
                    }
                    if (!this.setInnerGradationDirection((Integer)serializable)) {
                        sGPropertyResults2.putResult("BackgroundGradationDirection", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("BackgroundGradationDirection", 0);
                    continue;
                }
                if ("BackgroundGradationOrder".equalsIgnoreCase(string)) {
                    serializable = SGGradationPaint.getOrderIndex(string2);
                    if (serializable == null) {
                        sGPropertyResults2.putResult("BackgroundGradationOrder", 1);
                        continue;
                    }
                    if (!this.setInnerGradationOrder((Integer)serializable)) {
                        sGPropertyResults2.putResult("BackgroundGradationOrder", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("BackgroundGradationOrder", 0);
                    continue;
                }
                if ("BackgroundTransparency".equalsIgnoreCase(string)) {
                    serializable = SGUtilityText.getInteger(string2, "%");
                    if (serializable == null) {
                        sGPropertyResults2.putResult("BackgroundTransparency", 1);
                        continue;
                    }
                    if (!this.setTransparent((Integer)serializable)) {
                        sGPropertyResults2.putResult("BackgroundTransparency", 1);
                        continue;
                    }
                    sGPropertyResults2.putResult("BackgroundTransparency", 0);
                    continue;
                }
                if (!KEY_ANCHORED.equalsIgnoreCase(string)) continue;
                serializable = SGUtilityText.getBoolean(string2);
                if (serializable == null) {
                    sGPropertyResults2.putResult(KEY_ANCHORED, 1);
                    continue;
                }
                if (!this.setAnchored((Boolean)serializable)) {
                    sGPropertyResults2.putResult(KEY_ANCHORED, 1);
                    continue;
                }
                sGPropertyResults2.putResult(KEY_ANCHORED, 0);
            }
            return sGPropertyResults2;
        }
    }

    private class ShapeObject
    extends SGDrawingElement
    implements ActionListener,
    SGIUndoable,
    SGFigureElement.IMovableChild,
    SGICopiable,
    SGIPropertyDialogObserver,
    SGIAnchored {
        private int mID;
        private SGAxis mXAxis;
        private SGAxis mYAxis;
        private IElement mElement = null;
        private SGUndoManager mUndoManager = new SGUndoManager(this);
        private int mTempXAxis = -1;
        private int mTempYAxis = -1;
        private SGProperties mTemporaryProperties = null;
        private ShapeObjectPopupMenu mPopupMenu = null;
        private boolean mDisposed = false;
        private boolean mValidFlag = true;
        private int mMouseLocation;
        private boolean mSelectedFlag = false;

        public int getID() {
            return this.mID;
        }

        public boolean setID(int n) {
            this.mID = n;
            return true;
        }

        private ShapeObject() {
            this.init();
        }

        private ShapeObject(IElement iElement) {
            this.setIElement(iElement);
            this.init();
        }

        private ShapeObject(int n, IElement iElement, SGAxis sGAxis, SGAxis sGAxis2) {
            this.setIElement(iElement);
            this.setXAxis(sGAxis);
            this.setYAxis(sGAxis2);
            this.init();
        }

        private void init() {
        }

        public void dispose() {
            super.dispose();
            this.mElement.dispose();
            this.mElement = null;
            this.mPopupMenu = null;
            if (this.mTemporaryProperties != null) {
                this.mTemporaryProperties.dispose();
                this.mTemporaryProperties = null;
            }
            this.mUndoManager.dispose();
            this.mUndoManager = null;
            this.mXAxis = null;
            this.mYAxis = null;
        }

        public boolean isDisposed() {
            return this.mDisposed;
        }

        public JPopupMenu getPopupMenu() {
            ShapeObjectPopupMenu shapeObjectPopupMenu = null;
            if (this.mPopupMenu != null) {
                shapeObjectPopupMenu = this.mPopupMenu;
            } else {
                shapeObjectPopupMenu = new ShapeObjectPopupMenu();
                shapeObjectPopupMenu.init(this);
                this.mPopupMenu = shapeObjectPopupMenu;
            }
            shapeObjectPopupMenu.setAnchored(this.mElement.isAnchored());
            return shapeObjectPopupMenu;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("Property")) {
                SGFigureElementShape.this.clearFocusedObjectOtherThan(this);
                SGFigureElementShape.this.setPropertiesOfSelectedObjects();
            } else if (string.equals("Copy") || string.equals("Cut") || string.equals("Paste") || string.equals("Delete") || string.equals("Duplicate") || string.equals("Bring to Front") || string.equals("Bring Forward") || string.equals("Send Backward") || string.equals("Send to Back")) {
                SGFigureElementShape.this.notifyToListener(string);
            } else if (string.equals("Anchored")) {
                SGFigureElementShape.this.notifyToListener(string, actionEvent.getSource());
            }
        }

        public boolean prepare() {
            return this.mElement.prepare();
        }

        public boolean commit() {
            return this.mElement.commit();
        }

        public IElement getIElement() {
            return this.mElement;
        }

        public void setIElement(IElement iElement) {
            this.mElement = iElement;
        }

        private SGFigureElementShape getShapeElement() {
            return SGFigureElementShape.this;
        }

        private SGIFigureElementAxis getAxisElement() {
            return this.getShapeElement().getAxisElement();
        }

        public SGAxis getXAxis() {
            return this.mXAxis;
        }

        public SGAxis getYAxis() {
            return this.mYAxis;
        }

        public void setXAxis(SGAxis sGAxis) {
            this.mXAxis = sGAxis;
        }

        public void setYAxis(SGAxis sGAxis) {
            this.mYAxis = sGAxis;
        }

        private SGDrawingElement getDrawingElement() {
            return (SGDrawingElement)((Object)this.mElement);
        }

        private SGIDrawingElementJava2D getDrawingElement2D() {
            return (SGIDrawingElementJava2D)((Object)this.mElement);
        }

        public void setVisible(boolean bl) {
            super.setVisible(bl);
            this.getDrawingElement().setVisible(bl);
        }

        private void paintElement(Graphics2D graphics2D) {
            if (this.isValid()) {
                this.getDrawingElement2D().paint(graphics2D);
            }
        }

        public boolean isValid() {
            return this.mValidFlag;
        }

        public void setValid(boolean bl) {
            this.mValidFlag = bl;
        }

        public boolean setAxisValuesWithShape() {
            return this.mElement.setAxisValuesWithShape();
        }

        public boolean setShapeWithAxesValues() {
            return this.mElement.setShapeWithAxesValues();
        }

        public boolean contains(int n, int n2) {
            return ((SGDrawingElement)((Object)this.mElement)).contains(n, n2);
        }

        private List getAnchorPointList() {
            return this.mElement.getAnchorPointList();
        }

        private int getMouseLocation(int n, int n2) {
            return this.mElement.getMouseLocation(n, n2);
        }

        private Cursor getCursor(int n) {
            Cursor cursor = null;
            switch (n) {
                case 1: {
                    cursor = new Cursor(8);
                    break;
                }
                case 2: {
                    cursor = new Cursor(9);
                    break;
                }
                case 3: {
                    cursor = new Cursor(10);
                    break;
                }
                case 4: {
                    cursor = new Cursor(11);
                    break;
                }
                case 5: {
                    cursor = new Cursor(6);
                    break;
                }
                case 7: {
                    cursor = new Cursor(4);
                    break;
                }
                case 6: {
                    cursor = new Cursor(7);
                    break;
                }
                case 8: {
                    cursor = new Cursor(5);
                    break;
                }
                default: {
                    cursor = new Cursor(12);
                }
            }
            return cursor;
        }

        private boolean press(MouseEvent mouseEvent) {
            int n;
            int n2 = mouseEvent.getX();
            if (this.contains(n2, n = mouseEvent.getY())) {
                this.mMouseLocation = this.getMouseLocation(n2, n);
                Cursor cursor = null;
                if (this.mMouseLocation == 0) {
                    cursor = Cursor.getPredefinedCursor(13);
                } else {
                    this.getCursor(this.mMouseLocation);
                }
                SGFigureElementShape.this.setMouseCursor(cursor);
                return true;
            }
            return false;
        }

        private boolean drag(MouseEvent mouseEvent) {
            if (SGFigureElementShape.this.mPressedPoint == null) {
                return false;
            }
            if (this.mMouseLocation == 0) {
                boolean bl = this.dragOtherPoint(mouseEvent);
                return bl;
            }
            Point point = new Point(SGFigureElementShape.this.mPressedPoint);
            this.mElement.drag(mouseEvent, point, this.mMouseLocation);
            SGFigureElementShape.this.mPressedPoint.setLocation(point);
            return true;
        }

        private boolean dragOtherPoint(MouseEvent mouseEvent) {
            if (SGFigureElementShape.this.mPressedPoint != null) {
                int n = mouseEvent.getX() - ((SGFigureElementShape)SGFigureElementShape.this).mPressedPoint.x;
                int n2 = mouseEvent.getY() - ((SGFigureElementShape)SGFigureElementShape.this).mPressedPoint.y;
                this.translate(n, n2);
                SGFigureElementShape.this.mPressedPoint = mouseEvent.getPoint();
            }
            return true;
        }

        public boolean isSelected() {
            return this.mSelectedFlag;
        }

        public void setSelected(boolean bl) {
            this.mSelectedFlag = bl;
        }

        public int getAxisConfiguration(SGAxis sGAxis) {
            return SGFigureElementShape.this.mAxisElement.getLocationInPlane(sGAxis);
        }

        public boolean setXAxis(int n) {
            if (n != 0 && n != 1) {
                return false;
            }
            this.setXAxis(SGFigureElementShape.this.mAxisElement.getAxisInPlane(n));
            return true;
        }

        public boolean setYAxis(int n) {
            if (n != 2 && n != 3) {
                return false;
            }
            this.setYAxis(SGFigureElementShape.this.mAxisElement.getAxisInPlane(n));
            return true;
        }

        public Object copy() {
            IElement iElement = (IElement)this.mElement.copy();
            SGAxis sGAxis = this.getXAxis();
            SGAxis sGAxis2 = this.getYAxis();
            int n = this.getAxisConfiguration(this.getXAxis());
            int n2 = this.getAxisConfiguration(this.getYAxis());
            ShapeObject shapeObject = new ShapeObject(iElement);
            iElement.setShapeObject(shapeObject);
            shapeObject.setXAxis(sGAxis);
            shapeObject.setYAxis(sGAxis2);
            shapeObject.mTempXAxis = n;
            shapeObject.mTempYAxis = n2;
            return shapeObject;
        }

        public void translate(float f, float f2) {
            this.mElement.translate(f, f2);
        }

        public boolean isChanged() {
            return this.mUndoManager.isChanged();
        }

        public void setChanged(boolean bl) {
            this.mUndoManager.setChanged(bl);
        }

        public boolean isChangedRoot() {
            return this.isChanged();
        }

        public void clearChanged() {
            this.setChanged(false);
        }

        public boolean initPropertiesHistory() {
            return this.mUndoManager.initPropertiesHistory();
        }

        public void notifyToRoot() {
            SGFigureElementShape.this.notifyToRoot();
        }

        public boolean updateHistory() {
            return this.mUndoManager.updateHistory();
        }

        public void initUndoBuffer() {
            this.mUndoManager.initUndoBuffer();
        }

        public boolean setMementoBackward() {
            if (!this.mUndoManager.setMementoBackward()) {
                return false;
            }
            this.setShapeWithAxesValues();
            return true;
        }

        public boolean setMementoForward() {
            if (!this.mUndoManager.setMementoForward()) {
                return false;
            }
            this.setShapeWithAxesValues();
            return true;
        }

        public boolean undo() {
            return this.setMementoBackward();
        }

        public boolean redo() {
            return this.setMementoForward();
        }

        public SGProperties getMemento() {
            return this.mElement.getMement();
        }

        public boolean setMemento(SGProperties sGProperties) {
            if (!(sGProperties instanceof PropertyWithAxes)) {
                return false;
            }
            if (!super.setProperties(sGProperties)) {
                return false;
            }
            PropertyWithAxes propertyWithAxes = (PropertyWithAxes)((Object)sGProperties);
            SGAxis sGAxis = SGFigureElementShape.this.mAxisElement.getAxisInPlane(propertyWithAxes.getXAxisLocation());
            if (sGAxis == null) {
                return false;
            }
            this.setXAxis(sGAxis);
            SGAxis sGAxis2 = SGFigureElementShape.this.mAxisElement.getAxisInPlane(propertyWithAxes.getYAxisLocation());
            if (sGAxis2 == null) {
                return false;
            }
            this.setYAxis(sGAxis2);
            return this.mElement.setMement(sGProperties);
        }

        public boolean isUndoable() {
            return this.mUndoManager.isUndoable();
        }

        public boolean isRedoable() {
            return this.mUndoManager.isRedoable();
        }

        public boolean deleteForwardHistory() {
            return this.mUndoManager.deleteForwardHistory();
        }

        public Element createElement(Document document) {
            Element element = document.createElement(this.mElement.getName());
            if (!this.writeProperty(element)) {
                return null;
            }
            return element;
        }

        public boolean writeProperty(Element element) {
            SGIFigureElementAxis sGIFigureElementAxis = this.getAxisElement();
            element.setAttribute("XAxisPosition", sGIFigureElementAxis.getLocationName(this.getXAxis()));
            element.setAttribute("YAxisPosition", sGIFigureElementAxis.getLocationName(this.getYAxis()));
            return this.mElement.writeProperty(element);
        }

        public boolean readProperty(Element element) {
            SGIFigureElementAxis sGIFigureElementAxis = this.getAxisElement();
            String string = null;
            String string2 = element.getTagName();
            SGDrawingElement sGDrawingElement = null;
            if (string2.equals("Rectangle")) {
                sGDrawingElement = new Rect();
            } else if (string2.equals("Ellipse")) {
                sGDrawingElement = new Ellipse();
            } else if (string2.equals("Arrow")) {
                sGDrawingElement = new Arrow();
            } else {
                return false;
            }
            this.setIElement((IElement)((Object)sGDrawingElement));
            sGDrawingElement.setShapeObject(this);
            string = element.getAttribute("XAxisPosition");
            if (string.length() == 0) {
                return false;
            }
            SGAxis sGAxis = sGIFigureElementAxis.getAxis(string);
            if (sGAxis == null) {
                return false;
            }
            string = element.getAttribute("YAxisPosition");
            if (string.length() == 0) {
                return false;
            }
            SGAxis sGAxis2 = sGIFigureElementAxis.getAxis(string);
            if (sGAxis2 == null) {
                return false;
            }
            this.setXAxis(sGAxis);
            this.setYAxis(sGAxis2);
            return sGDrawingElement.readProperty(element);
        }

        public float getMagnification() {
            return SGFigureElementShape.this.getMagnification();
        }

        public boolean setMagnification(float f) {
            return this.mElement.setMagnification(f);
        }

        public SGPropertyResults setProperties(SGPropertyMap sGPropertyMap) {
            SGPropertyResults sGPropertyResults = new SGPropertyResults();
            if (!this.prepare()) {
                return null;
            }
            Iterator<String> iterator = sGPropertyMap.getKeyIterator();
            while (iterator.hasNext()) {
                int n;
                String string = iterator.next();
                String string2 = sGPropertyMap.getValueString(string);
                if ("AxisX".equalsIgnoreCase(string)) {
                    n = SGUtility.getAxisLocation(string2);
                    if (n == -1) {
                        sGPropertyResults.putResult("AxisX", 1);
                        continue;
                    }
                    if (!this.setXAxis(n)) {
                        sGPropertyResults.putResult("AxisX", 1);
                        continue;
                    }
                    sGPropertyResults.putResult("AxisX", 0);
                    continue;
                }
                if (!"AxisY".equalsIgnoreCase(string)) continue;
                n = SGUtility.getAxisLocation(string2);
                if (n == -1) {
                    sGPropertyResults.putResult("AxisY", 1);
                    continue;
                }
                if (!this.setYAxis(n)) {
                    sGPropertyResults.putResult("AxisY", 1);
                    continue;
                }
                sGPropertyResults.putResult("AxisY", 0);
            }
            sGPropertyResults = this.getIElement().setProperties(sGPropertyMap, sGPropertyResults);
            if (sGPropertyResults == null) {
                return null;
            }
            if (!this.commit()) {
                return null;
            }
            this.notifyToRoot();
            SGFigureElementShape.this.notifyChange();
            SGFigureElementShape.this.repaint();
            return sGPropertyResults;
        }

        public boolean cancel() {
            return this.mElement.cancel();
        }

        public boolean preview() {
            return this.mElement.preview();
        }

        public SGPropertyDialog getPropertyDialog() {
            return this.mElement.getPropertyDialog();
        }

        public boolean isAnchored() {
            return this.mElement.isAnchored();
        }

        public boolean setAnchored(boolean bl) {
            return this.mElement.setAnchored(bl);
        }
    }

    private static class ShapeObjectPopupMenu
    extends JPopupMenu {
        private static final long serialVersionUID = 7825575947035545853L;
        private JCheckBoxMenuItem anchoredCheckBox;

        private ShapeObjectPopupMenu() {
        }

        void init(ShapeObject shapeObject) {
            this.setBounds(0, 0, 100, 100);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("  -- Shape: ");
            stringBuffer.append(shapeObject.getID());
            stringBuffer.append(" --");
            this.add(new JLabel(stringBuffer.toString()));
            this.addSeparator();
            SGUtility.addItem(this, shapeObject, "Bring to Front");
            SGUtility.addItem(this, shapeObject, "Bring Forward");
            SGUtility.addItem(this, shapeObject, "Send Backward");
            SGUtility.addItem(this, shapeObject, "Send to Back");
            this.addSeparator();
            SGUtility.addItem(this, shapeObject, "Cut");
            SGUtility.addItem(this, shapeObject, "Copy");
            SGUtility.addItem(this, shapeObject, "Paste");
            this.addSeparator();
            SGUtility.addItem(this, shapeObject, "Delete");
            SGUtility.addItem(this, shapeObject, "Duplicate");
            this.addSeparator();
            this.anchoredCheckBox = new JCheckBoxMenuItem("Anchored");
            this.add(this.anchoredCheckBox);
            this.anchoredCheckBox.addActionListener(shapeObject);
            this.addSeparator();
            SGUtility.addItem(this, shapeObject, "Property");
        }

        void setAnchored(boolean bl) {
            this.anchoredCheckBox.setSelected(bl);
        }
    }

    private static interface PropertyWithAxes {
        public int getXAxisLocation();

        public int getYAxisLocation();
    }

    private static interface IElement
    extends SGINode,
    SGIPropertyDialogObserver,
    SGIDisposable,
    SGIAnchored {
        public void setShapeObject(ShapeObject var1);

        public Object copy();

        public void translate(float var1, float var2);

        public SGProperties getMement();

        public boolean setMagnification(float var1);

        public boolean setMement(SGProperties var1);

        public String getName();

        public String getClassDescription();

        public String getInstanceDescription();

        public boolean setAxisValuesWithShape();

        public boolean setShapeWithAxesValues();

        public List getAnchorPointList();

        public int getMouseLocation(int var1, int var2);

        public boolean drag(MouseEvent var1, Point var2, int var3);

        public boolean writeProperty(Element var1);

        public boolean readProperty(Element var1);

        public SGPropertyResults setProperties(SGPropertyMap var1, SGPropertyResults var2);
    }

    private static class ShapeElementProperties
    extends SGProperties {
        ArrayList visibleShapeList = new ArrayList();

        public void dispose() {
            super.dispose();
            this.visibleShapeList.clear();
            this.visibleShapeList = null;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ShapeElementProperties)) {
                return false;
            }
            ShapeElementProperties shapeElementProperties = (ShapeElementProperties)object;
            return shapeElementProperties.visibleShapeList.equals(this.visibleShapeList);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('[');
            stringBuffer.append(this.visibleShapeList.toString());
            stringBuffer.append(']');
            return stringBuffer.toString();
        }
    }
}

