/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGIChildObject;
import jp.riken.brain.ni.samuraigraph.base.SGICopiable;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementAxis;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementAxisBreak;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementGraph;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementGrid;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementLegend;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementShape;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementSignificantDifference;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementString;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementTimingLine;
import jp.riken.brain.ni.samuraigraph.base.SGINode;
import jp.riken.brain.ni.samuraigraph.base.SGISelectable;
import jp.riken.brain.ni.samuraigraph.base.SGIUndoable;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyMap;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyResults;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUndoManager;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementString;
import jp.riken.brain.ni.samuraigraph.figure.SGFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.SGIStringConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementString2DExtended;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGFigureElement2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGILabelDialogObserver;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGStringElementDialog;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityForFigureElementJava2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGFigureElementString
extends SGFigureElement2D
implements SGIFigureElementString,
SGIStringConstants,
CaretListener,
DocumentListener,
ActionListener,
KeyListener {
    private SGIFigureElementAxis mAxisElement = null;
    private LabelElement mEditedLabelElement = null;
    private Point mTempPoint = new Point();
    private JTextField mEditField = null;
    private static final int BOUNDARY_LINE_WIDTH = 6;
    private SGPropertyDialog mPropertyDialog = null;

    public SGFigureElementString() {
        this.initEditField();
    }

    private boolean initEditField() {
        JTextField jTextField = this.mEditField = new JTextField(10);
        jTextField.setVisible(false);
        jTextField.addActionListener(this);
        jTextField.addCaretListener(this);
        jTextField.getDocument().addDocumentListener(this);
        jTextField.addKeyListener(this);
        return true;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.mPropertyDialog != null) {
            this.mPropertyDialog.dispose();
            this.mPropertyDialog = null;
        }
        this.mAxisElement = null;
    }

    @Override
    public String getClassDescription() {
        return "Labels";
    }

    @Override
    public void setComponent(JComponent jComponent) {
        super.setComponent(jComponent);
        jComponent.add(this.mEditField);
    }

    @Override
    public void setAxisElement(SGIFigureElementAxis sGIFigureElementAxis) {
        this.mAxisElement = sGIFigureElementAxis;
    }

    @Override
    public boolean addString(int n, int n2) {
        if (!this.getGraphRect().contains(n, n2)) {
            return false;
        }
        this.clearFocusedObjects();
        this.mTempPoint = new Point(n, n2);
        JTextField jTextField = this.mEditField;
        float f = 16.0f * this.mMagnification;
        Font font = new Font("Serif", 0, (int)f);
        jTextField.setFont(font);
        Rectangle2D rectangle2D = font.getStringBounds("   ", new FontRenderContext(null, false, false));
        int n3 = n - this.mEditField.getInsets().left;
        int n4 = n2 - (int)(f / 2.0f);
        int n5 = (int)(rectangle2D.getWidth() + (double)f);
        int n6 = (int)(rectangle2D.getHeight() + (double)f);
        jTextField.setLocation(n3, n4);
        jTextField.setSize(n5, n6);
        jTextField.setText("");
        jTextField.setVisible(true);
        jTextField.requestFocus();
        this.repaint();
        return true;
    }

    @Override
    public int addNewString(String string, int n, int n2) {
        SGAxis sGAxis = this.mAxisElement.getAxis("Bottom");
        SGAxis sGAxis2 = this.mAxisElement.getAxis("Left");
        int n3 = this.assignChildId();
        if (!this.addString(n3, string, n, n2, sGAxis, sGAxis2)) {
            return -1;
        }
        return n3;
    }

    private boolean addString(int n, String string, float f, float f2, SGAxis sGAxis, SGAxis sGAxis2) {
        LabelElement labelElement = new LabelElement(string);
        labelElement.setMagnification(this.mMagnification);
        labelElement.mXAxis = sGAxis;
        labelElement.mYAxis = sGAxis2;
        labelElement.setLocation(f, f2);
        if (!this.addToList(n, labelElement)) {
            return false;
        }
        labelElement.initPropertiesHistory();
        this.setChanged(true);
        return true;
    }

    @Override
    public boolean addString(int n, String string, double d, double d2) {
        return this.addString(n, string, d, d2, "Bottom", "Left");
    }

    @Override
    public boolean addString(int n, String string, double d, double d2, String string2, String string3) {
        float f;
        if (!SGUtilityText.isValidString(string)) {
            return false;
        }
        String string4 = string2 != null ? string2 : "Bottom";
        String string5 = string3 != null ? string3 : "Left";
        SGAxis sGAxis = this.mAxisElement.getAxis(string4);
        SGAxis sGAxis2 = this.mAxisElement.getAxis(string5);
        if (sGAxis == null || sGAxis2 == null) {
            return false;
        }
        if (!sGAxis.isValidValue(d)) {
            return false;
        }
        if (!sGAxis2.isValidValue(d2)) {
            return false;
        }
        float f2 = this.calcLocation(d, sGAxis, true);
        if (!this.addString(n, string, f2, f = this.calcLocation(d2, sGAxis2, false), sGAxis, sGAxis2)) {
            return false;
        }
        this.notifyToRoot();
        this.repaint();
        return true;
    }

    @Override
    public String getString(int n) {
        SGIChildObject sGIChildObject = this.getVisibleChild(n);
        if (sGIChildObject instanceof LabelElement) {
            return ((LabelElement)sGIChildObject).getString();
        }
        return null;
    }

    @Override
    public boolean setString(int n, String string) {
        SGIChildObject sGIChildObject = this.getVisibleChild(n);
        if (sGIChildObject instanceof LabelElement) {
            LabelElement labelElement = (LabelElement)sGIChildObject;
            if (labelElement.getString().equals(string)) {
                return false;
            }
            if (!labelElement.setString(string)) {
                return false;
            }
            labelElement.setChanged(true);
            this.repaint();
            return true;
        }
        return false;
    }

    @Override
    public void setVisible(int n, boolean bl) {
        SGIChildObject sGIChildObject = this.getVisibleChild(n);
        if (null != sGIChildObject) {
            sGIChildObject.setVisible(bl);
        }
    }

    @Override
    public void paintGraphics(Graphics graphics, boolean bl) {
        JTextField jTextField;
        Object object;
        LabelElement labelElement;
        int n;
        Graphics2D graphics2D = (Graphics2D)graphics;
        List<SGIChildObject> list = this.getVisibleChildList();
        for (n = 0; n < list.size(); ++n) {
            labelElement = (LabelElement)list.get(n);
            labelElement.paint(graphics2D);
        }
        if (this.mSymbolsVisibleFlagAroundAllObjects) {
            for (n = 0; n < list.size(); ++n) {
                labelElement = (LabelElement)list.get(n);
                object = labelElement.getAnchorPointList();
                SGUtilityForFigureElementJava2D.drawAnchorAsChildObject((List)object, graphics2D);
            }
        }
        if (this.mSymbolsVisibleFlagAroundFocusedObjects) {
            ArrayList<SGISelectable> arrayList = new ArrayList<SGISelectable>();
            this.getFocusedObjectsList(arrayList);
            for (int i = 0; i < arrayList.size(); ++i) {
                object = (LabelElement)arrayList.get(i);
                ArrayList arrayList2 = ((LabelElement)object).getAnchorPointList();
                SGUtilityForFigureElementJava2D.drawAnchorAsFocusedObject(arrayList2, graphics2D);
            }
        }
        if ((jTextField = this.mEditField).isVisible()) {
            graphics2D.setPaint(Color.GRAY);
            graphics2D.setStroke(new BasicStroke(6.0f));
            graphics2D.draw(jTextField.getBounds());
            graphics2D.setStroke(new BasicStroke(2.0f));
            jTextField.repaint();
        }
    }

    @Override
    public boolean synchronize(SGIFigureElement sGIFigureElement, String string) {
        boolean bl = true;
        if (sGIFigureElement instanceof SGIFigureElementGraph) {
            if ("Data objects will be hidden".equals(string)) {
                SGIFigureElementGraph sGIFigureElementGraph = (SGIFigureElementGraph)sGIFigureElement;
                sGIFigureElementGraph.hideNetCDFLabelsOfFocusedObjects(this);
            }
        } else if (!(sGIFigureElement instanceof SGIFigureElementString) && !(sGIFigureElement instanceof SGIFigureElementLegend)) {
            if (sGIFigureElement instanceof SGIFigureElementAxis) {
                SGIFigureElementAxis sGIFigureElementAxis = (SGIFigureElementAxis)sGIFigureElement;
                bl = this.synchronizedToAxisElement(sGIFigureElementAxis, string);
            } else if (!(sGIFigureElement instanceof SGIFigureElementAxisBreak || sGIFigureElement instanceof SGIFigureElementSignificantDifference || sGIFigureElement instanceof SGIFigureElementTimingLine || sGIFigureElement instanceof SGIFigureElementGrid || sGIFigureElement instanceof SGIFigureElementShape)) {
                bl = sGIFigureElement.synchronizeArgument(this, string);
            }
        }
        return bl;
    }

    @Override
    public boolean hideSelectedObjects() {
        this.notifyToListener("Data label will be hidden");
        return super.hideSelectedObjects();
    }

    private boolean synchronizedToAxisElement(SGIFigureElementAxis sGIFigureElementAxis, String string) {
        return true;
    }

    @Override
    public boolean synchronizeArgument(SGIFigureElement sGIFigureElement, String string) {
        throw new Error();
    }

    @Override
    public boolean setMagnification(float f) {
        if (!this.closeTextField()) {
            return false;
        }
        return super.setMagnification(f);
    }

    @Override
    public boolean setGraphRect(float f, float f2, float f3, float f4) {
        if (!super.setGraphRect(f, f2, f3, f4)) {
            return false;
        }
        if (this.mEditField.isVisible() && !this.closeTextField()) {
            return false;
        }
        List list = this.mChildList;
        for (int i = 0; i < list.size(); ++i) {
            LabelElement labelElement = (LabelElement)list.get(i);
            labelElement.requestUpdateLocation();
        }
        return true;
    }

    @Override
    public boolean getMarginAroundGraphRect(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        Object object;
        if (!super.getMarginAroundGraphRect(sGTuple2f, sGTuple2f2)) {
            return false;
        }
        Rectangle2D rectangle2D = this.getGraphRect();
        List<SGIChildObject> list = this.getVisibleChildList();
        ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
        for (int i = 0; i < list.size(); ++i) {
            object = (LabelElement)list.get(i);
            arrayList.add(((SGDrawingElementString2DExtended)object).getElementBounds());
        }
        if (arrayList.size() == 0) {
            return true;
        }
        Rectangle2D rectangle2D2 = SGUtility.createUnion(arrayList);
        object = new ArrayList();
        ((ArrayList)object).add(rectangle2D);
        ((ArrayList)object).add(rectangle2D2);
        Rectangle2D rectangle2D3 = SGUtility.createUnion((ArrayList)object);
        float f = (float)(rectangle2D.getY() - rectangle2D3.getY());
        float f2 = (float)(rectangle2D3.getY() + rectangle2D3.getHeight() - (rectangle2D.getY() + rectangle2D.getHeight()));
        float f3 = (float)(rectangle2D.getX() - rectangle2D3.getX());
        float f4 = (float)(rectangle2D3.getX() + rectangle2D3.getWidth() - (rectangle2D.getX() + rectangle2D.getWidth()));
        sGTuple2f.x += f;
        sGTuple2f.y += f2;
        sGTuple2f2.x += f3;
        sGTuple2f2.y += f4;
        return true;
    }

    @Override
    public boolean onMouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = mouseEvent.getModifiers();
        int n4 = mouseEvent.getClickCount();
        boolean bl = this.onEdge(n, n2);
        boolean bl2 = (n3 & 2) != 0;
        boolean bl3 = (n3 & 1) != 0;
        List<SGIChildObject> list = this.getVisibleChildList();
        for (int i = list.size() - 1; i >= 0; --i) {
            LabelElement labelElement = (LabelElement)list.get(i);
            if (bl && labelElement.equals(this.mEditedLabelElement)) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && n4 == 2) {
                    this.setPropertiesOfSelectedObjects();
                    this.hideEditField();
                    this.mEditedLabelElement = null;
                }
                return true;
            }
            if (!labelElement.contains(n, n2)) continue;
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                if (n4 == 1) {
                    if (labelElement.isSelected() && !bl2 && !bl3) {
                        this.mEditedLabelElement = labelElement;
                        this.mTempPoint = new Point((int)labelElement.getX(), (int)labelElement.getY());
                        int n5 = this.mPressedPoint.x - this.mTempPoint.x;
                        int n6 = this.mPressedPoint.y - this.mTempPoint.y;
                        this.showEditField(this.mEditField, labelElement, n5, n6);
                    } else {
                        this.updateFocusedObjectsList((SGISelectable)labelElement, mouseEvent);
                    }
                }
            } else if (SwingUtilities.isRightMouseButton(mouseEvent) && n4 == 1) {
                this.updateFocusedObjectsList((SGISelectable)labelElement, mouseEvent);
                labelElement.getPopupMenu().show(this.getComponent(), n, n2);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean closeTextField() {
        return !(this.mEditedLabelElement == null ? !this.addStringElementFromTextField() : !this.commitEdit());
    }

    private boolean commitEdit() {
        String string = this.mEditedLabelElement.getString();
        String string2 = this.mEditField.getText();
        if (SGUtilityText.isValidString(string2)) {
            this.mEditedLabelElement.setString(string2);
            if (!string.equals(string2)) {
                this.mEditedLabelElement.setChanged(true);
                this.notifyToRoot();
            }
        }
        this.mEditedLabelElement = null;
        this.hideEditField();
        this.repaint();
        return true;
    }

    private boolean hideEditField() {
        this.mEditField.setText("");
        this.mEditField.setVisible(false);
        return true;
    }

    @Override
    public boolean onMousePressed(MouseEvent mouseEvent) {
        int n;
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        ArrayList arrayList = this.getFocusedObjectsList();
        List<SGIChildObject> list = this.getVisibleChildList();
        boolean bl = false;
        for (n = list.size() - 1; n >= 0; --n) {
            LabelElement labelElement = (LabelElement)list.get(n);
            if (!labelElement.contains(n2, n3)) continue;
            if (arrayList.contains(labelElement)) {
                this.mPressedPoint = mouseEvent.getPoint();
                labelElement.mTemporaryProperties = labelElement.getProperties();
                this.mDraggableFlag = true;
            }
            bl = true;
            break;
        }
        if (bl) {
            this.setMouseCursor(13);
        } else {
            n = this.onEdge(n2, n3) ? 1 : 0;
            if (this.mEditedLabelElement != null && n != 0) {
                bl = true;
            } else if (this.mEditField.isVisible()) {
                this.closeTextField();
            }
        }
        return bl;
    }

    @Override
    public boolean onMouseDragged(MouseEvent mouseEvent) {
        if (this.mPressedPoint == null) {
            return false;
        }
        if (!this.mDraggableFlag) {
            return false;
        }
        this.hideEditField();
        int n = mouseEvent.getX() - this.mPressedPoint.x;
        int n2 = mouseEvent.getY() - this.mPressedPoint.y;
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            LabelElement labelElement = (LabelElement)arrayList.get(i);
            labelElement.translate(n, n2);
        }
        this.mPressedPoint = mouseEvent.getPoint();
        return true;
    }

    @Override
    public boolean onMouseReleased(MouseEvent mouseEvent) {
        ArrayList arrayList = this.getFocusedObjectsList();
        boolean bl = false;
        for (int i = 0; i < arrayList.size(); ++i) {
            LabelElement labelElement = (LabelElement)arrayList.get(i);
            Rectangle2D rectangle2D = labelElement.getElementBounds();
            bl |= rectangle2D.contains(mouseEvent.getPoint());
        }
        if (bl) {
            this.setMouseCursor(12);
        } else {
            this.setMouseCursor(0);
        }
        this.mDraggableFlag = false;
        return true;
    }

    @Override
    public boolean setTemporaryPropertiesOfFocusedObjects() {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            LabelElement labelElement = (LabelElement)arrayList.get(i);
            labelElement.mTemporaryProperties = labelElement.getProperties();
        }
        return true;
    }

    @Override
    public boolean setChangedFocusedObjects() {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGProperties sGProperties;
            LabelElement labelElement = (LabelElement)arrayList.get(i);
            SGProperties sGProperties2 = labelElement.mTemporaryProperties;
            if (sGProperties2 == null || (sGProperties = labelElement.getProperties()).equals(sGProperties2)) continue;
            labelElement.setChanged(true);
        }
        return true;
    }

    public boolean onEdge(int n, int n2) {
        if (!this.mEditField.isVisible()) {
            return false;
        }
        Rectangle rectangle = this.mEditField.getBounds();
        int n3 = rectangle.x - 6;
        int n4 = rectangle.y - 6;
        int n5 = rectangle.width + 12;
        int n6 = rectangle.height + 12;
        Rectangle rectangle2 = new Rectangle(n3, n4, n5, n6);
        boolean bl = rectangle.contains(n, n2);
        boolean bl2 = rectangle2.contains(n, n2);
        boolean bl3 = !bl && bl2;
        return bl3;
    }

    @Override
    public boolean onDrawingElement(int n, int n2) {
        List<SGIChildObject> list = this.getVisibleChildList();
        for (int i = list.size() - 1; i >= 0; --i) {
            LabelElement labelElement = (LabelElement)list.get(i);
            boolean bl = labelElement.contains(n, n2);
            if (!bl) continue;
            this.setMouseCursor(12);
            return true;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.mEditField)) {
            this.closeTextField();
        }
    }

    private boolean addStringElementFromTextField() {
        String string = this.mEditField.getText();
        if (SGUtilityText.isValidString(string) && this.addNewString(string, this.mTempPoint.x, this.mTempPoint.y) < 0) {
            return false;
        }
        this.notifyToRoot();
        this.hideEditField();
        this.repaint();
        return true;
    }

    @Override
    public String getTagName() {
        return "Labels";
    }

    @Override
    public Element[] createElement(Document document) {
        Element element = this.createThisElement(document);
        if (element == null) {
            return null;
        }
        List<SGIChildObject> list = this.getVisibleChildList();
        for (int i = 0; i < list.size(); ++i) {
            LabelElement labelElement = (LabelElement)list.get(i);
            Element element2 = labelElement.createElement(document);
            if (element2 == null) {
                return null;
            }
            element.appendChild(element2);
        }
        return new Element[]{element};
    }

    @Override
    public boolean writeProperty(Element element) {
        return true;
    }

    @Override
    public boolean readProperty(Element element) {
        NodeList nodeList = element.getElementsByTagName("Label");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            LabelElement labelElement = new LabelElement();
            Element element2 = (Element)node;
            if (!labelElement.readProperty(element2)) {
                return false;
            }
            labelElement.initPropertiesHistory();
            this.addToList(labelElement);
        }
        return true;
    }

    @Override
    public boolean setMementoBackward() {
        boolean bl = super.setMementoBackward();
        if (!bl) {
            return false;
        }
        this.clearFocusedObjects();
        this.notifyChangeOnUndo();
        return true;
    }

    @Override
    public boolean setMementoForward() {
        boolean bl = super.setMementoForward();
        if (!bl) {
            return false;
        }
        this.clearFocusedObjects();
        this.notifyChangeOnUndo();
        return true;
    }

    @Override
    public boolean duplicateFocusedObjects() {
        int n = (int)(this.mMagnification * 10.0f);
        int n2 = (int)(this.mMagnification * 10.0f);
        List<SGICopiable> list = this.duplicateObjects();
        for (int i = 0; i < list.size(); ++i) {
            LabelElement labelElement = (LabelElement)list.get(i);
            labelElement.translate(n, n2);
            labelElement.setSelected(true);
            this.addToList(labelElement);
            labelElement.initPropertiesHistory();
        }
        if (list.size() != 0) {
            this.setChanged(true);
        }
        return true;
    }

    @Override
    public boolean paste(List<SGICopiable> list) {
        float f = this.getMagnification();
        int n = (int)(f * 10.0f);
        int n2 = (int)(f * 10.0f);
        int n3 = 0;
        for (int i = 0; i < list.size(); ++i) {
            SGICopiable sGICopiable = list.get(i);
            if (!(sGICopiable instanceof LabelElement)) continue;
            LabelElement labelElement = (LabelElement)sGICopiable;
            labelElement.translate(n, n2);
            SGProperties sGProperties = labelElement.getProperties();
            LabelElement labelElement2 = new LabelElement();
            labelElement2.setMagnification(f);
            labelElement2.setProperties(sGProperties);
            labelElement2.mXAxis = this.mAxisElement.getAxisInPlane(labelElement.mTempXAxis);
            labelElement2.mYAxis = this.mAxisElement.getAxisInPlane(labelElement.mTempYAxis);
            this.addToList(labelElement2);
            labelElement2.initPropertiesHistory();
            ++n3;
        }
        if (n3 != 0) {
            this.setChanged(true);
        }
        return true;
    }

    @Override
    public ArrayList getPropertyDialogObserverList() {
        return this.getFocusedObjectsList();
    }

    @Override
    protected Set getAvailableChildSet() {
        HashSet hashSet = new HashSet();
        List list = this.getMementoList();
        for (int i = 0; i < list.size(); ++i) {
            StringElementProperties stringElementProperties = (StringElementProperties)list.get(i);
            hashSet.addAll(stringElementProperties.visibleStringElementList);
        }
        return hashSet;
    }

    @Override
    public SGProperties getProperties() {
        StringElementProperties stringElementProperties = new StringElementProperties();
        stringElementProperties.visibleStringElementList = new ArrayList<SGIChildObject>(this.getVisibleChildList());
        return stringElementProperties;
    }

    @Override
    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof StringElementProperties)) {
            return false;
        }
        StringElementProperties stringElementProperties = (StringElementProperties)sGProperties;
        this.setVisibleChildList(stringElementProperties.visibleStringElementList);
        return true;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        char c = keyEvent.getKeyChar();
        if (object.equals(this.mEditField) && c == '\u001b') {
            this.hideEditField();
            this.mEditedLabelElement = null;
            this.repaint();
        }
    }

    @Override
    public boolean setDialogOwner(Frame frame) {
        if (!super.setDialogOwner(frame)) {
            return false;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (SGFigureElementString.this.mPropertyDialog == null) {
                    SGFigureElementString.this.mPropertyDialog = new SGStringElementDialog(SGFigureElementString.this.mDialogOwner, true);
                }
            }
        });
        return true;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateLabelTextField();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateLabelTextField();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateLabelTextField();
    }

    private void updateLabelTextField() {
        Font font = null;
        if (this.mEditedLabelElement != null) {
            LabelElement labelElement = this.mEditedLabelElement;
            float f = labelElement.getFontSize();
            font = new Font(labelElement.getFontName(), labelElement.getFontStyle(), (int)(labelElement.getMagnification() * f));
        } else {
            font = new Font("Serif", 0, (int)(this.mMagnification * 16.0f));
        }
        this.updateTextField(this.mEditField, font);
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
    }

    @Override
    public void onMenuSelected() {
        if (this.mEditField.isVisible()) {
            this.closeTextField();
        }
    }

    @Override
    public SGPropertyResults setChildProperties(int n, SGPropertyMap sGPropertyMap) {
        Object object;
        SGIChildObject sGIChildObject = this.getVisibleChild(n);
        if (sGIChildObject == null) {
            Object object2;
            Object object3;
            object = null;
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            Iterator<String> iterator = sGPropertyMap.getKeyIterator();
            while (iterator.hasNext()) {
                object3 = iterator.next();
                object2 = object3.toString();
                if ("Text".equalsIgnoreCase((String)object2)) {
                    object = sGPropertyMap.getValueString((String)object2);
                    continue;
                }
                if ("X".equalsIgnoreCase((String)object2)) {
                    string = sGPropertyMap.getValueString((String)object2);
                    continue;
                }
                if ("Y".equalsIgnoreCase((String)object2)) {
                    string2 = sGPropertyMap.getValueString((String)object2);
                    continue;
                }
                if ("AxisX".equalsIgnoreCase((String)object2)) {
                    string3 = sGPropertyMap.getValueString((String)object2);
                    continue;
                }
                if (!"AxisY".equalsIgnoreCase((String)object2)) continue;
                string4 = sGPropertyMap.getValueString((String)object2);
            }
            if (object == null) {
                return null;
            }
            if (string == null) {
                return null;
            }
            if (string2 == null) {
                return null;
            }
            object3 = SGUtilityText.getDouble(string);
            object2 = SGUtilityText.getDouble(string2);
            if (object3 == null) {
                return null;
            }
            if (object2 == null) {
                return null;
            }
            if (!SGUtility.isValidPropertyValue((Double)object3)) {
                return null;
            }
            if (!SGUtility.isValidPropertyValue((Double)object2)) {
                return null;
            }
            if (!sGPropertyMap.isDoubleQuoted("Text")) {
                return null;
            }
            if (!this.addString(n, (String)object, (Double)object3, (Double)object2, string3, string4)) {
                return null;
            }
            sGIChildObject = this.getVisibleChild(n);
        }
        object = sGIChildObject.setProperties(sGPropertyMap);
        return object;
    }

    public static class StringElementProperties
    extends SGProperties {
        ArrayList visibleStringElementList = new ArrayList();

        public void dispose() {
            super.dispose();
            this.visibleStringElementList.clear();
            this.visibleStringElementList = null;
        }

        public boolean equals(Object object) {
            if (!(object instanceof StringElementProperties)) {
                return false;
            }
            StringElementProperties stringElementProperties = (StringElementProperties)object;
            return stringElementProperties.visibleStringElementList.equals(this.visibleStringElementList);
        }
    }

    public static class LabelProperties
    extends SGDrawingElementString.StringProperties {
        private float mX = 0.0f;
        private float mY = 0.0f;
        private String mText = null;
        private SGAxis mXAxis = null;
        private SGAxis mYAxis = null;

        public boolean equals(Object object) {
            if (!(object instanceof LabelProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            LabelProperties labelProperties = (LabelProperties)object;
            if (this.mX != labelProperties.mX) {
                return false;
            }
            if (this.mY != labelProperties.mY) {
                return false;
            }
            if (!SGUtility.equals(this.mText, labelProperties.mText)) {
                return false;
            }
            if (!SGUtility.equals(this.mXAxis, labelProperties.mXAxis)) {
                return false;
            }
            return SGUtility.equals(this.mYAxis, labelProperties.mYAxis);
        }

        public Float getX() {
            return Float.valueOf(this.mX);
        }

        public Float getY() {
            return Float.valueOf(this.mY);
        }

        public String getText() {
            return this.mText;
        }

        public SGAxis getXAxis() {
            return this.mXAxis;
        }

        public SGAxis getYAxis() {
            return this.mYAxis;
        }

        public void setX(float f) {
            this.mX = f;
        }

        public void setY(float f) {
            this.mY = f;
        }

        public void setText(String string) {
            this.mText = string;
        }

        public void setXAxis(SGAxis sGAxis) {
            this.mXAxis = sGAxis;
        }

        public void setYAxis(SGAxis sGAxis) {
            this.mYAxis = sGAxis;
        }
    }

    private class LabelElement
    extends SGDrawingElementString2DExtended
    implements ActionListener,
    SGIUndoable,
    SGFigureElement.IMovableChild,
    SGICopiable,
    SGILabelDialogObserver,
    SGINode {
        private int mID;
        private boolean mSelectedFlag;
        private SGAxis mXAxis;
        private SGAxis mYAxis;
        private JPopupMenu mPopupMenu;
        private SGProperties mTemporaryProperties;
        private int mTempXAxis;
        private int mTempYAxis;
        private SGUndoManager mUndoManager;

        public int getID() {
            return this.mID;
        }

        public boolean setID(int n) {
            this.mID = n;
            return true;
        }

        public void dispose() {
            super.dispose();
            this.mPopupMenu = null;
            if (this.mTemporaryProperties != null) {
                this.mTemporaryProperties.dispose();
                this.mTemporaryProperties = null;
            }
            this.mUndoManager.dispose();
            this.mUndoManager = null;
            this.mXAxis = null;
            this.mYAxis = null;
        }

        public boolean isSelected() {
            return this.mSelectedFlag;
        }

        public void setSelected(boolean bl) {
            this.mSelectedFlag = bl;
        }

        LabelElement() {
            this.mSelectedFlag = false;
            this.mXAxis = null;
            this.mYAxis = null;
            this.mPopupMenu = null;
            this.mTemporaryProperties = null;
            this.mTempXAxis = -1;
            this.mTempYAxis = -1;
            this.mUndoManager = new SGUndoManager(this);
            this.init();
        }

        LabelElement(String string) {
            super(string);
            this.mSelectedFlag = false;
            this.mXAxis = null;
            this.mYAxis = null;
            this.mPopupMenu = null;
            this.mTemporaryProperties = null;
            this.mTempXAxis = -1;
            this.mTempYAxis = -1;
            this.mUndoManager = new SGUndoManager(this);
            this.init();
        }

        private boolean init() {
            this.setFontSize(16.0f, "pt");
            this.setFontName("Serif");
            this.setFontStyle(0);
            this.setAngle(0.0f);
            this.setColor(DEFAULT_LABEL_FONT_COLOR);
            return true;
        }

        public String getClassDescription() {
            return "";
        }

        public String getInstanceDescription() {
            String string = SGFigureElementString.this.mAxisElement.getLocationName(this.mXAxis);
            String string2 = SGFigureElementString.this.mAxisElement.getLocationName(this.mYAxis);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.mID);
            stringBuffer.append(": ");
            stringBuffer.append(SGUtility.removeEscapeChar(this.getString()));
            stringBuffer.append(", AxisX=");
            stringBuffer.append(string.toString());
            stringBuffer.append(", AxisY=");
            stringBuffer.append(string2.toString());
            stringBuffer.append(", X=");
            stringBuffer.append(this.getXValue());
            stringBuffer.append(", Y=");
            stringBuffer.append(this.getYValue());
            return stringBuffer.toString();
        }

        public Object copy() {
            LabelElement labelElement = new LabelElement();
            labelElement.setMagnification(this.getMagnification());
            labelElement.setProperties(this.getProperties());
            labelElement.setLocation(this.getX(), this.getY());
            labelElement.mTempXAxis = SGFigureElementString.this.mAxisElement.getLocationInPlane(this.mXAxis);
            labelElement.mTempYAxis = SGFigureElementString.this.mAxisElement.getLocationInPlane(this.mYAxis);
            return labelElement;
        }

        public double getXValue() {
            SGAxis sGAxis = this.mXAxis;
            double d = SGFigureElementString.this.calcValue(this.getX(), sGAxis, true);
            d = SGFigureElementString.this.getNumberInRangeOrder(d, sGAxis);
            return d;
        }

        public double getYValue() {
            SGAxis sGAxis = this.mYAxis;
            double d = SGFigureElementString.this.calcValue(this.getY(), sGAxis, false);
            d = SGFigureElementString.this.getNumberInRangeOrder(d, sGAxis);
            return d;
        }

        public boolean setXValue(double d) {
            SGAxis sGAxis = this.mXAxis;
            if (!sGAxis.isValidValue(d)) {
                return false;
            }
            double d2 = SGFigureElementString.this.calcValue(this.getX(), sGAxis, true);
            float f = d == (d2 = SGFigureElementString.this.getNumberInRangeOrder(d2, sGAxis)) ? this.getX() : SGFigureElementString.this.calcLocation(d, sGAxis, true);
            return this.setX(f);
        }

        public boolean setYValue(double d) {
            SGAxis sGAxis = this.mYAxis;
            if (!sGAxis.isValidValue(d)) {
                return false;
            }
            double d2 = SGFigureElementString.this.calcValue(this.getY(), sGAxis, false);
            float f = d == (d2 = SGFigureElementString.this.getNumberInRangeOrder(d2, sGAxis)) ? this.getY() : SGFigureElementString.this.calcLocation(d, sGAxis, false);
            return this.setY(f);
        }

        public boolean hasValidXValue(int n, Number number) {
            SGAxis sGAxis = n == -1 ? this.mXAxis : SGFigureElementString.this.mAxisElement.getAxisInPlane(n);
            double d = number != null ? number.doubleValue() : this.getXValue();
            return sGAxis.isValidValue(d);
        }

        public boolean hasValidYValue(int n, Number number) {
            SGAxis sGAxis = n == -1 ? this.mYAxis : SGFigureElementString.this.mAxisElement.getAxisInPlane(n);
            double d = number != null ? number.doubleValue() : this.getYValue();
            return sGAxis.isValidValue(d);
        }

        public int getXAxisLocation() {
            return SGFigureElementString.this.mAxisElement.getLocationInPlane(this.mXAxis);
        }

        public int getYAxisLocation() {
            return SGFigureElementString.this.mAxisElement.getLocationInPlane(this.mYAxis);
        }

        public boolean setXAxisLocation(int n) {
            if (n != 0 && n != 1) {
                return false;
            }
            this.mXAxis = SGFigureElementString.this.mAxisElement.getAxisInPlane(n);
            return true;
        }

        public boolean setYAxisLocation(int n) {
            if (n != 2 && n != 3) {
                return false;
            }
            this.mYAxis = SGFigureElementString.this.mAxisElement.getAxisInPlane(n);
            return true;
        }

        public boolean setString(String string) {
            if (!SGUtilityText.isValidString(string)) {
                return false;
            }
            return super.setString(string);
        }

        public boolean setStringColor(Color color) {
            return this.setColor(color);
        }

        public Color getStringColor() {
            return this.getColor();
        }

        public float getFontSize(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getFontSize(), string);
        }

        public boolean prepare() {
            this.mTemporaryProperties = this.getProperties();
            return true;
        }

        private ArrayList getAnchorPointList() {
            ArrayList<Point2D.Float> arrayList = new ArrayList<Point2D.Float>();
            Rectangle2D rectangle2D = this.getElementBounds();
            float f = (float)rectangle2D.getX();
            float f2 = (float)rectangle2D.getY();
            float f3 = (float)rectangle2D.getWidth();
            float f4 = (float)rectangle2D.getHeight();
            Point2D.Float float_ = new Point2D.Float(f, f2);
            Point2D.Float float_2 = new Point2D.Float(f, f2 + f4);
            Point2D.Float float_3 = new Point2D.Float(f + f3, f2);
            Point2D.Float float_4 = new Point2D.Float(f + f3, f2 + f4);
            arrayList.add(float_);
            arrayList.add(float_2);
            arrayList.add(float_3);
            arrayList.add(float_4);
            return arrayList;
        }

        public JPopupMenu getPopupMenu() {
            JPopupMenu jPopupMenu = null;
            if (this.mPopupMenu != null) {
                jPopupMenu = this.mPopupMenu;
            } else {
                this.mPopupMenu = jPopupMenu = this.createPopupMenu();
            }
            return jPopupMenu;
        }

        private JPopupMenu createPopupMenu() {
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.setBounds(0, 0, 100, 100);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("  -- Label: ");
            stringBuffer.append(this.getID());
            stringBuffer.append(" --");
            jPopupMenu.add(new JLabel(stringBuffer.toString()));
            jPopupMenu.addSeparator();
            SGUtility.addItem(jPopupMenu, this, "Bring to Front");
            SGUtility.addItem(jPopupMenu, this, "Bring Forward");
            SGUtility.addItem(jPopupMenu, this, "Send Backward");
            SGUtility.addItem(jPopupMenu, this, "Send to Back");
            jPopupMenu.addSeparator();
            SGUtility.addItem(jPopupMenu, this, "Cut");
            SGUtility.addItem(jPopupMenu, this, "Copy");
            SGUtility.addItem(jPopupMenu, this, "Paste");
            jPopupMenu.addSeparator();
            SGUtility.addItem(jPopupMenu, this, "Delete");
            SGUtility.addItem(jPopupMenu, this, "Duplicate");
            jPopupMenu.addSeparator();
            SGUtility.addItem(jPopupMenu, this, "Property");
            return jPopupMenu;
        }

        public String getTagName() {
            return "Label";
        }

        public Element createElement(Document document) {
            Element element = document.createElement(this.getTagName());
            if (!this.writeProperty(element)) {
                return null;
            }
            return element;
        }

        public boolean writeProperty(Element element) {
            if (!super.writeProperty(element)) {
                return false;
            }
            element.setAttribute("XAxisPosition", SGFigureElementString.this.mAxisElement.getLocationName(this.mXAxis));
            element.setAttribute("YAxisPosition", SGFigureElementString.this.mAxisElement.getLocationName(this.mYAxis));
            element.setAttribute("XValue", Double.toString(this.getXValue()));
            element.setAttribute("YValue", Double.toString(this.getYValue()));
            return true;
        }

        public boolean readProperty(Element element) {
            SGAxis sGAxis;
            if (!super.readProperty(element)) {
                return false;
            }
            String string = null;
            Double d = null;
            string = element.getAttribute("XAxisPosition");
            if (string.length() != 0) {
                sGAxis = SGFigureElementString.this.mAxisElement.getAxis(string);
                if (sGAxis == null) {
                    return false;
                }
                this.mXAxis = sGAxis;
            }
            if ((string = element.getAttribute("YAxisPosition")).length() != 0) {
                sGAxis = SGFigureElementString.this.mAxisElement.getAxis(string);
                if (sGAxis == null) {
                    return false;
                }
                this.mYAxis = sGAxis;
            }
            if ((string = element.getAttribute("XValue")).length() != 0) {
                d = SGUtilityText.getDouble(string);
                if (d == null) {
                    return false;
                }
                double d2 = d;
                if (!this.mXAxis.isValidValue(d2)) {
                    return false;
                }
                if (!this.setXValue(d2)) {
                    return false;
                }
            }
            if ((string = element.getAttribute("YValue")).length() != 0) {
                d = SGUtilityText.getDouble(string);
                if (d == null) {
                    return false;
                }
                double d3 = d;
                if (!this.mYAxis.isValidValue(d3)) {
                    return false;
                }
                if (!this.setYValue(d3)) {
                    return false;
                }
            }
            return true;
        }

        public boolean setX(float f) {
            return super.setX((f - SGFigureElementString.this.mGraphRectX) / this.getMagnification());
        }

        public boolean setY(float f) {
            return super.setY((f - SGFigureElementString.this.mGraphRectY) / this.getMagnification());
        }

        public float getX() {
            return this.getMagnification() * super.getX() + SGFigureElementString.this.mGraphRectX;
        }

        public float getY() {
            return this.getMagnification() * super.getY() + SGFigureElementString.this.mGraphRectY;
        }

        public SGProperties getProperties() {
            LabelProperties labelProperties = new LabelProperties();
            if (!this.getProperties(labelProperties)) {
                return null;
            }
            return labelProperties;
        }

        public boolean getProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof LabelProperties)) {
                return false;
            }
            if (!super.getProperties(sGProperties)) {
                return false;
            }
            LabelProperties labelProperties = (LabelProperties)sGProperties;
            labelProperties.setX(super.getX());
            labelProperties.setY(super.getY());
            labelProperties.setXAxis(this.mXAxis);
            labelProperties.setYAxis(this.mYAxis);
            labelProperties.setText(this.getString());
            labelProperties.setColor(this.getColor());
            return true;
        }

        public boolean setProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof LabelProperties)) {
                return false;
            }
            if (!super.setProperties(sGProperties)) {
                return false;
            }
            LabelProperties labelProperties = (LabelProperties)sGProperties;
            super.setX(labelProperties.getX().floatValue());
            super.setY(labelProperties.getY().floatValue());
            this.mXAxis = labelProperties.getXAxis();
            this.mYAxis = labelProperties.getYAxis();
            this.setString(labelProperties.getText());
            this.setColor(labelProperties.getColor());
            return true;
        }

        public boolean isChanged() {
            return this.mUndoManager.isChanged();
        }

        public void setChanged(boolean bl) {
            this.mUndoManager.setChanged(bl);
        }

        public boolean isChangedRoot() {
            return this.isChanged();
        }

        public void clearChanged() {
            this.setChanged(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("Property")) {
                SGFigureElementString.this.setPropertiesOfSelectedObjects();
            } else if (string.equals("Copy") || string.equals("Cut") || string.equals("Paste") || string.equals("Delete") || string.equals("Duplicate") || string.equals("Bring to Front") || string.equals("Bring Forward") || string.equals("Send Backward") || string.equals("Send to Back")) {
                SGFigureElementString.this.notifyToListener(string);
            }
        }

        public boolean commit() {
            SGProperties sGProperties = this.mTemporaryProperties;
            SGProperties sGProperties2 = this.getProperties();
            if (!sGProperties.equals(sGProperties2)) {
                this.mUndoManager.setChanged(true);
            }
            SGFigureElementString.this.repaint();
            this.mTemporaryProperties = null;
            SGFigureElementString.this.notifyChange();
            return true;
        }

        public boolean preview() {
            SGFigureElementString.this.repaint();
            SGFigureElementString.this.notifyChange();
            return true;
        }

        public boolean cancel() {
            if (!this.setProperties(this.mTemporaryProperties)) {
                return false;
            }
            this.mTemporaryProperties = null;
            SGFigureElementString.this.repaint();
            SGFigureElementString.this.notifyChange();
            return true;
        }

        public SGPropertyDialog getPropertyDialog() {
            SGPropertyDialog sGPropertyDialog = null;
            if (SGFigureElementString.this.mPropertyDialog != null) {
                sGPropertyDialog = SGFigureElementString.this.mPropertyDialog;
            } else {
                sGPropertyDialog = new SGStringElementDialog(SGFigureElementString.this.mDialogOwner, true);
                SGFigureElementString.this.mPropertyDialog = sGPropertyDialog;
            }
            return sGPropertyDialog;
        }

        public ArrayList getChildNodes() {
            return new ArrayList();
        }

        public SGProperties getMemento() {
            return this.getProperties();
        }

        public boolean setMemento(SGProperties sGProperties) {
            return this.setProperties(sGProperties);
        }

        public boolean isUndoable() {
            return this.mUndoManager.isUndoable();
        }

        public boolean isRedoable() {
            return this.mUndoManager.isRedoable();
        }

        public boolean initPropertiesHistory() {
            return this.mUndoManager.initPropertiesHistory();
        }

        public boolean setMementoBackward() {
            return this.mUndoManager.setMementoBackward();
        }

        public boolean setMementoForward() {
            return this.mUndoManager.setMementoForward();
        }

        public boolean undo() {
            return this.setMementoBackward();
        }

        public boolean redo() {
            return this.setMementoForward();
        }

        public boolean updateHistory() {
            return this.mUndoManager.updateHistory();
        }

        public void initUndoBuffer() {
            this.mUndoManager.initUndoBuffer();
        }

        public boolean deleteForwardHistory() {
            return this.mUndoManager.deleteForwardHistory();
        }

        public void notifyToRoot() {
            SGFigureElementString.this.notifyToRoot();
        }

        public SGPropertyResults setProperties(SGPropertyMap sGPropertyMap) {
            SGPropertyResults sGPropertyResults = new SGPropertyResults();
            if (!this.prepare()) {
                return null;
            }
            Iterator<String> iterator = sGPropertyMap.getKeyIterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                String string2 = sGPropertyMap.getValueString(string);
                if ("AxisX".equalsIgnoreCase(string)) {
                    int n = SGUtility.getAxisLocation(string2);
                    if (n == -1) {
                        sGPropertyResults.putResult("AxisX", 1);
                        continue;
                    }
                    if (!this.setXAxisLocation(n)) {
                        sGPropertyResults.putResult("AxisX", 1);
                        continue;
                    }
                    sGPropertyResults.putResult("AxisX", 0);
                    continue;
                }
                if ("AxisY".equalsIgnoreCase(string)) {
                    int n = SGUtility.getAxisLocation(string2);
                    if (n == -1) {
                        sGPropertyResults.putResult("AxisY", 1);
                        continue;
                    }
                    if (!this.setYAxisLocation(n)) {
                        sGPropertyResults.putResult("AxisY", 1);
                        continue;
                    }
                    sGPropertyResults.putResult("AxisY", 0);
                    continue;
                }
                if ("Text".equalsIgnoreCase(string)) {
                    if (!sGPropertyMap.isDoubleQuoted(string)) {
                        sGPropertyResults.putResult("Text", 1);
                        continue;
                    }
                    if (!this.setString(string2)) {
                        sGPropertyResults.putResult("Text", 1);
                        continue;
                    }
                    sGPropertyResults.putResult("Text", 0);
                    continue;
                }
                if ("X".equalsIgnoreCase(string)) {
                    Double d = SGUtilityText.getDouble(string2);
                    if (d == null) {
                        sGPropertyResults.putResult("X", 1);
                        continue;
                    }
                    if (!SGUtility.isValidPropertyValue(d)) {
                        sGPropertyResults.putResult("X", 1);
                        continue;
                    }
                    if (!this.setXValue(d)) {
                        sGPropertyResults.putResult("X", 1);
                        continue;
                    }
                    sGPropertyResults.putResult("X", 0);
                    continue;
                }
                if ("Y".equalsIgnoreCase(string)) {
                    Double d = SGUtilityText.getDouble(string2);
                    if (d == null) {
                        sGPropertyResults.putResult("Y", 1);
                        continue;
                    }
                    if (!SGUtility.isValidPropertyValue(d)) {
                        sGPropertyResults.putResult("Y", 1);
                        continue;
                    }
                    if (!this.setYValue(d)) {
                        sGPropertyResults.putResult("Y", 1);
                        continue;
                    }
                    sGPropertyResults.putResult("Y", 0);
                    continue;
                }
                if ("FontName".equalsIgnoreCase(string)) {
                    String string3 = SGUtility.findFontFamilyName(string2);
                    if (string3 == null) {
                        sGPropertyResults.putResult("FontName", 1);
                        continue;
                    }
                    if (!this.setFontName(string3)) {
                        sGPropertyResults.putResult("FontName", 1);
                        continue;
                    }
                    sGPropertyResults.putResult("FontName", 0);
                    continue;
                }
                if ("FontStyle".equalsIgnoreCase(string)) {
                    Integer n = SGUtilityText.getFontStyle(string2);
                    if (n == null) {
                        sGPropertyResults.putResult("FontStyle", 1);
                        continue;
                    }
                    if (!this.setFontStyle(n)) {
                        sGPropertyResults.putResult("FontStyle", 1);
                        continue;
                    }
                    sGPropertyResults.putResult("FontStyle", 0);
                    continue;
                }
                if ("FontSize".equalsIgnoreCase(string)) {
                    StringBuffer stringBuffer = new StringBuffer();
                    Number number = SGUtilityText.getNumber(string2, stringBuffer);
                    if (number == null) {
                        sGPropertyResults.putResult("FontSize", 1);
                        continue;
                    }
                    if (!this.setFontSize(number.floatValue(), stringBuffer.toString())) {
                        sGPropertyResults.putResult("FontSize", 1);
                        continue;
                    }
                    sGPropertyResults.putResult("FontSize", 0);
                    continue;
                }
                if ("Color".equalsIgnoreCase(string)) {
                    Color color = SGUtilityText.getColor(string2);
                    if (color != null) {
                        if (!this.setColor(color)) {
                            sGPropertyResults.putResult("Color", 1);
                            continue;
                        }
                    } else {
                        color = SGUtilityText.parseColor(string2);
                        if (color == null) {
                            sGPropertyResults.putResult("Color", 1);
                            continue;
                        }
                        if (!this.setColor(color)) {
                            sGPropertyResults.putResult("Color", 1);
                            continue;
                        }
                    }
                    sGPropertyResults.putResult("Color", 0);
                    continue;
                }
                if (!"Angle".equalsIgnoreCase(string)) continue;
                Float f = SGUtilityText.getFloat(string2);
                if (f == null) {
                    sGPropertyResults.putResult("Angle", 1);
                    continue;
                }
                if (!this.setAngle(((Number)f).floatValue())) {
                    sGPropertyResults.putResult("Angle", 1);
                    continue;
                }
                sGPropertyResults.putResult("Angle", 0);
            }
            if (!this.commit()) {
                return null;
            }
            this.notifyToRoot();
            SGFigureElementString.this.notifyChange();
            SGFigureElementString.this.repaint();
            return sGPropertyResults;
        }
    }
}

