/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import jp.riken.brain.ni.samuraigraph.base.SGButton;
import jp.riken.brain.ni.samuraigraph.base.SGCheckBox;
import jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton;
import jp.riken.brain.ni.samuraigraph.base.SGComboBox;
import jp.riken.brain.ni.samuraigraph.base.SGComponentGroup;
import jp.riken.brain.ni.samuraigraph.base.SGComponentGroupElement;
import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGTextField;
import jp.riken.brain.ni.samuraigraph.base.SGTwoAxesSelectionPanel;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGILegendConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGILegendDialogObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGLegendDialog
extends SGPropertyDialog
implements SGILegendConstants,
SGIDrawingElementConstants {
    private static final long serialVersionUID = -54582360939741917L;
    public static final String TITLE = "Legend Properties";
    private SGTwoAxesSelectionPanel mAxisPanel;
    private SGColorSelectionButton mBackgroundColorButton;
    private JLabel mBackgroundColorLabel;
    private JLabel mBackgroundLabel;
    private JSeparator mBackgroundSeparator;
    private JLabel mBackgroundTransparencyLabel;
    private JPanel mBackgroundTransparencyPanel;
    private SGSpinner mBackgroundTransparencySpinner;
    private SGButton mCancelButton;
    private JSeparator mDataSeparator;
    private JLabel mFontFamilyLabel;
    private SGComboBox mFontNameComboBox;
    private JLabel mFontSizeLabel;
    private SGSpinner mFontSizeSpinner;
    private SGComboBox mFontStyleComboBox;
    private JLabel mFontStyleLabel;
    private JLabel mFrameLabel;
    private SGColorSelectionButton mFrameLineColorButton;
    private JLabel mFrameLineColorLabel;
    private JLabel mFrameLineWidthLabel;
    private SGSpinner mFrameLineWidthSpinner;
    private JSeparator mFrameSeparator;
    private SGCheckBox mFrameVisibleCheckBox;
    private JLabel mLabelSpace1;
    private JLabel mLeftSpaceLabel;
    private JPanel mLegendPanel;
    private SGCheckBox mLegendVisibleCheckBox;
    private JLabel mLocationLabel;
    private JSeparator mLocationSeparator;
    private SGButton mOKButton;
    private SGButton mPreviewButton;
    private JLabel mRightSpaceLabel;
    private JLabel mSpanLabel;
    private SGSpinner mSpanSpinner;
    private SGColorSelectionButton mStringColorButton;
    private JLabel mStringColorLabel;
    private JLabel mStringLabel;
    private JSeparator mStringSeparator;
    private JLabel mSymbolLabel;
    private JLabel mXValueLabel;
    private SGTextField mXValueTextField;
    private JLabel mYValueLabel;
    private SGTextField mYValueTextField;
    private JPanel mlButtonPanel;
    private SGComponentGroup mVisibleComponentGroup = new SGComponentGroup();
    private SGComponentGroup mFrameVisibleComponentGroup = new SGComponentGroup();
    private SGComponentGroup mBackgroundComponentGroup = new SGComponentGroup();

    public SGLegendDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
        this.initialize();
    }

    private void initComponents() {
        this.mLabelSpace1 = new JLabel();
        this.mLegendPanel = new JPanel();
        this.mLegendVisibleCheckBox = new SGCheckBox();
        this.mFrameVisibleCheckBox = new SGCheckBox();
        this.mFrameLabel = new JLabel();
        this.mFrameLineWidthLabel = new JLabel();
        this.mFrameLineColorLabel = new JLabel();
        this.mBackgroundColorLabel = new JLabel();
        this.mFrameLineWidthSpinner = new SGSpinner();
        this.mFrameLineColorButton = new SGColorSelectionButton();
        this.mFrameSeparator = new JSeparator();
        this.mBackgroundColorButton = new SGColorSelectionButton();
        this.mFontFamilyLabel = new JLabel();
        this.mFontSizeLabel = new JLabel();
        this.mStringColorLabel = new JLabel();
        this.mFontNameComboBox = new SGComboBox();
        this.mFontSizeSpinner = new SGSpinner();
        this.mFontStyleComboBox = new SGComboBox();
        this.mStringColorButton = new SGColorSelectionButton();
        this.mStringLabel = new JLabel();
        this.mStringSeparator = new JSeparator();
        this.mLeftSpaceLabel = new JLabel();
        this.mRightSpaceLabel = new JLabel();
        this.mBackgroundLabel = new JLabel();
        this.mLocationLabel = new JLabel();
        this.mBackgroundSeparator = new JSeparator();
        this.mXValueLabel = new JLabel();
        this.mXValueTextField = new SGTextField();
        this.mYValueLabel = new JLabel();
        this.mYValueTextField = new SGTextField();
        this.mFontStyleLabel = new JLabel();
        this.mLocationSeparator = new JSeparator();
        this.mSpanSpinner = new SGSpinner();
        this.mSpanLabel = new JLabel();
        this.mSymbolLabel = new JLabel();
        this.mDataSeparator = new JSeparator();
        this.mBackgroundTransparencyPanel = new JPanel();
        this.mBackgroundTransparencyLabel = new JLabel();
        this.mBackgroundTransparencySpinner = new SGSpinner();
        this.mlButtonPanel = new JPanel();
        this.mOKButton = new SGButton();
        this.mCancelButton = new SGButton();
        this.mPreviewButton = new SGButton();
        this.mAxisPanel = new SGTwoAxesSelectionPanel();
        this.mLabelSpace1.setText("  ");
        this.getContentPane().setLayout(new GridBagLayout());
        this.mLegendPanel.setBorder(BorderFactory.createBevelBorder(0));
        this.mLegendPanel.setFont(new Font("MS Sans Serif", 0, 12));
        this.mLegendPanel.setLayout(new GridBagLayout());
        this.mLegendVisibleCheckBox.setText("Visible");
        this.mLegendVisibleCheckBox.setFont(new Font("Dialog", 0, 12));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mLegendPanel.add((Component)this.mLegendVisibleCheckBox, gridBagConstraints);
        this.mFrameVisibleCheckBox.setText("Visible");
        this.mFrameVisibleCheckBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        this.mLegendPanel.add((Component)this.mFrameVisibleCheckBox, gridBagConstraints);
        this.mFrameLabel.setFont(new Font("Dialog", 3, 12));
        this.mFrameLabel.setText("Frame");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLegendPanel.add((Component)this.mFrameLabel, gridBagConstraints);
        this.mFrameLineWidthLabel.setFont(new Font("Dialog", 0, 12));
        this.mFrameLineWidthLabel.setText("Width");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 10, 5);
        this.mLegendPanel.add((Component)this.mFrameLineWidthLabel, gridBagConstraints);
        this.mFrameLineColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mFrameLineColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 10, 5);
        this.mLegendPanel.add((Component)this.mFrameLineColorLabel, gridBagConstraints);
        this.mBackgroundColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mBackgroundColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 10, 5);
        this.mLegendPanel.add((Component)this.mBackgroundColorLabel, gridBagConstraints);
        this.mFrameLineWidthSpinner.setFont(new Font("Dialog", 0, 12));
        this.mFrameLineWidthSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mLegendPanel.add((Component)this.mFrameLineWidthSpinner, gridBagConstraints);
        this.mFrameLineColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mLegendPanel.add((Component)this.mFrameLineColorButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 50, 5, 5);
        this.mLegendPanel.add((Component)this.mFrameSeparator, gridBagConstraints);
        this.mBackgroundColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mLegendPanel.add((Component)this.mBackgroundColorButton, gridBagConstraints);
        this.mFontFamilyLabel.setFont(new Font("Dialog", 0, 12));
        this.mFontFamilyLabel.setText("Family");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mLegendPanel.add((Component)this.mFontFamilyLabel, gridBagConstraints);
        this.mFontSizeLabel.setFont(new Font("Dialog", 0, 12));
        this.mFontSizeLabel.setText("Size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mLegendPanel.add((Component)this.mFontSizeLabel, gridBagConstraints);
        this.mStringColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mStringColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.mLegendPanel.add((Component)this.mStringColorLabel, gridBagConstraints);
        this.mFontNameComboBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLegendPanel.add((Component)this.mFontNameComboBox, gridBagConstraints);
        this.mFontSizeSpinner.setFont(new Font("Dialog", 0, 12));
        this.mFontSizeSpinner.setMinimumSize(new Dimension(25, 20));
        this.mFontSizeSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLegendPanel.add((Component)this.mFontSizeSpinner, gridBagConstraints);
        this.mFontStyleComboBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLegendPanel.add((Component)this.mFontStyleComboBox, gridBagConstraints);
        this.mStringColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLegendPanel.add((Component)this.mStringColorButton, gridBagConstraints);
        this.mStringLabel.setFont(new Font("Dialog", 3, 12));
        this.mStringLabel.setText("String");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLegendPanel.add((Component)this.mStringLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 45, 5, 5);
        this.mLegendPanel.add((Component)this.mStringSeparator, gridBagConstraints);
        this.mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.mLegendPanel.add((Component)this.mLeftSpaceLabel, gridBagConstraints);
        this.mRightSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        this.mLegendPanel.add((Component)this.mRightSpaceLabel, gridBagConstraints);
        this.mBackgroundLabel.setFont(new Font("Dialog", 3, 12));
        this.mBackgroundLabel.setText("Background");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLegendPanel.add((Component)this.mBackgroundLabel, gridBagConstraints);
        this.mLocationLabel.setFont(new Font("Dialog", 3, 12));
        this.mLocationLabel.setText("Location");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLegendPanel.add((Component)this.mLocationLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 20, 0, 5);
        this.mLegendPanel.add((Component)this.mBackgroundSeparator, gridBagConstraints);
        this.mXValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mXValueLabel.setText("X");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLegendPanel.add((Component)this.mXValueLabel, gridBagConstraints);
        this.mXValueTextField.setColumns(6);
        this.mXValueTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLegendPanel.add((Component)this.mXValueTextField, gridBagConstraints);
        this.mYValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mYValueLabel.setText("Y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLegendPanel.add((Component)this.mYValueLabel, gridBagConstraints);
        this.mYValueTextField.setColumns(6);
        this.mYValueTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLegendPanel.add((Component)this.mYValueTextField, gridBagConstraints);
        this.mFontStyleLabel.setFont(new Font("Dialog", 0, 12));
        this.mFontStyleLabel.setText("Style");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mLegendPanel.add((Component)this.mFontStyleLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.mLegendPanel.add((Component)this.mLocationSeparator, gridBagConstraints);
        this.mSpanSpinner.setFont(new Font("Dialog", 0, 12));
        this.mSpanSpinner.setMinimumSize(new Dimension(25, 20));
        this.mSpanSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mLegendPanel.add((Component)this.mSpanSpinner, gridBagConstraints);
        this.mSpanLabel.setFont(new Font("Dialog", 0, 12));
        this.mSpanLabel.setText("Span");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 10, 5);
        this.mLegendPanel.add((Component)this.mSpanLabel, gridBagConstraints);
        this.mSymbolLabel.setFont(new Font("Dialog", 3, 12));
        this.mSymbolLabel.setText("Symbol ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLegendPanel.add((Component)this.mSymbolLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 60, 5, 5);
        this.mLegendPanel.add((Component)this.mDataSeparator, gridBagConstraints);
        this.mBackgroundTransparencyPanel.setLayout(new GridBagLayout());
        this.mBackgroundTransparencyLabel.setFont(new Font("Dialog", 0, 12));
        this.mBackgroundTransparencyLabel.setText("Transparency");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.mBackgroundTransparencyPanel.add((Component)this.mBackgroundTransparencyLabel, gridBagConstraints);
        this.mBackgroundTransparencySpinner.setFont(new Font("Dialog", 0, 12));
        this.mBackgroundTransparencySpinner.setPreferredSize(new Dimension(60, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.mBackgroundTransparencyPanel.add((Component)this.mBackgroundTransparencySpinner, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mLegendPanel.add((Component)this.mBackgroundTransparencyPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mLegendPanel, gridBagConstraints);
        this.mOKButton.setText("OK");
        this.mOKButton.setFont(new Font("Dialog", 1, 12));
        this.mlButtonPanel.add(this.mOKButton);
        this.mCancelButton.setText("Cancel");
        this.mCancelButton.setFont(new Font("Dialog", 1, 12));
        this.mlButtonPanel.add(this.mCancelButton);
        this.mPreviewButton.setText("Preview");
        this.mPreviewButton.setFont(new Font("Dialog", 1, 12));
        this.mlButtonPanel.add(this.mPreviewButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.mlButtonPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.mAxisPanel, gridBagConstraints);
        this.pack();
    }

    private boolean initProperty() {
        this.setTitle(TITLE);
        String[] stringArray = SGUtility.getAvailableFontFamilyNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.mFontNameComboBox.addItem(stringArray[i]);
        }
        String[] stringArray2 = new String[]{"Plain", "Italic", "Bold", "Bold Italic"};
        for (int i = 0; i < stringArray2.length; ++i) {
            this.mFontStyleComboBox.addItem(stringArray2[i]);
        }
        this.pack();
        this.mFrameLineWidthSpinner.initProperties(SGLegendDialog.getLineWidthSpinnerNumberModel(), "pt", 1, 2);
        this.mFontSizeSpinner.initProperties(SGLegendDialog.getFontSizeSpinnerNumberModel(), "pt", 1, 2);
        this.mSpanSpinner.initProperties(new SpinnerNumberModel(1.0, 0.5, 6.0, 0.1), "cm", 1, 2);
        this.mBackgroundTransparencySpinner.initProperties(new SpinnerNumberModel(100.0, 0.0, 100.0, 1.0), "%", 0, 0);
        this.mLegendVisibleCheckBox.addActionListener(this);
        this.mFrameVisibleCheckBox.addActionListener(this);
        this.mFontNameComboBox.addActionListener(this);
        this.mFontStyleComboBox.addActionListener(this);
        this.mAxisPanel.addActionListener(this);
        this.mBackgroundTransparencySpinner.addChangeListener(this);
        this.mXValueTextField.setDescription("Location-> X");
        this.mYValueTextField.setDescription("Location-> Y");
        this.mFrameLineWidthSpinner.setDescription("Frame-> Width");
        this.mFontSizeSpinner.setDescription("String-> Size");
        this.mSpanSpinner.setDescription("Symbol-> Span");
        this.mBackgroundTransparencySpinner.setDescription("Background-> Transparency");
        SGComponentGroupElement[] sGComponentGroupElementArray = new SGComponentGroupElement[]{new SGComponentGroupElement(this.mFrameLineWidthLabel), new SGComponentGroupElement(this.mFrameLineWidthSpinner), new SGComponentGroupElement(this.mFrameLineColorLabel), new SGComponentGroupElement(this.mFrameLineColorButton)};
        SGComponentGroupElement[] sGComponentGroupElementArray2 = new SGComponentGroupElement[]{new SGComponentGroupElement(this.mBackgroundColorLabel), new SGComponentGroupElement(this.mBackgroundColorButton)};
        SGComponentGroupElement[] sGComponentGroupElementArray3 = new SGComponentGroupElement[]{new SGComponentGroupElement(this.mSpanLabel), new SGComponentGroupElement(this.mSpanSpinner)};
        SGComponentGroupElement[] sGComponentGroupElementArray4 = new SGComponentGroupElement[]{new SGComponentGroupElement(this.mLocationLabel), new SGComponentGroupElement(this.mXValueLabel), new SGComponentGroupElement(this.mXValueTextField), new SGComponentGroupElement(this.mYValueLabel), new SGComponentGroupElement(this.mYValueTextField), new SGComponentGroupElement(this.mStringLabel), new SGComponentGroupElement(this.mFontFamilyLabel), new SGComponentGroupElement(this.mFontStyleLabel), new SGComponentGroupElement(this.mFontNameComboBox), new SGComponentGroupElement(this.mFontStyleComboBox), new SGComponentGroupElement(this.mFontSizeLabel), new SGComponentGroupElement(this.mFontSizeSpinner), new SGComponentGroupElement(this.mStringColorLabel), new SGComponentGroupElement(this.mStringColorButton), new SGComponentGroupElement(this.mFrameLabel), new SGComponentGroupElement(this.mFrameVisibleCheckBox), sGComponentGroupElementArray[0], sGComponentGroupElementArray[1], sGComponentGroupElementArray[2], sGComponentGroupElementArray[3], new SGComponentGroupElement(this.mBackgroundLabel), new SGComponentGroupElement(this.mBackgroundTransparencyLabel), new SGComponentGroupElement(this.mBackgroundTransparencySpinner), sGComponentGroupElementArray2[0], sGComponentGroupElementArray2[1], new SGComponentGroupElement(this.mSymbolLabel), sGComponentGroupElementArray3[0], sGComponentGroupElementArray3[1]};
        this.mVisibleComponentGroup.addElement(sGComponentGroupElementArray4);
        this.mFrameVisibleComponentGroup.addElement(sGComponentGroupElementArray);
        this.mBackgroundComponentGroup.addElement(sGComponentGroupElementArray2);
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (object.equals(this.mLegendVisibleCheckBox)) {
            this.setLegendVisible(this.mLegendVisibleCheckBox.getSelected());
        } else if (object.equals(this.mFrameVisibleCheckBox)) {
            this.setFrameComponentsEnabled(this.mFrameVisibleCheckBox.getSelected());
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object == this.mBackgroundTransparencySpinner && null != this.getBackgroundTransparency()) {
            this.setBackgroundTransparentComponentEnabled(this.getBackgroundTransparency().intValue());
        }
        super.stateChanged(changeEvent);
    }

    private boolean setAllLegendComponentsEnabled(Boolean bl) {
        boolean bl2 = true;
        if (bl != null) {
            bl2 = bl;
        }
        this.mVisibleComponentGroup.setEnabled(bl2);
        return true;
    }

    private boolean setFrameComponentsEnabled(Boolean bl) {
        boolean bl2 = true;
        if (bl != null) {
            bl2 = bl;
        }
        this.setFrameComponentsEnabled(bl2);
        return true;
    }

    private boolean setFrameComponentsEnabled(boolean bl) {
        this.mFrameVisibleComponentGroup.setEnabled(bl);
        return true;
    }

    private boolean setBackgroundComponentsEnabled(boolean bl) {
        this.mBackgroundComponentGroup.setEnabled(bl);
        return true;
    }

    public Number getXValue() {
        return this.getNumber(this.mXValueTextField);
    }

    public Number getYValue() {
        return this.getNumber(this.mYValueTextField);
    }

    public Boolean getLegendVisible() {
        return this.mLegendVisibleCheckBox.getSelected();
    }

    public Boolean getFrameVisible() {
        return this.mFrameVisibleCheckBox.getSelected();
    }

    public Number getFrameLineWidth() {
        return this.mFrameLineWidthSpinner.getNumber();
    }

    public Color getFrameLineColor() {
        return this.mFrameLineColorButton.getColor();
    }

    public Color getBackgroundColor() {
        return this.mBackgroundColorButton.getColor();
    }

    public Number getFontSize() {
        return this.mFontSizeSpinner.getNumber();
    }

    public String getFontName() {
        return (String)this.mFontNameComboBox.getSelectedItem();
    }

    public Integer getFontStyle() {
        String string = (String)this.mFontStyleComboBox.getSelectedItem();
        return SGUtilityText.getFontStyle(string);
    }

    public Color getTextColor() {
        return this.mStringColorButton.getColor();
    }

    public Number getBackgroundTransparency() {
        return this.mBackgroundTransparencySpinner.getNumber();
    }

    public Number getSymbolSpan() {
        return this.mSpanSpinner.getNumber();
    }

    public boolean setXValue(Object object) {
        return this.setValue(this.mXValueTextField, object);
    }

    public boolean setYValue(Object object) {
        return this.setValue(this.mYValueTextField, object);
    }

    public void setLegendVisible(Boolean bl) {
        this.mLegendVisibleCheckBox.setSelected(bl);
        this.setAllLegendComponentsEnabled(bl);
    }

    public void setFrameVisible(Boolean bl) {
        this.mFrameVisibleCheckBox.setSelected(bl);
        this.setFrameComponentsEnabled(bl);
    }

    public boolean setFrameLineWidth(Object object) {
        return this.setValue(this.mFrameLineWidthSpinner, object);
    }

    public void setFrameLineColor(Color color) {
        this.mFrameLineColorButton.setColor(color);
    }

    public void setBackgroundColor(Color color) {
        Color color2 = color != null ? new Color(color.getRed(), color.getGreen(), color.getBlue(), 255) : null;
        this.mBackgroundColorButton.setColor(color2);
    }

    public boolean setFontSize(Object object) {
        return this.setValue(this.mFontSizeSpinner, object);
    }

    public boolean setFontName(String string) {
        String string2 = SGUtility.findFontFamilyName(string);
        this.mFontNameComboBox.setSelectedItem(string2);
        return true;
    }

    public boolean setFontStyle(Integer n) {
        String string = null;
        if (n != null) {
            string = SGUtilityText.getFontStyleName(n);
        }
        this.mFontStyleComboBox.setSelectedItem(string);
        return true;
    }

    public void setTextColor(Color color) {
        this.mStringColorButton.setColor(color);
    }

    public boolean setBackgroundTransparent(Integer n) {
        if (n != null) {
            this.setBackgroundTransparentComponentEnabled(n);
            return this.setValue(this.mBackgroundTransparencySpinner, (Object)Float.valueOf(n.floatValue()));
        }
        return this.setValue(this.mBackgroundTransparencySpinner, null);
    }

    private boolean setBackgroundTransparentComponentEnabled(Integer n) {
        if (n.equals(100)) {
            return this.setBackgroundComponentsEnabled(Boolean.FALSE);
        }
        return this.setBackgroundComponentsEnabled(Boolean.TRUE);
    }

    public boolean setSymbolSpan(Object object) {
        return this.setValue(this.mSpanSpinner, object);
    }

    @Override
    public List<SGColorSelectionButton> getColorSelectionButtonsList() {
        ArrayList<SGColorSelectionButton> arrayList = new ArrayList<SGColorSelectionButton>();
        arrayList.add(this.mBackgroundColorButton);
        arrayList.add(this.mFrameLineColorButton);
        arrayList.add(this.mStringColorButton);
        return arrayList;
    }

    @Override
    public List getTextFieldComponentsList() {
        List list = this.getFormattedTextFieldsListFromSpinners();
        list.addAll(this.getNumberTextFieldList());
        return list;
    }

    @Override
    public List<SGTextField> getNumberTextFieldList() {
        ArrayList<SGTextField> arrayList = new ArrayList<SGTextField>();
        arrayList.add(this.mXValueTextField);
        arrayList.add(this.mYValueTextField);
        return arrayList;
    }

    @Override
    public List<SGSpinner> getSpinnerList() {
        ArrayList<SGSpinner> arrayList = new ArrayList<SGSpinner>();
        arrayList.add(this.mFontSizeSpinner);
        arrayList.add(this.mFrameLineWidthSpinner);
        arrayList.add(this.mSpanSpinner);
        arrayList.add(this.mBackgroundTransparencySpinner);
        return arrayList;
    }

    @Override
    public boolean setDialogProperty() {
        SGLegendDialog sGLegendDialog = this;
        List list = this.mPropertyDialogObserverList;
        if (!this.mAxisPanel.setSelected(list)) {
            return false;
        }
        SGILegendDialogObserver sGILegendDialogObserver = (SGILegendDialogObserver)list.get(0);
        double d = sGILegendDialogObserver.getXValue();
        double d2 = sGILegendDialogObserver.getYValue();
        String string = sGILegendDialogObserver.getFontName();
        float f = sGILegendDialogObserver.getFontSize("pt");
        int n = sGILegendDialogObserver.getFontStyle();
        Color color = sGILegendDialogObserver.getStringColor();
        float f2 = sGILegendDialogObserver.getFrameLineWidth("pt");
        Color color2 = sGILegendDialogObserver.getFrameLineColor();
        Color color3 = sGILegendDialogObserver.getBackgroundColor();
        boolean bl = sGILegendDialogObserver.isLegendVisible();
        boolean bl2 = sGILegendDialogObserver.isFrameLineVisible();
        int n2 = sGILegendDialogObserver.getBackgroundTransparency();
        float f3 = sGILegendDialogObserver.getSymbolSpan("cm");
        Double d3 = d;
        Double d4 = d2;
        String string2 = string;
        Float f4 = Float.valueOf(f);
        Integer n3 = n;
        Color color4 = color;
        Float f5 = Float.valueOf(f2);
        Color color5 = color2;
        Color color6 = color3;
        Boolean bl3 = bl;
        Boolean bl4 = bl2;
        Integer n4 = n2;
        Float f6 = Float.valueOf(f3);
        if (list.size() > 1) {
            double d5;
            SGILegendDialogObserver sGILegendDialogObserver2;
            int n5;
            for (n5 = 1; n5 < list.size(); ++n5) {
                sGILegendDialogObserver2 = (SGILegendDialogObserver)list.get(n5);
                d5 = sGILegendDialogObserver2.getXValue();
                if (d == d5) continue;
                d3 = null;
                break;
            }
            for (n5 = 1; n5 < list.size(); ++n5) {
                sGILegendDialogObserver2 = (SGILegendDialogObserver)list.get(n5);
                d5 = sGILegendDialogObserver2.getYValue();
                if (d2 == d5) continue;
                d4 = null;
                break;
            }
            for (n5 = 1; n5 < list.size(); ++n5) {
                sGILegendDialogObserver2 = (SGILegendDialogObserver)list.get(n5);
                String string3 = sGILegendDialogObserver2.getFontName();
                if (string.equals(string3)) continue;
                string2 = null;
                break;
            }
            for (n5 = 1; n5 < list.size(); ++n5) {
                sGILegendDialogObserver2 = (SGILegendDialogObserver)list.get(n5);
                float f7 = sGILegendDialogObserver2.getFontSize("pt");
                if (f == f7) continue;
                f4 = null;
                break;
            }
            for (n5 = 1; n5 < list.size(); ++n5) {
                sGILegendDialogObserver2 = (SGILegendDialogObserver)list.get(n5);
                int n6 = sGILegendDialogObserver2.getFontStyle();
                if (n == n6) continue;
                n3 = null;
                break;
            }
            for (n5 = 1; n5 < list.size(); ++n5) {
                sGILegendDialogObserver2 = (SGILegendDialogObserver)list.get(n5);
                Color color7 = sGILegendDialogObserver2.getStringColor();
                if (color4.equals(color7)) continue;
                color4 = null;
                break;
            }
            for (n5 = 1; n5 < list.size(); ++n5) {
                sGILegendDialogObserver2 = (SGILegendDialogObserver)list.get(n5);
                float f8 = sGILegendDialogObserver2.getFrameLineWidth("pt");
                if (f2 == f8) continue;
                f5 = null;
                break;
            }
            for (n5 = 1; n5 < list.size(); ++n5) {
                sGILegendDialogObserver2 = (SGILegendDialogObserver)list.get(n5);
                Color color8 = sGILegendDialogObserver2.getFrameLineColor();
                if (color5.equals(color8)) continue;
                color5 = null;
                break;
            }
            for (n5 = 1; n5 < list.size(); ++n5) {
                sGILegendDialogObserver2 = (SGILegendDialogObserver)list.get(n5);
                Color color9 = sGILegendDialogObserver2.getBackgroundColor();
                if (color6.equals(color9)) continue;
                color6 = null;
                break;
            }
            for (n5 = 1; n5 < list.size(); ++n5) {
                sGILegendDialogObserver2 = (SGILegendDialogObserver)list.get(n5);
                boolean bl5 = sGILegendDialogObserver2.isLegendVisible();
                if (bl == bl5) continue;
                bl3 = null;
                break;
            }
            for (n5 = 1; n5 < list.size(); ++n5) {
                sGILegendDialogObserver2 = (SGILegendDialogObserver)list.get(n5);
                boolean bl6 = sGILegendDialogObserver2.isFrameLineVisible();
                if (bl2 == bl6) continue;
                bl4 = null;
                break;
            }
            for (n5 = 1; n5 < list.size(); ++n5) {
                sGILegendDialogObserver2 = (SGILegendDialogObserver)list.get(n5);
                int n7 = sGILegendDialogObserver2.getBackgroundTransparency();
                if (n2 == n7) continue;
                n4 = null;
                break;
            }
            for (n5 = 1; n5 < list.size(); ++n5) {
                sGILegendDialogObserver2 = (SGILegendDialogObserver)list.get(n5);
                float f9 = sGILegendDialogObserver2.getSymbolSpan("cm");
                if (f3 == f9) continue;
                f6 = null;
                break;
            }
        }
        sGLegendDialog.setXValue(d3);
        sGLegendDialog.setYValue(d4);
        sGLegendDialog.setFrameVisible(bl4);
        sGLegendDialog.setFrameLineWidth(f5);
        sGLegendDialog.setFrameLineColor(color5);
        sGLegendDialog.setFontName(string2);
        sGLegendDialog.setFontSize(f4);
        sGLegendDialog.setFontStyle(n3);
        sGLegendDialog.setTextColor(color4);
        sGLegendDialog.setBackgroundColor(color6);
        sGLegendDialog.setBackgroundTransparent(n4);
        sGLegendDialog.setLegendVisible(bl3);
        sGLegendDialog.setSymbolSpan(f6);
        return true;
    }

    @Override
    public boolean setPropertiesToListeners(SGIPropertyDialogObserver sGIPropertyDialogObserver) {
        SGILegendDialogObserver sGILegendDialogObserver = (SGILegendDialogObserver)sGIPropertyDialogObserver;
        int n = this.mAxisPanel.getXAxisLocation();
        int n2 = this.mAxisPanel.getYAxisLocation();
        Number number = this.getXValue();
        Number number2 = this.getYValue();
        Boolean bl = this.getLegendVisible();
        Boolean bl2 = this.getFrameVisible();
        Number number3 = this.getFrameLineWidth();
        Color color = this.getFrameLineColor();
        Color color2 = this.getBackgroundColor();
        Number number4 = this.getBackgroundTransparency();
        String string = this.getFontName();
        Number number5 = this.getFontSize();
        Integer n3 = this.getFontStyle();
        Color color3 = this.getTextColor();
        Number number6 = this.getSymbolSpan();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!sGILegendDialogObserver.hasValidXAxisValue(n, number)) {
            arrayList.add("X");
        }
        if (!sGILegendDialogObserver.hasValidYAxisValue(n2, number2)) {
            arrayList.add("Y");
        }
        if (arrayList.size() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Axis value is invalid");
            stringBuffer.append(":\n");
            for (int i = 0; i < arrayList.size(); ++i) {
                String string2 = (String)arrayList.get(i);
                stringBuffer.append('-');
                stringBuffer.append(string2);
                stringBuffer.append('\n');
            }
            this.setInputErrorMessage(stringBuffer.toString());
            return false;
        }
        if (n != -1) {
            sGILegendDialogObserver.setXAxisLocation(n);
        }
        if (n2 != -1) {
            sGILegendDialogObserver.setYAxisLocation(n2);
        }
        if (number != null) {
            sGILegendDialogObserver.setXValue(number.doubleValue());
        }
        if (number2 != null) {
            sGILegendDialogObserver.setYValue(number2.doubleValue());
        }
        if (bl != null) {
            sGILegendDialogObserver.setLegendVisible(bl);
        }
        if (bl2 != null) {
            sGILegendDialogObserver.setFrameVisible(bl2);
        }
        if (number3 != null) {
            sGILegendDialogObserver.setFrameLineWidth(number3.floatValue(), "pt");
        }
        if (color != null) {
            sGILegendDialogObserver.setFrameLineColor(color);
        }
        if (color2 != null) {
            sGILegendDialogObserver.setBackgroundColor(color2);
        }
        if (number4 != null) {
            sGILegendDialogObserver.setBackgroundTransparent(number4.intValue());
        }
        if (string != null) {
            sGILegendDialogObserver.setFontName(string);
        }
        if (number5 != null) {
            sGILegendDialogObserver.setFontSize(number5.floatValue(), "pt");
        }
        if (n3 != null) {
            sGILegendDialogObserver.setFontStyle(n3);
        }
        if (color3 != null) {
            sGILegendDialogObserver.setFontColor(color3);
        }
        if (number6 != null) {
            sGILegendDialogObserver.setSymbolSpan(number6.floatValue(), "cm");
        }
        return true;
    }

    @Override
    protected JButton getOKButton() {
        return this.mOKButton;
    }

    @Override
    protected JButton getCancelButton() {
        return this.mCancelButton;
    }

    @Override
    protected JButton getPreviewButton() {
        return this.mPreviewButton;
    }

    @Override
    protected boolean hasValidInputValues() {
        boolean bl = true;
        if (!super.hasValidInputValues()) {
            bl = false;
        }
        if (!this.hasValidNumber(this.mXValueTextField, null, null)) {
            bl = false;
        }
        if (!this.hasValidNumber(this.mYValueTextField, null, null)) {
            bl = false;
        }
        return bl;
    }
}

