/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import jp.riken.brain.ni.samuraigraph.base.SGButton;
import jp.riken.brain.ni.samuraigraph.base.SGCheckBox;
import jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton;
import jp.riken.brain.ni.samuraigraph.base.SGComboBox;
import jp.riken.brain.ni.samuraigraph.base.SGComponentGroup;
import jp.riken.brain.ni.samuraigraph.base.SGComponentGroupElement;
import jp.riken.brain.ni.samuraigraph.base.SGFillPaint;
import jp.riken.brain.ni.samuraigraph.base.SGGradationPaint;
import jp.riken.brain.ni.samuraigraph.base.SGGradationPaintDialog;
import jp.riken.brain.ni.samuraigraph.base.SGGradationPaintSelectionButton;
import jp.riken.brain.ni.samuraigraph.base.SGIPaint;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGPatternPaint;
import jp.riken.brain.ni.samuraigraph.base.SGPatternPaintDialog;
import jp.riken.brain.ni.samuraigraph.base.SGPatternPaintSelectionButton;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGRadioButton;
import jp.riken.brain.ni.samuraigraph.base.SGSelectablePaint;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGTextField;
import jp.riken.brain.ni.samuraigraph.base.SGTwoAxesSelectionPanel;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIRectangularShapeDialogObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGRectangularShapeDialog
extends SGPropertyDialog {
    private static final long serialVersionUID = 1791114777174503450L;
    public static final String TITLE = "Rectangular Shape Properties";
    private SGTwoAxesSelectionPanel mAxisPanel;
    private JLabel mBackgroundLabel;
    private JSeparator mBackgroundSeparator;
    private JLabel mBackgroundTransparentLabel;
    private SGSpinner mBackgroundTransparentSpinner;
    private JLabel mBottomYValueLabel;
    private SGTextField mBottomYValueTextField;
    private SGCheckBox mBoundsAnchoredCheckBox;
    private JLabel mBoundsLabel;
    private JSeparator mBoundsSeparator;
    private JPanel mButtonPanel;
    private SGButton mCancelButton;
    private JLabel mEdgeLineLabel;
    private JSeparator mEdgeLineSeparator;
    private SGComboBox mEdgeLineTypeComboBox;
    private JLabel mEdgeLineTypeLabel;
    private SGCheckBox mEdgeLineVisibleCheckBox;
    private JLabel mEdgeLineWidthLabel;
    private SGSpinner mEdgeLineWidthSpinner;
    private JLabel mInnerColorLabel;
    private SGColorSelectionButton mInnerFillPaintButton;
    private SGRadioButton mInnerFillPaintRadioButton;
    private SGGradationPaintSelectionButton mInnerGradationPaintButton;
    private SGRadioButton mInnerGradationPaintRadioButton;
    private SGPatternPaintSelectionButton mInnerPatternPaintButton;
    private SGRadioButton mInnerPatternPaintRadioButton;
    private JLabel mLeftSpaceLabel;
    private JLabel mLeftXValueLabel;
    private SGTextField mLeftXValueTextField;
    private SGColorSelectionButton mLineColorButton;
    private JLabel mLineColorLabel;
    private SGButton mOKButton;
    private JPanel mPanel;
    private SGButton mPreviewButton;
    private JLabel mRightSpaceLabel;
    private JLabel mRightXValueLabel;
    private SGTextField mRightXValueTextField;
    private JLabel mTopYValueLabel;
    private SGTextField mTopYValueTextField;
    private SGRadioButton mNoInnerPaintStyleRadioButton;
    private SGPatternPaintDialog mPatternPaintDialog;
    private SGGradationPaintDialog mGradationPaintDialog;
    private SGComponentGroup mTransparentComponentGroup = new SGComponentGroup();

    public SGRectangularShapeDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
        this.initialize();
    }

    private void initComponents() {
        this.mAxisPanel = new SGTwoAxesSelectionPanel();
        this.mPanel = new JPanel();
        this.mEdgeLineLabel = new JLabel();
        this.mEdgeLineSeparator = new JSeparator();
        this.mLeftSpaceLabel = new JLabel();
        this.mRightSpaceLabel = new JLabel();
        this.mBoundsLabel = new JLabel();
        this.mBoundsSeparator = new JSeparator();
        this.mLeftXValueLabel = new JLabel();
        this.mLeftXValueTextField = new SGTextField();
        this.mTopYValueLabel = new JLabel();
        this.mTopYValueTextField = new SGTextField();
        this.mRightXValueLabel = new JLabel();
        this.mRightXValueTextField = new SGTextField();
        this.mBottomYValueLabel = new JLabel();
        this.mBottomYValueTextField = new SGTextField();
        this.mBoundsAnchoredCheckBox = new SGCheckBox();
        this.mBackgroundLabel = new JLabel();
        this.mBackgroundSeparator = new JSeparator();
        this.mLineColorLabel = new JLabel();
        this.mLineColorButton = new SGColorSelectionButton();
        this.mInnerColorLabel = new JLabel();
        this.mInnerFillPaintButton = new SGColorSelectionButton();
        this.mInnerPatternPaintButton = new SGPatternPaintSelectionButton();
        this.mInnerGradationPaintButton = new SGGradationPaintSelectionButton();
        this.mInnerFillPaintRadioButton = new SGRadioButton();
        this.mInnerPatternPaintRadioButton = new SGRadioButton();
        this.mInnerGradationPaintRadioButton = new SGRadioButton();
        this.mEdgeLineWidthLabel = new JLabel();
        this.mEdgeLineWidthSpinner = new SGSpinner();
        this.mBackgroundTransparentLabel = new JLabel();
        this.mBackgroundTransparentSpinner = new SGSpinner();
        this.mEdgeLineVisibleCheckBox = new SGCheckBox();
        this.mEdgeLineTypeLabel = new JLabel();
        this.mEdgeLineTypeComboBox = new SGComboBox();
        this.mButtonPanel = new JPanel();
        this.mOKButton = new SGButton();
        this.mCancelButton = new SGButton();
        this.mPreviewButton = new SGButton();
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.mAxisPanel, gridBagConstraints);
        this.mPanel.setBorder(BorderFactory.createBevelBorder(0));
        this.mPanel.setLayout(new GridBagLayout());
        this.mEdgeLineLabel.setFont(new Font("Dialog", 3, 12));
        this.mEdgeLineLabel.setText("Edge Line ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mEdgeLineLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 4, 5, 5);
        this.mPanel.add((Component)this.mEdgeLineSeparator, gridBagConstraints);
        this.mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.mPanel.add((Component)this.mLeftSpaceLabel, gridBagConstraints);
        this.mRightSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        this.mPanel.add((Component)this.mRightSpaceLabel, gridBagConstraints);
        this.mBoundsLabel.setFont(new Font("Dialog", 3, 12));
        this.mBoundsLabel.setText("Bounds ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.mPanel.add((Component)this.mBoundsLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 4, 5, 5);
        this.mPanel.add((Component)this.mBoundsSeparator, gridBagConstraints);
        this.mLeftXValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mLeftXValueLabel.setText("Left X");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mPanel.add((Component)this.mLeftXValueLabel, gridBagConstraints);
        this.mLeftXValueTextField.setColumns(6);
        this.mLeftXValueTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mLeftXValueTextField, gridBagConstraints);
        this.mTopYValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mTopYValueLabel.setText("Top Y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.mPanel.add((Component)this.mTopYValueLabel, gridBagConstraints);
        this.mTopYValueTextField.setColumns(6);
        this.mTopYValueTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mTopYValueTextField, gridBagConstraints);
        this.mRightXValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mRightXValueLabel.setText("Right X");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.mPanel.add((Component)this.mRightXValueLabel, gridBagConstraints);
        this.mRightXValueTextField.setColumns(6);
        this.mRightXValueTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mRightXValueTextField, gridBagConstraints);
        this.mBottomYValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mBottomYValueLabel.setText("Bottom Y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mPanel.add((Component)this.mBottomYValueLabel, gridBagConstraints);
        this.mBottomYValueTextField.setColumns(6);
        this.mBottomYValueTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mBottomYValueTextField, gridBagConstraints);
        this.mBoundsAnchoredCheckBox.setText("Anchored");
        this.mBoundsAnchoredCheckBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 0);
        this.mPanel.add((Component)this.mBoundsAnchoredCheckBox, gridBagConstraints);
        this.mBackgroundLabel.setFont(new Font("Dialog", 3, 12));
        this.mBackgroundLabel.setText("Background");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mBackgroundLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.mPanel.add((Component)this.mBackgroundSeparator, gridBagConstraints);
        this.mLineColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mLineColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 10);
        this.mPanel.add((Component)this.mLineColorLabel, gridBagConstraints);
        this.mLineColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 7, 5);
        this.mPanel.add((Component)this.mLineColorButton, gridBagConstraints);
        this.mInnerColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mInnerColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.mPanel.add((Component)this.mInnerColorLabel, gridBagConstraints);
        this.mInnerFillPaintButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        this.mPanel.add((Component)this.mInnerFillPaintButton, gridBagConstraints);
        this.mInnerPatternPaintButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        this.mPanel.add((Component)this.mInnerPatternPaintButton, gridBagConstraints);
        this.mInnerGradationPaintButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.mPanel.add((Component)this.mInnerGradationPaintButton, gridBagConstraints);
        this.mInnerFillPaintRadioButton.setText("Fill");
        this.mInnerFillPaintRadioButton.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        this.mPanel.add((Component)this.mInnerFillPaintRadioButton, gridBagConstraints);
        this.mInnerPatternPaintRadioButton.setText("Pattern");
        this.mInnerPatternPaintRadioButton.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 3, 0);
        this.mPanel.add((Component)this.mInnerPatternPaintRadioButton, gridBagConstraints);
        this.mInnerGradationPaintRadioButton.setText("Gradation");
        this.mInnerGradationPaintRadioButton.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 10, 0);
        this.mPanel.add((Component)this.mInnerGradationPaintRadioButton, gridBagConstraints);
        this.mEdgeLineWidthLabel.setFont(new Font("Dialog", 0, 12));
        this.mEdgeLineWidthLabel.setText("Line Width");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mPanel.add((Component)this.mEdgeLineWidthLabel, gridBagConstraints);
        this.mEdgeLineWidthSpinner.setFont(new Font("Dialog", 0, 12));
        this.mEdgeLineWidthSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mEdgeLineWidthSpinner, gridBagConstraints);
        this.mBackgroundTransparentLabel.setFont(new Font("Dialog", 0, 12));
        this.mBackgroundTransparentLabel.setText("Transparency");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 10);
        this.mPanel.add((Component)this.mBackgroundTransparentLabel, gridBagConstraints);
        this.mBackgroundTransparentSpinner.setFont(new Font("Dialog", 0, 12));
        this.mBackgroundTransparentSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mBackgroundTransparentSpinner, gridBagConstraints);
        this.mEdgeLineVisibleCheckBox.setText("Visible");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 0, 5);
        this.mPanel.add((Component)this.mEdgeLineVisibleCheckBox, gridBagConstraints);
        this.mEdgeLineTypeLabel.setFont(new Font("Dialog", 0, 12));
        this.mEdgeLineTypeLabel.setText("Type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mEdgeLineTypeLabel, gridBagConstraints);
        this.mEdgeLineTypeComboBox.setFont(new Font("Dialog", 0, 12));
        this.mEdgeLineTypeComboBox.setPreferredSize(new Dimension(140, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mEdgeLineTypeComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mPanel, gridBagConstraints);
        this.mOKButton.setText("OK");
        this.mOKButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setText("Cancel");
        this.mCancelButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mCancelButton);
        this.mPreviewButton.setText("Preview");
        this.mPreviewButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mPreviewButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        this.pack();
    }

    private void initProperty() {
        this.setTitle(TITLE);
        Object object = new String[]{"Solid", "Broken", "Dotted", "Dashed", "Double Dashed"};
        for (int i = 0; i < ((String[])object).length; ++i) {
            this.mEdgeLineTypeComboBox.addItem(object[i]);
        }
        this.mNoInnerPaintStyleRadioButton = new SGRadioButton();
        object = new ButtonGroup();
        ((ButtonGroup)object).add(this.mInnerFillPaintRadioButton);
        ((ButtonGroup)object).add(this.mInnerPatternPaintRadioButton);
        ((ButtonGroup)object).add(this.mInnerGradationPaintRadioButton);
        ((ButtonGroup)object).add(this.mNoInnerPaintStyleRadioButton);
        this.mNoInnerPaintStyleRadioButton.setVisible(false);
        this.pack();
        this.mEdgeLineWidthSpinner.initProperties(SGRectangularShapeDialog.getLineWidthSpinnerNumberModel(), "pt", 1, 2);
        this.mBackgroundTransparentSpinner.initProperties(new SpinnerNumberModel(100.0, 0.0, 100.0, 1.0), "%", 0, 0);
        object = new SGComponentGroupElement[]{new SGComponentGroupElement(this.mInnerColorLabel), new SGComponentGroupElement(this.mInnerFillPaintButton), new SGComponentGroupElement(this.mInnerFillPaintRadioButton), new SGComponentGroupElement(this.mInnerPatternPaintButton), new SGComponentGroupElement(this.mInnerPatternPaintRadioButton), new SGComponentGroupElement(this.mInnerGradationPaintButton), new SGComponentGroupElement(this.mInnerGradationPaintRadioButton)};
        this.mTransparentComponentGroup.addElement((SGComponentGroupElement[])object);
        this.mLeftXValueTextField.setDescription("Bounds-> LeftX");
        this.mRightXValueTextField.setDescription("Bounds-> RightX");
        this.mBottomYValueTextField.setDescription("Bounds-> BottomY");
        this.mTopYValueTextField.setDescription("Bounds-> TopY");
        this.mEdgeLineWidthSpinner.setDescription("Edge Line-> Line Width");
        this.mBackgroundTransparentSpinner.setDescription("Background-> Transparency");
        this.mEdgeLineTypeComboBox.addActionListener(this);
        this.mEdgeLineVisibleCheckBox.addActionListener(this);
        this.mAxisPanel.addActionListener(this);
        this.mInnerPatternPaintButton.addActionListener(this);
        this.mInnerGradationPaintButton.addActionListener(this);
        this.mBackgroundTransparentSpinner.addChangeListener(this);
        this.mPatternPaintDialog = new SGPatternPaintDialog(this, "Pattern Paint Dialog", false);
        this.mPatternPaintDialog.setDefaultCloseOperation(1);
        this.mPatternPaintDialog.pack();
        this.mPatternPaintDialog.setResizable(false);
        this.mPatternPaintDialog.addModelChangeListener(this);
        this.mGradationPaintDialog = new SGGradationPaintDialog(this, "Gradation Paint Dialog", false);
        this.mGradationPaintDialog.setDefaultCloseOperation(1);
        this.mGradationPaintDialog.pack();
        this.mGradationPaintDialog.setResizable(false);
        this.mGradationPaintDialog.addModelChangeListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object == this.mGradationPaintDialog) {
            SGGradationPaint sGGradationPaint = this.mGradationPaintDialog.getGradationPaint();
            this.mInnerGradationPaintButton.setGradationPaint(sGGradationPaint);
            return;
        }
        if (object == this.mPatternPaintDialog) {
            SGPatternPaint sGPatternPaint = this.mPatternPaintDialog.getPatternPaint();
            this.mInnerPatternPaintButton.setPatternPaint(sGPatternPaint);
            return;
        }
        if (object == this.mBackgroundTransparentSpinner && null != this.getTransparency()) {
            this.setTransparentComponentEnabled(this.getTransparency().intValue());
        }
        super.stateChanged(changeEvent);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (this.isVisible()) {
            if (object == this.mInnerFillPaintButton) {
                this.mInnerFillPaintRadioButton.setSelected(true);
            } else if (object == this.mInnerPatternPaintButton) {
                this.mInnerPatternPaintRadioButton.setSelected(true);
            } else if (object == this.mInnerGradationPaintButton) {
                this.mInnerGradationPaintRadioButton.setSelected(true);
            }
        }
        if (object == this.mInnerGradationPaintButton) {
            if (!this.mGradationPaintDialog.isVisible()) {
                this.mGradationPaintDialog.setSelectedGradationPaint(this.mInnerGradationPaintButton.getGradationPaint());
                this.mGradationPaintDialog.setLocation(this.mInnerGradationPaintButton.getX() + 20, this.mInnerGradationPaintButton.getY() + 20);
                this.mGradationPaintDialog.setVisible(true);
            }
        } else if (object == this.mInnerPatternPaintButton) {
            if (!this.mPatternPaintDialog.isVisible()) {
                this.mPatternPaintDialog.setSelectedPatternPaint(this.mInnerPatternPaintButton.getPatternPaint());
                this.mPatternPaintDialog.setLocation(this.mInnerPatternPaintButton.getX() + 20, this.mInnerPatternPaintButton.getY() + 20);
                this.mPatternPaintDialog.setVisible(true);
            }
        } else if (object == this.mEdgeLineVisibleCheckBox) {
            this.setLineVisible(this.getLineVisible());
        }
    }

    @Override
    public List getColorSelectionButtonsList() {
        ArrayList<SGColorSelectionButton> arrayList = new ArrayList<SGColorSelectionButton>();
        arrayList.add(this.mLineColorButton);
        arrayList.add(this.mInnerFillPaintButton);
        return arrayList;
    }

    @Override
    public List getTextFieldComponentsList() {
        List list = this.getFormattedTextFieldsListFromSpinners();
        list.addAll(this.getNumberTextFieldList());
        return list;
    }

    @Override
    public List getNumberTextFieldList() {
        ArrayList<SGTextField> arrayList = new ArrayList<SGTextField>();
        arrayList.add(this.mLeftXValueTextField);
        arrayList.add(this.mRightXValueTextField);
        arrayList.add(this.mTopYValueTextField);
        arrayList.add(this.mBottomYValueTextField);
        return arrayList;
    }

    @Override
    public List<SGSpinner> getSpinnerList() {
        ArrayList<SGSpinner> arrayList = new ArrayList<SGSpinner>();
        arrayList.add(this.mEdgeLineWidthSpinner);
        arrayList.add(this.mBackgroundTransparentSpinner);
        return arrayList;
    }

    @Override
    public boolean setDialogProperty() {
        List list = this.mPropertyDialogObserverList;
        if (!this.mAxisPanel.setSelected(list)) {
            return false;
        }
        SGIRectangularShapeDialogObserver sGIRectangularShapeDialogObserver = (SGIRectangularShapeDialogObserver)list.get(0);
        double d = sGIRectangularShapeDialogObserver.getLeftXValue();
        double d2 = sGIRectangularShapeDialogObserver.getTopYValue();
        double d3 = sGIRectangularShapeDialogObserver.getRightXValue();
        double d4 = sGIRectangularShapeDialogObserver.getBottomYValue();
        float f = sGIRectangularShapeDialogObserver.getLineWidth("pt");
        int n = sGIRectangularShapeDialogObserver.getLineType();
        SGIPaint sGIPaint = sGIRectangularShapeDialogObserver.getInnerPaint();
        Color color = sGIRectangularShapeDialogObserver.getLineColor();
        boolean bl = sGIRectangularShapeDialogObserver.isAnchored();
        boolean bl2 = sGIRectangularShapeDialogObserver.isLineVisible();
        Double d5 = d;
        Double d6 = d2;
        Double d7 = d3;
        Double d8 = d4;
        Float f2 = Float.valueOf(f);
        Integer n2 = n;
        SGIPaint sGIPaint2 = sGIPaint;
        Color color2 = color;
        Boolean bl3 = bl;
        Boolean bl4 = bl2;
        if (list.size() > 1) {
            double d9;
            SGIRectangularShapeDialogObserver sGIRectangularShapeDialogObserver2;
            int n3;
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGIRectangularShapeDialogObserver2 = (SGIRectangularShapeDialogObserver)list.get(n3);
                d9 = sGIRectangularShapeDialogObserver2.getLeftXValue();
                if (d == d9) continue;
                d5 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGIRectangularShapeDialogObserver2 = (SGIRectangularShapeDialogObserver)list.get(n3);
                d9 = sGIRectangularShapeDialogObserver2.getTopYValue();
                if (d2 == d9) continue;
                d6 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGIRectangularShapeDialogObserver2 = (SGIRectangularShapeDialogObserver)list.get(n3);
                d9 = sGIRectangularShapeDialogObserver2.getRightXValue();
                if (d3 == d9) continue;
                d7 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGIRectangularShapeDialogObserver2 = (SGIRectangularShapeDialogObserver)list.get(n3);
                d9 = sGIRectangularShapeDialogObserver2.getBottomYValue();
                if (d4 == d9) continue;
                d8 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGIRectangularShapeDialogObserver2 = (SGIRectangularShapeDialogObserver)list.get(n3);
                float f3 = sGIRectangularShapeDialogObserver2.getLineWidth("pt");
                if (f == f3) continue;
                f2 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGIRectangularShapeDialogObserver2 = (SGIRectangularShapeDialogObserver)list.get(n3);
                int n4 = sGIRectangularShapeDialogObserver2.getLineType();
                if (n == n4) continue;
                n2 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGIRectangularShapeDialogObserver2 = (SGIRectangularShapeDialogObserver)list.get(n3);
                SGIPaint sGIPaint3 = sGIRectangularShapeDialogObserver2.getInnerPaint();
                if (sGIPaint.equals(sGIPaint3)) continue;
                sGIPaint2 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGIRectangularShapeDialogObserver2 = (SGIRectangularShapeDialogObserver)list.get(n3);
                Color color3 = sGIRectangularShapeDialogObserver2.getLineColor();
                if (color.equals(color3)) continue;
                color2 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGIRectangularShapeDialogObserver2 = (SGIRectangularShapeDialogObserver)list.get(n3);
                boolean bl5 = sGIRectangularShapeDialogObserver2.isAnchored();
                if (bl == bl5) continue;
                bl3 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGIRectangularShapeDialogObserver2 = (SGIRectangularShapeDialogObserver)list.get(n3);
                boolean bl6 = sGIRectangularShapeDialogObserver2.isLineVisible();
                if (bl2 == bl6) continue;
                bl4 = null;
                break;
            }
        }
        this.setLeftXValue(d5);
        this.setTopYValue(d6);
        this.setRightXValue(d7);
        this.setBottomYValue(d8);
        this.setLineWidth(f2);
        this.setLineType(n2);
        this.setInnerPaint(sGIPaint2);
        this.setLineColor(color2);
        this.setAnchored(bl3);
        this.setLineVisible(bl4);
        return true;
    }

    @Override
    public boolean setPropertiesToListeners(SGIPropertyDialogObserver sGIPropertyDialogObserver) {
        SGIRectangularShapeDialogObserver sGIRectangularShapeDialogObserver = (SGIRectangularShapeDialogObserver)sGIPropertyDialogObserver;
        int n = this.mAxisPanel.getXAxisLocation();
        int n2 = this.mAxisPanel.getYAxisLocation();
        Number number = this.getLeftXValue();
        Number number2 = this.getTopYValue();
        Number number3 = this.getRightXValue();
        Number number4 = this.getBottomYValue();
        Number number5 = this.getLineWidth();
        int n3 = this.getLineType();
        SGIPaint sGIPaint = this.getInnerPaint();
        Color color = this.getLineColor();
        Boolean bl = this.getBoundsAnchored();
        Boolean bl2 = this.getLineVisible();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!sGIRectangularShapeDialogObserver.hasValidLeftXValue(n, number)) {
            arrayList.add("LeftX");
        }
        if (!sGIRectangularShapeDialogObserver.hasValidTopYValue(n2, number2)) {
            arrayList.add("TopY");
        }
        if (!sGIRectangularShapeDialogObserver.hasValidRightXValue(n, number3)) {
            arrayList.add("RightX");
        }
        if (!sGIRectangularShapeDialogObserver.hasValidBottomYValue(n2, number4)) {
            arrayList.add("BottomY");
        }
        if (arrayList.size() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Axis value is invalid");
            stringBuffer.append(":\n");
            for (int i = 0; i < arrayList.size(); ++i) {
                String string = (String)arrayList.get(i);
                stringBuffer.append('-');
                stringBuffer.append(string);
                stringBuffer.append('\n');
            }
            this.setInputErrorMessage(stringBuffer.toString());
            return false;
        }
        if (n != -1) {
            sGIRectangularShapeDialogObserver.setXAxisLocation(n);
        }
        if (n2 != -1) {
            sGIRectangularShapeDialogObserver.setYAxisLocation(n2);
        }
        if (number != null) {
            sGIRectangularShapeDialogObserver.setLeftXValue(number.doubleValue());
        }
        if (number2 != null) {
            sGIRectangularShapeDialogObserver.setTopYValue(number2.doubleValue());
        }
        if (number3 != null) {
            sGIRectangularShapeDialogObserver.setRightXValue(number3.doubleValue());
        }
        if (number4 != null) {
            sGIRectangularShapeDialogObserver.setBottomYValue(number4.doubleValue());
        }
        if (number5 != null) {
            sGIRectangularShapeDialogObserver.setLineWidth(number5.floatValue(), "pt");
        }
        if (n3 != -1) {
            sGIRectangularShapeDialogObserver.setLineType(n3);
        }
        if (sGIPaint != null) {
            sGIRectangularShapeDialogObserver.setInnerPaint(sGIPaint);
        }
        if (color != null) {
            sGIRectangularShapeDialogObserver.setLineColor(color);
        }
        if (bl2 != null) {
            sGIRectangularShapeDialogObserver.setLineVisible(bl2);
        }
        if (bl != null) {
            sGIRectangularShapeDialogObserver.setAnchored(bl);
        }
        return true;
    }

    public Number getLeftXValue() {
        return this.getNumber(this.mLeftXValueTextField);
    }

    public Number getRightXValue() {
        return this.getNumber(this.mRightXValueTextField);
    }

    public Number getTopYValue() {
        return this.getNumber(this.mTopYValueTextField);
    }

    public Number getBottomYValue() {
        return this.getNumber(this.mBottomYValueTextField);
    }

    public Color getLineColor() {
        return this.mLineColorButton.getColor();
    }

    public Boolean getLineVisible() {
        return this.mEdgeLineVisibleCheckBox.getSelected();
    }

    public Boolean getBoundsAnchored() {
        return this.mBoundsAnchoredCheckBox.getSelected();
    }

    public Color getInnerFillPaintColor() {
        return this.mInnerFillPaintButton.getColor();
    }

    public SGPatternPaint getInnerPatternPaint() {
        return this.mInnerPatternPaintButton.getPatternPaint();
    }

    public SGGradationPaint getInnerGradationPaint() {
        return this.mInnerGradationPaintButton.getGradationPaint();
    }

    public Integer getInnerColorStyle() {
        int n;
        if (this.mInnerFillPaintRadioButton.isSelected()) {
            n = 0;
        } else if (this.mInnerPatternPaintRadioButton.isSelected()) {
            n = 1;
        } else if (this.mInnerGradationPaintRadioButton.isSelected()) {
            n = 2;
        } else {
            return null;
        }
        return n;
    }

    public SGIPaint getInnerPaint() {
        SGSelectablePaint sGSelectablePaint = new SGSelectablePaint();
        sGSelectablePaint.setFillColor(this.getInnerFillPaintColor());
        sGSelectablePaint.setPatternPaint(this.getInnerPatternPaint());
        sGSelectablePaint.setGradationPaint(this.getInnerGradationPaint());
        sGSelectablePaint.setSelectedPaintStyle(this.getInnerColorStyle());
        sGSelectablePaint.setTransparency(this.getTransparency().intValue());
        return sGSelectablePaint;
    }

    public Number getLineWidth() {
        return this.mEdgeLineWidthSpinner.getNumber();
    }

    public int getLineType() {
        String string = (String)this.mEdgeLineTypeComboBox.getSelectedItem();
        if (string == null) {
            return -1;
        }
        Integer n = SGDrawingElementLine.getLineTypeFromName(string);
        return n;
    }

    public Number getTransparency() {
        return this.mBackgroundTransparentSpinner.getNumber();
    }

    public boolean setLeftXValue(Object object) {
        return this.setValue(this.mLeftXValueTextField, object);
    }

    public boolean setRightXValue(Object object) {
        return this.setValue(this.mRightXValueTextField, object);
    }

    public boolean setTopYValue(Object object) {
        return this.setValue(this.mTopYValueTextField, object);
    }

    public boolean setBottomYValue(Object object) {
        return this.setValue(this.mBottomYValueTextField, object);
    }

    public boolean setLineColor(Color color) {
        this.mLineColorButton.setColor(color);
        return true;
    }

    public boolean setLineVisible(Boolean bl) {
        this.mEdgeLineVisibleCheckBox.setSelected(bl);
        this.setEdgeLineComponentsEnabled(bl);
        return true;
    }

    private void setEdgeLineComponentsEnabled(Boolean bl) {
        boolean bl2 = true;
        if (bl != null) {
            bl2 = bl;
        }
        this.mEdgeLineTypeLabel.setEnabled(bl2);
        this.mEdgeLineTypeComboBox.setEnabled(bl2);
        this.mEdgeLineWidthLabel.setEnabled(bl2);
        this.mEdgeLineWidthSpinner.setEnabled(bl2);
        this.mLineColorLabel.setEnabled(bl2);
        this.mLineColorButton.setEnabled(bl2);
    }

    public boolean setAnchored(Boolean bl) {
        this.mBoundsAnchoredCheckBox.setSelected(bl);
        return true;
    }

    public boolean setInnerPaint(SGIPaint sGIPaint) {
        if (sGIPaint instanceof SGSelectablePaint) {
            SGSelectablePaint sGSelectablePaint = (SGSelectablePaint)sGIPaint;
            this.setInnerPaintStyle(sGSelectablePaint.getSelectedStyle());
            this.setInnerFillPaintColor(SGFillPaint.getOpaqueColor(sGSelectablePaint.getFillColor()));
            this.setInnerPatternPaint(sGSelectablePaint.getPatternPaint());
            this.setInnerGradationPaint(sGSelectablePaint.getGradationPaint());
            this.setTransparent(sGSelectablePaint.getTransparencyPercent());
            return true;
        }
        if (sGIPaint instanceof SGFillPaint) {
            SGFillPaint sGFillPaint = (SGFillPaint)sGIPaint;
            this.setInnerPaintStyle(0);
            this.setInnerFillPaintColor(SGFillPaint.getOpaqueColor((Color)sGFillPaint.getPaint(null)));
            this.setTransparent(sGFillPaint.getTransparencyPercent());
            return true;
        }
        if (sGIPaint instanceof SGPatternPaint) {
            SGPatternPaint sGPatternPaint = (SGPatternPaint)sGIPaint;
            this.setInnerPaintStyle(1);
            this.setInnerPatternPaint(sGPatternPaint);
            this.setTransparent(sGPatternPaint.getTransparencyPercent());
            return true;
        }
        if (sGIPaint instanceof SGGradationPaint) {
            SGGradationPaint sGGradationPaint = (SGGradationPaint)sGIPaint;
            this.setInnerPaintStyle(2);
            this.setInnerGradationPaint(sGGradationPaint);
            this.setTransparent(sGGradationPaint.getTransparencyPercent());
            return true;
        }
        return false;
    }

    public boolean setInnerFillPaintColor(Color color) {
        this.mInnerFillPaintButton.setColor(color);
        return true;
    }

    public boolean setInnerPatternPaint(SGPatternPaint sGPatternPaint) {
        if (sGPatternPaint != null) {
            this.mInnerPatternPaintButton.setPatternPaint(sGPatternPaint);
            return true;
        }
        return false;
    }

    public boolean setInnerGradationPaint(SGGradationPaint sGGradationPaint) {
        if (sGGradationPaint != null) {
            this.mInnerGradationPaintButton.setGradationPaint(sGGradationPaint);
            return true;
        }
        return false;
    }

    public boolean setInnerPaintStyle(Object object) {
        if (object == null) {
            this.mNoInnerPaintStyleRadioButton.setSelected(true);
            return false;
        }
        Integer n = null;
        try {
            n = Integer.valueOf(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        switch (n) {
            case 0: {
                this.mInnerFillPaintRadioButton.setSelected(true);
                break;
            }
            case 1: {
                this.mInnerPatternPaintRadioButton.setSelected(true);
                break;
            }
            case 2: {
                this.mInnerGradationPaintRadioButton.setSelected(true);
                break;
            }
            default: {
                throw new Error();
            }
        }
        return true;
    }

    public boolean setLineWidth(Object object) {
        return this.setValue(this.mEdgeLineWidthSpinner, object);
    }

    public boolean setLineType(Integer n) {
        if (n != null) {
            String string = SGDrawingElementLine.getLineTypeName(n);
            this.mEdgeLineTypeComboBox.setSelectedItem(string);
        } else {
            this.mEdgeLineTypeComboBox.setSelectedItem(null);
        }
        return true;
    }

    public boolean setTransparent(Integer n) {
        this.setTransparentComponentEnabled(n);
        return this.setValue(this.mBackgroundTransparentSpinner, (Object)Float.valueOf(n.floatValue()));
    }

    private boolean setTransparentComponentEnabled(Integer n) {
        if (n.equals(100)) {
            return this.setTransparentComponentEnabled(Boolean.FALSE);
        }
        return this.setTransparentComponentEnabled(Boolean.TRUE);
    }

    private boolean setTransparentComponentEnabled(Boolean bl) {
        if (this.mTransparentComponentGroup.isEnabled() != bl.booleanValue()) {
            this.mTransparentComponentGroup.setEnabled(bl);
        }
        return true;
    }

    @Override
    protected JButton getOKButton() {
        return this.mOKButton;
    }

    @Override
    protected JButton getCancelButton() {
        return this.mCancelButton;
    }

    @Override
    protected JButton getPreviewButton() {
        return this.mPreviewButton;
    }

    @Override
    protected boolean hasValidInputValues() {
        boolean bl = true;
        if (!super.hasValidInputValues()) {
            bl = false;
        }
        if (!this.hasValidNumber(this.mLeftXValueTextField, null, null)) {
            bl = false;
        }
        if (!this.hasValidNumber(this.mRightXValueTextField, null, null)) {
            bl = false;
        }
        if (!this.hasValidNumber(this.mTopYValueTextField, null, null)) {
            bl = false;
        }
        if (!this.hasValidNumber(this.mBottomYValueTextField, null, null)) {
            bl = false;
        }
        return bl;
    }
}

