/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.SGStroke;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementLine2D;

public abstract class SGSimpleLine2D
extends SGDrawingElementLine2D {
    protected SGTuple2f mStartPoint = new SGTuple2f();
    protected SGTuple2f mEndPoint = new SGTuple2f();
    protected float mMagnification = 1.0f;
    protected Color mColor = null;
    protected SGStroke mStroke = new SGStroke();

    public SGSimpleLine2D() {
    }

    public SGSimpleLine2D(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        super(sGTuple2f, sGTuple2f2);
    }

    public SGSimpleLine2D(float f, float f2, float f3, float f4) {
        super(f, f2, f3, f4);
    }

    public void dispose() {
        super.dispose();
        this.mColor = null;
        this.mStroke = null;
        this.mStartPoint = null;
        this.mEndPoint = null;
    }

    public float getMagnification() {
        return this.mMagnification;
    }

    public boolean setMagnification(float f) {
        if ((double)f <= 0.0) {
            throw new IllegalArgumentException("mag <= 0.0");
        }
        this.mMagnification = f;
        this.mStroke.setMagnification(f);
        return true;
    }

    protected SGStroke getStroke() {
        return this.mStroke;
    }

    public boolean setLineWidth(float f, String string) {
        double d = SGUtilityText.convertToPoint(f, string);
        return this.setLineWidth((float)d);
    }

    public boolean setLineWidth(float f) {
        this.getStroke().setLineWidth(f);
        return true;
    }

    public boolean setLineType(int n) {
        this.getStroke().setLineType(n);
        return true;
    }

    public Color getColor() {
        return this.mColor;
    }

    public boolean setColor(Color color) {
        this.mColor = color;
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof SGDrawingElementLine.LineProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        SGDrawingElementLine.LineProperties lineProperties = (SGDrawingElementLine.LineProperties)sGProperties;
        Float f = lineProperties.getLineWidth();
        if (f == null) {
            return false;
        }
        Integer n = lineProperties.getLineType();
        if (n == null) {
            return false;
        }
        this.setLineWidth(f.floatValue());
        this.setLineType(n);
        return true;
    }

    public boolean setTermPoints(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        this.mStartPoint = sGTuple2f;
        this.mEndPoint = sGTuple2f2;
        return true;
    }

    public SGTuple2f getStart() {
        return this.mStartPoint;
    }

    public SGTuple2f getEnd() {
        return this.mEndPoint;
    }
}

