/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import jp.riken.brain.ni.samuraigraph.base.SGFillPaint;
import jp.riken.brain.ni.samuraigraph.base.SGGradationPaint;
import jp.riken.brain.ni.samuraigraph.base.SGIPaint;
import jp.riken.brain.ni.samuraigraph.base.SGPatternPaint;
import jp.riken.brain.ni.samuraigraph.base.SGSelectablePaint;
import jp.riken.brain.ni.samuraigraph.base.SGTransparentPaint;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.SGStroke;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementRectangle2D;

public class SGSimpleRectangle2D
extends SGDrawingElementRectangle2D {
    protected float mX;
    protected float mY;
    protected float mMagnification = 1.0f;
    protected float mWidth;
    protected float mHeight;
    protected int mEdgeLineType;
    protected Color mEdgeLineColor;
    protected boolean mEdgeLineVisible;
    protected SGIPaint mInnerPaint = new SGSelectablePaint();
    protected SGStroke mStroke = new SGStroke();

    public SGSimpleRectangle2D() {
        this.mStroke.setJoin(0);
    }

    public void dispose() {
        super.dispose();
        this.mEdgeLineColor = null;
        this.mStroke = null;
        this.mInnerPaint = null;
    }

    public float getWidth() {
        return this.mWidth;
    }

    public float getHeight() {
        return this.mHeight;
    }

    public float getEdgeLineWidth() {
        return this.mStroke.getLineWidth();
    }

    public Color getEdgeLineColor() {
        return this.mEdgeLineColor;
    }

    public boolean isEdgeLineVisible() {
        return this.mEdgeLineVisible;
    }

    public SGIPaint getInnerPaint() {
        try {
            return (SGIPaint)this.mInnerPaint.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.getMessage());
        }
    }

    public int getEdgeLineType() {
        return this.mEdgeLineType;
    }

    public float getTransparency() {
        return this.mInnerPaint.getAlpha();
    }

    public boolean setWidth(float f) {
        this.mWidth = f;
        return true;
    }

    public boolean setHeight(float f) {
        this.mHeight = f;
        return true;
    }

    public boolean setEdgeLineWidth(float f) {
        this.mStroke.setLineWidth(f);
        return true;
    }

    public boolean setEdgeLineType(int n) {
        if (!SGDrawingElementLine.isValidLineType(n)) {
            return false;
        }
        this.mEdgeLineType = n;
        this.mStroke.setLineType(n);
        return true;
    }

    public boolean setEdgeLineColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color == null");
        }
        this.mEdgeLineColor = color;
        return true;
    }

    public boolean setEdgeLineVisible(boolean bl) {
        this.mEdgeLineVisible = bl;
        return true;
    }

    public boolean setInnerPaint(SGIPaint sGIPaint) {
        if (null == sGIPaint) {
            throw new IllegalArgumentException("paint == null");
        }
        this.mInnerPaint = sGIPaint;
        return true;
    }

    public boolean setInnerPaintStyle(int n) {
        if (this.mInnerPaint instanceof SGSelectablePaint) {
            return ((SGSelectablePaint)this.mInnerPaint).setSelectedPaintStyle(n);
        }
        return false;
    }

    public boolean setInnerFillColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color == null");
        }
        if (this.mInnerPaint instanceof SGFillPaint) {
            return ((SGFillPaint)this.mInnerPaint).setColor(color);
        }
        if (this.mInnerPaint instanceof SGSelectablePaint) {
            return ((SGSelectablePaint)this.mInnerPaint).setFillColor(color);
        }
        return false;
    }

    public boolean setInnerPatternColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color == null");
        }
        if (this.mInnerPaint instanceof SGPatternPaint) {
            return ((SGPatternPaint)this.mInnerPaint).setColor(color);
        }
        if (this.mInnerPaint instanceof SGSelectablePaint) {
            return ((SGSelectablePaint)this.mInnerPaint).setPatternColor(color);
        }
        return false;
    }

    public boolean setInnerPatternType(int n) {
        if (this.mInnerPaint instanceof SGPatternPaint) {
            return ((SGPatternPaint)this.mInnerPaint).setTypeIndex(n);
        }
        if (this.mInnerPaint instanceof SGSelectablePaint) {
            return ((SGSelectablePaint)this.mInnerPaint).setPatternIndex(n);
        }
        return false;
    }

    public boolean setInnerGradationColor1(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color == null");
        }
        if (this.mInnerPaint instanceof SGGradationPaint) {
            return ((SGGradationPaint)this.mInnerPaint).setColor1(color);
        }
        if (this.mInnerPaint instanceof SGSelectablePaint) {
            return ((SGSelectablePaint)this.mInnerPaint).setGradationColor1(color);
        }
        return false;
    }

    public boolean setInnerGradationColor2(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color == null");
        }
        if (this.mInnerPaint instanceof SGGradationPaint) {
            return ((SGGradationPaint)this.mInnerPaint).setColor2(color);
        }
        if (this.mInnerPaint instanceof SGSelectablePaint) {
            return ((SGSelectablePaint)this.mInnerPaint).setGradationColor2(color);
        }
        return false;
    }

    public boolean setInnerGradationDirection(int n) {
        if (this.mInnerPaint instanceof SGGradationPaint) {
            return ((SGGradationPaint)this.mInnerPaint).setDirection(n);
        }
        if (this.mInnerPaint instanceof SGSelectablePaint) {
            return ((SGSelectablePaint)this.mInnerPaint).setGradationDirection(n);
        }
        return false;
    }

    public boolean setInnerGradationOrder(int n) {
        if (this.mInnerPaint instanceof SGGradationPaint) {
            return ((SGGradationPaint)this.mInnerPaint).setOrder(n);
        }
        if (this.mInnerPaint instanceof SGSelectablePaint) {
            return ((SGSelectablePaint)this.mInnerPaint).setGradationOrder(n);
        }
        return false;
    }

    public boolean setTransparent(float f) {
        return this.mInnerPaint.setAlpha(f);
    }

    public boolean setTransparent(int n) {
        return ((SGTransparentPaint)this.mInnerPaint).setTransparency(n);
    }

    public boolean setMagnification(float f) {
        if ((double)f <= 0.0) {
            throw new IllegalArgumentException("mag <= 0.0");
        }
        this.mMagnification = f;
        this.mStroke.setMagnification(f);
        this.mInnerPaint.setMagnification(f);
        return true;
    }

    protected SGStroke getStroke() {
        return this.mStroke;
    }

    public float getMagnification() {
        return this.mMagnification;
    }

    public float getX() {
        return this.mX;
    }

    public float getY() {
        return this.mY;
    }

    public boolean setX(float f) {
        this.mX = f;
        return true;
    }

    public boolean setY(float f) {
        this.mY = f;
        return true;
    }
}

