/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.java;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.ImageGraphicAttribute;
import java.awt.font.ShapeGraphicAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ConvolveOp;
import java.awt.image.ImageObserver;
import java.awt.image.Kernel;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TooManyListenersException;
import java.util.TreeSet;
import org.freehep.graphics2d.TagString;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.java.JAVAArrayMap;
import org.freehep.graphicsio.png.PNGEncoder;
import org.freehep.util.UserProperties;
import org.freehep.util.Value;
import org.freehep.util.io.IndentPrintWriter;
import org.freehep.util.io.LineNumberWriter;

public class JAVAGraphics2D
extends VectorGraphics
implements LineNumberWriter.LineNumberListener {
    private static final int MAX_LINES_PER_METHOD = 200;
    private Map vg = new HashMap();
    private SortedSet imports = new TreeSet();
    private Value vgIndex = new Value().set(0);
    private Value paintSequenceNo = new Value().set(0);
    private Value blockLevel = new Value().set(0);
    private UserProperties properties;
    private int width = 800;
    private int height = 600;
    private String className = "TemporaryName";
    private OutputStream os;
    private ByteArrayOutputStream bos;
    private LineNumberWriter lineWriter;
    private IndentPrintWriter out;
    private Color backgroundColor;
    private Color color = Color.WHITE;
    private Paint paint = Color.BLACK;
    private String creator = "FreeHEP JAVAGraphics2D";
    private int colorMode = 0;
    private Stroke stroke = new BasicStroke();
    private AffineTransform transform = new AffineTransform();
    private RenderingHints hints = new RenderingHints(null);
    private boolean isDeviceIndependent;
    private Composite composite;
    private Shape clip;
    private Font font = new Font("Serif", 0, 12);
    private static final String rootKey = JAVAGraphics2D.class.getName();
    public static final String PACKAGE_NAME = rootKey + ".PackageName";
    public static final String COMPLETE_IMAGE_PATHS = rootKey + ".CompleteImagePath";
    public static final String EMBED_IMAGES = rootKey + ".EmbedImages";
    private static final UserProperties defaultProperties = new UserProperties();
    private static final String imagePrefix = "-image-";
    private String classPath;
    public static final String version = "$Revision: 1.1 $";
    private static int attributedStringCounter;
    private static int imageCounter;

    public static Properties getDefaultProperties() {
        return defaultProperties;
    }

    public static void setDefaultProperties(Properties newProperties) {
        defaultProperties.setProperties(newProperties);
    }

    public JAVAGraphics2D(File file, Dimension size) throws FileNotFoundException {
        this((OutputStream)new FileOutputStream(file), size);
        this.init(file);
    }

    public JAVAGraphics2D(File file, Component component) throws FileNotFoundException {
        this((OutputStream)new FileOutputStream(file), component);
        this.init(file);
    }

    public JAVAGraphics2D(OutputStream os, Dimension size) {
        this.init(os);
        this.width = size.width;
        this.height = size.height;
    }

    public JAVAGraphics2D(OutputStream os, Component component) {
        this.init(os);
        this.width = component.getWidth();
        this.height = component.getHeight();
        this.font = component.getFont();
        this.color = component.getForeground();
        this.paint = component.getForeground();
        this.backgroundColor = component.getBackground();
    }

    private void init(File file) {
        this.init();
        String name = file.getName();
        this.className = name.substring(0, name.lastIndexOf(".java"));
        this.classPath = file.getParentFile().getAbsolutePath().replace('\\', '/') + "/";
    }

    private void init(OutputStream os) {
        this.init();
        this.os = os;
        this.vg.put(this, new Integer(this.vgIndex.getInt()));
        this.bos = new ByteArrayOutputStream();
        this.lineWriter = new LineNumberWriter((Writer)new OutputStreamWriter(this.bos));
        this.lineWriter.setLineNumber(1);
        this.out = new IndentPrintWriter((Writer)this.lineWriter);
        this.out.setIndentString("    ");
        try {
            this.lineWriter.addLineNumberListener((LineNumberWriter.LineNumberListener)this, 200);
        }
        catch (TooManyListenersException tmle) {
            System.err.println(tmle);
        }
    }

    private void init() {
        this.initProperties(JAVAGraphics2D.getDefaultProperties());
        this.isDeviceIndependent = false;
        this.composite = AlphaComposite.getInstance(3);
    }

    protected JAVAGraphics2D(JAVAGraphics2D graphics) {
        this.vg = graphics.vg;
        this.vgIndex = graphics.vgIndex;
        this.imports = graphics.imports;
        this.paintSequenceNo = graphics.paintSequenceNo;
        this.blockLevel = graphics.blockLevel;
        this.properties = graphics.properties;
        this.width = graphics.width;
        this.height = graphics.height;
        this.className = graphics.className;
        this.os = graphics.os;
        this.bos = graphics.bos;
        this.out = graphics.out;
        this.backgroundColor = graphics.backgroundColor;
        this.color = graphics.color;
        this.paint = graphics.paint;
        this.creator = graphics.creator;
        this.colorMode = graphics.colorMode;
        this.stroke = graphics.stroke;
        this.transform = graphics.transform;
        this.hints = graphics.hints;
        this.isDeviceIndependent = graphics.isDeviceIndependent;
        this.composite = graphics.composite;
        this.clip = graphics.clip;
        this.font = graphics.font;
        this.vgIndex.set(this.vgIndex.getInt() + 1);
        this.vg.put(this, new Integer(this.vgIndex.getInt()));
    }

    public void setProperties(Properties newProperties) {
        if (newProperties == null) {
            return;
        }
        this.properties.setProperties(newProperties);
    }

    protected void initProperties(Properties defaults) {
        this.properties = new UserProperties();
        this.properties.setProperties(defaults);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public Color getPropertyColor(String key) {
        return this.properties.getPropertyColor(key);
    }

    public Rectangle getPropertyRectangle(String key) {
        return this.properties.getPropertyRectangle(key);
    }

    public Insets getPropertyInsets(String key) {
        return this.properties.getPropertyInsets(key);
    }

    public Dimension getPropertyDimension(String key) {
        return this.properties.getPropertyDimension(key);
    }

    public int getPropertyInt(String key) {
        return this.properties.getPropertyInt(key);
    }

    public double getPropertyDouble(String key) {
        return this.properties.getPropertyDouble(key);
    }

    public boolean isProperty(String key) {
        return this.properties.isProperty(key);
    }

    public void clearRect(int x, int y, int width, int height) {
        this.out.println(this.vg() + ".clearRect(" + x + ", " + y + ", " + width + ", " + height + ");");
    }

    public void clipRect(int x, int y, int width, int height) {
        this.out.println(this.vg() + ".clipRect(" + x + ", " + y + ", " + width + ", " + height + ");");
        this.clip = new Rectangle(x, y, width, height);
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.out.println(this.vg() + ".copyArea(" + x + ", " + y + ", " + width + ", " + height + ", " + dx + ", " + dy + ");");
    }

    public Graphics create() {
        JAVAGraphics2D g = new JAVAGraphics2D(this);
        this.out.println(g.vg() + " = (VectorGraphics)" + this.vg() + ".create();");
        return g;
    }

    public Graphics create(int x, int y, int width, int height) {
        JAVAGraphics2D g = new JAVAGraphics2D(this);
        this.out.println(g.vg() + " = (VectorGraphics)" + this.vg() + ".create(" + x + ", " + y + ", " + width + ", " + height + ");");
        return g;
    }

    public Graphics create(double x, double y, double width, double height) {
        JAVAGraphics2D g = new JAVAGraphics2D(this);
        this.out.println(g.vg() + " = (VectorGraphics)" + this.vg() + ".create(" + x + ", " + y + ", " + width + ", " + height + ");");
        return g;
    }

    public void dispose() {
        this.out.println(this.vg() + ".dispose();");
    }

    public void draw3DRect(int x, int y, int width, int height, boolean raised) {
        this.out.println(this.vg() + ".draw3DRect(" + x + ", " + y + ", " + width + ", " + height + ", " + raised + ");");
    }

    public void fill3DRect(int x, int y, int width, int height, boolean raised) {
        this.out.println(this.vg() + ".fill3DRect(" + x + ", " + y + ", " + width + ", " + height + ", " + raised + ");");
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.out.println(this.vg() + ".drawArc(" + x + ", " + y + ", " + width + ", " + height + ", " + startAngle + ", " + arcAngle + ");");
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.out.println(this.vg() + ".drawArc(" + x + ", " + y + ", " + width + ", " + height + ", " + startAngle + ", " + arcAngle + ");");
    }

    public void drawBytes(byte[] data, int offset, int length, int x, int y) {
        this.out.print(this.vg() + ".drawBytes(");
        this.write(data, offset + length);
        this.out.println(", " + offset + ", " + length + ", " + x + ", " + y + ");");
    }

    public void drawChars(char[] data, int offset, int length, int x, int y) {
        this.block();
        this.out.print(this.vg() + ".drawChars(");
        this.write(data, offset + length);
        this.unblock();
        this.out.println(", " + offset + ", " + length + ", " + x + ", " + y + ");");
    }

    public boolean drawImage(Image image, int x, int y, ImageObserver observer) {
        this.block();
        this.out.print(this.vg() + ".drawImage(");
        this.write(image);
        this.unblock();
        this.out.println(", " + x + ", " + y + ", " + "null" + ");");
        return true;
    }

    public boolean drawImage(Image image, int x, int y, int width, int height, ImageObserver observer) {
        this.block();
        this.out.print(this.vg() + ".drawImage(");
        this.write(image);
        this.unblock();
        this.out.println(", " + x + ", " + y + ", " + width + ", " + height + ", " + "null" + ");");
        return true;
    }

    public boolean drawImage(Image image, int x, int y, Color bgColor, ImageObserver observer) {
        this.block();
        this.out.print(this.vg() + ".drawImage(");
        this.write(image);
        this.out.print(", " + x + ", " + y + ", ");
        this.write(bgColor);
        this.unblock();
        this.out.println(", null);");
        return true;
    }

    public boolean drawImage(Image image, int x, int y, int width, int height, Color bgColor, ImageObserver observer) {
        this.block();
        this.out.print(this.vg() + ".drawImage(");
        this.write(image);
        this.out.print(", " + x + ", " + y + ", " + width + ", " + height + ", ");
        this.write(bgColor);
        this.unblock();
        this.out.println(", null);");
        return true;
    }

    public boolean drawImage(Image image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        this.block();
        this.out.print(this.vg() + ".drawImage(");
        this.write(image);
        this.out.print(", " + dx1 + ", " + dy1 + ", " + dx2 + ", " + dy2);
        this.out.print(", " + sx1 + ", " + sy1 + ", " + sx2 + ", " + sy2);
        this.unblock();
        this.out.println(", null);");
        return true;
    }

    public boolean drawImage(Image image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgColor, ImageObserver observer) {
        this.block();
        this.out.print(this.vg() + ".drawImage(");
        this.write(image);
        this.out.print(", " + dx1 + ", " + dy1 + ", " + dx2 + ", " + dy2);
        this.out.print(", " + sx1 + ", " + sy1 + ", " + sx2 + ", " + sy2 + ", ");
        this.write(bgColor);
        this.unblock();
        this.out.println(", null);");
        return true;
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.out.println(this.vg() + ".drawLine(" + x1 + ", " + y1 + ", " + x2 + ", " + y2 + ");");
    }

    public void drawOval(int x, int y, int width, int height) {
        this.out.println(this.vg() + ".drawOval(" + x + ", " + y + ", " + width + ", " + height + ");");
    }

    public void fillOval(int x, int y, int width, int height) {
        this.out.println(this.vg() + ".fillOval(" + x + ", " + y + ", " + width + ", " + height + ");");
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.block();
        this.out.print(this.vg() + ".drawPolygon(");
        this.write(xPoints);
        this.out.print(", ");
        this.write(yPoints);
        this.unblock();
        this.out.println(", " + nPoints + ");");
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.block();
        this.out.print(this.vg() + ".fillPolygon(");
        this.write(xPoints);
        this.out.print(", ");
        this.write(yPoints);
        this.unblock();
        this.out.println(", " + nPoints + ");");
    }

    public void drawPolygon(Polygon p) {
        this.block();
        this.out.print(this.vg() + ".drawPolygon(");
        this.write(p);
        this.unblock();
        this.out.println(");");
    }

    public void fillPolygon(Polygon p) {
        this.block();
        this.out.print(this.vg() + ".fillPolygon(");
        this.write(p);
        this.unblock();
        this.out.println(");");
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.block();
        this.out.print(this.vg() + ".drawPolyline(");
        this.write(xPoints);
        this.out.print(", ");
        this.write(yPoints);
        this.unblock();
        this.out.println(", " + nPoints + ");");
    }

    public void drawRect(int x, int y, int width, int height) {
        this.out.println(this.vg() + ".drawRect(" + x + ", " + y + ", " + width + ", " + height + ");");
    }

    public void fillRect(int x, int y, int width, int height) {
        this.out.println(this.vg() + ".fillRect(" + x + ", " + y + ", " + width + ", " + height + ");");
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.out.println(this.vg() + ".drawRoundRect(" + x + ", " + y + ", " + width + ", " + height + ", " + arcWidth + ", " + arcHeight + ");");
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.out.println(this.vg() + ".fillRoundRect(" + x + ", " + y + ", " + width + ", " + height + ", " + arcWidth + ", " + arcHeight + ");");
    }

    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.drawString(iterator, (float)x, (float)y);
    }

    public void drawString(String str, int x, int y) {
        this.block();
        this.out.print(this.vg() + ".drawString(");
        this.write(str);
        this.unblock();
        this.out.println(", " + x + ", " + y + ");");
    }

    public void finalize() {
        this.out.println(this.vg() + ".finalize();");
        super.finalize();
    }

    public Shape getClip() {
        return this.clip;
    }

    public Rectangle getClipBounds() {
        return this.clip == null ? null : this.clip.getBounds();
    }

    public Rectangle getClipBounds(Rectangle r) {
        Rectangle c = this.getClipBounds();
        if (c != null) {
            r.x = c.x;
            r.y = c.y;
            r.width = c.width;
            r.height = c.height;
        }
        return r;
    }

    public Color getColor() {
        return this.color;
    }

    public Font getFont() {
        return this.font;
    }

    public FontMetrics getFontMetrics() {
        return this.getFontMetrics(this.getFont());
    }

    public FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public boolean hitClip(int x, int y, int width, int height) {
        return this.clip.intersects(x, y, width, height);
    }

    public void setClip(int x, int y, int width, int height) {
        this.out.println(this.vg() + ".setClip(" + x + ", " + y + ", " + width + ", " + height + ");");
        this.clip = new Rectangle(x, y, width, height);
    }

    public void setClip(Shape clip) {
        this.block();
        this.out.print(this.vg() + ".setClip(");
        this.write(clip);
        this.unblock();
        this.out.println(");");
        this.clip = clip;
    }

    public void setColor(Color c) {
        this.block();
        this.out.print(this.vg() + ".setColor(");
        this.write(c);
        this.unblock();
        this.out.println(");");
        this.color = c;
    }

    public void setFont(Font font) {
        this.block();
        this.out.print(this.vg() + ".setFont(");
        this.write(font);
        this.unblock();
        this.out.println(");");
        this.font = font;
    }

    public void setPaintMode() {
        this.out.println(this.vg() + ".setPaintMode();");
    }

    public void setXORMode(Color c1) {
        this.block();
        this.out.print(this.vg() + ".setXORMode(");
        this.write(c1);
        this.unblock();
        this.out.println(");");
    }

    public String toString() {
        return "JavaGraphics2D";
    }

    public void translate(int x, int y) {
        this.out.println(this.vg() + ".translate(" + x + ", " + y + ");");
    }

    public void addRenderingHints(Map hints) {
        hints.putAll(hints);
        this.out.print(this.vg() + ".addRenderingHints(");
        this.writeHintMap(hints);
        this.out.println(");");
    }

    public void clip(Shape s) {
        this.block();
        this.out.print(this.vg() + ".clip(");
        this.write(s);
        this.unblock();
        this.out.println(");");
        this.clip = s;
    }

    public void draw(Shape s) {
        this.block();
        this.out.print(this.vg() + ".draw(");
        this.write(s);
        this.unblock();
        this.out.println(");");
    }

    public void drawGlyphVector(GlyphVector g, float x, float y) {
        this.fill(g.getOutline(x, y));
    }

    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        if (op instanceof AffineTransformOp) {
            this.out.print(this.vg() + ".drawImage(");
            this.out.indent();
            this.write(img);
            this.out.println(",");
            this.write((AffineTransformOp)op);
            this.out.println(",");
            this.out.println(x + ", " + y + ");");
            this.out.outdent();
        } else if (op instanceof ConvolveOp) {
            this.out.print(this.vg() + ".drawImage(");
            this.out.indent();
            this.write(img);
            this.out.println(",");
            this.write((ConvolveOp)op);
            this.out.println(",");
            this.out.println(x + ", " + y + ");");
            this.out.outdent();
        } else {
            this.out.println("System.err.println(\"" + ((Object)((Object)this)).getClass() + ": drawImage(BufferedImage, BufferedImageOp, int, int) not implemented.\");");
        }
    }

    private void write(ConvolveOp op) {
        if (op == null) {
            this.out.print("null");
            return;
        }
        this.imports.add("java.awt.image.ConvolveOp");
        this.out.print("new ConvolveOp(");
        this.write(op.getKernel());
        this.out.print(", ");
        this.out.print(op.getEdgeCondition());
        this.out.print(", ");
        if (op.getRenderingHints() != null) {
            this.out.print("new RenderingHints(");
            this.writeHintMap(op.getRenderingHints());
            this.out.print(")");
        } else {
            this.out.print("null");
        }
        this.out.print(")");
    }

    private void writeHintMap(Map hints) {
        if (hints == null) {
            this.out.print("null");
            return;
        }
        this.imports.add("org.freehep.graphicsio.java.JAVAArrayMap");
        this.out.print("new JAVAArrayMap(new Object[] {");
        Iterator keys = hints.keySet().iterator();
        while (keys.hasNext()) {
            Object value;
            String valueString;
            Object key = keys.next();
            String keyString = (String)JAVAArrayMap.HINTS.get(key);
            if (keyString == null || (valueString = (String)JAVAArrayMap.HINTS.get(value = hints.get(key))) == null) continue;
            this.out.print(keyString);
            this.out.print(", ");
            this.out.print(valueString);
            if (!keys.hasNext()) continue;
            this.out.print(", ");
        }
        this.out.print("})");
    }

    private void write(Kernel kernel) {
        this.imports.add("java.awt.image.Kernel");
        this.out.print("new Kernel(");
        this.out.print(kernel.getWidth());
        this.out.print(", ");
        this.out.print(kernel.getHeight());
        this.out.print(", ");
        this.write(kernel.getKernelData(null));
        this.out.print(")");
    }

    private void write(AffineTransformOp op) {
        this.imports.add("java.awt.image.AffineTransformOp");
        this.out.print("new AffineTransformOp(");
        this.write(op.getTransform());
        this.out.print(", ");
        this.out.print(op.getInterpolationType());
        this.out.print(")");
    }

    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        this.out.println(this.vg() + ".drawImage(");
        this.out.indent();
        this.write(img);
        this.out.println(",");
        this.write(xform);
        this.out.println(",");
        this.out.println("null);");
        this.out.outdent();
        return true;
    }

    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        this.out.println("System.err.println(\"" + ((Object)((Object)this)).getClass() + ": drawRenderableImage(RenderableImage, AffineTransform) not implemented.\");");
    }

    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        this.out.println("System.err.println(\"" + ((Object)((Object)this)).getClass() + ": drawRenderedImage(RenderedImage, AffineTransform) not implemented.\");");
    }

    private HashSet getAttributes(AttributedCharacterIterator iterator, HashSet imports, StringBuffer text) {
        HashSet<String> result = new HashSet<String>(0);
        char c = iterator.first();
        while (c != '\uffff') {
            text.append(c);
            Map<AttributedCharacterIterator.Attribute, Object> attributes = iterator.getAttributes();
            Iterator<AttributedCharacterIterator.Attribute> keys = attributes.keySet().iterator();
            while (keys.hasNext()) {
                StringBuffer attribute = new StringBuffer();
                AttributedCharacterIterator.Attribute key = keys.next();
                Object value = attributes.get(key);
                String className = key.getClass().getName();
                attribute.append(".addAttribute(");
                attribute.append(className.substring(className.lastIndexOf(".") + 1));
                attribute.append(".");
                imports.add(className);
                String keyName = key.toString().substring(key.toString().lastIndexOf("(") + 1, key.toString().lastIndexOf(")"));
                attribute.append(keyName.toUpperCase());
                attribute.append(", ");
                IndentPrintWriter old = this.out;
                StringWriter s = new StringWriter(0);
                this.out = new IndentPrintWriter((Writer)s);
                if (value instanceof String || value == null) {
                    this.write((String)value);
                } else if (value instanceof Float) {
                    this.write((Float)value);
                } else if (value instanceof Double) {
                    this.write((Double)value);
                } else if (value instanceof Integer) {
                    this.write((Integer)value);
                } else if (value instanceof Byte) {
                    this.write((Byte)value);
                } else if (value instanceof Boolean) {
                    this.write((Boolean)value);
                } else if (value instanceof Paint) {
                    this.write((Paint)value);
                } else if (value instanceof Dimension) {
                    this.write((Dimension)value);
                } else if (value instanceof AffineTransform) {
                    this.write((AffineTransform)value);
                } else if (value instanceof Font) {
                    this.write((Font)value);
                } else if (value instanceof ImageGraphicAttribute) {
                    this.write((ImageGraphicAttribute)value);
                } else if (value instanceof ShapeGraphicAttribute) {
                    this.write((ShapeGraphicAttribute)value);
                } else {
                    this.write(value.toString());
                }
                this.out.close();
                attribute.append(s.getBuffer());
                this.out = old;
                attribute.append(", ");
                attribute.append(iterator.getRunStart(key));
                attribute.append(", ");
                attribute.append(iterator.getRunLimit(key));
                attribute.append(");");
                result.add(attribute.toString());
            }
            c = iterator.next();
        }
        return result;
    }

    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        this.imports.add("java.text.AttributedString");
        String asName = "as" + attributedStringCounter++;
        StringBuffer attributeName = new StringBuffer();
        HashSet attributeImports = new HashSet(0);
        Iterator attributes = this.getAttributes(iterator, attributeImports, attributeName).iterator();
        this.imports.addAll(attributeImports);
        this.out.print("AttributedString ");
        this.out.print(asName);
        this.out.print("= new AttributedString(\"");
        this.out.print(attributeName.toString());
        this.out.println("\");");
        while (attributes.hasNext()) {
            this.out.print(asName);
            this.out.println(attributes.next());
        }
        this.out.print(this.vg());
        this.out.print(".drawString(");
        this.out.print(asName);
        this.out.print(".getIterator(), ");
        this.out.print(x);
        this.out.print("f, ");
        this.out.print(y);
        this.out.println("f);");
    }

    private void write(Boolean b) {
        if (b.booleanValue()) {
            this.out.print("Boolean.TRUE");
        } else {
            this.out.print("Boolean.FALSE");
        }
    }

    private void write(Byte b) {
        this.out.print("new Byte(");
        this.out.print((int)b.byteValue());
        this.out.print("b)");
    }

    private void write(Float f) {
        this.out.print("new Float(");
        this.out.print(f.floatValue());
        this.out.print("f)");
    }

    private void write(Double d) {
        this.out.print("new Double(");
        this.out.print(d.doubleValue());
        this.out.print(")");
    }

    private void write(Integer i) {
        this.out.print("new Integer(");
        this.out.print(i.intValue());
        this.out.print(")");
    }

    private void write(Dimension d) {
        this.imports.add("java.awt.Dimension");
        this.out.print("new Dimension(");
        this.out.print(d.getWidth());
        this.out.print(", ");
        this.out.print(d.getHeight());
        this.out.print(")");
    }

    private void write(ImageGraphicAttribute iga) {
        this.imports.add("java.awt.font.ImageGraphicAttribute");
        this.out.print("new ImageGraphicAttribute(");
        this.write(new BufferedImage(1, 1, 2));
        this.out.print("/* ImageGraphicAttribute.getImage() not supported */");
        this.out.print(", ");
        this.out.print(iga.getAlignment());
        this.out.print(", ");
        this.out.print(-iga.getBounds().getX());
        this.out.print(", ");
        this.out.print(-iga.getBounds().getY());
        this.out.print(")");
    }

    private void write(ShapeGraphicAttribute sga) {
        this.imports.add("java.awt.font.ShapeGraphicAttribute");
        this.out.print("new ShapeGraphicAttribute(");
        this.write(sga.getBounds().getBounds2D());
        this.out.print("/* ShapeGraphicAttribute.getShape() not supported */");
        this.out.print(", ");
        this.out.print(sga.getAlignment());
        this.out.print(", ");
        this.write(new BasicStroke());
        this.out.print("/* ShapeGraphicAttribute.getStroke() not supported */");
        this.out.print(")");
    }

    public void drawString(String str, float x, float y) {
        this.block();
        this.out.print(this.vg() + ".drawString(");
        this.write(str);
        this.unblock();
        this.out.println(", " + x + ", " + y + ");");
    }

    public void fill(Shape s) {
        this.block();
        this.out.print(this.vg() + ".fill(");
        this.write(s);
        this.unblock();
        this.out.println(");");
    }

    public Color getBackground() {
        return this.backgroundColor;
    }

    public Composite getComposite() {
        return this.composite;
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return null;
    }

    public FontRenderContext getFontRenderContext() {
        return new FontRenderContext(new AffineTransform(), false, false);
    }

    public Paint getPaint() {
        return this.paint;
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        return this.hints.get(key);
    }

    public RenderingHints getRenderingHints() {
        return this.hints;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        this.out.println("System.err.println(\"" + ((Object)((Object)this)).getClass() + ": hit(Rectangle, Shape, boolean) not implemented.\");");
        return false;
    }

    public void rotate(double theta) {
        this.out.println(this.vg() + ".rotate(" + theta + ");");
    }

    public void rotate(double theta, double x, double y) {
        this.out.println(this.vg() + ".rotate(" + theta + ", " + x + ", " + y + ");");
    }

    public void scale(double sx, double sy) {
        this.out.println(this.vg() + ".scale(" + sx + ", " + sy + ");");
    }

    public void setBackground(Color c) {
        this.block();
        this.out.print(this.vg() + ".setBackground(");
        this.write(c);
        this.unblock();
        this.out.println(");");
        this.backgroundColor = c;
    }

    public void setComposite(Composite c) {
        if (c instanceof AlphaComposite) {
            this.block();
            this.out.print(this.vg() + ".setComposite(");
            this.write((AlphaComposite)c);
            this.unblock();
            this.out.println(");");
        } else {
            this.out.println("System.err.println(\"" + ((Object)((Object)this)).getClass() + ": setComposite(Composite) not implemented.\");");
        }
        this.composite = c;
    }

    public void setPaint(Paint p) {
        this.block();
        this.out.print(this.vg() + ".setPaint(");
        this.write(p);
        this.unblock();
        this.out.println(");");
        this.paint = p;
    }

    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        if (hintValue != null) {
            this.hints.put(hintKey, hintValue);
        } else {
            this.hints.remove(hintKey);
        }
        String key = (String)JAVAArrayMap.HINTS.get(hintKey);
        if (key == null) {
            this.out.println("System.err.println(\"" + ((Object)((Object)this)).getClass() + ": setRenderingHint(RenderingHints.Key, Object) key not supported '" + hintKey + "'.\");");
            return;
        }
        String value = (String)JAVAArrayMap.HINTS.get(hintValue);
        if (value == null) {
            this.out.println("System.err.println(\"" + ((Object)((Object)this)).getClass() + ": setRenderingHint(RenderingHints.Key, Object) key not supported '" + hintKey + "'.\");");
            return;
        }
        this.imports.add("java.awt.RenderingHints");
        this.out.print(this.vg() + ".setRenderingHint(");
        this.out.print(key);
        this.out.print(", ");
        this.out.print(value);
        this.out.println(");");
    }

    public void setRenderingHints(Map hints) {
        this.hints = new RenderingHints(hints);
        this.out.print(this.vg() + ".setRenderingHints(");
        this.writeHintMap(hints);
        this.out.println(");");
    }

    public void setStroke(Stroke s) {
        if (s instanceof BasicStroke) {
            this.block();
            this.out.print(this.vg() + ".setStroke(");
            this.write((BasicStroke)s);
            this.unblock();
            this.out.println(");");
        } else {
            this.out.println("System.err.println(\"" + ((Object)((Object)this)).getClass() + ": setStroke(Stroke) not implemented.\");");
        }
        this.stroke = s;
    }

    public void setTransform(AffineTransform xform) {
        this.block();
        this.out.print(this.vg() + ".setTransform(");
        this.write(xform);
        this.unblock();
        this.out.println(");");
    }

    public void shear(double shx, double shy) {
        this.out.println(this.vg() + ".shear(" + shx + ", " + shy + ");");
    }

    public void transform(AffineTransform xform) {
        this.block();
        this.out.print(this.vg() + ".transform(");
        this.write(xform);
        this.unblock();
        this.out.println(");");
    }

    public void translate(double tx, double ty) {
        this.out.println(this.vg() + ".translate(" + tx + ", " + ty + ");");
    }

    public void clearRect(double x, double y, double width, double height) {
        this.out.println(this.vg() + ".clearRect(" + x + ", " + y + ", " + width + ", " + height + ");");
    }

    public void clipRect(double x, double y, double width, double height) {
        this.out.println(this.vg() + ".clipRect(" + x + ", " + y + ", " + width + ", " + height + ");");
        this.clip = new Rectangle2D.Double(x, y, width, height);
    }

    public void drawArc(double x, double y, double width, double height, double startAngle, double arcAngle) {
        this.out.println(this.vg() + ".drawArc(" + x + ", " + y + ", " + width + ", " + height + ", " + startAngle + ", " + arcAngle + ");");
    }

    public void drawLine(double x1, double y1, double x2, double y2) {
        this.out.println(this.vg() + ".drawLine(" + x1 + ", " + y1 + ", " + x2 + ", " + y2 + ");");
    }

    public void drawOval(double x, double y, double width, double height) {
        this.out.println(this.vg() + ".drawOval(" + x + ", " + y + ", " + width + ", " + height + ");");
    }

    public void drawPolygon(double[] xPoints, double[] yPoints, int nPoints) {
        this.block();
        this.out.print(this.vg() + ".drawPolygon(");
        this.write(xPoints);
        this.out.print(", ");
        this.write(yPoints);
        this.unblock();
        this.out.println(", " + nPoints + ");");
    }

    public void drawPolyline(double[] xPoints, double[] yPoints, int nPoints) {
        this.block();
        this.out.print(this.vg() + ".drawPolyline(");
        this.write(xPoints);
        this.out.print(", ");
        this.write(yPoints);
        this.unblock();
        this.out.println(", " + nPoints + ");");
    }

    public void drawRect(double x, double y, double width, double height) {
        this.out.println(this.vg() + ".drawRect(" + x + ", " + y + ", " + width + ", " + height + ");");
    }

    public void drawRoundRect(double x, double y, double width, double height, double arcWidth, double arcHeight) {
        this.out.println(this.vg() + ".drawRoundRect(" + x + ", " + y + ", " + width + ", " + height + ", " + arcWidth + ", " + arcHeight + ");");
    }

    public void drawSymbol(int x, int y, int size, int symbol) {
        this.out.println(this.vg() + ".drawSymbol(" + x + ", " + y + ", " + size + ", " + symbol + ");");
    }

    public void fillAndDrawSymbol(int x, int y, int size, int symbol, Color fillColor) {
    }

    public void drawSymbol(double x, double y, double size, int symbol) {
        this.out.println(this.vg() + ".drawSymbol(" + x + ", " + y + ", " + size + ", " + symbol + ");");
    }

    public void fillSymbol(int x, int y, int size, int symbol) {
        this.out.println(this.vg() + ".fillSymbol(" + x + ", " + y + ", " + size + ", " + symbol + ");");
    }

    public void fillSymbol(double x, double y, double size, int symbol) {
        this.out.println(this.vg() + ".fillSymbol(" + x + ", " + y + ", " + size + ", " + symbol + ");");
    }

    public void fillAndDrawSymbol(double x, double y, double size, int symbol, Color fillColor) {
    }

    public void drawString(String str, double x, double y) {
        this.block();
        this.out.print(this.vg() + ".drawString(");
        this.write(str);
        this.unblock();
        this.out.println(", " + x + ", " + y + ");");
    }

    public void drawString(TagString str, double x, double y) {
        this.block();
        this.out.print(this.vg() + ".drawString(");
        this.write(str);
        this.unblock();
        this.out.println(", " + x + ", " + y + ");");
    }

    public void drawString(String str, double x, double y, int horizontal, int vertical) {
        this.block();
        this.out.print(this.vg() + ".drawString(");
        this.write(str);
        this.unblock();
        this.out.println(", " + x + ", " + y + ", " + horizontal + ", " + vertical + ");");
    }

    public void drawString(TagString str, double x, double y, int horizontal, int vertical) {
        this.block();
        this.out.print(this.vg() + ".drawString(");
        this.write(str);
        this.unblock();
        this.out.println(", " + x + ", " + y + ", " + horizontal + ", " + vertical + ");");
    }

    public void drawString(String str, double x, double y, int horizontal, int vertical, boolean framed, Color frameColor, double frameWidth, boolean banner, Color bannerColor) {
        this.block();
        this.out.print(this.vg() + ".drawString(");
        this.write(str);
        this.out.print(", " + x + ", " + y + ", " + horizontal + ", " + vertical + ", " + framed + ", ");
        this.write(frameColor);
        this.out.print(", " + frameWidth + ", " + banner + ", ");
        this.write(bannerColor);
        this.unblock();
        this.out.println(");");
    }

    public void drawString(TagString str, double x, double y, int horizontal, int vertical, boolean framed, Color frameColor, double frameWidth, boolean banner, Color bannerColor) {
        this.block();
        this.out.print(this.vg() + ".drawString(");
        this.write(str);
        this.out.print(", " + x + ", " + y + ", " + horizontal + ", " + vertical + ", " + framed + ", ");
        this.write(frameColor);
        this.out.print(", " + frameWidth + ", " + banner + ", ");
        this.write(bannerColor);
        this.unblock();
        this.out.println(");");
    }

    public void fillAndDraw(Shape s, Color fillColor) {
        this.block();
        this.out.print(this.vg() + ".fillAndDraw(");
        this.write(s);
        this.out.print(", ");
        this.write(fillColor);
        this.unblock();
        this.out.println(");");
    }

    public void fillArc(double x, double y, double width, double height, double startAngle, double arcAngle) {
        this.out.println(this.vg() + ".fillArc(" + x + ", " + y + ", " + width + ", " + height + ", " + startAngle + ", " + arcAngle + ");");
    }

    public void fillOval(double x, double y, double width, double height) {
        this.out.println(this.vg() + ".fillOval(" + x + ", " + y + ", " + width + ", " + height + ");");
    }

    public void fillPolygon(double[] xPoints, double[] yPoints, int nPoints) {
        this.block();
        this.out.print(this.vg() + ".fillPolygon(");
        this.write(xPoints);
        this.out.print(", ");
        this.write(yPoints);
        this.unblock();
        this.out.println(", " + nPoints + ");");
    }

    public void fillRect(double x, double y, double width, double height) {
        this.out.println(this.vg() + ".fillRect(" + x + ", " + y + ", " + width + ", " + height + ");");
    }

    public void fillRoundRect(double x, double y, double width, double height, double arcWidth, double arcHeight) {
        this.out.println(this.vg() + ".fillRoundRect(" + x + ", " + y + ", " + width + ", " + height + ", " + arcWidth + ", " + arcHeight + ");");
    }

    public int getColorMode() {
        return this.colorMode;
    }

    public String getCreator() {
        return this.creator;
    }

    public boolean isDeviceIndependent() {
        return false;
    }

    public void printComment(String comment) {
        this.block();
        this.out.print(this.vg() + ".printComment(");
        this.write(comment);
        this.unblock();
        this.out.println(");");
    }

    public void setClip(double x, double y, double width, double height) {
        this.out.println(this.vg() + ".setClip(" + x + ", " + y + ", " + width + ", " + height + ");");
        this.clip = new Rectangle2D.Double(x, y, width, height);
    }

    public void setColorMode(int colorMode) {
        this.out.println(this.vg() + ".setColorMode(" + colorMode + ");");
        this.colorMode = colorMode;
    }

    public void setCreator(String creator) {
        if (creator != null) {
            this.creator = creator;
        }
    }

    public void setDeviceIndependent(boolean isDeviceIndependent) {
        this.isDeviceIndependent = true;
    }

    public void setLineWidth(int width) {
        this.out.println(this.vg() + ".setLineWidth(" + width + ");");
    }

    public void setLineWidth(double width) {
        this.out.println(this.vg() + ".setLineWidth(" + width + ");");
    }

    public void startExport() {
        this.block();
        this.imports.add("java.awt.Graphics");
        this.imports.add("java.io.IOException");
        this.imports.add("org.freehep.graphics2d.VectorGraphics");
        this.imports.add("org.freehep.graphicsio.test.TestingPanel");
        this.out.println("public class " + this.className + " extends TestingPanel {");
        this.out.println();
        this.out.indent();
        this.out.println("public " + this.className + "(String[] args) throws Exception {");
        this.out.indent();
        this.out.println("super(args);");
        this.out.print("setName(");
        this.write(this.className);
        this.out.println(");");
        this.out.outdent();
        this.out.println("} // contructor");
        this.out.println();
        this.out.println("public void paint(Graphics g) {");
        this.out.indent();
        this.out.println("vg[0] = VectorGraphics.create(g);");
        this.out.print("vg[0].setCreator(");
        this.write(this.creator);
        this.out.println(");");
        this.out.println("try {");
        this.out.indent();
        this.out.println("Paint0s" + this.paintSequenceNo.getInt() + ".paint(vg);");
        this.out.outdent();
        this.out.println("} catch (IOException e) {");
        this.out.indent();
        this.out.println("e.printStackTrace();");
        this.out.outdent();
        this.out.println("}");
        this.out.outdent();
        this.out.println("} // paint");
        this.out.println();
        this.startClass();
        this.unblock();
    }

    public void endExport() {
        this.block();
        this.endClass();
        this.out.println("private VectorGraphics vg[] = new VectorGraphics[" + this.vg.size() + "];");
        this.out.println();
        this.out.println("public static void main(String[] args) throws Exception {");
        this.out.indent();
        this.out.println("new " + this.className + "(args).runTest(" + this.width + ", " + this.height + ");");
        this.out.outdent();
        this.out.println("}");
        this.out.outdent();
        this.out.println("} // class");
        this.out.close();
        this.unblock();
        PrintWriter writer = new PrintWriter(this.os);
        writer.println("// AUTOMATICALLY GENERATED by " + this.creator);
        writer.println();
        if (this.getProperty(PACKAGE_NAME) != null && !this.getProperty(PACKAGE_NAME).equals("")) {
            writer.println("package " + this.getProperty(PACKAGE_NAME) + ";");
            writer.println();
        }
        Iterator i = this.imports.iterator();
        while (i.hasNext()) {
            writer.println("import " + i.next() + ";");
        }
        writer.println();
        writer.print(this.bos.toString());
        writer.close();
    }

    public void lineNumberReached(LineNumberWriter.LineNumberEvent event) {
        if (!this.block()) {
            this.lineWriter.setLineNumber(1);
            this.out.println("Paint0s" + (this.paintSequenceNo.getInt() + 1) + ".paint(vg);");
            this.endClass();
            this.paintSequenceNo.set(this.paintSequenceNo.getInt() + 1);
            this.startClass();
        }
        this.unblock();
    }

    private boolean block() {
        boolean blocked = this.blockLevel.getInt() > 0;
        this.blockLevel.set(this.blockLevel.getInt() + 1);
        return blocked;
    }

    private void unblock() {
        if (this.blockLevel.getInt() > 0) {
            this.blockLevel.set(this.blockLevel.getInt() - 1);
        }
    }

    private void startClass() {
        this.block();
        this.out.println("private static class Paint0s" + this.paintSequenceNo.getInt() + " {");
        this.out.indent();
        this.out.println("public static void paint(VectorGraphics[] vg) throws IOException {");
        this.out.indent();
        this.unblock();
    }

    private void endClass() {
        this.block();
        this.out.outdent();
        this.out.println("} // paint");
        this.out.outdent();
        this.out.println("} // class Paint0s" + this.paintSequenceNo.getInt());
        this.out.println();
        this.unblock();
    }

    private void write(Color c) {
        if (c == null) {
            this.out.print("null");
            return;
        }
        this.imports.add("java.awt.Color");
        this.out.print("new Color(" + c.getRed() + ", " + c.getGreen() + ", " + c.getBlue() + ", " + c.getAlpha() + ")");
    }

    private void write(Font font) {
        if (font == null) {
            this.out.print("null");
            return;
        }
        this.imports.add("java.awt.Font");
        this.out.print("new Font(");
        this.write(font.getName());
        this.out.print(", " + font.getStyle() + ", " + font.getSize() + ")");
    }

    private void write(AffineTransform t) {
        if (t == null) {
            this.out.print("null");
            return;
        }
        double[] m = new double[6];
        t.getMatrix(m);
        this.imports.add("java.awt.geom.AffineTransform");
        this.out.print("new AffineTransform(" + m[0] + ", " + m[1] + ", " + m[2] + ", " + m[3] + ", " + m[4] + ", " + m[5] + ")");
    }

    private void write(Shape s) {
        if (s == null) {
            this.out.print("null");
            return;
        }
        PathIterator i = s.getPathIterator(null);
        this.imports.add("org.freehep.graphicsio.java.JAVAGeneralPath");
        this.out.println("new JAVAGeneralPath(" + i.getWindingRule() + ", new JAVAGeneralPath.PathElement[] {");
        this.out.indent();
        float[] c = new float[6];
        while (!i.isDone()) {
            int type = i.currentSegment(c);
            switch (type) {
                case 0: {
                    this.out.print("new JAVAGeneralPath.MoveTo(" + c[0] + "f, " + c[1] + "f)");
                    break;
                }
                case 1: {
                    this.out.print("new JAVAGeneralPath.LineTo(" + c[0] + "f, " + c[1] + "f)");
                    break;
                }
                case 3: {
                    this.out.print("new JAVAGeneralPath.CurveTo(" + c[0] + "f, " + c[1] + "f, " + c[2] + "f, " + c[3] + "f, " + c[4] + "f, " + c[5] + "f)");
                    break;
                }
                case 2: {
                    this.out.print("new JAVAGeneralPath.QuadTo(" + c[0] + "f, " + c[1] + "f, " + c[2] + "f, " + c[3] + "f)");
                    break;
                }
                case 4: {
                    this.out.print("new JAVAGeneralPath.ClosePath()");
                    break;
                }
            }
            i.next();
            this.out.println(i.isDone() ? "" : ",");
        }
        this.out.outdent();
        this.out.print("})");
    }

    private void write(double[] a) {
        if (a == null) {
            this.out.print("null");
            return;
        }
        this.write(a, a.length);
    }

    private void write(double[] a, int length) {
        if (a == null) {
            this.out.print("null");
            return;
        }
        this.out.println("new double[] {");
        this.out.indent();
        for (int i = 0; i < length; ++i) {
            if (i != 0) {
                this.out.print(", ");
            }
            this.out.print(a[i]);
        }
        this.out.outdent();
        this.out.println();
        this.out.print("}");
    }

    private void write(float[] a) {
        if (a == null) {
            this.out.print("null");
            return;
        }
        this.write(a, a.length);
    }

    private void write(float[] a, int length) {
        if (a == null) {
            this.out.print("null");
            return;
        }
        this.out.print("new float[] {");
        this.out.indent();
        for (int i = 0; i < length; ++i) {
            if (i % 10 == 0) {
                this.out.println();
            }
            if (i != 0) {
                this.out.print(", ");
            }
            this.out.print(a[i] + "f");
        }
        this.out.outdent();
        this.out.println();
        this.out.print("}");
    }

    private void write(int[] a) {
        if (a == null) {
            this.out.print("null");
            return;
        }
        this.write(a, a.length);
    }

    private void write(int[] a, int length) {
        if (a == null) {
            this.out.print("null");
            return;
        }
        this.out.print("new int[] {");
        this.out.indent();
        for (int i = 0; i < length; ++i) {
            if (i % 10 == 0) {
                this.out.println();
            }
            if (i != 0) {
                this.out.print(", ");
            }
            this.out.print(a[i]);
        }
        this.out.outdent();
        this.out.println();
        this.out.print("}");
    }

    private void write(byte[] a) {
        if (a == null) {
            this.out.print("null");
            return;
        }
        this.write(a, a.length);
    }

    private void write(byte[] a, int length) {
        if (a == null) {
            this.out.print("null");
            return;
        }
        this.out.print("new byte[] {");
        this.out.indent();
        for (int i = 0; i < length; ++i) {
            if (i % 10 == 0) {
                this.out.println();
            }
            if (i != 0) {
                this.out.print(", ");
            }
            this.out.print((int)a[i]);
        }
        this.out.outdent();
        this.out.println();
        this.out.print("}");
    }

    private void write(char[] a, int length) {
        if (a == null) {
            this.out.print("null");
            return;
        }
        this.out.println("new char[] {");
        this.out.indent();
        for (int i = 0; i < length; ++i) {
            if (i != 0) {
                this.out.print(", ");
            }
            this.out.print("'");
            switch (a[i]) {
                case '\b': {
                    this.out.print("\\b");
                    break;
                }
                case '\t': {
                    this.out.print("\\t");
                    break;
                }
                case '\n': {
                    this.out.print("\\n");
                    break;
                }
                case '\f': {
                    this.out.print("\\f");
                    break;
                }
                case '\r': {
                    this.out.print("\\r");
                    break;
                }
                case '\"': {
                    this.out.print("\\\"");
                    break;
                }
                case '\'': {
                    this.out.print("\\'");
                    break;
                }
                case '\\': {
                    this.out.print("\\\\");
                    break;
                }
                default: {
                    this.out.print(this.toUnicode(a[i]));
                }
            }
            this.out.print("'");
            if (i % 10 != 0) continue;
            this.out.println();
        }
        this.out.outdent();
        this.out.println();
        this.out.print("}");
    }

    private void write(Polygon p) {
        if (p == null) {
            this.out.print("null");
            return;
        }
        this.imports.add("java.awt.Polygon");
        this.out.println("new Polygon(");
        this.out.indent();
        this.write(p.xpoints, p.npoints);
        this.out.print(", ");
        this.write(p.ypoints, p.npoints);
        this.out.println(", " + p.npoints);
        this.out.outdent();
        this.out.print(")");
    }

    private void write(Image image) {
        if (image == null) {
            this.out.print("null");
            return;
        }
        PNGEncoder encoder = new PNGEncoder(image, true, 0, 9);
        if (this.isProperty(EMBED_IMAGES)) {
            this.imports.add("javax.imageio.ImageIO");
            this.imports.add("java.io.ByteArrayInputStream");
            this.out.println("ImageIO.read(new ByteArrayInputStream(");
            this.out.indent();
            this.write(encoder.pngEncode());
            this.out.outdent();
            this.out.print("))");
        } else {
            String imageName = this.className + imagePrefix + imageCounter++ + ".png";
            if (this.isProperty(COMPLETE_IMAGE_PATHS)) {
                imageName = this.classPath + imageName;
            }
            try {
                FileOutputStream fos = new FileOutputStream(imageName);
                BufferedOutputStream bos = new BufferedOutputStream(fos);
                bos.write(encoder.pngEncode());
                bos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.imports.add("javax.imageio.ImageIO");
            this.imports.add("java.io.File");
            this.out.print("ImageIO.read(new File(\"" + imageName + "\"))");
        }
    }

    private void write(Paint p) {
        if (p == null) {
            this.out.print("(Paint)null");
        } else if (p instanceof Color) {
            this.write((Color)p);
        } else if (p instanceof TexturePaint) {
            this.write((TexturePaint)p);
        } else if (p instanceof GradientPaint) {
            this.write((GradientPaint)p);
        } else {
            this.write(Color.red);
            this.out.print("/* not supported '");
            this.out.print(p.toString());
            this.out.print("' */");
        }
    }

    private void write(GradientPaint gp) {
        if (gp == null) {
            this.out.print("null");
            return;
        }
        this.imports.add("java.awt.GradientPaint");
        this.out.println("new GradientPaint(");
        this.out.indent();
        this.write(gp.getPoint1());
        this.out.print(", ");
        this.write(gp.getColor1());
        this.out.println(", ");
        this.write(gp.getPoint2());
        this.out.print(", ");
        this.write(gp.getColor2());
        this.out.println(", " + gp.isCyclic());
        this.out.outdent();
        this.out.print(")");
    }

    private void write(TexturePaint tp) {
        if (tp == null) {
            this.out.print("null");
            return;
        }
        this.imports.add("java.awt.TexturePaint");
        this.out.println("new TexturePaint(");
        this.out.indent();
        this.write(tp.getImage());
        this.out.print(", ");
        this.write(tp.getAnchorRect());
        this.out.outdent();
        this.out.print(")");
    }

    private void write(BasicStroke bs) {
        if (bs == null) {
            this.out.print("null");
            return;
        }
        this.imports.add("java.awt.BasicStroke");
        this.out.println("new BasicStroke(");
        this.out.indent();
        this.out.println(bs.getLineWidth() + "f, " + bs.getEndCap() + ", ");
        this.out.println(bs.getLineJoin() + ", " + bs.getMiterLimit() + "f, ");
        this.write(bs.getDashArray());
        this.out.println(", " + bs.getDashPhase() + "f");
        this.out.outdent();
        this.out.print(")");
    }

    private void write(AlphaComposite ac) {
        if (ac == null) {
            this.out.print("null");
            return;
        }
        this.imports.add("java.awt.AlphaComposite");
        this.out.print("AlphaComposite.getInstance(" + ac.getRule() + ", " + ac.getAlpha() + "f)");
    }

    private void write(Point2D p) {
        if (p == null) {
            this.out.print("null");
            return;
        }
        this.imports.add("java.awt.geom.Point2D");
        this.out.print("new Point2D.Double(" + p.getX() + ", " + p.getY() + ")");
    }

    private void write(Rectangle2D r) {
        if (r == null) {
            this.out.print("null");
            return;
        }
        this.imports.add("java.awt.geom.Rectangle2D");
        this.out.print("new Rectangle2D.Double(" + r.getX() + ", " + r.getY() + ", " + r.getWidth() + ", " + r.getHeight() + ")");
    }

    private void write(String s) {
        if (s == null) {
            this.out.print("(String)null");
            return;
        }
        StringBuffer sb = new StringBuffer();
        block4: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    sb.append("\\\\");
                    continue block4;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block4;
                }
                default: {
                    sb.append(this.toUnicode(c));
                }
            }
        }
        this.out.print("\"" + sb.toString() + "\"");
    }

    private void write(TagString s) {
        if (s == null) {
            this.out.print("null");
            return;
        }
        this.imports.add("org.freehep.graphics2d.TagString");
        this.out.print("new TagString(");
        this.write(s.toString());
        this.out.print(")");
    }

    private String vg() {
        Integer index = (Integer)this.vg.get((Object)this);
        return "vg[" + (index != null ? String.valueOf(index) : "null") + "]";
    }

    private String toUnicode(char c) {
        if (c <= '\u001f' || '\u007f' <= c) {
            String unicode = "0000" + Integer.toHexString(c);
            return "\\u" + unicode.substring(unicode.length() - 4);
        }
        return String.valueOf(c);
    }

    static {
        defaultProperties.setProperty(PACKAGE_NAME, "");
        defaultProperties.setProperty(COMPLETE_IMAGE_PATHS, false);
        defaultProperties.setProperty(EMBED_IMAGES, false);
        attributedStringCounter = 0;
        imageCounter = 0;
    }
}

