/*
 * Decompiled with CFR 0.152.
 */
package thredds.filesystem;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import thredds.filesystem.CacheDirectory;
import thredds.filesystem.CacheFile;
import thredds.filesystem.CacheManagerOld;
import thredds.filesystem.ControllerIF;
import thredds.filesystem.MCollection;
import thredds.filesystem.MFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Controller
implements ControllerIF {
    private CacheManagerOld cacheManager;
    private Map<String, MCollection> map = new HashMap<String, MCollection>();

    public Controller(CacheManagerOld cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public void addCollection(MCollection mc) {
        this.map.put(mc.getName(), mc);
    }

    @Override
    public Iterator<MFile> getInventory(String collectionName) {
        MCollection mc = this.map.get(collectionName);
        if (mc == null) {
            return null;
        }
        return this.getInventory(mc);
    }

    @Override
    public Iterator<MFile> getInventory(MCollection mc) {
        CacheDirectory cd = this.cacheManager.get(mc.getDirectoryName());
        if (cd == null) {
            return null;
        }
        return new FilteredIterator(mc, cd);
    }

    @Override
    public void sync(String collectionName) {
    }

    @Override
    public Object lockCollection(String collectionName) {
        return null;
    }

    @Override
    public void unlockCollection(Object lock) {
    }

    @Override
    public boolean renewLock(Object lock) {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MFileIterator
    implements Iterator<MFile> {
        MCollection mc;
        CacheDirectory cd;
        CacheFile[] files;
        int count = 0;

        MFileIterator(MCollection mc, CacheDirectory cd) {
            this.mc = mc;
            this.cd = cd;
            this.files = cd.getChildren();
        }

        @Override
        public boolean hasNext() {
            return this.count < this.files.length;
        }

        @Override
        public MFile next() {
            CacheFile cfile = this.files[this.count++];
            return new MFile(this.cd.getPath(), cfile);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FilteredIterator
    implements Iterator<MFile> {
        private Iterator<MFile> orgIter;
        private MCollection mc;
        private MFile next;

        FilteredIterator(MCollection mc, CacheDirectory cd) {
            this.orgIter = new MFileIterator(mc, cd);
            this.mc = mc;
        }

        @Override
        public boolean hasNext() {
            this.next = this.nextFilteredDataPoint();
            return this.next != null;
        }

        @Override
        public MFile next() {
            return this.next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private MFile nextFilteredDataPoint() {
            if (this.orgIter == null) {
                return null;
            }
            if (!this.orgIter.hasNext()) {
                return null;
            }
            MFile pdata = this.orgIter.next();
            while (!this.mc.accept(pdata)) {
                if (!this.orgIter.hasNext()) {
                    return null;
                }
                pdata = this.orgIter.next();
            }
            return pdata;
        }
    }
}

