/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactory;
import ucar.nc2.ft.grid.GridDatasetStandardFactory;
import ucar.nc2.ft.point.collection.CompositeDatasetFactory;
import ucar.nc2.ft.point.standard.PointDatasetStandardFactory;
import ucar.nc2.ft.radial.RadialDatasetStandardFactory;
import ucar.nc2.stream.CdmRemoteDatasetFactory;
import ucar.nc2.thredds.ThreddsDataFactory;
import ucar.nc2.util.CancelTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureDatasetFactoryManager {
    private static List<Factory> factoryList = new ArrayList<Factory>();
    private static boolean userMode = false;
    private static boolean debug = false;

    public static void registerFactory(FeatureType datatype, String className) throws ClassNotFoundException {
        Class<?> c = Class.forName(className);
        FeatureDatasetFactoryManager.registerFactory(datatype, c);
    }

    public static void registerFactory(FeatureType datatype, Class c) {
        Object instance;
        if (!FeatureDatasetFactory.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException("Class " + c.getName() + " must implement FeatureDatasetFactory");
        }
        try {
            instance = c.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("FeatureDatasetFactoryManager Class " + c.getName() + " cannot instantiate, probably need default Constructor");
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("FeatureDatasetFactoryManager Class " + c.getName() + " is not accessible");
        }
        if (userMode) {
            factoryList.add(0, new Factory(datatype, c, (FeatureDatasetFactory)instance));
        } else {
            factoryList.add(new Factory(datatype, c, (FeatureDatasetFactory)instance));
        }
    }

    public static void registerFactory(String className) throws ClassNotFoundException {
        Class<?> c = Class.forName(className);
        FeatureDatasetFactoryManager.registerFactory(c);
    }

    public static void registerFactory(Class c) {
        Object instance;
        if (!FeatureDatasetFactory.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException("Class " + c.getName() + " must implement FeatureDatasetFactory");
        }
        try {
            instance = c.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("FeatureDatasetFactoryManager Class " + c.getName() + " cannot instantiate, probably need default Constructor");
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("FeatureDatasetFactoryManager Class " + c.getName() + " is not accessible");
        }
        try {
            FeatureType[] result;
            Method m = c.getMethod("getFeatureType", new Class[0]);
            for (FeatureType ft : result = (FeatureType[])m.invoke(instance, new Object[0])) {
                if (userMode) {
                    factoryList.add(0, new Factory(ft, c, (FeatureDatasetFactory)instance));
                    continue;
                }
                factoryList.add(new Factory(ft, c, (FeatureDatasetFactory)instance));
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("FeatureDatasetFactoryManager Class " + c.getName() + " failed invoking getFeatureType()", ex);
        }
    }

    public static FeatureDataset open(FeatureType wantFeatureType, String location, CancelTask task, Formatter errlog) throws IOException {
        if (location.startsWith("thredds:")) {
            ThreddsDataFactory.Result result = new ThreddsDataFactory().openFeatureDataset(wantFeatureType, location, task);
            errlog.format("%s", result.errLog);
            if (!FeatureDatasetFactoryManager.featureTypeOk(wantFeatureType, result.featureType)) {
                errlog.format("wanted %s but dataset is of type %s%n", new Object[]{wantFeatureType, result.featureType});
                return null;
            }
            return result.featureDataset;
        }
        if (location.startsWith("cdmremote:")) {
            return CdmRemoteDatasetFactory.factory(wantFeatureType, location);
        }
        if (location.startsWith("collection:")) {
            return CompositeDatasetFactory.factory(location, wantFeatureType, location, errlog);
        }
        NetcdfDataset ncd = NetcdfDataset.acquireDataset(location, task);
        return FeatureDatasetFactoryManager.wrap(wantFeatureType, ncd, task, errlog);
    }

    public static FeatureDataset wrap(FeatureType wantFeatureType, NetcdfDataset ncd, CancelTask task, Formatter errlog) throws IOException {
        if (debug) {
            System.out.println("wrap " + ncd.getLocation() + " want = " + (Object)((Object)wantFeatureType));
        }
        if (wantFeatureType == null || wantFeatureType == FeatureType.NONE || wantFeatureType == FeatureType.ANY) {
            return FeatureDatasetFactoryManager.wrapUnknown(ncd, task, errlog);
        }
        Object analysis = null;
        FeatureDatasetFactory useFactory = null;
        for (Factory fac : factoryList) {
            if (!FeatureDatasetFactoryManager.featureTypeOk(wantFeatureType, fac.featureType)) continue;
            if (debug) {
                System.out.println(" wrap try factory " + fac.factory.getClass().getName());
            }
            if ((analysis = fac.factory.isMine(wantFeatureType, ncd, errlog)) == null) continue;
            useFactory = fac.factory;
            break;
        }
        if (null == useFactory) {
            return null;
        }
        return useFactory.open(wantFeatureType, ncd, analysis, task, errlog);
    }

    private static FeatureDataset wrapUnknown(NetcdfDataset ncd, CancelTask task, Formatter errlog) throws IOException {
        GridDataset gds;
        GridDataset gds2;
        FeatureType ft = FeatureDatasetFactoryManager.findFeatureType(ncd);
        if (ft != null) {
            return FeatureDatasetFactoryManager.wrap(ft, ncd, task, errlog);
        }
        if (FeatureDatasetFactoryManager.isGrid(ncd.getCoordinateSystems()) && (gds2 = new GridDataset(ncd)).getGrids().size() > 0) {
            if (debug) {
                System.out.println(" wrapUnknown found grids ");
            }
            return gds2;
        }
        Object analysis = null;
        FeatureDatasetFactory useFactory = null;
        for (Factory fac : factoryList) {
            if (!FeatureDatasetFactoryManager.featureTypeOk(null, fac.featureType)) continue;
            if (debug) {
                System.out.println(" wrapUnknown try factory " + fac.factory.getClass().getName());
            }
            if (null == (analysis = fac.factory.isMine(null, ncd, errlog))) continue;
            useFactory = fac.factory;
            break;
        }
        if (null == useFactory && (gds = new GridDataset(ncd)).getGrids().size() > 0) {
            return gds;
        }
        if (null == useFactory) {
            return null;
        }
        return useFactory.open(null, ncd, analysis, task, errlog);
    }

    private static boolean isGrid(List<CoordinateSystem> csysList) {
        CoordinateSystem use = null;
        for (CoordinateSystem csys : csysList) {
            if (use == null) {
                use = csys;
                continue;
            }
            if (csys.getCoordinateAxes().size() <= use.getCoordinateAxes().size()) continue;
            use = csys;
        }
        if (use == null) {
            return false;
        }
        CoordinateAxis lat = use.getLatAxis();
        CoordinateAxis lon = use.getLonAxis();
        if (lat != null && lat.getSize() <= 1L) {
            return false;
        }
        if (lon != null && lon.getSize() <= 1L) {
            return false;
        }
        return use.getRankDomain() > 2 && use.getRankDomain() <= use.getRankRange();
    }

    public static boolean featureTypeOk(FeatureType want, FeatureType facType) {
        if (want == null) {
            return true;
        }
        if (want == facType) {
            return true;
        }
        if (want == FeatureType.ANY_POINT) {
            return facType.isPointFeatureType();
        }
        if (facType == FeatureType.ANY_POINT) {
            return want.isPointFeatureType();
        }
        return false;
    }

    public static FeatureType findFeatureType(NetcdfDataset ncd) {
        String cf_datatype;
        String cdm_datatype = ncd.findAttValueIgnoreCase(null, "cdm_data_type", null);
        if (cdm_datatype == null) {
            cdm_datatype = ncd.findAttValueIgnoreCase(null, "cdm_datatype", null);
        }
        if (cdm_datatype == null) {
            cdm_datatype = ncd.findAttValueIgnoreCase(null, "thredds_data_type", null);
        }
        if (cdm_datatype != null) {
            for (FeatureType ft : FeatureType.values()) {
                if (!cdm_datatype.equalsIgnoreCase(ft.name())) continue;
                if (debug) {
                    System.out.println(" wrapUnknown found cdm_datatype " + cdm_datatype);
                }
                return ft;
            }
        }
        if ((cf_datatype = ncd.findAttValueIgnoreCase(null, "CF:featureType", null)) == null) {
            cf_datatype = ncd.findAttValueIgnoreCase(null, "CFfeatureType", null);
        }
        if (cf_datatype != null) {
            if (debug) {
                System.out.println(" wrapUnknown found cf_datatype " + cdm_datatype);
            }
            return FeatureType.getType(cdm_datatype);
        }
        return null;
    }

    public static void main(String[] args) throws IOException {
        String server = "http://motherlode:8080/";
        String dataset = "/thredds/dodsC/fmrc/NCEP/GFS/Global_0p5deg/runs/NCEP-GFS-Global_0p5deg_RUN_2009-05-13T12:00:00Z";
        Formatter errlog = new Formatter();
        FeatureDataset fd = FeatureDatasetFactoryManager.open(FeatureType.GRID, server + dataset, null, errlog);
        System.out.printf("%s%n", fd);
    }

    static {
        FeatureDatasetFactoryManager.registerFactory(FeatureType.ANY_POINT, PointDatasetStandardFactory.class);
        FeatureDatasetFactoryManager.registerFactory(FeatureType.GRID, GridDatasetStandardFactory.class);
        FeatureDatasetFactoryManager.registerFactory(FeatureType.RADIAL, RadialDatasetStandardFactory.class);
        userMode = true;
    }

    private static class Factory {
        FeatureType featureType;
        Class c;
        FeatureDatasetFactory factory;

        Factory(FeatureType featureType, Class c, FeatureDatasetFactory factory) {
            this.featureType = featureType;
            this.c = c;
            this.factory = factory;
        }
    }
}

