/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.Structure;

public class StructureDataIteratorLinked
implements StructureDataIterator {
    private static Logger log = LoggerFactory.getLogger(StructureDataIteratorLinked.class);
    private Structure s;
    private int firstRecord;
    private int nextRecno;
    private int numRecords;
    private String linkVarName;

    public StructureDataIteratorLinked(Structure s, int firstRecord, int numRecords, String linkVarName) throws IOException {
        this.s = s;
        this.firstRecord = firstRecord;
        this.nextRecno = firstRecord;
        this.numRecords = numRecords;
        this.linkVarName = linkVarName;
    }

    public StructureData next() throws IOException {
        StructureData sdata;
        int recno = this.nextRecno++;
        try {
            sdata = this.s.readStructure(recno);
        }
        catch (InvalidRangeException e) {
            log.error("StructureDataLinkedIterator.nextStructureData recno=" + recno, (Throwable)e);
            throw new IOException(e.getMessage());
        }
        if (this.numRecords > 0) {
            if (this.nextRecno >= this.firstRecord + this.numRecords) {
                this.nextRecno = -1;
            }
        } else {
            this.nextRecno = sdata.getScalarInt(this.linkVarName);
        }
        return sdata;
    }

    public boolean hasNext() throws IOException {
        return this.nextRecno >= 0;
    }

    public StructureDataIterator reset() {
        this.nextRecno = this.firstRecord;
        return this;
    }

    public void setBufferSize(int bytes) {
    }

    public void finish() {
    }
}

