/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.collection;

import java.io.IOException;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.FeatureCollection;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.point.PointCollectionImpl;
import ucar.nc2.ft.point.PointIteratorAbstract;
import ucar.nc2.ft.point.collection.CompositeDatasetFactory;
import ucar.nc2.ft.point.collection.TimedCollection;
import ucar.nc2.units.DateRange;
import ucar.unidata.geoloc.LatLonRect;

public class CompositePointCollection
extends PointCollectionImpl {
    private TimedCollection pointCollections;

    protected CompositePointCollection(String name, TimedCollection pointCollections) {
        super(name);
        this.pointCollections = pointCollections;
    }

    public PointFeatureIterator getPointFeatureIterator(int bufferSize) throws IOException {
        CompositePointFeatureIterator iter = new CompositePointFeatureIterator();
        if (this.boundingBox == null || this.dateRange == null || this.npts < 0) {
            iter.setCalculateBounds(this);
        }
        return iter;
    }

    public PointFeatureCollection subset(LatLonRect boundingBox, DateRange dateRange) throws IOException {
        if (dateRange == null && boundingBox == null) {
            return this;
        }
        if (dateRange == null) {
            return new PointCollectionImpl.PointFeatureCollectionSubset(this, boundingBox, dateRange);
        }
        CompositePointCollection dateSubset = new CompositePointCollection(this.name, this.pointCollections.subset(dateRange));
        return new PointCollectionImpl.PointFeatureCollectionSubset(dateSubset, boundingBox, dateRange);
    }

    private class CompositePointFeatureIterator
    extends PointIteratorAbstract {
        private boolean finished = false;
        private int bufferSize = -1;
        private Iterator<TimedCollection.Dataset> iter;
        private FeatureDatasetPoint currentDataset;
        private PointFeatureIterator pfIter = null;

        CompositePointFeatureIterator() {
            this.iter = CompositePointCollection.this.pointCollections.getIterator();
        }

        private PointFeatureIterator getNextIterator() throws IOException {
            if (!this.iter.hasNext()) {
                return null;
            }
            TimedCollection.Dataset td = this.iter.next();
            Formatter errlog = new Formatter();
            this.currentDataset = (FeatureDatasetPoint)FeatureDatasetFactoryManager.open(FeatureType.POINT, td.getLocation(), null, errlog);
            if (CompositeDatasetFactory.debug) {
                System.out.printf("CompositePointFeatureIterator open dataset %s%n", td.getLocation());
            }
            List<FeatureCollection> fcList = this.currentDataset.getPointFeatureCollectionList();
            PointFeatureCollection pc = (PointFeatureCollection)fcList.get(0);
            return pc.getPointFeatureIterator(this.bufferSize);
        }

        public boolean hasNext() throws IOException {
            if (this.pfIter == null) {
                this.pfIter = this.getNextIterator();
                if (this.pfIter == null) {
                    this.finish();
                    return false;
                }
            }
            if (!this.pfIter.hasNext()) {
                this.pfIter.finish();
                this.currentDataset.close();
                this.pfIter = this.getNextIterator();
                return this.hasNext();
            }
            return true;
        }

        public PointFeature next() throws IOException {
            return this.pfIter.next();
        }

        public void finish() {
            if (this.finished) {
                return;
            }
            if (this.pfIter != null) {
                this.pfIter.finish();
            }
            this.finishCalcBounds();
            if (this.currentDataset != null) {
                try {
                    this.currentDataset.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.finished = true;
        }

        public void setBufferSize(int bytes) {
            this.bufferSize = bytes;
        }
    }
}

