/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.collection;

import java.io.IOException;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.FeatureCollection;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureCollectionIterator;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.StationTimeSeriesFeature;
import ucar.nc2.ft.StationTimeSeriesFeatureCollection;
import ucar.nc2.ft.point.PointIteratorAbstract;
import ucar.nc2.ft.point.StationFeatureImpl;
import ucar.nc2.ft.point.StationHelper;
import ucar.nc2.ft.point.StationTimeSeriesCollectionImpl;
import ucar.nc2.ft.point.collection.CompositeDatasetFactory;
import ucar.nc2.ft.point.collection.CompositePointCollection;
import ucar.nc2.ft.point.collection.TimedCollection;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeStationCollection
extends StationTimeSeriesCollectionImpl {
    private TimedCollection stnCollections;

    protected CompositeStationCollection(String name, TimedCollection stnCollections) throws IOException {
        super(name);
        this.stnCollections = stnCollections;
        TimedCollection.Dataset td = stnCollections.getPrototype();
        Formatter errlog = new Formatter();
        FeatureDatasetPoint openDataset = (FeatureDatasetPoint)FeatureDatasetFactoryManager.open(FeatureType.STATION, td.getLocation(), null, errlog);
        List<FeatureCollection> fcList = openDataset.getPointFeatureCollectionList();
        StationTimeSeriesCollectionImpl openCollection = (StationTimeSeriesCollectionImpl)fcList.get(0);
        this.stationHelper = new StationHelper();
        for (Station s : openCollection.getStations()) {
            this.stationHelper.addStation(new CompositeStationFeature(s, null, stnCollections));
        }
        openDataset.close();
    }

    @Override
    public StationTimeSeriesFeatureCollection subset(List<Station> stations) throws IOException {
        if (stations == null) {
            return this;
        }
        StationHelper sh = new StationHelper();
        sh.setStations(stations);
        CompositeStationCollection subset = new CompositeStationCollection(this.getName(), this.stnCollections);
        subset.stationHelper = sh;
        return subset;
    }

    @Override
    public StationTimeSeriesFeatureCollection subset(LatLonRect boundingBox) throws IOException {
        if (boundingBox == null) {
            return this;
        }
        StationHelper sh = new StationHelper();
        sh.setStations(this.stationHelper.getStations(boundingBox));
        CompositeStationCollection subset = new CompositeStationCollection(this.getName(), this.stnCollections);
        subset.stationHelper = sh;
        return subset;
    }

    @Override
    public StationTimeSeriesFeature getStationFeature(Station s) throws IOException {
        return new CompositeStationFeature(s, null, this.stnCollections);
    }

    @Override
    public PointFeatureCollection flatten(LatLonRect boundingBox, DateRange dateRange) throws IOException {
        CompositePointCollection flat = new CompositePointCollection(this.getName(), this.stnCollections);
        return flat.subset(boundingBox, dateRange);
    }

    @Override
    public PointFeatureCollectionIterator getPointFeatureCollectionIterator(int bufferSize) throws IOException {
        return new PointFeatureCollectionIterator(){
            Iterator<Station> stationIter;
            {
                this.stationIter = CompositeStationCollection.this.stationHelper.getStations().iterator();
            }

            public boolean hasNext() throws IOException {
                return this.stationIter.hasNext();
            }

            public PointFeatureCollection next() throws IOException {
                return (PointFeatureCollection)((Object)this.stationIter.next());
            }

            public void setBufferSize(int bytes) {
            }

            public void finish() {
            }
        };
    }

    private class CompositeStationFeature
    extends StationFeatureImpl {
        private TimedCollection collForFeature;

        CompositeStationFeature(Station s, DateUnit timeUnit, TimedCollection collForFeature) {
            super(s, timeUnit, -1);
            this.setDateRange(collForFeature.getDateRange());
            this.collForFeature = collForFeature;
        }

        public PointFeatureIterator getPointFeatureIterator(int bufferSize) throws IOException {
            CompositeStationFeatureIterator iter = new CompositeStationFeatureIterator();
            if (this.boundingBox == null || this.dateRange == null || this.npts < 0) {
                iter.setCalculateBounds(this);
            }
            return iter;
        }

        public StationTimeSeriesFeature subset(DateRange dateRange) throws IOException {
            if (dateRange == null) {
                return this;
            }
            CompositeStationFeature stnSubset = new CompositeStationFeature(this.s, this.timeUnit, this.collForFeature.subset(dateRange));
            return stnSubset.subset(dateRange);
        }

        public PointFeatureCollection subset(LatLonRect boundingBox, DateRange dateRange) throws IOException {
            if (boundingBox != null) {
                if (!boundingBox.contains(this.s.getLatLon())) {
                    return null;
                }
                if (dateRange == null) {
                    return this;
                }
            }
            return this.subset(dateRange);
        }

        private class CompositeStationFeatureIterator
        extends PointIteratorAbstract {
            private int bufferSize = -1;
            private Iterator<TimedCollection.Dataset> iter;
            private FeatureDatasetPoint currentDataset;
            private PointFeatureIterator pfIter = null;
            private boolean finished = false;

            CompositeStationFeatureIterator() {
                this.iter = CompositeStationFeature.this.collForFeature.getIterator();
            }

            private PointFeatureIterator getNextIterator() throws IOException {
                if (!this.iter.hasNext()) {
                    return null;
                }
                TimedCollection.Dataset td = this.iter.next();
                Formatter errlog = new Formatter();
                this.currentDataset = (FeatureDatasetPoint)FeatureDatasetFactoryManager.open(FeatureType.STATION, td.getLocation(), null, errlog);
                List<FeatureCollection> fcList = this.currentDataset.getPointFeatureCollectionList();
                StationTimeSeriesFeatureCollection stnCollection = (StationTimeSeriesFeatureCollection)fcList.get(0);
                Station s = stnCollection.getStation(CompositeStationFeature.this.getName());
                if (s == null) {
                    System.out.printf("CompositeStationFeatureIterator dataset%s missing station %s%n", td.getLocation(), CompositeStationFeature.this.getName());
                    return this.getNextIterator();
                }
                StationTimeSeriesFeature stnFeature = stnCollection.getStationFeature(s);
                if (CompositeDatasetFactory.debug) {
                    System.out.printf("CompositeStationFeatureIterator open dataset%s%n", td.getLocation());
                }
                return stnFeature.getPointFeatureIterator(this.bufferSize);
            }

            public boolean hasNext() throws IOException {
                if (this.pfIter == null) {
                    this.pfIter = this.getNextIterator();
                    if (this.pfIter == null) {
                        this.finish();
                        return false;
                    }
                }
                if (!this.pfIter.hasNext()) {
                    this.pfIter.finish();
                    this.currentDataset.close();
                    this.pfIter = this.getNextIterator();
                    return this.hasNext();
                }
                return true;
            }

            public PointFeature next() throws IOException {
                CompositeStationFeature.this.npts++;
                return this.pfIter.next();
            }

            public void finish() {
                if (this.finished) {
                    return;
                }
                if (this.pfIter != null) {
                    this.pfIter.finish();
                }
                if (this.currentDataset != null) {
                    try {
                        this.currentDataset.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.finishCalcBounds();
                this.finished = true;
            }

            public void setBufferSize(int bytes) {
                this.bufferSize = bytes;
            }
        }
    }
}

