/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.remote;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import ucar.ma2.ArrayStructureBB;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.point.PointDatasetImpl;
import ucar.nc2.ft.point.PointFeatureImpl;
import ucar.nc2.ft.point.remote.FeatureMaker;
import ucar.nc2.ft.point.remote.PointStreamProto;
import ucar.nc2.ft.point.remote.RemotePointCollection;
import ucar.nc2.ft.point.remote.RemoteStationCollection;
import ucar.nc2.stream.NcStream;
import ucar.nc2.stream.NcStreamRemote;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.EarthLocation;
import ucar.unidata.geoloc.EarthLocationImpl;
import ucar.unidata.geoloc.LatLonRect;

public class PointDatasetRemote
extends PointDatasetImpl {
    public PointDatasetRemote(FeatureType wantFeatureType, NetcdfDataset ncd, NcStreamRemote ncremote) throws IOException {
        super(ncd, wantFeatureType);
        this.collectionList = new ArrayList(1);
        switch (wantFeatureType) {
            case POINT: {
                this.collectionList.add(new RemotePointCollection(ncd.getLocation(), ncremote, null));
                break;
            }
            case STATION: {
                this.collectionList.add(new RemoteStationCollection(ncd.getLocation(), ncremote));
                break;
            }
            default: {
                throw new UnsupportedOperationException("No implemenattion for " + (Object)((Object)wantFeatureType));
            }
        }
    }

    static String makeQuery(String station, LatLonRect boundingBox, DateRange dateRange) {
        StringBuilder query = new StringBuilder();
        boolean needamp = false;
        if (station != null) {
            query.append(station);
            needamp = true;
        }
        if (boundingBox != null) {
            if (needamp) {
                query.append("&");
            }
            query.append("east=");
            query.append(boundingBox.getLonMin());
            query.append("&west=");
            query.append(boundingBox.getLonMax());
            query.append("&south=");
            query.append(boundingBox.getLatMin());
            query.append("&north=");
            query.append(boundingBox.getLatMax());
            needamp = true;
        }
        if (dateRange != null) {
            DateFormatter df = new DateFormatter();
            if (needamp) {
                query.append("&");
            }
            query.append("&start=");
            query.append(df.toDateTimeStringISO(dateRange.getStart().getDate()));
            query.append("&end=");
            query.append(df.toDateTimeStringISO(dateRange.getEnd().getDate()));
        }
        if (!needamp) {
            query.append("all");
        }
        return query.toString();
    }

    static class ProtobufPointFeatureMaker
    implements FeatureMaker {
        private DateUnit dateUnit;
        private StructureMembers sm;

        ProtobufPointFeatureMaker(PointStreamProto.PointFeatureCollection pfc) throws IOException {
            try {
                this.dateUnit = new DateUnit(pfc.getTimeUnit());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.dateUnit = DateUnit.getUnixDateUnit();
            }
            int offset = 0;
            this.sm = new StructureMembers(pfc.getName());
            for (PointStreamProto.Member m : pfc.getMembersList()) {
                StructureMembers.Member member = this.sm.addMember(m.getName(), m.getDesc(), m.getUnits(), NcStream.decodeDataType(m.getDataType()), NcStream.decodeSection(m.getSection()).getShape());
                member.setDataParam(offset);
                offset += member.getSizeBytes();
            }
            this.sm.setStructureSize(offset);
        }

        public PointFeature make(byte[] rawBytes) throws InvalidProtocolBufferException {
            PointStreamProto.PointFeature pfp = PointStreamProto.PointFeature.parseFrom(rawBytes);
            PointStreamProto.Location locp = pfp.getLoc();
            EarthLocationImpl location = new EarthLocationImpl(locp.getLat(), locp.getLon(), locp.getAlt());
            return new MyPointFeature(location, locp.getTime(), locp.getNomTime(), this.dateUnit, pfp);
        }

        private class MyPointFeature
        extends PointFeatureImpl {
            PointStreamProto.PointFeature pfp;

            MyPointFeature(EarthLocation location, double obsTime, double nomTime, DateUnit timeUnit, PointStreamProto.PointFeature pfp) {
                super(location, obsTime, nomTime, timeUnit);
                this.pfp = pfp;
            }

            public StructureData getData() throws IOException {
                ByteBuffer bb = ByteBuffer.wrap(this.pfp.getData().toByteArray());
                ArrayStructureBB asbb = new ArrayStructureBB(ProtobufPointFeatureMaker.this.sm, new int[]{1}, bb, 0);
                for (String s : this.pfp.getSdataList()) {
                    asbb.addObjectToHeap(s);
                }
                return asbb.getStructureData(0);
            }

            public String toString() {
                return this.location + " obs=" + this.obsTime + " nom=" + this.nomTime;
            }
        }
    }
}

